/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.system;

import net.algart.executors.api.Executor;
import net.algart.executors.api.data.SScalar;

public final class CreateLogLevel
extends Executor {
    public static final String OUTPUT_LOGGABLE = "loggable";
    private String logLevel = "DEBUG";
    private String propertyNameToOverwriteLogLevel = "";

    public CreateLogLevel() {
        this.addInputScalar(DEFAULT_INPUT_PORT);
        this.addOutputScalar(DEFAULT_OUTPUT_PORT);
        this.addOutputScalar(OUTPUT_LOGGABLE);
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public CreateLogLevel setLogLevel(String logLevel) {
        this.logLevel = CreateLogLevel.nonNull(logLevel);
        return this;
    }

    public CreateLogLevel setLogLevel(System.Logger.Level logLevel) {
        this.logLevel = CreateLogLevel.nonNull(logLevel).getName();
        return this;
    }

    public String getPropertyNameToOverwriteLogLevel() {
        return this.propertyNameToOverwriteLogLevel;
    }

    public CreateLogLevel setPropertyNameToOverwriteLogLevel(String propertyNameToOverwriteLogLevel) {
        this.propertyNameToOverwriteLogLevel = CreateLogLevel.nonNull(propertyNameToOverwriteLogLevel);
        return this;
    }

    @Override
    public void process() {
        String propertyName;
        SScalar input = this.getInputScalar(this.defaultInputPortName(), true);
        System.Logger.Level level = CreateLogLevel.parseOrNull(input.getValue());
        if (level == null && !(propertyName = this.propertyNameToOverwriteLogLevel.trim()).isEmpty()) {
            try {
                level = CreateLogLevel.parseOrNull(System.getProperty(propertyName));
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (level == null) {
                try {
                    level = CreateLogLevel.parseOrNull(System.getenv(propertyName));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (level == null) {
            level = CreateLogLevel.parseOrNull(this.logLevel);
        }
        this.getScalar().setTo(level.getName());
        this.getScalar(OUTPUT_LOGGABLE).setTo(LOG.isLoggable(level));
    }

    private static System.Logger.Level parseOrNull(String s) {
        if (s == null) {
            return null;
        }
        return CreateLogLevel.ofLogLevel(s);
    }
}

