/*
 * Decompiled with CFR 0.152.
 */
package net.algart.graalvm;

import java.lang.ref.Cleaner;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.algart.graalvm.GraalSourceContainer;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;

public class GraalPerformer
implements AutoCloseable {
    private static final System.Logger LOG = System.getLogger(GraalPerformer.class.getName());
    private static final Cleaner CLEANER = Cleaner.create();
    private final ExpensiveCleanableState state;
    private final Cleaner.Cleanable cleanable;
    Path workingDirectory = null;
    boolean jsEsmEvalReturnsExports = false;

    private GraalPerformer(Context context, String autoBindingLanguage) {
        this.state = new ExpensiveCleanableState(context, autoBindingLanguage);
        this.cleanable = CLEANER.register(this, this.state);
    }

    public static GraalPerformer newPerformer(Context context) {
        return GraalPerformer.newPerformer(context, null);
    }

    public static GraalPerformer newPerformer(Context context, String autoBindingLanguage) {
        return new GraalPerformer(context, autoBindingLanguage);
    }

    public Context context() {
        this.checkClosed();
        return this.state.context;
    }

    public Path getWorkingDirectory() {
        return this.workingDirectory;
    }

    public boolean isJsEsmEvalReturnsExports() {
        return this.jsEsmEvalReturnsExports;
    }

    public String autoBindingLanguage() {
        return this.state.autoBindingLanguage;
    }

    public boolean hasAutoBindings() {
        return this.state.autoBindings != null;
    }

    public Value autoBindings() {
        this.checkClosed();
        return this.state.autoBindings;
    }

    public Value bindingsJS() {
        return this.bindings("js");
    }

    public Value bindings(String language) {
        Objects.requireNonNull(language, "Null language for binding");
        this.checkClosed();
        return language.equals(this.state.autoBindingLanguage) ? this.autoBindings() : this.state.context.getBindings(language);
    }

    public Map<String, Object> properties() {
        this.checkClosed();
        return Collections.unmodifiableMap(this.state.properties);
    }

    public <T> T getProperty(String key, Class<T> propertyClass) {
        Objects.requireNonNull(key, "Null key");
        Objects.requireNonNull(propertyClass, "Null propertyClass");
        this.checkClosed();
        Object object = this.state.properties.get(key);
        if (object != null && !propertyClass.isInstance(object)) {
            throw new IllegalStateException("Performer property \"" + key + "\" has invalid class " + object.getClass().getName() + ": " + String.valueOf(propertyClass) + " is expected");
        }
        return propertyClass.cast(object);
    }

    public Object putProperty(String key, Object value) {
        Objects.requireNonNull(key, "Null key");
        Objects.requireNonNull(value, "Null value");
        this.checkClosed();
        return this.state.properties.put(key, value);
    }

    public Object putPropertyIfAbsent(String key, Object value) {
        Objects.requireNonNull(key, "Null key");
        Objects.requireNonNull(value, "Null value");
        this.checkClosed();
        return this.state.properties.putIfAbsent(key, value);
    }

    public Value performJS(CharSequence source) {
        return this.perform("js", source);
    }

    public Value perform(String language, CharSequence source) {
        this.checkClosed();
        return this.state.context.eval(language, source);
    }

    public Value perform(Source source) {
        this.checkClosed();
        return this.state.context.eval(source);
    }

    public Value perform(GraalSourceContainer sourceContainer) {
        return this.perform(sourceContainer.source());
    }

    public boolean isClosed() {
        return this.state.isReallyClosed();
    }

    @Override
    public void close() {
        this.state.normallyClosed = true;
        this.cleanable.clean();
    }

    public String toString() {
        return this.state.toString();
    }

    void setCustomizerInfo(String customizerToString) {
        this.state.customizerToString = customizerToString;
    }

    void setContextIdInfo(String contextId) {
        this.state.contextId = contextId;
    }

    private void checkClosed() {
        if (this.state.normallyClosed || this.state.isReallyClosed()) {
            throw new IllegalStateException("Cannot use " + String.valueOf(this));
        }
    }

    private static class ExpensiveCleanableState
    implements Runnable {
        private final String contextString;
        private final String autoBindingLanguage;
        private volatile boolean normallyClosed = false;
        private volatile Context context;
        private Value autoBindings;
        private Map<String, Object> properties;
        private String contextId = null;
        private String customizerToString = null;

        ExpensiveCleanableState(Context context, String autoBindingLanguage) {
            this.context = Objects.requireNonNull(context, "Null context");
            this.contextString = context.toString();
            this.autoBindingLanguage = autoBindingLanguage;
            this.autoBindings = autoBindingLanguage == null ? null : context.getBindings(autoBindingLanguage);
            this.properties = new LinkedHashMap<String, Object>();
        }

        @Override
        public void run() {
            if (this.isReallyClosed()) {
                return;
            }
            if (!this.normallyClosed) {
                LOG.log(System.Logger.Level.WARNING, () -> "CLEANING " + this.toBriefString());
            }
            this.context.close();
            this.context = null;
            this.autoBindings = null;
            this.properties = null;
        }

        public String toString() {
            return (!this.isReallyClosed() ? "" : (this.normallyClosed ? "closed " : "abnormally CLEANED ")) + this.toBriefString();
        }

        private String toBriefString() {
            return "Graal performer of " + this.contextString + (String)(this.customizerToString == null ? "" : " (customization: " + this.customizerToString) + ")" + (String)(this.contextId == null ? "" : " in context #" + this.contextId);
        }

        private boolean isReallyClosed() {
            return this.context == null;
        }
    }
}

