/*
 * Decompiled with CFR 0.152.
 */
package net.algart.jep;

import java.util.Objects;
import java.util.function.Supplier;
import jep.JepConfig;
import net.algart.jep.JepPerformer;
import net.algart.jep.additions.JepSingleThreadInterpreter;
import net.algart.jep.additions.JepType;

public final class JepPerformerContainer
implements AutoCloseable {
    private Supplier<JepConfig> configurationSupplier = null;
    private final JepType type;
    private volatile JepPerformer performer = null;
    private final Object lock = new Object();

    private JepPerformerContainer(JepType type) {
        this.type = Objects.requireNonNull(type, "Null JEP interpretation type");
    }

    public static JepPerformerContainer newContainer(JepType type) {
        return new JepPerformerContainer(type);
    }

    public JepType type() {
        return this.type;
    }

    public Supplier<JepConfig> getConfigurationSupplier() {
        return this.configurationSupplier;
    }

    public JepPerformerContainer setConfigurationSupplier(Supplier<JepConfig> configurationSupplier) {
        this.configurationSupplier = configurationSupplier;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JepPerformer performer() {
        JepPerformer performer;
        boolean created = false;
        Object object = this.lock;
        synchronized (object) {
            performer = this.performer;
            if (performer == null) {
                this.performer = performer = JepPerformer.newPerformer(JepSingleThreadInterpreter.newInstance(this.type, this.configurationSupplier));
                created = true;
            }
        }
        if (created) {
            JepPerformer.LOG.log(System.Logger.Level.DEBUG, "Created new " + String.valueOf(performer));
        }
        return performer;
    }

    public boolean isEmpty() {
        return this.performer == null;
    }

    public String toString() {
        JepPerformer performer = this.performer;
        return "JEP performer container (" + String.valueOf((Object)this.type) + "), " + (performer == null ? "EMPTY" : performer.toString()) + ", identity 0x" + System.identityHashCode(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        String message = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.performer != null) {
                message = this.performer.toString();
                this.performer.close();
                this.performer = null;
            }
        }
        if (message != null) {
            JepPerformer.LOG.log(System.Logger.Level.DEBUG, "Closed " + message);
        }
    }
}

