/*
 * Decompiled with CFR 0.152.
 */
package net.algart.jep.additions;

import java.util.Map;
import java.util.Objects;
import jep.JepException;
import jep.python.PyCallable;
import jep.python.PyObject;
import net.algart.jep.additions.AtomicPyObject;
import net.algart.jep.additions.JepSingleThreadInterpreter;

public class AtomicPyCallable
extends AtomicPyObject {
    private final PyCallable pyCallable;

    AtomicPyCallable(JepSingleThreadInterpreter interpreter, PyCallable pyCallable) {
        super(interpreter, (PyObject)Objects.requireNonNull(pyCallable, "Null pyCallable"));
        this.pyCallable = pyCallable;
    }

    public AtomicPyObject callRawAtomic(Object ... args) throws JepException {
        return this.i.wrapObject((PyObject)this.callRaw(args));
    }

    public AtomicPyObject callAsAtomic(Object ... args) throws JepException {
        return this.i.wrapObject(this.callAs(PyObject.class, args));
    }

    public Object callRaw(Object ... args) throws JepException {
        return this.i.executeInSingleThread(() -> this.pyCallable.call(args));
    }

    public <T> T callAs(Class<T> expectedType, Object ... args) throws JepException {
        Objects.requireNonNull(expectedType, "Null expectedType");
        return (T)this.i.executeInSingleThread(() -> this.pyCallable.callAs(expectedType, args));
    }

    public <T> T callAs(Class<T> expectedType, Map<String, Object> kwargs) throws JepException {
        Objects.requireNonNull(expectedType, "Null expectedType");
        Objects.requireNonNull(kwargs, "Null kwargs");
        return (T)this.i.executeInSingleThread(() -> this.pyCallable.callAs(expectedType, kwargs));
    }

    public <T> T callAs(Class<T> expectedType, Object[] args, Map<String, Object> kwargs) throws JepException {
        Objects.requireNonNull(expectedType, "Null expectedType");
        Objects.requireNonNull(kwargs, "Null kwargs");
        return (T)this.i.executeInSingleThread(() -> this.pyCallable.callAs(expectedType, args, kwargs));
    }
}

