/*
 * Decompiled with CFR 0.152.
 */
package net.algart.jep.additions;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import jep.MainInterpreter;
import jep.PyConfig;

public class GlobalPythonConfiguration
extends PyConfig {
    public static final String JEP_CONFIG_PROPERTY_PREFIX = "jep.config.";
    public static final GlobalPythonConfiguration INSTANCE = new GlobalPythonConfiguration();
    private boolean used = false;
    private final Object lock = new Object();

    private GlobalPythonConfiguration() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNoSiteFlag() {
        Object object = this.lock;
        synchronized (object) {
            return this.noSiteFlag;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlobalPythonConfiguration setNoSiteFlag(int noSiteFlag) {
        Object object = this.lock;
        synchronized (object) {
            super.setNoSiteFlag(noSiteFlag);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNoUserSiteDirectory() {
        Object object = this.lock;
        synchronized (object) {
            return this.noUserSiteDirectory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlobalPythonConfiguration setNoUserSiteDirectory(int noUserSiteDirectory) {
        Object object = this.lock;
        synchronized (object) {
            super.setNoUserSiteDirectory(noUserSiteDirectory);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIgnoreEnvironmentFlag() {
        Object object = this.lock;
        synchronized (object) {
            return this.ignoreEnvironmentFlag;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlobalPythonConfiguration setIgnoreEnvironmentFlag(int ignoreEnvironmentFlag) {
        Object object = this.lock;
        synchronized (object) {
            super.setIgnoreEnvironmentFlag(ignoreEnvironmentFlag);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getVerboseFlag() {
        Object object = this.lock;
        synchronized (object) {
            return this.verboseFlag;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlobalPythonConfiguration setVerboseFlag(int verboseFlag) {
        Object object = this.lock;
        synchronized (object) {
            super.setVerboseFlag(verboseFlag);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOptimizeFlag() {
        Object object = this.lock;
        synchronized (object) {
            return this.optimizeFlag;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlobalPythonConfiguration setOptimizeFlag(int optimizeFlag) {
        Object object = this.lock;
        synchronized (object) {
            super.setOptimizeFlag(optimizeFlag);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDontWriteBytecodeFlag() {
        Object object = this.lock;
        synchronized (object) {
            return this.dontWriteBytecodeFlag;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlobalPythonConfiguration setDontWriteBytecodeFlag(int dontWriteBytecodeFlag) {
        Object object = this.lock;
        synchronized (object) {
            super.setDontWriteBytecodeFlag(dontWriteBytecodeFlag);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHashRandomizationFlag() {
        Object object = this.lock;
        synchronized (object) {
            return this.hashRandomizationFlag;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlobalPythonConfiguration setHashRandomizationFlag(int hashRandomizationFlag) {
        Object object = this.lock;
        synchronized (object) {
            super.setHashRandomizationFlag(hashRandomizationFlag);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPythonHome() {
        Object object = this.lock;
        synchronized (object) {
            return this.pythonHome;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlobalPythonConfiguration setPythonHome(String pythonHome) {
        Object object = this.lock;
        synchronized (object) {
            super.setPythonHome(pythonHome);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PythonHomeInformation pythonHomeInformation() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isUsed()) {
                boolean ignoreEnvironment;
                String pythonHome = this.getPythonHome();
                boolean bl = ignoreEnvironment = this.getIgnoreEnvironmentFlag() > 0;
                if (pythonHome != null || ignoreEnvironment) {
                    return new PythonHomeInformation(pythonHome, true, ignoreEnvironment);
                }
            }
            return new PythonHomeInformation(GlobalPythonConfiguration.getEnv("PYTHONHOME"), false, false);
        }
    }

    public String actualPythonHome() {
        return this.pythonHomeInformation().pythonHome();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlobalPythonConfiguration loadFromSystemProperties() {
        Object object = this.lock;
        synchronized (object) {
            this.setNoSiteFlag(GlobalPythonConfiguration.getPrefixedInt("noSiteFlag", this.noSiteFlag));
            this.setNoUserSiteDirectory(GlobalPythonConfiguration.getPrefixedInt("noUserSiteDirectory", this.noUserSiteDirectory));
            this.setIgnoreEnvironmentFlag(GlobalPythonConfiguration.getPrefixedInt("ignoreEnvironmentFlag", this.ignoreEnvironmentFlag));
            this.setVerboseFlag(GlobalPythonConfiguration.getPrefixedInt("verboseFlag", this.verboseFlag));
            this.setOptimizeFlag(GlobalPythonConfiguration.getPrefixedInt("optimizeFlag", this.optimizeFlag));
            this.setDontWriteBytecodeFlag(GlobalPythonConfiguration.getPrefixedInt("dontWriteBytecodeFlag", this.dontWriteBytecodeFlag));
            this.setHashRandomizationFlag(GlobalPythonConfiguration.getPrefixedInt("hashRandomizationFlag", this.hashRandomizationFlag));
            this.setPythonHome(GlobalPythonConfiguration.getNonEmptyString("python.home", this.pythonHome));
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlobalPythonConfiguration useForJep() {
        Object object = this.lock;
        synchronized (object) {
            MainInterpreter.setInitParams((PyConfig)this);
            this.used = true;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUsed() {
        Object object = this.lock;
        synchronized (object) {
            return this.used;
        }
    }

    private static int getPrefixedInt(String propertyName, int defaultValue) {
        try {
            String property = System.getProperty(JEP_CONFIG_PROPERTY_PREFIX + propertyName);
            return property == null ? defaultValue : Integer.parseInt(property);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    private static String getNonEmptyString(String propertyName, String defaultValue) {
        try {
            String property = System.getProperty(propertyName);
            return property == null || property.isEmpty() ? defaultValue : property;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private static String getEnv(String envName) {
        try {
            return System.getenv(envName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public record PythonHomeInformation(String pythonHome, boolean used, boolean systemEnvironmentDisabled) {
        public boolean unknown() {
            return this.pythonHome == null;
        }

        public boolean exists() {
            if (this.pythonHome == null) {
                return false;
            }
            try {
                return Files.exists(Paths.get(this.pythonHome, new String[0]), new LinkOption[0]);
            }
            catch (Exception ignoredExceptionWhileParsingPath) {
                return false;
            }
        }

        public boolean systemEnvironmentUsed() {
            if (!this.used) {
                return true;
            }
            if (this.pythonHome == null) {
                assert (this.systemEnvironmentDisabled);
                return true;
            }
            return false;
        }
    }
}

