/*
 * Decompiled with CFR 0.152.
 */
package net.algart.jep.additions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import jep.Interpreter;
import jep.JepConfig;
import jep.JepException;

public class JepExtendedConfiguration
extends JepConfig {
    private List<String> startupCode = Collections.emptyList();
    private Verifier verifier = null;
    private Object verificationStatus = null;

    public List<String> getStartupCode() {
        return Collections.unmodifiableList(this.startupCode);
    }

    public JepExtendedConfiguration setStartupCode(List<String> startupCode) {
        Objects.requireNonNull(startupCode, "Null startupCode");
        ArrayList<String> clone = new ArrayList<String>(startupCode);
        clone.forEach(s -> Objects.requireNonNull(s, "Null element of startupCode"));
        this.startupCode = clone;
        return this;
    }

    public boolean hasVerifier() {
        return this.verifier != null;
    }

    public Verifier getVerifier() {
        return this.verifier;
    }

    public JepExtendedConfiguration setVerifier(Verifier verifier) {
        this.verifier = verifier;
        return this;
    }

    public Object getVerificationStatus() {
        return this.verificationStatus;
    }

    public JepExtendedConfiguration setVerificationStatus(Object verificationStatus) {
        this.verificationStatus = verificationStatus;
        return this;
    }

    public String toString() {
        return "JepExtendedConfiguration with verificationStatus=" + String.valueOf(this.verificationStatus) + " " + super.toString();
    }

    @FunctionalInterface
    public static interface Verifier {
        public Object verify(Interpreter var1, JepExtendedConfiguration var2) throws JepException;
    }
}

