/*
 * Decompiled with CFR 0.152.
 */
package net.algart.jep.additions;

import java.lang.ref.Cleaner;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import jep.Interpreter;
import jep.JepConfig;
import jep.JepException;
import jep.python.PyCallable;
import jep.python.PyObject;
import net.algart.jep.additions.AtomicPyCallable;
import net.algart.jep.additions.AtomicPyObject;
import net.algart.jep.additions.ConfiguredInterpreter;
import net.algart.jep.additions.JepType;

public class JepSingleThreadInterpreter
implements Interpreter {
    static final System.Logger LOG = System.getLogger(JepSingleThreadInterpreter.class.getName());
    private static final Cleaner CLEANER = Cleaner.create();
    private final JepType type;
    private final ExpensiveState state;
    private final Cleaner.Cleanable cleanable;
    private static final Object GLOBAL_LOCK = new Object();

    private JepSingleThreadInterpreter(JepType type, Supplier<JepConfig> configurationSupplier) {
        Objects.requireNonNull(type, "Null JEP interpretation type");
        this.type = type;
        ExpensiveCleanableState cleanableState = new ExpensiveCleanableState(type, configurationSupplier);
        this.state = cleanableState;
        this.cleanable = CLEANER.register(this, cleanableState);
        this.checkStateAlive();
    }

    public static Object getGlobalLock() {
        return GLOBAL_LOCK;
    }

    public static JepSingleThreadInterpreter newInstance(JepType type, Supplier<JepConfig> configurationSupplier) {
        Objects.requireNonNull(type, "Null JEP interpretation type");
        return new JepSingleThreadInterpreter(type, configurationSupplier);
    }

    public JepType type() {
        return this.type;
    }

    public JepConfig configuration() {
        this.checkStateAlive();
        return this.state.configuredInterpreter.configuration();
    }

    public <T> T executeInSingleThread(Callable<T> task) {
        Objects.requireNonNull(task, "Null task");
        Object object = this.state.lock;
        synchronized (object) {
            this.checkStateAlive();
            this.checkClosed();
            try {
                return this.state.singleThreadPool.submit(task).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw JepSingleThreadInterpreter.translateException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeInSingleThread(Runnable task) {
        Objects.requireNonNull(task, "Null task");
        Object object = this.state.lock;
        synchronized (object) {
            this.checkStateAlive();
            this.checkClosed();
            try {
                this.state.singleThreadPool.submit(task).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw JepSingleThreadInterpreter.translateException(e);
            }
        }
    }

    public AtomicPyObject wrapObject(PyObject pyObject) {
        return new AtomicPyObject(this, pyObject);
    }

    public AtomicPyCallable wrapCallable(PyCallable pyCallable) {
        return new AtomicPyCallable(this, pyCallable);
    }

    public Object invoke(String name, Object ... args) throws JepException {
        Objects.requireNonNull(name, "Null name");
        this.checkStateAlive();
        return this.executeInSingleThread(() -> this.state.configuredInterpreter.interpreter().invoke(name, args));
    }

    public Object invoke(String name, Map<String, Object> kwargs) throws JepException {
        Objects.requireNonNull(name, "Null name");
        this.checkStateAlive();
        return this.executeInSingleThread(() -> this.state.configuredInterpreter.interpreter().invoke(name, kwargs));
    }

    public Object invoke(String name, Object[] args, Map<String, Object> kwargs) throws JepException {
        Objects.requireNonNull(name, "Null name");
        this.checkStateAlive();
        return this.executeInSingleThread(() -> this.state.configuredInterpreter.interpreter().invoke(name, args, kwargs));
    }

    public boolean eval(String str) throws JepException {
        this.checkStateAlive();
        return this.executeInSingleThread(() -> this.state.configuredInterpreter.interpreter().eval(str));
    }

    public void exec(String str) throws JepException {
        this.checkStateAlive();
        this.executeInSingleThread(() -> this.state.configuredInterpreter.interpreter().exec(str));
    }

    public void runScript(String script) throws JepException {
        this.checkStateAlive();
        this.executeInSingleThread(() -> this.state.configuredInterpreter.interpreter().runScript(script));
    }

    public Object getValue(String name) throws JepException {
        Objects.requireNonNull(name, "Null name");
        this.checkStateAlive();
        return this.executeInSingleThread(() -> this.state.configuredInterpreter.interpreter().getValue(name));
    }

    public <T> T getValue(String name, Class<T> clazz) throws JepException {
        Objects.requireNonNull(name, "Null name");
        Objects.requireNonNull(clazz, "Null class");
        this.checkStateAlive();
        return (T)this.executeInSingleThread(() -> this.state.configuredInterpreter.interpreter().getValue(name, clazz));
    }

    public void set(String name, Object v) throws JepException {
        Objects.requireNonNull(name, "Null name");
        this.checkStateAlive();
        this.executeInSingleThread(() -> this.state.configuredInterpreter.interpreter().set(name, v));
    }

    public boolean isClosed() {
        return this.state.isReallyClosed();
    }

    public void close() throws JepException {
        this.state.normallyClosed = true;
        this.cleanable.clean();
    }

    public String toString() {
        return this.state.toBriefString();
    }

    private void checkStateAlive() {
        if (this.state.configuredInterpreter == null) {
            throw new IllegalStateException("Abnormal situation: interpreter is closed");
        }
    }

    private void checkClosed() {
        if (this.state.normallyClosed || this.state.isReallyClosed()) {
            throw new IllegalStateException("Cannot use " + String.valueOf(this));
        }
    }

    private static AssertionError translateException(Throwable exception) {
        if (exception instanceof InterruptedException) {
            Thread.currentThread().interrupt();
            throw new JepException("Interruption of JEP operation", exception);
        }
        if (exception instanceof ExecutionException) {
            Throwable cause = exception.getCause();
            if (cause instanceof RuntimeException && !(cause instanceof JepException)) {
                String message = cause.getMessage();
                throw new JepException("Exception in JEP thread: " + String.valueOf(message == null ? cause : message), cause);
            }
            JepSingleThreadInterpreter.throwUncheckedException(cause);
        }
        JepSingleThreadInterpreter.throwUncheckedException(exception);
        return new AssertionError((Object)"Cannot occur");
    }

    private static void throwUncheckedException(Throwable exception) {
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        if (exception instanceof Error) {
            throw (Error)exception;
        }
        throw new AssertionError((Object)("Impossible checked exception: " + String.valueOf(exception)));
    }

    private static class ExpensiveCleanableState
    extends ExpensiveState
    implements Runnable {
        public ExpensiveCleanableState(JepType type, Supplier<JepConfig> configurationSupplier) {
            super(type, configurationSupplier);
        }

        @Override
        public void run() {
            this.closeInterpreter();
        }
    }

    private static class ExpensiveState {
        private final String name;
        private final boolean globalThreadPool;
        private static final AtomicInteger THREAD_COUNT = new AtomicInteger(1);
        private volatile ThreadPoolExecutor singleThreadPool;
        private volatile ConfiguredInterpreter configuredInterpreter;
        private volatile boolean normallyClosed = false;
        private final Object lock = new Object();

        ExpensiveState(JepType type, Supplier<JepConfig> configurationSupplier) {
            this(() -> type.newLowLevelInterpreter(configurationSupplier), type.typeName(), type.isJVMGlobal());
        }

        private ExpensiveState(Supplier<ConfiguredInterpreter> configuredInterpreterSupplier, String name, boolean globalThreadPool) {
            if (name == null) {
                name = "unknown";
            }
            this.name = name;
            this.globalThreadPool = globalThreadPool;
            if (globalThreadPool) {
                this.singleThreadPool = JVMGlobalThreadPoolHolder.INSTANCE.getSingleThreadPool();
            } else {
                String threadName = "JEP " + name + " execution thread #" + THREAD_COUNT.getAndIncrement();
                LOG.log(System.Logger.Level.DEBUG, () -> "Creating " + threadName);
                this.singleThreadPool = ExpensiveState.newSingleThreadPool(threadName);
            }
            try {
                LOG.log(System.Logger.Level.DEBUG, () -> "Creating JEP " + this.name + " interpreter");
                this.configuredInterpreter = this.singleThreadPool.submit(configuredInterpreterSupplier::get).get();
                if (this.configuredInterpreter == null) {
                    throw new IllegalArgumentException("Illegal configuredInterpreterSupplier: created null result");
                }
            }
            catch (Throwable e) {
                this.shutdownLocalThreadPool(e);
                throw JepSingleThreadInterpreter.translateException(e);
            }
            LOG.log(System.Logger.Level.DEBUG, () -> "Created " + this.toBriefString());
            assert (this.configuredInterpreter != null) : "already checked above: configuredInterpreter == null";
            assert (this.singleThreadPool != null) : "created via new operation above: singleThreadPool == null";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void closeInterpreter() {
            Object object = this.lock;
            synchronized (object) {
                if (this.isReallyClosed()) {
                    return;
                }
                if (this.normallyClosed) {
                    LOG.log(System.Logger.Level.TRACE, () -> "Normal closing " + String.valueOf(this));
                } else {
                    LOG.log(System.Logger.Level.INFO, () -> "CLEANING " + this.toBriefString());
                }
                try {
                    this.singleThreadPool.submit(this.configuredInterpreter::close).get();
                    LOG.log(System.Logger.Level.DEBUG, () -> "Closed JEP " + this.name + " interpreter");
                }
                catch (InterruptedException | ExecutionException e) {
                    throw JepSingleThreadInterpreter.translateException(e);
                }
                this.shutdownLocalThreadPool(null);
                this.configuredInterpreter = null;
            }
        }

        private void shutdownLocalThreadPool(Throwable exception) {
            assert (this.singleThreadPool != null) : "shutdownLocalThreadPool() was called twice or without normal creation: singleThreadPool == null";
            if (!this.globalThreadPool) {
                LOG.log(System.Logger.Level.DEBUG, () -> "Shutting down JEP " + this.name + " thread pool" + (String)(exception == null ? "" : " (because of " + String.valueOf(exception) + ")"));
                this.singleThreadPool.shutdownNow();
            }
            this.singleThreadPool = null;
        }

        public String toBriefString() {
            return (!this.isReallyClosed() ? "" : (this.normallyClosed ? "closed " : "abnormally CLEANED ")) + "JEP single-thread " + this.name + " interpreter";
        }

        public String toString() {
            return this.toBriefString() + " in " + String.valueOf(this.singleThreadPool) + " (" + String.valueOf(this.configuredInterpreter) + ")";
        }

        private void checkClosed(String name) {
            if (this.normallyClosed || this.isReallyClosed()) {
                throw new IllegalStateException("Cannot use " + name);
            }
        }

        static ThreadPoolExecutor newSingleThreadPool(String threadName) {
            return new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), r -> {
                Thread t = new Thread(r, threadName);
                t.setDaemon(true);
                return t;
            });
        }

        private boolean isReallyClosed() {
            return this.configuredInterpreter == null;
        }
    }

    private static class JVMGlobalThreadPoolHolder {
        static final JVMGlobalThreadPoolHolder INSTANCE = new JVMGlobalThreadPoolHolder();
        private final ThreadPoolExecutor singleThreadPool;

        private JVMGlobalThreadPoolHolder() {
            String threadName = "JEP JVM-global execution thread";
            LOG.log(System.Logger.Level.INFO, () -> "Creating JEP JVM-global execution thread");
            this.singleThreadPool = ExpensiveState.newSingleThreadPool("JEP JVM-global execution thread");
        }

        public ThreadPoolExecutor getSingleThreadPool() {
            return this.singleThreadPool;
        }
    }
}

