/*
 * Decompiled with CFR 0.152.
 */
package net.algart.multimatrix;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.BitArray;
import net.algart.arrays.ByteArray;
import net.algart.arrays.CharArray;
import net.algart.arrays.DoubleArray;
import net.algart.arrays.FloatArray;
import net.algart.arrays.IntArray;
import net.algart.arrays.LongArray;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.PArray;
import net.algart.arrays.ShortArray;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.arrays.SizeMismatchException;
import net.algart.arrays.UpdatableBitArray;
import net.algart.arrays.UpdatableByteArray;
import net.algart.arrays.UpdatableCharArray;
import net.algart.arrays.UpdatableDoubleArray;
import net.algart.arrays.UpdatableFloatArray;
import net.algart.arrays.UpdatableIntArray;
import net.algart.arrays.UpdatableLongArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.arrays.UpdatableShortArray;
import net.algart.math.Range;
import net.algart.math.functions.AbstractFunc;
import net.algart.math.functions.Func;
import net.algart.math.functions.LinearFunc;
import net.algart.multimatrix.MultiMatrix2D;
import net.algart.multimatrix.NonZeroRangeCalculator;
import net.algart.multimatrix.SimpleMultiMatrix;
import net.algart.multimatrix.SimpleMultiMatrix2D;

public interface MultiMatrix
extends Cloneable {
    public static final int MAX_NUMBER_OF_CHANNELS = 512;
    public static final double INTENSITY_R_WEIGHT = 0.299;
    public static final double INTENSITY_B_WEIGHT = 0.114;
    public static final double INTENSITY_G_WEIGHT = 0.587;
    public static final int DEFAULT_R_CHANNEL = 0;
    public static final int DEFAULT_G_CHANNEL = 1;
    public static final int DEFAULT_B_CHANNEL = 2;
    public static final int DEFAULT_ALPHA_CHANNEL = 3;
    public static final List<Class<?>> SUPPORTED_ELEMENT_TYPES;

    public List<Matrix<? extends PArray>> allChannels();

    public Class<?> elementType();

    public int numberOfChannels();

    public Matrix<? extends PArray> channel(int var1);

    default public PArray channelArray(int channelIndex) {
        return (PArray)this.channel(channelIndex).array();
    }

    default public Matrix<PArray> mergeChannels() {
        return Matrices.mergeLayers((MemoryModel)net.algart.arrays.Arrays.SMM, this.allChannels());
    }

    default public long[] dimensions() {
        return this.channel(0).dimensions();
    }

    default public int dimCount() {
        return this.channel(0).dimCount();
    }

    default public long dim(int n) {
        return this.channel(0).dim(n);
    }

    default public Class<? extends PArray> arrayType() {
        return this.channel(0).type(PArray.class);
    }

    default public double maxPossibleValue() {
        return net.algart.arrays.Arrays.maxPossibleValue(this.arrayType(), (double)1.0);
    }

    default public long size() {
        return this.channel(0).size();
    }

    default public boolean isUnsigned() {
        return net.algart.arrays.Arrays.isUnsignedElementType(this.elementType());
    }

    default public boolean isFloatingPoint() {
        return net.algart.arrays.Arrays.isFloatingPointElementType(this.elementType());
    }

    default public int bitsPerElement() {
        return (int)((PArray)this.channel(0).array()).bitsPerElement();
    }

    public long indexInArray(long ... var1);

    default public MultiMatrix2D asMultiMatrix2D() {
        if (this instanceof MultiMatrix2D) {
            return (MultiMatrix2D)this;
        }
        List<Matrix<? extends PArray>> allChannels = this.allChannels();
        if (allChannels.get(0).dimCount() == 2) {
            return MultiMatrix.of2D(allChannels);
        }
        throw new IllegalStateException("This matrix is not actually 2-dimensional: " + String.valueOf(this));
    }

    default public PixelValue getPixel(long indexInArray) {
        return this.getPixel(indexInArray, null);
    }

    default public PixelValue getPixel(long indexInArray, PixelValue result) {
        if (result == null) {
            result = PixelValue.newZeroPixelValue(this.elementType(), this.numberOfChannels());
        }
        result.read(this, indexInArray);
        return result;
    }

    default public void setPixel(long indexInArray, PixelValue pixelValue) {
        pixelValue.write(this, indexInArray);
    }

    default public double getPixelChannel(int channelIndex, long indexInArray) {
        return this.channelArray(channelIndex).getDouble(indexInArray);
    }

    default public void setPixelChannel(int channelIndex, long indexInArray, double value) {
        ((UpdatablePArray)this.channelArray(channelIndex)).setDouble(indexInArray, value);
    }

    public MultiMatrix asPrecision(Class<?> var1);

    public MultiMatrix toPrecisionIfNot(Class<?> var1);

    default public MultiMatrix toPrecision(Class<?> newElementType) {
        return newElementType.equals(this.elementType()) ? this.clone() : this.toPrecisionIfNot(newElementType);
    }

    default public MultiMatrix asFloatingPoint() {
        return this.isFloatingPoint() ? this : this.asPrecision(Float.TYPE);
    }

    default public MultiMatrix asFloat() {
        return this.elementType() == Float.TYPE ? this : this.asPrecision(Float.TYPE);
    }

    default public MultiMatrix toFloatIfNot() {
        return this.elementType() == Float.TYPE ? this : this.toPrecisionIfNot(Float.TYPE);
    }

    default public boolean isMono() {
        return this.numberOfChannels() == 1;
    }

    default public boolean isColor() {
        int n = this.numberOfChannels();
        return n == 3 || n == 4;
    }

    default public boolean isSimpleMemoryModel() {
        return this.allChannels().stream().allMatch(channel -> SimpleMemoryModel.isSimpleArray((net.algart.arrays.Array)channel.array()));
    }

    public MultiMatrix asMono();

    default public MultiMatrix toMonoIfNot() {
        return this.isMono() ? this : this.asMono().clone();
    }

    default public MultiMatrix asOtherNumberOfChannels(int newNumberOfChannels) {
        return this.asOtherNumberOfChannels(newNumberOfChannels, true);
    }

    public MultiMatrix asOtherNumberOfChannels(int var1, boolean var2);

    public MultiMatrix clone();

    public MultiMatrix actualizeLazy();

    default public MultiMatrix nonZeroPixels(boolean checkOnlyRGBChannels) {
        return MultiMatrix.ofMono(this.nonZeroPixelsMatrix(checkOnlyRGBChannels));
    }

    default public MultiMatrix zeroPixels(boolean checkOnlyRGBChannels) {
        return MultiMatrix.ofMono(this.zeroPixelsMatrix(checkOnlyRGBChannels));
    }

    default public MultiMatrix nonZeroAnyChannel() {
        return MultiMatrix.ofMono(this.nonZeroAnyChannelMatrix());
    }

    default public MultiMatrix zeroAllChannels() {
        return MultiMatrix.ofMono(this.zeroAllChannelsMatrix());
    }

    default public MultiMatrix nonZeroRGB() {
        return MultiMatrix.ofMono(this.nonZeroRGBMatrix());
    }

    default public MultiMatrix zeroRGB() {
        return MultiMatrix.ofMono(this.zeroRGBMatrix());
    }

    default public Matrix<BitArray> nonZeroAnyChannelMatrix() {
        return this.nonZeroPixelsMatrix(false);
    }

    default public Matrix<BitArray> nonZeroRGBMatrix() {
        return this.nonZeroPixelsMatrix(true);
    }

    default public Matrix<BitArray> nonZeroPixelsMatrix(boolean checkOnlyRGBChannels) {
        if (this.numberOfChannels() == 1 && this.elementType() == Boolean.TYPE) {
            return this.channel(0).cast(BitArray.class);
        }
        ArrayList<Matrix<BitArray>> nonZeroPixelsInChannels = new ArrayList<Matrix<BitArray>>();
        for (Matrix<? extends PArray> m : this.allChannels()) {
            if (checkOnlyRGBChannels && nonZeroPixelsInChannels.size() >= 3) break;
            nonZeroPixelsInChannels.add(MultiMatrix.nonZeroPixels(m));
        }
        return nonZeroPixelsInChannels.size() == 1 ? (Matrix)nonZeroPixelsInChannels.get(0) : Matrices.asFuncMatrix((Func)Func.MAX, BitArray.class, nonZeroPixelsInChannels).cast(BitArray.class).clone();
    }

    default public Matrix<BitArray> zeroAllChannelsMatrix() {
        return this.zeroPixelsMatrix(false);
    }

    default public Matrix<BitArray> zeroRGBMatrix() {
        return this.zeroPixelsMatrix(true);
    }

    default public Matrix<BitArray> zeroPixelsMatrix(boolean checkOnlyRGBChannels) {
        return Matrices.asFuncMatrix((Func)Func.REVERSE, BitArray.class, this.nonZeroPixelsMatrix(checkOnlyRGBChannels)).cast(BitArray.class).clone();
    }

    default public MultiMatrix min(MultiMatrix other) {
        return this.asFunc(Func.MIN, other);
    }

    default public MultiMatrix max(MultiMatrix other) {
        return this.asFunc(Func.MAX, other);
    }

    default public MultiMatrix asFunc(Func funcOfOneArgument) {
        return this.asFunc(funcOfOneArgument, this.arrayType());
    }

    default public MultiMatrix asFunc(Func funcOfOneArgument, Class<? extends PArray> requiredType) {
        int n = this.numberOfChannels();
        ArrayList<Matrix> channels = new ArrayList<Matrix>();
        for (int k = 0; k < n; ++k) {
            channels.add(Matrices.asFuncMatrix((Func)funcOfOneArgument, requiredType, this.channel(k)));
        }
        return MultiMatrix.of(channels);
    }

    default public MultiMatrix asFunc(Func funcOfTwoArguments, MultiMatrix other) {
        return this.asFunc(funcOfTwoArguments, other, this.arrayType());
    }

    default public MultiMatrix asFunc(Func funcOfTwoArguments, MultiMatrix other, Class<? extends PArray> requiredType) {
        Objects.requireNonNull(other, "Null other multi-matrix");
        int n = this.numberOfChannels();
        other = other.asOtherNumberOfChannels(n).asPrecision(this.elementType());
        if (!2.$assertionsDisabled && other.numberOfChannels() != n) {
            throw new AssertionError((Object)"Invalid asOtherNumberOfChannels implementation");
        }
        ArrayList<Matrix> channels = new ArrayList<Matrix>();
        for (int k = 0; k < n; ++k) {
            channels.add(Matrices.asFuncMatrix((Func)funcOfTwoArguments, requiredType, this.channel(k), other.channel(k)));
        }
        return MultiMatrix.of(channels);
    }

    default public MultiMatrix apply(Function<Matrix<? extends PArray>, Matrix<? extends PArray>> function) {
        return MultiMatrix.of(Matrices.apply(function::apply, this.allChannels()));
    }

    default public List<Matrix<? extends PArray>> allChannelsInRGBAOrder() {
        List<Matrix<? extends PArray>> channels = this.allChannels();
        SimpleMultiMatrix.checkNumberOfChannels(channels, true);
        return channels;
    }

    default public List<Matrix<? extends PArray>> allChannelsInBGRAOrder() {
        List<Matrix<? extends PArray>> channels = this.allChannels();
        SimpleMultiMatrix.checkNumberOfChannels(channels, true);
        return SimpleMultiMatrix.flipRB(channels);
    }

    default public Matrix<? extends PArray> intensityChannel() {
        Matrix<? extends PArray> result = this.intensityChannelOrNull();
        if (result == null) {
            throw new IllegalStateException("Cannot convert " + this.numberOfChannels() + "-channel multichannel matrix into monochrome (intensity) one: automatic conversion to monochrome is possible only for 3- or 4-channel matrix (RGB or RGBA)");
        }
        return result;
    }

    default public Matrix<? extends PArray> intensityChannelOrNull() {
        int n = this.numberOfChannels();
        if (n == 1) {
            return this.channel(0);
        }
        if (n != 3 && n != 4) {
            return null;
        }
        Matrix<? extends PArray> g = this.channel(1);
        Matrix<? extends PArray> r = this.channel(0);
        Matrix<? extends PArray> b = this.channel(2);
        Class resultType = g.type(PArray.class);
        return Matrices.asFuncMatrix((Func)LinearFunc.getInstance((double)(this.isFloatingPoint() ? 0.0 : 0.5), (double[])new double[]{0.299, 0.587, 0.114}), (Class)resultType, r, g, b);
    }

    default public Range rangeOfIntensityOrNull() {
        Matrix<? extends PArray> intensityChannel = this.intensityChannelOrNull();
        return intensityChannel == null ? null : net.algart.arrays.Arrays.rangeOf((PArray)((PArray)intensityChannel.array()));
    }

    default public Range nonZeroRangeOf(int channelIndex) {
        return MultiMatrix.nonZeroRangeOf(null, (PArray)this.channel(channelIndex).array());
    }

    default public Matrix<? extends PArray> constantMatrix(double value) {
        return Matrices.constantMatrix((double)value, this.arrayType(), (long[])this.dimensions()).clone();
    }

    default public MultiMatrix contrast() {
        Range range = this.rangeOfIntensityOrNull();
        if (range == null) {
            return this;
        }
        return this.contrast(range, false);
    }

    default public MultiMatrix contrast(Range sourceRangeToContrast, boolean requireMonochromeOrColor) {
        Range destRange = Range.valueOf((double)0.0, (double)this.maxPossibleValue());
        LinearFunc function = sourceRangeToContrast == null || sourceRangeToContrast.size() == 0.0 ? null : LinearFunc.getInstance((Range)destRange, (Range)sourceRangeToContrast);
        return this.correctIntensity(function, requireMonochromeOrColor);
    }

    default public MultiMatrix correctIntensity(LinearFunc intensityCorrectingFunctionOfOneArgument, boolean requireMonochromeOrColor) {
        int n = this.numberOfChannels();
        if (n != 1 && n != 3 && n != 4) {
            if (requireMonochromeOrColor) {
                throw new IllegalStateException("Cannot correct intensity of " + n + "-channel multichannel matrix: it is possible only for 1-, 3- or 4-channel matrix (monochrome, RGB or RGBA)");
            }
            return this;
        }
        if (intensityCorrectingFunctionOfOneArgument == null) {
            return this;
        }
        if (n == 1) {
            return MultiMatrix.ofMono((Matrix<? extends PArray>)Matrices.asFuncMatrix((Func)intensityCorrectingFunctionOfOneArgument, (Class)this.channel(0).type(PArray.class), this.channel(0)));
        }
        Matrix<? extends PArray> i = this.intensityChannel();
        ArrayList<Matrix<? extends PArray>> channels = new ArrayList<Matrix<? extends PArray>>(this.allChannels());
        final double a = intensityCorrectingFunctionOfOneArgument.a(0);
        final double b = intensityCorrectingFunctionOfOneArgument.b();
        for (int k = 0; k < 3; ++k) {
            Matrix m = (Matrix)channels.get(k);
            final Range destRange = Range.valueOf((double)0.0, (double)((PArray)m.array()).maxPossibleValue(1.0));
            AbstractFunc f = new AbstractFunc(this){

                public double get(double ... x) {
                    return x[1] == 0.0 ? 0.0 : destRange.cut(x[0] * (a + b / x[1]));
                }

                public double get(double x0, double x1) {
                    return x1 == 0.0 ? 0.0 : destRange.cut(x0 * (a + b / x1));
                }
            };
            Matrix result = Matrices.asFuncMatrix((Func)f, (Class)m.type(PArray.class), (Matrix)m, i);
            channels.set(k, (Matrix<? extends PArray>)result);
        }
        return MultiMatrix.of(channels);
    }

    default public boolean dimEquals(MultiMatrix other) {
        Objects.requireNonNull(other, "Null multi-matrix");
        int dimCount = this.dimCount();
        if (other.dimCount() != dimCount) {
            return false;
        }
        for (int k = 0; k < dimCount; ++k) {
            if (other.dim(k) == this.dim(k)) continue;
            return false;
        }
        return true;
    }

    default public void checkDimensionEquality(MultiMatrix other, String thisMatrixName, String otherMatrixName) throws SizeMismatchException {
        if (other == null) {
            return;
        }
        if (!this.dimEquals(other)) {
            throw new SizeMismatchException("The " + thisMatrixName + " and " + otherMatrixName + " multi-matrix dimensions mismatch: " + String.valueOf(this) + " and " + String.valueOf(other));
        }
    }

    default public void freeResources() {
        for (Matrix<? extends PArray> m : this.allChannels()) {
            m.freeResources();
        }
    }

    public static MultiMatrix of(List<? extends Matrix<? extends PArray>> channels) {
        return new SimpleMultiMatrix(channels);
    }

    public static MultiMatrix ofRGBA(List<? extends Matrix<? extends PArray>> channels) {
        SimpleMultiMatrix.checkNumberOfChannels(channels, false);
        return new SimpleMultiMatrix(channels);
    }

    public static MultiMatrix ofBGRA(List<? extends Matrix<? extends PArray>> channels) {
        SimpleMultiMatrix.checkNumberOfChannels(channels, false);
        return new SimpleMultiMatrix(SimpleMultiMatrix.flipRB(channels));
    }

    public static MultiMatrix ofMono(Matrix<? extends PArray> singleChannel) {
        Objects.requireNonNull(singleChannel, "Null single-channel matrix");
        return new SimpleMultiMatrix(Collections.singletonList(singleChannel));
    }

    public static MultiMatrix ofMerged(Matrix<? extends PArray> mergedChannels) {
        Objects.requireNonNull(mergedChannels, "Null mergedChannels");
        return new SimpleMultiMatrix(Matrices.asLayers(mergedChannels, (int)512));
    }

    public static MultiMatrix2D newMultiMatrix2D(Class<?> elementType, int numberOfChannels, long dimX, long dimY) {
        return MultiMatrix.newMultiMatrix2D(elementType, numberOfChannels, dimX, dimY, true);
    }

    public static MultiMatrix2D zeroConstant2D(Class<?> elementType, int numberOfChannels, long dimX, long dimY) {
        return MultiMatrix.newMultiMatrix2D(elementType, numberOfChannels, dimX, dimY, false);
    }

    public static MultiMatrix2D newMultiMatrix2D(Class<?> elementType, int numberOfChannels, long dimX, long dimY, boolean updatable) {
        Objects.requireNonNull(elementType, "Null elementType");
        if (numberOfChannels <= 0) {
            throw new IllegalArgumentException("Zero or negative numberOfChannels=" + numberOfChannels);
        }
        ArrayList<Matrix> channels = new ArrayList<Matrix>();
        for (int k = 0; k < numberOfChannels; ++k) {
            channels.add(updatable ? net.algart.arrays.Arrays.SMM.newMatrix(UpdatablePArray.class, elementType, new long[]{dimX, dimY}) : Matrices.constantMatrix((double)0.0, (Class)net.algart.arrays.Arrays.type(PArray.class, elementType), (long[])new long[]{dimX, dimY}));
        }
        return new SimpleMultiMatrix2D(channels);
    }

    public static MultiMatrix2D of2D(List<? extends Matrix<? extends PArray>> channels) {
        return new SimpleMultiMatrix2D(channels);
    }

    public static MultiMatrix2D of2DRGBA(List<? extends Matrix<? extends PArray>> channels) {
        SimpleMultiMatrix.checkNumberOfChannels(channels, false);
        return new SimpleMultiMatrix2D(channels);
    }

    public static MultiMatrix2D of2DBGRA(List<? extends Matrix<? extends PArray>> channels) {
        SimpleMultiMatrix.checkNumberOfChannels(channels, false);
        return new SimpleMultiMatrix2D(SimpleMultiMatrix.flipRB(channels));
    }

    public static MultiMatrix2D of2DMono(Matrix<? extends PArray> singleChannel) {
        Objects.requireNonNull(singleChannel, "Null single-channel matrix");
        return new SimpleMultiMatrix2D(Collections.singletonList(singleChannel));
    }

    public static MultiMatrix2D of2DMerged(Matrix<? extends PArray> packedChannels) {
        Objects.requireNonNull(packedChannels, "Null packedChannels");
        return new SimpleMultiMatrix2D(Matrices.asLayers(packedChannels, (int)512));
    }

    public static Matrix<BitArray> nonZeroPixels(Matrix<? extends PArray> matrix) {
        if (matrix.elementType() == Boolean.TYPE) {
            return matrix.cast(BitArray.class);
        }
        return Matrices.asFuncMatrix((Func)Func.IDENTITY, BitArray.class, matrix);
    }

    public static Matrix<BitArray> zeroPixels(Matrix<? extends PArray> matrix) {
        return Matrices.asFuncMatrix((Func)Func.REVERSE, BitArray.class, MultiMatrix.nonZeroPixels(matrix));
    }

    public static List<Matrix<? extends UpdatablePArray>> cloneMatrices(List<Matrix<? extends PArray>> channels) {
        ArrayList<Matrix<? extends UpdatablePArray>> result = new ArrayList<Matrix<? extends UpdatablePArray>>();
        for (Matrix<? extends PArray> c : channels) {
            result.add((Matrix<? extends UpdatablePArray>)Matrices.clone(c));
        }
        return result;
    }

    public static List<Matrix<? extends PArray>> actualizeLazyMatrices(List<Matrix<? extends PArray>> channels) {
        ArrayList<Matrix<? extends PArray>> result = new ArrayList<Matrix<? extends PArray>>();
        for (Matrix matrix : channels) {
            result.add((Matrix<? extends PArray>)(SimpleMemoryModel.isSimpleArray((net.algart.arrays.Array)matrix.array()) ? matrix : Matrices.clone(matrix)));
        }
        return result;
    }

    public static List<MultiMatrix2D> asMultiMatrices2D(Collection<MultiMatrix> matrices) {
        ArrayList<MultiMatrix2D> result = new ArrayList<MultiMatrix2D>();
        for (MultiMatrix m : matrices) {
            result.add(m == null ? null : m.asMultiMatrix2D());
        }
        return result;
    }

    public static Range nonZeroRangeOf(PArray array) {
        return MultiMatrix.nonZeroRangeOf(null, array);
    }

    public static Range nonZeroRangeOf(ArrayContext context, PArray array) {
        NonZeroRangeCalculator calculator = new NonZeroRangeCalculator(context, array);
        calculator.process();
        return calculator.resultRange;
    }

    static {
        if (2.$assertionsDisabled) {
            // empty if block
        }
        SUPPORTED_ELEMENT_TYPES = List.of(Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Boolean.TYPE, Character.TYPE);
    }

    public static abstract class PixelValue {
        private int hashCode = -1;
        boolean hashCodeCalculated = false;

        private PixelValue() {
        }

        public static PixelValue of(Object channelsJavaArray) {
            return PixelValue.of(channelsJavaArray, true);
        }

        public static PixelValue newZeroPixelValue(Class<?> elementType, int numberOfChannels) {
            return PixelValue.of(Array.newInstance(elementType, numberOfChannels), false);
        }

        static PixelValue of(Object channelsJavaArray, boolean doClone) {
            Objects.requireNonNull(channelsJavaArray, "Null channels java array");
            if (channelsJavaArray instanceof boolean[]) {
                boolean[] channels = (boolean[])channelsJavaArray;
                return new Bit(doClone ? (boolean[])channels.clone() : channels);
            }
            if (channelsJavaArray instanceof char[]) {
                char[] channels = (char[])channelsJavaArray;
                return new Char(doClone ? (char[])channels.clone() : channels);
            }
            if (channelsJavaArray instanceof byte[]) {
                byte[] channels = (byte[])channelsJavaArray;
                return new Byte(doClone ? (byte[])channels.clone() : channels);
            }
            if (channelsJavaArray instanceof short[]) {
                short[] channels = (short[])channelsJavaArray;
                return new Short(doClone ? (short[])channels.clone() : channels);
            }
            if (channelsJavaArray instanceof int[]) {
                int[] channels = (int[])channelsJavaArray;
                return new Int(doClone ? (int[])channels.clone() : channels);
            }
            if (channelsJavaArray instanceof long[]) {
                long[] channels = (long[])channelsJavaArray;
                return new Long(doClone ? (long[])channels.clone() : channels);
            }
            if (channelsJavaArray instanceof float[]) {
                float[] channels = (float[])channelsJavaArray;
                return new Float(doClone ? (float[])channels.clone() : channels);
            }
            if (channelsJavaArray instanceof double[]) {
                double[] channels = (double[])channelsJavaArray;
                return new Double(doClone ? (double[])channels.clone() : channels);
            }
            throw new IllegalArgumentException("The passed java-array argument is not boolean[], char[], byte[], short[], int[], long[], float[] or double[] (it is " + channelsJavaArray.getClass().getSimpleName() + ")");
        }

        public final int hashCode() {
            if (!this.hashCodeCalculated) {
                this.hashCode = this.hashCodeImpl();
                this.hashCodeCalculated = true;
            }
            return this.hashCode;
        }

        public abstract boolean equals(Object var1);

        public abstract int numberOfChannels();

        public abstract Class<?> elementType();

        public Object getChannels() {
            return this.getChannels(null);
        }

        public Object getChannels(Object result) {
            if (result == null) {
                result = Array.newInstance(this.elementType(), this.numberOfChannels());
            }
            System.arraycopy(this.channelsRef(), 0, result, 0, this.numberOfChannels());
            return result;
        }

        public void setChannels(Object channels) {
            this.hashCodeCalculated = false;
            System.arraycopy(channels, 0, this.channelsRef(), 0, this.numberOfChannels());
        }

        public abstract double getChannel(int var1);

        public abstract void setChannel(int var1, double var2);

        public abstract void read(MultiMatrix var1, long var2);

        public abstract void write(MultiMatrix var1, long var2);

        public double[] getDoubleChannels() {
            return this.getDoubleChannels(null);
        }

        public double[] getDoubleChannels(double[] result) {
            if (result == null) {
                result = new double[this.numberOfChannels()];
            }
            for (int k = 0; k < result.length; ++k) {
                result[k] = this.getChannel(k);
            }
            return result;
        }

        public float[] getFloatChannels() {
            return this.getFloatChannels(null);
        }

        public float[] getFloatChannels(float[] result) {
            if (result == null) {
                result = new float[this.numberOfChannels()];
            }
            for (int k = 0; k < result.length; ++k) {
                result[k] = (float)this.getChannel(k);
            }
            return result;
        }

        public int[] getIntChannels() {
            return this.getIntChannels(null);
        }

        public int[] getIntChannels(int[] result) {
            if (result == null) {
                result = new int[this.numberOfChannels()];
            }
            for (int k = 0; k < result.length; ++k) {
                result[k] = (int)this.getChannel(k);
            }
            return result;
        }

        abstract Object channelsRef();

        abstract int hashCodeImpl();

        public static class Bit
        extends PixelValue {
            private final boolean[] channels;

            Bit(boolean[] channels) {
                this.channels = Objects.requireNonNull(channels, "Null channels");
            }

            @Override
            public int numberOfChannels() {
                return this.channels.length;
            }

            @Override
            public Class<?> elementType() {
                return Boolean.TYPE;
            }

            @Override
            public double getChannel(int channelIndex) {
                return this.channels[channelIndex] ? 1.0 : 0.0;
            }

            @Override
            public void setChannel(int channelIndex, double value) {
                this.hashCodeCalculated = false;
                this.channels[channelIndex] = value != 0.0;
            }

            @Override
            public void read(MultiMatrix multiMatrix, long indexInArray) {
                this.hashCodeCalculated = false;
                int n = multiMatrix.numberOfChannels();
                for (int k = 0; k < n; ++k) {
                    this.channels[k] = ((BitArray)multiMatrix.channelArray(k)).getBit(indexInArray);
                }
            }

            @Override
            public void write(MultiMatrix multiMatrix, long indexInArray) {
                int n = multiMatrix.numberOfChannels();
                for (int k = 0; k < n; ++k) {
                    ((UpdatableBitArray)multiMatrix.channelArray(k)).setBit(indexInArray, this.channels[k]);
                }
            }

            public String toString() {
                StringBuilder sb = new StringBuilder("bit pixel [");
                for (int k = 0; k < this.channels.length; ++k) {
                    if (k > 0) {
                        sb.append(", ");
                    }
                    sb.append(this.channels[k] ? (char)'1' : '0');
                }
                return sb.append("]").toString();
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Bit aBit = (Bit)o;
                return Arrays.equals(this.channels, aBit.channels);
            }

            @Override
            Object channelsRef() {
                return this.channels;
            }

            @Override
            int hashCodeImpl() {
                return Arrays.hashCode(this.channels);
            }
        }

        public static class Char
        extends PixelValue {
            private final char[] channels;

            Char(char[] channels) {
                this.channels = Objects.requireNonNull(channels, "Null channels");
            }

            @Override
            public int numberOfChannels() {
                return this.channels.length;
            }

            @Override
            public Class<?> elementType() {
                return Character.TYPE;
            }

            public char[] channelsRef() {
                return this.channels;
            }

            @Override
            public double getChannel(int channelIndex) {
                return this.channels[channelIndex];
            }

            @Override
            public void setChannel(int channelIndex, double value) {
                this.hashCodeCalculated = false;
                this.channels[channelIndex] = (char)value;
            }

            @Override
            public void read(MultiMatrix multiMatrix, long indexInArray) {
                this.hashCodeCalculated = false;
                int n = multiMatrix.numberOfChannels();
                for (int k = 0; k < n; ++k) {
                    this.channels[k] = ((CharArray)multiMatrix.channelArray(k)).getChar(indexInArray);
                }
            }

            @Override
            public void write(MultiMatrix multiMatrix, long indexInArray) {
                int n = multiMatrix.numberOfChannels();
                for (int k = 0; k < n; ++k) {
                    ((UpdatableCharArray)multiMatrix.channelArray(k)).setChar(indexInArray, this.channels[k]);
                }
            }

            public String toString() {
                StringBuilder sb = new StringBuilder("char pixel [");
                for (int k = 0; k < this.channels.length; ++k) {
                    if (k > 0) {
                        sb.append(", ");
                    }
                    sb.append(String.format(Locale.US, "'\\u%04X'", (int)this.channels[k]));
                }
                return sb.append("]").toString();
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Char aChar = (Char)o;
                return Arrays.equals(this.channels, aChar.channels);
            }

            @Override
            int hashCodeImpl() {
                return Arrays.hashCode(this.channels);
            }
        }

        public static class Byte
        extends PixelValue {
            private final byte[] channels;

            Byte(byte[] channels) {
                this.channels = Objects.requireNonNull(channels, "Null channels");
            }

            @Override
            public int numberOfChannels() {
                return this.channels.length;
            }

            @Override
            public Class<?> elementType() {
                return java.lang.Byte.TYPE;
            }

            @Override
            public double getChannel(int channelIndex) {
                return this.channels[channelIndex] & 0xFF;
            }

            @Override
            public void setChannel(int channelIndex, double value) {
                this.hashCodeCalculated = false;
                this.channels[channelIndex] = (byte)value;
            }

            @Override
            public void read(MultiMatrix multiMatrix, long indexInArray) {
                this.hashCodeCalculated = false;
                int n = multiMatrix.numberOfChannels();
                for (int k = 0; k < n; ++k) {
                    this.channels[k] = (byte)((ByteArray)multiMatrix.channelArray(k)).getByte(indexInArray);
                }
            }

            @Override
            public void write(MultiMatrix multiMatrix, long indexInArray) {
                int n = multiMatrix.numberOfChannels();
                for (int k = 0; k < n; ++k) {
                    ((UpdatableByteArray)multiMatrix.channelArray(k)).setByte(indexInArray, this.channels[k]);
                }
            }

            public String toString() {
                StringBuilder sb = new StringBuilder("byte pixel [");
                for (int k = 0; k < this.channels.length; ++k) {
                    if (k > 0) {
                        sb.append(", ");
                    }
                    sb.append(String.format(Locale.US, "0x%02X", this.channels[k] & 0xFF));
                }
                return sb.append("]").toString();
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Byte aByte = (Byte)o;
                return Arrays.equals(this.channels, aByte.channels);
            }

            @Override
            Object channelsRef() {
                return this.channels;
            }

            @Override
            int hashCodeImpl() {
                return Arrays.hashCode(this.channels);
            }
        }

        public static class Short
        extends PixelValue {
            private final short[] channels;

            Short(short[] channels) {
                this.channels = Objects.requireNonNull(channels, "Null channels");
            }

            @Override
            public int numberOfChannels() {
                return this.channels.length;
            }

            @Override
            public Class<?> elementType() {
                return java.lang.Short.TYPE;
            }

            @Override
            public double getChannel(int channelIndex) {
                return this.channels[channelIndex] & 0xFFFF;
            }

            @Override
            public void setChannel(int channelIndex, double value) {
                this.hashCodeCalculated = false;
                this.channels[channelIndex] = (short)value;
            }

            @Override
            public void read(MultiMatrix multiMatrix, long indexInArray) {
                this.hashCodeCalculated = false;
                int n = multiMatrix.numberOfChannels();
                for (int k = 0; k < n; ++k) {
                    this.channels[k] = (short)((ShortArray)multiMatrix.channelArray(k)).getShort(indexInArray);
                }
            }

            @Override
            public void write(MultiMatrix multiMatrix, long indexInArray) {
                int n = multiMatrix.numberOfChannels();
                for (int k = 0; k < n; ++k) {
                    ((UpdatableShortArray)multiMatrix.channelArray(k)).setShort(indexInArray, this.channels[k]);
                }
            }

            public String toString() {
                StringBuilder sb = new StringBuilder("short pixel [");
                for (int k = 0; k < this.channels.length; ++k) {
                    if (k > 0) {
                        sb.append(", ");
                    }
                    sb.append(String.format(Locale.US, "0x%04X", this.channels[k] & 0xFFFF));
                }
                return sb.append("]").toString();
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Short aShort = (Short)o;
                return Arrays.equals(this.channels, aShort.channels);
            }

            @Override
            Object channelsRef() {
                return this.channels;
            }

            @Override
            int hashCodeImpl() {
                return Arrays.hashCode(this.channels);
            }
        }

        public static class Int
        extends PixelValue {
            private final int[] channels;

            Int(int[] channels) {
                this.channels = Objects.requireNonNull(channels, "Null channels");
            }

            @Override
            public int numberOfChannels() {
                return this.channels.length;
            }

            @Override
            public Class<?> elementType() {
                return Integer.TYPE;
            }

            @Override
            public double getChannel(int channelIndex) {
                return this.channels[channelIndex];
            }

            @Override
            public void setChannel(int channelIndex, double value) {
                this.hashCodeCalculated = false;
                this.channels[channelIndex] = (int)value;
            }

            @Override
            public void read(MultiMatrix multiMatrix, long indexInArray) {
                this.hashCodeCalculated = false;
                int n = multiMatrix.numberOfChannels();
                for (int k = 0; k < n; ++k) {
                    this.channels[k] = ((IntArray)multiMatrix.channelArray(k)).getInt(indexInArray);
                }
            }

            @Override
            public void write(MultiMatrix multiMatrix, long indexInArray) {
                int n = multiMatrix.numberOfChannels();
                for (int k = 0; k < n; ++k) {
                    ((UpdatableIntArray)multiMatrix.channelArray(k)).setInt(indexInArray, this.channels[k]);
                }
            }

            public String toString() {
                StringBuilder sb = new StringBuilder("int pixel [");
                for (int k = 0; k < this.channels.length; ++k) {
                    if (k > 0) {
                        sb.append(", ");
                    }
                    if (this.channels[k] == 0) {
                        sb.append('0');
                        continue;
                    }
                    sb.append("0x").append(Integer.toHexString(this.channels[k]).toUpperCase());
                }
                return sb.append("]").toString();
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Int aInt = (Int)o;
                return Arrays.equals(this.channels, aInt.channels);
            }

            @Override
            Object channelsRef() {
                return this.channels;
            }

            @Override
            int hashCodeImpl() {
                return Arrays.hashCode(this.channels);
            }
        }

        public static class Long
        extends PixelValue {
            private final long[] channels;

            Long(long[] channels) {
                this.channels = Objects.requireNonNull(channels, "Null channels");
            }

            @Override
            public int numberOfChannels() {
                return this.channels.length;
            }

            @Override
            public Class<?> elementType() {
                return java.lang.Long.TYPE;
            }

            @Override
            public double getChannel(int channelIndex) {
                return this.channels[channelIndex];
            }

            @Override
            public void setChannel(int channelIndex, double value) {
                this.hashCodeCalculated = false;
                this.channels[channelIndex] = (long)value;
            }

            @Override
            public void read(MultiMatrix multiMatrix, long indexInArray) {
                this.hashCodeCalculated = false;
                int n = multiMatrix.numberOfChannels();
                for (int k = 0; k < n; ++k) {
                    this.channels[k] = ((LongArray)multiMatrix.channelArray(k)).getLong(indexInArray);
                }
            }

            @Override
            public void write(MultiMatrix multiMatrix, long indexInArray) {
                int n = multiMatrix.numberOfChannels();
                for (int k = 0; k < n; ++k) {
                    ((UpdatableLongArray)multiMatrix.channelArray(k)).setLong(indexInArray, this.channels[k]);
                }
            }

            public String toString() {
                StringBuilder sb = new StringBuilder("long pixel [");
                for (int k = 0; k < this.channels.length; ++k) {
                    if (k > 0) {
                        sb.append(", ");
                    }
                    if (this.channels[k] == 0L) {
                        sb.append('0');
                        continue;
                    }
                    sb.append("0x").append(java.lang.Long.toHexString(this.channels[k]).toUpperCase());
                }
                return sb.append("]").toString();
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Long aLong = (Long)o;
                return Arrays.equals(this.channels, aLong.channels);
            }

            @Override
            Object channelsRef() {
                return this.channels;
            }

            @Override
            int hashCodeImpl() {
                return Arrays.hashCode(this.channels);
            }
        }

        public static class Float
        extends PixelValue {
            private final float[] channels;

            Float(float[] channels) {
                this.channels = Objects.requireNonNull(channels, "Null channels");
            }

            @Override
            public int numberOfChannels() {
                return this.channels.length;
            }

            @Override
            public Class<?> elementType() {
                return java.lang.Float.TYPE;
            }

            @Override
            public double getChannel(int channelIndex) {
                return this.channels[channelIndex];
            }

            @Override
            public void setChannel(int channelIndex, double value) {
                this.hashCodeCalculated = false;
                this.channels[channelIndex] = (float)value;
            }

            @Override
            public void read(MultiMatrix multiMatrix, long indexInArray) {
                this.hashCodeCalculated = false;
                int n = multiMatrix.numberOfChannels();
                for (int k = 0; k < n; ++k) {
                    this.channels[k] = ((FloatArray)multiMatrix.channelArray(k)).getFloat(indexInArray);
                }
            }

            @Override
            public void write(MultiMatrix multiMatrix, long indexInArray) {
                int n = multiMatrix.numberOfChannels();
                for (int k = 0; k < n; ++k) {
                    ((UpdatableFloatArray)multiMatrix.channelArray(k)).setFloat(indexInArray, this.channels[k]);
                }
            }

            public String toString() {
                return "float pixel " + Arrays.toString(this.channels);
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Float aFloat = (Float)o;
                return Arrays.equals(this.channels, aFloat.channels);
            }

            @Override
            Object channelsRef() {
                return this.channels;
            }

            @Override
            int hashCodeImpl() {
                return Arrays.hashCode(this.channels);
            }
        }

        public static class Double
        extends PixelValue {
            private final double[] channels;

            Double(double[] channels) {
                this.channels = Objects.requireNonNull(channels, "Null channels");
            }

            @Override
            public int numberOfChannels() {
                return this.channels.length;
            }

            @Override
            public Class<?> elementType() {
                return java.lang.Double.TYPE;
            }

            @Override
            public double getChannel(int channelIndex) {
                return this.channels[channelIndex];
            }

            @Override
            public void setChannel(int channelIndex, double value) {
                this.hashCodeCalculated = false;
                this.channels[channelIndex] = value;
            }

            @Override
            public void read(MultiMatrix multiMatrix, long indexInArray) {
                this.hashCodeCalculated = false;
                int n = multiMatrix.numberOfChannels();
                for (int k = 0; k < n; ++k) {
                    this.channels[k] = ((DoubleArray)multiMatrix.channelArray(k)).getDouble(indexInArray);
                }
            }

            @Override
            public void write(MultiMatrix multiMatrix, long indexInArray) {
                int n = multiMatrix.numberOfChannels();
                for (int k = 0; k < n; ++k) {
                    ((UpdatableDoubleArray)multiMatrix.channelArray(k)).setDouble(indexInArray, this.channels[k]);
                }
            }

            public String toString() {
                return "double pixel " + Arrays.toString(this.channels);
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Double aDouble = (Double)o;
                return Arrays.equals(this.channels, aDouble.channels);
            }

            @Override
            Object channelsRef() {
                return this.channels;
            }

            @Override
            int hashCodeImpl() {
                return Arrays.hashCode(this.channels);
            }
        }
    }
}

