/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import net.algart.arrays.DataFile;
import net.algart.arrays.DataFileModel;

public abstract class AbstractDataFileModel
implements DataFileModel<File> {
    protected final Set<DataFile> allTemporaryFiles = Collections.synchronizedSet(new HashSet());
    protected final File tempPath;
    protected final long prefixSize;

    protected AbstractDataFileModel() {
        this.tempPath = null;
        this.prefixSize = 0L;
    }

    protected AbstractDataFileModel(File tempPath, long prefixSize) {
        this.tempPath = tempPath;
        this.prefixSize = prefixSize;
    }

    @Override
    public Class<File> pathClass() {
        return File.class;
    }

    @Override
    public abstract DataFile getDataFile(File var1, ByteOrder var2);

    @Override
    public abstract File getPath(DataFile var1);

    @Override
    public DataFile createTemporary(boolean unresizable) {
        File fileName;
        try {
            fileName = this.createTemporaryFile(unresizable);
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
        DataFile result = this.getDataFile(fileName, this.byteOrderInTemporaryFiles());
        if (this.isAutoDeletionRequested()) {
            this.allTemporaryFiles.add(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(DataFile dataFile) {
        Objects.requireNonNull(dataFile, "Null dataFile argument");
        File f = this.getPath(dataFile);
        Set<DataFile> set = this.allTemporaryFiles;
        synchronized (set) {
            if (!f.exists()) {
                return false;
            }
            if (!f.delete()) {
                throw new IOError(new IOException("Cannot delete file " + String.valueOf(f)));
            }
            this.allTemporaryFiles.remove(dataFile);
            return true;
        }
    }

    @Override
    public void finalizationNotify(File dataFilePath, boolean isApplicationShutdown) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<DataFile> allTemporaryFiles() {
        TreeSet<DataFile> result = new TreeSet<DataFile>((o1, o2) -> this.getPath((DataFile)o1).compareTo(this.getPath((DataFile)o2)));
        Set<DataFile> set = this.allTemporaryFiles;
        synchronized (set) {
            result.addAll(this.allTemporaryFiles);
        }
        return result;
    }

    @Override
    public void setTemporary(DataFile dataFile, boolean value) {
        Objects.requireNonNull(dataFile, "Null dataFile argument");
        if (this.isAutoDeletionRequested()) {
            if (value) {
                this.allTemporaryFiles.add(dataFile);
            } else {
                this.allTemporaryFiles.remove(dataFile);
            }
        }
    }

    @Override
    public abstract boolean isAutoDeletionRequested();

    @Override
    public abstract int recommendedNumberOfBanks();

    @Override
    public abstract int recommendedBankSize(boolean var1);

    @Override
    public int recommendedSingleMappingLimit() {
        return 0;
    }

    @Override
    public long recommendedPrefixSize() {
        return this.prefixSize;
    }

    @Override
    public boolean autoResizingOnMapping() {
        return false;
    }

    public final File tempPath() {
        return this.tempPath;
    }

    public final boolean isConcreteFile() {
        return this.tempPath != null && (!this.tempPath.exists() || this.tempPath.isFile());
    }

    public String temporaryFilePrefix() {
        return "lmm";
    }

    protected File createTemporaryFile(boolean unresizable) throws IOException {
        if (this.isConcreteFile()) {
            this.tempPath.createNewFile();
            return this.tempPath.getAbsoluteFile();
        }
        Object prefix = this.temporaryFilePrefix();
        while (((String)prefix).length() < 3) {
            prefix = (String)prefix + "_";
        }
        String suffix = (unresizable ? ".uarray." : ".marray.") + (this.byteOrderInTemporaryFiles() == ByteOrder.BIG_ENDIAN ? "be.tmp" : "le.tmp");
        return File.createTempFile((String)prefix, suffix, this.tempPath).getAbsoluteFile();
    }

    protected ByteOrder byteOrderInTemporaryFiles() {
        return ByteOrder.nativeOrder();
    }
}

