/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.Objects;
import net.algart.arrays.AbstractArray;
import net.algart.arrays.Array;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.Arrays;
import net.algart.arrays.ArraysSubMatrixImpl;
import net.algart.arrays.ArraysTileMatrixImpl;
import net.algart.arrays.BitArray;
import net.algart.arrays.ByteArray;
import net.algart.arrays.CharArray;
import net.algart.arrays.DirectAccessible;
import net.algart.arrays.DoubleArray;
import net.algart.arrays.FloatArray;
import net.algart.arrays.IntArray;
import net.algart.arrays.InternalUtils;
import net.algart.arrays.JArrays;
import net.algart.arrays.LongArray;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.NotSubMatrixException;
import net.algart.arrays.NotTiledMatrixException;
import net.algart.arrays.ObjectArray;
import net.algart.arrays.PArray;
import net.algart.arrays.PFixedArray;
import net.algart.arrays.PFloatingArray;
import net.algart.arrays.PIntegerArray;
import net.algart.arrays.ShortArray;
import net.algart.arrays.SizeMismatchException;
import net.algart.arrays.TooLargeArrayException;
import net.algart.arrays.UpdatableArray;
import net.algart.arrays.UpdatableBitArray;
import net.algart.arrays.UpdatableByteArray;
import net.algart.arrays.UpdatableCharArray;
import net.algart.arrays.UpdatableDoubleArray;
import net.algart.arrays.UpdatableFloatArray;
import net.algart.arrays.UpdatableIntArray;
import net.algart.arrays.UpdatableLongArray;
import net.algart.arrays.UpdatableObjectArray;
import net.algart.arrays.UpdatableShortArray;
import net.algart.math.IRectangularArea;

public abstract class AbstractMatrix<T extends Array>
implements Matrix<T> {
    @Override
    public abstract T array();

    @Override
    public Class<?> elementType() {
        return this.array().elementType();
    }

    @Override
    public Class<? extends Array> type() {
        return this.array().type();
    }

    @Override
    public Class<? extends UpdatableArray> updatableType() {
        return this.array().updatableType();
    }

    @Override
    public <U extends Array> Class<? extends U> type(Class<U> arraySupertype) {
        Objects.requireNonNull(arraySupertype, "Null arraySupertype");
        if (UpdatableArray.class.isAssignableFrom(arraySupertype)) {
            throw new IllegalArgumentException("The passed arraySupertype, " + String.valueOf(arraySupertype) + ", is updatable, but the argument of Matrix.type method must define an immutable basic array type (" + PArray.class.getName() + ", " + PIntegerArray.class.getName() + ", etc.)");
        }
        Class<? extends Array> result = this.array().type();
        if (!arraySupertype.isAssignableFrom(result)) {
            throw new ClassCastException("The type of built-in array of this matrix " + result.getName() + " is not the same type or a subtype of the specified supertype: " + String.valueOf(arraySupertype) + " (this matrix is " + String.valueOf(this) + ")");
        }
        return (Class)InternalUtils.cast(result);
    }

    @Override
    public <U extends Array> Class<? extends U> updatableType(Class<U> arraySupertype) {
        Objects.requireNonNull(arraySupertype, "Null arraySupertype");
        Class<? extends UpdatableArray> result = this.array().updatableType();
        if (!arraySupertype.isAssignableFrom(result)) {
            throw new ClassCastException("The type of built-in array of this matrix " + result.getName() + " is not the same type or a subtype of the specified supertype: " + String.valueOf(arraySupertype) + " (this matrix is " + String.valueOf(this) + ")");
        }
        return (Class)InternalUtils.cast(result);
    }

    @Override
    public boolean isPrimitive() {
        return this.array() instanceof PArray;
    }

    @Override
    public boolean isFloatingPoint() {
        return this.array() instanceof PFloatingArray;
    }

    @Override
    public boolean isFixedPoint() {
        return this.array() instanceof PFixedArray;
    }

    @Override
    public boolean isUnsigned() {
        return Arrays.isUnsignedElementType(this.elementType());
    }

    @Override
    public long bitsPerElement() {
        T array = this.array();
        return array instanceof PArray ? ((PArray)array).bitsPerElement() : -1L;
    }

    @Override
    public double maxPossibleValue(double valueForFloatingPoint) {
        T array = this.array();
        return array instanceof PArray ? ((PArray)array).maxPossibleValue(valueForFloatingPoint) : Double.NaN;
    }

    @Override
    public double maxPossibleValue() {
        return this.maxPossibleValue(1.0);
    }

    @Override
    public abstract long[] dimensions();

    @Override
    public abstract int dimCount();

    @Override
    public abstract long dim(int var1);

    @Override
    public boolean dimEquals(Matrix<?> m) {
        Objects.requireNonNull(m, "Null matrix");
        int dimCount = this.dimCount();
        if (m.dimCount() != dimCount) {
            return false;
        }
        for (int k = 0; k < dimCount; ++k) {
            if (m.dim(k) == this.dim(k)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean dimEquals(long ... dimensions) {
        Objects.requireNonNull(dimensions, "Null dimensions argument");
        if (dimensions.length != this.dimCount()) {
            return false;
        }
        for (int k = 0; k < dimensions.length; ++k) {
            if (dimensions[k] == this.dim(k)) continue;
            return false;
        }
        return true;
    }

    @Override
    public long index(long ... coordinates) {
        long result;
        int n = coordinates.length;
        if (n == 0) {
            throw new IllegalArgumentException("Empty coordinates array");
        }
        if ((result = coordinates[--n]) < 0L || result >= this.dim(n)) {
            throw new IndexOutOfBoundsException("Coordinate #" + n + " (" + result + (String)(result < 0L ? ") < 0" : ") >= dim(" + n + ") (" + this.dim(n) + ")") + " in " + String.valueOf(this));
        }
        while (n > 0) {
            long coord = coordinates[--n];
            long limit = this.dim(n);
            if (coord < 0L || coord >= limit) {
                throw new IndexOutOfBoundsException("Coordinate #" + n + " (" + coord + (String)(coord < 0L ? ") < 0" : ") >= dim(" + n + ") (" + limit + ")") + " in " + String.valueOf(this));
            }
            result = limit * result + coord;
        }
        return result;
    }

    @Override
    public long index(long x, long y) {
        long dimX = this.dim(0);
        long dimY = this.dim(1);
        if (x < 0L || x >= dimX) {
            throw new IndexOutOfBoundsException("X-coordinate (" + x + (String)(x < 0L ? ") < 0" : ") >= dim(0) (" + dimX + ")") + " in " + String.valueOf(this));
        }
        if (y < 0L || y >= dimY) {
            throw new IndexOutOfBoundsException("Y-coordinate (" + y + (String)(y < 0L ? ") < 0" : ") >= dim(1) (" + dimY + ")") + " in " + String.valueOf(this));
        }
        return y * dimX + x;
    }

    @Override
    public long index(long x, long y, long z) {
        long dimX = this.dim(0);
        long dimY = this.dim(1);
        long dimZ = this.dim(2);
        if (x < 0L || x >= dimX) {
            throw new IndexOutOfBoundsException("X-coordinate (" + x + (String)(x < 0L ? ") < 0" : ") >= dim(0) (" + dimX + ")") + " in " + String.valueOf(this));
        }
        if (y < 0L || y >= dimY) {
            throw new IndexOutOfBoundsException("Y-coordinate (" + y + (String)(y < 0L ? ") < 0" : ") >= dim(1) (" + dimY + ")") + " in " + String.valueOf(this));
        }
        if (z < 0L || z >= dimZ) {
            throw new IndexOutOfBoundsException("Z-coordinate (" + z + (String)(z < 0L ? ") < 0" : ") >= dim(2) (" + dimZ + ")") + " in " + String.valueOf(this));
        }
        return (z * dimY + y) * dimX + x;
    }

    @Override
    public long[] coordinates(long index, long[] result) {
        if (index < 0L) {
            throw new IndexOutOfBoundsException("Negative index argument");
        }
        int dimCount = this.dimCount();
        if (result == null) {
            result = new long[dimCount];
        } else if (result.length < dimCount) {
            throw new IllegalArgumentException("Too short result array: long[" + result.length + "]; " + dimCount + " elements required to store coordinates");
        }
        long a = index;
        for (int k = 0; k < dimCount - 1; ++k) {
            long dim = this.dim(k);
            long b = a / dim;
            result[k] = a - b * dim;
            a = b;
        }
        long dim = this.dim(dimCount - 1);
        if (a >= dim) {
            throw new IndexOutOfBoundsException("Too large index argument: " + index + " >= matrix size " + JArrays.toString(this.dimensions(), "*", 10000));
        }
        result[dimCount - 1] = a;
        return result;
    }

    @Override
    public long uncheckedIndex(long ... coordinates) {
        int n = coordinates.length;
        if (n == 0) {
            throw new IllegalArgumentException("Empty coordinates array");
        }
        long result = coordinates[--n];
        while (n > 0) {
            result = this.dim(--n) * result + coordinates[n];
        }
        return result;
    }

    @Override
    public long cyclicIndex(long ... coordinates) {
        int n = coordinates.length;
        if (n == 0) {
            throw new IllegalArgumentException("Empty coordinates array");
        }
        long result = coordinates[--n];
        long limit = this.dim(n);
        long l = result = limit == 0L ? 0L : result % limit;
        if (result < 0L) {
            result += limit;
        }
        while (n > 0) {
            long coord = coordinates[--n];
            limit = this.dim(n);
            long l2 = coord = limit == 0L ? 0L : coord % limit;
            if (coord < 0L) {
                coord += limit;
            }
            result = limit * result + coord;
        }
        return result;
    }

    @Override
    public long pseudoCyclicIndex(long ... coordinates) {
        int n = coordinates.length;
        if (n == 0) {
            throw new IllegalArgumentException("Empty coordinates array");
        }
        --n;
        if (this.isEmpty()) {
            return 0L;
        }
        long limit = this.dim(n);
        long result = coordinates[n] % limit;
        if (result < 0L) {
            result += limit;
        }
        while (n > 0) {
            long dim;
            if ((dim = this.dim(--n)) == 0L) {
                return 0L;
            }
            long coord = coordinates[n] % (limit *= dim);
            if (coord < 0L) {
                coord += limit;
            }
            assert ((result *= dim) >= 0L) : "cyclic index becomes " + result + ", n=" + n + " in " + String.valueOf(this);
            if ((result += coord) < 0L || result >= limit) assert ((result -= limit) >= 0L) : "cyclic index becomes " + result + ", n=" + n + " in " + String.valueOf(this);
        }
        return result;
    }

    @Override
    public long mirrorCyclicIndex(long ... coordinates) {
        int n = coordinates.length;
        if (n == 0) {
            throw new IllegalArgumentException("Empty coordinates array");
        }
        long result = coordinates[--n];
        long limit = this.dim(n);
        long l = result = limit == 0L ? 0L : AbstractMatrix.normalizeMirrorCoord(result, limit);
        while (n > 0) {
            long coord = coordinates[--n];
            limit = this.dim(n);
            coord = limit == 0L ? 0L : AbstractMatrix.normalizeMirrorCoord(coord, limit);
            result = limit * result + coord;
        }
        return result;
    }

    @Override
    public boolean inside(long ... coordinates) {
        if (coordinates.length == 0) {
            throw new IllegalArgumentException("Empty coordinates array");
        }
        for (int k = 0; k < coordinates.length; ++k) {
            long coord = coordinates[k];
            if (coord >= 0L && coord < this.dim(k)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean inside(long x, long y) {
        return x >= 0L && x < this.dim(0) && y >= 0L && y < this.dim(1);
    }

    @Override
    public boolean inside(long x, long y, long z) {
        return x >= 0L && x < this.dim(0) && y >= 0L && y < this.dim(1) && z >= 0L && z < this.dim(2);
    }

    @Override
    public abstract <U extends Array> Matrix<U> matrix(U var1);

    @Override
    public <U extends Array> Matrix<U> cast(Class<U> arrayClass) {
        if (!arrayClass.isInstance(this.array())) {
            throw new ClassCastException("Cannot cast " + String.valueOf(this.array().getClass()) + " (" + String.valueOf(this.array()) + ") to the type " + arrayClass.getName());
        }
        return (Matrix)InternalUtils.cast(this);
    }

    @Override
    public Matrix<T> subMatrix(long[] from, long[] to) {
        return this.subMatrix(from, to, Matrix.ContinuationMode.NONE, true);
    }

    @Override
    public Matrix<T> subMatrix(IRectangularArea area) {
        Objects.requireNonNull(area, "Null area argument");
        long[] from = area.min().coordinates();
        long[] to = area.max().coordinates();
        int k = 0;
        while (k < to.length) {
            int n = k++;
            to[n] = to[n] + 1L;
        }
        return this.subMatrix(from, to, Matrix.ContinuationMode.NONE, false);
    }

    @Override
    public Matrix<T> subMatrix(long fromX, long fromY, long toX, long toY) {
        return this.subMatrix(new long[]{fromX, fromY}, new long[]{toX, toY}, Matrix.ContinuationMode.NONE, false);
    }

    @Override
    public Matrix<T> subMatrix(long fromX, long fromY, long fromZ, long toX, long toY, long toZ) {
        return this.subMatrix(new long[]{fromX, fromY, fromZ}, new long[]{toX, toY, toZ}, Matrix.ContinuationMode.NONE, false);
    }

    @Override
    public Matrix<T> subMatrix(long[] from, long[] to, Matrix.ContinuationMode continuationMode) {
        return this.subMatrix(from, to, continuationMode, true);
    }

    @Override
    public Matrix<T> subMatrix(IRectangularArea area, Matrix.ContinuationMode continuationMode) {
        Objects.requireNonNull(area, "Null area argument");
        long[] from = area.min().coordinates();
        long[] to = area.max().coordinates();
        int k = 0;
        while (k < to.length) {
            int n = k++;
            to[n] = to[n] + 1L;
        }
        return this.subMatrix(from, to, continuationMode, false);
    }

    @Override
    public Matrix<T> subMatrix(long fromX, long fromY, long toX, long toY, Matrix.ContinuationMode continuationMode) {
        return this.subMatrix(new long[]{fromX, fromY}, new long[]{toX, toY}, continuationMode, false);
    }

    @Override
    public Matrix<T> subMatrix(long fromX, long fromY, long fromZ, long toX, long toY, long toZ, Matrix.ContinuationMode continuationMode) {
        return this.subMatrix(new long[]{fromX, fromY, fromZ}, new long[]{toX, toY, toZ}, continuationMode, false);
    }

    @Override
    public Matrix<T> subMatr(long[] position, long[] dimensions) {
        return this.subMatr(position, dimensions, Matrix.ContinuationMode.NONE, true);
    }

    @Override
    public Matrix<T> subMatr(long x, long y, long dimX, long dimY) {
        return this.subMatr(new long[]{x, y}, new long[]{dimX, dimY}, Matrix.ContinuationMode.NONE, false);
    }

    @Override
    public Matrix<T> subMatr(long x, long y, long z, long dimX, long dimY, long dimZ) {
        return this.subMatr(new long[]{x, y, z}, new long[]{dimX, dimY, dimZ}, Matrix.ContinuationMode.NONE, false);
    }

    @Override
    public Matrix<T> subMatr(long[] position, long[] dimensions, Matrix.ContinuationMode continuationMode) {
        return this.subMatr(position, dimensions, continuationMode, true);
    }

    @Override
    public Matrix<T> subMatr(long x, long y, long dimX, long dimY, Matrix.ContinuationMode continuationMode) {
        return this.subMatr(new long[]{x, y}, new long[]{dimX, dimY}, continuationMode, false);
    }

    @Override
    public Matrix<T> subMatr(long x, long y, long z, long dimX, long dimY, long dimZ, Matrix.ContinuationMode continuationMode) {
        return this.subMatr(new long[]{x, y, z}, new long[]{dimX, dimY, dimZ}, continuationMode, false);
    }

    @Override
    public boolean isSubMatrix() {
        return this.array() instanceof ArraysSubMatrixImpl.SubMatrixArray;
    }

    @Override
    public Matrix<T> subMatrixParent() {
        T a = this.array();
        if (!(a instanceof ArraysSubMatrixImpl.SubMatrixArray)) {
            throw new NotSubMatrixException("subMatrixParent() method must not be called for non-submatrix: " + String.valueOf(this));
        }
        Matrix<? extends Array> result = ((ArraysSubMatrixImpl.SubMatrixArray)a).baseMatrix();
        return (Matrix)InternalUtils.cast(result);
    }

    @Override
    public long[] subMatrixFrom() {
        T a = this.array();
        if (!(a instanceof ArraysSubMatrixImpl.SubMatrixArray)) {
            throw new NotSubMatrixException("subMatrixFrom() method must not be called for non-submatrix: " + String.valueOf(this));
        }
        return ((ArraysSubMatrixImpl.SubMatrixArray)a).from();
    }

    @Override
    public long[] subMatrixTo() {
        T a = this.array();
        if (!(a instanceof ArraysSubMatrixImpl.SubMatrixArray)) {
            throw new NotSubMatrixException("subMatrixTo() method must not be called for non-submatrix: " + String.valueOf(this));
        }
        return ((ArraysSubMatrixImpl.SubMatrixArray)a).to();
    }

    @Override
    public Matrix.ContinuationMode subMatrixContinuationMode() {
        T a = this.array();
        if (!(a instanceof ArraysSubMatrixImpl.SubMatrixArray)) {
            throw new NotSubMatrixException("subMatrixContinuationMode() method must not be called for non-submatrix: " + String.valueOf(this));
        }
        return ((ArraysSubMatrixImpl.SubMatrixArray)a).continuationMode();
    }

    @Override
    public Matrix<T> structureLike(Matrix<?> m) {
        return m.isTiled() ? this.tile(m.tileDimensions()) : this;
    }

    @Override
    public boolean isStructuredLike(Matrix<?> m) {
        return m.isTiled() == this.isTiled();
    }

    @Override
    public Matrix<T> tile(long ... tileDim) {
        AbstractArray result;
        Objects.requireNonNull(tileDim, "Null tile dimensions Java array");
        T a = this.array();
        if (a instanceof UpdatableBitArray) {
            Matrix m = (Matrix)InternalUtils.cast(this);
            result = new ArraysTileMatrixImpl.TileMatrixUpdatableBitArray(m, tileDim);
        } else if (a instanceof BitArray) {
            Matrix m = (Matrix)InternalUtils.cast(this);
            result = new ArraysTileMatrixImpl.TileMatrixBitArray(m, tileDim);
        } else if (a instanceof UpdatableCharArray) {
            Matrix m = (Matrix)InternalUtils.cast(this);
            result = new ArraysTileMatrixImpl.TileMatrixUpdatableCharArray(m, tileDim);
        } else if (a instanceof CharArray) {
            Matrix m = (Matrix)InternalUtils.cast(this);
            result = new ArraysTileMatrixImpl.TileMatrixCharArray(m, tileDim);
        } else if (a instanceof UpdatableByteArray) {
            Matrix m = (Matrix)InternalUtils.cast(this);
            result = new ArraysTileMatrixImpl.TileMatrixUpdatableByteArray(m, tileDim);
        } else if (a instanceof ByteArray) {
            Matrix m = (Matrix)InternalUtils.cast(this);
            result = new ArraysTileMatrixImpl.TileMatrixByteArray(m, tileDim);
        } else if (a instanceof UpdatableShortArray) {
            Matrix m = (Matrix)InternalUtils.cast(this);
            result = new ArraysTileMatrixImpl.TileMatrixUpdatableShortArray(m, tileDim);
        } else if (a instanceof ShortArray) {
            Matrix m = (Matrix)InternalUtils.cast(this);
            result = new ArraysTileMatrixImpl.TileMatrixShortArray(m, tileDim);
        } else if (a instanceof UpdatableIntArray) {
            Matrix m = (Matrix)InternalUtils.cast(this);
            result = new ArraysTileMatrixImpl.TileMatrixUpdatableIntArray(m, tileDim);
        } else if (a instanceof IntArray) {
            Matrix m = (Matrix)InternalUtils.cast(this);
            result = new ArraysTileMatrixImpl.TileMatrixIntArray(m, tileDim);
        } else if (a instanceof UpdatableLongArray) {
            Matrix m = (Matrix)InternalUtils.cast(this);
            result = new ArraysTileMatrixImpl.TileMatrixUpdatableLongArray(m, tileDim);
        } else if (a instanceof LongArray) {
            Matrix m = (Matrix)InternalUtils.cast(this);
            result = new ArraysTileMatrixImpl.TileMatrixLongArray(m, tileDim);
        } else if (a instanceof UpdatableFloatArray) {
            Matrix m = (Matrix)InternalUtils.cast(this);
            result = new ArraysTileMatrixImpl.TileMatrixUpdatableFloatArray(m, tileDim);
        } else if (a instanceof FloatArray) {
            Matrix m = (Matrix)InternalUtils.cast(this);
            result = new ArraysTileMatrixImpl.TileMatrixFloatArray(m, tileDim);
        } else if (a instanceof UpdatableDoubleArray) {
            Matrix m = (Matrix)InternalUtils.cast(this);
            result = new ArraysTileMatrixImpl.TileMatrixUpdatableDoubleArray(m, tileDim);
        } else if (a instanceof DoubleArray) {
            Matrix m = (Matrix)InternalUtils.cast(this);
            result = new ArraysTileMatrixImpl.TileMatrixDoubleArray(m, tileDim);
        } else if (a instanceof UpdatableObjectArray) {
            Matrix m = (Matrix)InternalUtils.cast(this);
            result = new ArraysTileMatrixImpl.TileMatrixUpdatableObjectArray(m, tileDim);
        } else if (a instanceof ObjectArray) {
            Matrix m = (Matrix)InternalUtils.cast(this);
            result = new ArraysTileMatrixImpl.TileMatrixObjectArray(m, tileDim);
        } else {
            throw new AssertionError((Object)("Unallowed type of built-in array: " + String.valueOf(a.getClass()) + " in " + String.valueOf(this)));
        }
        return this.matrix((Array)InternalUtils.cast(result));
    }

    @Override
    public Matrix<T> tile() {
        return this.tile(Matrices.defaultTileDimensions(this.dimCount()));
    }

    @Override
    public Matrix<T> tileParent() {
        T a = this.array();
        if (!(a instanceof ArraysTileMatrixImpl.TileMatrixArray)) {
            throw new NotTiledMatrixException("tileParent() method must not be called for non-tiled matrix: " + String.valueOf(this));
        }
        Matrix<? extends Array> result = ((ArraysTileMatrixImpl.TileMatrixArray)a).baseMatrix();
        return (Matrix)InternalUtils.cast(result);
    }

    @Override
    public long[] tileDimensions() {
        T a = this.array();
        if (!(a instanceof ArraysTileMatrixImpl.TileMatrixArray)) {
            throw new NotTiledMatrixException("tileDimensions() method must not be called for non-tiled matrix: " + String.valueOf(this));
        }
        return ((ArraysTileMatrixImpl.TileMatrixArray)a).tileDimensions();
    }

    @Override
    public boolean isTiled() {
        return Arrays.isTiled(this.array());
    }

    @Override
    public boolean isImmutable() {
        return this.array().isImmutable();
    }

    @Override
    public boolean isCopyOnNextWrite() {
        return this.array().isCopyOnNextWrite();
    }

    @Override
    public boolean isDirectAccessible() {
        T a = this.array();
        return a instanceof DirectAccessible && ((DirectAccessible)a).hasJavaArray();
    }

    @Override
    public Matrix<T> clone() {
        return this.clone(null);
    }

    @Override
    public Matrix<T> clone(ArrayContext context) {
        MemoryModel memoryModel = context == null ? Arrays.SMM : context.getMemoryModel();
        Matrix<UpdatableArray> result = memoryModel.newMatrix(UpdatableArray.class, this);
        Matrices.copy(context, result, this);
        return (Matrix)InternalUtils.cast(result);
    }

    @Override
    public void flushResources(ArrayContext context) {
        this.array().flushResources(context);
    }

    @Override
    public void freeResources(ArrayContext context) {
        this.array().freeResources(context);
    }

    @Override
    public void freeResources() {
        this.array().freeResources();
    }

    @Override
    public String toString() {
        return "matrix " + Matrices.dimensionsToString(this.dimensions()) + " on " + String.valueOf(this.array());
    }

    @Override
    public int hashCode() {
        return JArrays.arrayHashCode(this.dimensions(), 0, this.dimCount()) * 31 + this.array().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Matrix)) {
            return false;
        }
        Matrix m = (Matrix)obj;
        return this.dimEquals(m) && m.array().equals(this.array());
    }

    static long normalizeMirrorCoord(long coord, long dim) {
        boolean mirror;
        long repeatIndex = coord / dim;
        boolean bl = mirror = (repeatIndex & 1L) != 0L;
        if ((coord -= dim * repeatIndex) < 0L) {
            return mirror ? coord + dim : -coord - 1L;
        }
        return mirror ? dim - 1L - coord : coord;
    }

    static long checkDimensions(long[] dim) throws IllegalArgumentException {
        Objects.requireNonNull(dim, "Null dimensions Java array");
        if (dim.length == 0) {
            throw new IllegalArgumentException("Empty dimensions Java array");
        }
        for (int k = 0; k < dim.length; ++k) {
            if (dim[k] >= 0L) continue;
            throw new IllegalArgumentException("Negative matrix dimension #" + k + ": " + dim[k]);
        }
        long len = Arrays.longMul(dim);
        if (len == Long.MIN_VALUE) {
            throw new TooLargeArrayException("Too large dimensions: dim[0] * dim[1] * ... > Long.MAX_VALUE");
        }
        return len;
    }

    static void checkDimensions(long[] dim, long len) throws IllegalArgumentException {
        long correctLen = AbstractMatrix.checkDimensions(dim);
        if (correctLen != len) {
            throw new SizeMismatchException("Dimensions / length mismatch: dim[0] * dim[1] * ...  = " + correctLen + ", but the array length = " + len);
        }
    }

    private Matrix<T> subMatrix(long[] from, long[] to, Matrix.ContinuationMode continuationMode, boolean needCloning) {
        Objects.requireNonNull(from, "Null from[] Java array");
        Objects.requireNonNull(to, "Null to[] Java array");
        Objects.requireNonNull(continuationMode, "Null continuation mode");
        if (from.length != this.dimCount()) {
            throw new IllegalArgumentException("Illegal number of from[] elements: " + from.length + " instead " + this.dimCount());
        }
        if (to.length != from.length) {
            throw new IllegalArgumentException("Illegal number of to[] elements: " + to.length + " instead " + this.dimCount());
        }
        long[] dimensions = new long[from.length];
        if (needCloning) {
            from = (long[])from.clone();
        }
        for (int k = 0; k < from.length; ++k) {
            long tok = to[k];
            if (from[k] > tok) {
                throw new IndexOutOfBoundsException("Negative number of elements: from[" + k + "] = " + from[k] + " > to[" + k + "] = " + tok + " (start and end submatrix coordinate in the matrix " + String.valueOf(this) + ")");
            }
            dimensions[k] = tok - from[k];
            if (dimensions[k] >= 0L) continue;
            throw new IllegalArgumentException("Too large number of elements: to[" + k + "] - from[" + k + "] > Long.MAX_VALUE  (end and start submatrix coordinate in the matrix " + String.valueOf(this) + ")");
        }
        return this.subMatr(from, dimensions, continuationMode, false);
    }

    private Matrix<T> subMatr(long[] position, long[] dimensions, Matrix.ContinuationMode continuationMode, boolean needCloning) {
        AbstractArray result;
        Objects.requireNonNull(position, "Null position argument");
        Objects.requireNonNull(dimensions, "Null dimensions argument");
        Objects.requireNonNull(continuationMode, "Null continuation mode");
        T a = this.array();
        Object outsideValue = Matrices.castOutsideValue(continuationMode.isConstant() ? continuationMode.continuationConstant() : null, a);
        if (needCloning) {
            position = (long[])position.clone();
            dimensions = (long[])dimensions.clone();
        }
        if (continuationMode == Matrix.ContinuationMode.NONE && Arrays.isNCopies(this.array())) {
            long len = ArraysSubMatrixImpl.checkBounds(this, position, dimensions, Matrix.ContinuationMode.NONE);
            return (Matrix)InternalUtils.cast(Matrices.matrix(this.array().subArr(0L, len), dimensions));
        }
        if (a instanceof UpdatableBitArray) {
            Matrix m = (Matrix)InternalUtils.cast(this);
            result = new ArraysSubMatrixImpl.SubMatrixUpdatableBitArray(m, position, dimensions, (Boolean)outsideValue, continuationMode);
        } else if (a instanceof BitArray) {
            Matrix m = (Matrix)InternalUtils.cast(this);
            result = new ArraysSubMatrixImpl.SubMatrixBitArray(m, position, dimensions, (Boolean)outsideValue, continuationMode);
        } else if (a instanceof UpdatableCharArray) {
            Matrix m = (Matrix)InternalUtils.cast(this);
            result = new ArraysSubMatrixImpl.SubMatrixUpdatableCharArray(m, position, dimensions, ((Character)outsideValue).charValue(), continuationMode);
        } else if (a instanceof CharArray) {
            Matrix m = (Matrix)InternalUtils.cast(this);
            result = new ArraysSubMatrixImpl.SubMatrixCharArray(m, position, dimensions, ((Character)outsideValue).charValue(), continuationMode);
        } else if (a instanceof UpdatableByteArray) {
            Matrix m = (Matrix)InternalUtils.cast(this);
            result = new ArraysSubMatrixImpl.SubMatrixUpdatableByteArray(m, position, dimensions, (Byte)outsideValue, continuationMode);
        } else if (a instanceof ByteArray) {
            Matrix m = (Matrix)InternalUtils.cast(this);
            result = new ArraysSubMatrixImpl.SubMatrixByteArray(m, position, dimensions, (Byte)outsideValue, continuationMode);
        } else if (a instanceof UpdatableShortArray) {
            Matrix m = (Matrix)InternalUtils.cast(this);
            result = new ArraysSubMatrixImpl.SubMatrixUpdatableShortArray(m, position, dimensions, (Short)outsideValue, continuationMode);
        } else if (a instanceof ShortArray) {
            Matrix m = (Matrix)InternalUtils.cast(this);
            result = new ArraysSubMatrixImpl.SubMatrixShortArray(m, position, dimensions, (Short)outsideValue, continuationMode);
        } else if (a instanceof UpdatableIntArray) {
            Matrix m = (Matrix)InternalUtils.cast(this);
            result = new ArraysSubMatrixImpl.SubMatrixUpdatableIntArray(m, position, dimensions, (Integer)outsideValue, continuationMode);
        } else if (a instanceof IntArray) {
            Matrix m = (Matrix)InternalUtils.cast(this);
            result = new ArraysSubMatrixImpl.SubMatrixIntArray(m, position, dimensions, (Integer)outsideValue, continuationMode);
        } else if (a instanceof UpdatableLongArray) {
            Matrix m = (Matrix)InternalUtils.cast(this);
            result = new ArraysSubMatrixImpl.SubMatrixUpdatableLongArray(m, position, dimensions, (Long)outsideValue, continuationMode);
        } else if (a instanceof LongArray) {
            Matrix m = (Matrix)InternalUtils.cast(this);
            result = new ArraysSubMatrixImpl.SubMatrixLongArray(m, position, dimensions, (Long)outsideValue, continuationMode);
        } else if (a instanceof UpdatableFloatArray) {
            Matrix m = (Matrix)InternalUtils.cast(this);
            result = new ArraysSubMatrixImpl.SubMatrixUpdatableFloatArray(m, position, dimensions, ((Float)outsideValue).floatValue(), continuationMode);
        } else if (a instanceof FloatArray) {
            Matrix m = (Matrix)InternalUtils.cast(this);
            result = new ArraysSubMatrixImpl.SubMatrixFloatArray(m, position, dimensions, ((Float)outsideValue).floatValue(), continuationMode);
        } else if (a instanceof UpdatableDoubleArray) {
            Matrix m = (Matrix)InternalUtils.cast(this);
            result = new ArraysSubMatrixImpl.SubMatrixUpdatableDoubleArray(m, position, dimensions, (Double)outsideValue, continuationMode);
        } else if (a instanceof DoubleArray) {
            Matrix m = (Matrix)InternalUtils.cast(this);
            result = new ArraysSubMatrixImpl.SubMatrixDoubleArray(m, position, dimensions, (Double)outsideValue, continuationMode);
        } else if (a instanceof UpdatableObjectArray) {
            Matrix m = (Matrix)InternalUtils.cast(this);
            result = new ArraysSubMatrixImpl.SubMatrixUpdatableObjectArray<Object>(m, position, dimensions, outsideValue, continuationMode);
        } else if (a instanceof ObjectArray) {
            Matrix m = (Matrix)InternalUtils.cast(this);
            result = new ArraysSubMatrixImpl.SubMatrixObjectArray<Object>(m, position, dimensions, outsideValue, continuationMode);
        } else {
            throw new AssertionError((Object)("Unallowed type of built-in array: " + String.valueOf(a.getClass()) + " in " + String.valueOf(this)));
        }
        return Matrices.matrix((Array)InternalUtils.cast(result), dimensions);
    }
}

