/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.Objects;
import net.algart.arrays.AbstractArrayContext;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.arrays.ThreadPoolFactory;

public interface ArrayContext {
    public static final ArrayContext DEFAULT = new AbstractArrayContext.Default();
    public static final ArrayContext DEFAULT_SINGLE_THREAD = new AbstractArrayContext.DefaultSingleThread();

    public static ArrayContext getSimpleContext(MemoryModel memoryModel, boolean multithreading) {
        if (memoryModel instanceof SimpleMemoryModel) {
            return multithreading ? DEFAULT : DEFAULT_SINGLE_THREAD;
        }
        return multithreading ? new AbstractArrayContext.Default(memoryModel) : new AbstractArrayContext.DefaultSingleThread(memoryModel);
    }

    public ArrayContext part(double var1, double var3);

    public ArrayContext part(long var1, long var3, long var5);

    public ArrayContext part(int var1, int var2, int var3);

    public ArrayContext noProgressVersion();

    public ArrayContext singleThreadVersion();

    public ArrayContext multithreadingVersion(int var1, int var2);

    public ArrayContext customDataVersion(Object var1);

    public MemoryModel getMemoryModel();

    public ThreadPoolFactory getThreadPoolFactory();

    public void checkInterruption() throws RuntimeException;

    public void updateProgress(Event var1);

    public void checkInterruptionAndUpdateProgress(Class<?> var1, long var2, long var4);

    public int currentThreadIndex();

    public int numberOfThreads();

    public Object customData();

    public static class Event {
        private final Class<?> elementType;
        private final long[] lengthPerTask;
        private final long length;
        private final long[] readyCountPerTask;
        private final long readyCount;
        private final int numberOfParallelTasks;

        public Event(Class<?> elementType, long readyCount, long length) {
            this(elementType, new long[]{readyCount}, new long[]{length});
        }

        public Event(Class<?> elementType, long[] readyCountPerTask, long[] lengthPerTask) {
            Objects.requireNonNull(readyCountPerTask, "Null readyCountPerTask argument");
            Objects.requireNonNull(lengthPerTask, "Null lengthPerTask argument");
            if (lengthPerTask.length != readyCountPerTask.length) {
                throw new IllegalArgumentException("lengthPerTask and readyCountPerTask have different lengths");
            }
            if (lengthPerTask.length == 0) {
                throw new IllegalArgumentException("Zero number of tasks (lengthPerTask.length and readyCountPerTask.length)");
            }
            long sumLength = 0L;
            long sumCount = 0L;
            for (int k = 0; k < lengthPerTask.length; ++k) {
                Object perTask;
                long length = lengthPerTask[k];
                long count = readyCountPerTask[k];
                Object object = perTask = lengthPerTask.length == 1 ? "" : "PerTask[" + k + "]";
                if (length < 0L) {
                    throw new IllegalArgumentException("Negative length" + (String)perTask);
                }
                if (count < 0L) {
                    throw new IllegalArgumentException("Negative readyCount" + (String)perTask);
                }
                if (count > length) {
                    throw new IllegalArgumentException("readyCount" + (String)perTask + "=" + count + " is greater than length" + (String)perTask + "=" + length);
                }
                if ((sumLength += length) < 0L) {
                    throw new IllegalArgumentException("Sum of all lengthPerTask is greater than Long.MAX_VALUE");
                }
                assert ((sumCount += count) >= 0L);
            }
            this.elementType = elementType;
            this.readyCountPerTask = (long[])readyCountPerTask.clone();
            this.readyCount = sumCount;
            this.lengthPerTask = (long[])lengthPerTask.clone();
            this.length = sumLength;
            this.numberOfParallelTasks = readyCountPerTask.length;
        }

        public Class<?> elementType() {
            return this.elementType;
        }

        public long[] lengthPerTask() {
            return (long[])this.lengthPerTask.clone();
        }

        public long length() {
            return this.length;
        }

        public long[] readyCountPerTask() {
            return (long[])this.readyCountPerTask.clone();
        }

        public long readyCount() {
            return this.readyCount;
        }

        public int numberOfParallelTasks() {
            return this.numberOfParallelTasks;
        }

        public double readyPart() {
            return this.length == 0L || this.readyCount == this.length ? 1.0 : (double)this.readyCount / (double)this.length;
        }
    }
}

