/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.Objects;
import net.algart.arrays.ArrayComparator;
import net.algart.arrays.ArrayComparator32;
import net.algart.arrays.ArrayExchanger;
import net.algart.arrays.ArrayExchanger32;

public abstract class ArraySorter {
    private ArraySorter() {
    }

    public static ArraySorter getInsertionSorter() {
        return InsertionSorter.INSERTION_SORTER;
    }

    public static ArraySorter getShellSorter() {
        return ShellSorter.SHELL_SORTER;
    }

    public static ArraySorter getQuickSorter() {
        return QuickSorter.QUICK_SORTER;
    }

    public static boolean areIndexesSorted(int[] indexes, int from, int to, ArrayComparator comparator) {
        Objects.requireNonNull(comparator, "Null comparator argument");
        ArraySorter.check(indexes, from, to);
        for (int k = from; k < to - 1; ++k) {
            if (!comparator.less(indexes[k + 1], indexes[k])) continue;
            return false;
        }
        return true;
    }

    public static boolean areSorted(long from, long to, ArrayComparator comparator) {
        Objects.requireNonNull(comparator, "Null comparator argument");
        ArraySorter.check(from, to);
        for (long k = from; k < to - 1L; ++k) {
            if (!comparator.less(k + 1L, k)) continue;
            return false;
        }
        return true;
    }

    public abstract void sortIndexes(int[] var1, int var2, int var3, ArrayComparator var4);

    public void sortIndexes(int[] indexes, int from, int to, ArrayComparator32 comparator) {
        this.sortIndexes(indexes, from, to, (ArrayComparator)comparator);
    }

    public abstract void sort(long var1, long var3, ArrayComparator var5, ArrayExchanger var6);

    public void sort(int from, int to, ArrayComparator32 comparator, ArrayExchanger32 exchanger) {
        this.sort((long)from, (long)to, (ArrayComparator)comparator, (ArrayExchanger)exchanger);
    }

    public boolean isExchangingSorter() {
        return true;
    }

    static void insertionSortIndexesWithoutChecks(int[] indexes, int from, int to, ArrayComparator comparator) {
        for (int i = from + 1; i < to; ++i) {
            int index = indexes[i];
            for (int j = i - 1; j >= from && comparator.less(index, indexes[j]); --j) {
                indexes[j + 1] = indexes[j];
            }
            indexes[j + 1] = index;
        }
    }

    static void insertionSortWithoutChecks(long from, long to, ArrayComparator comparator, ArrayExchanger exchanger) {
        for (long i = from + 1L; i < to; ++i) {
            for (long j = i - 1L; j >= from && comparator.less(j + 1L, j); --j) {
                exchanger.swap(j, j + 1L);
            }
        }
    }

    static void check(long from, long to) {
        if (from < 0L || from > to) {
            throw new IllegalArgumentException("Illegal from (" + from + ") or to (" + to + ") arguments: should be 0 <= from <= to");
        }
    }

    static void check(int[] indexes, int from, int to) {
        Objects.requireNonNull(indexes, "Null indexes argument");
        ArraySorter.check(from, to);
        if (to > indexes.length) {
            throw new IllegalArgumentException("The sorted range " + from + ".." + to + " is out of indexes array int[" + indexes.length + "]");
        }
    }

    static class InsertionSorter
    extends ArraySorter {
        static final ArraySorter INSERTION_SORTER = new InsertionSorter();

        InsertionSorter() {
        }

        @Override
        public void sortIndexes(int[] indexes, int from, int to, ArrayComparator comparator) {
            Objects.requireNonNull(comparator, "Null comparator argument");
            InsertionSorter.check(indexes, from, to);
            InsertionSorter.insertionSortIndexesWithoutChecks(indexes, from, to, comparator);
        }

        @Override
        public void sort(long from, long to, ArrayComparator comparator, ArrayExchanger exchanger) {
            Objects.requireNonNull(comparator, "Null comparator argument");
            Objects.requireNonNull(exchanger, "Null exchanger argument");
            InsertionSorter.check(from, to);
            InsertionSorter.insertionSortWithoutChecks(from, to, comparator, exchanger);
        }

        public String toString() {
            return "Insertion sorting algorithm";
        }
    }

    static class ShellSorter
    extends ArraySorter {
        static final ArraySorter SHELL_SORTER = new ShellSorter();

        ShellSorter() {
        }

        @Override
        public void sortIndexes(int[] indexes, int from, int to, ArrayComparator comparator) {
            Objects.requireNonNull(comparator, "Null comparator argument");
            ShellSorter.check(indexes, from, to);
            int step = 1;
            int maxStep = (to - 1 - from) / 9;
            while (step <= maxStep) {
                step = 3 * step + 1;
            }
            while (step > 0) {
                for (int i = from + step; i < to; ++i) {
                    int index = indexes[i];
                    for (int j = i - step; j >= from && comparator.less(index, indexes[j]); j -= step) {
                        indexes[j + step] = indexes[j];
                    }
                    indexes[j + step] = index;
                }
                step /= 3;
            }
        }

        @Override
        public void sort(long from, long to, ArrayComparator comparator, ArrayExchanger exchanger) {
            Objects.requireNonNull(comparator, "Null comparator argument");
            Objects.requireNonNull(exchanger, "Null exchanger argument");
            ShellSorter.check(from, to);
            long step = 1L;
            long maxStep = (to - 1L - from) / 9L;
            while (step <= maxStep) {
                step = 3L * step + 1L;
            }
            while (step > 0L) {
                for (long i = from + step; i < to; ++i) {
                    for (long j = i - step; j >= from && comparator.less(j + step, j); j -= step) {
                        exchanger.swap(j, j + step);
                    }
                }
                step /= 3L;
            }
        }

        public String toString() {
            return "Shell sorting algorithm";
        }
    }

    static class QuickSorter
    extends ArraySorter {
        static final ArraySorter QUICK_SORTER = new QuickSorter();
        static final long THRESHOLD = 10L;

        QuickSorter() {
        }

        @Override
        public void sortIndexes(int[] indexes, int from, int to, ArrayComparator comparator) {
            Objects.requireNonNull(comparator, "Null comparator argument");
            QuickSorter.check(indexes, from, to);
            if (to - from <= 1) {
                return;
            }
            int[] stackLeft = new int[32];
            int[] stackRight = new int[32];
            int stackTop = -1;
            int left = from;
            int right = to - 1;
            while (true) {
                int temp;
                if ((long)(right - left) < 10L) {
                    QuickSorter.insertionSortIndexesWithoutChecks(indexes, left, right + 1, comparator);
                    if (stackTop < 0) break;
                    left = stackLeft[stackTop];
                    right = stackRight[stackTop];
                    --stackTop;
                    continue;
                }
                int baseIndex = left + right >> 1;
                if (comparator.less(indexes[baseIndex], indexes[left])) {
                    temp = indexes[baseIndex];
                    indexes[baseIndex] = indexes[left];
                    indexes[left] = temp;
                }
                if (comparator.less(indexes[right], indexes[baseIndex])) {
                    temp = indexes[right];
                    indexes[right] = indexes[baseIndex];
                    indexes[baseIndex] = temp;
                    if (comparator.less(indexes[baseIndex], indexes[left])) {
                        temp = indexes[baseIndex];
                        indexes[baseIndex] = indexes[left];
                        indexes[left] = temp;
                    }
                }
                temp = indexes[left + 1];
                indexes[left + 1] = indexes[baseIndex];
                indexes[baseIndex] = temp;
                baseIndex = left + 1;
                int i = left + 1;
                int j = right;
                while (true) {
                    if (comparator.less(indexes[++i], indexes[baseIndex])) {
                        continue;
                    }
                    while (comparator.less(indexes[baseIndex], indexes[--j])) {
                    }
                    if (i >= j) break;
                    temp = indexes[i];
                    indexes[i] = indexes[j];
                    indexes[j] = temp;
                }
                temp = indexes[j];
                indexes[j] = indexes[baseIndex];
                indexes[baseIndex] = temp;
                ++stackTop;
                if (right - j >= j - left) {
                    stackRight[stackTop] = right;
                    stackLeft[stackTop] = j + 1;
                    right = j - 1;
                    continue;
                }
                stackRight[stackTop] = j - 1;
                stackLeft[stackTop] = left;
                left = j + 1;
            }
        }

        @Override
        public void sort(long from, long to, ArrayComparator comparator, ArrayExchanger exchanger) {
            Objects.requireNonNull(comparator, "Null comparator argument");
            Objects.requireNonNull(exchanger, "Null exchanger argument");
            QuickSorter.check(from, to);
            if (to - from <= 1L) {
                return;
            }
            long[] stackLeft = new long[32];
            long[] stackRight = new long[32];
            int stackTop = -1;
            long left = from;
            long right = to - 1L;
            while (true) {
                if (right - left < 10L) {
                    QuickSorter.insertionSortWithoutChecks(left, right + 1L, comparator, exchanger);
                    if (stackTop < 0) break;
                    left = stackLeft[stackTop];
                    right = stackRight[stackTop];
                    --stackTop;
                    continue;
                }
                long baseIndex = left + right >> 1;
                if (comparator.less(baseIndex, left)) {
                    exchanger.swap(baseIndex, left);
                }
                if (comparator.less(right, baseIndex)) {
                    exchanger.swap(right, baseIndex);
                    if (comparator.less(baseIndex, left)) {
                        exchanger.swap(baseIndex, left);
                    }
                }
                exchanger.swap(left + 1L, baseIndex);
                baseIndex = left + 1L;
                long i = left + 1L;
                long j = right;
                while (true) {
                    if (comparator.less(++i, baseIndex)) {
                        continue;
                    }
                    while (comparator.less(baseIndex, --j)) {
                    }
                    if (i >= j) break;
                    exchanger.swap(i, j);
                }
                exchanger.swap(j, baseIndex);
                ++stackTop;
                if (right - j >= j - left) {
                    stackRight[stackTop] = right;
                    stackLeft[stackTop] = j + 1L;
                    right = j - 1L;
                    continue;
                }
                stackRight[stackTop] = j - 1L;
                stackLeft[stackTop] = left;
                left = j + 1L;
            }
        }

        public String toString() {
            return "Insertion sorting algorithm";
        }
    }
}

