/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.Objects;
import net.algart.arrays.AbstractArray;
import net.algart.arrays.Array;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.Arrays;
import net.algart.arrays.ArraysFuncImpl;
import net.algart.arrays.ArraysMatrixResizer;
import net.algart.arrays.ArraysOpImpl;
import net.algart.arrays.ArraysTileMatrixImpl;
import net.algart.arrays.BufferMemoryModel;
import net.algart.arrays.IntArray;
import net.algart.arrays.JArrays;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.arrays.UpdatableArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.math.IRange;
import net.algart.math.functions.ApertureFilterOperator;
import net.algart.math.functions.ApertureFilteredFunc;
import net.algart.math.functions.ConstantFunc;
import net.algart.math.functions.CoordinateTransformationOperator;
import net.algart.math.functions.CoordinateTransformedFunc;
import net.algart.math.functions.Func;
import net.algart.math.functions.LinearOperator;
import net.algart.math.functions.ProjectiveOperator;

class ArraysBufferedCopier {
    final ArrayContext context;
    final boolean compare;
    final UpdatableArray dest;
    final Array src;
    final int numberOfTasks;
    Arrays.CopyAlgorithm usedAlgorithm;

    private ArraysBufferedCopier(ArrayContext context, UpdatableArray dest, Array src, int numberOfTasks, boolean compare) {
        Objects.requireNonNull(dest, "Null dest argument");
        AbstractArray.checkCopyArguments(dest, src);
        this.context = context;
        this.dest = dest;
        this.src = src;
        this.numberOfTasks = numberOfTasks;
        this.compare = compare;
    }

    public static ArraysBufferedCopier getInstance(ArrayContext context, UpdatableArray dest, Array src, int numberOfTasks, boolean strictMode, boolean compare) {
        if (Arrays.SystemSettings.BLOCK_OPTIMIZATION_FOR_COORDINATE_TRANSFORMATION && Arrays.isIndexFuncArray(src)) {
            return new IndexFuncCopier(context, dest, src, numberOfTasks, strictMode, compare);
        }
        if (Arrays.isTiled(src) || Arrays.isTiled(dest)) {
            return new TileCopier(context, dest, src, numberOfTasks, strictMode, compare);
        }
        return new ArraysBufferedCopier(context, dest, src, numberOfTasks, compare);
    }

    public boolean process() {
        this.usedAlgorithm = Arrays.CopyAlgorithm.SIMPLE;
        return this.copy(this.context, this.dest, this.src, this.compare);
    }

    final boolean copy(ArrayContext context, UpdatableArray dest, Array src, boolean compare) {
        return this.copy(context, dest, src, this.numberOfTasks, compare);
    }

    final boolean copy(ArrayContext context, UpdatableArray dest, Array src, int numberOfTasks, boolean compare) {
        if (compare) {
            ArraysOpImpl.ComparingCopier copier = new ArraysOpImpl.ComparingCopier(context, dest, src, numberOfTasks);
            copier.process();
            return copier.changed;
        }
        Arrays.Copier copier = new Arrays.Copier(context, dest, src, numberOfTasks, 0L);
        copier.process();
        return false;
    }

    static class IndexFuncCopier
    extends ArraysBufferedCopier {
        final boolean strictMode;
        private final long[] dim;
        private final long[] dimParent;
        private final int n;
        private final boolean truncationMode;
        private final boolean tiledMatrices;
        private final Matrix<? extends PArray> mSrc;
        private final Matrix<? extends PArray> mOutside;
        private final Matrix<? extends UpdatablePArray> mDest;
        private final Matrix<? extends PArray> mParent;
        private final ApertureFilteredFunc fFiltered;
        private final Func fInterpolation;
        private final CoordinateTransformationOperator o;
        private final ProjectiveOperator po;
        private final double[] aFrom;
        private final double[] aTo;
        private final double[] diagonal;
        private final boolean projectiveTransformation;
        private final boolean affineTransformation;
        private final boolean resizingTransformation;
        private final Matrices.ResizingMethod resizingMethod;
        private final boolean optimizeResizingWholeMatrix;
        private final Matrices.InterpolationMethod interpolationMethod;
        private final IRange depRange;
        private final long bufSize;
        private final long parentTileSide;
        private final long parentTileSize;
        private final boolean bufferingPossible;
        private UpdatablePArray buf = null;

        private IndexFuncCopier(ArrayContext context, UpdatableArray dest, Array src, int numberOfTasks, boolean strictMode, boolean compare) {
            super(context, dest, src, numberOfTasks, compare);
            CoordinateTransformedFunc fTransformed;
            assert (Arrays.isIndexFuncArray(src));
            this.strictMode = strictMode;
            this.dim = Arrays.getIndexDimensions(src);
            this.n = this.dim.length;
            if (this.n < 1) {
                throw new AssertionError((Object)("Invalid implementation of some classes: number of dimensions is " + this.n));
            }
            if (Arrays.longMul(this.dim) < 0L) {
                throw new AssertionError((Object)"Invalid implementation of some classes: illegal product of dimensions");
            }
            this.truncationMode = Arrays.getTruncationMode(src);
            Func f = Arrays.getFunc(src);
            if (f instanceof CoordinateTransformedFunc) {
                fTransformed = (CoordinateTransformedFunc)f;
                this.fFiltered = null;
            } else if (f instanceof ApertureFilteredFunc) {
                this.fFiltered = (ApertureFilteredFunc)f;
                fTransformed = this.fFiltered.parent() instanceof CoordinateTransformedFunc ? (CoordinateTransformedFunc)this.fFiltered.parent() : null;
            } else {
                this.fFiltered = null;
                fTransformed = null;
            }
            if (!dest.isEmpty() && Arrays.longMul(this.dim) == dest.length() && src.length() == dest.length() && fTransformed != null && Matrices.isInterpolationFunc(fTransformed.parent())) {
                boolean resizingTransformation;
                if (!(src instanceof PArray)) {
                    throw new AssertionError((Object)("isIndexFuncArray returns true for non-primitive array " + String.valueOf(src)));
                }
                if (src.elementType() != dest.elementType()) {
                    throw new AssertionError((Object)"checkCopyArguments does not detect different element types");
                }
                if (!(dest instanceof UpdatablePArray)) {
                    throw new AssertionError((Object)("AlgART array " + String.valueOf(dest.elementType()) + "[] does not implement " + String.valueOf(UpdatablePArray.class)));
                }
                this.mSrc = Matrices.matrix((PArray)src, this.dim);
                this.mDest = Matrices.matrix((UpdatablePArray)dest, this.dim);
                this.o = fTransformed.operator();
                this.po = this.o instanceof ProjectiveOperator ? (ProjectiveOperator)this.o : null;
                this.aFrom = new double[this.n];
                this.aTo = new double[this.n];
                if (this.fFiltered != null) {
                    ApertureFilterOperator afo = this.fFiltered.operator();
                    for (int k = 0; k < this.n; ++k) {
                        this.aFrom[k] = afo.apertureFrom(k);
                        if (this.aFrom[k] < 0.0) {
                            int n = k;
                            this.aFrom[n] = this.aFrom[n] - 1.0E-6;
                        }
                        this.aTo[k] = afo.apertureTo(k) + 1.0E-6;
                    }
                }
                this.diagonal = this.o instanceof LinearOperator ? this.po.diagonal() : null;
                boolean bl = resizingTransformation = this.diagonal != null && this.po.isDiagonal() && this.po.isZeroB();
                if (resizingTransformation) {
                    for (double d : this.diagonal) {
                        resizingTransformation &= d > 0.0;
                    }
                }
                this.resizingTransformation = resizingTransformation;
                this.affineTransformation = this.o instanceof LinearOperator;
                this.projectiveTransformation = this.o instanceof ProjectiveOperator;
                this.fInterpolation = fTransformed.parent();
                this.interpolationMethod = Matrices.getInterpolationMethod(this.fInterpolation);
                this.depRange = this.interpolationMethod.dependenceCoordRange();
                this.mOutside = Matrices.isOnlyInsideInterpolationFunc(this.fInterpolation) ? null : this.coordFuncMatrix(ConstantFunc.getInstance(Matrices.getOutsideValue(this.fInterpolation)), this.dim);
                this.mParent = Matrices.getUnderlyingMatrix(this.fInterpolation);
                this.tiledMatrices = Arrays.isTiledOrSubMatrixOfTiled(dest) || Arrays.isTiledOrSubMatrixOfTiled(this.mParent.array());
                this.dimParent = this.mParent.dimensions();
                if (this.dimParent.length != this.n) {
                    throw new AssertionError((Object)"Invalid implementation of some classes: space dimension was changed");
                }
                if (this.o instanceof LinearOperator) {
                    Objects.requireNonNull(this.diagonal, "Invalid implementation of some classes:  null ProjectiveOperator.diagonal()");
                    if (this.diagonal.length != this.n || this.po.n() != this.n) {
                        throw new AssertionError((Object)("Invalid implementation of some classes: illegal space dimension for the operator " + String.valueOf(this.po)));
                    }
                }
                Object helperInfo = resizingTransformation && src instanceof ArraysFuncImpl.OptimizationHelperInfo ? ((ArraysFuncImpl.OptimizationHelperInfo)((Object)src)).getOptimizationHelperInfo() : null;
                this.resizingMethod = helperInfo instanceof Matrices.ResizingMethod ? (Matrices.ResizingMethod)helperInfo : null;
                this.optimizeResizingWholeMatrix = this.resizingMethod != null && !this.strictMode && !this.compare && this.mParent.elementType() == this.mDest.elementType() && Arrays.SystemSettings.BLOCK_OPTIMIZATION_FOR_RESIZING_WHOLE_MATRIX;
                double elementsPerByte = 8.0 / (double)this.mParent.array().bitsPerElement();
                double elementsPerTempJavaMemory = elementsPerByte * (double)Arrays.SystemSettings.maxTempJavaMemory();
                this.bufSize = Math.max(Math.round(elementsPerByte * (double)Arrays.SystemSettings.MIN_OPTIMIZATION_JAVA_MEMORY), Math.round(elementsPerTempJavaMemory));
                long estimatedSize = Math.min(this.bufSize, this.mParent.size());
                this.parentTileSide = IndexFuncCopier.estimateTileSide(this.dimParent, estimatedSize);
                this.parentTileSize = IndexFuncCopier.tileSize(this.dimParent, this.parentTileSide);
                this.bufferingPossible = true;
            } else {
                this.tiledMatrices = false;
                this.mSrc = null;
                this.mDest = null;
                this.o = null;
                this.po = null;
                this.aTo = null;
                this.aFrom = null;
                this.diagonal = null;
                this.projectiveTransformation = false;
                this.affineTransformation = false;
                this.resizingTransformation = false;
                this.resizingMethod = null;
                this.optimizeResizingWholeMatrix = false;
                this.fInterpolation = null;
                this.interpolationMethod = null;
                this.depRange = null;
                this.mOutside = null;
                this.mParent = null;
                this.dimParent = null;
                this.bufSize = -1L;
                this.parentTileSize = -1L;
                this.parentTileSide = -1L;
                this.bufferingPossible = false;
            }
        }

        @Override
        public boolean process() {
            Boolean result;
            if (!this.bufferingPossible) {
                return super.process();
            }
            if (SimpleMemoryModel.isSimpleArray(this.mParent.array())) {
                if (this.optimizeResizingWholeMatrix && ArraysMatrixResizer.tryToResizeWithOptimization(this.context, this.resizingMethod, this.mDest, this.mParent)) {
                    this.usedAlgorithm = Arrays.CopyAlgorithm.BUFFERING_WHOLE_ARRAY;
                    return false;
                }
                if (SimpleMemoryModel.isSimpleArray(this.mDest.array())) {
                    return super.process();
                }
            }
            if (this.isVeryQuickCompression()) {
                return super.process();
            }
            if (!this.tiledMatrices && (result = this.copyWithBufferingWholeMatrix()) != null) {
                this.usedAlgorithm = Arrays.CopyAlgorithm.BUFFERING_WHOLE_ARRAY;
                return result;
            }
            if (this.strictMode) {
                this.usedAlgorithm = Arrays.CopyAlgorithm.SIMPLE;
                return super.process();
            }
            if (Arrays.SystemSettings.BLOCK_OPTIMIZATION_FOR_RESIZING_TRANSFORMATION && !this.tiledMatrices && this.resizingTransformation && (result = this.copyWithBufferingLayers()) != null) {
                this.usedAlgorithm = Arrays.CopyAlgorithm.BUFFERING_LAYERS;
                return result;
            }
            if (Arrays.SystemSettings.BLOCK_OPTIMIZATION_FOR_AFFINE_TRANSFORMATION && this.affineTransformation) {
                result = this.copyWithRegularTiling();
                if (result != null) {
                    this.usedAlgorithm = Arrays.CopyAlgorithm.REGULAR_BUFFERING_TILES;
                    return result;
                }
                return super.process();
            }
            if (Arrays.SystemSettings.BLOCK_OPTIMIZATION_FOR_PROJECTIVE_TRANSFORMATION && this.projectiveTransformation && (result = this.copyWithRecursiveTiling()) != null) {
                this.usedAlgorithm = Arrays.CopyAlgorithm.RECURSIVE_BUFFERING_TILES;
                return result;
            }
            return super.process();
        }

        private boolean isVeryQuickCompression() {
            if (!this.resizingTransformation) {
                return false;
            }
            if (this.fFiltered != null) {
                return false;
            }
            double totalAverage = 1.0;
            boolean usualWayIsBetter = true;
            for (double d : this.diagonal) {
                usualWayIsBetter &= d > 1.0;
                totalAverage *= d;
            }
            return usualWayIsBetter &= totalAverage > 200.0;
        }

        private Boolean copyWithBufferingWholeMatrix() {
            if (this.projectiveTransformation && !this.optimizeResizingWholeMatrix) {
                double minimalUsedPart = !this.strictMode ? 0.7 : 0.01;
                long[] parentFrom = new long[this.n];
                long[] parentTo = new long[this.n];
                this.srcSquareTileToParentCoordSystem(parentFrom, parentTo, new long[this.n], this.dim);
                if (this.checkFullyOutside(parentFrom, parentTo)) {
                    return this.copy(this.context, this.dest, this.mOutside == null ? this.src : this.mOutside.array(), this.compare);
                }
                this.checkFullyInsideAndTrim(parentFrom, parentTo);
                long[] dimParentTile = new long[this.n];
                for (int k = 0; k < this.n; ++k) {
                    assert (parentFrom[k] >= 0L && parentTo[k] <= this.dimParent[k] && parentFrom[k] <= parentTo[k]);
                    dimParentTile[k] = parentTo[k] - parentFrom[k];
                }
                long parentTileSize = Arrays.longMul(dimParentTile);
                assert (parentTileSize >= 0L);
                if ((double)parentTileSize < minimalUsedPart * (double)this.mParent.size()) {
                    return null;
                }
            }
            if (this.mParent.size() > this.bufSize) {
                return null;
            }
            Matrix<UpdatablePArray> buf = Arrays.SMM.newMatrix(UpdatablePArray.class, this.mParent.elementType(), this.dimParent);
            this.copy(this.context == null ? null : this.context.part(0.0, 0.1), buf.array(), this.mParent.array(), false);
            if (this.optimizeResizingWholeMatrix && ArraysMatrixResizer.tryToResizeWithOptimization(this.context == null ? null : this.context.part(0.1, 1.0), this.resizingMethod, this.mDest, buf)) {
                return false;
            }
            Func bufInterpolation = this.interpolation(buf);
            Func bufTransformed = this.o.apply(bufInterpolation);
            if (this.fFiltered != null) {
                bufTransformed = this.fFiltered.operator().apply(bufTransformed);
            }
            Matrix<? extends PArray> lazy = this.coordFuncMatrix(bufTransformed, this.dim);
            return this.copy(this.context == null ? null : this.context.part(0.1, 1.0), this.mDest.array(), lazy.array(), this.compare);
        }

        private Boolean copyWithBufferingLayers() {
            assert (this.po instanceof LinearOperator);
            assert (this.resizingTransformation);
            long parentPlaneSize = 1L;
            for (int k = 0; k < this.n - 1; ++k) {
                parentPlaneSize *= this.dimParent[k];
            }
            long srcPlaneSize = 1L;
            for (int k = 0; k < this.n - 1; ++k) {
                srcPlaneSize *= this.dim[k];
            }
            long parentPlaneCount = this.bufSize / parentPlaneSize;
            if (parentPlaneCount <= 0L) {
                return null;
            }
            long srcPlaneCount = Math.min(this.parentLayerToSrcCoordSystem(parentPlaneCount), this.dim[this.n - 1]);
            assert (srcPlaneCount >= 0L);
            if (srcPlaneCount == 0L) {
                return null;
            }
            long[] parentFrom = new long[this.n];
            long[] parentTo = new long[this.n];
            this.srcSquareTileToParentCoordSystem(parentFrom, parentTo, new long[this.n], this.dim);
            boolean layerFullyInside = true;
            for (int k = 0; k < this.n; ++k) {
                if (parentFrom[k] < 0L) {
                    parentFrom[k] = 0L;
                    if (k < this.n - 1) {
                        layerFullyInside = false;
                    }
                }
                if (parentTo[k] <= this.dimParent[k]) continue;
                parentTo[k] = this.dimParent[k];
                if (k >= this.n - 1) continue;
                layerFullyInside = false;
            }
            long usedParentPlaneSize = 1L;
            for (int k = 0; k < this.n - 1; ++k) {
                usedParentPlaneSize *= parentTo[k] - parentFrom[k];
            }
            if ((double)usedParentPlaneSize <= 0.7 * (double)parentPlaneSize) {
                return null;
            }
            long[] dimLayer = (long[])this.dimParent.clone();
            dimLayer[this.n - 1] = parentPlaneCount;
            this.buf = (UpdatablePArray)Arrays.SMM.newUnresizableArray(this.mParent.elementType(), Arrays.longMul(dimLayer));
            long[] dimLazy = (long[])this.dim.clone();
            long m = this.dim[this.n - 1];
            boolean result = false;
            double[] correctionShift = new double[this.n];
            long srcFrom = 0L;
            while (srcFrom < m) {
                boolean fullyOutside;
                long srcTo = srcFrom + Math.min(srcPlaneCount, m - srcFrom);
                ArrayContext ac = this.context == null ? null : this.context.part(srcFrom, srcTo, m);
                double transformedFrom = ((double)srcFrom + this.aFrom[this.n - 1]) * this.diagonal[this.n - 1];
                double transformedTo = ((double)(srcTo - 1L) + this.aTo[this.n - 1]) * this.diagonal[this.n - 1];
                long parFrom = (long)(Math.floor(transformedFrom) + (double)this.depRange.min());
                long parTo = (long)(Math.ceil(transformedTo) + (double)this.depRange.max() + 1.0);
                boolean bl = fullyOutside = parTo <= 0L || parFrom >= this.dimParent[this.n - 1];
                if (fullyOutside) {
                    long srcFromIndex = srcFrom * srcPlaneSize;
                    long srcToIndex = srcTo * srcPlaneSize;
                    result |= this.copy(this.context == null ? null : this.context.part(srcFrom, srcTo, m), this.mDest.array().subArray(srcFromIndex, srcToIndex), (this.mOutside == null ? this.mSrc : this.mOutside).array().subArray(srcFromIndex, srcToIndex), this.compare);
                } else {
                    boolean fullyInside = parFrom >= 0L && parTo < this.dimParent[this.n - 1] && layerFullyInside;
                    parFrom = Math.max(parFrom, 0L);
                    if ((parTo = Math.min(parTo, this.dimParent[this.n - 1])) - parFrom > parentPlaneCount) {
                        throw new AssertionError((Object)("Error while estimation in parentLayerToSrcDim: " + srcFrom + ".." + srcTo + " <-- " + parFrom + ".." + parTo));
                    }
                    dimLayer[this.n - 1] = parTo - parFrom;
                    dimLazy[this.n - 1] = srcTo - srcFrom;
                    Matrix<UpdatablePArray> layer = Matrices.matrix(this.buf.subArr(0L, Arrays.longMul(dimLayer)), dimLayer);
                    this.copy(ac == null ? null : ac.part(0.0, 0.1), layer.array(), this.mParent.array().subArray(parFrom * parentPlaneSize, parTo * parentPlaneSize), false);
                    Func layerInterpolation = fullyInside ? Matrices.asInterpolationFunc(layer, this.interpolationMethod, false) : this.interpolation(layer);
                    correctionShift[this.n - 1] = (double)srcFrom * this.diagonal[this.n - 1] - (double)parFrom;
                    LinearOperator correctedOperator = LinearOperator.getDiagonalInstance(this.diagonal, correctionShift);
                    Func layerTransformed = correctedOperator.apply(layerInterpolation);
                    if (this.fFiltered != null) {
                        layerTransformed = this.fFiltered.operator().apply(layerTransformed);
                    }
                    Matrix<? extends PArray> lazy = this.coordFuncMatrix(layerTransformed, dimLazy);
                    result |= this.copy(ac == null ? null : ac.part(0.1, 1.0), this.mDest.array().subArray(srcFrom * srcPlaneSize, srcTo * srcPlaneSize), lazy.array(), this.compare);
                }
                srcFrom = srcTo;
            }
            return result;
        }

        private Boolean copyWithRegularTiling() {
            assert (this.po instanceof LinearOperator);
            assert (this.affineTransformation);
            if (this.parentTileSide <= 1L) {
                return null;
            }
            if (this.n > 9) {
                return null;
            }
            long srcSide = this.parentRegularSquareTileToSrcCoordSystem(this.parentTileSide);
            if (this.tiledMatrices) {
                srcSide = Long.highestOneBit(srcSide);
            }
            assert (srcSide >= 0L);
            if (srcSide == 0L) {
                return null;
            }
            long[] tileCounts = new long[this.n];
            for (int k = 0; k < this.n; ++k) {
                if (this.dim[k] == 0L) {
                    return null;
                }
                tileCounts[k] = (this.dim[k] - 1L) / srcSide + 1L;
            }
            long[] scales = !this.optimizeResizingWholeMatrix ? null : ArraysMatrixResizer.getScalesIfCanBeOptimizedForDirectAccessibleResult(this.resizingMethod, this.mParent.elementType(), this.dim, this.dimParent);
            boolean useMatrixResizer = scales != null;
            Matrix<IntArray> enumerator = Matrices.matrix(Arrays.nIntCopies(Arrays.longMul(tileCounts), 157), tileCounts);
            long actualBufSize = this.parentTileSize;
            if (useMatrixResizer) {
                assert (this.mDest.elementType() == this.mParent.elementType());
                actualBufSize = 1L;
                for (int k = 0; k < this.n; ++k) {
                    long side = scales[k] * Math.min(srcSide, this.dim[k]);
                    assert (side <= this.dimParent[k]);
                    actualBufSize *= side;
                }
            }
            this.buf = (UpdatablePArray)Arrays.SMM.newUnresizableArray(this.mParent.elementType(), actualBufSize);
            long[] tileIndexes = new long[this.n];
            long[] srcFrom = new long[this.n];
            long[] srcTo = new long[this.n];
            long[] parentFrom = new long[this.n];
            long[] parentTo = new long[this.n];
            boolean result = false;
            long tileCount = enumerator.size();
            for (long tileIndex = 0L; tileIndex < tileCount; ++tileIndex) {
                ArrayContext ac = this.context == null ? null : this.context.part(tileIndex, tileIndex + 1L, tileCount);
                enumerator.coordinates(tileIndex, tileIndexes);
                for (int k = 0; k < this.n; ++k) {
                    srcFrom[k] = tileIndexes[k] * srcSide;
                    assert (srcFrom[k] < this.dim[k]);
                    srcTo[k] = Math.min(srcFrom[k] + srcSide, this.dim[k]);
                }
                if (useMatrixResizer) {
                    long[] parentTileDim = new long[this.n];
                    for (int k = 0; k < this.n; ++k) {
                        parentFrom[k] = srcFrom[k] * scales[k];
                        parentTo[k] = srcTo[k] * scales[k];
                        assert (parentFrom[k] <= this.dimParent[k] && parentTo[k] <= this.dimParent[k]);
                        parentTileDim[k] = parentTo[k] - parentFrom[k];
                    }
                    Matrix<UpdatablePArray> parentTileBuf = Matrices.matrixAtSubArray(this.buf, 0L, parentTileDim);
                    this.copy(ac == null ? null : ac.part(0.0, 0.3), parentTileBuf.array(), this.mParent.subMatrix(parentFrom, parentTo).array(), false);
                    if (ArraysMatrixResizer.tryToResizeWithOptimization(ac == null ? null : ac.part(0.3, 1.0), this.resizingMethod, this.mDest.subMatrix(srcFrom, srcTo), parentTileBuf)) continue;
                    useMatrixResizer = false;
                    ac = ac == null ? null : ac.part(0.3, 1.0);
                    this.buf = (UpdatablePArray)Arrays.SMM.newUnresizableArray(this.mParent.elementType(), this.parentTileSize);
                }
                this.srcSquareTileToParentCoordSystem(parentFrom, parentTo, srcFrom, srcTo);
                if (this.checkFullyOutside(parentFrom, parentTo)) {
                    result |= this.copy(ac, this.mDest.subMatrix(srcFrom, srcTo).array(), (this.mOutside == null ? this.mSrc : this.mOutside).subMatrix(srcFrom, srcTo).array(), this.compare);
                    continue;
                }
                boolean fullyInside = this.checkFullyInsideAndTrim(parentFrom, parentTo);
                result |= this.copyTile(ac, srcFrom, srcTo, parentFrom, parentTo, fullyInside);
            }
            return result;
        }

        private Boolean copyWithRecursiveTiling() {
            assert (this.po instanceof ProjectiveOperator);
            assert (this.projectiveTransformation);
            if (this.parentTileSide <= 0L) {
                return null;
            }
            if (this.n > 9) {
                return null;
            }
            this.buf = (UpdatablePArray)Arrays.SMM.newUnresizableArray(this.mParent.elementType(), this.parentTileSize);
            return this.copyWithRecursiveTiling(this.context, new long[this.n], this.dim);
        }

        private boolean copyWithRecursiveTiling(ArrayContext ac, long[] srcFrom, long[] srcTo) {
            long[] parentFrom = new long[this.n];
            long[] parentTo = new long[this.n];
            this.srcSquareTileToParentCoordSystem(parentFrom, parentTo, srcFrom, srcTo);
            if (this.checkFullyOutside(parentFrom, parentTo)) {
                return this.copy(ac, this.mDest.subMatrix(srcFrom, srcTo).array(), (this.mOutside == null ? this.mSrc : this.mOutside).subMatrix(srcFrom, srcTo).array(), this.compare);
            }
            boolean fullyInside = this.checkFullyInsideAndTrim(parentFrom, parentTo);
            long maxParentSide = 0L;
            for (int k = 0; k < this.n; ++k) {
                assert (parentTo[k] >= parentFrom[k]);
                long side = parentTo[k] - parentFrom[k];
                assert (side >= 0L) : "parentFrom/To are probably not trimmed";
                maxParentSide = Math.max(maxParentSide, side);
            }
            if (maxParentSide <= this.parentTileSide) {
                return this.copyTile(ac, srcFrom, srcTo, parentFrom, parentTo, fullyInside);
            }
            long srcTileSize = 1L;
            for (int k = 0; k < this.n; ++k) {
                assert (srcTo[k] > srcFrom[k]);
                srcTileSize *= srcTo[k] - srcFrom[k];
            }
            if (srcTileSize <= 100L) {
                return this.copy(ac, this.mDest.subMatrix(srcFrom, srcTo).array(), this.mSrc.subMatrix(srcFrom, srcTo).array(), this.compare);
            }
            if (srcTileSize <= 1L) {
                throw new AssertionError((Object)"The constant MIN_OPTIMIZATION_RESULT_TILE_VOLUME must be >=1");
            }
            int splittingCoord = this.n - 1;
            long maxSide = srcTo[this.n - 1] - srcFrom[this.n - 1];
            for (int k = this.n - 2; k >= 0; --k) {
                if (srcTo[k] - srcFrom[k] <= maxSide) continue;
                maxSide = srcTo[k] - srcFrom[k];
                splittingCoord = k;
            }
            assert (maxSide > 1L);
            long[] srcMiddle = new long[this.n];
            System.arraycopy(srcTo, 0, srcMiddle, 0, this.n);
            srcMiddle[splittingCoord] = srcFrom[splittingCoord] + maxSide / 2L;
            boolean result = this.copyWithRecursiveTiling(ac == null ? null : ac.part(0.0, 0.5), srcFrom, srcMiddle);
            System.arraycopy(srcFrom, 0, srcMiddle, 0, this.n);
            srcMiddle[splittingCoord] = srcFrom[splittingCoord] + maxSide / 2L;
            return result |= this.copyWithRecursiveTiling(ac == null ? null : ac.part(0.5, 1.0), srcMiddle, srcTo);
        }

        private boolean copyTile(ArrayContext ac, long[] srcFrom, long[] srcTo, long[] parentFrom, long[] parentTo, boolean fullyInside) {
            assert (this.po != null);
            for (int k = 0; k < this.n; ++k) {
                long side = parentTo[k] - parentFrom[k];
                if (side < 0L || side > this.parentTileSide) {
                    throw new AssertionError((Object)("Error while estimation of the parent tile side: " + IndexFuncCopier.toS(parentFrom) + ".." + IndexFuncCopier.toS(parentTo)));
                }
            }
            long[] parentTileDim = new long[this.n];
            long[] lazyDim = new long[this.n];
            for (int k = 0; k < this.n; ++k) {
                assert (parentFrom[k] >= 0L && parentTo[k] <= this.dimParent[k] && parentFrom[k] <= parentTo[k]);
                parentTileDim[k] = parentTo[k] - parentFrom[k];
                lazyDim[k] = srcTo[k] - srcFrom[k];
            }
            long trimmedParentTileSize = Arrays.longMul(parentTileDim);
            if (trimmedParentTileSize > this.buf.length()) {
                throw new AssertionError((Object)("Error while estimation of necessary buffer size: " + this.buf.length() + " instead of necessary " + trimmedParentTileSize));
            }
            Matrix<UpdatablePArray> parentTileBuf = Matrices.matrix(this.buf.subArr(0L, trimmedParentTileSize), parentTileDim);
            this.copy(ac == null ? null : ac.part(0.0, 0.3), parentTileBuf.array(), this.mParent.subMatrix(parentFrom, parentTo).array(), false);
            Func parentTileInterpolation = fullyInside ? Matrices.asInterpolationFunc(parentTileBuf, this.interpolationMethod, false) : this.interpolation(parentTileBuf);
            ProjectiveOperator correctedOperator = this.correctOperatorForTile(srcFrom, parentFrom);
            if (fullyInside) {
                double[] parentCoordinates = new double[this.n];
                correctedOperator.map(parentCoordinates, new double[this.n]);
                for (int k = 0; k < this.n; ++k) {
                    if (parentCoordinates[k] < -1.0 || parentCoordinates[k] > (double)(this.dimParent[k] + 1L)) {
                        throw new AssertionError((Object)("Error while correcting linear operator: the origin of coordinates is transformed to a point" + IndexFuncCopier.toS(parentCoordinates) + " outside the tile"));
                    }
                }
            }
            Func result = correctedOperator.apply(parentTileInterpolation);
            if (this.fFiltered != null) {
                result = this.fFiltered.operator().apply(result);
            }
            Func tileTransformed = result;
            Matrix<? extends PArray> lazy = this.coordFuncMatrix(tileTransformed, lazyDim);
            return this.copy(ac == null ? null : ac.part(0.3, 1.0), this.mDest.subMatrix(srcFrom, srcTo).array(), lazy.array(), this.compare);
        }

        private ProjectiveOperator correctOperatorForTile(long[] srcFrom, long[] parentFrom) {
            int i;
            double[] srcFromDouble = new double[this.n];
            for (int k = 0; k < this.n; ++k) {
                srcFromDouble[k] = srcFrom[k];
            }
            if (this.po instanceof LinearOperator) {
                double[] transformedFromDouble = new double[this.n];
                this.po.map(transformedFromDouble, srcFromDouble);
                double[] correctedB = new double[this.n];
                for (int k = 0; k < this.n; ++k) {
                    correctedB[k] = transformedFromDouble[k] - (double)parentFrom[k];
                }
                return ((LinearOperator)this.po).changeB(correctedB);
            }
            double[] a = this.po.a();
            double[] b = this.po.b();
            double[] c = this.po.c();
            double d = this.po.d();
            assert (this.po.n() == this.n && b.length == this.n && c.length == this.n && a.length == this.n * this.n);
            double csf = 0.0;
            for (i = 0; i < this.n; ++i) {
                csf += c[i] * srcFromDouble[i];
            }
            i = 0;
            int ofs = 0;
            while (i < this.n) {
                double pfi = parentFrom[i];
                double aisf = 0.0;
                for (int j = 0; j < this.n; ++j) {
                    aisf += a[ofs] * srcFromDouble[j];
                    int n = ofs++;
                    a[n] = a[n] - pfi * c[j];
                }
                int n = i++;
                b[n] = b[n] + (aisf - pfi * csf - pfi * d);
            }
            return ProjectiveOperator.getInstance(a, b, c, d += csf);
        }

        private boolean checkFullyOutside(long[] parentFrom, long[] parentTo) {
            for (int k = 0; k < this.n; ++k) {
                if (parentTo[k] > 0L && parentFrom[k] < this.dimParent[k]) continue;
                return true;
            }
            return false;
        }

        private boolean checkFullyInsideAndTrim(long[] parentFrom, long[] parentTo) {
            boolean result = true;
            for (int k = 0; k < this.n; ++k) {
                if (parentFrom[k] < 0L) {
                    parentFrom[k] = 0L;
                    result = false;
                }
                if (parentTo[k] <= this.dimParent[k]) continue;
                parentTo[k] = this.dimParent[k];
                result = false;
            }
            return result;
        }

        private long parentLayerToSrcCoordSystem(long dimParent) {
            assert (this.po instanceof LinearOperator);
            assert (this.resizingTransformation);
            --dimParent;
            if ((dimParent -= this.depRange.size()) <= 1L) {
                return 0L;
            }
            assert (this.diagonal[this.n - 1] > 0.0);
            double dimSrc = (double)dimParent / this.diagonal[this.n - 1];
            if (this.fFiltered != null) {
                ApertureFilterOperator afo = this.fFiltered.operator();
                double lastASide = afo.apertureTo(this.n - 1) - afo.apertureFrom(this.n - 1);
                dimSrc -= lastASide;
            }
            if ((dimSrc -= 0.001) <= 0.0) {
                return 0L;
            }
            return (long)dimSrc;
        }

        private long parentRegularSquareTileToSrcCoordSystem(long dimParent) {
            int k;
            assert (this.po instanceof LinearOperator);
            assert (this.affineTransformation);
            assert (this.n <= 9);
            --dimParent;
            if ((dimParent -= this.depRange.size()) <= 1L) {
                return 0L;
            }
            double[] minParentCoordinates = new double[this.n];
            double[] maxParentCoordinates = new double[this.n];
            JArrays.fill(minParentCoordinates, Double.POSITIVE_INFINITY);
            JArrays.fill(maxParentCoordinates, Double.NEGATIVE_INFINITY);
            double[] srcCoordinates = new double[this.n];
            double[] parentCoordinates = new double[this.n];
            int maxBits = 1 << this.n;
            for (int bits = 0; bits < maxBits; ++bits) {
                for (k = 0; k < this.n; ++k) {
                    srcCoordinates[k] = bits >>> k & 1;
                }
                this.po.map(parentCoordinates, srcCoordinates);
                JArrays.minDoubleArray(minParentCoordinates, 0, parentCoordinates, 0, this.n);
                JArrays.maxDoubleArray(maxParentCoordinates, 0, parentCoordinates, 0, this.n);
            }
            double d = Double.NEGATIVE_INFINITY;
            for (k = 0; k < parentCoordinates.length; ++k) {
                d = Math.max(d, maxParentCoordinates[k] - minParentCoordinates[k]);
            }
            if (Double.isNaN(d) || d <= 0.0) {
                return 0L;
            }
            double dimSrc = (double)dimParent / d;
            if (this.fFiltered != null) {
                dimSrc -= this.fFiltered.operator().maxApertureSize();
            }
            if ((dimSrc -= 0.001) <= 0.0) {
                return 0L;
            }
            if (dimSrc >= (double)dimParent) {
                return (long)dimSrc;
            }
            if (Math.pow(dimSrc / (double)dimParent, this.n) <= 0.01 && this.fFiltered == null) {
                return 0L;
            }
            return (long)dimSrc;
        }

        private void srcSquareTileToParentCoordSystem(long[] parentFrom, long[] parentTo, long[] srcFrom, long[] srcTo) {
            assert (this.n <= 9);
            double[] minParentCoordinates = new double[this.n];
            double[] maxParentCoordinates = new double[this.n];
            double[] srcCoordinates = new double[this.n];
            double[] parentCoordinates = new double[this.n];
            JArrays.fill(minParentCoordinates, Double.POSITIVE_INFINITY);
            JArrays.fill(maxParentCoordinates, Double.NEGATIVE_INFINITY);
            int maxBits = 1 << this.n;
            for (int bits = 0; bits < maxBits; ++bits) {
                for (int k = 0; k < this.n; ++k) {
                    srcCoordinates[k] = (bits >>> k & 1) == 0 ? (double)srcFrom[k] + this.aFrom[k] : (double)(srcTo[k] - 1L) + this.aTo[k];
                }
                this.po.map(parentCoordinates, srcCoordinates);
                JArrays.minDoubleArray(minParentCoordinates, 0, parentCoordinates, 0, this.n);
                JArrays.maxDoubleArray(maxParentCoordinates, 0, parentCoordinates, 0, this.n);
            }
            for (int k = 0; k < this.n; ++k) {
                parentFrom[k] = (long)(Math.floor(minParentCoordinates[k]) + (double)this.depRange.min());
                parentTo[k] = (long)(Math.ceil(maxParentCoordinates[k]) + (double)this.depRange.max() + 1.0);
                assert (parentFrom[k] <= parentTo[k]) : "parentFrom[" + k + "] = " + parentFrom[k] + " > parentTo[" + k + "] = " + parentTo[k];
            }
        }

        private Func interpolation(Matrix<? extends PArray> m) {
            return Matrices.isOnlyInsideInterpolationFunc(this.fInterpolation) ? Matrices.asInterpolationFunc(m, this.interpolationMethod, Matrices.isCheckedOnlyInsideInterpolationFunc(this.fInterpolation)) : Matrices.asInterpolationFunc(m, this.interpolationMethod, Matrices.getOutsideValue(this.fInterpolation));
        }

        private Matrix<? extends PArray> coordFuncMatrix(Func transformed, long[] dim) {
            return Matrices.asCoordFuncMatrix(this.truncationMode, transformed, this.mDest.type(PArray.class), dim);
        }

        private static long estimateTileSide(long[] dim, long bufSize) {
            long lastResult;
            long maxDim = 0L;
            for (long d : dim) {
                maxDim = Math.max(maxDim, d);
            }
            long result = (long)Math.pow(bufSize, 1.0 / (double)dim.length);
            do {
                lastResult = result;
            } while ((result = Math.max(result + 1L, (long)((double)result * 1.05))) <= maxDim && IndexFuncCopier.tileSize(dim, result) <= bufSize);
            return lastResult;
        }

        private static long tileSize(long[] dim, long tileSide) {
            long result = 1L;
            for (long d : dim) {
                result *= Math.min(d, tileSide);
            }
            return result;
        }

        private static String toS(double[] array) {
            return JArrays.toString(array, ";", 100);
        }

        private static String toS(long[] array) {
            return JArrays.toString(array, ";", 100);
        }
    }

    static class TileCopier
    extends ArraysBufferedCopier {
        private final boolean strictMode;
        private final long copiedLength;
        private final long[] dim;
        private final long lastDim;
        private final long[] tileDim;
        private final long lastTileDim;
        private final long[] layerDim;
        private final long layerSize;
        private final Matrix<? extends UpdatableArray> baseMatrixDest;
        private final Matrix<? extends Array> baseMatrixSrc;
        private final long maxBufSize;
        private final int n;
        private final boolean optimizationPossible;

        private TileCopier(ArrayContext context, UpdatableArray dest, Array src, int numberOfTasks, boolean strictMode, boolean compare) {
            super(context, dest, src, numberOfTasks, compare);
            this.copiedLength = Math.min(src.length(), dest.length());
            this.strictMode = strictMode;
            if (Arrays.isTiled(src)) {
                this.baseMatrixSrc = ((ArraysTileMatrixImpl.TileMatrixArray)((Object)src)).baseMatrix();
                assert (this.baseMatrixSrc.size() == src.length()) : "Error in implementation of " + String.valueOf(src);
                this.dim = this.baseMatrixSrc.dimensions();
                this.tileDim = Arrays.tileDimensions(src);
                if (Arrays.isTiled(dest)) {
                    this.baseMatrixDest = ((ArraysTileMatrixImpl.TileMatrixArray)((Object)dest)).baseMatrix().cast(UpdatableArray.class);
                    assert (this.baseMatrixDest.size() == dest.length()) : "Error in implementation of " + String.valueOf(dest);
                    this.maxBufSize = -1L;
                    this.optimizationPossible = this.copiedLength > 0L && this.baseMatrixSrc.dimEquals(this.baseMatrixDest) && java.util.Arrays.equals(this.tileDim, Arrays.tileDimensions(dest));
                } else {
                    double eSize = (double)Arrays.sizeOf(dest) / (double)dest.length();
                    this.maxBufSize = Math.round((double)Arrays.SystemSettings.availableTempJavaMemoryForTiling() / eSize);
                    this.baseMatrixDest = null;
                    this.optimizationPossible = this.copiedLength > 0L && eSize > 0.0 && !SimpleMemoryModel.isSimpleArray(this.baseMatrixSrc.array()) && !BufferMemoryModel.isBufferArray(this.baseMatrixSrc.array());
                }
            } else {
                this.baseMatrixSrc = null;
                if (Arrays.isTiled(dest)) {
                    this.baseMatrixDest = ((ArraysTileMatrixImpl.TileMatrixArray)((Object)dest)).baseMatrix().cast(UpdatableArray.class);
                    assert (this.baseMatrixDest.size() == dest.length()) : "Error in implementation of " + String.valueOf(dest);
                    this.dim = this.baseMatrixDest.dimensions();
                    this.tileDim = Arrays.tileDimensions(dest);
                    double eSize = (double)Arrays.sizeOf(src) / (double)src.length();
                    this.maxBufSize = Math.round((double)Arrays.SystemSettings.availableTempJavaMemoryForTiling() / eSize);
                    this.optimizationPossible = this.copiedLength > 0L && eSize > 0.0 && !SimpleMemoryModel.isSimpleArray(this.baseMatrixDest.array()) && !BufferMemoryModel.isBufferArray(this.baseMatrixDest.array());
                } else {
                    throw new AssertionError((Object)("Internal error while using " + String.valueOf(TileCopier.class)));
                }
            }
            this.n = this.dim.length;
            if (this.n < 1) {
                throw new AssertionError((Object)("Invalid implementation of some classes: number of dimensions is " + this.n));
            }
            this.lastDim = this.dim[this.n - 1];
            this.lastTileDim = this.tileDim[this.n - 1];
            this.layerDim = (long[])this.dim.clone();
            this.layerDim[this.n - 1] = Math.min(this.lastDim, this.lastTileDim);
            this.layerSize = Arrays.longMul(this.layerDim);
            if (this.layerSize < 0L) {
                throw new AssertionError((Object)"Invalid implementation of some classes: illegal product of layer dimensions");
            }
        }

        @Override
        public boolean process() {
            if (!this.optimizationPossible) {
                return super.process();
            }
            if (this.baseMatrixSrc != null && this.baseMatrixDest != null) {
                ArraysBufferedCopier copier = ArraysBufferedCopier.getInstance(this.context, this.baseMatrixDest.array(), this.baseMatrixSrc.array(), this.numberOfTasks, this.strictMode, this.compare);
                boolean result = copier.process();
                this.usedAlgorithm = copier.usedAlgorithm;
                return result;
            }
            assert (this.baseMatrixSrc != null || this.baseMatrixDest != null);
            if (this.copiedLength < this.layerSize) {
                return super.process();
            }
            if (this.layerSize > this.maxBufSize) {
                return super.process();
            }
            Matrix<UpdatableArray> buf = Arrays.SMM.newMatrix(UpdatableArray.class, this.baseMatrixSrc != null ? this.dest.elementType() : this.src.elementType(), this.layerDim);
            Matrix<UpdatableArray> tiledBuf = buf.tile(this.tileDim);
            long tiledArrayLength = this.baseMatrixSrc != null ? this.baseMatrixSrc.size() : this.baseMatrixDest.size();
            boolean result = false;
            long p = 0L;
            long lastCoord = 0L;
            while (p < this.copiedLength) {
                long len = this.layerSize;
                if (p + len > tiledArrayLength) {
                    assert (lastCoord + this.lastTileDim > this.lastDim);
                    len = tiledArrayLength - p;
                }
                if (p + len > this.copiedLength) {
                    assert (this.src.length() != this.dest.length());
                    len = this.copiedLength - p;
                    result |= this.copy(this.context == null ? null : this.context.part(p, p + len, this.copiedLength), this.dest.subArr(p, len), this.src.subArr(p, len), this.compare);
                } else {
                    ArrayContext ac;
                    ArrayContext arrayContext = ac = this.context == null ? null : this.context.part(p, p + len, this.copiedLength);
                    if (lastCoord + this.lastTileDim > this.lastDim) {
                        long[] finishingLayerDim = (long[])this.dim.clone();
                        finishingLayerDim[this.n - 1] = this.lastDim - lastCoord;
                        buf = Matrices.matrix(buf.array().subArr(0L, Arrays.longMul(finishingLayerDim)), finishingLayerDim);
                        tiledBuf = buf.tile(this.tileDim);
                    }
                    if (this.baseMatrixSrc != null) {
                        this.copy(ac == null ? null : ac.part(0.0, 0.3), buf.array(), this.baseMatrixSrc.array().subArr(p, len), false);
                        result |= this.copy(ac == null ? null : ac.part(0.3, 1.0), this.dest.subArr(p, len), tiledBuf.array(), 1, this.compare);
                    } else {
                        this.copy(ac == null ? null : ac.part(0.0, 0.7), tiledBuf.array(), this.src.subArr(p, len), false);
                        result |= this.copy(ac == null ? null : ac.part(0.7, 1.0), this.baseMatrixDest.array().subArr(p, len), buf.array(), 1, this.compare);
                    }
                }
                p += this.layerSize;
                lastCoord += this.lastTileDim;
            }
            this.usedAlgorithm = this.baseMatrixSrc != null ? Arrays.CopyAlgorithm.UNTILING : Arrays.CopyAlgorithm.TILING;
            return result;
        }
    }
}

