/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.Objects;
import net.algart.arrays.AbstractArray;
import net.algart.arrays.Arrays;
import net.algart.arrays.ArraysLinearGetDataOp;
import net.algart.arrays.BitArray;
import net.algart.arrays.ByteArray;
import net.algart.arrays.CharArray;
import net.algart.arrays.DoubleArray;
import net.algart.arrays.FloatArray;
import net.algart.arrays.IntArray;
import net.algart.arrays.LongArray;
import net.algart.arrays.ShortArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.math.functions.LinearFunc;

class ArraysLinearSetDataOp {
    private static final boolean OPTIMIZE_LINEAR_FOR_JARRAYS = true;
    private final boolean truncateOverflows;
    private final UpdatablePArray x;
    private final long length;
    private final double a;
    private final double aInv;
    private final double b;
    private final boolean isCast;
    private final Object ja;
    private final long subArrayOffset;
    private final int xElementTypeCode;
    private final int destElementTypeCode;

    ArraysLinearSetDataOp(boolean truncateOverflows, UpdatablePArray x, LinearFunc.Updatable lf, int destElementTypeCode) {
        Objects.requireNonNull(lf, "Null lf argument");
        if (lf.n() == 0) {
            throw new AssertionError((Object)("No coefficients in the specified function " + String.valueOf(lf)));
        }
        this.truncateOverflows = truncateOverflows;
        this.x = x;
        this.length = x.length();
        this.a = lf.a(0);
        this.aInv = this.a == 1.0 ? 1.0 : 1.0 / this.a;
        this.b = lf.b();
        this.isCast = this.a == 1.0 && this.b == 0.0;
        this.ja = Arrays.javaArrayInternal(this.x);
        this.subArrayOffset = this.ja != null ? (long)Arrays.javaArrayOffsetInternal(this.x) : 0L;
        if (this.x instanceof BitArray) {
            this.xElementTypeCode = 1;
        } else if (this.x instanceof CharArray) {
            this.xElementTypeCode = 2;
        } else if (this.x instanceof ByteArray) {
            this.xElementTypeCode = 3;
        } else if (this.x instanceof ShortArray) {
            this.xElementTypeCode = 4;
        } else if (this.x instanceof IntArray) {
            this.xElementTypeCode = 5;
        } else if (this.x instanceof LongArray) {
            this.xElementTypeCode = 6;
        } else if (this.x instanceof FloatArray) {
            this.xElementTypeCode = 7;
        } else if (this.x instanceof DoubleArray) {
            this.xElementTypeCode = 8;
        } else {
            throw new AssertionError((Object)("Illegal UpdatablePArray type: " + String.valueOf(this.x.getClass())));
        }
        this.destElementTypeCode = destElementTypeCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
        Objects.requireNonNull(srcArray, "Null srcArray argument");
        if (count < 0) {
            throw new IllegalArgumentException("Negative number of stored elements (" + count + ")");
        }
        if (arrayPos < 0L) {
            throw AbstractArray.rangeException(arrayPos, this.length, this.x.getClass());
        }
        if (arrayPos > this.length - (long)count) {
            throw AbstractArray.rangeException(arrayPos + (long)count - 1L, this.length, this.x.getClass());
        }
        while (count > 0) {
            int len = Math.min(count, 16384);
            boolean optimizeJArray = this.ja != null;
            Object[] intBuf = null;
            Object[] doubleBuf = null;
            boolean intBufRequested = false;
            boolean doubleBufRequested = false;
            try {
                int j;
                if (this.isCast && this.destElementTypeCode <= 5) {
                    if (this.destElementTypeCode != 5 || srcArrayOffset != 0) {
                        intBuf = (int[])ArraysLinearGetDataOp.INT_BUFFERS.requestArray();
                        intBufRequested = true;
                    }
                } else if (!this.isCast || this.destElementTypeCode != 8 || srcArrayOffset != 0) {
                    doubleBuf = (double[])ArraysLinearGetDataOp.DOUBLE_BUFFERS.requestArray();
                    doubleBufRequested = true;
                }
                switch (this.destElementTypeCode) {
                    case 1: {
                        Object[] src = (boolean[])srcArray;
                        if (this.isCast) {
                            j = 0;
                            while (j < len) {
                                intBuf[j] = src[srcArrayOffset] ? 1 : 0;
                                ++j;
                                ++srcArrayOffset;
                            }
                        } else {
                            double vFalse = -this.b / this.a + 0.0;
                            double vTrue = (1.0 - this.b) / this.a + 0.0;
                            int j2 = 0;
                            while (j2 < len) {
                                doubleBuf[j2] = src[srcArrayOffset] ? vTrue : vFalse;
                                ++j2;
                                ++srcArrayOffset;
                            }
                        }
                        break;
                    }
                    case 2: {
                        Object[] src = (char[])srcArray;
                        if (this.isCast) {
                            j = 0;
                            while (j < len) {
                                intBuf[j] = src[srcArrayOffset];
                                ++j;
                                ++srcArrayOffset;
                            }
                        } else {
                            j = 0;
                            while (j < len) {
                                doubleBuf[j] = ((double)src[srcArrayOffset] - this.b) * this.aInv;
                                ++j;
                                ++srcArrayOffset;
                            }
                        }
                        break;
                    }
                    case 3: {
                        Object[] src = (byte[])srcArray;
                        if (this.isCast) {
                            j = 0;
                            while (j < len) {
                                intBuf[j] = src[srcArrayOffset] & 0xFF;
                                ++j;
                                ++srcArrayOffset;
                            }
                        } else {
                            j = 0;
                            while (j < len) {
                                doubleBuf[j] = ((double)(src[srcArrayOffset] & 0xFF) - this.b) * this.aInv;
                                ++j;
                                ++srcArrayOffset;
                            }
                        }
                        break;
                    }
                    case 4: {
                        Object[] src = (short[])srcArray;
                        if (this.isCast) {
                            j = 0;
                            while (j < len) {
                                intBuf[j] = src[srcArrayOffset] & 0xFFFF;
                                ++j;
                                ++srcArrayOffset;
                            }
                        } else {
                            j = 0;
                            while (j < len) {
                                doubleBuf[j] = ((double)(src[srcArrayOffset] & 0xFFFF) - this.b) * this.aInv;
                                ++j;
                                ++srcArrayOffset;
                            }
                        }
                        break;
                    }
                    case 5: {
                        Object[] src = (int[])srcArray;
                        if (this.isCast) {
                            if (srcArrayOffset == 0) {
                                intBuf = src;
                                break;
                            }
                            System.arraycopy(src, srcArrayOffset, intBuf, 0, len);
                            break;
                        }
                        j = 0;
                        while (j < len) {
                            doubleBuf[j] = ((double)src[srcArrayOffset] - this.b) * this.aInv;
                            ++j;
                            ++srcArrayOffset;
                        }
                        break;
                    }
                    case 6: {
                        Object[] src = (long[])srcArray;
                        if (this.isCast) {
                            j = 0;
                            while (j < len) {
                                doubleBuf[j] = (double)src[srcArrayOffset];
                                ++j;
                                ++srcArrayOffset;
                            }
                        } else {
                            j = 0;
                            while (j < len) {
                                doubleBuf[j] = ((double)src[srcArrayOffset] - this.b) * this.aInv;
                                ++j;
                                ++srcArrayOffset;
                            }
                        }
                        break;
                    }
                    case 7: {
                        Object[] src = (float[])srcArray;
                        if (this.isCast) {
                            j = 0;
                            while (j < len) {
                                doubleBuf[j] = (double)src[srcArrayOffset];
                                ++j;
                                ++srcArrayOffset;
                            }
                        } else {
                            j = 0;
                            while (j < len) {
                                doubleBuf[j] = ((double)src[srcArrayOffset] - this.b) * this.aInv;
                                ++j;
                                ++srcArrayOffset;
                            }
                        }
                        break;
                    }
                    case 8: {
                        Object[] src = (double[])srcArray;
                        if (this.isCast) {
                            if (srcArrayOffset == 0) {
                                doubleBuf = src;
                                break;
                            }
                            System.arraycopy(src, srcArrayOffset, doubleBuf, 0, len);
                            break;
                        }
                        j = 0;
                        while (j < len) {
                            doubleBuf[j] = (src[srcArrayOffset] - this.b) * this.aInv;
                            ++j;
                            ++srcArrayOffset;
                        }
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)"Illegal destElementTypeCode");
                    }
                }
                assert (intBuf == null != (doubleBuf == null));
                switch (this.xElementTypeCode) {
                    case 1: {
                        Object[] dest = (boolean[])ArraysLinearGetDataOp.BOOLEAN_BUFFERS.requestArray();
                        try {
                            if (intBuf != null) {
                                for (j = 0; j < len; ++j) {
                                    dest[j] = intBuf[j] != 0;
                                }
                            } else {
                                for (j = 0; j < len; ++j) {
                                    dest[j] = doubleBuf[j] != 0.0;
                                }
                            }
                            this.x.setData(arrayPos, dest, 0, len);
                            break;
                        }
                        finally {
                            ArraysLinearGetDataOp.BOOLEAN_BUFFERS.releaseArray(dest);
                        }
                    }
                    case 2: {
                        int v;
                        int j3;
                        int destOffset;
                        Object[] dest;
                        if (optimizeJArray) {
                            dest = (char[])this.ja;
                            destOffset = (int)(arrayPos + this.subArrayOffset);
                            if (intBuf != null) {
                                if (this.truncateOverflows) {
                                    j3 = 0;
                                    while (j3 < len) {
                                        int v2 = intBuf[j3];
                                        dest[destOffset] = (char)(v2 < 0 ? 0 : (char)(v2 > 65535 ? 65535 : (char)v2));
                                        ++j3;
                                        ++destOffset;
                                    }
                                } else {
                                    j3 = 0;
                                    while (j3 < len) {
                                        dest[destOffset] = (char)intBuf[j3];
                                        ++j3;
                                        ++destOffset;
                                    }
                                }
                            } else if (this.truncateOverflows) {
                                j3 = 0;
                                while (j3 < len) {
                                    int v3 = (int)doubleBuf[j3];
                                    dest[destOffset] = (char)(v3 < 0 ? 0 : (char)(v3 > 65535 ? 65535 : (char)v3));
                                    ++j3;
                                    ++destOffset;
                                }
                            } else {
                                j3 = 0;
                                while (j3 < len) {
                                    dest[destOffset] = (char)doubleBuf[j3];
                                    ++j3;
                                    ++destOffset;
                                }
                            }
                            break;
                        }
                        dest = (char[])ArraysLinearGetDataOp.CHAR_BUFFERS.requestArray();
                        try {
                            if (intBuf != null) {
                                if (this.truncateOverflows) {
                                    for (j = 0; j < len; ++j) {
                                        v = intBuf[j];
                                        dest[j] = (char)(v < 0 ? 0 : (char)(v > 65535 ? 65535 : (char)v));
                                    }
                                } else {
                                    for (j = 0; j < len; ++j) {
                                        dest[j] = (char)intBuf[j];
                                    }
                                }
                            } else if (this.truncateOverflows) {
                                for (j = 0; j < len; ++j) {
                                    v = (int)doubleBuf[j];
                                    dest[j] = (char)(v < 0 ? 0 : (char)(v > 65535 ? 65535 : (char)v));
                                }
                            } else {
                                for (j = 0; j < len; ++j) {
                                    dest[j] = (char)doubleBuf[j];
                                }
                            }
                            this.x.setData(arrayPos, dest, 0, len);
                            break;
                        }
                        finally {
                            ArraysLinearGetDataOp.CHAR_BUFFERS.releaseArray(dest);
                        }
                    }
                    case 3: {
                        int v;
                        int j3;
                        int destOffset;
                        Object[] dest;
                        if (optimizeJArray) {
                            dest = (byte[])this.ja;
                            destOffset = (int)(arrayPos + this.subArrayOffset);
                            if (intBuf != null) {
                                if (this.truncateOverflows) {
                                    j3 = 0;
                                    while (j3 < len) {
                                        int v4 = intBuf[j3];
                                        dest[destOffset] = (byte)(v4 < 0 ? 0 : Math.min(v4, 255));
                                        ++j3;
                                        ++destOffset;
                                    }
                                } else {
                                    j3 = 0;
                                    while (j3 < len) {
                                        dest[destOffset] = (byte)intBuf[j3];
                                        ++j3;
                                        ++destOffset;
                                    }
                                }
                            } else if (this.truncateOverflows) {
                                j3 = 0;
                                while (j3 < len) {
                                    int v5 = (int)doubleBuf[j3];
                                    dest[destOffset] = (byte)(v5 < 0 ? 0 : Math.min(v5, 255));
                                    ++j3;
                                    ++destOffset;
                                }
                            } else {
                                j3 = 0;
                                while (j3 < len) {
                                    dest[destOffset] = (byte)doubleBuf[j3];
                                    ++j3;
                                    ++destOffset;
                                }
                            }
                            break;
                        }
                        dest = (byte[])ArraysLinearGetDataOp.BYTE_BUFFERS.requestArray();
                        try {
                            if (intBuf != null) {
                                if (this.truncateOverflows) {
                                    for (j = 0; j < len; ++j) {
                                        v = intBuf[j];
                                        dest[j] = (byte)(v < 0 ? 0 : Math.min(v, 255));
                                    }
                                } else {
                                    for (j = 0; j < len; ++j) {
                                        dest[j] = (byte)intBuf[j];
                                    }
                                }
                            } else if (this.truncateOverflows) {
                                for (j = 0; j < len; ++j) {
                                    v = (int)doubleBuf[j];
                                    dest[j] = (byte)(v < 0 ? 0 : Math.min(v, 255));
                                }
                            } else {
                                for (j = 0; j < len; ++j) {
                                    dest[j] = (byte)doubleBuf[j];
                                }
                            }
                            this.x.setData(arrayPos, dest, 0, len);
                            break;
                        }
                        finally {
                            ArraysLinearGetDataOp.BYTE_BUFFERS.releaseArray(dest);
                        }
                    }
                    case 4: {
                        int v;
                        int j3;
                        int destOffset;
                        Object[] dest;
                        if (optimizeJArray) {
                            dest = (short[])this.ja;
                            destOffset = (int)(arrayPos + this.subArrayOffset);
                            if (intBuf != null) {
                                if (this.truncateOverflows) {
                                    j3 = 0;
                                    while (j3 < len) {
                                        int v6 = intBuf[j3];
                                        dest[destOffset] = (short)(v6 < 0 ? 0 : Math.min(v6, 65535));
                                        ++j3;
                                        ++destOffset;
                                    }
                                } else {
                                    j3 = 0;
                                    while (j3 < len) {
                                        dest[destOffset] = (short)intBuf[j3];
                                        ++j3;
                                        ++destOffset;
                                    }
                                }
                            } else if (this.truncateOverflows) {
                                j3 = 0;
                                while (j3 < len) {
                                    int v7 = (int)doubleBuf[j3];
                                    dest[destOffset] = (short)(v7 < 0 ? 0 : Math.min(v7, 65535));
                                    ++j3;
                                    ++destOffset;
                                }
                            } else {
                                j3 = 0;
                                while (j3 < len) {
                                    dest[destOffset] = (short)doubleBuf[j3];
                                    ++j3;
                                    ++destOffset;
                                }
                            }
                            break;
                        }
                        dest = (short[])ArraysLinearGetDataOp.SHORT_BUFFERS.requestArray();
                        try {
                            if (intBuf != null) {
                                if (this.truncateOverflows) {
                                    for (j = 0; j < len; ++j) {
                                        v = intBuf[j];
                                        dest[j] = (short)(v < 0 ? 0 : Math.min(v, 65535));
                                    }
                                } else {
                                    for (j = 0; j < len; ++j) {
                                        dest[j] = (short)intBuf[j];
                                    }
                                }
                            } else if (this.truncateOverflows) {
                                for (j = 0; j < len; ++j) {
                                    v = (int)doubleBuf[j];
                                    dest[j] = (short)(v < 0 ? 0 : Math.min(v, 65535));
                                }
                            } else {
                                for (j = 0; j < len; ++j) {
                                    dest[j] = (short)doubleBuf[j];
                                }
                            }
                            this.x.setData(arrayPos, dest, 0, len);
                            break;
                        }
                        finally {
                            ArraysLinearGetDataOp.SHORT_BUFFERS.releaseArray(dest);
                        }
                    }
                    case 5: {
                        int j3;
                        int destOffset;
                        Object[] dest;
                        if (optimizeJArray) {
                            dest = (int[])this.ja;
                            destOffset = (int)(arrayPos + this.subArrayOffset);
                            if (intBuf != null) {
                                System.arraycopy(intBuf, 0, dest, destOffset, len);
                                break;
                            }
                            if (this.truncateOverflows) {
                                j3 = 0;
                                while (j3 < len) {
                                    dest[destOffset] = (int)doubleBuf[j3];
                                    ++j3;
                                    ++destOffset;
                                }
                            } else {
                                j3 = 0;
                                while (j3 < len) {
                                    dest[destOffset] = (int)doubleBuf[j3];
                                    ++j3;
                                    ++destOffset;
                                }
                            }
                            break;
                        }
                        if (intBuf != null) {
                            this.x.setData(arrayPos, intBuf, 0, len);
                            break;
                        }
                        dest = (int[])ArraysLinearGetDataOp.INT_BUFFERS.requestArray();
                        try {
                            if (this.truncateOverflows) {
                                for (j = 0; j < len; ++j) {
                                    dest[j] = (int)doubleBuf[j];
                                }
                            } else {
                                for (j = 0; j < len; ++j) {
                                    dest[j] = (int)doubleBuf[j];
                                }
                            }
                            this.x.setData(arrayPos, dest, 0, len);
                            break;
                        }
                        finally {
                            ArraysLinearGetDataOp.INT_BUFFERS.releaseArray(dest);
                        }
                    }
                    case 6: {
                        int j3;
                        int destOffset;
                        Object[] dest;
                        if (optimizeJArray) {
                            dest = (long[])this.ja;
                            destOffset = (int)(arrayPos + this.subArrayOffset);
                            if (intBuf != null) {
                                j3 = 0;
                                while (j3 < len) {
                                    dest[destOffset] = intBuf[j3];
                                    ++j3;
                                    ++destOffset;
                                }
                            } else {
                                j3 = 0;
                                while (j3 < len) {
                                    dest[destOffset] = (long)doubleBuf[j3];
                                    ++j3;
                                    ++destOffset;
                                }
                            }
                            break;
                        }
                        dest = (long[])ArraysLinearGetDataOp.LONG_BUFFERS.requestArray();
                        try {
                            if (intBuf != null) {
                                for (j = 0; j < len; ++j) {
                                    dest[j] = intBuf[j];
                                }
                            } else {
                                for (j = 0; j < len; ++j) {
                                    dest[j] = (long)doubleBuf[j];
                                }
                            }
                            this.x.setData(arrayPos, dest, 0, len);
                            break;
                        }
                        finally {
                            ArraysLinearGetDataOp.LONG_BUFFERS.releaseArray(dest);
                        }
                    }
                    case 7: {
                        int j3;
                        int destOffset;
                        Object[] dest;
                        if (optimizeJArray) {
                            dest = (float[])this.ja;
                            destOffset = (int)(arrayPos + this.subArrayOffset);
                            if (intBuf != null) {
                                j3 = 0;
                                while (j3 < len) {
                                    dest[destOffset] = intBuf[j3];
                                    ++j3;
                                    ++destOffset;
                                }
                            } else {
                                j3 = 0;
                                while (j3 < len) {
                                    dest[destOffset] = (float)doubleBuf[j3];
                                    ++j3;
                                    ++destOffset;
                                }
                            }
                            break;
                        }
                        dest = (float[])ArraysLinearGetDataOp.FLOAT_BUFFERS.requestArray();
                        try {
                            if (intBuf != null) {
                                for (j = 0; j < len; ++j) {
                                    dest[j] = intBuf[j];
                                }
                            } else {
                                for (j = 0; j < len; ++j) {
                                    dest[j] = (float)doubleBuf[j];
                                }
                            }
                            this.x.setData(arrayPos, dest, 0, len);
                            break;
                        }
                        finally {
                            ArraysLinearGetDataOp.FLOAT_BUFFERS.releaseArray(dest);
                        }
                    }
                    case 8: {
                        int j3;
                        int destOffset;
                        Object[] dest;
                        if (optimizeJArray) {
                            dest = (double[])this.ja;
                            destOffset = (int)(arrayPos + this.subArrayOffset);
                            if (intBuf != null) {
                                j3 = 0;
                                while (j3 < len) {
                                    dest[destOffset] = intBuf[j3];
                                    ++j3;
                                    ++destOffset;
                                }
                                break;
                            }
                            System.arraycopy(doubleBuf, 0, dest, destOffset, len);
                            break;
                        }
                        if (intBuf == null) {
                            this.x.setData(arrayPos, doubleBuf, 0, len);
                            break;
                        }
                        dest = (double[])ArraysLinearGetDataOp.DOUBLE_BUFFERS.requestArray();
                        try {
                            for (j = 0; j < len; ++j) {
                                dest[j] = intBuf[j];
                            }
                            this.x.setData(arrayPos, dest, 0, len);
                            break;
                        }
                        finally {
                            ArraysLinearGetDataOp.DOUBLE_BUFFERS.releaseArray(dest);
                        }
                    }
                    default: {
                        throw new AssertionError((Object)"Illegal srcElementTypeCode");
                    }
                }
                if (intBufRequested) {
                    ArraysLinearGetDataOp.INT_BUFFERS.releaseArray(intBuf);
                }
                if (doubleBufRequested) {
                    ArraysLinearGetDataOp.DOUBLE_BUFFERS.releaseArray(doubleBuf);
                }
            }
            catch (Throwable throwable) {
                if (intBufRequested) {
                    ArraysLinearGetDataOp.INT_BUFFERS.releaseArray(intBuf);
                }
                if (doubleBufRequested) {
                    ArraysLinearGetDataOp.DOUBLE_BUFFERS.releaseArray(doubleBuf);
                }
                throw throwable;
            }
            arrayPos += (long)len;
            count -= len;
        }
    }
}

