/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import net.algart.arrays.Arrays;
import net.algart.arrays.ArraysInterpolationsImpl;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;

class ArraysPolylinearInterpolationsImpl {
    ArraysPolylinearInterpolationsImpl() {
    }

    static class ContinuedPolylinearDoubleInterpolation
    extends ContinuedPolylinearInterpolation {
        private final double[] arr;
        private final int ofs;

        ContinuedPolylinearDoubleInterpolation(Matrix<? extends PArray> m, double outsideValue) {
            super(m, outsideValue);
            this.arr = (double[])Arrays.javaArrayInternal(this.array);
            this.ofs = Arrays.javaArrayOffsetInternal(this.array);
        }

        @Override
        public double get(double x) {
            int ix = (int)x;
            if (ix < 0 || ix >= this.idimX - 1) {
                return ix == this.idimX - 1 ? this.arr[this.ofs + ix] : this.outsideValue;
            }
            double a = this.arr[this.ofs + ix];
            double b = this.arr[this.ofs + ix + 1];
            return (a - b) * ((double)ix - x) + a;
        }

        @Override
        public double get(double x, double y) {
            int ix = (int)x;
            int iy = (int)y;
            if (ix < 0 || ix >= this.idimX - 1 || iy < 0 || iy >= this.idimY - 1) {
                if (ix == this.idimX - 1 || iy == this.idimY - 1) {
                    return super.get(x, y);
                }
                return this.outsideValue;
            }
            int ofs1 = iy * this.idimX + ix;
            int ofs2 = ofs1 + this.idimX;
            double a = this.arr[this.ofs + ofs1];
            double b = this.arr[this.ofs + ofs1 + 1];
            double v1 = (a - b) * ((double)ix - x) + a;
            double c = this.arr[this.ofs + ofs2];
            double d = this.arr[this.ofs + ofs2 + 1];
            double v2 = (c - d) * ((double)ix - x) + c;
            return (v1 - v2) * ((double)iy - y) + v1;
        }
    }

    static class CheckedPolylinearDoubleInterpolation
    extends CheckedPolylinearInterpolation {
        private final double[] arr;
        private final int ofs;

        CheckedPolylinearDoubleInterpolation(Matrix<? extends PArray> m) {
            super(m);
            this.arr = (double[])Arrays.javaArrayInternal(this.array);
            this.ofs = Arrays.javaArrayOffsetInternal(this.array);
        }

        @Override
        public double get(double x) {
            int ix = (int)x;
            this.checkIntIndex0(ix);
            double a = this.arr[this.ofs + ix];
            if (ix == this.idimX - 1) {
                return a;
            }
            double b = this.arr[this.ofs + ix + 1];
            return (a - b) * ((double)ix - x) + a;
        }

        @Override
        public double get(double x, double y) {
            int ix = (int)x;
            int iy = (int)y;
            if (ix < 0 || ix >= this.idimX - 1 || iy < 0 || iy >= this.idimY - 1) {
                if (ix == this.idimX - 1 || iy == this.idimY - 1) {
                    return super.get(x, y);
                }
                this.checkIntIndex0(ix);
                this.checkIntIndex1(iy);
                throw new AssertionError();
            }
            int ofs1 = iy * this.idimX + ix;
            int ofs2 = ofs1 + this.idimX;
            double a = this.arr[this.ofs + ofs1];
            double b = this.arr[this.ofs + ofs1 + 1];
            double v1 = (a - b) * ((double)ix - x) + a;
            double c = this.arr[this.ofs + ofs2];
            double d = this.arr[this.ofs + ofs2 + 1];
            double v2 = (c - d) * ((double)ix - x) + c;
            return (v1 - v2) * ((double)iy - y) + v1;
        }
    }

    static class UncheckedPolylinearDoubleInterpolation
    extends UncheckedPolylinearInterpolation {
        private final double[] arr;
        private final int ofs;

        UncheckedPolylinearDoubleInterpolation(Matrix<? extends PArray> m) {
            super(m);
            this.arr = (double[])Arrays.javaArrayInternal(this.array);
            this.ofs = Arrays.javaArrayOffsetInternal(this.array);
        }

        @Override
        public double get(double x) {
            int ix = (int)x;
            double a = this.arr[this.ofs + ix];
            if (ix == this.idimX - 1) {
                return a;
            }
            double b = this.arr[this.ofs + ix + 1];
            return (a - b) * ((double)ix - x) + a;
        }

        @Override
        public double get(double x, double y) {
            int ix = (int)x;
            int iy = (int)y;
            int ofs1 = iy * this.idimX + ix;
            int ofs2 = ofs1 + this.idimX;
            double a = this.arr[this.ofs + ofs1];
            double b = ix == this.idimX - 1 ? a : this.arr[this.ofs + ofs1 + 1];
            double v1 = (a - b) * ((double)ix - x) + a;
            if (iy == this.idimY - 1) {
                return v1;
            }
            double c = this.arr[this.ofs + ofs2];
            double d = ix == this.idimX - 1 ? c : this.arr[this.ofs + ofs2 + 1];
            double v2 = (c - d) * ((double)ix - x) + c;
            return (v1 - v2) * ((double)iy - y) + v1;
        }
    }

    static class ContinuedPolylinearFloatInterpolation
    extends ContinuedPolylinearInterpolation {
        private final float[] arr;
        private final int ofs;

        ContinuedPolylinearFloatInterpolation(Matrix<? extends PArray> m, double outsideValue) {
            super(m, outsideValue);
            this.arr = (float[])Arrays.javaArrayInternal(this.array);
            this.ofs = Arrays.javaArrayOffsetInternal(this.array);
        }

        @Override
        public double get(double x) {
            int ix = (int)x;
            if (ix < 0 || ix >= this.idimX - 1) {
                return ix == this.idimX - 1 ? (double)this.arr[this.ofs + ix] : this.outsideValue;
            }
            double a = this.arr[this.ofs + ix];
            double b = this.arr[this.ofs + ix + 1];
            return (a - b) * ((double)ix - x) + a;
        }

        @Override
        public double get(double x, double y) {
            int ix = (int)x;
            int iy = (int)y;
            if (ix < 0 || ix >= this.idimX - 1 || iy < 0 || iy >= this.idimY - 1) {
                if (ix == this.idimX - 1 || iy == this.idimY - 1) {
                    return super.get(x, y);
                }
                return this.outsideValue;
            }
            int ofs1 = iy * this.idimX + ix;
            int ofs2 = ofs1 + this.idimX;
            double a = this.arr[this.ofs + ofs1];
            double b = this.arr[this.ofs + ofs1 + 1];
            double v1 = (a - b) * ((double)ix - x) + a;
            double c = this.arr[this.ofs + ofs2];
            double d = this.arr[this.ofs + ofs2 + 1];
            double v2 = (c - d) * ((double)ix - x) + c;
            return (v1 - v2) * ((double)iy - y) + v1;
        }
    }

    static class CheckedPolylinearFloatInterpolation
    extends CheckedPolylinearInterpolation {
        private final float[] arr;
        private final int ofs;

        CheckedPolylinearFloatInterpolation(Matrix<? extends PArray> m) {
            super(m);
            this.arr = (float[])Arrays.javaArrayInternal(this.array);
            this.ofs = Arrays.javaArrayOffsetInternal(this.array);
        }

        @Override
        public double get(double x) {
            int ix = (int)x;
            this.checkIntIndex0(ix);
            double a = this.arr[this.ofs + ix];
            if (ix == this.idimX - 1) {
                return a;
            }
            double b = this.arr[this.ofs + ix + 1];
            return (a - b) * ((double)ix - x) + a;
        }

        @Override
        public double get(double x, double y) {
            int ix = (int)x;
            int iy = (int)y;
            if (ix < 0 || ix >= this.idimX - 1 || iy < 0 || iy >= this.idimY - 1) {
                if (ix == this.idimX - 1 || iy == this.idimY - 1) {
                    return super.get(x, y);
                }
                this.checkIntIndex0(ix);
                this.checkIntIndex1(iy);
                throw new AssertionError();
            }
            int ofs1 = iy * this.idimX + ix;
            int ofs2 = ofs1 + this.idimX;
            double a = this.arr[this.ofs + ofs1];
            double b = this.arr[this.ofs + ofs1 + 1];
            double v1 = (a - b) * ((double)ix - x) + a;
            double c = this.arr[this.ofs + ofs2];
            double d = this.arr[this.ofs + ofs2 + 1];
            double v2 = (c - d) * ((double)ix - x) + c;
            return (v1 - v2) * ((double)iy - y) + v1;
        }
    }

    static class UncheckedPolylinearFloatInterpolation
    extends UncheckedPolylinearInterpolation {
        private final float[] arr;
        private final int ofs;

        UncheckedPolylinearFloatInterpolation(Matrix<? extends PArray> m) {
            super(m);
            this.arr = (float[])Arrays.javaArrayInternal(this.array);
            this.ofs = Arrays.javaArrayOffsetInternal(this.array);
        }

        @Override
        public double get(double x) {
            int ix = (int)x;
            double a = this.arr[this.ofs + ix];
            if (ix == this.idimX - 1) {
                return a;
            }
            double b = this.arr[this.ofs + ix + 1];
            return (a - b) * ((double)ix - x) + a;
        }

        @Override
        public double get(double x, double y) {
            int ix = (int)x;
            int iy = (int)y;
            int ofs1 = iy * this.idimX + ix;
            int ofs2 = ofs1 + this.idimX;
            double a = this.arr[this.ofs + ofs1];
            double b = ix == this.idimX - 1 ? a : (double)this.arr[this.ofs + ofs1 + 1];
            double v1 = (a - b) * ((double)ix - x) + a;
            if (iy == this.idimY - 1) {
                return v1;
            }
            double c = this.arr[this.ofs + ofs2];
            double d = ix == this.idimX - 1 ? c : (double)this.arr[this.ofs + ofs2 + 1];
            double v2 = (c - d) * ((double)ix - x) + c;
            return (v1 - v2) * ((double)iy - y) + v1;
        }
    }

    static class ContinuedPolylinearLongInterpolation
    extends ContinuedPolylinearInterpolation {
        private final long[] arr;
        private final int ofs;

        ContinuedPolylinearLongInterpolation(Matrix<? extends PArray> m, double outsideValue) {
            super(m, outsideValue);
            this.arr = (long[])Arrays.javaArrayInternal(this.array);
            this.ofs = Arrays.javaArrayOffsetInternal(this.array);
        }

        @Override
        public double get(double x) {
            int ix = (int)x;
            if (ix < 0 || ix >= this.idimX - 1) {
                return ix == this.idimX - 1 ? (double)this.arr[this.ofs + ix] : this.outsideValue;
            }
            double a = this.arr[this.ofs + ix];
            double b = this.arr[this.ofs + ix + 1];
            return (a - b) * ((double)ix - x) + a;
        }

        @Override
        public double get(double x, double y) {
            int ix = (int)x;
            int iy = (int)y;
            if (ix < 0 || ix >= this.idimX - 1 || iy < 0 || iy >= this.idimY - 1) {
                if (ix == this.idimX - 1 || iy == this.idimY - 1) {
                    return super.get(x, y);
                }
                return this.outsideValue;
            }
            int ofs1 = iy * this.idimX + ix;
            int ofs2 = ofs1 + this.idimX;
            double a = this.arr[this.ofs + ofs1];
            double b = this.arr[this.ofs + ofs1 + 1];
            double v1 = (a - b) * ((double)ix - x) + a;
            double c = this.arr[this.ofs + ofs2];
            double d = this.arr[this.ofs + ofs2 + 1];
            double v2 = (c - d) * ((double)ix - x) + c;
            return (v1 - v2) * ((double)iy - y) + v1;
        }
    }

    static class CheckedPolylinearLongInterpolation
    extends CheckedPolylinearInterpolation {
        private final long[] arr;
        private final int ofs;

        CheckedPolylinearLongInterpolation(Matrix<? extends PArray> m) {
            super(m);
            this.arr = (long[])Arrays.javaArrayInternal(this.array);
            this.ofs = Arrays.javaArrayOffsetInternal(this.array);
        }

        @Override
        public double get(double x) {
            int ix = (int)x;
            this.checkIntIndex0(ix);
            double a = this.arr[this.ofs + ix];
            if (ix == this.idimX - 1) {
                return a;
            }
            double b = this.arr[this.ofs + ix + 1];
            return (a - b) * ((double)ix - x) + a;
        }

        @Override
        public double get(double x, double y) {
            int ix = (int)x;
            int iy = (int)y;
            if (ix < 0 || ix >= this.idimX - 1 || iy < 0 || iy >= this.idimY - 1) {
                if (ix == this.idimX - 1 || iy == this.idimY - 1) {
                    return super.get(x, y);
                }
                this.checkIntIndex0(ix);
                this.checkIntIndex1(iy);
                throw new AssertionError();
            }
            int ofs1 = iy * this.idimX + ix;
            int ofs2 = ofs1 + this.idimX;
            double a = this.arr[this.ofs + ofs1];
            double b = this.arr[this.ofs + ofs1 + 1];
            double v1 = (a - b) * ((double)ix - x) + a;
            double c = this.arr[this.ofs + ofs2];
            double d = this.arr[this.ofs + ofs2 + 1];
            double v2 = (c - d) * ((double)ix - x) + c;
            return (v1 - v2) * ((double)iy - y) + v1;
        }
    }

    static class UncheckedPolylinearLongInterpolation
    extends UncheckedPolylinearInterpolation {
        private final long[] arr;
        private final int ofs;

        UncheckedPolylinearLongInterpolation(Matrix<? extends PArray> m) {
            super(m);
            this.arr = (long[])Arrays.javaArrayInternal(this.array);
            this.ofs = Arrays.javaArrayOffsetInternal(this.array);
        }

        @Override
        public double get(double x) {
            int ix = (int)x;
            double a = this.arr[this.ofs + ix];
            if (ix == this.idimX - 1) {
                return a;
            }
            double b = this.arr[this.ofs + ix + 1];
            return (a - b) * ((double)ix - x) + a;
        }

        @Override
        public double get(double x, double y) {
            int ix = (int)x;
            int iy = (int)y;
            int ofs1 = iy * this.idimX + ix;
            int ofs2 = ofs1 + this.idimX;
            double a = this.arr[this.ofs + ofs1];
            double b = ix == this.idimX - 1 ? a : (double)this.arr[this.ofs + ofs1 + 1];
            double v1 = (a - b) * ((double)ix - x) + a;
            if (iy == this.idimY - 1) {
                return v1;
            }
            double c = this.arr[this.ofs + ofs2];
            double d = ix == this.idimX - 1 ? c : (double)this.arr[this.ofs + ofs2 + 1];
            double v2 = (c - d) * ((double)ix - x) + c;
            return (v1 - v2) * ((double)iy - y) + v1;
        }
    }

    static class ContinuedPolylinearIntInterpolation
    extends ContinuedPolylinearInterpolation {
        private final int[] arr;
        private final int ofs;

        ContinuedPolylinearIntInterpolation(Matrix<? extends PArray> m, double outsideValue) {
            super(m, outsideValue);
            this.arr = (int[])Arrays.javaArrayInternal(this.array);
            this.ofs = Arrays.javaArrayOffsetInternal(this.array);
        }

        @Override
        public double get(double x) {
            int ix = (int)x;
            if (ix < 0 || ix >= this.idimX - 1) {
                return ix == this.idimX - 1 ? (double)this.arr[this.ofs + ix] : this.outsideValue;
            }
            double a = this.arr[this.ofs + ix];
            double b = this.arr[this.ofs + ix + 1];
            return (a - b) * ((double)ix - x) + a;
        }

        @Override
        public double get(double x, double y) {
            int ix = (int)x;
            int iy = (int)y;
            if (ix < 0 || ix >= this.idimX - 1 || iy < 0 || iy >= this.idimY - 1) {
                if (ix == this.idimX - 1 || iy == this.idimY - 1) {
                    return super.get(x, y);
                }
                return this.outsideValue;
            }
            int ofs1 = iy * this.idimX + ix;
            int ofs2 = ofs1 + this.idimX;
            double a = this.arr[this.ofs + ofs1];
            double b = this.arr[this.ofs + ofs1 + 1];
            double v1 = (a - b) * ((double)ix - x) + a;
            double c = this.arr[this.ofs + ofs2];
            double d = this.arr[this.ofs + ofs2 + 1];
            double v2 = (c - d) * ((double)ix - x) + c;
            return (v1 - v2) * ((double)iy - y) + v1;
        }
    }

    static class CheckedPolylinearIntInterpolation
    extends CheckedPolylinearInterpolation {
        private final int[] arr;
        private final int ofs;

        CheckedPolylinearIntInterpolation(Matrix<? extends PArray> m) {
            super(m);
            this.arr = (int[])Arrays.javaArrayInternal(this.array);
            this.ofs = Arrays.javaArrayOffsetInternal(this.array);
        }

        @Override
        public double get(double x) {
            int ix = (int)x;
            this.checkIntIndex0(ix);
            double a = this.arr[this.ofs + ix];
            if (ix == this.idimX - 1) {
                return a;
            }
            double b = this.arr[this.ofs + ix + 1];
            return (a - b) * ((double)ix - x) + a;
        }

        @Override
        public double get(double x, double y) {
            int ix = (int)x;
            int iy = (int)y;
            if (ix < 0 || ix >= this.idimX - 1 || iy < 0 || iy >= this.idimY - 1) {
                if (ix == this.idimX - 1 || iy == this.idimY - 1) {
                    return super.get(x, y);
                }
                this.checkIntIndex0(ix);
                this.checkIntIndex1(iy);
                throw new AssertionError();
            }
            int ofs1 = iy * this.idimX + ix;
            int ofs2 = ofs1 + this.idimX;
            double a = this.arr[this.ofs + ofs1];
            double b = this.arr[this.ofs + ofs1 + 1];
            double v1 = (a - b) * ((double)ix - x) + a;
            double c = this.arr[this.ofs + ofs2];
            double d = this.arr[this.ofs + ofs2 + 1];
            double v2 = (c - d) * ((double)ix - x) + c;
            return (v1 - v2) * ((double)iy - y) + v1;
        }
    }

    static class UncheckedPolylinearIntInterpolation
    extends UncheckedPolylinearInterpolation {
        private final int[] arr;
        private final int ofs;

        UncheckedPolylinearIntInterpolation(Matrix<? extends PArray> m) {
            super(m);
            this.arr = (int[])Arrays.javaArrayInternal(this.array);
            this.ofs = Arrays.javaArrayOffsetInternal(this.array);
        }

        @Override
        public double get(double x) {
            int ix = (int)x;
            double a = this.arr[this.ofs + ix];
            if (ix == this.idimX - 1) {
                return a;
            }
            double b = this.arr[this.ofs + ix + 1];
            return (a - b) * ((double)ix - x) + a;
        }

        @Override
        public double get(double x, double y) {
            int ix = (int)x;
            int iy = (int)y;
            int ofs1 = iy * this.idimX + ix;
            int ofs2 = ofs1 + this.idimX;
            double a = this.arr[this.ofs + ofs1];
            double b = ix == this.idimX - 1 ? a : (double)this.arr[this.ofs + ofs1 + 1];
            double v1 = (a - b) * ((double)ix - x) + a;
            if (iy == this.idimY - 1) {
                return v1;
            }
            double c = this.arr[this.ofs + ofs2];
            double d = ix == this.idimX - 1 ? c : (double)this.arr[this.ofs + ofs2 + 1];
            double v2 = (c - d) * ((double)ix - x) + c;
            return (v1 - v2) * ((double)iy - y) + v1;
        }
    }

    static class ContinuedPolylinearShortInterpolation
    extends ContinuedPolylinearInterpolation {
        private final short[] arr;
        private final int ofs;

        ContinuedPolylinearShortInterpolation(Matrix<? extends PArray> m, double outsideValue) {
            super(m, outsideValue);
            this.arr = (short[])Arrays.javaArrayInternal(this.array);
            this.ofs = Arrays.javaArrayOffsetInternal(this.array);
        }

        @Override
        public double get(double x) {
            int ix = (int)x;
            if (ix < 0 || ix >= this.idimX - 1) {
                return ix == this.idimX - 1 ? (double)(this.arr[this.ofs + ix] & 0xFFFF) : this.outsideValue;
            }
            double a = this.arr[this.ofs + ix] & 0xFFFF;
            double b = this.arr[this.ofs + ix + 1] & 0xFFFF;
            return (a - b) * ((double)ix - x) + a;
        }

        @Override
        public double get(double x, double y) {
            int ix = (int)x;
            int iy = (int)y;
            if (ix < 0 || ix >= this.idimX - 1 || iy < 0 || iy >= this.idimY - 1) {
                if (ix == this.idimX - 1 || iy == this.idimY - 1) {
                    return super.get(x, y);
                }
                return this.outsideValue;
            }
            int ofs1 = iy * this.idimX + ix;
            int ofs2 = ofs1 + this.idimX;
            double a = this.arr[this.ofs + ofs1] & 0xFFFF;
            double b = this.arr[this.ofs + ofs1 + 1] & 0xFFFF;
            double v1 = (a - b) * ((double)ix - x) + a;
            double c = this.arr[this.ofs + ofs2] & 0xFFFF;
            double d = this.arr[this.ofs + ofs2 + 1] & 0xFFFF;
            double v2 = (c - d) * ((double)ix - x) + c;
            return (v1 - v2) * ((double)iy - y) + v1;
        }
    }

    static class CheckedPolylinearShortInterpolation
    extends CheckedPolylinearInterpolation {
        private final short[] arr;
        private final int ofs;

        CheckedPolylinearShortInterpolation(Matrix<? extends PArray> m) {
            super(m);
            this.arr = (short[])Arrays.javaArrayInternal(this.array);
            this.ofs = Arrays.javaArrayOffsetInternal(this.array);
        }

        @Override
        public double get(double x) {
            int ix = (int)x;
            this.checkIntIndex0(ix);
            double a = this.arr[this.ofs + ix] & 0xFFFF;
            if (ix == this.idimX - 1) {
                return a;
            }
            double b = this.arr[this.ofs + ix + 1] & 0xFFFF;
            return (a - b) * ((double)ix - x) + a;
        }

        @Override
        public double get(double x, double y) {
            int ix = (int)x;
            int iy = (int)y;
            if (ix < 0 || ix >= this.idimX - 1 || iy < 0 || iy >= this.idimY - 1) {
                if (ix == this.idimX - 1 || iy == this.idimY - 1) {
                    return super.get(x, y);
                }
                this.checkIntIndex0(ix);
                this.checkIntIndex1(iy);
                throw new AssertionError();
            }
            int ofs1 = iy * this.idimX + ix;
            int ofs2 = ofs1 + this.idimX;
            double a = this.arr[this.ofs + ofs1] & 0xFFFF;
            double b = this.arr[this.ofs + ofs1 + 1] & 0xFFFF;
            double v1 = (a - b) * ((double)ix - x) + a;
            double c = this.arr[this.ofs + ofs2] & 0xFFFF;
            double d = this.arr[this.ofs + ofs2 + 1] & 0xFFFF;
            double v2 = (c - d) * ((double)ix - x) + c;
            return (v1 - v2) * ((double)iy - y) + v1;
        }
    }

    static class UncheckedPolylinearShortInterpolation
    extends UncheckedPolylinearInterpolation {
        private final short[] arr;
        private final int ofs;

        UncheckedPolylinearShortInterpolation(Matrix<? extends PArray> m) {
            super(m);
            this.arr = (short[])Arrays.javaArrayInternal(this.array);
            this.ofs = Arrays.javaArrayOffsetInternal(this.array);
        }

        @Override
        public double get(double x) {
            int ix = (int)x;
            double a = this.arr[this.ofs + ix] & 0xFFFF;
            if (ix == this.idimX - 1) {
                return a;
            }
            double b = this.arr[this.ofs + ix + 1] & 0xFFFF;
            return (a - b) * ((double)ix - x) + a;
        }

        @Override
        public double get(double x, double y) {
            int ix = (int)x;
            int iy = (int)y;
            int ofs1 = iy * this.idimX + ix;
            int ofs2 = ofs1 + this.idimX;
            double a = this.arr[this.ofs + ofs1] & 0xFFFF;
            double b = ix == this.idimX - 1 ? a : (double)(this.arr[this.ofs + ofs1 + 1] & 0xFFFF);
            double v1 = (a - b) * ((double)ix - x) + a;
            if (iy == this.idimY - 1) {
                return v1;
            }
            double c = this.arr[this.ofs + ofs2] & 0xFFFF;
            double d = ix == this.idimX - 1 ? c : (double)(this.arr[this.ofs + ofs2 + 1] & 0xFFFF);
            double v2 = (c - d) * ((double)ix - x) + c;
            return (v1 - v2) * ((double)iy - y) + v1;
        }
    }

    static class ContinuedPolylinearCharInterpolation
    extends ContinuedPolylinearInterpolation {
        private final char[] arr;
        private final int ofs;

        ContinuedPolylinearCharInterpolation(Matrix<? extends PArray> m, double outsideValue) {
            super(m, outsideValue);
            this.arr = (char[])Arrays.javaArrayInternal(this.array);
            this.ofs = Arrays.javaArrayOffsetInternal(this.array);
        }

        @Override
        public double get(double x) {
            int ix = (int)x;
            if (ix < 0 || ix >= this.idimX - 1) {
                return ix == this.idimX - 1 ? (double)this.arr[this.ofs + ix] : this.outsideValue;
            }
            double a = this.arr[this.ofs + ix];
            double b = this.arr[this.ofs + ix + 1];
            return (a - b) * ((double)ix - x) + a;
        }

        @Override
        public double get(double x, double y) {
            int ix = (int)x;
            int iy = (int)y;
            if (ix < 0 || ix >= this.idimX - 1 || iy < 0 || iy >= this.idimY - 1) {
                if (ix == this.idimX - 1 || iy == this.idimY - 1) {
                    return super.get(x, y);
                }
                return this.outsideValue;
            }
            int ofs1 = iy * this.idimX + ix;
            int ofs2 = ofs1 + this.idimX;
            double a = this.arr[this.ofs + ofs1];
            double b = this.arr[this.ofs + ofs1 + 1];
            double v1 = (a - b) * ((double)ix - x) + a;
            double c = this.arr[this.ofs + ofs2];
            double d = this.arr[this.ofs + ofs2 + 1];
            double v2 = (c - d) * ((double)ix - x) + c;
            return (v1 - v2) * ((double)iy - y) + v1;
        }
    }

    static class CheckedPolylinearCharInterpolation
    extends CheckedPolylinearInterpolation {
        private final char[] arr;
        private final int ofs;

        CheckedPolylinearCharInterpolation(Matrix<? extends PArray> m) {
            super(m);
            this.arr = (char[])Arrays.javaArrayInternal(this.array);
            this.ofs = Arrays.javaArrayOffsetInternal(this.array);
        }

        @Override
        public double get(double x) {
            int ix = (int)x;
            this.checkIntIndex0(ix);
            double a = this.arr[this.ofs + ix];
            if (ix == this.idimX - 1) {
                return a;
            }
            double b = this.arr[this.ofs + ix + 1];
            return (a - b) * ((double)ix - x) + a;
        }

        @Override
        public double get(double x, double y) {
            int ix = (int)x;
            int iy = (int)y;
            if (ix < 0 || ix >= this.idimX - 1 || iy < 0 || iy >= this.idimY - 1) {
                if (ix == this.idimX - 1 || iy == this.idimY - 1) {
                    return super.get(x, y);
                }
                this.checkIntIndex0(ix);
                this.checkIntIndex1(iy);
                throw new AssertionError();
            }
            int ofs1 = iy * this.idimX + ix;
            int ofs2 = ofs1 + this.idimX;
            double a = this.arr[this.ofs + ofs1];
            double b = this.arr[this.ofs + ofs1 + 1];
            double v1 = (a - b) * ((double)ix - x) + a;
            double c = this.arr[this.ofs + ofs2];
            double d = this.arr[this.ofs + ofs2 + 1];
            double v2 = (c - d) * ((double)ix - x) + c;
            return (v1 - v2) * ((double)iy - y) + v1;
        }
    }

    static class UncheckedPolylinearCharInterpolation
    extends UncheckedPolylinearInterpolation {
        private final char[] arr;
        private final int ofs;

        UncheckedPolylinearCharInterpolation(Matrix<? extends PArray> m) {
            super(m);
            this.arr = (char[])Arrays.javaArrayInternal(this.array);
            this.ofs = Arrays.javaArrayOffsetInternal(this.array);
        }

        @Override
        public double get(double x) {
            int ix = (int)x;
            double a = this.arr[this.ofs + ix];
            if (ix == this.idimX - 1) {
                return a;
            }
            double b = this.arr[this.ofs + ix + 1];
            return (a - b) * ((double)ix - x) + a;
        }

        @Override
        public double get(double x, double y) {
            int ix = (int)x;
            int iy = (int)y;
            int ofs1 = iy * this.idimX + ix;
            int ofs2 = ofs1 + this.idimX;
            double a = this.arr[this.ofs + ofs1];
            double b = ix == this.idimX - 1 ? a : (double)this.arr[this.ofs + ofs1 + 1];
            double v1 = (a - b) * ((double)ix - x) + a;
            if (iy == this.idimY - 1) {
                return v1;
            }
            double c = this.arr[this.ofs + ofs2];
            double d = ix == this.idimX - 1 ? c : (double)this.arr[this.ofs + ofs2 + 1];
            double v2 = (c - d) * ((double)ix - x) + c;
            return (v1 - v2) * ((double)iy - y) + v1;
        }
    }

    static class ContinuedPolylinearByteInterpolation
    extends ContinuedPolylinearInterpolation {
        private final byte[] arr;
        private final int ofs;

        ContinuedPolylinearByteInterpolation(Matrix<? extends PArray> m, double outsideValue) {
            super(m, outsideValue);
            this.arr = (byte[])Arrays.javaArrayInternal(this.array);
            this.ofs = Arrays.javaArrayOffsetInternal(this.array);
        }

        @Override
        public double get(double x) {
            int ix = (int)x;
            if (ix < 0 || ix >= this.idimX - 1) {
                return ix == this.idimX - 1 ? (double)(this.arr[this.ofs + ix] & 0xFF) : this.outsideValue;
            }
            double a = this.arr[this.ofs + ix] & 0xFF;
            double b = this.arr[this.ofs + ix + 1] & 0xFF;
            return (a - b) * ((double)ix - x) + a;
        }

        @Override
        public double get(double x, double y) {
            int ix = (int)x;
            int iy = (int)y;
            if (ix < 0 || ix >= this.idimX - 1 || iy < 0 || iy >= this.idimY - 1) {
                if (ix == this.idimX - 1 || iy == this.idimY - 1) {
                    return super.get(x, y);
                }
                return this.outsideValue;
            }
            int ofs1 = iy * this.idimX + ix;
            int ofs2 = ofs1 + this.idimX;
            double a = this.arr[this.ofs + ofs1] & 0xFF;
            double b = this.arr[this.ofs + ofs1 + 1] & 0xFF;
            double v1 = (a - b) * ((double)ix - x) + a;
            double c = this.arr[this.ofs + ofs2] & 0xFF;
            double d = this.arr[this.ofs + ofs2 + 1] & 0xFF;
            double v2 = (c - d) * ((double)ix - x) + c;
            return (v1 - v2) * ((double)iy - y) + v1;
        }
    }

    static class CheckedPolylinearByteInterpolation
    extends CheckedPolylinearInterpolation {
        private final byte[] arr;
        private final int ofs;

        CheckedPolylinearByteInterpolation(Matrix<? extends PArray> m) {
            super(m);
            this.arr = (byte[])Arrays.javaArrayInternal(this.array);
            this.ofs = Arrays.javaArrayOffsetInternal(this.array);
        }

        @Override
        public double get(double x) {
            int ix = (int)x;
            this.checkIntIndex0(ix);
            double a = this.arr[this.ofs + ix] & 0xFF;
            if (ix == this.idimX - 1) {
                return a;
            }
            double b = this.arr[this.ofs + ix + 1] & 0xFF;
            return (a - b) * ((double)ix - x) + a;
        }

        @Override
        public double get(double x, double y) {
            int ix = (int)x;
            int iy = (int)y;
            if (ix < 0 || ix >= this.idimX - 1 || iy < 0 || iy >= this.idimY - 1) {
                if (ix == this.idimX - 1 || iy == this.idimY - 1) {
                    return super.get(x, y);
                }
                this.checkIntIndex0(ix);
                this.checkIntIndex1(iy);
                throw new AssertionError();
            }
            int ofs1 = iy * this.idimX + ix;
            int ofs2 = ofs1 + this.idimX;
            double a = this.arr[this.ofs + ofs1] & 0xFF;
            double b = this.arr[this.ofs + ofs1 + 1] & 0xFF;
            double v1 = (a - b) * ((double)ix - x) + a;
            double c = this.arr[this.ofs + ofs2] & 0xFF;
            double d = this.arr[this.ofs + ofs2 + 1] & 0xFF;
            double v2 = (c - d) * ((double)ix - x) + c;
            return (v1 - v2) * ((double)iy - y) + v1;
        }
    }

    static class UncheckedPolylinearByteInterpolation
    extends UncheckedPolylinearInterpolation {
        private final byte[] arr;
        private final int ofs;

        UncheckedPolylinearByteInterpolation(Matrix<? extends PArray> m) {
            super(m);
            this.arr = (byte[])Arrays.javaArrayInternal(this.array);
            this.ofs = Arrays.javaArrayOffsetInternal(this.array);
        }

        @Override
        public double get(double x) {
            int ix = (int)x;
            double a = this.arr[this.ofs + ix] & 0xFF;
            if (ix == this.idimX - 1) {
                return a;
            }
            double b = this.arr[this.ofs + ix + 1] & 0xFF;
            return (a - b) * ((double)ix - x) + a;
        }

        @Override
        public double get(double x, double y) {
            int ix = (int)x;
            int iy = (int)y;
            int ofs1 = iy * this.idimX + ix;
            int ofs2 = ofs1 + this.idimX;
            double a = this.arr[this.ofs + ofs1] & 0xFF;
            double b = ix == this.idimX - 1 ? a : (double)(this.arr[this.ofs + ofs1 + 1] & 0xFF);
            double v1 = (a - b) * ((double)ix - x) + a;
            if (iy == this.idimY - 1) {
                return v1;
            }
            double c = this.arr[this.ofs + ofs2] & 0xFF;
            double d = ix == this.idimX - 1 ? c : (double)(this.arr[this.ofs + ofs2 + 1] & 0xFF);
            double v2 = (c - d) * ((double)ix - x) + c;
            return (v1 - v2) * ((double)iy - y) + v1;
        }
    }

    static class ContinuedPolylinearInterpolation
    extends AbstractPolylinearInterpolation {
        final double outsideValue;

        ContinuedPolylinearInterpolation(Matrix<? extends PArray> m, double outsideValue) {
            super(m);
            this.outsideValue = outsideValue;
        }

        @Override
        public double get(double ... x) {
            if (x.length == 0) {
                throw new IndexOutOfBoundsException("At least 1 argument required");
            }
            return this.get(x, Math.min(this.dim.length, x.length), 0L);
        }

        @Override
        public double get(double x) {
            long ix = (long)x;
            if (ix < 0L || ix >= this.dimX - 1L) {
                return ix == this.dimX - 1L ? this.array.getDouble(ix) : this.outsideValue;
            }
            double a = this.array.getDouble(ix);
            double b = this.array.getDouble(ix + 1L);
            return (a - b) * ((double)ix - x) + a;
        }

        @Override
        public double get(double x, double y) {
            long ix = (long)x;
            long iy = (long)y;
            if (ix < 0L || ix >= this.dimX - 1L || iy < 0L || iy >= this.dimY - 1L) {
                if (ix == this.dimX - 1L) {
                    if (iy < 0L || iy >= this.dimY) {
                        return this.outsideValue;
                    }
                    long ofs1 = iy * this.dimX + ix;
                    long ofs2 = ofs1 + this.dimX;
                    if (iy == this.dimY - 1L) {
                        return this.array.getDouble(ofs1);
                    }
                    double a = this.array.getDouble(ofs1);
                    double c = this.array.getDouble(ofs2);
                    return (a - c) * ((double)iy - y) + a;
                }
                if (iy == this.dimY - 1L) {
                    assert (ix != this.dimX - 1L);
                    if (ix < 0L || ix >= this.dimX) {
                        return this.outsideValue;
                    }
                    long ofs1 = iy * this.dimX + ix;
                    double a = this.array.getDouble(ofs1);
                    double b = this.array.getDouble(ofs1 + 1L);
                    return (a - b) * ((double)ix - x) + a;
                }
                return this.outsideValue;
            }
            long ofs1 = iy * this.dimX + ix;
            long ofs2 = ofs1 + this.dimX;
            double a = this.array.getDouble(ofs1);
            double b = this.array.getDouble(ofs1 + 1L);
            double c = this.array.getDouble(ofs2);
            double d = this.array.getDouble(ofs2 + 1L);
            double v1 = (a - b) * ((double)ix - x) + a;
            double v2 = (c - d) * ((double)ix - x) + c;
            return (v1 - v2) * ((double)iy - y) + v1;
        }

        double get(double[] x, int xLength, long layerIndex) {
            if (xLength == 1) {
                long coord = (long)x[0];
                long index = layerIndex * this.dimX + coord;
                if (coord < 0L || coord >= this.dimX - 1L) {
                    return coord == this.dimX - 1L ? this.array.getDouble(index) : this.outsideValue;
                }
                double a = this.array.getDouble(index);
                double b = this.array.getDouble(index + 1L);
                return (a - b) * ((double)coord - x[0]) + a;
            }
            int n = xLength - 1;
            long coord = (long)x[n];
            long index = layerIndex * this.dim[n] + coord;
            if (coord < 0L || coord >= this.dim[n] - 1L) {
                return coord == this.dim[n] - 1L ? this.get(x, n, index) : this.outsideValue;
            }
            double a = this.get(x, n, index);
            double b = this.get(x, n, index + 1L);
            return (a - b) * ((double)coord - x[n]) + a;
        }

        @Override
        public Boolean isChecked() {
            return null;
        }

        @Override
        public Double outsideValue() {
            return this.outsideValue;
        }

        @Override
        public String toString() {
            return "continued (by " + this.outsideValue + ") polylinear interpolation of " + String.valueOf(this.m);
        }
    }

    static class CheckedPolylinearInterpolation
    extends AbstractPolylinearInterpolation {
        CheckedPolylinearInterpolation(Matrix<? extends PArray> m) {
            super(m);
        }

        @Override
        public double get(double ... x) {
            if (x.length == 0) {
                throw new IndexOutOfBoundsException("At least 1 argument required");
            }
            return this.get(x, Math.min(this.dim.length, x.length), 0L);
        }

        @Override
        public double get(double x) {
            long ix = (long)x;
            this.checkIndex0(ix);
            double a = this.array.getDouble(ix);
            if (ix == this.dimX - 1L) {
                return a;
            }
            double b = this.array.getDouble(ix + 1L);
            return (a - b) * ((double)ix - x) + a;
        }

        @Override
        public double get(double x, double y) {
            long ix = (long)x;
            this.checkIndex0(ix);
            long iy = (long)y;
            this.checkIndex1(iy);
            long ofs1 = iy * this.dimX + ix;
            long ofs2 = ofs1 + this.dimX;
            double a = this.array.getDouble(ofs1);
            double b = ix == this.dimX - 1L ? a : this.array.getDouble(ofs1 + 1L);
            double v1 = (a - b) * ((double)ix - x) + a;
            if (iy == this.dimY - 1L) {
                return v1;
            }
            double c = this.array.getDouble(ofs2);
            double d = ix == this.dimX - 1L ? c : this.array.getDouble(ofs2 + 1L);
            double v2 = (c - d) * ((double)ix - x) + c;
            return (v1 - v2) * ((double)iy - y) + v1;
        }

        double get(double[] x, int xLength, long layerIndex) {
            if (xLength == 1) {
                long coord = (long)x[0];
                this.checkIndex0(coord);
                long index = layerIndex * this.dimX + coord;
                double a = this.array.getDouble(index);
                if (coord == this.dimX - 1L) {
                    return a;
                }
                double b = this.array.getDouble(index + 1L);
                return (a - b) * ((double)coord - x[0]) + a;
            }
            int n = xLength - 1;
            long coord = (long)x[n];
            this.checkIndex(n, coord);
            long index = layerIndex * this.dim[n] + coord;
            double a = this.get(x, n, index);
            if (coord == this.dim[n] - 1L) {
                return a;
            }
            double b = this.get(x, n, index + 1L);
            return (a - b) * ((double)coord - x[n]) + a;
        }

        @Override
        public Boolean isChecked() {
            return true;
        }

        @Override
        public Double outsideValue() {
            return null;
        }

        @Override
        public String toString() {
            return "polylinear interpolation of " + String.valueOf(this.m);
        }
    }

    static class UncheckedPolylinearInterpolation
    extends AbstractPolylinearInterpolation {
        UncheckedPolylinearInterpolation(Matrix<? extends PArray> m) {
            super(m);
        }

        @Override
        public double get(double ... x) {
            if (x.length == 0) {
                throw new IndexOutOfBoundsException("At least 1 argument required");
            }
            return this.get(x, Math.min(this.dim.length, x.length), 0L);
        }

        @Override
        public double get(double x) {
            long ix = (long)x;
            double a = this.array.getDouble(ix);
            if (ix == this.dimX - 1L) {
                return a;
            }
            double b = this.array.getDouble(ix + 1L);
            return (a - b) * ((double)ix - x) + a;
        }

        @Override
        public double get(double x, double y) {
            long ix = (long)x;
            long iy = (long)y;
            long ofs1 = iy * this.dimX + ix;
            long ofs2 = ofs1 + this.dimX;
            double a = this.array.getDouble(ofs1);
            double b = ix == this.dimX - 1L ? a : this.array.getDouble(ofs1 + 1L);
            double v1 = (a - b) * ((double)ix - x) + a;
            if (iy == this.dimY - 1L) {
                return v1;
            }
            double c = this.array.getDouble(ofs2);
            double d = ix == this.dimX - 1L ? c : this.array.getDouble(ofs2 + 1L);
            double v2 = (c - d) * ((double)ix - x) + c;
            return (v1 - v2) * ((double)iy - y) + v1;
        }

        double get(double[] x, int xLength, long layerIndex) {
            if (xLength == 1) {
                long coord = (long)x[0];
                long index = layerIndex * this.dimX + coord;
                double a = this.array.getDouble(index);
                if (coord == this.dimX - 1L) {
                    return a;
                }
                double b = this.array.getDouble(index + 1L);
                return (a - b) * ((double)coord - x[0]) + a;
            }
            int n = xLength - 1;
            long coord = (long)x[n];
            long index = layerIndex * this.dim[n] + coord;
            double a = this.get(x, n, index);
            if (coord == this.dim[n] - 1L) {
                return a;
            }
            double b = this.get(x, n, index + 1L);
            return (a - b) * ((double)coord - x[n]) + a;
        }

        @Override
        public Boolean isChecked() {
            return false;
        }

        @Override
        public Double outsideValue() {
            return null;
        }

        @Override
        public String toString() {
            return "polylinear interpolation (unchecked ranges) of " + String.valueOf(this.m);
        }
    }

    static abstract class AbstractPolylinearInterpolation
    extends ArraysInterpolationsImpl.AbstractInterpolation {
        AbstractPolylinearInterpolation(Matrix<? extends PArray> m) {
            super(m);
        }

        @Override
        public final double get(double x, double y, double z) {
            return this.get(new double[]{x, y, z});
        }

        @Override
        public final double get(double x, double y, double z, double t) {
            return this.get(new double[]{x, y, z, t});
        }

        @Override
        public Matrices.InterpolationMethod getInterpolationMethod() {
            return Matrices.InterpolationMethod.POLYLINEAR_FUNCTION;
        }
    }
}

