/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.Objects;
import net.algart.arrays.Array;
import net.algart.arrays.Arrays;
import net.algart.arrays.ArraysSubMatrixIndexer;
import net.algart.arrays.BitArray;
import net.algart.arrays.ByteArray;
import net.algart.arrays.CharArray;
import net.algart.arrays.DoubleArray;
import net.algart.arrays.FloatArray;
import net.algart.arrays.IntArray;
import net.algart.arrays.LongArray;
import net.algart.arrays.Matrix;
import net.algart.arrays.ObjectArray;
import net.algart.arrays.PackedBitArrays;
import net.algart.arrays.ShortArray;
import net.algart.arrays.UpdatableArray;
import net.algart.arrays.UpdatableBitArray;
import net.algart.arrays.UpdatableByteArray;
import net.algart.arrays.UpdatableCharArray;
import net.algart.arrays.UpdatableDoubleArray;
import net.algart.arrays.UpdatableFloatArray;
import net.algart.arrays.UpdatableIntArray;
import net.algart.arrays.UpdatableLongArray;
import net.algart.arrays.UpdatableObjectArray;
import net.algart.arrays.UpdatableShortArray;

class ArraysSubMatrixConstantlyContinuedIndexer
implements ArraysSubMatrixIndexer {
    private static final boolean DEBUG_MODE = false;
    private static final long OUTSIDE_INDEX = -1L;
    private final Array baseArray;
    private final UpdatableArray updatableBaseArray;
    private final BitArray baseBitArray;
    private final UpdatableBitArray updatableBaseBitArray;
    private final CharArray baseCharArray;
    private final UpdatableCharArray updatableBaseCharArray;
    private final ByteArray baseByteArray;
    private final UpdatableByteArray updatableBaseByteArray;
    private final ShortArray baseShortArray;
    private final UpdatableShortArray updatableBaseShortArray;
    private final IntArray baseIntArray;
    private final UpdatableIntArray updatableBaseIntArray;
    private final LongArray baseLongArray;
    private final UpdatableLongArray updatableBaseLongArray;
    private final FloatArray baseFloatArray;
    private final UpdatableFloatArray updatableBaseFloatArray;
    private final DoubleArray baseDoubleArray;
    private final UpdatableDoubleArray updatableBaseDoubleArray;
    private final ObjectArray<Object> baseObjectArray;
    private final UpdatableObjectArray<Object> updatableBaseObjectArray;
    private final long[] pos;
    private final long pos0;
    private final long[] dim;
    private final long dim0;
    private final long size;
    private final long[] baseDim;
    private final long baseDim0;
    private final long[] baseDimMul;
    private final Array outsideConst;
    private final boolean outsideBitConst;
    private final char outsideCharConst;
    private final byte outsideByteConst;
    private final short outsideShortConst;
    private final int outsideIntConst;
    private final long outsideLongConst;
    private final float outsideFloatConst;
    private final double outsideDoubleConst;
    private final Object outsideObjectConst;

    ArraysSubMatrixConstantlyContinuedIndexer(Matrix<? extends Array> baseMatrix, long[] pos, long[] dim, Array outsideConst) {
        int k;
        this.baseArray = baseMatrix.array();
        this.updatableBaseArray = this.baseArray instanceof UpdatableArray ? (UpdatableArray)this.baseArray : null;
        this.baseBitArray = this.baseArray instanceof BitArray ? (BitArray)this.baseArray : null;
        this.updatableBaseBitArray = this.baseArray instanceof UpdatableBitArray ? (UpdatableBitArray)this.baseArray : null;
        this.baseCharArray = this.baseArray instanceof CharArray ? (CharArray)this.baseArray : null;
        this.updatableBaseCharArray = this.baseArray instanceof UpdatableCharArray ? (UpdatableCharArray)this.baseArray : null;
        this.baseByteArray = this.baseArray instanceof ByteArray ? (ByteArray)this.baseArray : null;
        this.updatableBaseByteArray = this.baseArray instanceof UpdatableByteArray ? (UpdatableByteArray)this.baseArray : null;
        this.baseShortArray = this.baseArray instanceof ShortArray ? (ShortArray)this.baseArray : null;
        this.updatableBaseShortArray = this.baseArray instanceof UpdatableShortArray ? (UpdatableShortArray)this.baseArray : null;
        this.baseIntArray = this.baseArray instanceof IntArray ? (IntArray)this.baseArray : null;
        this.updatableBaseIntArray = this.baseArray instanceof UpdatableIntArray ? (UpdatableIntArray)this.baseArray : null;
        this.baseLongArray = this.baseArray instanceof LongArray ? (LongArray)this.baseArray : null;
        this.updatableBaseLongArray = this.baseArray instanceof UpdatableLongArray ? (UpdatableLongArray)this.baseArray : null;
        this.baseFloatArray = this.baseArray instanceof FloatArray ? (FloatArray)this.baseArray : null;
        this.updatableBaseFloatArray = this.baseArray instanceof UpdatableFloatArray ? (UpdatableFloatArray)this.baseArray : null;
        this.baseDoubleArray = this.baseArray instanceof DoubleArray ? (DoubleArray)this.baseArray : null;
        this.updatableBaseDoubleArray = this.baseArray instanceof UpdatableDoubleArray ? (UpdatableDoubleArray)this.baseArray : null;
        this.baseObjectArray = this.baseArray instanceof ObjectArray ? ((ObjectArray)this.baseArray).cast(Object.class) : null;
        UpdatableObjectArray<Object> updatableObjectArray = this.updatableBaseObjectArray = this.baseArray instanceof UpdatableObjectArray ? ((UpdatableObjectArray)this.baseArray).cast(Object.class) : null;
        assert (dim.length == baseMatrix.dimCount());
        assert (pos.length == dim.length);
        for (int k2 = 0; k2 < pos.length; ++k2) {
            assert (dim[k2] >= 0L);
            assert (pos[k2] <= Long.MAX_VALUE - dim[k2]);
        }
        int n = dim.length;
        int q = 0;
        long collapsedDimensions = 1L;
        while (q < dim.length - 1 && pos[q] == 0L && dim[q] == baseMatrix.dim(q)) {
            collapsedDimensions *= dim[q];
            ++q;
            --n;
        }
        assert (n > 0);
        this.baseDim = new long[n];
        this.pos = new long[n];
        this.dim = new long[n];
        for (k = 0; k < n; ++k) {
            this.baseDim[k] = baseMatrix.dim(k + q);
            this.pos[k] = pos[k + q];
            this.dim[k] = dim[k + q];
        }
        this.baseDim[0] = this.baseDim[0] * collapsedDimensions;
        this.pos[0] = this.pos[0] * collapsedDimensions;
        this.dim[0] = this.dim[0] * collapsedDimensions;
        this.baseDim0 = this.baseDim[0];
        this.pos0 = this.pos[0];
        this.dim0 = this.dim[0];
        this.size = Arrays.longMul(dim);
        assert (this.size >= 0L);
        assert (this.size == Arrays.longMul(this.dim));
        this.baseDimMul = new long[n];
        for (k = 0; k < n; ++k) {
            this.baseDimMul[k] = k == 0 ? 1L : this.baseDimMul[k - 1] * this.baseDim[k - 1];
        }
        this.outsideConst = outsideConst;
        long outsideLength = outsideConst.length();
        this.outsideBitConst = outsideConst instanceof BitArray && outsideLength > 0L && ((BitArray)outsideConst).getBit(0L);
        this.outsideCharConst = outsideConst instanceof CharArray && outsideLength > 0L ? ((CharArray)outsideConst).getChar(0L) : (char)'\u0000';
        this.outsideByteConst = outsideConst instanceof ByteArray && outsideLength > 0L ? (byte)((ByteArray)outsideConst).getByte(0L) : (byte)0;
        this.outsideShortConst = outsideConst instanceof ShortArray && outsideLength > 0L ? (short)((ShortArray)outsideConst).getShort(0L) : (short)0;
        this.outsideIntConst = outsideConst instanceof IntArray && outsideLength > 0L ? ((IntArray)outsideConst).getInt(0L) : 0;
        this.outsideLongConst = outsideConst instanceof LongArray && outsideLength > 0L ? ((LongArray)outsideConst).getLong(0L) : 0L;
        this.outsideFloatConst = outsideConst instanceof FloatArray && outsideLength > 0L ? ((FloatArray)outsideConst).getFloat(0L) : 0.0f;
        this.outsideDoubleConst = outsideConst instanceof DoubleArray && outsideLength > 0L ? ((DoubleArray)outsideConst).getDouble(0L) : 0.0;
        this.outsideObjectConst = outsideConst instanceof ObjectArray && outsideLength > 0L ? ((ObjectArray)outsideConst).get(0L) : Integer.valueOf(0);
    }

    @Override
    public boolean bitsBlocksImplemented() {
        return true;
    }

    @Override
    public boolean indexOfImplemented() {
        return true;
    }

    @Override
    public long translate(long index) {
        int k;
        assert (index >= 0L && index < this.size);
        if (this.dim.length == 1) {
            long coord = this.pos0 + index;
            return coord < 0L || coord >= this.baseDim0 ? -1L : coord;
        }
        long a = index;
        long b = a / this.dim0;
        long baseCoord0 = this.pos0 + a - b * this.dim0;
        if (baseCoord0 < 0L || baseCoord0 >= this.baseDim0) {
            return -1L;
        }
        a = b;
        long indexInBase = baseCoord0;
        for (k = 1; k < this.dim.length - 1; ++k) {
            b = a / this.dim[k];
            long baseCoordK = this.pos[k] + a - b * this.dim[k];
            if (baseCoordK < 0L || baseCoordK >= this.baseDim[k]) {
                return -1L;
            }
            a = b;
            indexInBase += baseCoordK * this.baseDimMul[k];
        }
        assert (k == this.dim.length - 1);
        long baseCoordLast = this.pos[k] + a;
        if (baseCoordLast < 0L || baseCoordLast >= this.baseDim[k]) {
            return -1L;
        }
        return indexInBase += baseCoordLast * this.baseDimMul[k];
    }

    @Override
    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
        assert (arrayPos >= 0L && arrayPos <= this.size - (long)count);
        assert (count >= 0);
        if (this.dim.length == 1) {
            this.getDataInLine(arrayPos + this.pos0, arrayPos + this.pos0, destArray, destArrayOffset, count);
            return;
        }
        long bLast = -157L;
        long index = arrayPos;
        while (count > 0) {
            boolean fullLineOutside;
            long indexInBase;
            long baseCoord0;
            int len;
            block16: {
                long subCoord0;
                long b;
                long a = index;
                if (index == arrayPos) {
                    b = a / this.dim0;
                    subCoord0 = a - b * this.dim0;
                } else {
                    b = bLast + 1L;
                    subCoord0 = 0L;
                }
                bLast = b;
                len = (int)Math.min(this.dim0 - subCoord0, (long)count);
                assert (len > 0) : "zero len = " + len;
                indexInBase = baseCoord0 = this.pos0 + subCoord0;
                if (baseCoord0 <= (long)(-len) || baseCoord0 >= this.baseDim0) {
                    fullLineOutside = true;
                } else {
                    int k;
                    a = b;
                    fullLineOutside = false;
                    for (k = 1; k < this.dim.length - 1; ++k) {
                        b = a / this.dim[k];
                        long subCoordK = a - b * this.dim[k];
                        long baseCoordK = this.pos[k] + subCoordK;
                        if (baseCoordK < 0L || baseCoordK >= this.baseDim[k]) {
                            fullLineOutside = true;
                            break block16;
                        }
                        a = b;
                        indexInBase += baseCoordK * this.baseDimMul[k];
                    }
                    assert (k == this.dim.length - 1);
                    long baseCoordLast = this.pos[k] + a;
                    if (baseCoordLast < 0L || baseCoordLast >= this.baseDim[k]) {
                        fullLineOutside = true;
                    } else {
                        indexInBase += baseCoordLast * this.baseDimMul[k];
                    }
                }
            }
            if (fullLineOutside) {
                this.outsideConst.getData(0L, destArray, destArrayOffset, len);
            } else {
                this.getDataInLine(indexInBase, baseCoord0, destArray, destArrayOffset, len);
            }
            index += (long)len;
            destArrayOffset += len;
            count -= len;
        }
    }

    private void getDataInLine(long indexInBase, long baseCoord0, Object destArray, int destArrayOffset, int len) {
        int m;
        if (baseCoord0 < 0L && len > 0) {
            m = (int)Math.min(-baseCoord0, (long)len);
            this.outsideConst.getData(0L, destArray, destArrayOffset, m);
            baseCoord0 += (long)m;
            indexInBase += (long)m;
            destArrayOffset += m;
            len -= m;
        }
        if (baseCoord0 >= 0L && baseCoord0 < this.baseDim0 && len > 0) {
            m = (int)Math.min(this.baseDim0 - baseCoord0, (long)len);
            this.baseArray.getData(indexInBase, destArray, destArrayOffset, m);
            baseCoord0 += (long)m;
            destArrayOffset += m;
            len -= m;
        }
        if (baseCoord0 >= this.baseDim0 && len > 0) {
            this.outsideConst.getData(0L, destArray, destArrayOffset, len);
        }
    }

    @Override
    public void setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
        assert (arrayPos >= 0L && arrayPos <= this.size - (long)count);
        assert (count >= 0);
        if (this.dim.length == 1) {
            this.setDataInLine(arrayPos + this.pos0, arrayPos + this.pos0, srcArray, srcArrayOffset, count);
            return;
        }
        long bLast = -157L;
        long index = arrayPos;
        while (count > 0) {
            boolean fullLineOutside;
            long indexInBase;
            long baseCoord0;
            int len;
            block15: {
                long subCoord0;
                long b;
                long a = index;
                if (index == arrayPos) {
                    b = a / this.dim0;
                    subCoord0 = a - b * this.dim0;
                } else {
                    b = bLast + 1L;
                    subCoord0 = 0L;
                }
                bLast = b;
                len = (int)Math.min(this.dim0 - subCoord0, (long)count);
                assert (len > 0) : "zero len = " + len;
                indexInBase = baseCoord0 = this.pos0 + subCoord0;
                if (baseCoord0 <= (long)(-len) || baseCoord0 >= this.baseDim0) {
                    fullLineOutside = true;
                } else {
                    int k;
                    a = b;
                    fullLineOutside = false;
                    for (k = 1; k < this.dim.length - 1; ++k) {
                        b = a / this.dim[k];
                        long subCoordK = a - b * this.dim[k];
                        long baseCoordK = this.pos[k] + subCoordK;
                        if (baseCoordK < 0L || baseCoordK >= this.baseDim[k]) {
                            fullLineOutside = true;
                            break block15;
                        }
                        a = b;
                        indexInBase += baseCoordK * this.baseDimMul[k];
                    }
                    assert (k == this.dim.length - 1);
                    long baseCoordLast = this.pos[k] + a;
                    if (baseCoordLast < 0L || baseCoordLast >= this.baseDim[k]) {
                        fullLineOutside = true;
                    } else {
                        indexInBase += baseCoordLast * this.baseDimMul[k];
                    }
                }
            }
            if (!fullLineOutside) {
                this.setDataInLine(indexInBase, baseCoord0, srcArray, srcArrayOffset, len);
            }
            index += (long)len;
            srcArrayOffset += len;
            count -= len;
        }
    }

    private void setDataInLine(long indexInBase, long baseCoord0, Object srcArray, int srcArrayOffset, int len) {
        int m;
        if (baseCoord0 < 0L && len > 0) {
            m = (int)Math.min(-baseCoord0, (long)len);
            baseCoord0 += (long)m;
            indexInBase += (long)m;
            srcArrayOffset += m;
            len -= m;
        }
        if (baseCoord0 >= 0L && baseCoord0 < this.baseDim0 && len > 0) {
            m = (int)Math.min(this.baseDim0 - baseCoord0, (long)len);
            this.updatableBaseArray.setData(indexInBase, srcArray, srcArrayOffset, m);
            baseCoord0 += (long)m;
            srcArrayOffset += m;
            len -= m;
        }
        if (baseCoord0 < this.baseDim0 || len > 0) {
            // empty if block
        }
    }

    @Override
    public void getBits(long arrayPos, long[] destArray, long destArrayOffset, long count) {
        assert (arrayPos >= 0L && arrayPos <= this.size - count);
        assert (count >= 0L);
        if (this.dim.length == 1) {
            this.getBitsInLine(arrayPos + this.pos0, arrayPos + this.pos0, destArray, destArrayOffset, count);
            return;
        }
        long bLast = -157L;
        long index = arrayPos;
        while (count > 0L) {
            boolean fullLineOutside;
            long indexInBase;
            long baseCoord0;
            long len;
            block16: {
                long subCoord0;
                long b;
                long a = index;
                if (index == arrayPos) {
                    b = a / this.dim0;
                    subCoord0 = a - b * this.dim0;
                } else {
                    b = bLast + 1L;
                    subCoord0 = 0L;
                }
                bLast = b;
                len = Math.min(this.dim0 - subCoord0, count);
                assert (len > 0L) : "zero len = " + len;
                indexInBase = baseCoord0 = this.pos0 + subCoord0;
                if (baseCoord0 <= -len || baseCoord0 >= this.baseDim0) {
                    fullLineOutside = true;
                } else {
                    int k;
                    a = b;
                    fullLineOutside = false;
                    for (k = 1; k < this.dim.length - 1; ++k) {
                        b = a / this.dim[k];
                        long subCoordK = a - b * this.dim[k];
                        long baseCoordK = this.pos[k] + subCoordK;
                        if (baseCoordK < 0L || baseCoordK >= this.baseDim[k]) {
                            fullLineOutside = true;
                            break block16;
                        }
                        a = b;
                        indexInBase += baseCoordK * this.baseDimMul[k];
                    }
                    assert (k == this.dim.length - 1);
                    long baseCoordLast = this.pos[k] + a;
                    if (baseCoordLast < 0L || baseCoordLast >= this.baseDim[k]) {
                        fullLineOutside = true;
                    } else {
                        indexInBase += baseCoordLast * this.baseDimMul[k];
                    }
                }
            }
            if (fullLineOutside) {
                PackedBitArrays.fillBits(destArray, destArrayOffset, len, this.outsideBitConst);
            } else {
                this.getBitsInLine(indexInBase, baseCoord0, destArray, destArrayOffset, len);
            }
            index += len;
            destArrayOffset += len;
            count -= len;
        }
    }

    private void getBitsInLine(long indexInBase, long baseCoord0, long[] destArray, long destArrayOffset, long len) {
        long m;
        if (baseCoord0 < 0L && len > 0L) {
            m = Math.min(-baseCoord0, len);
            PackedBitArrays.fillBits(destArray, destArrayOffset, m, this.outsideBitConst);
            baseCoord0 += m;
            indexInBase += m;
            destArrayOffset += m;
            len -= m;
        }
        if (baseCoord0 >= 0L && baseCoord0 < this.baseDim0 && len > 0L) {
            m = Math.min(this.baseDim0 - baseCoord0, len);
            this.baseBitArray.getBits(indexInBase, destArray, destArrayOffset, m);
            baseCoord0 += m;
            destArrayOffset += m;
            len -= m;
        }
        if (baseCoord0 >= this.baseDim0 && len > 0L) {
            PackedBitArrays.fillBits(destArray, destArrayOffset, len, this.outsideBitConst);
        }
    }

    @Override
    public void setBits(long arrayPos, long[] srcArray, long srcArrayOffset, long count) {
        assert (arrayPos >= 0L && arrayPos <= this.size - count);
        assert (count >= 0L);
        if (this.dim.length == 1) {
            this.setBitsInLine(arrayPos + this.pos0, arrayPos + this.pos0, srcArray, srcArrayOffset, count);
            return;
        }
        long bLast = -157L;
        long index = arrayPos;
        while (count > 0L) {
            boolean fullLineOutside;
            long indexInBase;
            long baseCoord0;
            long len;
            block15: {
                long subCoord0;
                long b;
                long a = index;
                if (index == arrayPos) {
                    b = a / this.dim0;
                    subCoord0 = a - b * this.dim0;
                } else {
                    b = bLast + 1L;
                    subCoord0 = 0L;
                }
                bLast = b;
                len = Math.min(this.dim0 - subCoord0, count);
                assert (len > 0L) : "zero len = " + len;
                indexInBase = baseCoord0 = this.pos0 + subCoord0;
                if (baseCoord0 <= -len || baseCoord0 >= this.baseDim0) {
                    fullLineOutside = true;
                } else {
                    int k;
                    a = b;
                    fullLineOutside = false;
                    for (k = 1; k < this.dim.length - 1; ++k) {
                        b = a / this.dim[k];
                        long subCoordK = a - b * this.dim[k];
                        long baseCoordK = this.pos[k] + subCoordK;
                        if (baseCoordK < 0L || baseCoordK >= this.baseDim[k]) {
                            fullLineOutside = true;
                            break block15;
                        }
                        a = b;
                        indexInBase += baseCoordK * this.baseDimMul[k];
                    }
                    assert (k == this.dim.length - 1);
                    long baseCoordLast = this.pos[k] + a;
                    if (baseCoordLast < 0L || baseCoordLast >= this.baseDim[k]) {
                        fullLineOutside = true;
                    } else {
                        indexInBase += baseCoordLast * this.baseDimMul[k];
                    }
                }
            }
            if (!fullLineOutside) {
                this.setBitsInLine(indexInBase, baseCoord0, srcArray, srcArrayOffset, len);
            }
            index += len;
            srcArrayOffset += len;
            count -= len;
        }
    }

    private void setBitsInLine(long indexInBase, long baseCoord0, long[] srcArray, long srcArrayOffset, long len) {
        long m;
        if (baseCoord0 < 0L && len > 0L) {
            m = Math.min(-baseCoord0, len);
            baseCoord0 += m;
            indexInBase += m;
            srcArrayOffset += m;
            len -= m;
        }
        if (baseCoord0 >= 0L && baseCoord0 < this.baseDim0 && len > 0L) {
            m = Math.min(this.baseDim0 - baseCoord0, len);
            this.updatableBaseBitArray.setBits(indexInBase, srcArray, srcArrayOffset, m);
            baseCoord0 += m;
            srcArrayOffset += m;
            len -= m;
        }
        if (baseCoord0 < this.baseDim0 || len > 0L) {
            // empty if block
        }
    }

    @Override
    public long indexOfBit(long lowIndex, long highIndex, boolean value) {
        long len;
        long count;
        if (lowIndex < 0L) {
            lowIndex = 0L;
        }
        if (highIndex > this.size) {
            highIndex = this.size;
        }
        if (highIndex <= lowIndex) {
            return -1L;
        }
        if (this.dim.length == 1) {
            long result = this.indexOfBitInLine(lowIndex + this.pos0, lowIndex + this.pos0, count, value);
            return result == Long.MAX_VALUE ? -1L : result - this.pos0;
        }
        long bLast = -157L;
        long index = lowIndex;
        for (count = highIndex - lowIndex; count > 0L; count -= len) {
            boolean fullLineOutside;
            long indexInBase;
            long baseCoord0;
            block19: {
                long subCoord0;
                long b;
                long a = index;
                if (index == lowIndex) {
                    b = a / this.dim0;
                    subCoord0 = a - b * this.dim0;
                } else {
                    b = bLast + 1L;
                    subCoord0 = 0L;
                }
                bLast = b;
                len = Math.min(this.dim0 - subCoord0, count);
                assert (len > 0L) : "zero len = " + len;
                indexInBase = baseCoord0 = this.pos0 + subCoord0;
                if (baseCoord0 <= -len || baseCoord0 >= this.baseDim0) {
                    fullLineOutside = true;
                } else {
                    int k;
                    a = b;
                    fullLineOutside = false;
                    for (k = 1; k < this.dim.length - 1; ++k) {
                        b = a / this.dim[k];
                        long subCoordK = a - b * this.dim[k];
                        long baseCoordK = this.pos[k] + subCoordK;
                        if (baseCoordK < 0L || baseCoordK >= this.baseDim[k]) {
                            fullLineOutside = true;
                            break block19;
                        }
                        a = b;
                        indexInBase += baseCoordK * this.baseDimMul[k];
                    }
                    assert (k == this.dim.length - 1);
                    long baseCoordLast = this.pos[k] + a;
                    if (baseCoordLast < 0L || baseCoordLast >= this.baseDim[k]) {
                        fullLineOutside = true;
                    } else {
                        indexInBase += baseCoordLast * this.baseDimMul[k];
                    }
                }
            }
            if (fullLineOutside) {
                if (value == this.outsideBitConst) {
                    return index;
                }
            } else {
                long result = this.indexOfBitInLine(indexInBase, baseCoord0, len, value);
                if (result != Long.MAX_VALUE) {
                    return index + result - indexInBase;
                }
            }
            index += len;
        }
        return -1L;
    }

    private long indexOfBitInLine(long indexInBase, long baseCoord0, long len, boolean value) {
        long m;
        if (len <= 0L) {
            return Long.MAX_VALUE;
        }
        if (baseCoord0 < 0L) {
            m = -baseCoord0;
            if (value == this.outsideBitConst) {
                return indexInBase;
            }
            if ((len -= m) <= 0L) {
                return Long.MAX_VALUE;
            }
            baseCoord0 += m;
            indexInBase += m;
        }
        if (baseCoord0 >= 0L && baseCoord0 < this.baseDim0) {
            m = Math.min(this.baseDim0 - baseCoord0, len);
            long result = this.baseBitArray.indexOf(indexInBase, indexInBase + m, value);
            if (result != -1L) {
                return result;
            }
            len -= m;
            baseCoord0 += m;
            indexInBase += m;
        }
        if (baseCoord0 >= this.baseDim0 && len > 0L && value == this.outsideBitConst) {
            return indexInBase;
        }
        return Long.MAX_VALUE;
    }

    @Override
    public long lastIndexOfBit(long lowIndex, long highIndex, boolean value) {
        if (lowIndex < 0L) {
            lowIndex = 0L;
        }
        if (highIndex > this.size) {
            highIndex = this.size;
        }
        if (highIndex <= lowIndex) {
            return -1L;
        }
        long count = highIndex - lowIndex;
        --highIndex;
        if (this.dim.length == 1) {
            long result = this.lastIndexOfBitInLine(highIndex + this.pos0, highIndex + this.pos0, count, value);
            return result == Long.MAX_VALUE ? -1L : result - this.pos0;
        }
        long bLast = -157L;
        long index = highIndex;
        while (count > 0L) {
            boolean fullLineOutside;
            long indexInBase;
            long baseCoord0;
            long len;
            block19: {
                long subCoord0;
                long b;
                long a = index;
                if (index == highIndex) {
                    b = a / this.dim0;
                    subCoord0 = a - b * this.dim0;
                } else {
                    b = bLast - 1L;
                    subCoord0 = this.dim0 - 1L;
                }
                bLast = b;
                len = Math.min(subCoord0 + 1L, count);
                assert (len > 0L) : "zero len = " + len;
                indexInBase = baseCoord0 = this.pos0 + subCoord0;
                if (baseCoord0 < 0L || baseCoord0 - len >= this.baseDim0) {
                    fullLineOutside = true;
                } else {
                    int k;
                    a = b;
                    fullLineOutside = false;
                    for (k = 1; k < this.dim.length - 1; ++k) {
                        b = a / this.dim[k];
                        long subCoordK = a - b * this.dim[k];
                        long baseCoordK = this.pos[k] + subCoordK;
                        if (baseCoordK < 0L || baseCoordK >= this.baseDim[k]) {
                            fullLineOutside = true;
                            break block19;
                        }
                        a = b;
                        indexInBase += baseCoordK * this.baseDimMul[k];
                    }
                    assert (k == this.dim.length - 1);
                    long baseCoordLast = this.pos[k] + a;
                    if (baseCoordLast < 0L || baseCoordLast >= this.baseDim[k]) {
                        fullLineOutside = true;
                    } else {
                        indexInBase += baseCoordLast * this.baseDimMul[k];
                    }
                }
            }
            if (fullLineOutside) {
                if (value == this.outsideBitConst) {
                    return index;
                }
            } else {
                long result = this.lastIndexOfBitInLine(indexInBase, baseCoord0, len, value);
                if (result != Long.MAX_VALUE) {
                    return index + result - indexInBase;
                }
            }
            index -= len;
            count -= len;
        }
        return -1L;
    }

    private long lastIndexOfBitInLine(long indexInBase, long baseCoord0, long len, boolean value) {
        long m;
        if (len <= 0L) {
            return Long.MAX_VALUE;
        }
        if (baseCoord0 >= this.baseDim0) {
            if (value == this.outsideBitConst) {
                return indexInBase;
            }
            m = baseCoord0 - this.baseDim0 + 1L;
            if ((len -= m) <= 0L) {
                return Long.MAX_VALUE;
            }
            baseCoord0 -= m;
            indexInBase -= m;
        }
        if (baseCoord0 < this.baseDim0 && baseCoord0 >= 0L) {
            m = Math.min(baseCoord0 + 1L, len);
            long result = this.baseBitArray.lastIndexOf(indexInBase + 1L - m, indexInBase + 1L, value);
            if (result != -1L) {
                return result;
            }
            len -= m;
            baseCoord0 -= m;
            indexInBase -= m;
        }
        if (baseCoord0 < 0L && len > 0L && value == this.outsideBitConst) {
            return indexInBase;
        }
        return Long.MAX_VALUE;
    }

    @Override
    public void fillBits(long position, long count, boolean value) {
        assert (position >= 0L && position <= this.size - count);
        assert (count >= 0L);
        if (this.dim.length == 1) {
            this.fillBitsInLine(position + this.pos0, position + this.pos0, count, value);
            return;
        }
        long bLast = -157L;
        long index = position;
        while (count > 0L) {
            boolean fullLineOutside;
            long indexInBase;
            long baseCoord0;
            long len;
            block15: {
                long subCoord0;
                long b;
                long a = index;
                if (index == position) {
                    b = a / this.dim0;
                    subCoord0 = a - b * this.dim0;
                } else {
                    b = bLast + 1L;
                    subCoord0 = 0L;
                }
                bLast = b;
                len = Math.min(this.dim0 - subCoord0, count);
                assert (len > 0L) : "zero len = " + len;
                indexInBase = baseCoord0 = this.pos0 + subCoord0;
                if (baseCoord0 <= -len || baseCoord0 >= this.baseDim0) {
                    fullLineOutside = true;
                } else {
                    int k;
                    a = b;
                    fullLineOutside = false;
                    for (k = 1; k < this.dim.length - 1; ++k) {
                        b = a / this.dim[k];
                        long subCoordK = a - b * this.dim[k];
                        long baseCoordK = this.pos[k] + subCoordK;
                        if (baseCoordK < 0L || baseCoordK >= this.baseDim[k]) {
                            fullLineOutside = true;
                            break block15;
                        }
                        a = b;
                        indexInBase += baseCoordK * this.baseDimMul[k];
                    }
                    assert (k == this.dim.length - 1);
                    long baseCoordLast = this.pos[k] + a;
                    if (baseCoordLast < 0L || baseCoordLast >= this.baseDim[k]) {
                        fullLineOutside = true;
                    } else {
                        indexInBase += baseCoordLast * this.baseDimMul[k];
                    }
                }
            }
            if (!fullLineOutside) {
                this.fillBitsInLine(indexInBase, baseCoord0, len, value);
            }
            index += len;
            count -= len;
        }
    }

    private void fillBitsInLine(long indexInBase, long baseCoord0, long len, boolean value) {
        if (baseCoord0 < 0L && len > 0L) {
            if ((len += baseCoord0) <= 0L) {
                return;
            }
            indexInBase -= baseCoord0;
            baseCoord0 = 0L;
        }
        if (baseCoord0 < this.baseDim0 && len > 0L) {
            long m = Math.min(this.baseDim0 - baseCoord0, len);
            this.updatableBaseBitArray.fill(indexInBase, m, value);
        }
    }

    @Override
    public long indexOfChar(long lowIndex, long highIndex, char value) {
        long len;
        long count;
        if (lowIndex < 0L) {
            lowIndex = 0L;
        }
        if (highIndex > this.size) {
            highIndex = this.size;
        }
        if (highIndex <= lowIndex) {
            return -1L;
        }
        if (this.dim.length == 1) {
            long result = this.indexOfCharInLine(lowIndex + this.pos0, lowIndex + this.pos0, count, value);
            return result == Long.MAX_VALUE ? -1L : result - this.pos0;
        }
        long bLast = -157L;
        long index = lowIndex;
        for (count = highIndex - lowIndex; count > 0L; count -= len) {
            boolean fullLineOutside;
            long indexInBase;
            long baseCoord0;
            block19: {
                long subCoord0;
                long b;
                long a = index;
                if (index == lowIndex) {
                    b = a / this.dim0;
                    subCoord0 = a - b * this.dim0;
                } else {
                    b = bLast + 1L;
                    subCoord0 = 0L;
                }
                bLast = b;
                len = Math.min(this.dim0 - subCoord0, count);
                assert (len > 0L) : "zero len = " + len;
                indexInBase = baseCoord0 = this.pos0 + subCoord0;
                if (baseCoord0 <= -len || baseCoord0 >= this.baseDim0) {
                    fullLineOutside = true;
                } else {
                    int k;
                    a = b;
                    fullLineOutside = false;
                    for (k = 1; k < this.dim.length - 1; ++k) {
                        b = a / this.dim[k];
                        long subCoordK = a - b * this.dim[k];
                        long baseCoordK = this.pos[k] + subCoordK;
                        if (baseCoordK < 0L || baseCoordK >= this.baseDim[k]) {
                            fullLineOutside = true;
                            break block19;
                        }
                        a = b;
                        indexInBase += baseCoordK * this.baseDimMul[k];
                    }
                    assert (k == this.dim.length - 1);
                    long baseCoordLast = this.pos[k] + a;
                    if (baseCoordLast < 0L || baseCoordLast >= this.baseDim[k]) {
                        fullLineOutside = true;
                    } else {
                        indexInBase += baseCoordLast * this.baseDimMul[k];
                    }
                }
            }
            if (fullLineOutside) {
                if (value == this.outsideCharConst) {
                    return index;
                }
            } else {
                long result = this.indexOfCharInLine(indexInBase, baseCoord0, len, value);
                if (result != Long.MAX_VALUE) {
                    return index + result - indexInBase;
                }
            }
            index += len;
        }
        return -1L;
    }

    private long indexOfCharInLine(long indexInBase, long baseCoord0, long len, char value) {
        long m;
        if (len <= 0L) {
            return Long.MAX_VALUE;
        }
        if (baseCoord0 < 0L) {
            m = -baseCoord0;
            if (value == this.outsideCharConst) {
                return indexInBase;
            }
            if ((len -= m) <= 0L) {
                return Long.MAX_VALUE;
            }
            baseCoord0 += m;
            indexInBase += m;
        }
        if (baseCoord0 >= 0L && baseCoord0 < this.baseDim0) {
            m = Math.min(this.baseDim0 - baseCoord0, len);
            long result = this.baseCharArray.indexOf(indexInBase, indexInBase + m, value);
            if (result != -1L) {
                return result;
            }
            len -= m;
            baseCoord0 += m;
            indexInBase += m;
        }
        if (baseCoord0 >= this.baseDim0 && len > 0L && value == this.outsideCharConst) {
            return indexInBase;
        }
        return Long.MAX_VALUE;
    }

    @Override
    public long lastIndexOfChar(long lowIndex, long highIndex, char value) {
        if (lowIndex < 0L) {
            lowIndex = 0L;
        }
        if (highIndex > this.size) {
            highIndex = this.size;
        }
        if (highIndex <= lowIndex) {
            return -1L;
        }
        long count = highIndex - lowIndex;
        --highIndex;
        if (this.dim.length == 1) {
            long result = this.lastIndexOfCharInLine(highIndex + this.pos0, highIndex + this.pos0, count, value);
            return result == Long.MAX_VALUE ? -1L : result - this.pos0;
        }
        long bLast = -157L;
        long index = highIndex;
        while (count > 0L) {
            boolean fullLineOutside;
            long indexInBase;
            long baseCoord0;
            long len;
            block19: {
                long subCoord0;
                long b;
                long a = index;
                if (index == highIndex) {
                    b = a / this.dim0;
                    subCoord0 = a - b * this.dim0;
                } else {
                    b = bLast - 1L;
                    subCoord0 = this.dim0 - 1L;
                }
                bLast = b;
                len = Math.min(subCoord0 + 1L, count);
                assert (len > 0L) : "zero len = " + len;
                indexInBase = baseCoord0 = this.pos0 + subCoord0;
                if (baseCoord0 < 0L || baseCoord0 - len >= this.baseDim0) {
                    fullLineOutside = true;
                } else {
                    int k;
                    a = b;
                    fullLineOutside = false;
                    for (k = 1; k < this.dim.length - 1; ++k) {
                        b = a / this.dim[k];
                        long subCoordK = a - b * this.dim[k];
                        long baseCoordK = this.pos[k] + subCoordK;
                        if (baseCoordK < 0L || baseCoordK >= this.baseDim[k]) {
                            fullLineOutside = true;
                            break block19;
                        }
                        a = b;
                        indexInBase += baseCoordK * this.baseDimMul[k];
                    }
                    assert (k == this.dim.length - 1);
                    long baseCoordLast = this.pos[k] + a;
                    if (baseCoordLast < 0L || baseCoordLast >= this.baseDim[k]) {
                        fullLineOutside = true;
                    } else {
                        indexInBase += baseCoordLast * this.baseDimMul[k];
                    }
                }
            }
            if (fullLineOutside) {
                if (value == this.outsideCharConst) {
                    return index;
                }
            } else {
                long result = this.lastIndexOfCharInLine(indexInBase, baseCoord0, len, value);
                if (result != Long.MAX_VALUE) {
                    return index + result - indexInBase;
                }
            }
            index -= len;
            count -= len;
        }
        return -1L;
    }

    private long lastIndexOfCharInLine(long indexInBase, long baseCoord0, long len, char value) {
        long m;
        if (len <= 0L) {
            return Long.MAX_VALUE;
        }
        if (baseCoord0 >= this.baseDim0) {
            if (value == this.outsideCharConst) {
                return indexInBase;
            }
            m = baseCoord0 - this.baseDim0 + 1L;
            if ((len -= m) <= 0L) {
                return Long.MAX_VALUE;
            }
            baseCoord0 -= m;
            indexInBase -= m;
        }
        if (baseCoord0 < this.baseDim0 && baseCoord0 >= 0L) {
            m = Math.min(baseCoord0 + 1L, len);
            long result = this.baseCharArray.lastIndexOf(indexInBase + 1L - m, indexInBase + 1L, value);
            if (result != -1L) {
                return result;
            }
            len -= m;
            baseCoord0 -= m;
            indexInBase -= m;
        }
        if (baseCoord0 < 0L && len > 0L && value == this.outsideCharConst) {
            return indexInBase;
        }
        return Long.MAX_VALUE;
    }

    @Override
    public void fillChars(long position, long count, char value) {
        assert (position >= 0L && position <= this.size - count);
        assert (count >= 0L);
        if (this.dim.length == 1) {
            this.fillCharsInLine(position + this.pos0, position + this.pos0, count, value);
            return;
        }
        long bLast = -157L;
        long index = position;
        while (count > 0L) {
            boolean fullLineOutside;
            long indexInBase;
            long baseCoord0;
            long len;
            block15: {
                long subCoord0;
                long b;
                long a = index;
                if (index == position) {
                    b = a / this.dim0;
                    subCoord0 = a - b * this.dim0;
                } else {
                    b = bLast + 1L;
                    subCoord0 = 0L;
                }
                bLast = b;
                len = Math.min(this.dim0 - subCoord0, count);
                assert (len > 0L) : "zero len = " + len;
                indexInBase = baseCoord0 = this.pos0 + subCoord0;
                if (baseCoord0 <= -len || baseCoord0 >= this.baseDim0) {
                    fullLineOutside = true;
                } else {
                    int k;
                    a = b;
                    fullLineOutside = false;
                    for (k = 1; k < this.dim.length - 1; ++k) {
                        b = a / this.dim[k];
                        long subCoordK = a - b * this.dim[k];
                        long baseCoordK = this.pos[k] + subCoordK;
                        if (baseCoordK < 0L || baseCoordK >= this.baseDim[k]) {
                            fullLineOutside = true;
                            break block15;
                        }
                        a = b;
                        indexInBase += baseCoordK * this.baseDimMul[k];
                    }
                    assert (k == this.dim.length - 1);
                    long baseCoordLast = this.pos[k] + a;
                    if (baseCoordLast < 0L || baseCoordLast >= this.baseDim[k]) {
                        fullLineOutside = true;
                    } else {
                        indexInBase += baseCoordLast * this.baseDimMul[k];
                    }
                }
            }
            if (!fullLineOutside) {
                this.fillCharsInLine(indexInBase, baseCoord0, len, value);
            }
            index += len;
            count -= len;
        }
    }

    private void fillCharsInLine(long indexInBase, long baseCoord0, long len, char value) {
        if (baseCoord0 < 0L && len > 0L) {
            if ((len += baseCoord0) <= 0L) {
                return;
            }
            indexInBase -= baseCoord0;
            baseCoord0 = 0L;
        }
        if (baseCoord0 < this.baseDim0 && len > 0L) {
            long m = Math.min(this.baseDim0 - baseCoord0, len);
            this.updatableBaseCharArray.fill(indexInBase, m, value);
        }
    }

    @Override
    public long indexOfByte(long lowIndex, long highIndex, byte value) {
        long len;
        long count;
        if (lowIndex < 0L) {
            lowIndex = 0L;
        }
        if (highIndex > this.size) {
            highIndex = this.size;
        }
        if (highIndex <= lowIndex) {
            return -1L;
        }
        if (this.dim.length == 1) {
            long result = this.indexOfByteInLine(lowIndex + this.pos0, lowIndex + this.pos0, count, value);
            return result == Long.MAX_VALUE ? -1L : result - this.pos0;
        }
        long bLast = -157L;
        long index = lowIndex;
        for (count = highIndex - lowIndex; count > 0L; count -= len) {
            boolean fullLineOutside;
            long indexInBase;
            long baseCoord0;
            block19: {
                long subCoord0;
                long b;
                long a = index;
                if (index == lowIndex) {
                    b = a / this.dim0;
                    subCoord0 = a - b * this.dim0;
                } else {
                    b = bLast + 1L;
                    subCoord0 = 0L;
                }
                bLast = b;
                len = Math.min(this.dim0 - subCoord0, count);
                assert (len > 0L) : "zero len = " + len;
                indexInBase = baseCoord0 = this.pos0 + subCoord0;
                if (baseCoord0 <= -len || baseCoord0 >= this.baseDim0) {
                    fullLineOutside = true;
                } else {
                    int k;
                    a = b;
                    fullLineOutside = false;
                    for (k = 1; k < this.dim.length - 1; ++k) {
                        b = a / this.dim[k];
                        long subCoordK = a - b * this.dim[k];
                        long baseCoordK = this.pos[k] + subCoordK;
                        if (baseCoordK < 0L || baseCoordK >= this.baseDim[k]) {
                            fullLineOutside = true;
                            break block19;
                        }
                        a = b;
                        indexInBase += baseCoordK * this.baseDimMul[k];
                    }
                    assert (k == this.dim.length - 1);
                    long baseCoordLast = this.pos[k] + a;
                    if (baseCoordLast < 0L || baseCoordLast >= this.baseDim[k]) {
                        fullLineOutside = true;
                    } else {
                        indexInBase += baseCoordLast * this.baseDimMul[k];
                    }
                }
            }
            if (fullLineOutside) {
                if (value == this.outsideByteConst) {
                    return index;
                }
            } else {
                long result = this.indexOfByteInLine(indexInBase, baseCoord0, len, value);
                if (result != Long.MAX_VALUE) {
                    return index + result - indexInBase;
                }
            }
            index += len;
        }
        return -1L;
    }

    private long indexOfByteInLine(long indexInBase, long baseCoord0, long len, byte value) {
        long m;
        if (len <= 0L) {
            return Long.MAX_VALUE;
        }
        if (baseCoord0 < 0L) {
            m = -baseCoord0;
            if (value == this.outsideByteConst) {
                return indexInBase;
            }
            if ((len -= m) <= 0L) {
                return Long.MAX_VALUE;
            }
            baseCoord0 += m;
            indexInBase += m;
        }
        if (baseCoord0 >= 0L && baseCoord0 < this.baseDim0) {
            m = Math.min(this.baseDim0 - baseCoord0, len);
            long result = this.baseByteArray.indexOf(indexInBase, indexInBase + m, value);
            if (result != -1L) {
                return result;
            }
            len -= m;
            baseCoord0 += m;
            indexInBase += m;
        }
        if (baseCoord0 >= this.baseDim0 && len > 0L && value == this.outsideByteConst) {
            return indexInBase;
        }
        return Long.MAX_VALUE;
    }

    @Override
    public long lastIndexOfByte(long lowIndex, long highIndex, byte value) {
        if (lowIndex < 0L) {
            lowIndex = 0L;
        }
        if (highIndex > this.size) {
            highIndex = this.size;
        }
        if (highIndex <= lowIndex) {
            return -1L;
        }
        long count = highIndex - lowIndex;
        --highIndex;
        if (this.dim.length == 1) {
            long result = this.lastIndexOfByteInLine(highIndex + this.pos0, highIndex + this.pos0, count, value);
            return result == Long.MAX_VALUE ? -1L : result - this.pos0;
        }
        long bLast = -157L;
        long index = highIndex;
        while (count > 0L) {
            boolean fullLineOutside;
            long indexInBase;
            long baseCoord0;
            long len;
            block19: {
                long subCoord0;
                long b;
                long a = index;
                if (index == highIndex) {
                    b = a / this.dim0;
                    subCoord0 = a - b * this.dim0;
                } else {
                    b = bLast - 1L;
                    subCoord0 = this.dim0 - 1L;
                }
                bLast = b;
                len = Math.min(subCoord0 + 1L, count);
                assert (len > 0L) : "zero len = " + len;
                indexInBase = baseCoord0 = this.pos0 + subCoord0;
                if (baseCoord0 < 0L || baseCoord0 - len >= this.baseDim0) {
                    fullLineOutside = true;
                } else {
                    int k;
                    a = b;
                    fullLineOutside = false;
                    for (k = 1; k < this.dim.length - 1; ++k) {
                        b = a / this.dim[k];
                        long subCoordK = a - b * this.dim[k];
                        long baseCoordK = this.pos[k] + subCoordK;
                        if (baseCoordK < 0L || baseCoordK >= this.baseDim[k]) {
                            fullLineOutside = true;
                            break block19;
                        }
                        a = b;
                        indexInBase += baseCoordK * this.baseDimMul[k];
                    }
                    assert (k == this.dim.length - 1);
                    long baseCoordLast = this.pos[k] + a;
                    if (baseCoordLast < 0L || baseCoordLast >= this.baseDim[k]) {
                        fullLineOutside = true;
                    } else {
                        indexInBase += baseCoordLast * this.baseDimMul[k];
                    }
                }
            }
            if (fullLineOutside) {
                if (value == this.outsideByteConst) {
                    return index;
                }
            } else {
                long result = this.lastIndexOfByteInLine(indexInBase, baseCoord0, len, value);
                if (result != Long.MAX_VALUE) {
                    return index + result - indexInBase;
                }
            }
            index -= len;
            count -= len;
        }
        return -1L;
    }

    private long lastIndexOfByteInLine(long indexInBase, long baseCoord0, long len, byte value) {
        long m;
        if (len <= 0L) {
            return Long.MAX_VALUE;
        }
        if (baseCoord0 >= this.baseDim0) {
            if (value == this.outsideByteConst) {
                return indexInBase;
            }
            m = baseCoord0 - this.baseDim0 + 1L;
            if ((len -= m) <= 0L) {
                return Long.MAX_VALUE;
            }
            baseCoord0 -= m;
            indexInBase -= m;
        }
        if (baseCoord0 < this.baseDim0 && baseCoord0 >= 0L) {
            m = Math.min(baseCoord0 + 1L, len);
            long result = this.baseByteArray.lastIndexOf(indexInBase + 1L - m, indexInBase + 1L, value);
            if (result != -1L) {
                return result;
            }
            len -= m;
            baseCoord0 -= m;
            indexInBase -= m;
        }
        if (baseCoord0 < 0L && len > 0L && value == this.outsideByteConst) {
            return indexInBase;
        }
        return Long.MAX_VALUE;
    }

    @Override
    public void fillBytes(long position, long count, byte value) {
        assert (position >= 0L && position <= this.size - count);
        assert (count >= 0L);
        if (this.dim.length == 1) {
            this.fillBytesInLine(position + this.pos0, position + this.pos0, count, value);
            return;
        }
        long bLast = -157L;
        long index = position;
        while (count > 0L) {
            boolean fullLineOutside;
            long indexInBase;
            long baseCoord0;
            long len;
            block15: {
                long subCoord0;
                long b;
                long a = index;
                if (index == position) {
                    b = a / this.dim0;
                    subCoord0 = a - b * this.dim0;
                } else {
                    b = bLast + 1L;
                    subCoord0 = 0L;
                }
                bLast = b;
                len = Math.min(this.dim0 - subCoord0, count);
                assert (len > 0L) : "zero len = " + len;
                indexInBase = baseCoord0 = this.pos0 + subCoord0;
                if (baseCoord0 <= -len || baseCoord0 >= this.baseDim0) {
                    fullLineOutside = true;
                } else {
                    int k;
                    a = b;
                    fullLineOutside = false;
                    for (k = 1; k < this.dim.length - 1; ++k) {
                        b = a / this.dim[k];
                        long subCoordK = a - b * this.dim[k];
                        long baseCoordK = this.pos[k] + subCoordK;
                        if (baseCoordK < 0L || baseCoordK >= this.baseDim[k]) {
                            fullLineOutside = true;
                            break block15;
                        }
                        a = b;
                        indexInBase += baseCoordK * this.baseDimMul[k];
                    }
                    assert (k == this.dim.length - 1);
                    long baseCoordLast = this.pos[k] + a;
                    if (baseCoordLast < 0L || baseCoordLast >= this.baseDim[k]) {
                        fullLineOutside = true;
                    } else {
                        indexInBase += baseCoordLast * this.baseDimMul[k];
                    }
                }
            }
            if (!fullLineOutside) {
                this.fillBytesInLine(indexInBase, baseCoord0, len, value);
            }
            index += len;
            count -= len;
        }
    }

    private void fillBytesInLine(long indexInBase, long baseCoord0, long len, byte value) {
        if (baseCoord0 < 0L && len > 0L) {
            if ((len += baseCoord0) <= 0L) {
                return;
            }
            indexInBase -= baseCoord0;
            baseCoord0 = 0L;
        }
        if (baseCoord0 < this.baseDim0 && len > 0L) {
            long m = Math.min(this.baseDim0 - baseCoord0, len);
            this.updatableBaseByteArray.fill(indexInBase, m, value);
        }
    }

    @Override
    public long indexOfShort(long lowIndex, long highIndex, short value) {
        long len;
        long count;
        if (lowIndex < 0L) {
            lowIndex = 0L;
        }
        if (highIndex > this.size) {
            highIndex = this.size;
        }
        if (highIndex <= lowIndex) {
            return -1L;
        }
        if (this.dim.length == 1) {
            long result = this.indexOfShortInLine(lowIndex + this.pos0, lowIndex + this.pos0, count, value);
            return result == Long.MAX_VALUE ? -1L : result - this.pos0;
        }
        long bLast = -157L;
        long index = lowIndex;
        for (count = highIndex - lowIndex; count > 0L; count -= len) {
            boolean fullLineOutside;
            long indexInBase;
            long baseCoord0;
            block19: {
                long subCoord0;
                long b;
                long a = index;
                if (index == lowIndex) {
                    b = a / this.dim0;
                    subCoord0 = a - b * this.dim0;
                } else {
                    b = bLast + 1L;
                    subCoord0 = 0L;
                }
                bLast = b;
                len = Math.min(this.dim0 - subCoord0, count);
                assert (len > 0L) : "zero len = " + len;
                indexInBase = baseCoord0 = this.pos0 + subCoord0;
                if (baseCoord0 <= -len || baseCoord0 >= this.baseDim0) {
                    fullLineOutside = true;
                } else {
                    int k;
                    a = b;
                    fullLineOutside = false;
                    for (k = 1; k < this.dim.length - 1; ++k) {
                        b = a / this.dim[k];
                        long subCoordK = a - b * this.dim[k];
                        long baseCoordK = this.pos[k] + subCoordK;
                        if (baseCoordK < 0L || baseCoordK >= this.baseDim[k]) {
                            fullLineOutside = true;
                            break block19;
                        }
                        a = b;
                        indexInBase += baseCoordK * this.baseDimMul[k];
                    }
                    assert (k == this.dim.length - 1);
                    long baseCoordLast = this.pos[k] + a;
                    if (baseCoordLast < 0L || baseCoordLast >= this.baseDim[k]) {
                        fullLineOutside = true;
                    } else {
                        indexInBase += baseCoordLast * this.baseDimMul[k];
                    }
                }
            }
            if (fullLineOutside) {
                if (value == this.outsideShortConst) {
                    return index;
                }
            } else {
                long result = this.indexOfShortInLine(indexInBase, baseCoord0, len, value);
                if (result != Long.MAX_VALUE) {
                    return index + result - indexInBase;
                }
            }
            index += len;
        }
        return -1L;
    }

    private long indexOfShortInLine(long indexInBase, long baseCoord0, long len, short value) {
        long m;
        if (len <= 0L) {
            return Long.MAX_VALUE;
        }
        if (baseCoord0 < 0L) {
            m = -baseCoord0;
            if (value == this.outsideShortConst) {
                return indexInBase;
            }
            if ((len -= m) <= 0L) {
                return Long.MAX_VALUE;
            }
            baseCoord0 += m;
            indexInBase += m;
        }
        if (baseCoord0 >= 0L && baseCoord0 < this.baseDim0) {
            m = Math.min(this.baseDim0 - baseCoord0, len);
            long result = this.baseShortArray.indexOf(indexInBase, indexInBase + m, value);
            if (result != -1L) {
                return result;
            }
            len -= m;
            baseCoord0 += m;
            indexInBase += m;
        }
        if (baseCoord0 >= this.baseDim0 && len > 0L && value == this.outsideShortConst) {
            return indexInBase;
        }
        return Long.MAX_VALUE;
    }

    @Override
    public long lastIndexOfShort(long lowIndex, long highIndex, short value) {
        if (lowIndex < 0L) {
            lowIndex = 0L;
        }
        if (highIndex > this.size) {
            highIndex = this.size;
        }
        if (highIndex <= lowIndex) {
            return -1L;
        }
        long count = highIndex - lowIndex;
        --highIndex;
        if (this.dim.length == 1) {
            long result = this.lastIndexOfShortInLine(highIndex + this.pos0, highIndex + this.pos0, count, value);
            return result == Long.MAX_VALUE ? -1L : result - this.pos0;
        }
        long bLast = -157L;
        long index = highIndex;
        while (count > 0L) {
            boolean fullLineOutside;
            long indexInBase;
            long baseCoord0;
            long len;
            block19: {
                long subCoord0;
                long b;
                long a = index;
                if (index == highIndex) {
                    b = a / this.dim0;
                    subCoord0 = a - b * this.dim0;
                } else {
                    b = bLast - 1L;
                    subCoord0 = this.dim0 - 1L;
                }
                bLast = b;
                len = Math.min(subCoord0 + 1L, count);
                assert (len > 0L) : "zero len = " + len;
                indexInBase = baseCoord0 = this.pos0 + subCoord0;
                if (baseCoord0 < 0L || baseCoord0 - len >= this.baseDim0) {
                    fullLineOutside = true;
                } else {
                    int k;
                    a = b;
                    fullLineOutside = false;
                    for (k = 1; k < this.dim.length - 1; ++k) {
                        b = a / this.dim[k];
                        long subCoordK = a - b * this.dim[k];
                        long baseCoordK = this.pos[k] + subCoordK;
                        if (baseCoordK < 0L || baseCoordK >= this.baseDim[k]) {
                            fullLineOutside = true;
                            break block19;
                        }
                        a = b;
                        indexInBase += baseCoordK * this.baseDimMul[k];
                    }
                    assert (k == this.dim.length - 1);
                    long baseCoordLast = this.pos[k] + a;
                    if (baseCoordLast < 0L || baseCoordLast >= this.baseDim[k]) {
                        fullLineOutside = true;
                    } else {
                        indexInBase += baseCoordLast * this.baseDimMul[k];
                    }
                }
            }
            if (fullLineOutside) {
                if (value == this.outsideShortConst) {
                    return index;
                }
            } else {
                long result = this.lastIndexOfShortInLine(indexInBase, baseCoord0, len, value);
                if (result != Long.MAX_VALUE) {
                    return index + result - indexInBase;
                }
            }
            index -= len;
            count -= len;
        }
        return -1L;
    }

    private long lastIndexOfShortInLine(long indexInBase, long baseCoord0, long len, short value) {
        long m;
        if (len <= 0L) {
            return Long.MAX_VALUE;
        }
        if (baseCoord0 >= this.baseDim0) {
            if (value == this.outsideShortConst) {
                return indexInBase;
            }
            m = baseCoord0 - this.baseDim0 + 1L;
            if ((len -= m) <= 0L) {
                return Long.MAX_VALUE;
            }
            baseCoord0 -= m;
            indexInBase -= m;
        }
        if (baseCoord0 < this.baseDim0 && baseCoord0 >= 0L) {
            m = Math.min(baseCoord0 + 1L, len);
            long result = this.baseShortArray.lastIndexOf(indexInBase + 1L - m, indexInBase + 1L, value);
            if (result != -1L) {
                return result;
            }
            len -= m;
            baseCoord0 -= m;
            indexInBase -= m;
        }
        if (baseCoord0 < 0L && len > 0L && value == this.outsideShortConst) {
            return indexInBase;
        }
        return Long.MAX_VALUE;
    }

    @Override
    public void fillShorts(long position, long count, short value) {
        assert (position >= 0L && position <= this.size - count);
        assert (count >= 0L);
        if (this.dim.length == 1) {
            this.fillShortsInLine(position + this.pos0, position + this.pos0, count, value);
            return;
        }
        long bLast = -157L;
        long index = position;
        while (count > 0L) {
            boolean fullLineOutside;
            long indexInBase;
            long baseCoord0;
            long len;
            block15: {
                long subCoord0;
                long b;
                long a = index;
                if (index == position) {
                    b = a / this.dim0;
                    subCoord0 = a - b * this.dim0;
                } else {
                    b = bLast + 1L;
                    subCoord0 = 0L;
                }
                bLast = b;
                len = Math.min(this.dim0 - subCoord0, count);
                assert (len > 0L) : "zero len = " + len;
                indexInBase = baseCoord0 = this.pos0 + subCoord0;
                if (baseCoord0 <= -len || baseCoord0 >= this.baseDim0) {
                    fullLineOutside = true;
                } else {
                    int k;
                    a = b;
                    fullLineOutside = false;
                    for (k = 1; k < this.dim.length - 1; ++k) {
                        b = a / this.dim[k];
                        long subCoordK = a - b * this.dim[k];
                        long baseCoordK = this.pos[k] + subCoordK;
                        if (baseCoordK < 0L || baseCoordK >= this.baseDim[k]) {
                            fullLineOutside = true;
                            break block15;
                        }
                        a = b;
                        indexInBase += baseCoordK * this.baseDimMul[k];
                    }
                    assert (k == this.dim.length - 1);
                    long baseCoordLast = this.pos[k] + a;
                    if (baseCoordLast < 0L || baseCoordLast >= this.baseDim[k]) {
                        fullLineOutside = true;
                    } else {
                        indexInBase += baseCoordLast * this.baseDimMul[k];
                    }
                }
            }
            if (!fullLineOutside) {
                this.fillShortsInLine(indexInBase, baseCoord0, len, value);
            }
            index += len;
            count -= len;
        }
    }

    private void fillShortsInLine(long indexInBase, long baseCoord0, long len, short value) {
        if (baseCoord0 < 0L && len > 0L) {
            if ((len += baseCoord0) <= 0L) {
                return;
            }
            indexInBase -= baseCoord0;
            baseCoord0 = 0L;
        }
        if (baseCoord0 < this.baseDim0 && len > 0L) {
            long m = Math.min(this.baseDim0 - baseCoord0, len);
            this.updatableBaseShortArray.fill(indexInBase, m, value);
        }
    }

    @Override
    public long indexOfInt(long lowIndex, long highIndex, int value) {
        long len;
        long count;
        if (lowIndex < 0L) {
            lowIndex = 0L;
        }
        if (highIndex > this.size) {
            highIndex = this.size;
        }
        if (highIndex <= lowIndex) {
            return -1L;
        }
        if (this.dim.length == 1) {
            long result = this.indexOfIntInLine(lowIndex + this.pos0, lowIndex + this.pos0, count, value);
            return result == Long.MAX_VALUE ? -1L : result - this.pos0;
        }
        long bLast = -157L;
        long index = lowIndex;
        for (count = highIndex - lowIndex; count > 0L; count -= len) {
            boolean fullLineOutside;
            long indexInBase;
            long baseCoord0;
            block19: {
                long subCoord0;
                long b;
                long a = index;
                if (index == lowIndex) {
                    b = a / this.dim0;
                    subCoord0 = a - b * this.dim0;
                } else {
                    b = bLast + 1L;
                    subCoord0 = 0L;
                }
                bLast = b;
                len = Math.min(this.dim0 - subCoord0, count);
                assert (len > 0L) : "zero len = " + len;
                indexInBase = baseCoord0 = this.pos0 + subCoord0;
                if (baseCoord0 <= -len || baseCoord0 >= this.baseDim0) {
                    fullLineOutside = true;
                } else {
                    int k;
                    a = b;
                    fullLineOutside = false;
                    for (k = 1; k < this.dim.length - 1; ++k) {
                        b = a / this.dim[k];
                        long subCoordK = a - b * this.dim[k];
                        long baseCoordK = this.pos[k] + subCoordK;
                        if (baseCoordK < 0L || baseCoordK >= this.baseDim[k]) {
                            fullLineOutside = true;
                            break block19;
                        }
                        a = b;
                        indexInBase += baseCoordK * this.baseDimMul[k];
                    }
                    assert (k == this.dim.length - 1);
                    long baseCoordLast = this.pos[k] + a;
                    if (baseCoordLast < 0L || baseCoordLast >= this.baseDim[k]) {
                        fullLineOutside = true;
                    } else {
                        indexInBase += baseCoordLast * this.baseDimMul[k];
                    }
                }
            }
            if (fullLineOutside) {
                if (value == this.outsideIntConst) {
                    return index;
                }
            } else {
                long result = this.indexOfIntInLine(indexInBase, baseCoord0, len, value);
                if (result != Long.MAX_VALUE) {
                    return index + result - indexInBase;
                }
            }
            index += len;
        }
        return -1L;
    }

    private long indexOfIntInLine(long indexInBase, long baseCoord0, long len, int value) {
        long m;
        if (len <= 0L) {
            return Long.MAX_VALUE;
        }
        if (baseCoord0 < 0L) {
            m = -baseCoord0;
            if (value == this.outsideIntConst) {
                return indexInBase;
            }
            if ((len -= m) <= 0L) {
                return Long.MAX_VALUE;
            }
            baseCoord0 += m;
            indexInBase += m;
        }
        if (baseCoord0 >= 0L && baseCoord0 < this.baseDim0) {
            m = Math.min(this.baseDim0 - baseCoord0, len);
            long result = this.baseIntArray.indexOf(indexInBase, indexInBase + m, value);
            if (result != -1L) {
                return result;
            }
            len -= m;
            baseCoord0 += m;
            indexInBase += m;
        }
        if (baseCoord0 >= this.baseDim0 && len > 0L && value == this.outsideIntConst) {
            return indexInBase;
        }
        return Long.MAX_VALUE;
    }

    @Override
    public long lastIndexOfInt(long lowIndex, long highIndex, int value) {
        if (lowIndex < 0L) {
            lowIndex = 0L;
        }
        if (highIndex > this.size) {
            highIndex = this.size;
        }
        if (highIndex <= lowIndex) {
            return -1L;
        }
        long count = highIndex - lowIndex;
        --highIndex;
        if (this.dim.length == 1) {
            long result = this.lastIndexOfIntInLine(highIndex + this.pos0, highIndex + this.pos0, count, value);
            return result == Long.MAX_VALUE ? -1L : result - this.pos0;
        }
        long bLast = -157L;
        long index = highIndex;
        while (count > 0L) {
            boolean fullLineOutside;
            long indexInBase;
            long baseCoord0;
            long len;
            block19: {
                long subCoord0;
                long b;
                long a = index;
                if (index == highIndex) {
                    b = a / this.dim0;
                    subCoord0 = a - b * this.dim0;
                } else {
                    b = bLast - 1L;
                    subCoord0 = this.dim0 - 1L;
                }
                bLast = b;
                len = Math.min(subCoord0 + 1L, count);
                assert (len > 0L) : "zero len = " + len;
                indexInBase = baseCoord0 = this.pos0 + subCoord0;
                if (baseCoord0 < 0L || baseCoord0 - len >= this.baseDim0) {
                    fullLineOutside = true;
                } else {
                    int k;
                    a = b;
                    fullLineOutside = false;
                    for (k = 1; k < this.dim.length - 1; ++k) {
                        b = a / this.dim[k];
                        long subCoordK = a - b * this.dim[k];
                        long baseCoordK = this.pos[k] + subCoordK;
                        if (baseCoordK < 0L || baseCoordK >= this.baseDim[k]) {
                            fullLineOutside = true;
                            break block19;
                        }
                        a = b;
                        indexInBase += baseCoordK * this.baseDimMul[k];
                    }
                    assert (k == this.dim.length - 1);
                    long baseCoordLast = this.pos[k] + a;
                    if (baseCoordLast < 0L || baseCoordLast >= this.baseDim[k]) {
                        fullLineOutside = true;
                    } else {
                        indexInBase += baseCoordLast * this.baseDimMul[k];
                    }
                }
            }
            if (fullLineOutside) {
                if (value == this.outsideIntConst) {
                    return index;
                }
            } else {
                long result = this.lastIndexOfIntInLine(indexInBase, baseCoord0, len, value);
                if (result != Long.MAX_VALUE) {
                    return index + result - indexInBase;
                }
            }
            index -= len;
            count -= len;
        }
        return -1L;
    }

    private long lastIndexOfIntInLine(long indexInBase, long baseCoord0, long len, int value) {
        long m;
        if (len <= 0L) {
            return Long.MAX_VALUE;
        }
        if (baseCoord0 >= this.baseDim0) {
            if (value == this.outsideIntConst) {
                return indexInBase;
            }
            m = baseCoord0 - this.baseDim0 + 1L;
            if ((len -= m) <= 0L) {
                return Long.MAX_VALUE;
            }
            baseCoord0 -= m;
            indexInBase -= m;
        }
        if (baseCoord0 < this.baseDim0 && baseCoord0 >= 0L) {
            m = Math.min(baseCoord0 + 1L, len);
            long result = this.baseIntArray.lastIndexOf(indexInBase + 1L - m, indexInBase + 1L, value);
            if (result != -1L) {
                return result;
            }
            len -= m;
            baseCoord0 -= m;
            indexInBase -= m;
        }
        if (baseCoord0 < 0L && len > 0L && value == this.outsideIntConst) {
            return indexInBase;
        }
        return Long.MAX_VALUE;
    }

    @Override
    public void fillInts(long position, long count, int value) {
        assert (position >= 0L && position <= this.size - count);
        assert (count >= 0L);
        if (this.dim.length == 1) {
            this.fillIntsInLine(position + this.pos0, position + this.pos0, count, value);
            return;
        }
        long bLast = -157L;
        long index = position;
        while (count > 0L) {
            boolean fullLineOutside;
            long indexInBase;
            long baseCoord0;
            long len;
            block15: {
                long subCoord0;
                long b;
                long a = index;
                if (index == position) {
                    b = a / this.dim0;
                    subCoord0 = a - b * this.dim0;
                } else {
                    b = bLast + 1L;
                    subCoord0 = 0L;
                }
                bLast = b;
                len = Math.min(this.dim0 - subCoord0, count);
                assert (len > 0L) : "zero len = " + len;
                indexInBase = baseCoord0 = this.pos0 + subCoord0;
                if (baseCoord0 <= -len || baseCoord0 >= this.baseDim0) {
                    fullLineOutside = true;
                } else {
                    int k;
                    a = b;
                    fullLineOutside = false;
                    for (k = 1; k < this.dim.length - 1; ++k) {
                        b = a / this.dim[k];
                        long subCoordK = a - b * this.dim[k];
                        long baseCoordK = this.pos[k] + subCoordK;
                        if (baseCoordK < 0L || baseCoordK >= this.baseDim[k]) {
                            fullLineOutside = true;
                            break block15;
                        }
                        a = b;
                        indexInBase += baseCoordK * this.baseDimMul[k];
                    }
                    assert (k == this.dim.length - 1);
                    long baseCoordLast = this.pos[k] + a;
                    if (baseCoordLast < 0L || baseCoordLast >= this.baseDim[k]) {
                        fullLineOutside = true;
                    } else {
                        indexInBase += baseCoordLast * this.baseDimMul[k];
                    }
                }
            }
            if (!fullLineOutside) {
                this.fillIntsInLine(indexInBase, baseCoord0, len, value);
            }
            index += len;
            count -= len;
        }
    }

    private void fillIntsInLine(long indexInBase, long baseCoord0, long len, int value) {
        if (baseCoord0 < 0L && len > 0L) {
            if ((len += baseCoord0) <= 0L) {
                return;
            }
            indexInBase -= baseCoord0;
            baseCoord0 = 0L;
        }
        if (baseCoord0 < this.baseDim0 && len > 0L) {
            long m = Math.min(this.baseDim0 - baseCoord0, len);
            this.updatableBaseIntArray.fill(indexInBase, m, value);
        }
    }

    @Override
    public long indexOfLong(long lowIndex, long highIndex, long value) {
        long len;
        long count;
        if (lowIndex < 0L) {
            lowIndex = 0L;
        }
        if (highIndex > this.size) {
            highIndex = this.size;
        }
        if (highIndex <= lowIndex) {
            return -1L;
        }
        if (this.dim.length == 1) {
            long result = this.indexOfLongInLine(lowIndex + this.pos0, lowIndex + this.pos0, count, value);
            return result == Long.MAX_VALUE ? -1L : result - this.pos0;
        }
        long bLast = -157L;
        long index = lowIndex;
        for (count = highIndex - lowIndex; count > 0L; count -= len) {
            boolean fullLineOutside;
            long indexInBase;
            long baseCoord0;
            block19: {
                long subCoord0;
                long b;
                long a = index;
                if (index == lowIndex) {
                    b = a / this.dim0;
                    subCoord0 = a - b * this.dim0;
                } else {
                    b = bLast + 1L;
                    subCoord0 = 0L;
                }
                bLast = b;
                len = Math.min(this.dim0 - subCoord0, count);
                assert (len > 0L) : "zero len = " + len;
                indexInBase = baseCoord0 = this.pos0 + subCoord0;
                if (baseCoord0 <= -len || baseCoord0 >= this.baseDim0) {
                    fullLineOutside = true;
                } else {
                    int k;
                    a = b;
                    fullLineOutside = false;
                    for (k = 1; k < this.dim.length - 1; ++k) {
                        b = a / this.dim[k];
                        long subCoordK = a - b * this.dim[k];
                        long baseCoordK = this.pos[k] + subCoordK;
                        if (baseCoordK < 0L || baseCoordK >= this.baseDim[k]) {
                            fullLineOutside = true;
                            break block19;
                        }
                        a = b;
                        indexInBase += baseCoordK * this.baseDimMul[k];
                    }
                    assert (k == this.dim.length - 1);
                    long baseCoordLast = this.pos[k] + a;
                    if (baseCoordLast < 0L || baseCoordLast >= this.baseDim[k]) {
                        fullLineOutside = true;
                    } else {
                        indexInBase += baseCoordLast * this.baseDimMul[k];
                    }
                }
            }
            if (fullLineOutside) {
                if (value == this.outsideLongConst) {
                    return index;
                }
            } else {
                long result = this.indexOfLongInLine(indexInBase, baseCoord0, len, value);
                if (result != Long.MAX_VALUE) {
                    return index + result - indexInBase;
                }
            }
            index += len;
        }
        return -1L;
    }

    private long indexOfLongInLine(long indexInBase, long baseCoord0, long len, long value) {
        long m;
        if (len <= 0L) {
            return Long.MAX_VALUE;
        }
        if (baseCoord0 < 0L) {
            m = -baseCoord0;
            if (value == this.outsideLongConst) {
                return indexInBase;
            }
            if ((len -= m) <= 0L) {
                return Long.MAX_VALUE;
            }
            baseCoord0 += m;
            indexInBase += m;
        }
        if (baseCoord0 >= 0L && baseCoord0 < this.baseDim0) {
            m = Math.min(this.baseDim0 - baseCoord0, len);
            long result = this.baseLongArray.indexOf(indexInBase, indexInBase + m, value);
            if (result != -1L) {
                return result;
            }
            len -= m;
            baseCoord0 += m;
            indexInBase += m;
        }
        if (baseCoord0 >= this.baseDim0 && len > 0L && value == this.outsideLongConst) {
            return indexInBase;
        }
        return Long.MAX_VALUE;
    }

    @Override
    public long lastIndexOfLong(long lowIndex, long highIndex, long value) {
        if (lowIndex < 0L) {
            lowIndex = 0L;
        }
        if (highIndex > this.size) {
            highIndex = this.size;
        }
        if (highIndex <= lowIndex) {
            return -1L;
        }
        long count = highIndex - lowIndex;
        --highIndex;
        if (this.dim.length == 1) {
            long result = this.lastIndexOfLongInLine(highIndex + this.pos0, highIndex + this.pos0, count, value);
            return result == Long.MAX_VALUE ? -1L : result - this.pos0;
        }
        long bLast = -157L;
        long index = highIndex;
        while (count > 0L) {
            boolean fullLineOutside;
            long indexInBase;
            long baseCoord0;
            long len;
            block19: {
                long subCoord0;
                long b;
                long a = index;
                if (index == highIndex) {
                    b = a / this.dim0;
                    subCoord0 = a - b * this.dim0;
                } else {
                    b = bLast - 1L;
                    subCoord0 = this.dim0 - 1L;
                }
                bLast = b;
                len = Math.min(subCoord0 + 1L, count);
                assert (len > 0L) : "zero len = " + len;
                indexInBase = baseCoord0 = this.pos0 + subCoord0;
                if (baseCoord0 < 0L || baseCoord0 - len >= this.baseDim0) {
                    fullLineOutside = true;
                } else {
                    int k;
                    a = b;
                    fullLineOutside = false;
                    for (k = 1; k < this.dim.length - 1; ++k) {
                        b = a / this.dim[k];
                        long subCoordK = a - b * this.dim[k];
                        long baseCoordK = this.pos[k] + subCoordK;
                        if (baseCoordK < 0L || baseCoordK >= this.baseDim[k]) {
                            fullLineOutside = true;
                            break block19;
                        }
                        a = b;
                        indexInBase += baseCoordK * this.baseDimMul[k];
                    }
                    assert (k == this.dim.length - 1);
                    long baseCoordLast = this.pos[k] + a;
                    if (baseCoordLast < 0L || baseCoordLast >= this.baseDim[k]) {
                        fullLineOutside = true;
                    } else {
                        indexInBase += baseCoordLast * this.baseDimMul[k];
                    }
                }
            }
            if (fullLineOutside) {
                if (value == this.outsideLongConst) {
                    return index;
                }
            } else {
                long result = this.lastIndexOfLongInLine(indexInBase, baseCoord0, len, value);
                if (result != Long.MAX_VALUE) {
                    return index + result - indexInBase;
                }
            }
            index -= len;
            count -= len;
        }
        return -1L;
    }

    private long lastIndexOfLongInLine(long indexInBase, long baseCoord0, long len, long value) {
        long m;
        if (len <= 0L) {
            return Long.MAX_VALUE;
        }
        if (baseCoord0 >= this.baseDim0) {
            if (value == this.outsideLongConst) {
                return indexInBase;
            }
            m = baseCoord0 - this.baseDim0 + 1L;
            if ((len -= m) <= 0L) {
                return Long.MAX_VALUE;
            }
            baseCoord0 -= m;
            indexInBase -= m;
        }
        if (baseCoord0 < this.baseDim0 && baseCoord0 >= 0L) {
            m = Math.min(baseCoord0 + 1L, len);
            long result = this.baseLongArray.lastIndexOf(indexInBase + 1L - m, indexInBase + 1L, value);
            if (result != -1L) {
                return result;
            }
            len -= m;
            baseCoord0 -= m;
            indexInBase -= m;
        }
        if (baseCoord0 < 0L && len > 0L && value == this.outsideLongConst) {
            return indexInBase;
        }
        return Long.MAX_VALUE;
    }

    @Override
    public void fillLongs(long position, long count, long value) {
        assert (position >= 0L && position <= this.size - count);
        assert (count >= 0L);
        if (this.dim.length == 1) {
            this.fillLongsInLine(position + this.pos0, position + this.pos0, count, value);
            return;
        }
        long bLast = -157L;
        long index = position;
        while (count > 0L) {
            boolean fullLineOutside;
            long indexInBase;
            long baseCoord0;
            long len;
            block15: {
                long subCoord0;
                long b;
                long a = index;
                if (index == position) {
                    b = a / this.dim0;
                    subCoord0 = a - b * this.dim0;
                } else {
                    b = bLast + 1L;
                    subCoord0 = 0L;
                }
                bLast = b;
                len = Math.min(this.dim0 - subCoord0, count);
                assert (len > 0L) : "zero len = " + len;
                indexInBase = baseCoord0 = this.pos0 + subCoord0;
                if (baseCoord0 <= -len || baseCoord0 >= this.baseDim0) {
                    fullLineOutside = true;
                } else {
                    int k;
                    a = b;
                    fullLineOutside = false;
                    for (k = 1; k < this.dim.length - 1; ++k) {
                        b = a / this.dim[k];
                        long subCoordK = a - b * this.dim[k];
                        long baseCoordK = this.pos[k] + subCoordK;
                        if (baseCoordK < 0L || baseCoordK >= this.baseDim[k]) {
                            fullLineOutside = true;
                            break block15;
                        }
                        a = b;
                        indexInBase += baseCoordK * this.baseDimMul[k];
                    }
                    assert (k == this.dim.length - 1);
                    long baseCoordLast = this.pos[k] + a;
                    if (baseCoordLast < 0L || baseCoordLast >= this.baseDim[k]) {
                        fullLineOutside = true;
                    } else {
                        indexInBase += baseCoordLast * this.baseDimMul[k];
                    }
                }
            }
            if (!fullLineOutside) {
                this.fillLongsInLine(indexInBase, baseCoord0, len, value);
            }
            index += len;
            count -= len;
        }
    }

    private void fillLongsInLine(long indexInBase, long baseCoord0, long len, long value) {
        if (baseCoord0 < 0L && len > 0L) {
            if ((len += baseCoord0) <= 0L) {
                return;
            }
            indexInBase -= baseCoord0;
            baseCoord0 = 0L;
        }
        if (baseCoord0 < this.baseDim0 && len > 0L) {
            long m = Math.min(this.baseDim0 - baseCoord0, len);
            this.updatableBaseLongArray.fill(indexInBase, m, value);
        }
    }

    @Override
    public long indexOfFloat(long lowIndex, long highIndex, float value) {
        long len;
        long count;
        if (lowIndex < 0L) {
            lowIndex = 0L;
        }
        if (highIndex > this.size) {
            highIndex = this.size;
        }
        if (highIndex <= lowIndex) {
            return -1L;
        }
        if (this.dim.length == 1) {
            long result = this.indexOfFloatInLine(lowIndex + this.pos0, lowIndex + this.pos0, count, value);
            return result == Long.MAX_VALUE ? -1L : result - this.pos0;
        }
        long bLast = -157L;
        long index = lowIndex;
        for (count = highIndex - lowIndex; count > 0L; count -= len) {
            boolean fullLineOutside;
            long indexInBase;
            long baseCoord0;
            block19: {
                long subCoord0;
                long b;
                long a = index;
                if (index == lowIndex) {
                    b = a / this.dim0;
                    subCoord0 = a - b * this.dim0;
                } else {
                    b = bLast + 1L;
                    subCoord0 = 0L;
                }
                bLast = b;
                len = Math.min(this.dim0 - subCoord0, count);
                assert (len > 0L) : "zero len = " + len;
                indexInBase = baseCoord0 = this.pos0 + subCoord0;
                if (baseCoord0 <= -len || baseCoord0 >= this.baseDim0) {
                    fullLineOutside = true;
                } else {
                    int k;
                    a = b;
                    fullLineOutside = false;
                    for (k = 1; k < this.dim.length - 1; ++k) {
                        b = a / this.dim[k];
                        long subCoordK = a - b * this.dim[k];
                        long baseCoordK = this.pos[k] + subCoordK;
                        if (baseCoordK < 0L || baseCoordK >= this.baseDim[k]) {
                            fullLineOutside = true;
                            break block19;
                        }
                        a = b;
                        indexInBase += baseCoordK * this.baseDimMul[k];
                    }
                    assert (k == this.dim.length - 1);
                    long baseCoordLast = this.pos[k] + a;
                    if (baseCoordLast < 0L || baseCoordLast >= this.baseDim[k]) {
                        fullLineOutside = true;
                    } else {
                        indexInBase += baseCoordLast * this.baseDimMul[k];
                    }
                }
            }
            if (fullLineOutside) {
                if (value == this.outsideFloatConst) {
                    return index;
                }
            } else {
                long result = this.indexOfFloatInLine(indexInBase, baseCoord0, len, value);
                if (result != Long.MAX_VALUE) {
                    return index + result - indexInBase;
                }
            }
            index += len;
        }
        return -1L;
    }

    private long indexOfFloatInLine(long indexInBase, long baseCoord0, long len, float value) {
        long m;
        if (len <= 0L) {
            return Long.MAX_VALUE;
        }
        if (baseCoord0 < 0L) {
            m = -baseCoord0;
            if (value == this.outsideFloatConst) {
                return indexInBase;
            }
            if ((len -= m) <= 0L) {
                return Long.MAX_VALUE;
            }
            baseCoord0 += m;
            indexInBase += m;
        }
        if (baseCoord0 >= 0L && baseCoord0 < this.baseDim0) {
            m = Math.min(this.baseDim0 - baseCoord0, len);
            long result = this.baseFloatArray.indexOf(indexInBase, indexInBase + m, value);
            if (result != -1L) {
                return result;
            }
            len -= m;
            baseCoord0 += m;
            indexInBase += m;
        }
        if (baseCoord0 >= this.baseDim0 && len > 0L && value == this.outsideFloatConst) {
            return indexInBase;
        }
        return Long.MAX_VALUE;
    }

    @Override
    public long lastIndexOfFloat(long lowIndex, long highIndex, float value) {
        if (lowIndex < 0L) {
            lowIndex = 0L;
        }
        if (highIndex > this.size) {
            highIndex = this.size;
        }
        if (highIndex <= lowIndex) {
            return -1L;
        }
        long count = highIndex - lowIndex;
        --highIndex;
        if (this.dim.length == 1) {
            long result = this.lastIndexOfFloatInLine(highIndex + this.pos0, highIndex + this.pos0, count, value);
            return result == Long.MAX_VALUE ? -1L : result - this.pos0;
        }
        long bLast = -157L;
        long index = highIndex;
        while (count > 0L) {
            boolean fullLineOutside;
            long indexInBase;
            long baseCoord0;
            long len;
            block19: {
                long subCoord0;
                long b;
                long a = index;
                if (index == highIndex) {
                    b = a / this.dim0;
                    subCoord0 = a - b * this.dim0;
                } else {
                    b = bLast - 1L;
                    subCoord0 = this.dim0 - 1L;
                }
                bLast = b;
                len = Math.min(subCoord0 + 1L, count);
                assert (len > 0L) : "zero len = " + len;
                indexInBase = baseCoord0 = this.pos0 + subCoord0;
                if (baseCoord0 < 0L || baseCoord0 - len >= this.baseDim0) {
                    fullLineOutside = true;
                } else {
                    int k;
                    a = b;
                    fullLineOutside = false;
                    for (k = 1; k < this.dim.length - 1; ++k) {
                        b = a / this.dim[k];
                        long subCoordK = a - b * this.dim[k];
                        long baseCoordK = this.pos[k] + subCoordK;
                        if (baseCoordK < 0L || baseCoordK >= this.baseDim[k]) {
                            fullLineOutside = true;
                            break block19;
                        }
                        a = b;
                        indexInBase += baseCoordK * this.baseDimMul[k];
                    }
                    assert (k == this.dim.length - 1);
                    long baseCoordLast = this.pos[k] + a;
                    if (baseCoordLast < 0L || baseCoordLast >= this.baseDim[k]) {
                        fullLineOutside = true;
                    } else {
                        indexInBase += baseCoordLast * this.baseDimMul[k];
                    }
                }
            }
            if (fullLineOutside) {
                if (value == this.outsideFloatConst) {
                    return index;
                }
            } else {
                long result = this.lastIndexOfFloatInLine(indexInBase, baseCoord0, len, value);
                if (result != Long.MAX_VALUE) {
                    return index + result - indexInBase;
                }
            }
            index -= len;
            count -= len;
        }
        return -1L;
    }

    private long lastIndexOfFloatInLine(long indexInBase, long baseCoord0, long len, float value) {
        long m;
        if (len <= 0L) {
            return Long.MAX_VALUE;
        }
        if (baseCoord0 >= this.baseDim0) {
            if (value == this.outsideFloatConst) {
                return indexInBase;
            }
            m = baseCoord0 - this.baseDim0 + 1L;
            if ((len -= m) <= 0L) {
                return Long.MAX_VALUE;
            }
            baseCoord0 -= m;
            indexInBase -= m;
        }
        if (baseCoord0 < this.baseDim0 && baseCoord0 >= 0L) {
            m = Math.min(baseCoord0 + 1L, len);
            long result = this.baseFloatArray.lastIndexOf(indexInBase + 1L - m, indexInBase + 1L, value);
            if (result != -1L) {
                return result;
            }
            len -= m;
            baseCoord0 -= m;
            indexInBase -= m;
        }
        if (baseCoord0 < 0L && len > 0L && value == this.outsideFloatConst) {
            return indexInBase;
        }
        return Long.MAX_VALUE;
    }

    @Override
    public void fillFloats(long position, long count, float value) {
        assert (position >= 0L && position <= this.size - count);
        assert (count >= 0L);
        if (this.dim.length == 1) {
            this.fillFloatsInLine(position + this.pos0, position + this.pos0, count, value);
            return;
        }
        long bLast = -157L;
        long index = position;
        while (count > 0L) {
            boolean fullLineOutside;
            long indexInBase;
            long baseCoord0;
            long len;
            block15: {
                long subCoord0;
                long b;
                long a = index;
                if (index == position) {
                    b = a / this.dim0;
                    subCoord0 = a - b * this.dim0;
                } else {
                    b = bLast + 1L;
                    subCoord0 = 0L;
                }
                bLast = b;
                len = Math.min(this.dim0 - subCoord0, count);
                assert (len > 0L) : "zero len = " + len;
                indexInBase = baseCoord0 = this.pos0 + subCoord0;
                if (baseCoord0 <= -len || baseCoord0 >= this.baseDim0) {
                    fullLineOutside = true;
                } else {
                    int k;
                    a = b;
                    fullLineOutside = false;
                    for (k = 1; k < this.dim.length - 1; ++k) {
                        b = a / this.dim[k];
                        long subCoordK = a - b * this.dim[k];
                        long baseCoordK = this.pos[k] + subCoordK;
                        if (baseCoordK < 0L || baseCoordK >= this.baseDim[k]) {
                            fullLineOutside = true;
                            break block15;
                        }
                        a = b;
                        indexInBase += baseCoordK * this.baseDimMul[k];
                    }
                    assert (k == this.dim.length - 1);
                    long baseCoordLast = this.pos[k] + a;
                    if (baseCoordLast < 0L || baseCoordLast >= this.baseDim[k]) {
                        fullLineOutside = true;
                    } else {
                        indexInBase += baseCoordLast * this.baseDimMul[k];
                    }
                }
            }
            if (!fullLineOutside) {
                this.fillFloatsInLine(indexInBase, baseCoord0, len, value);
            }
            index += len;
            count -= len;
        }
    }

    private void fillFloatsInLine(long indexInBase, long baseCoord0, long len, float value) {
        if (baseCoord0 < 0L && len > 0L) {
            if ((len += baseCoord0) <= 0L) {
                return;
            }
            indexInBase -= baseCoord0;
            baseCoord0 = 0L;
        }
        if (baseCoord0 < this.baseDim0 && len > 0L) {
            long m = Math.min(this.baseDim0 - baseCoord0, len);
            this.updatableBaseFloatArray.fill(indexInBase, m, value);
        }
    }

    @Override
    public long indexOfDouble(long lowIndex, long highIndex, double value) {
        long len;
        long count;
        if (lowIndex < 0L) {
            lowIndex = 0L;
        }
        if (highIndex > this.size) {
            highIndex = this.size;
        }
        if (highIndex <= lowIndex) {
            return -1L;
        }
        if (this.dim.length == 1) {
            long result = this.indexOfDoubleInLine(lowIndex + this.pos0, lowIndex + this.pos0, count, value);
            return result == Long.MAX_VALUE ? -1L : result - this.pos0;
        }
        long bLast = -157L;
        long index = lowIndex;
        for (count = highIndex - lowIndex; count > 0L; count -= len) {
            boolean fullLineOutside;
            long indexInBase;
            long baseCoord0;
            block19: {
                long subCoord0;
                long b;
                long a = index;
                if (index == lowIndex) {
                    b = a / this.dim0;
                    subCoord0 = a - b * this.dim0;
                } else {
                    b = bLast + 1L;
                    subCoord0 = 0L;
                }
                bLast = b;
                len = Math.min(this.dim0 - subCoord0, count);
                assert (len > 0L) : "zero len = " + len;
                indexInBase = baseCoord0 = this.pos0 + subCoord0;
                if (baseCoord0 <= -len || baseCoord0 >= this.baseDim0) {
                    fullLineOutside = true;
                } else {
                    int k;
                    a = b;
                    fullLineOutside = false;
                    for (k = 1; k < this.dim.length - 1; ++k) {
                        b = a / this.dim[k];
                        long subCoordK = a - b * this.dim[k];
                        long baseCoordK = this.pos[k] + subCoordK;
                        if (baseCoordK < 0L || baseCoordK >= this.baseDim[k]) {
                            fullLineOutside = true;
                            break block19;
                        }
                        a = b;
                        indexInBase += baseCoordK * this.baseDimMul[k];
                    }
                    assert (k == this.dim.length - 1);
                    long baseCoordLast = this.pos[k] + a;
                    if (baseCoordLast < 0L || baseCoordLast >= this.baseDim[k]) {
                        fullLineOutside = true;
                    } else {
                        indexInBase += baseCoordLast * this.baseDimMul[k];
                    }
                }
            }
            if (fullLineOutside) {
                if (value == this.outsideDoubleConst) {
                    return index;
                }
            } else {
                long result = this.indexOfDoubleInLine(indexInBase, baseCoord0, len, value);
                if (result != Long.MAX_VALUE) {
                    return index + result - indexInBase;
                }
            }
            index += len;
        }
        return -1L;
    }

    private long indexOfDoubleInLine(long indexInBase, long baseCoord0, long len, double value) {
        long m;
        if (len <= 0L) {
            return Long.MAX_VALUE;
        }
        if (baseCoord0 < 0L) {
            m = -baseCoord0;
            if (value == this.outsideDoubleConst) {
                return indexInBase;
            }
            if ((len -= m) <= 0L) {
                return Long.MAX_VALUE;
            }
            baseCoord0 += m;
            indexInBase += m;
        }
        if (baseCoord0 >= 0L && baseCoord0 < this.baseDim0) {
            m = Math.min(this.baseDim0 - baseCoord0, len);
            long result = this.baseDoubleArray.indexOf(indexInBase, indexInBase + m, value);
            if (result != -1L) {
                return result;
            }
            len -= m;
            baseCoord0 += m;
            indexInBase += m;
        }
        if (baseCoord0 >= this.baseDim0 && len > 0L && value == this.outsideDoubleConst) {
            return indexInBase;
        }
        return Long.MAX_VALUE;
    }

    @Override
    public long lastIndexOfDouble(long lowIndex, long highIndex, double value) {
        if (lowIndex < 0L) {
            lowIndex = 0L;
        }
        if (highIndex > this.size) {
            highIndex = this.size;
        }
        if (highIndex <= lowIndex) {
            return -1L;
        }
        long count = highIndex - lowIndex;
        --highIndex;
        if (this.dim.length == 1) {
            long result = this.lastIndexOfDoubleInLine(highIndex + this.pos0, highIndex + this.pos0, count, value);
            return result == Long.MAX_VALUE ? -1L : result - this.pos0;
        }
        long bLast = -157L;
        long index = highIndex;
        while (count > 0L) {
            boolean fullLineOutside;
            long indexInBase;
            long baseCoord0;
            long len;
            block19: {
                long subCoord0;
                long b;
                long a = index;
                if (index == highIndex) {
                    b = a / this.dim0;
                    subCoord0 = a - b * this.dim0;
                } else {
                    b = bLast - 1L;
                    subCoord0 = this.dim0 - 1L;
                }
                bLast = b;
                len = Math.min(subCoord0 + 1L, count);
                assert (len > 0L) : "zero len = " + len;
                indexInBase = baseCoord0 = this.pos0 + subCoord0;
                if (baseCoord0 < 0L || baseCoord0 - len >= this.baseDim0) {
                    fullLineOutside = true;
                } else {
                    int k;
                    a = b;
                    fullLineOutside = false;
                    for (k = 1; k < this.dim.length - 1; ++k) {
                        b = a / this.dim[k];
                        long subCoordK = a - b * this.dim[k];
                        long baseCoordK = this.pos[k] + subCoordK;
                        if (baseCoordK < 0L || baseCoordK >= this.baseDim[k]) {
                            fullLineOutside = true;
                            break block19;
                        }
                        a = b;
                        indexInBase += baseCoordK * this.baseDimMul[k];
                    }
                    assert (k == this.dim.length - 1);
                    long baseCoordLast = this.pos[k] + a;
                    if (baseCoordLast < 0L || baseCoordLast >= this.baseDim[k]) {
                        fullLineOutside = true;
                    } else {
                        indexInBase += baseCoordLast * this.baseDimMul[k];
                    }
                }
            }
            if (fullLineOutside) {
                if (value == this.outsideDoubleConst) {
                    return index;
                }
            } else {
                long result = this.lastIndexOfDoubleInLine(indexInBase, baseCoord0, len, value);
                if (result != Long.MAX_VALUE) {
                    return index + result - indexInBase;
                }
            }
            index -= len;
            count -= len;
        }
        return -1L;
    }

    private long lastIndexOfDoubleInLine(long indexInBase, long baseCoord0, long len, double value) {
        long m;
        if (len <= 0L) {
            return Long.MAX_VALUE;
        }
        if (baseCoord0 >= this.baseDim0) {
            if (value == this.outsideDoubleConst) {
                return indexInBase;
            }
            m = baseCoord0 - this.baseDim0 + 1L;
            if ((len -= m) <= 0L) {
                return Long.MAX_VALUE;
            }
            baseCoord0 -= m;
            indexInBase -= m;
        }
        if (baseCoord0 < this.baseDim0 && baseCoord0 >= 0L) {
            m = Math.min(baseCoord0 + 1L, len);
            long result = this.baseDoubleArray.lastIndexOf(indexInBase + 1L - m, indexInBase + 1L, value);
            if (result != -1L) {
                return result;
            }
            len -= m;
            baseCoord0 -= m;
            indexInBase -= m;
        }
        if (baseCoord0 < 0L && len > 0L && value == this.outsideDoubleConst) {
            return indexInBase;
        }
        return Long.MAX_VALUE;
    }

    @Override
    public void fillDoubles(long position, long count, double value) {
        assert (position >= 0L && position <= this.size - count);
        assert (count >= 0L);
        if (this.dim.length == 1) {
            this.fillDoublesInLine(position + this.pos0, position + this.pos0, count, value);
            return;
        }
        long bLast = -157L;
        long index = position;
        while (count > 0L) {
            boolean fullLineOutside;
            long indexInBase;
            long baseCoord0;
            long len;
            block15: {
                long subCoord0;
                long b;
                long a = index;
                if (index == position) {
                    b = a / this.dim0;
                    subCoord0 = a - b * this.dim0;
                } else {
                    b = bLast + 1L;
                    subCoord0 = 0L;
                }
                bLast = b;
                len = Math.min(this.dim0 - subCoord0, count);
                assert (len > 0L) : "zero len = " + len;
                indexInBase = baseCoord0 = this.pos0 + subCoord0;
                if (baseCoord0 <= -len || baseCoord0 >= this.baseDim0) {
                    fullLineOutside = true;
                } else {
                    int k;
                    a = b;
                    fullLineOutside = false;
                    for (k = 1; k < this.dim.length - 1; ++k) {
                        b = a / this.dim[k];
                        long subCoordK = a - b * this.dim[k];
                        long baseCoordK = this.pos[k] + subCoordK;
                        if (baseCoordK < 0L || baseCoordK >= this.baseDim[k]) {
                            fullLineOutside = true;
                            break block15;
                        }
                        a = b;
                        indexInBase += baseCoordK * this.baseDimMul[k];
                    }
                    assert (k == this.dim.length - 1);
                    long baseCoordLast = this.pos[k] + a;
                    if (baseCoordLast < 0L || baseCoordLast >= this.baseDim[k]) {
                        fullLineOutside = true;
                    } else {
                        indexInBase += baseCoordLast * this.baseDimMul[k];
                    }
                }
            }
            if (!fullLineOutside) {
                this.fillDoublesInLine(indexInBase, baseCoord0, len, value);
            }
            index += len;
            count -= len;
        }
    }

    private void fillDoublesInLine(long indexInBase, long baseCoord0, long len, double value) {
        if (baseCoord0 < 0L && len > 0L) {
            if ((len += baseCoord0) <= 0L) {
                return;
            }
            indexInBase -= baseCoord0;
            baseCoord0 = 0L;
        }
        if (baseCoord0 < this.baseDim0 && len > 0L) {
            long m = Math.min(this.baseDim0 - baseCoord0, len);
            this.updatableBaseDoubleArray.fill(indexInBase, m, value);
        }
    }

    @Override
    public long indexOfObject(long lowIndex, long highIndex, Object value) {
        long len;
        long count;
        if (lowIndex < 0L) {
            lowIndex = 0L;
        }
        if (highIndex > this.size) {
            highIndex = this.size;
        }
        if (highIndex <= lowIndex) {
            return -1L;
        }
        if (this.dim.length == 1) {
            long result = this.indexOfObjectInLine(lowIndex + this.pos0, lowIndex + this.pos0, count, value);
            return result == Long.MAX_VALUE ? -1L : result - this.pos0;
        }
        long bLast = -157L;
        long index = lowIndex;
        for (count = highIndex - lowIndex; count > 0L; count -= len) {
            boolean fullLineOutside;
            long indexInBase;
            long baseCoord0;
            block19: {
                long subCoord0;
                long b;
                long a = index;
                if (index == lowIndex) {
                    b = a / this.dim0;
                    subCoord0 = a - b * this.dim0;
                } else {
                    b = bLast + 1L;
                    subCoord0 = 0L;
                }
                bLast = b;
                len = Math.min(this.dim0 - subCoord0, count);
                assert (len > 0L) : "zero len = " + len;
                indexInBase = baseCoord0 = this.pos0 + subCoord0;
                if (baseCoord0 <= -len || baseCoord0 >= this.baseDim0) {
                    fullLineOutside = true;
                } else {
                    int k;
                    a = b;
                    fullLineOutside = false;
                    for (k = 1; k < this.dim.length - 1; ++k) {
                        b = a / this.dim[k];
                        long subCoordK = a - b * this.dim[k];
                        long baseCoordK = this.pos[k] + subCoordK;
                        if (baseCoordK < 0L || baseCoordK >= this.baseDim[k]) {
                            fullLineOutside = true;
                            break block19;
                        }
                        a = b;
                        indexInBase += baseCoordK * this.baseDimMul[k];
                    }
                    assert (k == this.dim.length - 1);
                    long baseCoordLast = this.pos[k] + a;
                    if (baseCoordLast < 0L || baseCoordLast >= this.baseDim[k]) {
                        fullLineOutside = true;
                    } else {
                        indexInBase += baseCoordLast * this.baseDimMul[k];
                    }
                }
            }
            if (fullLineOutside) {
                if (Objects.equals(value, this.outsideObjectConst)) {
                    return index;
                }
            } else {
                long result = this.indexOfObjectInLine(indexInBase, baseCoord0, len, value);
                if (result != Long.MAX_VALUE) {
                    return index + result - indexInBase;
                }
            }
            index += len;
        }
        return -1L;
    }

    private long indexOfObjectInLine(long indexInBase, long baseCoord0, long len, Object value) {
        long m;
        if (len <= 0L) {
            return Long.MAX_VALUE;
        }
        if (baseCoord0 < 0L) {
            m = -baseCoord0;
            if (Objects.equals(value, this.outsideObjectConst)) {
                return indexInBase;
            }
            if ((len -= m) <= 0L) {
                return Long.MAX_VALUE;
            }
            baseCoord0 += m;
            indexInBase += m;
        }
        if (baseCoord0 >= 0L && baseCoord0 < this.baseDim0) {
            m = Math.min(this.baseDim0 - baseCoord0, len);
            long result = this.baseObjectArray.indexOf(indexInBase, indexInBase + m, value);
            if (result != -1L) {
                return result;
            }
            len -= m;
            baseCoord0 += m;
            indexInBase += m;
        }
        if (baseCoord0 >= this.baseDim0 && len > 0L && Objects.equals(value, this.outsideObjectConst)) {
            return indexInBase;
        }
        return Long.MAX_VALUE;
    }

    @Override
    public long lastIndexOfObject(long lowIndex, long highIndex, Object value) {
        if (lowIndex < 0L) {
            lowIndex = 0L;
        }
        if (highIndex > this.size) {
            highIndex = this.size;
        }
        if (highIndex <= lowIndex) {
            return -1L;
        }
        long count = highIndex - lowIndex;
        --highIndex;
        if (this.dim.length == 1) {
            long result = this.lastIndexOfObjectInLine(highIndex + this.pos0, highIndex + this.pos0, count, value);
            return result == Long.MAX_VALUE ? -1L : result - this.pos0;
        }
        long bLast = -157L;
        long index = highIndex;
        while (count > 0L) {
            boolean fullLineOutside;
            long indexInBase;
            long baseCoord0;
            long len;
            block19: {
                long subCoord0;
                long b;
                long a = index;
                if (index == highIndex) {
                    b = a / this.dim0;
                    subCoord0 = a - b * this.dim0;
                } else {
                    b = bLast - 1L;
                    subCoord0 = this.dim0 - 1L;
                }
                bLast = b;
                len = Math.min(subCoord0 + 1L, count);
                assert (len > 0L) : "zero len = " + len;
                indexInBase = baseCoord0 = this.pos0 + subCoord0;
                if (baseCoord0 < 0L || baseCoord0 - len >= this.baseDim0) {
                    fullLineOutside = true;
                } else {
                    int k;
                    a = b;
                    fullLineOutside = false;
                    for (k = 1; k < this.dim.length - 1; ++k) {
                        b = a / this.dim[k];
                        long subCoordK = a - b * this.dim[k];
                        long baseCoordK = this.pos[k] + subCoordK;
                        if (baseCoordK < 0L || baseCoordK >= this.baseDim[k]) {
                            fullLineOutside = true;
                            break block19;
                        }
                        a = b;
                        indexInBase += baseCoordK * this.baseDimMul[k];
                    }
                    assert (k == this.dim.length - 1);
                    long baseCoordLast = this.pos[k] + a;
                    if (baseCoordLast < 0L || baseCoordLast >= this.baseDim[k]) {
                        fullLineOutside = true;
                    } else {
                        indexInBase += baseCoordLast * this.baseDimMul[k];
                    }
                }
            }
            if (fullLineOutside) {
                if (Objects.equals(value, this.outsideObjectConst)) {
                    return index;
                }
            } else {
                long result = this.lastIndexOfObjectInLine(indexInBase, baseCoord0, len, value);
                if (result != Long.MAX_VALUE) {
                    return index + result - indexInBase;
                }
            }
            index -= len;
            count -= len;
        }
        return -1L;
    }

    private long lastIndexOfObjectInLine(long indexInBase, long baseCoord0, long len, Object value) {
        long m;
        if (len <= 0L) {
            return Long.MAX_VALUE;
        }
        if (baseCoord0 >= this.baseDim0) {
            if (Objects.equals(value, this.outsideObjectConst)) {
                return indexInBase;
            }
            m = baseCoord0 - this.baseDim0 + 1L;
            if ((len -= m) <= 0L) {
                return Long.MAX_VALUE;
            }
            baseCoord0 -= m;
            indexInBase -= m;
        }
        if (baseCoord0 < this.baseDim0 && baseCoord0 >= 0L) {
            m = Math.min(baseCoord0 + 1L, len);
            long result = this.baseObjectArray.lastIndexOf(indexInBase + 1L - m, indexInBase + 1L, value);
            if (result != -1L) {
                return result;
            }
            len -= m;
            baseCoord0 -= m;
            indexInBase -= m;
        }
        if (baseCoord0 < 0L && len > 0L && Objects.equals(value, this.outsideObjectConst)) {
            return indexInBase;
        }
        return Long.MAX_VALUE;
    }

    @Override
    public void fillObjects(long position, long count, Object value) {
        assert (position >= 0L && position <= this.size - count);
        assert (count >= 0L);
        if (this.dim.length == 1) {
            this.fillObjectsInLine(position + this.pos0, position + this.pos0, count, value);
            return;
        }
        long bLast = -157L;
        long index = position;
        while (count > 0L) {
            boolean fullLineOutside;
            long indexInBase;
            long baseCoord0;
            long len;
            block15: {
                long subCoord0;
                long b;
                long a = index;
                if (index == position) {
                    b = a / this.dim0;
                    subCoord0 = a - b * this.dim0;
                } else {
                    b = bLast + 1L;
                    subCoord0 = 0L;
                }
                bLast = b;
                len = Math.min(this.dim0 - subCoord0, count);
                assert (len > 0L) : "zero len = " + len;
                indexInBase = baseCoord0 = this.pos0 + subCoord0;
                if (baseCoord0 <= -len || baseCoord0 >= this.baseDim0) {
                    fullLineOutside = true;
                } else {
                    int k;
                    a = b;
                    fullLineOutside = false;
                    for (k = 1; k < this.dim.length - 1; ++k) {
                        b = a / this.dim[k];
                        long subCoordK = a - b * this.dim[k];
                        long baseCoordK = this.pos[k] + subCoordK;
                        if (baseCoordK < 0L || baseCoordK >= this.baseDim[k]) {
                            fullLineOutside = true;
                            break block15;
                        }
                        a = b;
                        indexInBase += baseCoordK * this.baseDimMul[k];
                    }
                    assert (k == this.dim.length - 1);
                    long baseCoordLast = this.pos[k] + a;
                    if (baseCoordLast < 0L || baseCoordLast >= this.baseDim[k]) {
                        fullLineOutside = true;
                    } else {
                        indexInBase += baseCoordLast * this.baseDimMul[k];
                    }
                }
            }
            if (!fullLineOutside) {
                this.fillObjectsInLine(indexInBase, baseCoord0, len, value);
            }
            index += len;
            count -= len;
        }
    }

    private void fillObjectsInLine(long indexInBase, long baseCoord0, long len, Object value) {
        if (baseCoord0 < 0L && len > 0L) {
            if ((len += baseCoord0) <= 0L) {
                return;
            }
            indexInBase -= baseCoord0;
            baseCoord0 = 0L;
        }
        if (baseCoord0 < this.baseDim0 && len > 0L) {
            long m = Math.min(this.baseDim0 - baseCoord0, len);
            this.updatableBaseObjectArray.fill(indexInBase, m, value);
        }
    }
}

