/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import net.algart.arrays.AbstractMatrix;
import net.algart.arrays.Array;
import net.algart.arrays.Arrays;
import net.algart.arrays.ArraysSubMatrixIndexer;
import net.algart.arrays.BitArray;
import net.algart.arrays.ByteArray;
import net.algart.arrays.CharArray;
import net.algart.arrays.DoubleArray;
import net.algart.arrays.FloatArray;
import net.algart.arrays.IntArray;
import net.algart.arrays.JArrayPool;
import net.algart.arrays.LongArray;
import net.algart.arrays.Matrix;
import net.algart.arrays.ObjectArray;
import net.algart.arrays.PackedBitArrays;
import net.algart.arrays.ShortArray;
import net.algart.arrays.UpdatableArray;
import net.algart.arrays.UpdatableBitArray;
import net.algart.arrays.UpdatableByteArray;
import net.algart.arrays.UpdatableCharArray;
import net.algart.arrays.UpdatableDoubleArray;
import net.algart.arrays.UpdatableFloatArray;
import net.algart.arrays.UpdatableIntArray;
import net.algart.arrays.UpdatableLongArray;
import net.algart.arrays.UpdatableObjectArray;
import net.algart.arrays.UpdatableShortArray;

class ArraysSubMatrixMirrorCyclicIndexer
implements ArraysSubMatrixIndexer {
    private static final boolean DEBUG_MODE = false;
    private static final int MC_INDEXER_BUFFER_LENGTH = 8192;
    private static final JArrayPool BOOLEAN_BUFFERS = JArrayPool.getInstance(Boolean.TYPE, 8192);
    private static final JArrayPool CHAR_BUFFERS = JArrayPool.getInstance(Character.TYPE, 8192);
    private static final JArrayPool BYTE_BUFFERS = JArrayPool.getInstance(Byte.TYPE, 8192);
    private static final JArrayPool SHORT_BUFFERS = JArrayPool.getInstance(Short.TYPE, 8192);
    private static final JArrayPool INT_BUFFERS = JArrayPool.getInstance(Integer.TYPE, 8192);
    private static final JArrayPool LONG_BUFFERS = JArrayPool.getInstance(Long.TYPE, 8192);
    private static final JArrayPool FLOAT_BUFFERS = JArrayPool.getInstance(Float.TYPE, 8192);
    private static final JArrayPool DOUBLE_BUFFERS = JArrayPool.getInstance(Double.TYPE, 8192);
    private static final JArrayPool OBJECT_BUFFERS = JArrayPool.getInstance(Object.class, 8192);
    private final Array baseArray;
    private final BitArray baseBitArray;
    private final UpdatableArray updatableBaseArray;
    private final UpdatableBitArray updatableBaseBitArray;
    private final UpdatableCharArray updatableBaseCharArray;
    private final UpdatableByteArray updatableBaseByteArray;
    private final UpdatableShortArray updatableBaseShortArray;
    private final UpdatableIntArray updatableBaseIntArray;
    private final UpdatableLongArray updatableBaseLongArray;
    private final UpdatableFloatArray updatableBaseFloatArray;
    private final UpdatableDoubleArray updatableBaseDoubleArray;
    private final UpdatableObjectArray<Object> updatableBaseObjectArray;
    private final long[] pos;
    private final long pos0;
    private final long[] dim;
    private final long dim0;
    private final long size;
    private final long[] baseDimMul;
    private final long[] baseDim;
    private final long baseDim0;
    private final long baseSize;
    private final ArrayReverser reverser;
    private final JArrayPool pool;

    ArraysSubMatrixMirrorCyclicIndexer(Matrix<? extends Array> baseMatrix, long[] pos, long[] dim) {
        int k;
        this.baseArray = baseMatrix.array();
        this.baseBitArray = this.baseArray instanceof BitArray ? (BitArray)this.baseArray : null;
        this.updatableBaseArray = this.baseArray instanceof UpdatableArray ? (UpdatableArray)this.baseArray : null;
        this.updatableBaseBitArray = this.baseArray instanceof UpdatableBitArray ? (UpdatableBitArray)this.baseArray : null;
        this.updatableBaseCharArray = this.baseArray instanceof UpdatableCharArray ? (UpdatableCharArray)this.baseArray : null;
        this.updatableBaseByteArray = this.baseArray instanceof UpdatableByteArray ? (UpdatableByteArray)this.baseArray : null;
        this.updatableBaseShortArray = this.baseArray instanceof UpdatableShortArray ? (UpdatableShortArray)this.baseArray : null;
        this.updatableBaseIntArray = this.baseArray instanceof UpdatableIntArray ? (UpdatableIntArray)this.baseArray : null;
        this.updatableBaseLongArray = this.baseArray instanceof UpdatableLongArray ? (UpdatableLongArray)this.baseArray : null;
        this.updatableBaseFloatArray = this.baseArray instanceof UpdatableFloatArray ? (UpdatableFloatArray)this.baseArray : null;
        this.updatableBaseDoubleArray = this.baseArray instanceof UpdatableDoubleArray ? (UpdatableDoubleArray)this.baseArray : null;
        UpdatableObjectArray<Object> updatableObjectArray = this.updatableBaseObjectArray = this.baseArray instanceof UpdatableObjectArray ? ((UpdatableObjectArray)this.baseArray).cast(Object.class) : null;
        assert (dim.length == baseMatrix.dimCount());
        assert (pos.length == dim.length);
        for (int k2 = 0; k2 < pos.length; ++k2) {
            assert (dim[k2] >= 0L);
            assert (pos[k2] <= Long.MAX_VALUE - dim[k2]);
        }
        int n = dim.length;
        assert (n > 0);
        this.baseDim = new long[n];
        this.pos = new long[n];
        this.dim = new long[n];
        for (k = 0; k < n; ++k) {
            this.baseDim[k] = baseMatrix.dim(k);
            this.pos[k] = pos[k];
            this.dim[k] = dim[k];
        }
        this.baseDim0 = this.baseDim[0];
        this.pos0 = this.pos[0];
        this.dim0 = this.dim[0];
        this.size = Arrays.longMul(dim);
        assert (this.size >= 0L);
        assert (this.size == Arrays.longMul(this.dim));
        this.baseDimMul = new long[n];
        for (k = 0; k < n; ++k) {
            this.baseDimMul[k] = k == 0 ? 1L : this.baseDimMul[k - 1] * this.baseDim[k - 1];
        }
        this.baseSize = this.baseArray.length();
        ArrayReverser arrayReverser = this.baseArray instanceof BitArray ? new BooleanArrayReverser() : (this.baseArray instanceof CharArray ? new CharArrayReverser() : (this.baseArray instanceof ByteArray ? new ByteArrayReverser() : (this.baseArray instanceof ShortArray ? new ShortArrayReverser() : (this.baseArray instanceof IntArray ? new IntArrayReverser() : (this.baseArray instanceof LongArray ? new LongArrayReverser() : (this.baseArray instanceof FloatArray ? new FloatArrayReverser() : (this.baseArray instanceof DoubleArray ? new DoubleArrayReverser() : (this.reverser = this.baseArray instanceof ObjectArray ? new ObjectArrayReverser() : null))))))));
        if (this.reverser == null) {
            throw new AssertionError((Object)("Illegal Array type: " + String.valueOf(this.baseArray.getClass())));
        }
        this.pool = this.baseArray instanceof BitArray ? BOOLEAN_BUFFERS : (this.baseArray instanceof CharArray ? CHAR_BUFFERS : (this.baseArray instanceof ByteArray ? BYTE_BUFFERS : (this.baseArray instanceof ShortArray ? SHORT_BUFFERS : (this.baseArray instanceof IntArray ? INT_BUFFERS : (this.baseArray instanceof LongArray ? LONG_BUFFERS : (this.baseArray instanceof FloatArray ? FLOAT_BUFFERS : (this.baseArray instanceof DoubleArray ? DOUBLE_BUFFERS : (this.baseArray instanceof ObjectArray ? OBJECT_BUFFERS : null))))))));
    }

    @Override
    public boolean bitsBlocksImplemented() {
        return true;
    }

    @Override
    public boolean indexOfImplemented() {
        return false;
    }

    @Override
    public long translate(long index) {
        int k;
        assert (index >= 0L && index < this.size);
        if (this.dim.length == 1) {
            long coord = this.pos0 + index;
            assert (this.pos0 < 0L || coord >= 0L);
            coord = AbstractMatrix.normalizeMirrorCoord(coord, this.baseDim0);
            return coord;
        }
        long a = index;
        long b = a / this.dim0;
        long subCoord0 = a - b * this.dim0;
        long baseCoord0 = this.pos0 + subCoord0;
        assert (this.pos0 < 0L || baseCoord0 >= 0L);
        baseCoord0 = AbstractMatrix.normalizeMirrorCoord(baseCoord0, this.baseDim0);
        a = b;
        long indexInBase = baseCoord0;
        for (k = 1; k < this.dim.length - 1; ++k) {
            b = a / this.dim[k];
            long subCoordK = a - b * this.dim[k];
            long baseCoordK = this.pos[k] + subCoordK;
            assert (this.pos[k] < 0L || baseCoordK >= 0L);
            baseCoordK = AbstractMatrix.normalizeMirrorCoord(baseCoordK, this.baseDim[k]);
            a = b;
            indexInBase += baseCoordK * this.baseDimMul[k];
        }
        assert (k == this.dim.length - 1);
        long baseCoordLast = this.pos[k] + a;
        assert (this.pos[k] < 0L || baseCoordLast >= 0L);
        baseCoordLast = AbstractMatrix.normalizeMirrorCoord(baseCoordLast, this.baseDim[k]);
        return indexInBase += baseCoordLast * this.baseDimMul[k];
    }

    @Override
    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
        assert (arrayPos >= 0L && arrayPos <= this.size - (long)count);
        assert (count >= 0);
        if (this.dim.length == 1) {
            if (count == 0) {
                return;
            }
            long coord = this.pos0 + arrayPos;
            assert (this.pos0 < 0L || coord >= 0L);
            coord = ArraysSubMatrixMirrorCyclicIndexer.partiallyNormalizeMirrorCoord(coord, this.baseDim0);
            this.getDataInLine(0L, coord, destArray, destArrayOffset, count);
            return;
        }
        long bLast = -157L;
        long index = arrayPos;
        while (count > 0) {
            int k;
            long subCoord0;
            long b;
            long a = index;
            if (index == arrayPos) {
                b = a / this.dim0;
                subCoord0 = a - b * this.dim0;
            } else {
                b = bLast + 1L;
                subCoord0 = 0L;
            }
            bLast = b;
            int len = (int)Math.min(this.dim0 - subCoord0, (long)count);
            assert (len > 0) : "zero len = " + len;
            long baseCoord0 = this.pos0 + subCoord0;
            assert (this.pos0 < 0L || baseCoord0 >= 0L);
            baseCoord0 = ArraysSubMatrixMirrorCyclicIndexer.partiallyNormalizeMirrorCoord(baseCoord0, this.baseDim0);
            a = b;
            long indexOfLineStartInBase = 0L;
            for (k = 1; k < this.dim.length - 1; ++k) {
                b = a / this.dim[k];
                long subCoordK = a - b * this.dim[k];
                long baseCoordK = this.pos[k] + subCoordK;
                assert (this.pos[k] < 0L || baseCoordK >= 0L);
                baseCoordK = AbstractMatrix.normalizeMirrorCoord(baseCoordK, this.baseDim[k]);
                a = b;
                indexOfLineStartInBase += baseCoordK * this.baseDimMul[k];
            }
            assert (k == this.dim.length - 1);
            long baseCoordLast = this.pos[k] + a;
            assert (this.pos[k] < 0L || baseCoordLast >= 0L);
            baseCoordLast = AbstractMatrix.normalizeMirrorCoord(baseCoordLast, this.baseDim[k]);
            this.getDataInLine(indexOfLineStartInBase += baseCoordLast * this.baseDimMul[k], baseCoord0, destArray, destArrayOffset, len);
            index += (long)len;
            destArrayOffset += len;
            count -= len;
        }
    }

    private void getDataInLine(long indexOfLineStartInBase, long baseCoord0, Object destArray, int destArrayOffset, int len) {
        boolean inMirror = baseCoord0 < 0L;
        assert ((baseCoord0 &= Long.MAX_VALUE) < this.baseDim0);
        while (len > 0) {
            int m = (int)Math.min(this.baseDim0 - baseCoord0, (long)len);
            if (inMirror) {
                baseCoord0 = this.baseDim0 - baseCoord0 - (long)m;
            }
            this.baseArray.getData(indexOfLineStartInBase + baseCoord0, destArray, destArrayOffset, m);
            if (inMirror) {
                this.reverser.reverse(destArray, destArrayOffset, m);
            }
            baseCoord0 = 0L;
            inMirror = !inMirror;
            destArrayOffset += m;
            len -= m;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
        assert (arrayPos >= 0L && arrayPos <= this.size - (long)count);
        assert (count >= 0);
        if (count == 0) {
            return;
        }
        Object dataBuffer = this.pool.requestArray();
        try {
            if (this.dim.length == 1) {
                long coord = this.pos0 + arrayPos;
                assert (this.pos0 < 0L || coord >= 0L);
                coord = ArraysSubMatrixMirrorCyclicIndexer.partiallyNormalizeMirrorCoord(coord, this.baseDim0);
                this.setDataInLine(0L, coord, srcArray, srcArrayOffset, count, dataBuffer);
                return;
            }
            long bLast = -157L;
            long index = arrayPos;
            while (count > 0) {
                int k;
                long subCoord0;
                long b;
                long a = index;
                if (index == arrayPos) {
                    b = a / this.dim0;
                    subCoord0 = a - b * this.dim0;
                } else {
                    b = bLast + 1L;
                    subCoord0 = 0L;
                }
                bLast = b;
                int len = (int)Math.min(this.dim0 - subCoord0, (long)count);
                assert (len > 0) : "zero len = " + len;
                long baseCoord0 = this.pos0 + subCoord0;
                assert (this.pos0 < 0L || baseCoord0 >= 0L);
                baseCoord0 = ArraysSubMatrixMirrorCyclicIndexer.partiallyNormalizeMirrorCoord(baseCoord0, this.baseDim0);
                a = b;
                long indexOfLineStartInBase = 0L;
                for (k = 1; k < this.dim.length - 1; ++k) {
                    b = a / this.dim[k];
                    long subCoordK = a - b * this.dim[k];
                    long baseCoordK = this.pos[k] + subCoordK;
                    assert (this.pos[k] < 0L || baseCoordK >= 0L);
                    baseCoordK = AbstractMatrix.normalizeMirrorCoord(baseCoordK, this.baseDim[k]);
                    a = b;
                    indexOfLineStartInBase += baseCoordK * this.baseDimMul[k];
                }
                assert (k == this.dim.length - 1);
                long baseCoordLast = this.pos[k] + a;
                assert (this.pos[k] < 0L || baseCoordLast >= 0L);
                baseCoordLast = AbstractMatrix.normalizeMirrorCoord(baseCoordLast, this.baseDim[k]);
                this.setDataInLine(indexOfLineStartInBase += baseCoordLast * this.baseDimMul[k], baseCoord0, srcArray, srcArrayOffset, len, dataBuffer);
                index += (long)len;
                srcArrayOffset += len;
                count -= len;
            }
        }
        finally {
            this.pool.releaseArray(dataBuffer);
        }
    }

    private void setDataInLine(long indexOfLineStartInBase, long baseCoord0, Object srcArray, int srcArrayOffset, int len, Object dataBuffer) {
        boolean inMirror = baseCoord0 < 0L;
        assert ((baseCoord0 &= Long.MAX_VALUE) < this.baseDim0);
        while (len > 0) {
            int m = (int)Math.min(this.baseDim0 - baseCoord0, (long)len);
            if (m > 8192) {
                m = 8192;
            }
            if (inMirror) {
                this.reverser.reverse(dataBuffer, srcArray, srcArrayOffset, m);
                this.updatableBaseArray.setData(indexOfLineStartInBase + this.baseDim0 - baseCoord0 - (long)m, dataBuffer, 0, m);
            } else {
                this.updatableBaseArray.setData(indexOfLineStartInBase + baseCoord0, srcArray, srcArrayOffset, m);
            }
            if ((baseCoord0 += (long)m) == this.baseDim0) {
                baseCoord0 = 0L;
                inMirror = !inMirror;
            }
            srcArrayOffset += m;
            len -= m;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getBits(long arrayPos, long[] destArray, long destArrayOffset, long count) {
        assert (arrayPos >= 0L && arrayPos <= this.size - count);
        assert (count >= 0L);
        if (count == 0L) {
            return;
        }
        long[] dataBuffer = (long[])LONG_BUFFERS.requestArray();
        try {
            if (this.dim.length == 1) {
                long coord = this.pos0 + arrayPos;
                assert (this.pos0 < 0L || coord >= 0L);
                coord = ArraysSubMatrixMirrorCyclicIndexer.partiallyNormalizeMirrorCoord(coord, this.baseDim0);
                this.getBitsInLine(0L, coord, destArray, destArrayOffset, count, dataBuffer);
                return;
            }
            long bLast = -157L;
            long index = arrayPos;
            while (count > 0L) {
                int k;
                long subCoord0;
                long b;
                long a = index;
                if (index == arrayPos) {
                    b = a / this.dim0;
                    subCoord0 = a - b * this.dim0;
                } else {
                    b = bLast + 1L;
                    subCoord0 = 0L;
                }
                bLast = b;
                long len = Math.min(this.dim0 - subCoord0, count);
                assert (len > 0L) : "zero len = " + len;
                long baseCoord0 = this.pos0 + subCoord0;
                assert (this.pos0 < 0L || baseCoord0 >= 0L);
                baseCoord0 = ArraysSubMatrixMirrorCyclicIndexer.partiallyNormalizeMirrorCoord(baseCoord0, this.baseDim0);
                a = b;
                long indexOfLineStartInBase = 0L;
                for (k = 1; k < this.dim.length - 1; ++k) {
                    b = a / this.dim[k];
                    long subCoordK = a - b * this.dim[k];
                    long baseCoordK = this.pos[k] + subCoordK;
                    assert (this.pos[k] < 0L || baseCoordK >= 0L);
                    baseCoordK = AbstractMatrix.normalizeMirrorCoord(baseCoordK, this.baseDim[k]);
                    a = b;
                    indexOfLineStartInBase += baseCoordK * this.baseDimMul[k];
                }
                assert (k == this.dim.length - 1);
                long baseCoordLast = this.pos[k] + a;
                assert (this.pos[k] < 0L || baseCoordLast >= 0L);
                baseCoordLast = AbstractMatrix.normalizeMirrorCoord(baseCoordLast, this.baseDim[k]);
                this.getBitsInLine(indexOfLineStartInBase += baseCoordLast * this.baseDimMul[k], baseCoord0, destArray, destArrayOffset, len, dataBuffer);
                index += len;
                destArrayOffset += len;
                count -= len;
            }
        }
        finally {
            LONG_BUFFERS.releaseArray(dataBuffer);
        }
    }

    private void getBitsInLine(long indexOfLineStartInBase, long baseCoord0, long[] destArray, long destArrayOffset, long len, long[] dataBuffer) {
        boolean inMirror = baseCoord0 < 0L;
        assert ((baseCoord0 &= Long.MAX_VALUE) < this.baseDim0);
        assert (dataBuffer.length == 8192);
        while (len > 0L) {
            long m = Math.min(this.baseDim0 - baseCoord0, len);
            if (m > 524288L) {
                m = 524288L;
            }
            if (inMirror) {
                this.baseBitArray.getBits(indexOfLineStartInBase + this.baseDim0 - baseCoord0 - m, dataBuffer, 0L, m);
                PackedBitArrays.reverseBits(destArray, destArrayOffset, dataBuffer, 0L, m);
            } else {
                this.baseBitArray.getBits(indexOfLineStartInBase + baseCoord0, destArray, destArrayOffset, m);
            }
            if ((baseCoord0 += m) == this.baseDim0) {
                baseCoord0 = 0L;
                inMirror = !inMirror;
            }
            destArrayOffset += m;
            len -= m;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBits(long arrayPos, long[] srcArray, long srcArrayOffset, long count) {
        assert (arrayPos >= 0L && arrayPos <= this.size - count);
        assert (count >= 0L);
        if (count == 0L) {
            return;
        }
        long[] dataBuffer = (long[])LONG_BUFFERS.requestArray();
        try {
            if (this.dim.length == 1) {
                long coord = this.pos0 + arrayPos;
                assert (this.pos0 < 0L || coord >= 0L);
                coord = ArraysSubMatrixMirrorCyclicIndexer.partiallyNormalizeMirrorCoord(coord, this.baseDim0);
                this.setBitsInLine(0L, coord, srcArray, srcArrayOffset, count, dataBuffer);
                return;
            }
            long bLast = -157L;
            long index = arrayPos;
            while (count > 0L) {
                int k;
                long subCoord0;
                long b;
                long a = index;
                if (index == arrayPos) {
                    b = a / this.dim0;
                    subCoord0 = a - b * this.dim0;
                } else {
                    b = bLast + 1L;
                    subCoord0 = 0L;
                }
                bLast = b;
                long len = Math.min(this.dim0 - subCoord0, count);
                assert (len > 0L) : "zero len = " + len;
                long baseCoord0 = this.pos0 + subCoord0;
                assert (this.pos0 < 0L || baseCoord0 >= 0L);
                baseCoord0 = ArraysSubMatrixMirrorCyclicIndexer.partiallyNormalizeMirrorCoord(baseCoord0, this.baseDim0);
                a = b;
                long indexOfLineStartInBase = 0L;
                for (k = 1; k < this.dim.length - 1; ++k) {
                    b = a / this.dim[k];
                    long subCoordK = a - b * this.dim[k];
                    long baseCoordK = this.pos[k] + subCoordK;
                    assert (this.pos[k] < 0L || baseCoordK >= 0L);
                    baseCoordK = AbstractMatrix.normalizeMirrorCoord(baseCoordK, this.baseDim[k]);
                    a = b;
                    indexOfLineStartInBase += baseCoordK * this.baseDimMul[k];
                }
                assert (k == this.dim.length - 1);
                long baseCoordLast = this.pos[k] + a;
                assert (this.pos[k] < 0L || baseCoordLast >= 0L);
                baseCoordLast = AbstractMatrix.normalizeMirrorCoord(baseCoordLast, this.baseDim[k]);
                this.setBitsInLine(indexOfLineStartInBase += baseCoordLast * this.baseDimMul[k], baseCoord0, srcArray, srcArrayOffset, len, dataBuffer);
                index += len;
                srcArrayOffset += len;
                count -= len;
            }
        }
        finally {
            LONG_BUFFERS.releaseArray(dataBuffer);
        }
    }

    private void setBitsInLine(long indexOfLineStartInBase, long baseCoord0, long[] srcArray, long srcArrayOffset, long len, long[] dataBuffer) {
        boolean inMirror = baseCoord0 < 0L;
        assert ((baseCoord0 &= Long.MAX_VALUE) < this.baseDim0);
        assert (dataBuffer.length == 8192);
        while (len > 0L) {
            long m = Math.min(this.baseDim0 - baseCoord0, len);
            if (m > 524288L) {
                m = 524288L;
            }
            if (inMirror) {
                PackedBitArrays.reverseBits(dataBuffer, 0L, srcArray, srcArrayOffset, m);
                this.updatableBaseBitArray.setBits(indexOfLineStartInBase + this.baseDim0 - baseCoord0 - m, dataBuffer, 0L, m);
            } else {
                this.updatableBaseBitArray.setBits(indexOfLineStartInBase + baseCoord0, srcArray, srcArrayOffset, m);
            }
            if ((baseCoord0 += m) == this.baseDim0) {
                baseCoord0 = 0L;
                inMirror = !inMirror;
            }
            srcArrayOffset += m;
            len -= m;
        }
    }

    @Override
    public long indexOfBit(long lowIndex, long highIndex, boolean value) {
        throw new AssertionError((Object)"indexOfBit method should not be called for mirror cyclic continuation");
    }

    @Override
    public long lastIndexOfBit(long lowIndex, long highIndex, boolean value) {
        throw new AssertionError((Object)"lastIndexOfBit method should not be called for mirror cyclic continuation");
    }

    @Override
    public void fillBits(long position, long count, boolean value) {
        assert (position >= 0L && position <= this.size - count);
        assert (count >= 0L);
        if (this.dim.length == 1) {
            if (count == 0L) {
                return;
            }
            long coord = this.pos0 + position;
            assert (this.pos0 < 0L || coord >= 0L);
            coord = ArraysSubMatrixMirrorCyclicIndexer.partiallyNormalizeMirrorCoord(coord, this.baseDim0);
            this.fillBitsInLine(0L, coord, count, value);
            return;
        }
        long bLast = -157L;
        long index = position;
        while (count > 0L) {
            int k;
            long subCoord0;
            long b;
            long a = index;
            if (index == position) {
                b = a / this.dim0;
                subCoord0 = a - b * this.dim0;
            } else {
                b = bLast + 1L;
                subCoord0 = 0L;
            }
            bLast = b;
            long len = Math.min(this.dim0 - subCoord0, count);
            assert (len > 0L) : "zero len = " + len;
            long baseCoord0 = this.pos0 + subCoord0;
            assert (this.pos0 < 0L || baseCoord0 >= 0L);
            baseCoord0 = ArraysSubMatrixMirrorCyclicIndexer.partiallyNormalizeMirrorCoord(baseCoord0, this.baseDim0);
            a = b;
            long indexOfLineStartInBase = 0L;
            for (k = 1; k < this.dim.length - 1; ++k) {
                b = a / this.dim[k];
                long subCoordK = a - b * this.dim[k];
                long baseCoordK = this.pos[k] + subCoordK;
                assert (this.pos[k] < 0L || baseCoordK >= 0L);
                baseCoordK = AbstractMatrix.normalizeMirrorCoord(baseCoordK, this.baseDim[k]);
                a = b;
                indexOfLineStartInBase += baseCoordK * this.baseDimMul[k];
            }
            assert (k == this.dim.length - 1);
            long baseCoordLast = this.pos[k] + a;
            assert (this.pos[k] < 0L || baseCoordLast >= 0L);
            baseCoordLast = AbstractMatrix.normalizeMirrorCoord(baseCoordLast, this.baseDim[k]);
            this.fillBitsInLine(indexOfLineStartInBase += baseCoordLast * this.baseDimMul[k], baseCoord0, len, value);
            index += len;
            count -= len;
        }
    }

    private void fillBitsInLine(long indexOfLineStartInBase, long baseCoord0, long len, boolean value) {
        boolean inMirror = baseCoord0 < 0L;
        assert ((baseCoord0 &= Long.MAX_VALUE) < this.baseDim0);
        long m = Math.min(this.baseDim0 - baseCoord0, len);
        long position = indexOfLineStartInBase + (inMirror ? this.baseDim0 - baseCoord0 - m : baseCoord0);
        this.updatableBaseBitArray.fill(position, m, value);
        if ((len -= m) == 0L) {
            return;
        }
        inMirror = !inMirror;
        m = Math.min(this.baseDim0, len);
        position = inMirror ? indexOfLineStartInBase + this.baseDim0 - m : indexOfLineStartInBase;
        this.updatableBaseBitArray.fill(position, m, value);
    }

    @Override
    public long indexOfChar(long lowIndex, long highIndex, char value) {
        throw new AssertionError((Object)"indexOfChar method should not be called for mirror cyclic continuation");
    }

    @Override
    public long lastIndexOfChar(long lowIndex, long highIndex, char value) {
        throw new AssertionError((Object)"lastIndexOfChar method should not be called for mirror cyclic continuation");
    }

    @Override
    public void fillChars(long position, long count, char value) {
        assert (position >= 0L && position <= this.size - count);
        assert (count >= 0L);
        if (this.dim.length == 1) {
            if (count == 0L) {
                return;
            }
            long coord = this.pos0 + position;
            assert (this.pos0 < 0L || coord >= 0L);
            coord = ArraysSubMatrixMirrorCyclicIndexer.partiallyNormalizeMirrorCoord(coord, this.baseDim0);
            this.fillCharsInLine(0L, coord, count, value);
            return;
        }
        long bLast = -157L;
        long index = position;
        while (count > 0L) {
            int k;
            long subCoord0;
            long b;
            long a = index;
            if (index == position) {
                b = a / this.dim0;
                subCoord0 = a - b * this.dim0;
            } else {
                b = bLast + 1L;
                subCoord0 = 0L;
            }
            bLast = b;
            long len = Math.min(this.dim0 - subCoord0, count);
            assert (len > 0L) : "zero len = " + len;
            long baseCoord0 = this.pos0 + subCoord0;
            assert (this.pos0 < 0L || baseCoord0 >= 0L);
            baseCoord0 = ArraysSubMatrixMirrorCyclicIndexer.partiallyNormalizeMirrorCoord(baseCoord0, this.baseDim0);
            a = b;
            long indexOfLineStartInBase = 0L;
            for (k = 1; k < this.dim.length - 1; ++k) {
                b = a / this.dim[k];
                long subCoordK = a - b * this.dim[k];
                long baseCoordK = this.pos[k] + subCoordK;
                assert (this.pos[k] < 0L || baseCoordK >= 0L);
                baseCoordK = AbstractMatrix.normalizeMirrorCoord(baseCoordK, this.baseDim[k]);
                a = b;
                indexOfLineStartInBase += baseCoordK * this.baseDimMul[k];
            }
            assert (k == this.dim.length - 1);
            long baseCoordLast = this.pos[k] + a;
            assert (this.pos[k] < 0L || baseCoordLast >= 0L);
            baseCoordLast = AbstractMatrix.normalizeMirrorCoord(baseCoordLast, this.baseDim[k]);
            this.fillCharsInLine(indexOfLineStartInBase += baseCoordLast * this.baseDimMul[k], baseCoord0, len, value);
            index += len;
            count -= len;
        }
    }

    private void fillCharsInLine(long indexOfLineStartInBase, long baseCoord0, long len, char value) {
        boolean inMirror = baseCoord0 < 0L;
        assert ((baseCoord0 &= Long.MAX_VALUE) < this.baseDim0);
        long m = Math.min(this.baseDim0 - baseCoord0, len);
        long position = indexOfLineStartInBase + (inMirror ? this.baseDim0 - baseCoord0 - m : baseCoord0);
        this.updatableBaseCharArray.fill(position, m, value);
        if ((len -= m) == 0L) {
            return;
        }
        inMirror = !inMirror;
        m = Math.min(this.baseDim0, len);
        position = inMirror ? indexOfLineStartInBase + this.baseDim0 - m : indexOfLineStartInBase;
        this.updatableBaseCharArray.fill(position, m, value);
    }

    @Override
    public long indexOfByte(long lowIndex, long highIndex, byte value) {
        throw new AssertionError((Object)"indexOfByte method should not be called for mirror cyclic continuation");
    }

    @Override
    public long lastIndexOfByte(long lowIndex, long highIndex, byte value) {
        throw new AssertionError((Object)"lastIndexOfByte method should not be called for mirror cyclic continuation");
    }

    @Override
    public void fillBytes(long position, long count, byte value) {
        assert (position >= 0L && position <= this.size - count);
        assert (count >= 0L);
        if (this.dim.length == 1) {
            if (count == 0L) {
                return;
            }
            long coord = this.pos0 + position;
            assert (this.pos0 < 0L || coord >= 0L);
            coord = ArraysSubMatrixMirrorCyclicIndexer.partiallyNormalizeMirrorCoord(coord, this.baseDim0);
            this.fillBytesInLine(0L, coord, count, value);
            return;
        }
        long bLast = -157L;
        long index = position;
        while (count > 0L) {
            int k;
            long subCoord0;
            long b;
            long a = index;
            if (index == position) {
                b = a / this.dim0;
                subCoord0 = a - b * this.dim0;
            } else {
                b = bLast + 1L;
                subCoord0 = 0L;
            }
            bLast = b;
            long len = Math.min(this.dim0 - subCoord0, count);
            assert (len > 0L) : "zero len = " + len;
            long baseCoord0 = this.pos0 + subCoord0;
            assert (this.pos0 < 0L || baseCoord0 >= 0L);
            baseCoord0 = ArraysSubMatrixMirrorCyclicIndexer.partiallyNormalizeMirrorCoord(baseCoord0, this.baseDim0);
            a = b;
            long indexOfLineStartInBase = 0L;
            for (k = 1; k < this.dim.length - 1; ++k) {
                b = a / this.dim[k];
                long subCoordK = a - b * this.dim[k];
                long baseCoordK = this.pos[k] + subCoordK;
                assert (this.pos[k] < 0L || baseCoordK >= 0L);
                baseCoordK = AbstractMatrix.normalizeMirrorCoord(baseCoordK, this.baseDim[k]);
                a = b;
                indexOfLineStartInBase += baseCoordK * this.baseDimMul[k];
            }
            assert (k == this.dim.length - 1);
            long baseCoordLast = this.pos[k] + a;
            assert (this.pos[k] < 0L || baseCoordLast >= 0L);
            baseCoordLast = AbstractMatrix.normalizeMirrorCoord(baseCoordLast, this.baseDim[k]);
            this.fillBytesInLine(indexOfLineStartInBase += baseCoordLast * this.baseDimMul[k], baseCoord0, len, value);
            index += len;
            count -= len;
        }
    }

    private void fillBytesInLine(long indexOfLineStartInBase, long baseCoord0, long len, byte value) {
        boolean inMirror = baseCoord0 < 0L;
        assert ((baseCoord0 &= Long.MAX_VALUE) < this.baseDim0);
        long m = Math.min(this.baseDim0 - baseCoord0, len);
        long position = indexOfLineStartInBase + (inMirror ? this.baseDim0 - baseCoord0 - m : baseCoord0);
        this.updatableBaseByteArray.fill(position, m, value);
        if ((len -= m) == 0L) {
            return;
        }
        inMirror = !inMirror;
        m = Math.min(this.baseDim0, len);
        position = inMirror ? indexOfLineStartInBase + this.baseDim0 - m : indexOfLineStartInBase;
        this.updatableBaseByteArray.fill(position, m, value);
    }

    @Override
    public long indexOfShort(long lowIndex, long highIndex, short value) {
        throw new AssertionError((Object)"indexOfShort method should not be called for mirror cyclic continuation");
    }

    @Override
    public long lastIndexOfShort(long lowIndex, long highIndex, short value) {
        throw new AssertionError((Object)"lastIndexOfShort method should not be called for mirror cyclic continuation");
    }

    @Override
    public void fillShorts(long position, long count, short value) {
        assert (position >= 0L && position <= this.size - count);
        assert (count >= 0L);
        if (this.dim.length == 1) {
            if (count == 0L) {
                return;
            }
            long coord = this.pos0 + position;
            assert (this.pos0 < 0L || coord >= 0L);
            coord = ArraysSubMatrixMirrorCyclicIndexer.partiallyNormalizeMirrorCoord(coord, this.baseDim0);
            this.fillShortsInLine(0L, coord, count, value);
            return;
        }
        long bLast = -157L;
        long index = position;
        while (count > 0L) {
            int k;
            long subCoord0;
            long b;
            long a = index;
            if (index == position) {
                b = a / this.dim0;
                subCoord0 = a - b * this.dim0;
            } else {
                b = bLast + 1L;
                subCoord0 = 0L;
            }
            bLast = b;
            long len = Math.min(this.dim0 - subCoord0, count);
            assert (len > 0L) : "zero len = " + len;
            long baseCoord0 = this.pos0 + subCoord0;
            assert (this.pos0 < 0L || baseCoord0 >= 0L);
            baseCoord0 = ArraysSubMatrixMirrorCyclicIndexer.partiallyNormalizeMirrorCoord(baseCoord0, this.baseDim0);
            a = b;
            long indexOfLineStartInBase = 0L;
            for (k = 1; k < this.dim.length - 1; ++k) {
                b = a / this.dim[k];
                long subCoordK = a - b * this.dim[k];
                long baseCoordK = this.pos[k] + subCoordK;
                assert (this.pos[k] < 0L || baseCoordK >= 0L);
                baseCoordK = AbstractMatrix.normalizeMirrorCoord(baseCoordK, this.baseDim[k]);
                a = b;
                indexOfLineStartInBase += baseCoordK * this.baseDimMul[k];
            }
            assert (k == this.dim.length - 1);
            long baseCoordLast = this.pos[k] + a;
            assert (this.pos[k] < 0L || baseCoordLast >= 0L);
            baseCoordLast = AbstractMatrix.normalizeMirrorCoord(baseCoordLast, this.baseDim[k]);
            this.fillShortsInLine(indexOfLineStartInBase += baseCoordLast * this.baseDimMul[k], baseCoord0, len, value);
            index += len;
            count -= len;
        }
    }

    private void fillShortsInLine(long indexOfLineStartInBase, long baseCoord0, long len, short value) {
        boolean inMirror = baseCoord0 < 0L;
        assert ((baseCoord0 &= Long.MAX_VALUE) < this.baseDim0);
        long m = Math.min(this.baseDim0 - baseCoord0, len);
        long position = indexOfLineStartInBase + (inMirror ? this.baseDim0 - baseCoord0 - m : baseCoord0);
        this.updatableBaseShortArray.fill(position, m, value);
        if ((len -= m) == 0L) {
            return;
        }
        inMirror = !inMirror;
        m = Math.min(this.baseDim0, len);
        position = inMirror ? indexOfLineStartInBase + this.baseDim0 - m : indexOfLineStartInBase;
        this.updatableBaseShortArray.fill(position, m, value);
    }

    @Override
    public long indexOfInt(long lowIndex, long highIndex, int value) {
        throw new AssertionError((Object)"indexOfInt method should not be called for mirror cyclic continuation");
    }

    @Override
    public long lastIndexOfInt(long lowIndex, long highIndex, int value) {
        throw new AssertionError((Object)"lastIndexOfInt method should not be called for mirror cyclic continuation");
    }

    @Override
    public void fillInts(long position, long count, int value) {
        assert (position >= 0L && position <= this.size - count);
        assert (count >= 0L);
        if (this.dim.length == 1) {
            if (count == 0L) {
                return;
            }
            long coord = this.pos0 + position;
            assert (this.pos0 < 0L || coord >= 0L);
            coord = ArraysSubMatrixMirrorCyclicIndexer.partiallyNormalizeMirrorCoord(coord, this.baseDim0);
            this.fillIntsInLine(0L, coord, count, value);
            return;
        }
        long bLast = -157L;
        long index = position;
        while (count > 0L) {
            int k;
            long subCoord0;
            long b;
            long a = index;
            if (index == position) {
                b = a / this.dim0;
                subCoord0 = a - b * this.dim0;
            } else {
                b = bLast + 1L;
                subCoord0 = 0L;
            }
            bLast = b;
            long len = Math.min(this.dim0 - subCoord0, count);
            assert (len > 0L) : "zero len = " + len;
            long baseCoord0 = this.pos0 + subCoord0;
            assert (this.pos0 < 0L || baseCoord0 >= 0L);
            baseCoord0 = ArraysSubMatrixMirrorCyclicIndexer.partiallyNormalizeMirrorCoord(baseCoord0, this.baseDim0);
            a = b;
            long indexOfLineStartInBase = 0L;
            for (k = 1; k < this.dim.length - 1; ++k) {
                b = a / this.dim[k];
                long subCoordK = a - b * this.dim[k];
                long baseCoordK = this.pos[k] + subCoordK;
                assert (this.pos[k] < 0L || baseCoordK >= 0L);
                baseCoordK = AbstractMatrix.normalizeMirrorCoord(baseCoordK, this.baseDim[k]);
                a = b;
                indexOfLineStartInBase += baseCoordK * this.baseDimMul[k];
            }
            assert (k == this.dim.length - 1);
            long baseCoordLast = this.pos[k] + a;
            assert (this.pos[k] < 0L || baseCoordLast >= 0L);
            baseCoordLast = AbstractMatrix.normalizeMirrorCoord(baseCoordLast, this.baseDim[k]);
            this.fillIntsInLine(indexOfLineStartInBase += baseCoordLast * this.baseDimMul[k], baseCoord0, len, value);
            index += len;
            count -= len;
        }
    }

    private void fillIntsInLine(long indexOfLineStartInBase, long baseCoord0, long len, int value) {
        boolean inMirror = baseCoord0 < 0L;
        assert ((baseCoord0 &= Long.MAX_VALUE) < this.baseDim0);
        long m = Math.min(this.baseDim0 - baseCoord0, len);
        long position = indexOfLineStartInBase + (inMirror ? this.baseDim0 - baseCoord0 - m : baseCoord0);
        this.updatableBaseIntArray.fill(position, m, value);
        if ((len -= m) == 0L) {
            return;
        }
        inMirror = !inMirror;
        m = Math.min(this.baseDim0, len);
        position = inMirror ? indexOfLineStartInBase + this.baseDim0 - m : indexOfLineStartInBase;
        this.updatableBaseIntArray.fill(position, m, value);
    }

    @Override
    public long indexOfLong(long lowIndex, long highIndex, long value) {
        throw new AssertionError((Object)"indexOfLong method should not be called for mirror cyclic continuation");
    }

    @Override
    public long lastIndexOfLong(long lowIndex, long highIndex, long value) {
        throw new AssertionError((Object)"lastIndexOfLong method should not be called for mirror cyclic continuation");
    }

    @Override
    public void fillLongs(long position, long count, long value) {
        assert (position >= 0L && position <= this.size - count);
        assert (count >= 0L);
        if (this.dim.length == 1) {
            if (count == 0L) {
                return;
            }
            long coord = this.pos0 + position;
            assert (this.pos0 < 0L || coord >= 0L);
            coord = ArraysSubMatrixMirrorCyclicIndexer.partiallyNormalizeMirrorCoord(coord, this.baseDim0);
            this.fillLongsInLine(0L, coord, count, value);
            return;
        }
        long bLast = -157L;
        long index = position;
        while (count > 0L) {
            int k;
            long subCoord0;
            long b;
            long a = index;
            if (index == position) {
                b = a / this.dim0;
                subCoord0 = a - b * this.dim0;
            } else {
                b = bLast + 1L;
                subCoord0 = 0L;
            }
            bLast = b;
            long len = Math.min(this.dim0 - subCoord0, count);
            assert (len > 0L) : "zero len = " + len;
            long baseCoord0 = this.pos0 + subCoord0;
            assert (this.pos0 < 0L || baseCoord0 >= 0L);
            baseCoord0 = ArraysSubMatrixMirrorCyclicIndexer.partiallyNormalizeMirrorCoord(baseCoord0, this.baseDim0);
            a = b;
            long indexOfLineStartInBase = 0L;
            for (k = 1; k < this.dim.length - 1; ++k) {
                b = a / this.dim[k];
                long subCoordK = a - b * this.dim[k];
                long baseCoordK = this.pos[k] + subCoordK;
                assert (this.pos[k] < 0L || baseCoordK >= 0L);
                baseCoordK = AbstractMatrix.normalizeMirrorCoord(baseCoordK, this.baseDim[k]);
                a = b;
                indexOfLineStartInBase += baseCoordK * this.baseDimMul[k];
            }
            assert (k == this.dim.length - 1);
            long baseCoordLast = this.pos[k] + a;
            assert (this.pos[k] < 0L || baseCoordLast >= 0L);
            baseCoordLast = AbstractMatrix.normalizeMirrorCoord(baseCoordLast, this.baseDim[k]);
            this.fillLongsInLine(indexOfLineStartInBase += baseCoordLast * this.baseDimMul[k], baseCoord0, len, value);
            index += len;
            count -= len;
        }
    }

    private void fillLongsInLine(long indexOfLineStartInBase, long baseCoord0, long len, long value) {
        boolean inMirror = baseCoord0 < 0L;
        assert ((baseCoord0 &= Long.MAX_VALUE) < this.baseDim0);
        long m = Math.min(this.baseDim0 - baseCoord0, len);
        long position = indexOfLineStartInBase + (inMirror ? this.baseDim0 - baseCoord0 - m : baseCoord0);
        this.updatableBaseLongArray.fill(position, m, value);
        if ((len -= m) == 0L) {
            return;
        }
        inMirror = !inMirror;
        m = Math.min(this.baseDim0, len);
        position = inMirror ? indexOfLineStartInBase + this.baseDim0 - m : indexOfLineStartInBase;
        this.updatableBaseLongArray.fill(position, m, value);
    }

    @Override
    public long indexOfFloat(long lowIndex, long highIndex, float value) {
        throw new AssertionError((Object)"indexOfFloat method should not be called for mirror cyclic continuation");
    }

    @Override
    public long lastIndexOfFloat(long lowIndex, long highIndex, float value) {
        throw new AssertionError((Object)"lastIndexOfFloat method should not be called for mirror cyclic continuation");
    }

    @Override
    public void fillFloats(long position, long count, float value) {
        assert (position >= 0L && position <= this.size - count);
        assert (count >= 0L);
        if (this.dim.length == 1) {
            if (count == 0L) {
                return;
            }
            long coord = this.pos0 + position;
            assert (this.pos0 < 0L || coord >= 0L);
            coord = ArraysSubMatrixMirrorCyclicIndexer.partiallyNormalizeMirrorCoord(coord, this.baseDim0);
            this.fillFloatsInLine(0L, coord, count, value);
            return;
        }
        long bLast = -157L;
        long index = position;
        while (count > 0L) {
            int k;
            long subCoord0;
            long b;
            long a = index;
            if (index == position) {
                b = a / this.dim0;
                subCoord0 = a - b * this.dim0;
            } else {
                b = bLast + 1L;
                subCoord0 = 0L;
            }
            bLast = b;
            long len = Math.min(this.dim0 - subCoord0, count);
            assert (len > 0L) : "zero len = " + len;
            long baseCoord0 = this.pos0 + subCoord0;
            assert (this.pos0 < 0L || baseCoord0 >= 0L);
            baseCoord0 = ArraysSubMatrixMirrorCyclicIndexer.partiallyNormalizeMirrorCoord(baseCoord0, this.baseDim0);
            a = b;
            long indexOfLineStartInBase = 0L;
            for (k = 1; k < this.dim.length - 1; ++k) {
                b = a / this.dim[k];
                long subCoordK = a - b * this.dim[k];
                long baseCoordK = this.pos[k] + subCoordK;
                assert (this.pos[k] < 0L || baseCoordK >= 0L);
                baseCoordK = AbstractMatrix.normalizeMirrorCoord(baseCoordK, this.baseDim[k]);
                a = b;
                indexOfLineStartInBase += baseCoordK * this.baseDimMul[k];
            }
            assert (k == this.dim.length - 1);
            long baseCoordLast = this.pos[k] + a;
            assert (this.pos[k] < 0L || baseCoordLast >= 0L);
            baseCoordLast = AbstractMatrix.normalizeMirrorCoord(baseCoordLast, this.baseDim[k]);
            this.fillFloatsInLine(indexOfLineStartInBase += baseCoordLast * this.baseDimMul[k], baseCoord0, len, value);
            index += len;
            count -= len;
        }
    }

    private void fillFloatsInLine(long indexOfLineStartInBase, long baseCoord0, long len, float value) {
        boolean inMirror = baseCoord0 < 0L;
        assert ((baseCoord0 &= Long.MAX_VALUE) < this.baseDim0);
        long m = Math.min(this.baseDim0 - baseCoord0, len);
        long position = indexOfLineStartInBase + (inMirror ? this.baseDim0 - baseCoord0 - m : baseCoord0);
        this.updatableBaseFloatArray.fill(position, m, value);
        if ((len -= m) == 0L) {
            return;
        }
        inMirror = !inMirror;
        m = Math.min(this.baseDim0, len);
        position = inMirror ? indexOfLineStartInBase + this.baseDim0 - m : indexOfLineStartInBase;
        this.updatableBaseFloatArray.fill(position, m, value);
    }

    @Override
    public long indexOfDouble(long lowIndex, long highIndex, double value) {
        throw new AssertionError((Object)"indexOfDouble method should not be called for mirror cyclic continuation");
    }

    @Override
    public long lastIndexOfDouble(long lowIndex, long highIndex, double value) {
        throw new AssertionError((Object)"lastIndexOfDouble method should not be called for mirror cyclic continuation");
    }

    @Override
    public void fillDoubles(long position, long count, double value) {
        assert (position >= 0L && position <= this.size - count);
        assert (count >= 0L);
        if (this.dim.length == 1) {
            if (count == 0L) {
                return;
            }
            long coord = this.pos0 + position;
            assert (this.pos0 < 0L || coord >= 0L);
            coord = ArraysSubMatrixMirrorCyclicIndexer.partiallyNormalizeMirrorCoord(coord, this.baseDim0);
            this.fillDoublesInLine(0L, coord, count, value);
            return;
        }
        long bLast = -157L;
        long index = position;
        while (count > 0L) {
            int k;
            long subCoord0;
            long b;
            long a = index;
            if (index == position) {
                b = a / this.dim0;
                subCoord0 = a - b * this.dim0;
            } else {
                b = bLast + 1L;
                subCoord0 = 0L;
            }
            bLast = b;
            long len = Math.min(this.dim0 - subCoord0, count);
            assert (len > 0L) : "zero len = " + len;
            long baseCoord0 = this.pos0 + subCoord0;
            assert (this.pos0 < 0L || baseCoord0 >= 0L);
            baseCoord0 = ArraysSubMatrixMirrorCyclicIndexer.partiallyNormalizeMirrorCoord(baseCoord0, this.baseDim0);
            a = b;
            long indexOfLineStartInBase = 0L;
            for (k = 1; k < this.dim.length - 1; ++k) {
                b = a / this.dim[k];
                long subCoordK = a - b * this.dim[k];
                long baseCoordK = this.pos[k] + subCoordK;
                assert (this.pos[k] < 0L || baseCoordK >= 0L);
                baseCoordK = AbstractMatrix.normalizeMirrorCoord(baseCoordK, this.baseDim[k]);
                a = b;
                indexOfLineStartInBase += baseCoordK * this.baseDimMul[k];
            }
            assert (k == this.dim.length - 1);
            long baseCoordLast = this.pos[k] + a;
            assert (this.pos[k] < 0L || baseCoordLast >= 0L);
            baseCoordLast = AbstractMatrix.normalizeMirrorCoord(baseCoordLast, this.baseDim[k]);
            this.fillDoublesInLine(indexOfLineStartInBase += baseCoordLast * this.baseDimMul[k], baseCoord0, len, value);
            index += len;
            count -= len;
        }
    }

    private void fillDoublesInLine(long indexOfLineStartInBase, long baseCoord0, long len, double value) {
        boolean inMirror = baseCoord0 < 0L;
        assert ((baseCoord0 &= Long.MAX_VALUE) < this.baseDim0);
        long m = Math.min(this.baseDim0 - baseCoord0, len);
        long position = indexOfLineStartInBase + (inMirror ? this.baseDim0 - baseCoord0 - m : baseCoord0);
        this.updatableBaseDoubleArray.fill(position, m, value);
        if ((len -= m) == 0L) {
            return;
        }
        inMirror = !inMirror;
        m = Math.min(this.baseDim0, len);
        position = inMirror ? indexOfLineStartInBase + this.baseDim0 - m : indexOfLineStartInBase;
        this.updatableBaseDoubleArray.fill(position, m, value);
    }

    @Override
    public long indexOfObject(long lowIndex, long highIndex, Object value) {
        throw new AssertionError((Object)"indexOfObject method should not be called for mirror cyclic continuation");
    }

    @Override
    public long lastIndexOfObject(long lowIndex, long highIndex, Object value) {
        throw new AssertionError((Object)"lastIndexOfObject method should not be called for mirror cyclic continuation");
    }

    @Override
    public void fillObjects(long position, long count, Object value) {
        assert (position >= 0L && position <= this.size - count);
        assert (count >= 0L);
        if (this.dim.length == 1) {
            if (count == 0L) {
                return;
            }
            long coord = this.pos0 + position;
            assert (this.pos0 < 0L || coord >= 0L);
            coord = ArraysSubMatrixMirrorCyclicIndexer.partiallyNormalizeMirrorCoord(coord, this.baseDim0);
            this.fillObjectsInLine(0L, coord, count, value);
            return;
        }
        long bLast = -157L;
        long index = position;
        while (count > 0L) {
            int k;
            long subCoord0;
            long b;
            long a = index;
            if (index == position) {
                b = a / this.dim0;
                subCoord0 = a - b * this.dim0;
            } else {
                b = bLast + 1L;
                subCoord0 = 0L;
            }
            bLast = b;
            long len = Math.min(this.dim0 - subCoord0, count);
            assert (len > 0L) : "zero len = " + len;
            long baseCoord0 = this.pos0 + subCoord0;
            assert (this.pos0 < 0L || baseCoord0 >= 0L);
            baseCoord0 = ArraysSubMatrixMirrorCyclicIndexer.partiallyNormalizeMirrorCoord(baseCoord0, this.baseDim0);
            a = b;
            long indexOfLineStartInBase = 0L;
            for (k = 1; k < this.dim.length - 1; ++k) {
                b = a / this.dim[k];
                long subCoordK = a - b * this.dim[k];
                long baseCoordK = this.pos[k] + subCoordK;
                assert (this.pos[k] < 0L || baseCoordK >= 0L);
                baseCoordK = AbstractMatrix.normalizeMirrorCoord(baseCoordK, this.baseDim[k]);
                a = b;
                indexOfLineStartInBase += baseCoordK * this.baseDimMul[k];
            }
            assert (k == this.dim.length - 1);
            long baseCoordLast = this.pos[k] + a;
            assert (this.pos[k] < 0L || baseCoordLast >= 0L);
            baseCoordLast = AbstractMatrix.normalizeMirrorCoord(baseCoordLast, this.baseDim[k]);
            this.fillObjectsInLine(indexOfLineStartInBase += baseCoordLast * this.baseDimMul[k], baseCoord0, len, value);
            index += len;
            count -= len;
        }
    }

    private void fillObjectsInLine(long indexOfLineStartInBase, long baseCoord0, long len, Object value) {
        boolean inMirror = baseCoord0 < 0L;
        assert ((baseCoord0 &= Long.MAX_VALUE) < this.baseDim0);
        long m = Math.min(this.baseDim0 - baseCoord0, len);
        long position = indexOfLineStartInBase + (inMirror ? this.baseDim0 - baseCoord0 - m : baseCoord0);
        this.updatableBaseObjectArray.fill(position, m, value);
        if ((len -= m) == 0L) {
            return;
        }
        inMirror = !inMirror;
        m = Math.min(this.baseDim0, len);
        position = inMirror ? indexOfLineStartInBase + this.baseDim0 - m : indexOfLineStartInBase;
        this.updatableBaseObjectArray.fill(position, m, value);
    }

    private static long partiallyNormalizeMirrorCoord(long coord, long dim) {
        boolean mirror;
        long repeatIndex = coord / dim;
        boolean bl = mirror = (repeatIndex & 1L) != 0L;
        if ((coord -= dim * repeatIndex) < 0L) {
            coord += dim;
            mirror = !mirror;
        }
        return mirror ? coord | Long.MIN_VALUE : coord;
    }

    private static class BooleanArrayReverser
    implements ArrayReverser {
        private BooleanArrayReverser() {
        }

        @Override
        public void reverse(Object javaArray, int position, int count) {
            boolean[] a = (boolean[])javaArray;
            int i = position;
            int mid = position + (count >> 1);
            int j = position + count - 1;
            while (i < mid) {
                boolean temp = a[i];
                a[i] = a[j];
                a[j] = temp;
                ++i;
                --j;
            }
        }

        @Override
        public void reverse(Object destArray, Object srcArray, int srcPosition, int count) {
            boolean[] da = (boolean[])destArray;
            boolean[] sa = (boolean[])srcArray;
            int i = 0;
            int j = srcPosition + count - 1;
            while (i < count) {
                da[i] = sa[j];
                ++i;
                --j;
            }
        }
    }

    private static class CharArrayReverser
    implements ArrayReverser {
        private CharArrayReverser() {
        }

        @Override
        public void reverse(Object javaArray, int position, int count) {
            char[] a = (char[])javaArray;
            int i = position;
            int mid = position + (count >> 1);
            int j = position + count - 1;
            while (i < mid) {
                char temp = a[i];
                a[i] = a[j];
                a[j] = temp;
                ++i;
                --j;
            }
        }

        @Override
        public void reverse(Object destArray, Object srcArray, int srcPosition, int count) {
            char[] da = (char[])destArray;
            char[] sa = (char[])srcArray;
            int i = 0;
            int j = srcPosition + count - 1;
            while (i < count) {
                da[i] = sa[j];
                ++i;
                --j;
            }
        }
    }

    private static class ByteArrayReverser
    implements ArrayReverser {
        private ByteArrayReverser() {
        }

        @Override
        public void reverse(Object javaArray, int position, int count) {
            byte[] a = (byte[])javaArray;
            int i = position;
            int mid = position + (count >> 1);
            int j = position + count - 1;
            while (i < mid) {
                byte temp = a[i];
                a[i] = a[j];
                a[j] = temp;
                ++i;
                --j;
            }
        }

        @Override
        public void reverse(Object destArray, Object srcArray, int srcPosition, int count) {
            byte[] da = (byte[])destArray;
            byte[] sa = (byte[])srcArray;
            int i = 0;
            int j = srcPosition + count - 1;
            while (i < count) {
                da[i] = sa[j];
                ++i;
                --j;
            }
        }
    }

    private static class ShortArrayReverser
    implements ArrayReverser {
        private ShortArrayReverser() {
        }

        @Override
        public void reverse(Object javaArray, int position, int count) {
            short[] a = (short[])javaArray;
            int i = position;
            int mid = position + (count >> 1);
            int j = position + count - 1;
            while (i < mid) {
                short temp = a[i];
                a[i] = a[j];
                a[j] = temp;
                ++i;
                --j;
            }
        }

        @Override
        public void reverse(Object destArray, Object srcArray, int srcPosition, int count) {
            short[] da = (short[])destArray;
            short[] sa = (short[])srcArray;
            int i = 0;
            int j = srcPosition + count - 1;
            while (i < count) {
                da[i] = sa[j];
                ++i;
                --j;
            }
        }
    }

    private static class IntArrayReverser
    implements ArrayReverser {
        private IntArrayReverser() {
        }

        @Override
        public void reverse(Object javaArray, int position, int count) {
            int[] a = (int[])javaArray;
            int i = position;
            int mid = position + (count >> 1);
            int j = position + count - 1;
            while (i < mid) {
                int temp = a[i];
                a[i] = a[j];
                a[j] = temp;
                ++i;
                --j;
            }
        }

        @Override
        public void reverse(Object destArray, Object srcArray, int srcPosition, int count) {
            int[] da = (int[])destArray;
            int[] sa = (int[])srcArray;
            int i = 0;
            int j = srcPosition + count - 1;
            while (i < count) {
                da[i] = sa[j];
                ++i;
                --j;
            }
        }
    }

    private static class LongArrayReverser
    implements ArrayReverser {
        private LongArrayReverser() {
        }

        @Override
        public void reverse(Object javaArray, int position, int count) {
            long[] a = (long[])javaArray;
            int i = position;
            int mid = position + (count >> 1);
            int j = position + count - 1;
            while (i < mid) {
                long temp = a[i];
                a[i] = a[j];
                a[j] = temp;
                ++i;
                --j;
            }
        }

        @Override
        public void reverse(Object destArray, Object srcArray, int srcPosition, int count) {
            long[] da = (long[])destArray;
            long[] sa = (long[])srcArray;
            int i = 0;
            int j = srcPosition + count - 1;
            while (i < count) {
                da[i] = sa[j];
                ++i;
                --j;
            }
        }
    }

    private static class FloatArrayReverser
    implements ArrayReverser {
        private FloatArrayReverser() {
        }

        @Override
        public void reverse(Object javaArray, int position, int count) {
            float[] a = (float[])javaArray;
            int i = position;
            int mid = position + (count >> 1);
            int j = position + count - 1;
            while (i < mid) {
                float temp = a[i];
                a[i] = a[j];
                a[j] = temp;
                ++i;
                --j;
            }
        }

        @Override
        public void reverse(Object destArray, Object srcArray, int srcPosition, int count) {
            float[] da = (float[])destArray;
            float[] sa = (float[])srcArray;
            int i = 0;
            int j = srcPosition + count - 1;
            while (i < count) {
                da[i] = sa[j];
                ++i;
                --j;
            }
        }
    }

    private static class DoubleArrayReverser
    implements ArrayReverser {
        private DoubleArrayReverser() {
        }

        @Override
        public void reverse(Object javaArray, int position, int count) {
            double[] a = (double[])javaArray;
            int i = position;
            int mid = position + (count >> 1);
            int j = position + count - 1;
            while (i < mid) {
                double temp = a[i];
                a[i] = a[j];
                a[j] = temp;
                ++i;
                --j;
            }
        }

        @Override
        public void reverse(Object destArray, Object srcArray, int srcPosition, int count) {
            double[] da = (double[])destArray;
            double[] sa = (double[])srcArray;
            int i = 0;
            int j = srcPosition + count - 1;
            while (i < count) {
                da[i] = sa[j];
                ++i;
                --j;
            }
        }
    }

    private static class ObjectArrayReverser
    implements ArrayReverser {
        private ObjectArrayReverser() {
        }

        @Override
        public void reverse(Object javaArray, int position, int count) {
            Object[] a = (Object[])javaArray;
            int i = position;
            int mid = position + (count >> 1);
            int j = position + count - 1;
            while (i < mid) {
                Object temp = a[i];
                a[i] = a[j];
                a[j] = temp;
                ++i;
                --j;
            }
        }

        @Override
        public void reverse(Object destArray, Object srcArray, int srcPosition, int count) {
            Object[] da = (Object[])destArray;
            Object[] sa = (Object[])srcArray;
            int i = 0;
            int j = srcPosition + count - 1;
            while (i < count) {
                da[i] = sa[j];
                ++i;
                --j;
            }
        }
    }

    private static interface ArrayReverser {
        public void reverse(Object var1, int var2, int var3);

        public void reverse(Object var1, Object var2, int var3, int var4);
    }
}

