/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.nio.ByteBuffer;
import java.util.EmptyStackException;
import java.util.Objects;
import net.algart.arrays.AbstractArray;
import net.algart.arrays.AbstractMemoryModel;
import net.algart.arrays.Array;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.Arrays;
import net.algart.arrays.DataBuffer;
import net.algart.arrays.DataObjectBuffer;
import net.algart.arrays.InternalUtils;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.MutableArray;
import net.algart.arrays.MutableByteArray;
import net.algart.arrays.MutableObjectArray;
import net.algart.arrays.MutableObjectInPlaceArray;
import net.algart.arrays.ObjectArray;
import net.algart.arrays.ObjectInPlaceArray;
import net.algart.arrays.TooLargeArrayException;
import net.algart.arrays.UnallowedMutationError;
import net.algart.arrays.UnsupportedElementTypeException;
import net.algart.arrays.UpdatableArray;
import net.algart.arrays.UpdatableByteArray;
import net.algart.arrays.UpdatableObjectArray;
import net.algart.arrays.UpdatableObjectInPlaceArray;

public final class CombinedMemoryModel<E>
extends AbstractMemoryModel {
    private final Combiner<E> combiner;

    private CombinedMemoryModel(Combiner<E> combiner) {
        Objects.requireNonNull(combiner, "Null combiner argument");
        this.combiner = combiner;
    }

    public static <E> CombinedMemoryModel<E> getInstance(Combiner<E> combiner) {
        return new CombinedMemoryModel<E>(combiner);
    }

    @Override
    public MutableArray newEmptyArray(Class<?> elementType) {
        return this.newEmptyArray(elementType, 10L);
    }

    @Override
    public MutableArray newEmptyArray(Class<?> elementType, long initialCapacity) {
        Arrays.checkElementTypeForNullAndVoid(elementType);
        if (initialCapacity < 0L) {
            throw new IllegalArgumentException("Negative initial capacity");
        }
        if (!Object.class.isAssignableFrom(elementType)) {
            throw new UnsupportedElementTypeException("Primitive element types are not allowed (passed type: " + String.valueOf(elementType) + ")");
        }
        Class eType = (Class)InternalUtils.cast(elementType);
        if (this.combiner instanceof CombinerInPlace) {
            return new MutableCombinedInPlaceArray(eType, initialCapacity, 0L, (CombinerInPlace)this.combiner);
        }
        return new MutableCombinedArray<E>(eType, initialCapacity, 0L, this.combiner);
    }

    @Override
    public MutableArray newArray(Class<?> elementType, long initialLength) {
        return this.newEmptyArray(elementType, initialLength).length(initialLength).trim();
    }

    @Override
    public UpdatableArray newUnresizableArray(Class<?> elementType, long length) {
        Arrays.checkElementTypeForNullAndVoid(elementType);
        if (length < 0L) {
            throw new IllegalArgumentException("Negative array length");
        }
        if (!Object.class.isAssignableFrom(elementType)) {
            throw new UnsupportedElementTypeException("Primitive element types are not allowed (passed type: " + String.valueOf(elementType) + ")");
        }
        Class eType = (Class)InternalUtils.cast(elementType);
        if (this.combiner instanceof CombinerInPlace) {
            return new UpdatableCombinedInPlaceArray(eType, length, length, (CombinerInPlace)this.combiner);
        }
        return new UpdatableCombinedArray<E>(eType, length, length, this.combiner);
    }

    @Override
    public boolean isElementTypeSupported(Class<?> elementType) {
        Objects.requireNonNull(elementType, "Null elementType argument");
        return Object.class.isAssignableFrom(elementType);
    }

    @Override
    public boolean areAllPrimitiveElementTypesSupported() {
        return false;
    }

    @Override
    public boolean areAllElementTypesSupported() {
        return false;
    }

    @Override
    public long maxSupportedLength(Class<?> elementType) {
        Objects.requireNonNull(elementType, "Null elementType argument");
        return Long.MAX_VALUE;
    }

    @Override
    public boolean isCreatedBy(Array array) {
        return array instanceof CombinedArray && ((CombinedArray)array).combiner == this.combiner;
    }

    public static boolean isCombinedArray(Array array) {
        return array instanceof CombinedArray;
    }

    public ObjectArray<E> asCombinedArray(Class<E> elementType, Array[] storage) {
        Array[] storageClone = (Array[])storage.clone();
        for (int k = 0; k < storageClone.length; ++k) {
            storageClone[k] = storageClone[k].asImmutable();
        }
        if (this.combiner instanceof CombinerInPlace) {
            return new CombinedInPlaceArray<E>(elementType, storageClone, (CombinerInPlace)this.combiner);
        }
        return new CombinedArray<E>(elementType, storageClone, this.combiner);
    }

    public UpdatableObjectArray<E> asUpdatableCombinedArray(Class<E> elementType, UpdatableArray[] storage) {
        UpdatableArray[] storageClone = (UpdatableArray[])storage.clone();
        for (int k = 0; k < storageClone.length; ++k) {
            storageClone[k] = storageClone[k].asUnresizable().shallowClone();
        }
        if (this.combiner instanceof CombinerInPlace) {
            return new UpdatableCombinedInPlaceArray<E>(elementType, storageClone, (CombinerInPlace)this.combiner);
        }
        return new UpdatableCombinedArray<E>(elementType, storageClone, this.combiner);
    }

    public String toString() {
        return "Combined memory model [combiner: " + String.valueOf(this.combiner) + "]";
    }

    public static Array[] getStorage(Array combinedArray) {
        Objects.requireNonNull(combinedArray, "Null combinedArray argument");
        if (!(combinedArray instanceof CombinedArray)) {
            throw new IllegalArgumentException("The passed argument is not a combined array");
        }
        CombinedArray cv = (CombinedArray)combinedArray;
        Array[] result = (Array[])cv.storage.clone();
        for (int k = 0; k < result.length; ++k) {
            result[k] = cv.storage[k].shallowClone();
        }
        return result;
    }

    public static UpdatableArray[] getStorage(UpdatableArray combinedArray) {
        return (UpdatableArray[])CombinedMemoryModel.getStorage((Array)combinedArray);
    }

    public static MutableArray[] getStorage(MutableArray combinedArray) {
        return (MutableArray[])CombinedMemoryModel.getStorage((Array)combinedArray);
    }

    public static String[] getStorageToStrings(Array combinedArray) {
        Objects.requireNonNull(combinedArray, "Null combinedArray argument");
        if (!(combinedArray instanceof CombinedArray)) {
            throw new IllegalArgumentException("The passed argument is not a combined array");
        }
        CombinedArray cv = (CombinedArray)combinedArray;
        String[] result = new String[cv.storage.length];
        for (int k = 0; k < result.length; ++k) {
            result[k] = cv.storage[k].toString();
        }
        return result;
    }

    private static Array[] shallowCloneArrays(Array[] src) {
        Objects.requireNonNull(src, "Cannot make shallow clones of arrays: null Array[] src");
        Array[] result = (Array[])src.clone();
        for (int k = 0; k < result.length; ++k) {
            Objects.requireNonNull(src[k], "Cannot make shallow clones of arrays: array #" + k + " is null");
            result[k] = src[k].shallowClone();
        }
        return result;
    }

    public static interface Combiner<E> {
        public E get(long var1, Array[] var3);

        public void set(long var1, E var3, UpdatableArray[] var4);

        public UpdatableArray[] allocateStorage(long var1, boolean var3);

        public int numbersOfElementsPerOneCombinedElement(int var1);
    }

    public static interface CombinerInPlace<E>
    extends Combiner<E> {
        public E allocateElement();

        public void getInPlace(long var1, E var3, Array[] var4);
    }

    private static final class MutableCombinedInPlaceArray<E>
    extends MutableCombinedArray<E>
    implements MutableObjectInPlaceArray<E> {
        MutableCombinedInPlaceArray(Class<E> elementType, MutableArray[] storage, CombinerInPlace<E> combiner) {
            super(elementType, storage, combiner);
        }

        MutableCombinedInPlaceArray(Class<E> elementType, long initialCapacity, long initialLength, CombinerInPlace<E> combiner) {
            super(elementType, initialCapacity, initialLength, combiner);
        }

        @Override
        public E allocateElement() {
            return ((CombinerInPlace)this.combiner).allocateElement();
        }

        @Override
        public E getInPlace(long index, Object resultValue) {
            Object resValue = InternalUtils.cast(resultValue);
            ((CombinerInPlace)this.combiner).getInPlace(index, resValue, this.storage);
            return (E)resValue;
        }

        @Override
        public MutableObjectInPlaceArray<E> setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
            super.setData(arrayPos, srcArray, srcArrayOffset, count);
            return this;
        }

        @Override
        public MutableObjectInPlaceArray<E> setData(long arrayPos, Object srcArray) {
            super.setData(arrayPos, srcArray);
            return this;
        }

        @Override
        public MutableObjectInPlaceArray<E> copy(Array src) {
            super.copy(src);
            return this;
        }

        @Override
        public MutableObjectInPlaceArray<E> swap(UpdatableArray another) {
            super.swap(another);
            return this;
        }

        @Override
        public MutableObjectInPlaceArray<E> length(long newLength) {
            super.length(newLength);
            return this;
        }

        @Override
        public MutableObjectInPlaceArray<E> ensureCapacity(long minCapacity) {
            super.ensureCapacity(minCapacity);
            return this;
        }

        @Override
        public MutableObjectInPlaceArray<E> trim() {
            super.trim();
            return this;
        }

        @Override
        public MutableObjectInPlaceArray<E> append(Array appendedArray) {
            super.append(appendedArray);
            return this;
        }

        @Override
        public UpdatableObjectInPlaceArray<E> subArray(long fromIndex, long toIndex) {
            this.checkSubArrayArguments(fromIndex, toIndex);
            UpdatableArray[] stor = new UpdatableArray[this.storage.length];
            for (int k = 0; k < this.storage.length; ++k) {
                stor[k] = ((UpdatableArray)this.storage[k]).subArray(fromIndex * (long)this.numbersOfElements[k], toIndex * (long)this.numbersOfElements[k]);
            }
            return new UpdatableCombinedInPlaceArray(this.elementType, stor, (CombinerInPlace)this.combiner);
        }

        @Override
        public UpdatableObjectInPlaceArray<E> subArr(long position, long count) {
            this.checkSubArrArguments(position, count);
            UpdatableArray[] stor = new UpdatableArray[this.storage.length];
            for (int k = 0; k < this.storage.length; ++k) {
                stor[k] = ((UpdatableArray)this.storage[k]).subArr(position * (long)this.numbersOfElements[k], count * (long)this.numbersOfElements[k]);
            }
            return new UpdatableCombinedInPlaceArray(this.elementType, stor, (CombinerInPlace)this.combiner);
        }

        @Override
        public MutableObjectInPlaceArray<E> asCopyOnNextWrite() {
            MutableArray[] stor = (MutableArray[])this.storage.clone();
            for (int k = 0; k < this.storage.length; ++k) {
                stor[k] = stor[k].asCopyOnNextWrite();
            }
            return new MutableCombinedInPlaceArray<E>(this.elementType, stor, (CombinerInPlace)this.combiner);
        }

        @Override
        public UpdatableObjectInPlaceArray<E> asUnresizable() {
            UpdatableArray[] stor = new UpdatableArray[this.storage.length];
            for (int k = 0; k < this.storage.length; ++k) {
                stor[k] = ((MutableArray[])this.storage)[k].asUnresizable();
            }
            return new UpdatableCombinedInPlaceArray(this.elementType, stor, (CombinerInPlace)this.combiner);
        }

        @Override
        public MutableObjectInPlaceArray<E> shallowClone() {
            return (MutableObjectInPlaceArray)InternalUtils.cast(super.shallowClone());
        }
    }

    static class MutableCombinedArray<E>
    extends UpdatableCombinedArray<E>
    implements MutableObjectArray<E> {
        MutableCombinedArray(Class<E> elementType, MutableArray[] storage, Combiner<E> combiner) {
            super(elementType, storage, combiner);
        }

        MutableCombinedArray(Class<E> elementType, long initialCapacity, long initialLength, Combiner<E> combiner) {
            super(elementType, initialCapacity, initialLength, combiner);
        }

        @Override
        public MutableObjectArray<E> length(long newLength) {
            if (newLength != this.length) {
                int k;
                for (k = 0; k < this.storage.length; ++k) {
                    InternalUtils.longMulAndException(newLength, this.numbersOfElements[k]);
                }
                for (k = 0; k < this.storage.length; ++k) {
                    ((MutableArray[])this.storage)[k].length(newLength * (long)this.numbersOfElements[k]);
                }
                this.length = newLength;
                this.recalculateCapacity();
            }
            return this;
        }

        @Override
        public MutableObjectArray<E> ensureCapacity(long minCapacity) {
            if (minCapacity > this.capacity()) {
                int k;
                for (k = 0; k < this.storage.length; ++k) {
                    InternalUtils.longMulAndException(minCapacity, this.numbersOfElements[k]);
                }
                for (k = 0; k < this.storage.length; ++k) {
                    ((MutableArray[])this.storage)[k].ensureCapacity(minCapacity * (long)this.numbersOfElements[k]);
                }
                this.recalculateCapacity();
            }
            return this;
        }

        @Override
        public MutableObjectArray<E> trim() {
            if (this.length < this.capacity()) {
                for (int k = 0; k < this.storage.length; ++k) {
                    ((MutableArray[])this.storage)[k].trim();
                }
                this.recalculateCapacity();
            }
            return this;
        }

        @Override
        public MutableObjectArray<E> append(Array appendedArray) {
            MutableCombinedArray.defaultAppend(this, appendedArray);
            return this;
        }

        @Override
        public final Object popElement() {
            return this.pop();
        }

        @Override
        public final E pop() {
            long index = this.length() - 1L;
            if (index < 0L) {
                throw new EmptyStackException();
            }
            Object result = this.get(index);
            this.length(index);
            return result;
        }

        @Override
        public final void pushElement(Object value) {
            long index = this.length();
            if (index == Long.MAX_VALUE) {
                throw new TooLargeArrayException("Too large desired array length (>Long.MAX_VALUE)");
            }
            this.length(index + 1L);
            this.setElement(index, value);
        }

        @Override
        public final void push(E value) {
            this.pushElement(value);
        }

        @Override
        public void removeTop() {
            long index = this.length() - 1L;
            if (index < 0L) {
                throw new EmptyStackException();
            }
            this.length(index);
        }

        @Override
        public MutableObjectArray<E> setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
            super.setData(arrayPos, srcArray, srcArrayOffset, count);
            return this;
        }

        @Override
        public MutableObjectArray<E> setData(long arrayPos, Object srcArray) {
            super.setData(arrayPos, srcArray);
            return this;
        }

        @Override
        public MutableObjectArray<E> copy(Array src) {
            super.copy(src);
            return this;
        }

        @Override
        public MutableObjectArray<E> swap(UpdatableArray another) {
            super.swap(another);
            return this;
        }

        @Override
        public boolean isUnresizable() {
            return false;
        }

        @Override
        public MutableObjectArray<E> asCopyOnNextWrite() {
            MutableArray[] stor = (MutableArray[])this.storage.clone();
            for (int k = 0; k < this.storage.length; ++k) {
                stor[k] = stor[k].asCopyOnNextWrite();
            }
            return new MutableCombinedArray<E>(this.elementType, stor, this.combiner);
        }

        @Override
        public UpdatableObjectArray<E> asUnresizable() {
            UpdatableArray[] stor = new UpdatableArray[this.storage.length];
            for (int k = 0; k < this.storage.length; ++k) {
                stor[k] = ((MutableArray[])this.storage)[k].asUnresizable();
            }
            return new UpdatableCombinedArray(this.elementType, stor, this.combiner);
        }

        @Override
        public MutableObjectArray<E> shallowClone() {
            return (MutableObjectArray)InternalUtils.cast(super.shallowClone());
        }

        @Override
        public <D> MutableObjectArray<D> cast(Class<D> elementType) {
            return (MutableObjectArray)InternalUtils.cast(super.cast((Class)elementType));
        }

        @Override
        public String toString() {
            return "mutable combined array " + this.elementType.getName() + "[" + this.length() + "], capacity " + this.capacity();
        }
    }

    private static final class UpdatableCombinedInPlaceArray<E>
    extends UpdatableCombinedArray<E>
    implements UpdatableObjectInPlaceArray<E> {
        UpdatableCombinedInPlaceArray(Class<E> elementType, UpdatableArray[] storage, CombinerInPlace<E> combiner) {
            super(elementType, storage, combiner);
        }

        UpdatableCombinedInPlaceArray(Class<E> elementType, long initialCapacity, long initialLength, CombinerInPlace<E> combiner) {
            super(elementType, initialCapacity, initialLength, combiner);
        }

        @Override
        public E allocateElement() {
            return ((CombinerInPlace)this.combiner).allocateElement();
        }

        @Override
        public E getInPlace(long index, Object resultValue) {
            Object resValue = InternalUtils.cast(resultValue);
            ((CombinerInPlace)this.combiner).getInPlace(index, resValue, this.storage);
            return (E)resValue;
        }

        @Override
        public UpdatableObjectInPlaceArray<E> subArray(long fromIndex, long toIndex) {
            this.checkSubArrayArguments(fromIndex, toIndex);
            UpdatableArray[] stor = new UpdatableArray[this.storage.length];
            for (int k = 0; k < this.storage.length; ++k) {
                stor[k] = ((UpdatableArray)this.storage[k]).subArray(fromIndex * (long)this.numbersOfElements[k], toIndex * (long)this.numbersOfElements[k]);
            }
            return new UpdatableCombinedInPlaceArray<E>(this.elementType, stor, (CombinerInPlace)this.combiner);
        }

        @Override
        public UpdatableObjectInPlaceArray<E> subArr(long position, long count) {
            this.checkSubArrArguments(position, count);
            UpdatableArray[] stor = new UpdatableArray[this.storage.length];
            for (int k = 0; k < this.storage.length; ++k) {
                stor[k] = ((UpdatableArray)this.storage[k]).subArr(position * (long)this.numbersOfElements[k], count * (long)this.numbersOfElements[k]);
            }
            return new UpdatableCombinedInPlaceArray<E>(this.elementType, stor, (CombinerInPlace)this.combiner);
        }

        @Override
        public UpdatableObjectInPlaceArray<E> asUnresizable() {
            return this;
        }
    }

    static class UpdatableCombinedArray<E>
    extends CombinedArray<E>
    implements UpdatableObjectArray<E> {
        UpdatableCombinedArray(Class<E> elementType, UpdatableArray[] storage, Combiner<E> combiner) {
            super(elementType, storage, combiner);
        }

        UpdatableCombinedArray(Class<E> elementType, long initialCapacity, long initialLength, Combiner<E> combiner) {
            super(elementType, initialCapacity, initialLength, combiner);
        }

        @Override
        public final void setElement(long index, Object value) {
            if (value != null && !this.elementType.isAssignableFrom(value.getClass())) {
                throw new ClassCastException("Invalid type of setElement argument");
            }
            this.combiner.set(index, InternalUtils.cast(value), (UpdatableArray[])this.storage);
        }

        @Override
        public final void set(long index, E value) {
            this.setElement(index, value);
        }

        @Override
        public UpdatableArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
            Objects.requireNonNull(srcArray, "Null srcArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of stored elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            Object[] src = (Object[])InternalUtils.cast(srcArray);
            if (this.combiner instanceof BufferedCombiner) {
                ((BufferedCombiner)this.combiner).set(arrayPos, src, srcArrayOffset, count, (UpdatableArray[])this.storage);
            } else {
                this.setDataInternal(arrayPos, src, srcArrayOffset, count);
            }
            return this;
        }

        @Override
        public UpdatableArray setData(long arrayPos, Object srcArray) {
            Objects.requireNonNull(srcArray, "Null srcArray argument");
            if (arrayPos < 0L || arrayPos > this.length) {
                throw this.rangeException(arrayPos);
            }
            int count = java.lang.reflect.Array.getLength(srcArray);
            if ((long)count > this.length - arrayPos) {
                count = (int)(this.length - arrayPos);
            }
            Object[] src = (Object[])InternalUtils.cast(srcArray);
            if (this.combiner instanceof BufferedCombiner) {
                ((BufferedCombiner)this.combiner).set(arrayPos, src, 0, count, (UpdatableArray[])this.storage);
            } else {
                this.setDataInternal(arrayPos, src, 0, count);
            }
            return this;
        }

        private void setDataInternal(long arrayPos, E[] src, int srcArrayOffset, int count) {
            UpdatableArray[] stor = (UpdatableArray[])this.storage;
            int k = srcArrayOffset;
            int kMax = srcArrayOffset + count;
            while (k < kMax) {
                if (src[k] != null && !this.elementType.isAssignableFrom(src[k].getClass())) {
                    throw new ClassCastException("Invalid type of setElement argument");
                }
                this.combiner.set(arrayPos, src[k], stor);
                ++k;
                ++arrayPos;
            }
        }

        @Override
        public final void copy(long destIndex, long srcIndex) {
            if (srcIndex < 0L || srcIndex >= this.length) {
                throw this.rangeException(srcIndex);
            }
            if (destIndex < 0L || destIndex >= this.length) {
                throw this.rangeException(destIndex);
            }
            UpdatableArray[] stor = (UpdatableArray[])this.storage;
            if (this.allNumbersAre1) {
                for (UpdatableArray s : stor) {
                    s.copy(destIndex, srcIndex);
                }
            } else {
                for (int k = 0; k < this.storage.length; ++k) {
                    int ne = this.numbersOfElements[k];
                    stor[k].copy(destIndex * (long)ne, srcIndex * (long)ne, ne);
                }
            }
        }

        @Override
        public final void copy(long destIndex, long srcIndex, long count) {
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of copied elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (srcIndex < 0L) {
                throw this.rangeException(srcIndex);
            }
            if (srcIndex > this.length - count) {
                throw this.rangeException(srcIndex + count - 1L);
            }
            if (destIndex < 0L) {
                throw this.rangeException(destIndex);
            }
            if (destIndex > this.length - count) {
                throw this.rangeException(destIndex + count - 1L);
            }
            UpdatableArray[] stor = (UpdatableArray[])this.storage;
            if (this.allNumbersAre1) {
                for (UpdatableArray s : stor) {
                    s.copy(destIndex, srcIndex, count);
                }
            } else {
                for (int k = 0; k < this.storage.length; ++k) {
                    int ne = this.numbersOfElements[k];
                    stor[k].copy(destIndex * (long)ne, srcIndex * (long)ne, count * (long)ne);
                }
            }
        }

        @Override
        public final void swap(long firstIndex, long secondIndex) {
            if (firstIndex < 0L || firstIndex >= this.length) {
                throw this.rangeException(firstIndex);
            }
            if (secondIndex < 0L || secondIndex >= this.length) {
                throw this.rangeException(secondIndex);
            }
            UpdatableArray[] stor = (UpdatableArray[])this.storage;
            if (this.allNumbersAre1) {
                for (int k = 0; k < this.storage.length; ++k) {
                    stor[k].swap(firstIndex, secondIndex);
                }
            } else {
                for (int k = 0; k < this.storage.length; ++k) {
                    int ne = this.numbersOfElements[k];
                    stor[k].swap(firstIndex * (long)ne, secondIndex * (long)ne, ne);
                }
            }
        }

        @Override
        public final void swap(long firstIndex, long secondIndex, long count) {
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of swapped elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (firstIndex < 0L) {
                throw this.rangeException(firstIndex);
            }
            if (firstIndex > this.length - count) {
                throw this.rangeException(firstIndex + count - 1L);
            }
            if (secondIndex < 0L) {
                throw this.rangeException(secondIndex);
            }
            if (secondIndex > this.length - count) {
                throw this.rangeException(secondIndex + count - 1L);
            }
            UpdatableArray[] stor = (UpdatableArray[])this.storage;
            if (this.allNumbersAre1) {
                for (int k = 0; k < this.storage.length; ++k) {
                    stor[k].swap(firstIndex, secondIndex, count);
                }
            } else {
                for (int k = 0; k < this.storage.length; ++k) {
                    int ne = this.numbersOfElements[k];
                    stor[k].swap(firstIndex * (long)ne, secondIndex * (long)ne, count * (long)ne);
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Lifted jumps to return sites
         */
        @Override
        public UpdatableArray copy(Array src) {
            if (src instanceof CombinedArray) {
                CombinedArray a = (CombinedArray)src;
                if (a.combiner == this.combiner) {
                    AbstractArray.checkCopyArguments(this, src);
                    int k = 0;
                    while (k < this.storage.length) {
                        ((UpdatableArray[])this.storage)[k].copy(a.storage[k]);
                        ++k;
                    }
                    return this;
                }
            }
            UpdatableCombinedArray.defaultCopy(this, src);
            return this;
        }

        /*
         * Enabled aggressive block sorting
         * Lifted jumps to return sites
         */
        @Override
        public UpdatableArray swap(UpdatableArray another) {
            if (another instanceof UpdatableCombinedArray) {
                UpdatableCombinedArray a = (UpdatableCombinedArray)another;
                if (a.combiner == this.combiner) {
                    AbstractArray.checkSwapArguments(this, another);
                    int k = 0;
                    while (k < this.storage.length) {
                        ((UpdatableArray)this.storage[k]).swap((UpdatableArray)a.storage[k]);
                        ++k;
                    }
                    return this;
                }
            }
            UpdatableCombinedArray.defaultSwap(this, another);
            return this;
        }

        @Override
        public UpdatableObjectArray<E> fill(Object value) {
            this.copy(Arrays.nObjectCopies(this.length, value, this.elementType));
            return this;
        }

        @Override
        public UpdatableObjectArray<E> fill(long position, long count, Object value) {
            this.subArr(position, count).copy(Arrays.nObjectCopies(count, value, this.elementType));
            return this;
        }

        @Override
        public UpdatableObjectArray<E> subArray(long fromIndex, long toIndex) {
            this.checkSubArrayArguments(fromIndex, toIndex);
            UpdatableArray[] stor = new UpdatableArray[this.storage.length];
            for (int k = 0; k < this.storage.length; ++k) {
                stor[k] = ((UpdatableArray)this.storage[k]).subArray(fromIndex * (long)this.numbersOfElements[k], toIndex * (long)this.numbersOfElements[k]);
            }
            return new UpdatableCombinedArray<E>(this.elementType, stor, this.combiner);
        }

        @Override
        public UpdatableObjectArray<E> subArr(long position, long count) {
            this.checkSubArrArguments(position, count);
            UpdatableArray[] stor = new UpdatableArray[this.storage.length];
            for (int k = 0; k < this.storage.length; ++k) {
                stor[k] = ((UpdatableArray)this.storage[k]).subArr(position * (long)this.numbersOfElements[k], count * (long)this.numbersOfElements[k]);
            }
            return new UpdatableCombinedArray<E>(this.elementType, stor, this.combiner);
        }

        @Override
        public UpdatableArray asCopyOnNextWrite() {
            UpdatableArray[] stor = new UpdatableArray[this.storage.length];
            for (int k = 0; k < this.storage.length; ++k) {
                stor[k] = ((UpdatableArray[])this.storage)[k].asCopyOnNextWrite();
            }
            return new UpdatableCombinedArray<E>(this.elementType, stor, this.combiner);
        }

        @Override
        public UpdatableObjectArray<E> asUnresizable() {
            return this;
        }

        @Override
        public void setNonNew() {
            this.setNewStatus(false);
        }

        @Override
        public UpdatableObjectArray<E> shallowClone() {
            UpdatableCombinedArray result = (UpdatableCombinedArray)InternalUtils.cast(super.standardObjectClone());
            result.storage = CombinedMemoryModel.shallowCloneArrays(this.storage);
            return result;
        }

        @Override
        public <D> UpdatableObjectArray<D> cast(Class<D> elementType) {
            return (UpdatableObjectArray)InternalUtils.cast(super.cast(elementType));
        }

        @Override
        public String toString() {
            return "unresizable combined array " + this.elementType.getName() + "[" + this.length() + "], capacity " + this.capacity();
        }
    }

    static class CombinedArray<E>
    extends AbstractArray
    implements ObjectArray<E> {
        final Class<E> elementType;
        final Combiner<E> combiner;
        Array[] storage;
        final int[] numbersOfElements;
        final boolean allNumbersAre1;

        CombinedArray(Class<E> elementType, Array[] storage, Combiner<E> combiner) {
            super(Integer.MAX_VALUE, 0L);
            Objects.requireNonNull(storage, "Null storage argument");
            Objects.requireNonNull(combiner, "Null combiner argument");
            this.combiner = combiner;
            this.elementType = elementType;
            this.allNumbersAre1 = CombinedArray.checkStorageAndNumbersOfElements(storage, combiner);
            this.storage = storage;
            this.numbersOfElements = new int[storage.length];
            for (int k = 0; k < storage.length; ++k) {
                this.numbersOfElements[k] = combiner.numbersOfElementsPerOneCombinedElement(k);
            }
            this.length = storage[0].length() / (long)this.numbersOfElements[0];
            this.recalculateCapacity();
        }

        CombinedArray(Class<E> elementType, long initialCapacity, long initialLength, Combiner<E> combiner) {
            super(initialCapacity, initialLength);
            int k;
            Objects.requireNonNull(combiner, "Null combiner argument");
            this.combiner = combiner;
            this.elementType = elementType;
            boolean unresizableRequired = this.isUnresizable();
            Array[] stor = combiner.allocateStorage(initialLength, unresizableRequired);
            this.allNumbersAre1 = CombinedArray.checkStorageAndNumbersOfElements(stor, combiner);
            this.numbersOfElements = new int[stor.length];
            for (k = 0; k < stor.length; ++k) {
                this.numbersOfElements[k] = combiner.numbersOfElementsPerOneCombinedElement(k);
            }
            for (k = 0; k < stor.length; ++k) {
                if (!unresizableRequired && !(stor[k] instanceof MutableArray)) {
                    throw new IllegalArgumentException("Storage array #" + k + " does not implement MutableArray, though the resizable one is required while calling Combiner.allocateStorage method");
                }
                long correctLength = InternalUtils.longMulAndException(initialLength, this.numbersOfElements[k]);
                if (stor[k].length() == correctLength) continue;
                throw new IllegalArgumentException("Incorrect length of storage array #" + k + ": length = " + this.storage[k].length() + ", but the correct one is " + correctLength);
            }
            this.capacity = initialCapacity;
            if (!unresizableRequired) {
                for (k = 0; k < stor.length; ++k) {
                    ((MutableArray)stor[k]).ensureCapacity(InternalUtils.longMulAndException(initialCapacity, this.numbersOfElements[k]));
                }
            } else if (initialCapacity != initialLength) {
                throw new AssertionError((Object)"Unequal length and capacity while creating unresizable array!");
            }
            if (unresizableRequired) {
                this.storage = stor;
            } else {
                this.storage = new MutableArray[stor.length];
                System.arraycopy(stor, 0, this.storage, 0, stor.length);
            }
        }

        final void recalculateCapacity() {
            long cap = Long.MAX_VALUE;
            for (int k = 0; k < this.storage.length; ++k) {
                cap = Math.min(cap, this.storage[k].capacity() / (long)this.numbersOfElements[k]);
            }
            this.capacity = cap;
        }

        private static boolean checkStorageAndNumbersOfElements(Array[] storage, Combiner<?> combiner) {
            Objects.requireNonNull(storage, "Null Array[] storage");
            if (storage.length == 0) {
                throw new IllegalArgumentException("Storage must contain at least 1 array");
            }
            boolean result = true;
            long length0 = 157L;
            int ne0 = 28;
            for (int k = 0; k < storage.length; ++k) {
                Objects.requireNonNull(storage[k], "Null storage[" + k + "] array");
                int ne = combiner.numbersOfElementsPerOneCombinedElement(k);
                if (ne <= 0) {
                    throw new IllegalArgumentException("combiner.numbersOfElementsPerOneCombinedElement(" + k + ") = " + ne + " <= 0");
                }
                result &= ne == 1;
                if (storage[k].length() % (long)ne != 0L) {
                    throw new IllegalArgumentException("Incorrect length of storage array #" + k + ": length = " + storage[k].length() + " and is not divided by combiner.numbersOfElementsPerOneCombinedElement(" + k + ") = " + ne);
                }
                long length = storage[k].length() / (long)ne;
                if (k == 0) {
                    length0 = length;
                    ne0 = ne;
                    continue;
                }
                if (length == length0) continue;
                throw new IllegalArgumentException("Storage arrays lengths don't correspond to each other:  the length of array # " + k + " = " + storage[k].length() + " = " + length + " * " + ne + " (" + ne + " per one combined object), but the length of array #0 = " + storage[0].length() + " = " + length0 + " * " + ne0 + " (" + ne0 + " per one combined object)");
            }
            return result;
        }

        @Override
        public final Class<E> elementType() {
            return this.elementType;
        }

        @Override
        public Class<? extends ObjectArray<E>> type() {
            return (Class)InternalUtils.cast(ObjectArray.class);
        }

        @Override
        public Class<? extends UpdatableObjectArray<E>> updatableType() {
            return (Class)InternalUtils.cast(UpdatableObjectArray.class);
        }

        @Override
        public Class<? extends MutableObjectArray<E>> mutableType() {
            return (Class)InternalUtils.cast(MutableObjectArray.class);
        }

        @Override
        public final Object getElement(long index) {
            return this.combiner.get(index, this.storage);
        }

        @Override
        public final E get(long index) {
            return this.combiner.get(index, this.storage);
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, E value) {
            long n = Math.min(this.length(), highIndex);
            if (value == null) {
                for (k = Math.max(lowIndex, 0L); k < n; ++k) {
                    if (this.get(k) != null) continue;
                    return k;
                }
            } else {
                while (k < n) {
                    if (value.equals(this.get(k))) {
                        return k;
                    }
                    ++k;
                }
            }
            return -1L;
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, E value) {
            long k = Math.min(this.length(), highIndex);
            long low = Math.max(lowIndex, 0L);
            if (value == null) {
                while (k > low) {
                    if (this.get(--k) != null) continue;
                    return k;
                }
            } else {
                while (k > low) {
                    if (!value.equals(this.get(--k))) continue;
                    return k;
                }
            }
            return -1L;
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            Object[] dest = (Object[])InternalUtils.cast(destArray);
            if (this.combiner instanceof BufferedCombiner) {
                ((BufferedCombiner)this.combiner).get(arrayPos, dest, destArrayOffset, count, this.storage);
            } else {
                this.getDataInternal(arrayPos, dest, destArrayOffset, count);
            }
        }

        @Override
        public void getData(long arrayPos, Object destArray) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (arrayPos < 0L || arrayPos > this.length) {
                throw this.rangeException(arrayPos);
            }
            int count = java.lang.reflect.Array.getLength(destArray);
            if ((long)count > this.length - arrayPos) {
                count = (int)(this.length - arrayPos);
            }
            Object[] dest = (Object[])InternalUtils.cast(destArray);
            if (this.combiner instanceof BufferedCombiner) {
                ((BufferedCombiner)this.combiner).get(arrayPos, dest, 0, count, this.storage);
            } else {
                this.getDataInternal(arrayPos, dest, 0, count);
            }
        }

        private void getDataInternal(long arrayPos, Object[] dest, int destArrayOffset, int count) {
            int k = destArrayOffset;
            int kMax = destArrayOffset + count;
            while (k < kMax) {
                dest[k] = this.combiner.get(arrayPos, this.storage);
                ++k;
                ++arrayPos;
            }
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            this.checkSubArrayArguments(fromIndex, toIndex);
            Array[] stor = new Array[this.storage.length];
            for (int k = 0; k < this.storage.length; ++k) {
                stor[k] = this.storage[k].subArray(fromIndex * (long)this.numbersOfElements[k], toIndex * (long)this.numbersOfElements[k]);
            }
            return new CombinedArray<E>(this.elementType, stor, this.combiner);
        }

        @Override
        public Array subArr(long position, long count) {
            this.checkSubArrArguments(position, count);
            Array[] stor = new Array[this.storage.length];
            for (int k = 0; k < this.storage.length; ++k) {
                stor[k] = this.storage[k].subArr(position * (long)this.numbersOfElements[k], count * (long)this.numbersOfElements[k]);
            }
            return new CombinedArray<E>(this.elementType, stor, this.combiner);
        }

        @Override
        public DataObjectBuffer<E> buffer(DataBuffer.AccessMode mode, long capacity) {
            return (DataObjectBuffer)InternalUtils.cast(super.buffer(mode, capacity));
        }

        @Override
        public DataObjectBuffer<E> buffer(DataBuffer.AccessMode mode) {
            return (DataObjectBuffer)InternalUtils.cast(super.buffer(mode));
        }

        @Override
        public DataObjectBuffer<E> buffer(long capacity) {
            return (DataObjectBuffer)InternalUtils.cast(super.buffer(capacity));
        }

        @Override
        public DataObjectBuffer<E> buffer() {
            return (DataObjectBuffer)InternalUtils.cast(super.buffer());
        }

        @Override
        public final ObjectArray<E> asImmutable() {
            if (this.isImmutable()) {
                return this;
            }
            Array[] stor = new Array[this.storage.length];
            for (int k = 0; k < this.storage.length; ++k) {
                stor[k] = this.storage[k].asImmutable();
            }
            return new CombinedArray<E>(this.elementType, stor, this.combiner);
        }

        @Override
        public boolean isImmutable() {
            return this.storage[0].isImmutable();
        }

        @Override
        public final ObjectArray<E> asTrustedImmutable() {
            if (this.isImmutable()) {
                return this;
            }
            Array[] stor = new Array[this.storage.length];
            for (int k = 0; k < this.storage.length; ++k) {
                stor[k] = this.storage[k].asTrustedImmutable();
            }
            return new CombinedArray<E>(this.elementType, stor, this.combiner);
        }

        @Override
        public final void checkUnallowedMutation() throws UnallowedMutationError {
            try {
                for (Array s : this.storage) {
                    s.checkUnallowedMutation();
                }
            }
            catch (UnallowedMutationError ex) {
                UnallowedMutationError e = new UnallowedMutationError("Unallowed mutations of trusted immutable array  are detected by checkUnallowedMutation() method [" + String.valueOf(this) + "]");
                e.initCause(ex);
                throw e;
            }
        }

        @Override
        public Array asCopyOnNextWrite() {
            if (this.isImmutable()) {
                return this;
            }
            Array[] stor = new Array[this.storage.length];
            for (int k = 0; k < this.storage.length; ++k) {
                stor[k] = this.storage[k].asCopyOnNextWrite();
            }
            return new CombinedArray<E>(this.elementType, stor, this.combiner);
        }

        @Override
        public boolean isCopyOnNextWrite() {
            return this.storage[0].isCopyOnNextWrite();
        }

        @Override
        public boolean isUnresizable() {
            return true;
        }

        @Override
        public Array shallowClone() {
            Array[] stor = new Array[this.storage.length];
            for (int k = 0; k < this.storage.length; ++k) {
                stor[k] = this.storage[k].shallowClone();
            }
            return new CombinedArray<E>(this.elementType, stor, this.combiner);
        }

        @Override
        public MutableObjectArray<E> mutableClone(MemoryModel memoryModel) {
            return (MutableObjectArray)InternalUtils.cast(super.mutableClone(memoryModel));
        }

        @Override
        public UpdatableObjectArray<E> updatableClone(MemoryModel memoryModel) {
            return (UpdatableObjectArray)InternalUtils.cast(super.updatableClone(memoryModel));
        }

        @Override
        public E[] ja() {
            return this.toJavaArray();
        }

        @Override
        public <D> ObjectArray<D> cast(Class<D> elementType) {
            if (!elementType.isAssignableFrom(this.elementType)) {
                throw new ClassCastException("Illegal desired element type " + String.valueOf(elementType) + " for " + String.valueOf(this));
            }
            return (ObjectArray)InternalUtils.cast(this);
        }

        @Override
        public final void loadResources(ArrayContext context) {
            for (int k = 0; k < this.storage.length; ++k) {
                this.storage[k].loadResources(context == null ? null : context.part(k, k + 1, this.storage.length));
            }
        }

        @Override
        public final void flushResources(ArrayContext context, boolean forcePhysicalWriting) {
            for (int k = 0; k < this.storage.length; ++k) {
                this.storage[k].flushResources(context == null ? null : context.part(k, k + 1, this.storage.length), forcePhysicalWriting);
            }
        }

        @Override
        public final void freeResources(ArrayContext context, boolean forcePhysicalWriting) {
            for (int k = 0; k < this.storage.length; ++k) {
                this.storage[k].freeResources(context == null ? null : context.part(k, k + 1, this.storage.length), forcePhysicalWriting);
            }
        }

        @Override
        public String toString() {
            return (this.isImmutable() ? "immutable " : "") + "combined array " + this.elementType.getName() + "[" + this.length() + "], capacity " + this.capacity();
        }

        @Override
        public final boolean equals(Object obj) {
            if (obj instanceof CombinedArray && ((CombinedArray)obj).combiner == this.combiner) {
                for (int k = 0; k < this.storage.length; ++k) {
                    CombinedArray a = (CombinedArray)obj;
                    if (this.storage[k].equals(a.storage[k])) continue;
                    return false;
                }
                return true;
            }
            return super.equals(obj);
        }

        @Override
        final Object javaArrayInternal() {
            return null;
        }

        @Override
        final int javaArrayOffsetInternal() {
            return 0;
        }
    }

    private static final class CombinedInPlaceArray<E>
    extends CombinedArray<E>
    implements ObjectInPlaceArray<E> {
        CombinedInPlaceArray(Class<E> elementType, Array[] storage, CombinerInPlace<E> combiner) {
            super(elementType, storage, combiner);
        }

        CombinedInPlaceArray(Class<E> elementType, long initialCapacity, long initialLength, CombinerInPlace<E> combiner) {
            super(elementType, initialCapacity, initialLength, combiner);
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, E value) {
            long n;
            if (value == null) {
                return super.indexOf(lowIndex, highIndex, value);
            }
            long k = Math.max(lowIndex, 0L);
            if (k >= (n = Math.min(this.length(), highIndex))) {
                return -1L;
            }
            E e = this.allocateElement();
            while (k < n) {
                if (value.equals(this.getInPlace(k, e))) {
                    return k;
                }
                ++k;
            }
            return -1L;
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, E value) {
            long low;
            if (value == null) {
                return super.lastIndexOf(lowIndex, highIndex, value);
            }
            long k = Math.min(this.length(), highIndex);
            if (k <= (low = Math.max(lowIndex, 0L))) {
                return -1L;
            }
            E e = this.allocateElement();
            while (k > low) {
                if (value.equals(this.getInPlace(k, e))) {
                    return k;
                }
                --k;
            }
            return -1L;
        }

        @Override
        public E allocateElement() {
            return ((CombinerInPlace)this.combiner).allocateElement();
        }

        @Override
        public E getInPlace(long index, Object resultValue) {
            Object resValue = InternalUtils.cast(resultValue);
            ((CombinerInPlace)this.combiner).getInPlace(index, resValue, this.storage);
            return (E)resValue;
        }
    }

    public static abstract class AbstractByteBufferCombinerInPlace<E>
    extends AbstractByteBufferCombiner<E>
    implements CombinerInPlace<E> {
        protected AbstractByteBufferCombinerInPlace(Class<?> elementType, ByteBuffer workStorageForOneElement, MemoryModel memoryModel) {
            super(elementType, workStorageForOneElement, memoryModel);
        }

        @Override
        public abstract E allocateElement();

        protected abstract void loadElementInPlace(E var1);

        @Override
        public final void getInPlace(long index, E resultValue, Array[] storage) {
            storage[0].getData(index * (long)this.elementSize, this.array, 0, this.elementSize);
            if (this.isDirect) {
                this.workStorage.rewind();
                this.workStorage.put(this.array);
            }
            this.loadElementInPlace(resultValue);
        }
    }

    public static abstract class AbstractByteBufferCombiner<E>
    implements Combiner<E> {
        protected final ByteBuffer workStorage;
        final Class<?> elementType;
        final int elementSize;
        final boolean isDirect;
        final byte[] array;
        private final MemoryModel mm;

        protected AbstractByteBufferCombiner(Class<?> elementType, ByteBuffer workStorageForOneElement, MemoryModel memoryModel) {
            Objects.requireNonNull(elementType, "Null elementType");
            if (elementType == Void.TYPE) {
                throw new IllegalArgumentException("Illegal elementType: it cannot be void.class");
            }
            Objects.requireNonNull(workStorageForOneElement, "Null workStorageForOneElement argument");
            if (workStorageForOneElement.isReadOnly()) {
                throw new IllegalArgumentException("Illegal workStorageForOneElement argument: it must not be read-only");
            }
            Objects.requireNonNull(memoryModel, "Null memoryModel argument");
            if (!memoryModel.isElementTypeSupported(Byte.TYPE)) {
                throw new IllegalArgumentException("Illegal memoryModel argument: it must support byte elements");
            }
            this.elementType = elementType;
            this.workStorage = workStorageForOneElement;
            this.elementSize = workStorageForOneElement.limit();
            this.isDirect = !workStorageForOneElement.hasArray();
            this.array = this.isDirect ? new byte[this.elementSize] : workStorageForOneElement.array();
            this.mm = memoryModel;
        }

        protected abstract E loadElement();

        protected abstract void storeElement(E var1);

        @Override
        public final E get(long index, Array[] storage) {
            storage[0].getData(index * (long)this.elementSize, this.array, 0, this.elementSize);
            if (this.isDirect) {
                this.workStorage.rewind();
                this.workStorage.put(this.array);
            }
            return this.loadElement();
        }

        @Override
        public final void set(long index, E value, UpdatableArray[] storage) {
            this.storeElement(value);
            if (this.isDirect) {
                this.workStorage.rewind();
                this.workStorage.get(this.array);
            }
            storage[0].setData(index * (long)this.elementSize, this.array, 0, this.elementSize);
        }

        @Override
        public final UpdatableArray[] allocateStorage(long length, boolean unresizable) {
            if (unresizable) {
                return new UpdatableByteArray[]{this.mm.newUnresizableByteArray(length * (long)this.elementSize)};
            }
            return new MutableByteArray[]{this.mm.newByteArray(length * (long)this.elementSize)};
        }

        @Override
        public final int numbersOfElementsPerOneCombinedElement(int indexOfArrayInStorage) {
            return this.elementSize;
        }
    }

    public static interface BufferedCombiner<E>
    extends Combiner<E> {
        public void get(long var1, E[] var3, int var4, int var5, Array[] var6);

        public void set(long var1, E[] var3, int var4, int var5, UpdatableArray[] var6);
    }
}

