/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.algart.arrays.AbstractThreadPoolFactory;
import net.algart.arrays.Array;
import net.algart.arrays.Arrays;
import net.algart.arrays.InternalUtils;
import net.algart.arrays.ThreadPoolFactory;

public class DefaultThreadPoolFactory
extends AbstractThreadPoolFactory
implements ThreadPoolFactory {
    private static final long MIN_MULTITHREADING_LENGTH = InternalUtils.getLongProperty("net.algart.arrays.minMultithreadingLength", 16L);
    private static final int GLOBAL_THREAD_POOLS_PER_CPU = Math.min(128, Math.max(1, InternalUtils.getIntProperty("net.algart.arrays.globalThreadPoolsPerCPU", 2)));
    private static final int GLOBAL_THREAD_POOL_SIZE = Math.min(8192, InternalUtils.getIntProperty("net.algart.arrays.globalThreadPoolSize", 1 + GLOBAL_THREAD_POOLS_PER_CPU * InternalUtils.availableProcessors()));
    private static final int GLOBAL_THREAD_POOL_KEEP_ALIVE_TIME = Math.max(0, InternalUtils.getIntProperty("net.algart.arrays.globalThreadPoolKeepAliveTime", 30000));
    private final int numberOfTasks;
    private final ThreadPoolExecutor persistentThreadPool;

    public static ThreadPoolExecutor globalThreadPool() {
        return ConstantHolder.GLOBAL_THREAD_POOL;
    }

    public static DefaultThreadPoolFactory getDefaultThreadPoolFactory() {
        return ConstantHolder.DEFAULT;
    }

    public static DefaultThreadPoolFactory getDefaultThreadPoolFactory(int numberOfTasks) {
        if (numberOfTasks == 0) {
            return ConstantHolder.DEFAULT;
        }
        if (numberOfTasks == 1) {
            return ConstantHolder.DEFAULT_SINGLE_THREAD;
        }
        return new DefaultThreadPoolFactory(numberOfTasks, ConstantHolder.GLOBAL_THREAD_POOL);
    }

    public DefaultThreadPoolFactory(int numberOfTasks, ThreadPoolExecutor persistentThreadPool) {
        if (numberOfTasks < 0) {
            throw new IllegalArgumentException("Negative numberOfTasks=" + numberOfTasks);
        }
        this.numberOfTasks = numberOfTasks;
        this.persistentThreadPool = persistentThreadPool;
    }

    @Override
    public int recommendedNumberOfTasks() {
        int corePoolSize;
        int nt;
        int n = nt = this.numberOfTasks != 0 ? this.numberOfTasks : Arrays.SystemSettings.cpuCount();
        if (nt > 1 && this.persistentThreadPool != null && (corePoolSize = Math.max(1, this.persistentThreadPool.getCorePoolSize())) < nt) {
            nt = corePoolSize;
        }
        return nt;
    }

    @Override
    public int recommendedNumberOfTasks(Array sourceArray) {
        Objects.requireNonNull(sourceArray, "Null sourceArray argument");
        if (this.numberOfTasks != 0) {
            return this.recommendedNumberOfTasks();
        }
        long len = sourceArray.length();
        if (len < MIN_MULTITHREADING_LENGTH) {
            return 1;
        }
        return (int)Math.min(len, (long)this.recommendedNumberOfTasks());
    }

    @Override
    public ThreadPoolFactory singleThreadVersion() {
        if (this.numberOfTasks == 1) {
            return this;
        }
        return new DefaultThreadPoolFactory(1, this.persistentThreadPool);
    }

    @Override
    public ExecutorService getThreadPool(ThreadFactory threadFactory) {
        return this.persistentThreadPool != null ? this.persistentThreadPool : Executors.newFixedThreadPool(this.recommendedNumberOfTasks(), threadFactory == null ? Executors.defaultThreadFactory() : threadFactory);
    }

    @Override
    public ExecutorService getThreadPool(Array sourceArray, ThreadFactory threadFactory) {
        Objects.requireNonNull(sourceArray, "Null sourceArray argument");
        return this.persistentThreadPool != null ? this.persistentThreadPool : Executors.newFixedThreadPool(this.recommendedNumberOfTasks(sourceArray), threadFactory == null ? Executors.defaultThreadFactory() : threadFactory);
    }

    @Override
    public void releaseThreadPool(ExecutorService pool) {
        if (this.persistentThreadPool == null) {
            pool.shutdown();
        }
    }

    public final ExecutorService persistentThreadPool() {
        return this.persistentThreadPool;
    }

    private static class ConstantHolder {
        private static final ThreadPoolExecutor GLOBAL_THREAD_POOL;
        private static final DefaultThreadPoolFactory DEFAULT;
        private static final DefaultThreadPoolFactory DEFAULT_SINGLE_THREAD;

        private ConstantHolder() {
        }

        static {
            ThreadPoolExecutor threadPoolExecutor = GLOBAL_THREAD_POOL = GLOBAL_THREAD_POOL_SIZE <= 0 ? null : new ThreadPoolExecutor(GLOBAL_THREAD_POOL_SIZE, GLOBAL_THREAD_POOL_SIZE, (long)GLOBAL_THREAD_POOL_KEEP_ALIVE_TIME, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
                private final AtomicInteger threadNumber = new AtomicInteger(1);

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(r, "AlgART-arrays-thread-" + this.threadNumber.getAndIncrement());
                    t.setDaemon(true);
                    return t;
                }
            });
            if (GLOBAL_THREAD_POOL != null && GLOBAL_THREAD_POOL_KEEP_ALIVE_TIME > 0) {
                GLOBAL_THREAD_POOL.allowCoreThreadTimeOut(true);
            }
            DEFAULT = new DefaultThreadPoolFactory(0, GLOBAL_THREAD_POOL);
            DEFAULT_SINGLE_THREAD = new DefaultThreadPoolFactory(1, GLOBAL_THREAD_POOL);
        }
    }
}

