/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.Objects;
import net.algart.arrays.Arrays;
import net.algart.arrays.DataBuffer;
import net.algart.arrays.DataFloatBuffer;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.MutableFloatArray;
import net.algart.arrays.PFloatingArray;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.arrays.TooLargeArrayException;
import net.algart.arrays.UpdatableFloatArray;

public interface FloatArray
extends PFloatingArray {
    public Class<? extends FloatArray> type();

    public Class<? extends UpdatableFloatArray> updatableType();

    public Class<? extends MutableFloatArray> mutableType();

    public float getFloat(long var1);

    default public float[] newJavaArray(int length) {
        return new float[length];
    }

    public long indexOf(long var1, long var3, float var5);

    public long lastIndexOf(long var1, long var3, float var5);

    @Override
    public DataFloatBuffer buffer(DataBuffer.AccessMode var1, long var2);

    @Override
    public DataFloatBuffer buffer(DataBuffer.AccessMode var1);

    @Override
    public DataFloatBuffer buffer(long var1);

    @Override
    public DataFloatBuffer buffer();

    @Override
    public FloatArray asImmutable();

    @Override
    public FloatArray asTrustedImmutable();

    @Override
    public MutableFloatArray mutableClone(MemoryModel var1);

    @Override
    public UpdatableFloatArray updatableClone(MemoryModel var1);

    default public float[] toJavaArray() {
        long len = this.length();
        if (len != (long)((int)len)) {
            throw new TooLargeArrayException("Cannot convert AlgART array to float[] Java array, because it is too large: " + String.valueOf(this));
        }
        float[] result = this.newJavaArray((int)len);
        this.getData(0L, result);
        return result;
    }

    public float[] ja();

    default public Matrix<? extends FloatArray> matrix(long ... dim) {
        return Matrices.matrix(this, dim);
    }

    @Override
    default public float[] toFloat() {
        return this.toJavaArray();
    }

    @Override
    default public float[] jaFloat() {
        return this.ja();
    }

    public static UpdatableFloatArray newArray(MemoryModel memoryModel, long length) {
        Objects.requireNonNull(memoryModel, "Null memory model");
        return memoryModel.newUnresizableFloatArray(length);
    }

    public static UpdatableFloatArray newArray(long length) {
        return Arrays.SMM.newUnresizableFloatArray(length);
    }

    public static UpdatableFloatArray as(float[] array) {
        return SimpleMemoryModel.asUpdatableFloatArray(array);
    }
}

