/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.Objects;
import net.algart.arrays.Arrays;
import net.algart.arrays.DataBuffer;
import net.algart.arrays.DataIntBuffer;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.MutableIntArray;
import net.algart.arrays.PIntegerArray;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.arrays.TooLargeArrayException;
import net.algart.arrays.UpdatableIntArray;

public interface IntArray
extends PIntegerArray {
    public Class<? extends IntArray> type();

    public Class<? extends UpdatableIntArray> updatableType();

    public Class<? extends MutableIntArray> mutableType();

    @Override
    public int getInt(long var1);

    default public int[] newJavaArray(int length) {
        return new int[length];
    }

    public long indexOf(long var1, long var3, int var5);

    public long lastIndexOf(long var1, long var3, int var5);

    @Override
    public DataIntBuffer buffer(DataBuffer.AccessMode var1, long var2);

    @Override
    public DataIntBuffer buffer(DataBuffer.AccessMode var1);

    @Override
    public DataIntBuffer buffer(long var1);

    @Override
    public DataIntBuffer buffer();

    @Override
    public IntArray asImmutable();

    @Override
    public IntArray asTrustedImmutable();

    @Override
    public MutableIntArray mutableClone(MemoryModel var1);

    @Override
    public UpdatableIntArray updatableClone(MemoryModel var1);

    default public int[] toJavaArray() {
        long len = this.length();
        if (len != (long)((int)len)) {
            throw new TooLargeArrayException("Cannot convert AlgART array to int[] Java array, because it is too large: " + String.valueOf(this));
        }
        int[] result = this.newJavaArray((int)len);
        this.getData(0L, result);
        return result;
    }

    public int[] ja();

    default public Matrix<? extends IntArray> matrix(long ... dim) {
        return Matrices.matrix(this, dim);
    }

    @Override
    default public int[] toInt() {
        return this.toJavaArray();
    }

    @Override
    default public int[] jaInt() {
        return this.ja();
    }

    public static UpdatableIntArray newArray(MemoryModel memoryModel, long length) {
        Objects.requireNonNull(memoryModel, "Null memory model");
        return memoryModel.newUnresizableIntArray(length);
    }

    public static UpdatableIntArray newArray(long length) {
        return Arrays.SMM.newUnresizableIntArray(length);
    }

    public static UpdatableIntArray as(int[] array) {
        return SimpleMemoryModel.asUpdatableIntArray(array);
    }
}

