/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.algart.arrays.AbstractArray;
import net.algart.arrays.AbstractMatrix;
import net.algart.arrays.Array;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.Arrays;
import net.algart.arrays.ArraysFuncImpl;
import net.algart.arrays.ArraysInterpolationsImpl;
import net.algart.arrays.ArraysMatrixRegionCopier;
import net.algart.arrays.ArraysMatrixResizer;
import net.algart.arrays.ArraysPolylinearInterpolationsImpl;
import net.algart.arrays.ArraysSubMatrixCopier;
import net.algart.arrays.BitArray;
import net.algart.arrays.ByteArray;
import net.algart.arrays.CharArray;
import net.algart.arrays.DegeneratedSimplexException;
import net.algart.arrays.DoubleArray;
import net.algart.arrays.FloatArray;
import net.algart.arrays.IntArray;
import net.algart.arrays.InterleavingBandsPacker;
import net.algart.arrays.InterleavingBandsUnpacker;
import net.algart.arrays.InternalUtils;
import net.algart.arrays.JArrays;
import net.algart.arrays.LongArray;
import net.algart.arrays.Matrix;
import net.algart.arrays.MatrixImpl;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.MutableArray;
import net.algart.arrays.PArray;
import net.algart.arrays.ShortArray;
import net.algart.arrays.SizeMismatchException;
import net.algart.arrays.UpdatableArray;
import net.algart.arrays.UpdatableBitArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.math.IRange;
import net.algart.math.functions.ConstantFunc;
import net.algart.math.functions.Func;

public class Matrices {
    private static final double INVERTED_MEGABYTE = 9.5367431640625E-7;

    private Matrices() {
    }

    public static <T extends Array> Matrix<T> matrix(T array, long ... dim) {
        return new MatrixImpl<T>(array, dim);
    }

    public static <T extends Array> Matrix<T> matrixAtSubArray(T array, long position, long ... dim) {
        if (array != null && dim != null) {
            if (position < 0L || position > array.length()) {
                throw new IndexOutOfBoundsException("Illegal position = " + position + " (must be in range 0.." + array.length() + ")");
            }
            long correctLen = AbstractMatrix.checkDimensions(dim = (long[])dim.clone());
            if (correctLen > array.length() - position) {
                throw new SizeMismatchException("Dimensions are too large for the given position and length: dim[0] * dim[1] * ... = " + correctLen + ", which is greater than the array length " + array.length() + " + position " + position);
            }
            array = (Array)InternalUtils.cast(array.subArr(position, correctLen));
        }
        return new MatrixImpl<T>(array, dim);
    }

    public static <T extends Array> void checkNewMatrixType(Class<T> arraySupertype, Class<?> elementType) {
        Objects.requireNonNull(arraySupertype, "Null arraySupertype argument");
        Arrays.checkElementTypeForNullAndVoid(elementType);
        if (MutableArray.class.isAssignableFrom(arraySupertype)) {
            throw new IllegalArgumentException("Illegal arraySupertype = " + String.valueOf(arraySupertype) + ": it is MutableArray or its subtype, but a matrix cannot be based on a resizable array");
        }
        Class<UpdatableArray> type = Arrays.type(UpdatableArray.class, elementType);
        if (!arraySupertype.isAssignableFrom(type)) {
            throw new ClassCastException("The passed array supertype " + arraySupertype.getName() + " is not a supertype for " + type.getName());
        }
    }

    public static long sizeOf(Matrix<?> matrix) {
        Objects.requireNonNull(matrix, "Null matrix argument");
        return Arrays.sizeOf(matrix.array());
    }

    public static double sizeOfMB(Matrix<?> matrix) {
        return (double)Matrices.sizeOf(matrix) * 9.5367431640625E-7;
    }

    public static double sizeOf(Collection<? extends Matrix<?>> matrices) {
        Objects.requireNonNull(matrices, "Null matrices argument");
        double result = 0.0;
        for (Matrix<?> matrix : matrices) {
            result += (double)Matrices.sizeOf(matrix);
        }
        return result;
    }

    public static double sizeOfMB(Collection<? extends Matrix<?>> matrices) {
        return Matrices.sizeOf(matrices) * 9.5367431640625E-7;
    }

    public static long[] defaultTileDimensions(int dimCount) {
        if (dimCount <= 0) {
            throw new IllegalArgumentException("Zero or negative number of dimensions");
        }
        long[] result = new long[dimCount];
        long defaultTileSide = InternalUtils.DEFAULT_MATRIX_TILE_SIDES[Math.min(result.length, InternalUtils.DEFAULT_MATRIX_TILE_SIDES.length - 1)];
        java.util.Arrays.fill(result, defaultTileSide);
        return result;
    }

    public static <T extends Array> List<Matrix<? extends T>> several(Class<T> arrayClass, Matrix<?> ... matrices) {
        Objects.requireNonNull(arrayClass, "Null arrayClass argument");
        if (matrices.length == 0) {
            return Collections.emptyList();
        }
        matrices = (Matrix[])matrices.clone();
        for (int k = 0; k < matrices.length; ++k) {
            Objects.requireNonNull(matrices[k], "Null matrices[" + k + "] argument");
            if (arrayClass.isInstance(matrices[k].array())) continue;
            throw new ClassCastException("Illegal type of matrices[" + k + "] argument (" + String.valueOf(matrices[k]) + "; required array class is " + arrayClass.getName() + ")");
        }
        Matrix[] cast = (Matrix[])InternalUtils.cast(matrices);
        return java.util.Arrays.asList(cast);
    }

    public static <T extends Array> T[] arraysOfParallelMatrices(Class<T> arrayClass, List<? extends Matrix<?>> matrices) {
        return Matrices.arraysOfParallelMatrices(arrayClass, matrices, (boolean)false);
    }

    public static <T extends Array> T[] arraysOfParallelMatrices(Class<T> arrayClass, Collection<? extends Matrix<?>> matrices, boolean requireIdenticalType) {
        Objects.requireNonNull(arrayClass, "Null arrayClass argument");
        Objects.requireNonNull(matrices, "Null list of matrices");
        matrices = new ArrayList(matrices);
        Matrix<?> m0 = null;
        Class<?> elementType = null;
        int k = 0;
        Array[] result = (Array[])InternalUtils.cast(java.lang.reflect.Array.newInstance(arrayClass, matrices.size()));
        for (Matrix<?> m : matrices) {
            Objects.requireNonNull(m, "Null matrix #" + k);
            if (!arrayClass.isInstance(m.array())) {
                throw new ClassCastException("Illegal type of the matrix #" + k + " (" + String.valueOf(m) + "; required array class is " + arrayClass.getName() + ")");
            }
            if (m0 == null) {
                m0 = m;
                elementType = m.elementType();
            } else {
                if (requireIdenticalType && m.elementType() != elementType) {
                    throw new IllegalArgumentException("The matrix #" + k + " and the matrix #0 element type mismatch: the matrix #" + k + " has " + String.valueOf(m.elementType()) + " elements, the matrix #0 has " + String.valueOf(elementType) + " elements");
                }
                if (!m.dimEquals(m0)) {
                    throw new SizeMismatchException("The matrix #" + k + " and the matrix #0 dimensions mismatch: the matrix #" + k + " is " + String.valueOf(m) + ", the matrix #0 is " + String.valueOf(m0));
                }
            }
            result[k] = (Array)InternalUtils.cast(m.array());
            ++k;
        }
        return result;
    }

    public static <R extends Array, T extends Array> List<Matrix<R>> apply(Function<? super Matrix<T>, ? extends Matrix<R>> function, Collection<? extends Matrix<? extends T>> channels) {
        Objects.requireNonNull(function, "Null function argument");
        Objects.requireNonNull(channels, "Null list of channels");
        Matrices.checkDimensionEquality(channels);
        ArrayList<Matrix<R>> result = new ArrayList<Matrix<R>>();
        for (Matrix<T> channel : channels) {
            MatrixImpl<T> castChannel = new MatrixImpl<T>(channel.array(), channel.dimensions());
            Matrix<R> applied = function.apply(castChannel);
            result.add(applied);
        }
        return result;
    }

    public static void separate(List<? extends Matrix<? extends UpdatablePArray>> result, Matrix<? extends PArray> interleaved) {
        Matrices.separate(null, result, interleaved);
    }

    public static void separate(ArrayContext context, List<? extends Matrix<? extends UpdatablePArray>> result, Matrix<? extends PArray> interleaved) {
        Objects.requireNonNull(result, "Null result list");
        Objects.requireNonNull(interleaved, "Null interleaved matrix");
        if (context == null) {
            context = ArrayContext.DEFAULT_SINGLE_THREAD;
        }
        UpdatablePArray[] arrays = (UpdatablePArray[])Matrices.arraysOfParallelMatrices(UpdatablePArray.class, result, (boolean)true);
        Matrices.checkDimensionEqualityWithInterleaving(interleaved, result);
        if (arrays.length > 0) {
            try (InterleavingBandsUnpacker unpacker = InterleavingBandsUnpacker.getInstance(context, arrays, interleaved.array());){
                unpacker.process();
            }
        }
    }

    public static <T extends PArray> List<Matrix<T>> separate(Matrix<? extends T> interleaved) {
        return Matrices.separate((ArrayContext)null, interleaved);
    }

    public static <T extends PArray> List<Matrix<T>> separate(ArrayContext context, Matrix<? extends T> interleaved) {
        return Matrices.separate(context, interleaved, Integer.MAX_VALUE);
    }

    public static <T extends PArray> List<Matrix<T>> separate(Matrix<? extends T> interleaved, int limit) {
        return Matrices.separate(null, interleaved, limit);
    }

    public static <T extends PArray> List<Matrix<T>> separate(ArrayContext context, Matrix<? extends T> interleaved, int limit) {
        Objects.requireNonNull(interleaved, "Null interleaved matrix");
        if (context == null) {
            context = ArrayContext.DEFAULT_SINGLE_THREAD;
        }
        long[] dimensions = interleaved.dimensions();
        long numberOfMatrices = Matrices.numberOfChannels(dimensions, false, limit);
        long[] reducedDimensions = java.util.Arrays.copyOfRange(dimensions, 1, dimensions.length);
        MemoryModel mm = context.getMemoryModel();
        Class<?> elementType = interleaved.elementType();
        UpdatablePArray[] arrays = new UpdatablePArray[(int)numberOfMatrices];
        ArrayList<Matrix<T>> result = new ArrayList<Matrix<T>>();
        if (numberOfMatrices > 0L) {
            int k = 0;
            while ((long)k < numberOfMatrices) {
                Matrix<UpdatablePArray> m = mm.newMatrix(UpdatablePArray.class, elementType, reducedDimensions);
                arrays[k] = m.array();
                result.add((Matrix)InternalUtils.cast(m));
                ++k;
            }
            try (InterleavingBandsUnpacker unpacker = InterleavingBandsUnpacker.getInstance(context, arrays, (PArray)interleaved.array());){
                unpacker.process();
            }
        }
        return result;
    }

    public static void interleave(Matrix<? extends UpdatablePArray> result, List<? extends Matrix<? extends PArray>> separated) {
        Matrices.interleave(null, result, separated);
    }

    public static void interleave(ArrayContext context, Matrix<? extends UpdatablePArray> result, List<? extends Matrix<? extends PArray>> separated) {
        ArrayList<? extends Matrix<? extends PArray>> list;
        Objects.requireNonNull(result, "Null result argument");
        Objects.requireNonNull(separated, "Null separated argument");
        if (context == null) {
            context = ArrayContext.DEFAULT_SINGLE_THREAD;
        }
        if ((list = new ArrayList<Matrix<? extends PArray>>(separated)).isEmpty()) {
            throw new IllegalArgumentException("Empty separated matrix list");
        }
        PArray[] arrays = (PArray[])Matrices.arraysOfParallelMatrices(PArray.class, list, (boolean)true);
        assert (arrays.length > 0);
        Matrices.checkDimensionEqualityWithInterleaving(result, separated);
        try (InterleavingBandsPacker packer = InterleavingBandsPacker.getInstance(context, arrays, result.array());){
            packer.process();
        }
    }

    public static <T extends PArray> Matrix<T> interleave(List<? extends Matrix<? extends T>> separated) {
        return Matrices.interleave((ArrayContext)null, separated);
    }

    public static <T extends PArray> Matrix<T> interleave(ArrayContext context, List<? extends Matrix<? extends T>> separated) {
        ArrayList<Matrix<T>> list;
        Objects.requireNonNull(separated, "Null separated argument");
        if (context == null) {
            context = ArrayContext.DEFAULT_SINGLE_THREAD;
        }
        if ((list = new ArrayList<Matrix<T>>(separated)).isEmpty()) {
            throw new IllegalArgumentException("Empty separated matrix list");
        }
        PArray[] arrays = (PArray[])Matrices.arraysOfParallelMatrices(PArray.class, list, (boolean)true);
        Matrix m0 = (Matrix)list.get(0);
        long[] dimensions = new long[m0.dimCount() + 1];
        System.arraycopy(m0.dimensions(), 0, dimensions, 1, dimensions.length - 1);
        dimensions[0] = arrays.length;
        MemoryModel mm = context.getMemoryModel();
        Matrix<UpdatablePArray> result = mm.newMatrix(UpdatablePArray.class, m0.elementType(), dimensions);
        try (InterleavingBandsPacker packer = InterleavingBandsPacker.getInstance(context, arrays, result.array());){
            packer.process();
        }
        return (Matrix)InternalUtils.cast(result);
    }

    public static <T extends Array> List<Matrix<T>> asLayers(Matrix<T> merged) {
        return Matrices.asLayers(merged, Integer.MAX_VALUE);
    }

    public static <T extends Array> List<Matrix<T>> asLayers(Matrix<T> merged, int limit) {
        Objects.requireNonNull(merged, "Null merged matrix");
        long[] dimensions = merged.dimensions();
        int numberOfMatrices = Matrices.numberOfChannels(dimensions, true, limit);
        long[] reducedDimensions = java.util.Arrays.copyOf(dimensions, dimensions.length - 1);
        long size = Arrays.longMul(reducedDimensions);
        T array = merged.array();
        ArrayList<Matrix<T>> result = new ArrayList<Matrix<T>>();
        long p = 0L;
        int k = 0;
        while (k < numberOfMatrices) {
            Array subArray = (Array)InternalUtils.cast(array.subArr(p, size));
            result.add(Matrices.matrix(subArray, reducedDimensions));
            ++k;
            p += size;
        }
        return result;
    }

    public static <T extends Array> Matrix<T> mergeLayers(List<? extends Matrix<? extends T>> matrices) {
        return Matrices.mergeLayers(Arrays.SMM, matrices);
    }

    public static <T extends Array> Matrix<T> mergeLayers(MemoryModel memoryModel, List<? extends Matrix<? extends T>> matrices) {
        Objects.requireNonNull(memoryModel, "Null memory model");
        Objects.requireNonNull(matrices, "Null matrices argument");
        ArrayList<Matrix<T>> list = new ArrayList<Matrix<T>>(matrices);
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Empty matrices list");
        }
        Array[] arrays = Matrices.arraysOfParallelMatrices(Array.class, list, (boolean)true);
        Matrix m0 = (Matrix)list.get(0);
        long[] dimensions = java.util.Arrays.copyOf(m0.dimensions(), m0.dimCount() + 1);
        dimensions[dimensions.length - 1] = arrays.length;
        long size = m0.size();
        Matrix<UpdatableArray> result = memoryModel.newMatrix(UpdatableArray.class, m0.elementType(), dimensions);
        UpdatableArray array = result.array();
        long p = 0L;
        for (Matrix matrix : list) {
            array.subArr(p, size).copy((Array)matrix.array());
            p += size;
        }
        return (Matrix)InternalUtils.cast(result);
    }

    public static void checkDimensionEquality(Collection<? extends Matrix<?>> matrices, boolean requireIdenticalType) {
        Objects.requireNonNull(matrices, "Null list of matrices");
        Matrix<?> m0 = null;
        Class<?> elementType = null;
        int k = 0;
        for (Matrix<?> m : matrices) {
            Objects.requireNonNull(m, "Null matrix #" + k);
            if (m0 == null) {
                m0 = m;
                elementType = m.elementType();
            } else {
                if (requireIdenticalType && m.elementType() != elementType) {
                    throw new IllegalArgumentException("The matrix #" + k + " and the matrix #0 element type mismatch: the matrix #" + k + " has " + String.valueOf(m.elementType()) + " elements, the matrix #0 has " + String.valueOf(elementType) + " elements");
                }
                if (!m.dimEquals(m0)) {
                    throw new SizeMismatchException("The matrix #" + k + " and the matrix #0 dimensions mismatch: the matrix #" + k + " is " + String.valueOf(m) + ", the matrix #0 is " + String.valueOf(m0));
                }
            }
            ++k;
        }
    }

    public static void checkDimensionEquality(Collection<? extends Matrix<?>> matrices) {
        Matrices.checkDimensionEquality(matrices, false);
    }

    public static void checkDimensionEquality(Matrix<?> ... matrices) {
        Objects.requireNonNull(matrices, "Null array of matrices");
        for (int k = 0; k < matrices.length; ++k) {
            Objects.requireNonNull(matrices[k], "Null matrix #" + k);
            if (k <= 0 || matrices[k].dimEquals(matrices[0])) continue;
            throw new SizeMismatchException("The matrix #" + k + " and the matrix #0 dimensions mismatch: the matrix #" + k + " is " + String.valueOf(matrices[k]) + ", the matrix #0 is " + String.valueOf(matrices[0]));
        }
    }

    public static Func asInterpolationFunc(Matrix<? extends PArray> matrix, InterpolationMethod interpolationMethod, boolean checkRanges) {
        Objects.requireNonNull(matrix, "Null matrix argument");
        Objects.requireNonNull(interpolationMethod, "Null interpolationMethod argument");
        PArray a = matrix.array();
        switch (interpolationMethod.ordinal()) {
            case 0: {
                if (checkRanges) {
                    if (Arrays.javaArrayInternal(a) != null && a.length() < Integer.MAX_VALUE) {
                        if (a instanceof ByteArray) {
                            return new ArraysInterpolationsImpl.CheckedTrivialByteInterpolation(matrix);
                        }
                        if (a instanceof CharArray) {
                            return new ArraysInterpolationsImpl.CheckedTrivialCharInterpolation(matrix);
                        }
                        if (a instanceof ShortArray) {
                            return new ArraysInterpolationsImpl.CheckedTrivialShortInterpolation(matrix);
                        }
                        if (a instanceof IntArray) {
                            return new ArraysInterpolationsImpl.CheckedTrivialIntInterpolation(matrix);
                        }
                        if (a instanceof LongArray) {
                            return new ArraysInterpolationsImpl.CheckedTrivialLongInterpolation(matrix);
                        }
                        if (a instanceof FloatArray) {
                            return new ArraysInterpolationsImpl.CheckedTrivialFloatInterpolation(matrix);
                        }
                        if (a instanceof DoubleArray) {
                            return new ArraysInterpolationsImpl.CheckedTrivialDoubleInterpolation(matrix);
                        }
                        return new ArraysInterpolationsImpl.CheckedTrivialInterpolation(matrix);
                    }
                    return new ArraysInterpolationsImpl.CheckedTrivialInterpolation(matrix);
                }
                if (Arrays.javaArrayInternal(a) != null && a.length() < Integer.MAX_VALUE) {
                    if (a instanceof ByteArray) {
                        return new ArraysInterpolationsImpl.UncheckedTrivialByteInterpolation(matrix);
                    }
                    if (a instanceof CharArray) {
                        return new ArraysInterpolationsImpl.UncheckedTrivialCharInterpolation(matrix);
                    }
                    if (a instanceof ShortArray) {
                        return new ArraysInterpolationsImpl.UncheckedTrivialShortInterpolation(matrix);
                    }
                    if (a instanceof IntArray) {
                        return new ArraysInterpolationsImpl.UncheckedTrivialIntInterpolation(matrix);
                    }
                    if (a instanceof LongArray) {
                        return new ArraysInterpolationsImpl.UncheckedTrivialLongInterpolation(matrix);
                    }
                    if (a instanceof FloatArray) {
                        return new ArraysInterpolationsImpl.UncheckedTrivialFloatInterpolation(matrix);
                    }
                    if (a instanceof DoubleArray) {
                        return new ArraysInterpolationsImpl.UncheckedTrivialDoubleInterpolation(matrix);
                    }
                    return new ArraysInterpolationsImpl.UncheckedTrivialInterpolation(matrix);
                }
                return new ArraysInterpolationsImpl.UncheckedTrivialInterpolation(matrix);
            }
            case 1: {
                if (checkRanges) {
                    if (Arrays.javaArrayInternal(a) != null && a.length() < Integer.MAX_VALUE) {
                        if (a instanceof ByteArray) {
                            return new ArraysPolylinearInterpolationsImpl.CheckedPolylinearByteInterpolation(matrix);
                        }
                        if (a instanceof CharArray) {
                            return new ArraysPolylinearInterpolationsImpl.CheckedPolylinearCharInterpolation(matrix);
                        }
                        if (a instanceof ShortArray) {
                            return new ArraysPolylinearInterpolationsImpl.CheckedPolylinearShortInterpolation(matrix);
                        }
                        if (a instanceof IntArray) {
                            return new ArraysPolylinearInterpolationsImpl.CheckedPolylinearIntInterpolation(matrix);
                        }
                        if (a instanceof LongArray) {
                            return new ArraysPolylinearInterpolationsImpl.CheckedPolylinearLongInterpolation(matrix);
                        }
                        if (a instanceof FloatArray) {
                            return new ArraysPolylinearInterpolationsImpl.CheckedPolylinearFloatInterpolation(matrix);
                        }
                        if (a instanceof DoubleArray) {
                            return new ArraysPolylinearInterpolationsImpl.CheckedPolylinearDoubleInterpolation(matrix);
                        }
                        return new ArraysPolylinearInterpolationsImpl.CheckedPolylinearInterpolation(matrix);
                    }
                    return new ArraysPolylinearInterpolationsImpl.CheckedPolylinearInterpolation(matrix);
                }
                if (Arrays.javaArrayInternal(a) != null && a.length() < Integer.MAX_VALUE) {
                    if (a instanceof ByteArray) {
                        return new ArraysPolylinearInterpolationsImpl.UncheckedPolylinearByteInterpolation(matrix);
                    }
                    if (a instanceof CharArray) {
                        return new ArraysPolylinearInterpolationsImpl.UncheckedPolylinearCharInterpolation(matrix);
                    }
                    if (a instanceof ShortArray) {
                        return new ArraysPolylinearInterpolationsImpl.UncheckedPolylinearShortInterpolation(matrix);
                    }
                    if (a instanceof IntArray) {
                        return new ArraysPolylinearInterpolationsImpl.UncheckedPolylinearIntInterpolation(matrix);
                    }
                    if (a instanceof LongArray) {
                        return new ArraysPolylinearInterpolationsImpl.UncheckedPolylinearLongInterpolation(matrix);
                    }
                    if (a instanceof FloatArray) {
                        return new ArraysPolylinearInterpolationsImpl.UncheckedPolylinearFloatInterpolation(matrix);
                    }
                    if (a instanceof DoubleArray) {
                        return new ArraysPolylinearInterpolationsImpl.UncheckedPolylinearDoubleInterpolation(matrix);
                    }
                    return new ArraysPolylinearInterpolationsImpl.UncheckedPolylinearInterpolation(matrix);
                }
                return new ArraysPolylinearInterpolationsImpl.UncheckedPolylinearInterpolation(matrix);
            }
        }
        throw new InternalError("Impossible switch case");
    }

    public static Func asInterpolationFunc(Matrix<? extends PArray> matrix, InterpolationMethod interpolationMethod, double outsideValue) {
        Objects.requireNonNull(matrix, "Null matrix argument");
        Objects.requireNonNull(interpolationMethod, "Null interpolationMethod argument");
        PArray a = matrix.array();
        switch (interpolationMethod.ordinal()) {
            case 0: {
                if (Arrays.javaArrayInternal(a) != null && a.length() < Integer.MAX_VALUE) {
                    if (a instanceof ByteArray) {
                        return new ArraysInterpolationsImpl.ContinuedTrivialByteInterpolation(matrix, outsideValue);
                    }
                    if (a instanceof CharArray) {
                        return new ArraysInterpolationsImpl.ContinuedTrivialCharInterpolation(matrix, outsideValue);
                    }
                    if (a instanceof ShortArray) {
                        return new ArraysInterpolationsImpl.ContinuedTrivialShortInterpolation(matrix, outsideValue);
                    }
                    if (a instanceof IntArray) {
                        return new ArraysInterpolationsImpl.ContinuedTrivialIntInterpolation(matrix, outsideValue);
                    }
                    if (a instanceof LongArray) {
                        return new ArraysInterpolationsImpl.ContinuedTrivialLongInterpolation(matrix, outsideValue);
                    }
                    if (a instanceof FloatArray) {
                        return new ArraysInterpolationsImpl.ContinuedTrivialFloatInterpolation(matrix, outsideValue);
                    }
                    if (a instanceof DoubleArray) {
                        return new ArraysInterpolationsImpl.ContinuedTrivialDoubleInterpolation(matrix, outsideValue);
                    }
                    return new ArraysInterpolationsImpl.ContinuedTrivialInterpolation(matrix, outsideValue);
                }
                return new ArraysInterpolationsImpl.ContinuedTrivialInterpolation(matrix, outsideValue);
            }
            case 1: {
                if (Arrays.javaArrayInternal(a) != null && a.length() < Integer.MAX_VALUE) {
                    if (a instanceof ByteArray) {
                        return new ArraysPolylinearInterpolationsImpl.ContinuedPolylinearByteInterpolation(matrix, outsideValue);
                    }
                    if (a instanceof CharArray) {
                        return new ArraysPolylinearInterpolationsImpl.ContinuedPolylinearCharInterpolation(matrix, outsideValue);
                    }
                    if (a instanceof ShortArray) {
                        return new ArraysPolylinearInterpolationsImpl.ContinuedPolylinearShortInterpolation(matrix, outsideValue);
                    }
                    if (a instanceof IntArray) {
                        return new ArraysPolylinearInterpolationsImpl.ContinuedPolylinearIntInterpolation(matrix, outsideValue);
                    }
                    if (a instanceof LongArray) {
                        return new ArraysPolylinearInterpolationsImpl.ContinuedPolylinearLongInterpolation(matrix, outsideValue);
                    }
                    if (a instanceof FloatArray) {
                        return new ArraysPolylinearInterpolationsImpl.ContinuedPolylinearFloatInterpolation(matrix, outsideValue);
                    }
                    if (a instanceof DoubleArray) {
                        return new ArraysPolylinearInterpolationsImpl.ContinuedPolylinearDoubleInterpolation(matrix, outsideValue);
                    }
                    return new ArraysPolylinearInterpolationsImpl.ContinuedPolylinearInterpolation(matrix, outsideValue);
                }
                return new ArraysPolylinearInterpolationsImpl.ContinuedPolylinearInterpolation(matrix, outsideValue);
            }
        }
        throw new InternalError("Impossible switch case");
    }

    public static boolean isInterpolationFunc(Func f) {
        return f instanceof ArraysInterpolationsImpl.AbstractInterpolation;
    }

    public static boolean isOnlyInsideInterpolationFunc(Func f) {
        return f instanceof ArraysInterpolationsImpl.AbstractInterpolation && ((ArraysInterpolationsImpl.AbstractInterpolation)f).isChecked() != null;
    }

    public static boolean isCheckedOnlyInsideInterpolationFunc(Func f) {
        Boolean v;
        return f instanceof ArraysInterpolationsImpl.AbstractInterpolation && (v = ((ArraysInterpolationsImpl.AbstractInterpolation)f).isChecked()) != null && v != false;
    }

    public static boolean isContinuedInterpolationFunc(Func f) {
        return f instanceof ArraysInterpolationsImpl.AbstractInterpolation && ((ArraysInterpolationsImpl.AbstractInterpolation)f).outsideValue() != null;
    }

    public static Matrix<? extends PArray> getUnderlyingMatrix(Func f) {
        Objects.requireNonNull(f, "Null f argument");
        if (!Matrices.isInterpolationFunc(f)) {
            throw new IllegalArgumentException("The passed function is not a view of a matrix");
        }
        return ((ArraysInterpolationsImpl.AbstractInterpolation)f).m;
    }

    public static double getOutsideValue(Func f) {
        Objects.requireNonNull(f, "Null f argument");
        if (!Matrices.isInterpolationFunc(f)) {
            throw new IllegalArgumentException("The passed function is not a view of a matrix");
        }
        if (!Matrices.isContinuedInterpolationFunc(f)) {
            throw new IllegalArgumentException("The passed interpolation function isn't continued outside the matrix");
        }
        return ((ArraysInterpolationsImpl.AbstractInterpolation)f).outsideValue();
    }

    public static InterpolationMethod getInterpolationMethod(Func f) {
        Objects.requireNonNull(f, "Null f argument");
        if (!Matrices.isInterpolationFunc(f)) {
            throw new IllegalArgumentException("The passed function is not a view of a matrix");
        }
        return ((ArraysInterpolationsImpl.AbstractInterpolation)f).getInterpolationMethod();
    }

    public static <T extends PArray> Matrix<T> constantMatrix(double constant, Class<? extends T> requiredType, long ... dim) {
        return Matrices.asCoordFuncMatrix(true, ConstantFunc.getInstance(constant), requiredType, dim);
    }

    public static <T extends PArray> Matrix<T> asCoordFuncMatrix(Func f, Class<? extends T> requiredType, long ... dim) {
        return Matrices.asCoordFuncMatrix(true, f, requiredType, dim);
    }

    public static <T extends PArray> Matrix<T> asCoordFuncMatrix(boolean truncateOverflows, Func f, Class<? extends T> requiredType, long ... dim) {
        dim = (long[])dim.clone();
        T array = ArraysFuncImpl.asCoordFuncMatrix(truncateOverflows, f, requiredType, dim);
        return Matrices.matrix(array, dim);
    }

    public static boolean isCoordFuncMatrix(Matrix<? extends PArray> matrix) {
        return matrix != null && Arrays.isIndexFuncArray(matrix.array());
    }

    public static <T extends PArray> Matrix<T> asFuncMatrix(Func f, Class<? extends T> requiredType, Matrix<? extends PArray> x) {
        return Matrices.asFuncMatrix(f, requiredType, Matrices.several(PArray.class, x));
    }

    public static <T extends PArray> Matrix<T> asFuncMatrix(boolean truncateOverflows, Func f, Class<? extends T> requiredType, Matrix<? extends PArray> x) {
        return Matrices.asFuncMatrix(truncateOverflows, f, requiredType, Matrices.several(PArray.class, x));
    }

    public static <T extends PArray> Matrix<T> asFuncMatrix(Func f, Class<? extends T> requiredType, Matrix<? extends PArray> x1, Matrix<? extends PArray> x2) {
        return Matrices.asFuncMatrix(f, requiredType, Matrices.several(PArray.class, x1, x2));
    }

    public static <T extends PArray> Matrix<T> asFuncMatrix(boolean truncateOverflows, Func f, Class<? extends T> requiredType, Matrix<? extends PArray> x1, Matrix<? extends PArray> x2) {
        return Matrices.asFuncMatrix(truncateOverflows, f, requiredType, Matrices.several(PArray.class, x1, x2));
    }

    public static <T extends PArray> Matrix<T> asFuncMatrix(Func f, Class<? extends T> requiredType, Matrix<? extends PArray> x1, Matrix<? extends PArray> x2, Matrix<? extends PArray> x3) {
        return Matrices.asFuncMatrix(f, requiredType, Matrices.several(PArray.class, x1, x2, x3));
    }

    public static <T extends PArray> Matrix<T> asFuncMatrix(boolean truncateOverflows, Func f, Class<? extends T> requiredType, Matrix<? extends PArray> x1, Matrix<? extends PArray> x2, Matrix<? extends PArray> x3) {
        return Matrices.asFuncMatrix(truncateOverflows, f, requiredType, Matrices.several(PArray.class, x1, x2, x3));
    }

    public static <T extends PArray> Matrix<T> asFuncMatrix(Func f, Class<? extends T> requiredType, Matrix<? extends PArray> x1, Matrix<? extends PArray> x2, Matrix<? extends PArray> x3, Matrix<? extends PArray> x4) {
        return Matrices.asFuncMatrix(f, requiredType, Matrices.several(PArray.class, x1, x2, x3, x4));
    }

    public static <T extends PArray> Matrix<T> asFuncMatrix(boolean truncateOverflows, Func f, Class<? extends T> requiredType, Matrix<? extends PArray> x1, Matrix<? extends PArray> x2, Matrix<? extends PArray> x3, Matrix<? extends PArray> x4) {
        return Matrices.asFuncMatrix(truncateOverflows, f, requiredType, Matrices.several(PArray.class, x1, x2, x3, x4));
    }

    public static <T extends PArray> Matrix<T> asFuncMatrix(Func f, Class<? extends T> requiredType, List<? extends Matrix<? extends PArray>> x) {
        return Matrices.asFuncMatrix(true, f, requiredType, x);
    }

    public static <T extends PArray> Matrix<T> asFuncMatrix(boolean truncateOverflows, Func f, Class<? extends T> requiredType, List<? extends Matrix<? extends PArray>> x) {
        PArray[] arrays = (PArray[])Matrices.arraysOfParallelMatrices(PArray.class, x);
        if (arrays.length == 0) {
            throw new IllegalArgumentException("Empty x (list of AlgART matrices)");
        }
        return x.get(0).matrix(Arrays.asFuncArray(truncateOverflows, f, requiredType, arrays));
    }

    public static <T extends UpdatablePArray> Matrix<T> asUpdatableFuncMatrix(Func.Updatable f, Class<? extends T> requiredType, Matrix<? extends UpdatablePArray> x) {
        return Matrices.asUpdatableFuncMatrix(true, f, requiredType, x);
    }

    public static <T extends UpdatablePArray> Matrix<T> asUpdatableFuncMatrix(boolean truncateOverflows, Func.Updatable f, Class<? extends T> requiredType, Matrix<? extends UpdatablePArray> x) {
        return x.matrix(Arrays.asUpdatableFuncArray(truncateOverflows, f, requiredType, x.array()));
    }

    public static void applyFunc(Func f, Matrix<? extends UpdatablePArray> result, Matrix<? extends PArray> x) {
        Matrices.applyFunc(null, f, result, x);
    }

    public static void applyFunc(ArrayContext context, Func f, Matrix<? extends UpdatablePArray> result, Matrix<? extends PArray> x) {
        Matrices.applyFunc(context, true, f, result, x);
    }

    public static void applyFunc(ArrayContext context, boolean truncateOverflows, Func f, Matrix<? extends UpdatablePArray> result, Matrix<? extends PArray> x) {
        Matrices.applyFunc(context, truncateOverflows, f, result, Matrices.several(PArray.class, x));
    }

    public static void applyFunc(Func f, Matrix<? extends UpdatablePArray> result, Matrix<? extends PArray> x1, Matrix<? extends PArray> x2) {
        Matrices.applyFunc(null, f, result, x1, x2);
    }

    public static void applyFunc(ArrayContext context, Func f, Matrix<? extends UpdatablePArray> result, Matrix<? extends PArray> x1, Matrix<? extends PArray> x2) {
        Matrices.applyFunc(context, true, f, result, x1, x2);
    }

    public static void applyFunc(ArrayContext context, boolean truncateOverflows, Func f, Matrix<? extends UpdatablePArray> result, Matrix<? extends PArray> x1, Matrix<? extends PArray> x2) {
        Matrices.applyFunc(context, truncateOverflows, f, result, Matrices.several(PArray.class, x1, x2));
    }

    public static void applyFunc(Func f, Matrix<? extends UpdatablePArray> result, Matrix<? extends PArray> x1, Matrix<? extends PArray> x2, Matrix<? extends PArray> x3) {
        Matrices.applyFunc(null, f, result, x1, x2, x3);
    }

    public static void applyFunc(ArrayContext context, Func f, Matrix<? extends UpdatablePArray> result, Matrix<? extends PArray> x1, Matrix<? extends PArray> x2, Matrix<? extends PArray> x3) {
        Matrices.applyFunc(context, true, f, result, x1, x2, x3);
    }

    public static void applyFunc(ArrayContext context, boolean truncateOverflows, Func f, Matrix<? extends UpdatablePArray> result, Matrix<? extends PArray> x1, Matrix<? extends PArray> x2, Matrix<? extends PArray> x3) {
        Matrices.applyFunc(context, truncateOverflows, f, result, Matrices.several(PArray.class, x1, x2, x3));
    }

    public static void applyFunc(Func f, Matrix<? extends UpdatablePArray> result, Matrix<? extends PArray> x1, Matrix<? extends PArray> x2, Matrix<? extends PArray> x3, Matrix<? extends PArray> x4) {
        Matrices.applyFunc(null, f, result, x1, x2, x3, x4);
    }

    public static void applyFunc(ArrayContext context, Func f, Matrix<? extends UpdatablePArray> result, Matrix<? extends PArray> x1, Matrix<? extends PArray> x2, Matrix<? extends PArray> x3, Matrix<? extends PArray> x4) {
        Matrices.applyFunc(context, true, f, result, x1, x2, x3, x4);
    }

    public static void applyFunc(ArrayContext context, boolean truncateOverflows, Func f, Matrix<? extends UpdatablePArray> result, Matrix<? extends PArray> x1, Matrix<? extends PArray> x2, Matrix<? extends PArray> x3, Matrix<? extends PArray> x4) {
        Matrices.applyFunc(context, truncateOverflows, f, result, Matrices.several(PArray.class, x1, x2, x3, x4));
    }

    public static void applyFunc(Func f, Matrix<? extends UpdatablePArray> result, List<? extends Matrix<? extends PArray>> x) {
        Matrices.applyFunc(null, f, result, x);
    }

    public static void applyFunc(ArrayContext context, Func f, Matrix<? extends UpdatablePArray> result, List<? extends Matrix<? extends PArray>> x) {
        Matrices.applyFunc(context, true, f, result, x);
    }

    public static void applyFunc(ArrayContext context, boolean truncateOverflows, Func f, Matrix<? extends UpdatablePArray> result, List<? extends Matrix<? extends PArray>> x) {
        Objects.requireNonNull(result, "Null result argument");
        PArray[] arrays = (PArray[])Matrices.arraysOfParallelMatrices(PArray.class, x);
        int k = 0;
        for (Matrix<? extends PArray> matrix : x) {
            if (!matrix.dimEquals(result)) {
                throw new SizeMismatchException("x.get(" + k + ") and result matrix dimensions mismatch: matrix #" + k + " is " + String.valueOf(matrix) + ", result matrix is " + String.valueOf(result));
            }
            arrays[k++] = matrix.array();
        }
        Arrays.applyFunc(context, truncateOverflows, f, result.array(), arrays);
    }

    public static Matrix<? extends PArray> asPrecision(Matrix<? extends PArray> matrix, Class<?> newElementType) {
        Objects.requireNonNull(matrix, "Null matrix");
        Objects.requireNonNull(newElementType, "Null newElementType");
        if (newElementType == matrix.elementType()) {
            return matrix;
        }
        return matrix.matrix(Arrays.asPrecision(matrix.array(), newElementType));
    }

    public static void applyPrecision(Matrix<? extends UpdatablePArray> result, Matrix<? extends PArray> matrix) {
        Matrices.applyPrecision(null, result, matrix);
    }

    public static void applyPrecision(ArrayContext context, Matrix<? extends UpdatablePArray> result, Matrix<? extends PArray> matrix) {
        Objects.requireNonNull(result, "Null result matrix");
        Objects.requireNonNull(matrix, "Null source matrix");
        if (!matrix.dimEquals(result)) {
            throw new SizeMismatchException("Source and result matrix dimensions mismatch: source matrix is " + String.valueOf(matrix) + ", result matrix is " + String.valueOf(result));
        }
        Arrays.applyPrecision(context, result.array(), matrix.array());
    }

    public static Matrix<PArray> asResized(ResizingMethod resizingMethod, Matrix<? extends PArray> matrix, long ... newDim) {
        return ArraysMatrixResizer.asResized(resizingMethod, matrix, newDim, null);
    }

    public static Matrix<PArray> asResized(ResizingMethod resizingMethod, Matrix<? extends PArray> matrix, long[] newDim, double[] scales) {
        return ArraysMatrixResizer.asResized(resizingMethod, matrix, newDim, scales);
    }

    public static void resize(ResizingMethod resizingMethod, Matrix<? extends UpdatablePArray> result, Matrix<? extends PArray> src) {
        Matrices.resize(null, resizingMethod, result, src);
    }

    public static void resize(ArrayContext context, ResizingMethod resizingMethod, Matrix<? extends UpdatablePArray> result, Matrix<? extends PArray> src) {
        ArraysMatrixResizer.resize(context, resizingMethod, result, src);
    }

    public static void add(Matrix<? extends UpdatablePArray> result, Matrix<? extends PArray> other) {
        Matrices.addToOther(result, result, other);
    }

    public static void addToOther(Matrix<? extends UpdatablePArray> result, Matrix<? extends PArray> a, Matrix<? extends PArray> b) {
        Matrices.applyFunc(ArrayContext.DEFAULT_SINGLE_THREAD, Func.X_PLUS_Y, result, a, b);
    }

    public static void subtract(Matrix<? extends UpdatablePArray> result, Matrix<? extends PArray> other) {
        Matrices.subtractToOther(result, result, other);
    }

    public static void subtractToOther(Matrix<? extends UpdatablePArray> result, Matrix<? extends PArray> a, Matrix<? extends PArray> b) {
        Matrices.applyFunc(ArrayContext.DEFAULT_SINGLE_THREAD, Func.X_MINUS_Y, result, a, b);
    }

    public static void bitOr(Matrix<? extends UpdatableBitArray> result, Matrix<? extends BitArray> other) {
        Matrices.bitOrToOther(result, result, other);
    }

    public static void bitOrToOther(Matrix<? extends UpdatableBitArray> result, Matrix<? extends BitArray> a, Matrix<? extends BitArray> b) {
        Matrices.applyFunc(ArrayContext.DEFAULT_SINGLE_THREAD, Func.MAX, result, a, b);
    }

    public static void bitAnd(Matrix<? extends UpdatableBitArray> result, Matrix<? extends BitArray> other) {
        Matrices.bitAndToOther(result, result, other);
    }

    public static void bitAndToOther(Matrix<? extends UpdatableBitArray> result, Matrix<? extends BitArray> a, Matrix<? extends BitArray> b) {
        Matrices.applyFunc(ArrayContext.DEFAULT_SINGLE_THREAD, Func.MIN, result, a, b);
    }

    public static void bitXor(Matrix<? extends UpdatableBitArray> result, Matrix<? extends BitArray> other) {
        Matrices.bitXorToOther(result, result, other);
    }

    public static void bitXorToOther(Matrix<? extends UpdatableBitArray> result, Matrix<? extends BitArray> a, Matrix<? extends BitArray> b) {
        Matrices.applyFunc(ArrayContext.DEFAULT_SINGLE_THREAD, Func.ABS_DIFF, result, a, b);
    }

    public static void bitDiff(Matrix<? extends UpdatableBitArray> result, Matrix<? extends BitArray> other) {
        Matrices.bitDiffToOther(result, result, other);
    }

    public static void bitDiffToOther(Matrix<? extends UpdatableBitArray> result, Matrix<? extends BitArray> a, Matrix<? extends BitArray> b) {
        Matrices.applyFunc(ArrayContext.DEFAULT_SINGLE_THREAD, Func.POSITIVE_DIFF, result, a, b);
    }

    public static void bitNot(Matrix<? extends UpdatableBitArray> bitMatrix) {
        Matrices.bitNotToOther(bitMatrix, bitMatrix);
    }

    public static void bitNotToOther(Matrix<? extends UpdatableBitArray> result, Matrix<? extends BitArray> source) {
        Matrices.applyFunc(ArrayContext.DEFAULT_SINGLE_THREAD, (Func)Func.REVERSE, result, source);
    }

    public static void packBitsGreater(Matrix<? extends UpdatableBitArray> result, Matrix<? extends PArray> intensities, double threshold) {
        Objects.requireNonNull(result, "Null result matrix");
        Objects.requireNonNull(intensities, "Null intensities matrix");
        Matrices.checkDimensionEquality(result, intensities);
        Arrays.packBitsGreater(result.array(), intensities.array(), threshold);
    }

    public static void packBitsLess(Matrix<? extends UpdatableBitArray> result, Matrix<? extends PArray> intensities, double threshold) {
        Objects.requireNonNull(result, "Null result matrix");
        Objects.requireNonNull(intensities, "Null intensities matrix");
        Matrices.checkDimensionEquality(result, intensities);
        Arrays.packBitsLess(result.array(), intensities.array(), threshold);
    }

    public static void packBitsGreaterOrEqual(Matrix<? extends UpdatableBitArray> result, Matrix<? extends PArray> intensities, double threshold) {
        Objects.requireNonNull(result, "Null result matrix");
        Objects.requireNonNull(intensities, "Null intensities matrix");
        Matrices.checkDimensionEquality(result, intensities);
        Arrays.packBitsGreaterOrEqual(result.array(), intensities.array(), threshold);
    }

    public static void packBitsLessOrEqual(Matrix<? extends UpdatableBitArray> result, Matrix<? extends PArray> intensities, double threshold) {
        Objects.requireNonNull(result, "Null result matrix");
        Objects.requireNonNull(intensities, "Null intensities matrix");
        Matrices.checkDimensionEquality(result, intensities);
        Arrays.packBitsLessOrEqual(result.array(), intensities.array(), threshold);
    }

    public static void unpackBits(Matrix<? extends UpdatablePArray> result, Matrix<? extends BitArray> bits, double filler0, double filler1) {
        Objects.requireNonNull(result, "Null result matrix");
        Objects.requireNonNull(bits, "Null bits matrix");
        Matrices.checkDimensionEquality(result, bits);
        Arrays.unpackBits(result.array(), bits.array(), filler0, filler1);
    }

    public static void unpackUnitBits(Matrix<? extends UpdatablePArray> result, Matrix<? extends BitArray> bits, double filler1) {
        Objects.requireNonNull(result, "Null result matrix");
        Objects.requireNonNull(bits, "Null bits matrix");
        Matrices.checkDimensionEquality(result, bits);
        Arrays.unpackUnitBits(result.array(), bits.array(), filler1);
    }

    public static void unpackZeroBits(Matrix<? extends UpdatablePArray> result, Matrix<? extends BitArray> bits, double filler0) {
        Objects.requireNonNull(result, "Null result matrix");
        Objects.requireNonNull(bits, "Null bits matrix");
        Matrices.checkDimensionEquality(result, bits);
        Arrays.unpackZeroBits(result.array(), bits.array(), filler0);
    }

    public static Matrix<Array> asShifted(Matrix<? extends Array> matrix, long ... shifts) {
        Objects.requireNonNull(matrix, "Null matrix argument");
        Objects.requireNonNull(shifts, "Null shifts argument");
        long shift = shifts.length == 0 ? 0L : shifts[shifts.length - 1];
        for (int k = shifts.length - 2; k >= 0; --k) {
            shift = shift * matrix.dim(k) + shifts[k];
        }
        Array array = matrix.array();
        Array shifted = Arrays.asShifted(array, shift);
        return matrix.matrix(shifted);
    }

    public static Matrix<? extends UpdatablePArray> clone(Matrix<? extends PArray> matrix) {
        return Matrices.clone(Arrays.SMM, matrix);
    }

    public static Matrix<? extends UpdatablePArray> clone(MemoryModel memoryModel, Matrix<? extends PArray> matrix) {
        Objects.requireNonNull(memoryModel, "Null memory model");
        Objects.requireNonNull(matrix, "Null matrix");
        Matrix<UpdatablePArray> result = memoryModel.newMatrix(UpdatablePArray.class, matrix);
        Matrices.copy(null, result, matrix);
        return result;
    }

    public static Arrays.CopyStatus copy(ArrayContext context, Matrix<? extends UpdatableArray> dest, Matrix<? extends Array> src) {
        return Matrices.copy(context, dest, src, 0);
    }

    public static Arrays.CopyStatus copy(ArrayContext context, Matrix<? extends UpdatableArray> dest, Matrix<? extends Array> src, int numberOfTasks) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        if (!dest.dimEquals(src)) {
            throw new SizeMismatchException("dest and src matrix dimensions mismatch: " + String.valueOf(dest) + " and " + String.valueOf(src));
        }
        return Arrays.copy(context, dest.array(), src.array(), numberOfTasks);
    }

    public static Arrays.CopyStatus copy(ArrayContext context, Matrix<? extends UpdatableArray> dest, Matrix<? extends Array> src, int numberOfTasks, boolean strictMode) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        if (!dest.dimEquals(src)) {
            throw new SizeMismatchException("dest and src matrix dimensions mismatch: " + String.valueOf(dest) + " and " + String.valueOf(src));
        }
        return Arrays.copy(context, dest.array(), src.array(), numberOfTasks, strictMode);
    }

    public static Arrays.ComparingCopyStatus compareAndCopy(ArrayContext context, Matrix<? extends UpdatableArray> dest, Matrix<? extends Array> src) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        if (!dest.dimEquals(src)) {
            throw new SizeMismatchException("dest and src matrix dimensions mismatch: " + String.valueOf(dest) + " and " + String.valueOf(src));
        }
        return Arrays.compareAndCopy(context, dest.array(), src.array());
    }

    public static void copy(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src) {
        Matrices.copy(ArrayContext.DEFAULT_SINGLE_THREAD, dest, src);
    }

    public static void copyRegion(Matrix<? extends UpdatableArray> dest, Matrix<? extends Array> src, Region destRegion, long ... shifts) {
        Matrices.copyRegion(null, dest, src, destRegion, shifts);
    }

    public static void copyRegion(ArrayContext context, Matrix<? extends UpdatableArray> dest, Matrix<? extends Array> src, Region destRegion, long ... shifts) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        Objects.requireNonNull(destRegion, "Null destRegion argument");
        Objects.requireNonNull(shifts, "Null shifts argument");
        shifts = (long[])shifts.clone();
        AbstractArray.checkCopyArguments(dest.array(), src.array());
        if (destRegion instanceof Hyperparallelepiped) {
            Hyperparallelepiped destParallelepiped = (Hyperparallelepiped)destRegion;
            if (!destParallelepiped.isInsideMatrix(dest)) {
                throw new IndexOutOfBoundsException("The destination region (" + String.valueOf(destRegion) + ") is not inside the destination " + String.valueOf(dest));
            }
            if (!destParallelepiped.isInsideMatrix(src, shifts)) {
                throw new IndexOutOfBoundsException("The source region (" + String.valueOf(destRegion) + ", shifted backwards by " + JArrays.toString(shifts, ",", 100) + ") is not inside the source " + String.valueOf(src));
            }
            if (ArraysSubMatrixCopier.copySubMatrixRegion(context, dest, src, Matrix.ContinuationMode.NONE, destRegion, shifts)) {
                return;
            }
        }
        ArraysMatrixRegionCopier regionCopier = ArraysMatrixRegionCopier.getInstance(context, destRegion.n(), dest, src, shifts, null, true);
        regionCopier.process(destRegion);
    }

    public static void copyRegion(ArrayContext context, Matrix<? extends UpdatableArray> dest, Matrix<? extends Array> src, Region destRegion, long[] shifts, Object outsideValue) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        Objects.requireNonNull(destRegion, "Null destRegion argument");
        Objects.requireNonNull(shifts, "Null shifts argument");
        shifts = (long[])shifts.clone();
        AbstractArray.checkCopyArguments(dest.array(), src.array());
        if (ArraysSubMatrixCopier.copySubMatrixRegion(context, dest, src, Matrix.ContinuationMode.getConstantMode(outsideValue), destRegion, shifts)) {
            return;
        }
        ArraysMatrixRegionCopier regionCopier = ArraysMatrixRegionCopier.getInstance(context, destRegion.n(), dest, src, shifts, outsideValue, false);
        regionCopier.process(destRegion);
    }

    public static void clear(Matrix<? extends UpdatablePArray> result) {
        Matrices.fill(result, 0.0);
    }

    public static void fill(Matrix<? extends UpdatablePArray> result, double value) {
        result.array().fill(value);
    }

    public static void fillRegion(Matrix<? extends UpdatableArray> dest, Region destRegion, Object value) {
        Matrices.fillRegion(null, dest, destRegion, value);
    }

    public static void fillRegion(ArrayContext context, Matrix<? extends UpdatableArray> dest, Region destRegion, Object value) {
        Matrices.copyRegion(context, dest, dest, destRegion, dest.dimensions(), value);
    }

    public static void clearBoundary(Matrix<? extends UpdatablePArray> result, int boundaryWidth) {
        Matrices.fillBoundary(result, boundaryWidth, 0.0);
    }

    public static void fillBoundary(Matrix<? extends UpdatablePArray> result, int boundaryWidth, double value) {
        if (boundaryWidth < 0) {
            throw new IllegalArgumentException("Negative boundaryWidth = " + boundaryWidth);
        }
        Matrices.fillOutside(result, boundaryWidth, boundaryWidth, result.dimX() - 2L * (long)boundaryWidth, result.dimY() - 2L * (long)boundaryWidth, value);
    }

    public static void fillOutside(Matrix<? extends UpdatablePArray> result, long minX, long minY, long sizeX, long sizeY, double value) {
        if (sizeX <= 0L || sizeY <= 0L) {
            result.array().fill(value);
            return;
        }
        long toX = minX + sizeX;
        long toY = minY + sizeY;
        long dimX = result.dimX();
        long dimY = result.dimY();
        if (minX != 0L) {
            result.subMatrix(0L, 0L, minX, dimY).array().fill(value);
        }
        if (toX != dimX) {
            result.subMatrix(toX, 0L, dimX, dimY).array().fill(value);
        }
        if (minY != 0L) {
            result.subMatrix(0L, 0L, dimX, minY).array().fill(value);
        }
        if (toY != dimY) {
            result.subMatrix(0L, toY, dimX, dimY).array().fill(value);
        }
    }

    public static String dimensionsToString(long[] dim) {
        return dim.length == 1 ? dim[0] + "(x1)" : JArrays.toString(dim, "x", 1000);
    }

    static Object castOutsideValue(Object outsideValue, Array array) {
        if (array instanceof PArray) {
            Number number;
            if (outsideValue == null) {
                number = 0L;
            } else if (outsideValue instanceof Boolean) {
                number = (Boolean)outsideValue != false ? 1L : 0L;
            } else if (outsideValue instanceof Character) {
                number = (long)((Character)outsideValue).charValue();
            } else if (outsideValue instanceof Byte) {
                number = (long)((Byte)outsideValue & 0xFF);
            } else if (outsideValue instanceof Short) {
                number = (long)((Short)outsideValue & 0xFFFF);
            } else if (outsideValue instanceof Integer) {
                number = (long)((Integer)outsideValue).intValue();
            } else if (outsideValue instanceof Long) {
                number = (Long)outsideValue;
            } else if (outsideValue instanceof Float) {
                number = (double)((Float)outsideValue).floatValue();
            } else if (outsideValue instanceof Double) {
                number = (Double)outsideValue;
            } else {
                throw new ClassCastException("Cannot cast outside value from " + String.valueOf(outsideValue.getClass()) + " to any primitive type");
            }
            if (array instanceof BitArray) {
                return number.doubleValue() != 0.0;
            }
            if (array instanceof CharArray) {
                return Character.valueOf((char)number.intValue());
            }
            if (array instanceof ByteArray) {
                return number.byteValue();
            }
            if (array instanceof ShortArray) {
                return number.shortValue();
            }
            if (array instanceof IntArray) {
                return number.intValue();
            }
            if (array instanceof LongArray) {
                return number.longValue();
            }
            if (array instanceof FloatArray) {
                return Float.valueOf(number.floatValue());
            }
            if (array instanceof DoubleArray) {
                return number.doubleValue();
            }
            throw new AssertionError((Object)("Unallowed type of built-in array: " + String.valueOf(array.getClass())));
        }
        if (outsideValue == null) {
            return null;
        }
        if (array.elementType().isAssignableFrom(outsideValue.getClass())) {
            return outsideValue;
        }
        throw new ClassCastException("Cannot cast outside value from " + String.valueOf(outsideValue.getClass()) + " to " + String.valueOf(array.elementType()));
    }

    private static void checkDimensionEqualityWithInterleaving(Matrix<? extends PArray> interleaved, List<? extends Matrix<? extends PArray>> list) {
        long[] dimensions = interleaved.dimensions();
        long numberOfMatrices = Matrices.numberOfChannels(dimensions, false);
        if ((long)list.size() != numberOfMatrices) {
            throw new IllegalArgumentException("Number of elements in the specified list of separated matrices = " + list.size() + " does not match to the first dimension " + numberOfMatrices + " of the interleaved matrix " + String.valueOf(interleaved));
        }
        if (numberOfMatrices > 0L) {
            long[] reducedDimensions = java.util.Arrays.copyOfRange(dimensions, 1, dimensions.length);
            Matrix<? extends PArray> m0 = list.get(0);
            if (!m0.dimEquals(reducedDimensions)) {
                throw new SizeMismatchException("Dimensions mismatch: the interleaved matrix is " + String.valueOf(interleaved) + ", the separated matrices in the list are " + Matrices.dimensionsToString(m0.dimensions()) + ", but their dimensions must be equal to the highest " + reducedDimensions.length + " of all " + dimensions.length + " dimensions of the interleaved matrix");
            }
            if (m0.elementType() != interleaved.elementType()) {
                throw new IllegalArgumentException("Different element type: " + String.valueOf(m0.elementType()) + " in the separated matrices, " + String.valueOf(interleaved.elementType()) + " in the interleaved matrix");
            }
        }
    }

    private static long numberOfChannels(long[] dimensions, boolean lastDimension) {
        long n;
        if (dimensions.length <= 1) {
            throw new IllegalStateException("The matrix must have at least 2 dimensions");
        }
        long l = n = lastDimension ? dimensions[dimensions.length - 1] : dimensions[0];
        assert (n >= 0L) : "illegal Matrix.dimensions() behavior: negative dimension";
        return n;
    }

    private static int numberOfChannels(long[] dimensions, boolean lastDimension, int limit) {
        if (limit <= 0) {
            throw new IllegalArgumentException("Zero or negative limit " + limit);
        }
        long n = Matrices.numberOfChannels(dimensions, lastDimension);
        if (n > (long)limit) {
            throw new IllegalArgumentException("Too large number of result matrices: " + n + " > allowed limit " + limit);
        }
        assert (n == (long)((int)n)) : "n must be <= 31-bit limit " + limit;
        return (int)n;
    }

    private static IRange[] coordRangesOfVertices(double[][] vertices, int requiredDimCount) {
        Objects.requireNonNull(vertices, "Null vertices array");
        if (vertices.length == 0) {
            throw new IllegalArgumentException("No vertices are specified");
        }
        for (int k = 0; k < vertices.length; ++k) {
            Objects.requireNonNull(vertices[k], "Null vertices[" + k + "]");
            if (vertices[k].length == 0) {
                throw new IllegalArgumentException("Empty vertices[" + k + "]: 0-dimensional points are not allowed");
            }
            if (requiredDimCount > 0 && vertices[k].length != requiredDimCount) {
                throw new IllegalArgumentException("The vertex #" + k + " is " + vertices[k].length + "-dimensional, but only " + requiredDimCount + "-dimensional vertices are allowed");
            }
            if (vertices[k].length == vertices[0].length) continue;
            throw new IllegalArgumentException("Different number of dimensions in the vertex #" + k + " (" + vertices[k].length + "-dimensional) and the vertex #0 (" + vertices[0].length + "-dimensional");
        }
        IRange[] result = new IRange[vertices[0].length];
        for (int j = 0; j < result.length; ++j) {
            result[j] = IRange.valueOf((long)StrictMath.floor(vertices[0][j]), (long)StrictMath.ceil(vertices[0][j]));
        }
        for (int k = 1; k < vertices.length; ++k) {
            for (int j = 0; j < result.length; ++j) {
                result[j] = IRange.valueOf(Math.min(result[j].min(), (long)StrictMath.floor(vertices[k][j])), Math.max(result[j].max(), (long)StrictMath.ceil(vertices[k][j])));
            }
        }
        return result;
    }

    private static boolean buildSimplexByVertices(double[][] vertices, double[] a, double[] b) {
        Objects.requireNonNull(vertices, "Null vertices array");
        if (vertices.length == 0) {
            throw new IllegalArgumentException("No vertices are specified");
        }
        int n = vertices[0].length;
        if (vertices.length != n + 1) {
            throw new IllegalArgumentException("Illegal number of vertices " + vertices.length + ": the " + (String)(n == 2 ? "triangle" : (n == 3 ? "tetrahedron" : n + "-dimensional simplex")) + " must be defined by " + (n + 1) + " vertices");
        }
        if ((long)vertices.length * (long)n != (long)a.length) {
            throw new OutOfMemoryError("Too large A matrix");
        }
        if (vertices.length != b.length) {
            throw new OutOfMemoryError("Too large b vector");
        }
        boolean result = true;
        double[] minorMatrix = new double[n * n];
        int k = 0;
        int aOfs = 0;
        while (k < vertices.length) {
            int j;
            double[] vertex = vertices[k];
            if (vertex.length != n) {
                throw new IllegalArgumentException("Different number of dimensions in the vertex #" + k + " (" + vertex.length + "-dimensional) and the vertex #0 (" + n + "-dimensional");
            }
            for (int minorIndex = 0; minorIndex <= n; ++minorIndex) {
                double minorValue;
                int i = 0;
                int vIndex = 0;
                int minorOfs = 0;
                while (i < n) {
                    if (vIndex == k) {
                        ++vIndex;
                    }
                    double[] v = vertices[vIndex];
                    int vOfs = 0;
                    for (int j2 = 0; j2 < n; ++j2) {
                        if (j2 != minorIndex) {
                            minorMatrix[minorOfs++] = v[vOfs];
                        }
                        ++vOfs;
                    }
                    if (minorIndex < n) {
                        minorMatrix[minorOfs++] = 1.0;
                    }
                    ++i;
                    ++vIndex;
                }
                double d = minorValue = (minorIndex & 1) == 0 ? Matrices.determinant(n, minorMatrix) : -Matrices.determinant(n, minorMatrix);
                if (minorIndex < n) {
                    a[aOfs + minorIndex] = minorValue;
                    continue;
                }
                b[k] = -minorValue;
            }
            double sum = 0.0;
            for (j = 0; j < n; ++j) {
                sum += a[aOfs + j] * vertex[j];
            }
            if (sum == b[k]) {
                result = false;
            } else if (sum > b[k]) {
                for (j = 0; j < n; ++j) {
                    a[aOfs + j] = -a[aOfs + j];
                }
                b[k] = -b[k];
            }
            ++k;
            aOfs += n;
        }
        return result;
    }

    private static double determinant(int n, double ... a) {
        assert (a.length == n * n);
        if (n <= 0) {
            throw new IllegalArgumentException("Zero or negative matrix size");
        }
        if (n == 1) {
            return a[0];
        }
        if (n == 2) {
            return a[0] * a[3] - a[1] * a[2];
        }
        double[] minor = new double[(n - 1) * (n - 1)];
        double sum = 0.0;
        for (int minorIndex = 0; minorIndex < n; ++minorIndex) {
            int aOfs = n;
            int minorOfs = 0;
            for (int i = 1; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    if (j != minorIndex) {
                        minor[minorOfs++] = a[aOfs];
                    }
                    ++aOfs;
                }
            }
            if ((minorIndex & 1) == 0) {
                sum += a[minorIndex] * Matrices.determinant(n - 1, minor);
                continue;
            }
            sum -= a[minorIndex] * Matrices.determinant(n - 1, minor);
        }
        return sum;
    }

    public static enum InterpolationMethod {
        STEP_FUNCTION(IRange.valueOf(0L, 0L)),
        POLYLINEAR_FUNCTION(IRange.valueOf(0L, 1L));

        private final IRange dependenceCoordRange;

        private InterpolationMethod(IRange dependenceCoordRange) {
            this.dependenceCoordRange = dependenceCoordRange;
        }

        public IRange dependenceCoordRange() {
            return this.dependenceCoordRange;
        }
    }

    public static class ResizingMethod {
        public static final ResizingMethod SIMPLE = new ResizingMethod(InterpolationMethod.STEP_FUNCTION);
        public static final ResizingMethod AVERAGING = ResizingMethod.newAveraging(InterpolationMethod.STEP_FUNCTION);
        public static final ResizingMethod POLYLINEAR_INTERPOLATION = new ResizingMethod(InterpolationMethod.POLYLINEAR_FUNCTION);
        public static final ResizingMethod POLYLINEAR_AVERAGING = ResizingMethod.newAveraging(InterpolationMethod.POLYLINEAR_FUNCTION);
        final InterpolationMethod interpolationMethod;

        private ResizingMethod(InterpolationMethod interpolationMethod) {
            Objects.requireNonNull(interpolationMethod, "Null interpolationMethod");
            this.interpolationMethod = interpolationMethod;
        }

        public boolean averaging() {
            return false;
        }

        public final boolean interpolation() {
            return this.interpolationMethod != InterpolationMethod.STEP_FUNCTION;
        }

        public final InterpolationMethod interpolationMethod() {
            return this.interpolationMethod;
        }

        private static ResizingMethod newAveraging(InterpolationMethod interpolationMethod) {
            return new Averaging(interpolationMethod);
        }

        public static class Averaging
        extends ResizingMethod {
            protected Averaging(InterpolationMethod interpolationMethod) {
                super(interpolationMethod);
            }

            @Override
            public final boolean averaging() {
                return true;
            }

            protected Func getAveragingFunc(long[] apertureDim) {
                return null;
            }
        }
    }

    public static abstract class Region {
        static final Region[] EMPTY_REGIONS = new Region[0];
        final IRange[] coordRanges;
        final long minX;
        final long maxX;
        final int n;

        protected Region(IRange[] coordRanges) {
            Objects.requireNonNull(coordRanges, "Null coordRanges argument");
            if (coordRanges.length == 0) {
                throw new IllegalArgumentException("Empty coordRanges array");
            }
            for (int k = 0; k < coordRanges.length; ++k) {
                Objects.requireNonNull(coordRanges[k], "Null coordRanges[" + k + "]");
            }
            this.n = coordRanges.length;
            this.coordRanges = (IRange[])coordRanges.clone();
            this.minX = coordRanges[0].min();
            this.maxX = coordRanges[0].max();
        }

        public static Hyperparallelepiped getSegment(IRange xRange) {
            return new Hyperparallelepiped(xRange);
        }

        public static Hyperparallelepiped getRectangle2D(IRange xRange, IRange yRange) {
            return new Hyperparallelepiped(xRange, yRange);
        }

        public static Hyperparallelepiped getParallelepiped3D(IRange xRange, IRange yRange, IRange zRange) {
            return new Hyperparallelepiped(xRange, yRange, zRange);
        }

        public static Hyperparallelepiped getHyperparallelepiped(IRange ... coordRanges) {
            return new Hyperparallelepiped(coordRanges);
        }

        public static Simplex getTriangle2D(double x1, double y1, double x2, double y2, double x3, double y3) {
            return new Simplex(new double[][]{{x1, y1}, {x2, y2}, {x3, y3}});
        }

        public static Simplex getTetrahedron3D(double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3, double x4, double y4, double z4) {
            return new Simplex(new double[][]{{x1, y1, z1}, {x2, y2, z2}, {x3, y3, z3}, {x4, y4, z4}});
        }

        public static Simplex getSimplex(double[][] vertices) {
            return new Simplex(vertices);
        }

        public static ConvexHyperpolyhedron getConvexHyperpolyhedron(double[] a, double[] b, IRange ... coordRanges) {
            return new ConvexHyperpolyhedron(coordRanges, a, b);
        }

        public static Polygon2D getPolygon2D(double[][] vertices) {
            return new Polygon2D(vertices);
        }

        public final int n() {
            return this.n;
        }

        public final IRange[] coordRanges() {
            return (IRange[])this.coordRanges.clone();
        }

        public final IRange coordRange(int coordIndex) {
            return this.coordRanges[coordIndex];
        }

        public boolean isRectangular() {
            return false;
        }

        public abstract boolean contains(long ... var1);

        public boolean isContainsSupported() {
            return true;
        }

        public Region[] sectionAtLastCoordinate(final long sectionCoordinateValue) {
            if (!this.checkSectionAtLastCoordinate(sectionCoordinateValue)) {
                return EMPTY_REGIONS;
            }
            final Region parent = this;
            return new Region[]{new Region(this, (IRange[])JArrays.copyOfRange(this.coordRanges, 0, this.n - 1)){

                @Override
                public boolean contains(long ... coordinates) {
                    long[] parentCoordinates = new long[this.n + 1];
                    for (int k = 0; k < this.n; ++k) {
                        parentCoordinates[k] = coordinates[k];
                    }
                    parentCoordinates[this.n] = sectionCoordinateValue;
                    return parent.contains(parentCoordinates);
                }

                public String toString() {
                    return "section at " + sectionCoordinateValue + " of " + String.valueOf(parent);
                }
            }};
        }

        protected final boolean checkSectionAtLastCoordinate(long sectionCoordinateValue) {
            if (this.n == 1) {
                throw new IllegalStateException("Cannot get a section for 1-dimensional region");
            }
            return this.coordRanges[this.n - 1].contains(sectionCoordinateValue);
        }

        boolean sectionIsUninterruptedSegment(long sectionCoordinateValue) {
            return false;
        }

        boolean segmentSectionAtLastCoordinate(MutableIRange result, long sectionCoordinateValue) {
            throw new UnsupportedOperationException();
        }

        static class MutableIRange {
            long min;
            long max;

            MutableIRange() {
            }
        }
    }

    public static final class Hyperparallelepiped
    extends Region {
        private Hyperparallelepiped(IRange ... coordRanges) {
            super(coordRanges);
        }

        @Override
        public boolean isRectangular() {
            return true;
        }

        @Override
        public boolean contains(long ... coordinates) {
            for (int k = 0; k < this.n; ++k) {
                if (this.coordRanges[k].contains(coordinates[k])) continue;
                return false;
            }
            return true;
        }

        @Override
        public Region[] sectionAtLastCoordinate(long sectionCoordinateValue) {
            if (!this.checkSectionAtLastCoordinate(sectionCoordinateValue)) {
                return EMPTY_REGIONS;
            }
            return new Region[]{new Hyperparallelepiped((IRange[])JArrays.copyOfRange(this.coordRanges, 0, this.n - 1))};
        }

        public boolean isInsideMatrix(Matrix<?> matrix) {
            return this.isInsideMatrix(matrix, new long[0]);
        }

        public boolean isInsideMatrix(Matrix<?> matrix, long ... backShifts) {
            Objects.requireNonNull(matrix, "Null matrix argument");
            Objects.requireNonNull(backShifts, "Null backShifts argument");
            for (int k = 0; k < this.n; ++k) {
                long shift;
                long l = shift = k < backShifts.length ? backShifts[k] : 0L;
                if (this.coordRanges[k].min() - shift < 0L) {
                    return false;
                }
                if (this.coordRanges[k].max() - shift < matrix.dim(k)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return this.n + "-dimensional rectangular region " + JArrays.toString(this.coordRanges, "x", 100);
        }

        @Override
        boolean sectionIsUninterruptedSegment(long sectionCoordinateValue) {
            return this.n == 2 && this.coordRanges[1].contains(sectionCoordinateValue);
        }

        @Override
        boolean segmentSectionAtLastCoordinate(Region.MutableIRange result, long sectionCoordinateValue) {
            result.min = this.minX;
            result.max = this.maxX;
            return true;
        }
    }

    public static final class Polygon2D
    extends Region {
        private final double[] vx;
        private final double[] vy;

        private Polygon2D(double[][] vertices) {
            super(Matrices.coordRangesOfVertices(vertices, 2));
            this.vx = new double[vertices.length];
            this.vy = new double[vertices.length];
            for (int k = 0; k < vertices.length; ++k) {
                this.vx[k] = vertices[k][0];
                this.vy[k] = vertices[k][1];
            }
        }

        @Override
        public boolean contains(long ... coordinates) {
            throw new UnsupportedOperationException("Inside method is not supported by " + String.valueOf(this.getClass()));
        }

        @Override
        public boolean isContainsSupported() {
            return false;
        }

        @Override
        public Region[] sectionAtLastCoordinate(long sectionY) {
            int k;
            if (!this.checkSectionAtLastCoordinate(sectionY)) {
                return EMPTY_REGIONS;
            }
            int m = this.vx.length;
            double[] sectionX = new double[m];
            int horizontalCount = 0;
            int sectionCount = 0;
            for (int k2 = 0; k2 < m; ++k2) {
                double vyPrev;
                double vxPrev = k2 > 0 ? this.vx[k2 - 1] : this.vx[m - 1];
                double d = vyPrev = k2 > 0 ? this.vy[k2 - 1] : this.vy[m - 1];
                if (this.vy[k2] != (double)sectionY) {
                    if (!(this.vy[k2] > (double)sectionY ? vyPrev < (double)sectionY : vyPrev > (double)sectionY)) continue;
                    sectionX[sectionCount++] = this.vx[k2] + (vxPrev - this.vx[k2]) * ((double)sectionY - this.vy[k2]) / (vyPrev - this.vy[k2]);
                    continue;
                }
                if (vyPrev != (double)sectionY) {
                    double vyNext;
                    int i = k2;
                    do {
                        if (++i == m) {
                            i = 0;
                        }
                        if (i == k2) {
                            throw new AssertionError((Object)"Cannot find another vy, though vyPrev!=vy[k]");
                        }
                    } while ((vyNext = this.vy[i]) == (double)sectionY);
                    sectionX[sectionCount++] = this.vx[k2];
                    if (vyNext > (double)sectionY != vyPrev > (double)sectionY) continue;
                    sectionX[sectionCount++] = this.vx[k2];
                    continue;
                }
                ++horizontalCount;
            }
            if (sectionCount % 2 != 0) {
                throw new AssertionError((Object)("Odd number " + sectionCount + " of intersections of " + String.valueOf(this) + " and the horizontal y=" + sectionY));
            }
            if ((long)(sectionCount / 2) + (long)horizontalCount > Integer.MAX_VALUE) {
                throw new OutOfMemoryError("Too large number of horizontal segments");
            }
            java.util.Arrays.sort(sectionX, 0, sectionCount);
            Region[] result = new Region[sectionCount / 2 + horizontalCount];
            int resultCount = 0;
            for (k = 0; k < sectionCount; k += 2) {
                long maxX;
                long minX = (long)StrictMath.ceil(sectionX[k]);
                if (minX > (maxX = (long)StrictMath.floor(sectionX[k + 1]))) continue;
                result[resultCount++] = Polygon2D.getSegment(IRange.valueOf(minX, maxX));
            }
            if (horizontalCount > 0) {
                for (k = 0; k < m; ++k) {
                    long maxX;
                    long minX;
                    double vyPrev;
                    if (this.vy[k] != (double)sectionY) continue;
                    double vxPrev = k > 0 ? this.vx[k - 1] : this.vx[m - 1];
                    double d = vyPrev = k > 0 ? this.vy[k - 1] : this.vy[m - 1];
                    if (vyPrev != (double)sectionY || (minX = (long)StrictMath.ceil(StrictMath.min(this.vx[k], vxPrev))) > (maxX = (long)StrictMath.floor(StrictMath.max(this.vx[k], vxPrev)))) continue;
                    result[resultCount++] = Polygon2D.getSegment(IRange.valueOf(minX, maxX));
                }
            }
            if (resultCount < result.length) {
                result = (Region[])JArrays.copyOfRange(result, 0, resultCount);
            }
            return result;
        }

        public int verticesCount() {
            return this.vx.length;
        }

        public double vertexX(int index) {
            return this.vx[index];
        }

        public double vertexY(int index) {
            return this.vy[index];
        }

        public double[][] vertices() {
            double[][] result = new double[this.vx.length][2];
            for (int k = 0; k < result.length; ++k) {
                result[k][0] = this.vx[k];
                result[k][1] = this.vy[k];
            }
            return result;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("2-dimensional polygon ");
            for (int k = 0; k < this.vx.length; ++k) {
                if (k > 0) {
                    sb.append("-");
                }
                sb.append("(").append(this.vx[k]).append(",").append(this.vy[k]).append(")");
            }
            return sb.toString();
        }
    }

    public static final class Simplex
    extends ConvexHyperpolyhedron {
        private final double[][] vertices;

        private Simplex(double[][] vertices) {
            super(Matrices.coordRangesOfVertices(vertices, 0), new double[(int)Math.min(Integer.MAX_VALUE, (long)vertices[0].length * ((long)vertices[0].length + 1L))], new double[(int)Math.min(Integer.MAX_VALUE, (long)vertices[0].length + 1L)]);
            boolean degenerated;
            this.vertices = (double[][])vertices.clone();
            boolean bl = degenerated = !Matrices.buildSimplexByVertices(vertices, this.a, this.b);
            if (degenerated) {
                throw new DegeneratedSimplexException("Degenerated simplex is not allowed: " + String.valueOf(this));
            }
            for (int k = 0; k < vertices.length; ++k) {
                this.vertices[k] = (double[])vertices[k].clone();
            }
        }

        public static boolean isSimplexDegenerated(double[][] vertices) {
            Matrices.coordRangesOfVertices(vertices, 0);
            return !Matrices.buildSimplexByVertices(vertices, new double[(int)Math.min(Integer.MAX_VALUE, (long)vertices[0].length * ((long)vertices[0].length + 1L))], new double[(int)Math.min(Integer.MAX_VALUE, (long)vertices[0].length + 1L)]);
        }

        public double[][] vertices() {
            double[][] result = new double[this.vertices.length][];
            for (int k = 0; k < result.length; ++k) {
                result[k] = (double[])this.vertices[k].clone();
            }
            return result;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder(this.n + "-dimensional simplex" + (this.n == 2 ? " (triangle)" : (this.n == 3 ? " (tetrahedron)" : "")) + " with vertices ");
            for (int k = 0; k < this.vertices.length; ++k) {
                if (k > 0) {
                    sb.append(", ");
                }
                sb.append("(").append(JArrays.toString(this.vertices[k], ",", 100)).append(")");
            }
            return sb.toString();
        }
    }

    public static class ConvexHyperpolyhedron
    extends Region {
        final double[] a;
        final double[] b;

        private ConvexHyperpolyhedron(IRange[] coordRanges, double[] a, double[] b) {
            super(coordRanges);
            Objects.requireNonNull(a, "Null A coefficients");
            Objects.requireNonNull(b, "Null b coefficients");
            if ((long)a.length != (long)this.n * (long)b.length) {
                throw new IllegalArgumentException("Illegal size of A matrix: a.length=" + a.length + " must be equal to b.length*n=" + (long)this.n * (long)b.length);
            }
            this.a = (double[])a.clone();
            this.b = (double[])b.clone();
        }

        @Override
        public boolean contains(long ... coordinates) {
            for (int k = 0; k < this.n; ++k) {
                if (this.coordRanges[k].contains(coordinates[k])) continue;
                return false;
            }
            int ofs = 0;
            for (int i = 0; i < this.b.length; ++i) {
                double scalarProd = 0.0;
                int j = 0;
                while (j < this.n) {
                    scalarProd += this.a[ofs] * (double)coordinates[j];
                    ++j;
                    ++ofs;
                }
                if (!(scalarProd > this.b[i])) continue;
                return false;
            }
            return true;
        }

        @Override
        public Region[] sectionAtLastCoordinate(long sectionCoordinateValue) {
            if (!this.checkSectionAtLastCoordinate(sectionCoordinateValue)) {
                return EMPTY_REGIONS;
            }
            if (this.n > 2) {
                double[] newA = new double[(this.n - 1) * this.b.length];
                double[] newB = new double[this.b.length];
                int ofs = 0;
                for (int i = 0; i < this.b.length; ++i) {
                    System.arraycopy(this.a, ofs, newA, i * (this.n - 1), this.n - 1);
                    newB[i] = this.b[i] - this.a[ofs += this.n - 1] * (double)sectionCoordinateValue;
                    ++ofs;
                }
                return new Region[]{new ConvexHyperpolyhedron((IRange[])JArrays.copyOfRange(this.coordRanges, 0, this.n - 1), newA, newB)};
            }
            assert (this.n == 2);
            Region.MutableIRange xRange = new Region.MutableIRange();
            if (!this.segmentSectionAtLastCoordinate(xRange, sectionCoordinateValue)) {
                return EMPTY_REGIONS;
            }
            return new Region[]{new Hyperparallelepiped(IRange.valueOf(xRange.min, xRange.max))};
        }

        public String toString() {
            return this.n + "-dimensional convex hyperpolyhedral region (inside " + JArrays.toString(this.coordRanges, "x", 100) + ")";
        }

        @Override
        boolean sectionIsUninterruptedSegment(long sectionCoordinateValue) {
            return this.n == 2 && this.coordRanges[1].contains(sectionCoordinateValue);
        }

        @Override
        boolean segmentSectionAtLastCoordinate(Region.MutableIRange result, long sectionCoordinateValue) {
            double left = this.coordRanges[0].min();
            double right = this.coordRanges[0].max();
            for (int i = 0; i < this.b.length; ++i) {
                double v;
                double c = this.a[2 * i];
                double d = this.b[i] - this.a[2 * i + 1] * (double)sectionCoordinateValue;
                if (c > 0.0) {
                    v = d / c;
                    if (!(v < right)) continue;
                    right = v;
                    continue;
                }
                if (c < 0.0) {
                    v = d / c;
                    if (!(v > left)) continue;
                    left = v;
                    continue;
                }
                if (!(d < 0.0)) continue;
                return false;
            }
            result.min = (long)StrictMath.ceil(left);
            result.max = (long)StrictMath.floor(right);
            return result.min <= result.max;
        }

        public double[] a() {
            return (double[])this.a.clone();
        }

        public double[] b() {
            return (double[])this.b.clone();
        }
    }
}

