/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.Objects;
import net.algart.arrays.AbstractMatrix;
import net.algart.arrays.Array;
import net.algart.arrays.Matrix;

class MatrixImpl<T extends Array>
extends AbstractMatrix<T>
implements Matrix<T> {
    private final T array;
    private final long[] dimensions;

    MatrixImpl(T array, long[] dimensions) {
        Objects.requireNonNull(array, "Null array argument");
        if (!array.isUnresizable()) {
            throw new IllegalArgumentException("Matrix cannot be created on the base of resizable array: please use UpdatableArray.asUnresizable() method before constructing a matrix");
        }
        this.array = array;
        this.dimensions = (long[])dimensions.clone();
        MatrixImpl.checkDimensions(this.dimensions, array.length());
    }

    @Override
    public T array() {
        return this.array;
    }

    @Override
    public Object toJavaArray() {
        return this.array.toJavaArray();
    }

    @Override
    public Object ja() {
        return this.array.ja();
    }

    @Override
    public long size() {
        return this.array.length();
    }

    @Override
    public int size32() {
        return this.array.length32();
    }

    @Override
    public long[] dimensions() {
        return (long[])this.dimensions.clone();
    }

    @Override
    public int dimCount() {
        return this.dimensions.length;
    }

    @Override
    public long dim(int n) {
        return n < this.dimensions.length ? this.dimensions[n] : 1L;
    }

    @Override
    public <U extends Array> Matrix<U> matrix(U anotherArray) {
        return new MatrixImpl<U>(anotherArray, this.dimensions);
    }
}

