/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.Objects;
import net.algart.arrays.Array;
import net.algart.arrays.Arrays;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.MutableArray;
import net.algart.arrays.UpdatableArray;
import net.algart.arrays.UpdatablePArray;

public interface MutablePArray
extends UpdatablePArray,
MutableArray {
    public double popDouble();

    public void addDouble(double var1);

    public void addLong(long var1);

    public void addInt(int var1);

    @Override
    public MutablePArray setData(long var1, Object var3, int var4, int var5);

    @Override
    public MutablePArray setData(long var1, Object var3);

    @Override
    public MutablePArray copy(Array var1);

    @Override
    public MutablePArray swap(UpdatableArray var1);

    @Override
    public MutablePArray length(long var1);

    @Override
    public MutablePArray ensureCapacity(long var1);

    @Override
    public MutablePArray trim();

    @Override
    public MutablePArray append(Array var1);

    @Override
    public MutablePArray asCopyOnNextWrite();

    @Override
    public MutablePArray shallowClone();

    public static MutablePArray newArray(MemoryModel memoryModel, Class<?> elementType) {
        Objects.requireNonNull(memoryModel, "Null memory model");
        Objects.requireNonNull(elementType, "Null element type");
        if (!elementType.isPrimitive()) {
            throw new IllegalArgumentException("Not a primitive type: " + String.valueOf(elementType));
        }
        return (MutablePArray)memoryModel.newEmptyArray(elementType);
    }

    public static MutablePArray newArray(Class<?> elementType) {
        return MutablePArray.newArray(Arrays.SMM, elementType);
    }
}

