/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.Objects;
import net.algart.arrays.Arrays;
import net.algart.arrays.DataBuffer;
import net.algart.arrays.DataShortBuffer;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.MutableShortArray;
import net.algart.arrays.PIntegerArray;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.arrays.TooLargeArrayException;
import net.algart.arrays.UpdatableShortArray;

public interface ShortArray
extends PIntegerArray {
    public Class<? extends ShortArray> type();

    public Class<? extends UpdatableShortArray> updatableType();

    public Class<? extends MutableShortArray> mutableType();

    public int getShort(long var1);

    default public short[] newJavaArray(int length) {
        return new short[length];
    }

    public long indexOf(long var1, long var3, short var5);

    public long lastIndexOf(long var1, long var3, short var5);

    @Override
    public DataShortBuffer buffer(DataBuffer.AccessMode var1, long var2);

    @Override
    public DataShortBuffer buffer(DataBuffer.AccessMode var1);

    @Override
    public DataShortBuffer buffer(long var1);

    @Override
    public DataShortBuffer buffer();

    @Override
    public ShortArray asImmutable();

    @Override
    public ShortArray asTrustedImmutable();

    @Override
    public MutableShortArray mutableClone(MemoryModel var1);

    @Override
    public UpdatableShortArray updatableClone(MemoryModel var1);

    default public short[] toJavaArray() {
        long len = this.length();
        if (len != (long)((int)len)) {
            throw new TooLargeArrayException("Cannot convert AlgART array to short[] Java array, because it is too large: " + String.valueOf(this));
        }
        short[] result = this.newJavaArray((int)len);
        this.getData(0L, result);
        return result;
    }

    public short[] ja();

    default public Matrix<? extends ShortArray> matrix(long ... dim) {
        return Matrices.matrix(this, dim);
    }

    @Override
    default public short[] toShort() {
        return this.toJavaArray();
    }

    @Override
    default public short[] jaShort() {
        return this.ja();
    }

    public static UpdatableShortArray newArray(MemoryModel memoryModel, long length) {
        Objects.requireNonNull(memoryModel, "Null memory model");
        return memoryModel.newUnresizableShortArray(length);
    }

    public static UpdatableShortArray newArray(long length) {
        return Arrays.SMM.newUnresizableShortArray(length);
    }

    @Override
    public int getInt(long var1);

    public static UpdatableShortArray as(short[] array) {
        return SimpleMemoryModel.asUpdatableShortArray(array);
    }
}

