/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import net.algart.arrays.BitArray;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.UpdatablePFixedArray;

public interface UpdatableBitArray
extends BitArray,
UpdatablePFixedArray {
    public void setBit(long var1, boolean var3);

    public UpdatableBitArray fill(boolean var1);

    public UpdatableBitArray fill(long var1, long var3, boolean var5);

    @Override
    public UpdatableBitArray subArray(long var1, long var3);

    @Override
    public UpdatableBitArray subArr(long var1, long var3);

    @Override
    public UpdatableBitArray asUnresizable();

    default public Matrix<UpdatableBitArray> matrix(long ... dim) {
        return Matrices.matrix(this, dim);
    }

    public void setBit(long var1);

    public void clearBit(long var1);

    public void setBitNoSync(long var1, boolean var3);

    public void setBitNoSync(long var1);

    public void clearBitNoSync(long var1);

    default public void setBits64(long arrayPos, long bits, int count) {
        if (arrayPos < 0L) {
            throw new IndexOutOfBoundsException("Negative arrayPos argument: " + arrayPos);
        }
        if (count < 0) {
            throw new IllegalArgumentException("Negative count argument: " + count);
        }
        if (count > 64) {
            throw new IllegalArgumentException("Too large count argument: " + count + "; we cannot set > 64 bits in setBits64 method");
        }
        for (int k = count - 1; k >= 0; --k) {
            long bit = bits >>> k & 1L;
            this.setBit(arrayPos + (long)k, bit != 0L);
        }
    }

    default public void setBits64NoSync(long arrayPos, long bits, int count) {
        if (arrayPos < 0L) {
            throw new IndexOutOfBoundsException("Negative arrayPos argument: " + arrayPos);
        }
        if (count < 0) {
            throw new IllegalArgumentException("Negative count argument: " + count);
        }
        if (count > 64) {
            throw new IllegalArgumentException("Too large count argument: " + count + "; we cannot set > 64 bits in setBits64NoSync method");
        }
        for (int k = count - 1; k >= 0; --k) {
            long bit = bits >>> k & 1L;
            this.setBitNoSync(arrayPos + (long)k, bit != 0L);
        }
    }

    public UpdatableBitArray setBits(long var1, long[] var3, long var4, long var6);
}

