/*
 * Decompiled with CFR 0.152.
 */
package net.algart.contexts;

import java.util.Objects;
import net.algart.arrays.Arrays;
import net.algart.arrays.DefaultThreadPoolFactory;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.arrays.ThreadPoolFactory;
import net.algart.contexts.AbstractContext;
import net.algart.contexts.ArrayMemoryContext;
import net.algart.contexts.ArrayThreadPoolContext;
import net.algart.contexts.Context;
import net.algart.contexts.InterruptionContext;
import net.algart.contexts.ProgressUpdater;
import net.algart.contexts.StatusUpdater;

public class DefaultContext
extends AbstractContext
implements Context,
InterruptionContext,
ArrayMemoryContext,
ArrayThreadPoolContext,
ProgressUpdater,
StatusUpdater {
    private final MemoryModel memoryModel;
    private final ThreadPoolFactory threadPoolFactory;

    protected DefaultContext() {
        super(true);
        this.memoryModel = Arrays.SystemSettings.globalMemoryModel();
        this.threadPoolFactory = DefaultThreadPoolFactory.getDefaultThreadPoolFactory();
    }

    public DefaultContext(MemoryModel memoryModel) {
        super(true);
        this.memoryModel = memoryModel;
        this.threadPoolFactory = DefaultThreadPoolFactory.getDefaultThreadPoolFactory();
    }

    public static DefaultContext getInstance() {
        return DefaultContextHolder.INSTANCE;
    }

    @Override
    public void checkInterruption() {
    }

    @Override
    public void addInterruptionListener(InterruptionContext.Listener listener) {
    }

    @Override
    public void removeInterruptionListener(InterruptionContext.Listener listener) {
    }

    @Override
    public MemoryModel getMemoryModel() {
        return this.memoryModel;
    }

    @Override
    public MemoryModel getMemoryModel(Class<?> elementType) {
        MemoryModel mm = this.getMemoryModel();
        return mm.isElementTypeSupported(elementType) ? mm : SimpleMemoryModel.getInstance();
    }

    @Override
    public MemoryModel getMemoryModel(String settings) {
        Objects.requireNonNull(settings, "Null settings argument");
        return this.getMemoryModel();
    }

    @Override
    public ThreadPoolFactory getThreadPoolFactory() {
        return this.threadPoolFactory;
    }

    @Override
    public void updateProgress(double readyPart, boolean force) {
        this.updateStatus(Math.round(readyPart * 100.0) + "%", force);
    }

    @Override
    public void updateStatus(String message) {
        this.updateStatus(message, true);
    }

    @Override
    public void updateStatus(String message, boolean force) {
    }

    private static class DefaultContextHolder {
        private static final DefaultContext INSTANCE = new DefaultContext(){};

        private DefaultContextHolder() {
        }
    }
}

