/*
 * Decompiled with CFR 0.152.
 */
package net.algart.contours;

public final class ContourLength {
    private int numberOfPoints = 1;
    private int arrayLength = 2;
    long doubledArea = 0L;

    public ContourLength setNumberOfPoints(int numberOfPoints) {
        if (numberOfPoints <= 0) {
            throw new IllegalArgumentException("Invalid contour length: zero or negative number of points " + numberOfPoints);
        }
        if (numberOfPoints >= 0x3FFFFEFF) {
            throw new IllegalArgumentException("Too large number of points in a contour: it is > 1073741567");
        }
        this.numberOfPoints = numberOfPoints;
        this.arrayLength = numberOfPoints << 1;
        return this;
    }

    public int getNumberOfPoints() {
        return this.numberOfPoints;
    }

    public int getArrayLength() {
        return this.arrayLength;
    }

    public boolean isDegenerated() {
        return this.numberOfPoints == 1;
    }

    public String toString() {
        return "length " + this.numberOfPoints + " point" + (this.numberOfPoints > 1 ? "s" : "") + " (int[" + this.arrayLength + "])";
    }
}

