/*
 * Decompiled with CFR 0.152.
 */
package net.algart.math.functions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.DoublePredicate;
import net.algart.math.IPoint;
import net.algart.math.functions.AbsDiffFunc;
import net.algart.math.functions.AbsFunc;
import net.algart.math.functions.Func1;
import net.algart.math.functions.IdentityFunc;
import net.algart.math.functions.LinearFunc;
import net.algart.math.functions.MaxFunc;
import net.algart.math.functions.MinFunc;
import net.algart.math.functions.PositiveDiffFunc;
import net.algart.math.functions.SelectFrom8Directions2DFunc;
import net.algart.math.functions.SelectFunc;
import net.algart.math.functions.SelectIfGreaterFunc;
import net.algart.math.functions.SelectIfGreaterOrEqualFunc;

public interface Func {
    public static final Func IDENTITY = new IdentityFunc();
    public static final Updatable UPDATABLE_IDENTITY = new IdentityFunc.Updatable();
    public static final Func MAX = new MaxFunc();
    public static final Func MIN = new MinFunc();
    public static final Func ABS = new AbsFunc();
    public static final Func ABS_DIFF = new AbsDiffFunc();
    public static final Func POSITIVE_DIFF = new PositiveDiffFunc();
    public static final LinearFunc X_PLUS_Y = LinearFunc.getInstance(0.0, 1.0, 1.0);
    public static final LinearFunc X_MINUS_Y = LinearFunc.getInstance(0.0, 1.0, -1.0);
    public static final LinearFunc Y_MINUS_X = LinearFunc.getInstance(0.0, -1.0, 1.0);
    public static final LinearFunc HALF_X_PLUS_Y = LinearFunc.getInstance(0.0, 0.5, 0.5);
    public static final LinearFunc HALF_X_MINUS_Y = LinearFunc.getInstance(0.0, 0.5, -0.5);
    public static final LinearFunc HALF_Y_MINUS_X = LinearFunc.getInstance(0.0, -0.5, 0.5);
    public static final LinearFunc REVERSE = LinearFunc.getInstance(1.0, -1.0);
    public static final Func SELECT = new SelectFunc();
    public static final Func SELECT_IF_GREATER = new SelectIfGreaterFunc();
    public static final Func SELECT_IF_GREATER_OR_EQUAL = new SelectIfGreaterOrEqualFunc();
    public static final Func SELECT_FROM_8_DIRECTIONS_2D = new SelectFrom8Directions2DFunc();
    public static final List<IPoint> SHIFTS_ALONG_8_DIRECTIONS_2D = Collections.unmodifiableList(Arrays.asList(IPoint.valueOf(1L, 0L), IPoint.valueOf(1L, 1L), IPoint.valueOf(0L, 1L), IPoint.valueOf(-1L, 1L), IPoint.valueOf(-1L, 0L), IPoint.valueOf(-1L, -1L), IPoint.valueOf(0L, -1L), IPoint.valueOf(1L, -1L)));

    public double get(double ... var1);

    public double get();

    public double get(double var1);

    public double get(double var1, double var3);

    public double get(double var1, double var3, double var5);

    public double get(double var1, double var3, double var5, double var7);

    public static Func1 of(DoublePredicate predicate) {
        Objects.requireNonNull(predicate, "Null predicate");
        return x0 -> predicate.test(x0) ? 1.0 : 0.0;
    }

    public static interface Updatable
    extends Func {
        public void set(double[] var1, double var2);
    }
}

