/*
 * Decompiled with CFR 0.152.
 */
package net.algart.math.functions;

import net.algart.math.functions.Func;

public abstract class LogFunc
implements Func {
    private final double base;

    private LogFunc(double base) {
        this.base = base;
    }

    public static LogFunc getInstance(double b) {
        if (b == Math.E) {
            return new LogFunc(b){

                @Override
                public double get(double ... x) {
                    return Math.log(x[0]);
                }

                @Override
                public double get(double x0) {
                    return Math.log(x0);
                }

                @Override
                public double get(double x0, double x1) {
                    return Math.log(x0);
                }

                @Override
                public double get(double x0, double x1, double x2) {
                    return Math.log(x0);
                }

                @Override
                public double get(double x0, double x1, double x2, double x3) {
                    return Math.log(x0);
                }
            };
        }
        if (b == 10.0) {
            return new LogFunc(b){

                @Override
                public double get(double ... x) {
                    return Math.log10(x[0]);
                }

                @Override
                public double get(double x0) {
                    return Math.log10(x0);
                }

                @Override
                public double get(double x0, double x1) {
                    return Math.log10(x0);
                }

                @Override
                public double get(double x0, double x1, double x2) {
                    return Math.log10(x0);
                }

                @Override
                public double get(double x0, double x1, double x2, double x3) {
                    return Math.log10(x0);
                }
            };
        }
        final double mult = 1.0 / Math.log(b);
        return new LogFunc(b){

            @Override
            public double get(double ... x) {
                return Math.log(x[0]) * mult;
            }

            @Override
            public double get(double x0) {
                return Math.log(x0) * mult;
            }

            @Override
            public double get(double x0, double x1) {
                return Math.log(x0) * mult;
            }

            @Override
            public double get(double x0, double x1, double x2) {
                return Math.log(x0) * mult;
            }

            @Override
            public double get(double x0, double x1, double x2, double x3) {
                return Math.log(x0) * mult;
            }
        };
    }

    public static LogFunc getStrictInstance(double b) {
        if (b == Math.E) {
            return new LogFunc(b){

                @Override
                public double get(double ... x) {
                    return StrictMath.log(x[0]);
                }

                @Override
                public double get(double x0) {
                    return StrictMath.log(x0);
                }

                @Override
                public double get(double x0, double x1) {
                    return StrictMath.log(x0);
                }

                @Override
                public double get(double x0, double x1, double x2) {
                    return StrictMath.log(x0);
                }

                @Override
                public double get(double x0, double x1, double x2, double x3) {
                    return StrictMath.log(x0);
                }
            };
        }
        if (b == 10.0) {
            return new LogFunc(b){

                @Override
                public double get(double ... x) {
                    return StrictMath.log10(x[0]);
                }

                @Override
                public double get(double x0) {
                    return StrictMath.log10(x0);
                }

                @Override
                public double get(double x0, double x1) {
                    return StrictMath.log10(x0);
                }

                @Override
                public double get(double x0, double x1, double x2) {
                    return StrictMath.log10(x0);
                }

                @Override
                public double get(double x0, double x1, double x2, double x3) {
                    return StrictMath.log10(x0);
                }
            };
        }
        final double mult = 1.0 / Math.log(b);
        return new LogFunc(b){

            @Override
            public double get(double ... x) {
                return StrictMath.log(x[0]) * mult;
            }

            @Override
            public double get(double x0) {
                return StrictMath.log(x0) * mult;
            }

            @Override
            public double get(double x0, double x1) {
                return StrictMath.log(x0) * mult;
            }

            @Override
            public double get(double x0, double x1, double x2) {
                return StrictMath.log(x0) * mult;
            }

            @Override
            public double get(double x0, double x1, double x2, double x3) {
                return StrictMath.log(x0) * mult;
            }
        };
    }

    @Override
    public abstract double get(double ... var1);

    @Override
    public double get() {
        throw new IndexOutOfBoundsException("At least 1 argument required");
    }

    @Override
    public abstract double get(double var1);

    @Override
    public abstract double get(double var1, double var3);

    @Override
    public abstract double get(double var1, double var3, double var5);

    @Override
    public abstract double get(double var1, double var3, double var5, double var7);

    public String toString() {
        return "function f(x)=log(x) (base=" + this.base + ")";
    }
}

