/*
 * Decompiled with CFR 0.152.
 */
package net.algart.math.functions;

import net.algart.math.functions.Func;

final class MinFunc
implements Func {
    MinFunc() {
    }

    @Override
    public double get(double ... x) {
        if (x.length == 0) {
            return Double.POSITIVE_INFINITY;
        }
        double result = x[0];
        for (int k = 1; k < x.length; ++k) {
            if (!(x[k] < result)) continue;
            result = x[k];
        }
        return result;
    }

    @Override
    public double get() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public double get(double x0) {
        return x0;
    }

    @Override
    public double get(double x0, double x1) {
        return Math.min(x0, x1);
    }

    @Override
    public double get(double x0, double x1, double x2) {
        double x = Math.min(x0, x1);
        return Math.min(x, x2);
    }

    @Override
    public double get(double x0, double x1, double x2, double x3) {
        double x = Math.min(x0, x1);
        double y = Math.min(x2, x3);
        return Math.min(x, y);
    }

    public String toString() {
        return "minimum function f(x0,x1,...)=min(x0,x1,...)";
    }
}

