/*
 * Decompiled with CFR 0.152.
 */
package net.algart.math.functions;

import net.algart.math.functions.Func;

public final class MultiplyingFunc
implements Func {
    private final double scale;

    private MultiplyingFunc(double scale) {
        this.scale = scale;
    }

    public static MultiplyingFunc getInstance(double scale) {
        return new MultiplyingFunc(scale);
    }

    @Override
    public double get(double ... x) {
        double result = this.scale;
        for (double v : x) {
            result *= v;
        }
        return result;
    }

    @Override
    public double get() {
        return this.scale;
    }

    @Override
    public double get(double x0) {
        return this.scale * x0;
    }

    @Override
    public double get(double x0, double x1) {
        return this.scale * x0 * x1;
    }

    @Override
    public double get(double x0, double x1, double x2) {
        return this.scale * x0 * x1 * x2;
    }

    @Override
    public double get(double x0, double x1, double x2, double x3) {
        return this.scale * x0 * x1 * x2 * x3;
    }

    public String toString() {
        return "product function f(x0,x1,...)=" + this.scale + "*x0*x1*...";
    }
}

