/*
 * Decompiled with CFR 0.152.
 */
package net.algart.math.patterns;

import java.util.Objects;
import java.util.Set;
import net.algart.math.IPoint;
import net.algart.math.IRange;
import net.algart.math.Range;
import net.algart.math.patterns.AbstractWeightedPattern;
import net.algart.math.patterns.Pattern;
import net.algart.math.patterns.WeightedPattern;

class BasicWeightedPattern
extends AbstractWeightedPattern
implements WeightedPattern {
    private final IPoint weightCoordMin;
    private final IPoint weightCoordMax;
    private final long[] wcMin;
    private final long[] wcMax;
    private final double[] weights;
    private final double outsideWeight;
    private volatile Range weightRange = null;

    BasicWeightedPattern(Pattern parent, IPoint weightCoordMin, IPoint weightCoordMax, double[] weights, double outsideWeight, boolean cloneWeights) {
        super(parent);
        int n = this.dimCount();
        if (n != weightCoordMin.coordCount()) {
            throw new IllegalArgumentException("Dimensions count mismatch: \"coordMin\" is " + weightCoordMin.coordCount() + "-dimensional, the pattern is " + n + "-dimensional");
        }
        if (n != weightCoordMax.coordCount()) {
            throw new IllegalArgumentException("Dimensions count mismatch: \"coordMax\" is " + weightCoordMax.coordCount() + "-dimensional, the pattern is " + n + "-dimensional");
        }
        this.weightCoordMin = weightCoordMin;
        this.weightCoordMax = weightCoordMax;
        this.wcMin = weightCoordMin.coordinates();
        this.wcMax = weightCoordMax.coordinates();
        IRange[] ranges = new IRange[n];
        long count = 1L;
        for (int k = 0; k < n; ++k) {
            IRange range;
            ranges[k] = range = IRange.valueOf(weightCoordMin.coord(k), weightCoordMax.coord(k));
            if (range.size() < Integer.MAX_VALUE && (count *= range.size()) < Integer.MAX_VALUE) continue;
            throw new IllegalArgumentException("Too large desired weight matrix: more than 2^31-1 elements");
        }
        assert (count >= 1L);
        if ((long)weights.length != count) {
            throw new IllegalArgumentException("The length of weights array " + weights.length + " does not match to the product " + count + " of dimensions of the desired weight matrix");
        }
        for (double w : this.weights = cloneWeights ? (double[])weights.clone() : weights) {
            if (!Double.isNaN(w)) continue;
            throw new IllegalArgumentException("Cannot create " + this.getClass().getName() + ": NaN weight is not allowed");
        }
        if (Double.isNaN(outsideWeight)) {
            throw new IllegalArgumentException("Cannot create " + this.getClass().getName() + ": NaN outside weight is not allowed");
        }
        this.outsideWeight = outsideWeight;
    }

    @Override
    public WeightedPattern shift(IPoint shift) {
        return new BasicWeightedPattern(this.parent.shift(shift.toPoint()), this.weightCoordMin.add(shift), this.weightCoordMax.add(shift), this.weights, this.outsideWeight, false);
    }

    @Override
    public WeightedPattern scale(double ... multipliers) {
        Objects.requireNonNull(multipliers, "Null multipliers argument");
        if (multipliers.length != this.dimCount()) {
            throw new IllegalArgumentException("Illegal number of multipliers: " + multipliers.length + " instead of " + this.dimCount());
        }
        int n = this.dimCount();
        Pattern newPattern = this.parent.scale(multipliers);
        IPoint newMin = this.weightCoordMin.roundedScale(multipliers);
        IPoint newMax = this.weightCoordMin.roundedScale(multipliers);
        long count = 1L;
        for (int k = 0; k < n; ++k) {
            IRange range = IRange.valueOf(newMin.coord(k), newMax.coord(k));
            if (range.size() < Integer.MAX_VALUE && (count *= range.size()) < Integer.MAX_VALUE) continue;
            throw new IllegalArgumentException("Too large desired weight matrix after resizing: more than 2^31-1 elements");
        }
        double[] newWeights = new double[(int)count];
        double newOutsideWeight = this.outsideWeight * newPattern.largePointCount() / this.largePointCount();
        BasicWeightedPattern result = new BasicWeightedPattern(newPattern, newMin, newMax, newWeights, newOutsideWeight, false);
        if (Math.abs(multipliers[0]) < 1.0) {
            Set<IPoint> points = this.roundedPoints();
            for (IPoint point : points) {
                IPoint newPoint = point.roundedScale(multipliers);
                int newIndex = result.weightIndex(newPoint);
                if (newIndex == -1) continue;
                int n2 = newIndex;
                newWeights[n2] = newWeights[n2] + this.weight(point);
            }
        } else {
            double multInv = 1.0 / multipliers[0];
            int[] duplicationCounts = new int[this.weights.length];
            Set<IPoint> newPoints = result.roundedPoints();
            for (IPoint newPoint : newPoints) {
                IPoint point = newPoint.multiply(multInv);
                int index = this.weightIndex(point);
                if (index == -1) continue;
                int n3 = index;
                duplicationCounts[n3] = duplicationCounts[n3] + 1;
            }
            for (IPoint newPoint : newPoints) {
                int newIndex = result.weightIndex(newPoint);
                if (newIndex == -1) continue;
                IPoint point = newPoint.multiply(multInv);
                int index = this.weightIndex(point);
                if (index != -1) {
                    newWeights[newIndex] = this.weights[index] / (double)duplicationCounts[index];
                    continue;
                }
                newWeights[newIndex] = newOutsideWeight;
            }
        }
        return result;
    }

    @Override
    public double weight(IPoint point) {
        int index = this.weightIndex(point);
        if (index == -1) {
            return this.outsideWeight;
        }
        return this.weights[index];
    }

    @Override
    public Range weightRange() {
        double max;
        double min;
        if (this.weightRange != null) {
            return this.weightRange;
        }
        if (this.weightCoordMin.equals(this.parent.coordMin().toRoundedPoint()) && this.weightCoordMax.equals(this.parent.coordMax().toRoundedPoint())) {
            min = this.weights[0];
            max = this.weights[0];
            for (int k = 1; k < this.weights.length; ++k) {
                if (this.weights[k] < min) {
                    min = this.weights[k];
                }
                if (!(this.weights[k] > max)) continue;
                max = this.weights[k];
            }
        } else {
            min = Double.POSITIVE_INFINITY;
            max = Double.NEGATIVE_INFINITY;
            for (IPoint point : this.roundedPoints()) {
                double w = this.weight(point);
                if (w < min) {
                    min = w;
                }
                if (!(w > max)) continue;
                max = w;
            }
        }
        this.weightRange = Range.valueOf(min, max);
        return this.weightRange;
    }

    int weightIndex(IPoint point) {
        int n = this.dimCount();
        long index = point.coord(n - 1);
        if (index < this.wcMin[n - 1] || index > this.wcMax[n - 1]) {
            return -1;
        }
        index -= this.wcMin[n - 1];
        for (int k = n - 2; k >= 0; --k) {
            long coord = point.coord(k);
            if (coord < this.wcMin[k] || coord > this.wcMax[k]) {
                return -1;
            }
            long dim = this.wcMax[k] - this.wcMin[k] + 1L;
            index = index * dim + (coord -= this.wcMin[k]);
        }
        assert (index <= Integer.MAX_VALUE);
        return (int)index;
    }
}

