/*
 * Decompiled with CFR 0.152.
 */
package net.algart.math.patterns;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import net.algart.math.Point;
import net.algart.math.Range;
import net.algart.math.patterns.AbstractPattern;
import net.algart.math.patterns.BasicDirectPointSetUniformGridPattern;
import net.algart.math.patterns.DirectPointSetPattern;
import net.algart.math.patterns.OnePointPattern;
import net.algart.math.patterns.Pattern;
import net.algart.math.patterns.TwoPointsPattern;

public class SimplePattern
extends AbstractPattern
implements DirectPointSetPattern {
    private final Set<Point> points;

    public SimplePattern(Collection<Point> points) {
        super(SimplePattern.getDimCountAndCheck(points));
        HashSet<Point> pointSet = new HashSet<Point>(points);
        if (SimplePattern.getDimCountAndCheck(pointSet) != this.dimCount) {
            throw new IllegalArgumentException("Points dimensions were changed in a parallel thread");
        }
        this.points = pointSet;
        this.fillCoordRangesWithCheck(this.points);
    }

    @Override
    public final long pointCount() {
        return this.points.size();
    }

    @Override
    public final Set<Point> points() {
        return Collections.unmodifiableSet(this.points);
    }

    @Override
    public Range coordRange(int coordIndex) {
        return this.coordRanges[coordIndex];
    }

    @Override
    public final boolean isSurelySinglePoint() {
        return this.points.size() == 1;
    }

    @Override
    public SimplePattern shift(Point shift) {
        Objects.requireNonNull(shift, "Null shift argument");
        if (shift.coordCount() != this.dimCount) {
            throw new IllegalArgumentException("The number of shift coordinates " + shift.coordCount() + " is not equal to the number of pattern coordinates " + this.dimCount);
        }
        HashSet<Point> resultPoints = new HashSet<Point>(this.points.size());
        for (Point p : this.points) {
            resultPoints.add(p.add(shift));
        }
        return new SimplePattern(resultPoints);
    }

    @Override
    public SimplePattern symmetric() {
        return (SimplePattern)super.symmetric();
    }

    @Override
    public SimplePattern multiply(double multiplier) {
        return (SimplePattern)super.multiply(multiplier);
    }

    @Override
    public SimplePattern scale(double ... multipliers) {
        Objects.requireNonNull(multipliers, "Null multipliers argument");
        if (multipliers.length != this.dimCount) {
            throw new IllegalArgumentException("Illegal number of multipliers: " + multipliers.length + " instead of " + this.dimCount);
        }
        multipliers = (double[])multipliers.clone();
        HashSet<Point> resultPoints = new HashSet<Point>(this.points.size());
        for (Point p : this.points) {
            resultPoints.add(p.scale(multipliers));
        }
        return new SimplePattern(resultPoints);
    }

    @Override
    public SimplePattern projectionAlongAxis(int coordIndex) {
        this.checkCoordIndex(coordIndex);
        assert (this.dimCount > 0);
        if (this.dimCount == 1) {
            throw new IllegalStateException("Cannot perform projection for 1-dimensional pattern");
        }
        HashSet<Point> resultPoints = new HashSet<Point>(this.points.size());
        for (Point p : this.points) {
            resultPoints.add(p.projectionAlongAxis(coordIndex));
        }
        return new SimplePattern(resultPoints);
    }

    @Override
    public SimplePattern minBound(int coordIndex) {
        return (SimplePattern)this.minBound(coordIndex, true);
    }

    @Override
    public SimplePattern maxBound(int coordIndex) {
        return (SimplePattern)this.maxBound(coordIndex, true);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.dimCount + "D multipoint common pattern containing " + this.points.size() + " points");
        if (this.pointCount() <= 32L) {
            sb.append(" ").append(this.points());
        }
        if (this.pointCount() <= 1024L) {
            sb.append(" inside ").append(this.coordArea());
        }
        return sb.toString();
    }

    public final int hashCode() {
        return this.points().hashCode();
    }

    public final boolean equals(Object obj) {
        return obj instanceof Pattern && SimplePattern.simplePatternsEqual(this, (Pattern)obj);
    }

    static int getDimCountAndCheck(Collection<Point> points) {
        Objects.requireNonNull(points, "Null points argument");
        int n = points.size();
        if (n == 0) {
            throw new IllegalArgumentException("Empty points set");
        }
        Iterator<Point> iterator = points.iterator();
        Point p = iterator.next();
        Objects.requireNonNull(p, "Null point is the collection");
        int result = p.coordCount();
        while (iterator.hasNext()) {
            p = iterator.next();
            Objects.requireNonNull(p, "Null point is the collection");
            if (p.coordCount() != result) {
                throw new IllegalArgumentException("Points dimensions mismatch: the first point has " + result + " coordinates, but some of points has " + p.coordCount());
            }
            SimplePattern.checkPoint(p);
        }
        return result;
    }

    static boolean simplePatternsEqual(Pattern first, Pattern second) {
        return second == first || (second instanceof SimplePattern || second instanceof BasicDirectPointSetUniformGridPattern || second instanceof TwoPointsPattern || second instanceof OnePointPattern) && second.points().equals(first.points());
    }
}

