/*
 * Decompiled with CFR 0.152.
 */
package net.algart.math.patterns;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.algart.math.Point;
import net.algart.math.Range;
import net.algart.math.patterns.AbstractPattern;
import net.algart.math.patterns.DirectPointSetPattern;
import net.algart.math.patterns.Pattern;
import net.algart.math.patterns.Patterns;
import net.algart.math.patterns.SimplePattern;

final class TwoPointsPattern
extends AbstractPattern
implements DirectPointSetPattern {
    private final Point p1;
    private final Point p2;

    TwoPointsPattern(Point p1, Point p2) {
        super(SimplePattern.getDimCountAndCheck(Arrays.asList(p1, p2)));
        if (p1.equals(p2)) {
            throw new AssertionError((Object)"Identical 2 points");
        }
        this.p1 = p1;
        this.p2 = p2;
        this.fillCoordRangesWithCheck(Arrays.asList(this.p1, this.p2));
    }

    @Override
    public long pointCount() {
        return 2L;
    }

    @Override
    public Set<Point> points() {
        HashSet<Point> resultPoints = new HashSet<Point>(2);
        resultPoints.add(this.p1);
        resultPoints.add(this.p2);
        return Collections.unmodifiableSet(resultPoints);
    }

    @Override
    public Range coordRange(int coordIndex) {
        return this.coordRanges[coordIndex];
    }

    @Override
    public boolean isSurelySinglePoint() {
        return false;
    }

    @Override
    public boolean isSurelyInteger() {
        return this.p1.isInteger() && this.p2.isInteger();
    }

    @Override
    public DirectPointSetPattern shift(Point shift) {
        Objects.requireNonNull(shift, "Null shift argument");
        if (shift.coordCount() != this.dimCount) {
            throw new IllegalArgumentException("The number of shift coordinates " + shift.coordCount() + " is not equal to the number of pattern coordinates " + this.dimCount);
        }
        if (shift.isOrigin()) {
            return this;
        }
        return new TwoPointsPattern(this.p1.add(shift), this.p2.add(shift));
    }

    @Override
    public DirectPointSetPattern scale(double ... multipliers) {
        Objects.requireNonNull(multipliers, "Null multipliers argument");
        if (multipliers.length != this.dimCount) {
            throw new IllegalArgumentException("Illegal number of multipliers: " + multipliers.length + " instead of " + this.dimCount);
        }
        boolean allUnit = true;
        for (double m : multipliers) {
            allUnit &= m == 1.0;
        }
        if (allUnit) {
            return this;
        }
        return Patterns.newPattern(this.p1.scale(multipliers), this.p2.scale(multipliers));
    }

    @Override
    public DirectPointSetPattern symmetric() {
        return (DirectPointSetPattern)super.symmetric();
    }

    @Override
    public DirectPointSetPattern multiply(double multiplier) {
        return (DirectPointSetPattern)super.multiply(multiplier);
    }

    @Override
    public DirectPointSetPattern projectionAlongAxis(int coordIndex) {
        this.checkCoordIndex(coordIndex);
        assert (this.dimCount > 0);
        if (this.dimCount == 1) {
            throw new IllegalStateException("Cannot perform projection for 1-dimensional pattern");
        }
        return Patterns.newPattern(this.p1.projectionAlongAxis(coordIndex), this.p2.projectionAlongAxis(coordIndex));
    }

    @Override
    public DirectPointSetPattern minBound(int coordIndex) {
        return (DirectPointSetPattern)super.minBound(coordIndex);
    }

    @Override
    public DirectPointSetPattern maxBound(int coordIndex) {
        return (DirectPointSetPattern)super.maxBound(coordIndex);
    }

    public String toString() {
        return this.dimCount + "D 2-point pattern (" + String.valueOf(this.p1) + " and " + String.valueOf(this.p2) + ")";
    }

    public int hashCode() {
        return this.points().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof Pattern && SimplePattern.simplePatternsEqual(this, (Pattern)obj);
    }
}

