/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.filters3x3;

import java.lang.reflect.Array;
import java.util.Objects;
import java.util.stream.IntStream;
import net.algart.arrays.Arrays;
import net.algart.arrays.DirectAccessible;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.matrices.Abstract2DProcessor;

public abstract class AbstractQuickFilter3x3
extends Abstract2DProcessor {
    final int rem1ForDimX;
    final int dimX;
    final int dimXm1;
    private final int dimXMul2;
    private final Object buffer3Lines;
    private final Object resultLine;
    private final int numberOfRanges;
    private final int[] splitters;
    private boolean multithreading = Arrays.SystemSettings.cpuCount() > 1;

    protected AbstractQuickFilter3x3(Class<?> elementType, long[] dimensions) {
        super(elementType, dimensions, 0x2AAAAAAA);
        this.dimX = this.dimX();
        this.dimXm1 = this.dimX - 1;
        this.rem1ForDimX = AbstractQuickFilter3x3.rem(1, this.dimX);
        this.dimXMul2 = 2 * this.dimX;
        this.buffer3Lines = Array.newInstance(elementType, 3 * this.dimX);
        this.resultLine = Array.newInstance(elementType, this.dimX);
        int reducedDimY = (int)Math.min(this.dimY(), Integer.MAX_VALUE);
        int cpuCount = Arrays.SystemSettings.cpuCount();
        this.numberOfRanges = cpuCount == 1 ? 1 : Math.min(reducedDimY, 4 * cpuCount);
        this.splitters = new int[this.numberOfRanges + 1];
        Arrays.splitToRanges(this.splitters, reducedDimY);
    }

    public boolean isMultithreading() {
        return this.multithreading;
    }

    public void setMultithreading(boolean multithreading) {
        this.multithreading = multithreading;
    }

    public int numberOfRanges() {
        return this.numberOfRanges;
    }

    public Matrix<UpdatablePArray> filter(Matrix<? extends PArray> source) {
        Matrix<UpdatablePArray> result = Arrays.SMM.newMatrix(UpdatablePArray.class, source);
        this.filter(result, source);
        return result;
    }

    public void filter(Matrix<? extends UpdatablePArray> result, Matrix<? extends PArray> source) {
        DirectAccessible da;
        Objects.requireNonNull(result, "Null result");
        Objects.requireNonNull(source, "Null source");
        this.checkCompatibility(result);
        this.checkCompatibility(source);
        if (source.isEmpty()) {
            return;
        }
        Object sourceArray = null;
        int sourceOffset = -1;
        if (source.array() instanceof DirectAccessible && (da = (DirectAccessible)((Object)source.array())).hasJavaArray()) {
            sourceArray = da.javaArray();
            sourceOffset = da.javaArrayOffset();
        }
        Object resultArray = null;
        int resultOffset = -1;
        if (result.array() instanceof DirectAccessible && (da = (DirectAccessible)((Object)result.array())).hasJavaArray()) {
            resultArray = da.javaArray();
            resultOffset = da.javaArrayOffset();
        }
        this.initialize();
        if (sourceArray == null || resultArray == null) {
            this.doFilter(result.array(), source.array());
        } else {
            this.doFilterForDirectAccessible(resultArray, resultOffset, sourceArray, sourceOffset);
        }
    }

    protected void initialize() {
    }

    protected abstract void process3Lines(Object var1, int var2, Object var3, int var4, int var5, int var6, int var7);

    private void doFilter(UpdatablePArray result, PArray source) {
        int dimX = this.dimX();
        long dimY = this.dimY();
        source.getData(this.matrixSize() - (long)dimX, this.buffer3Lines, 0, dimX);
        source.getData(0L, this.buffer3Lines, dimX, dimX);
        long matrixSizeMinusDimX = this.matrixSize() - (long)dimX;
        long y = 0L;
        long lineOffset = 0L;
        while (y < dimY) {
            long nextLineOffset = this.nextLineOffset(lineOffset);
            source.getData(nextLineOffset, this.buffer3Lines, this.dimXMul2, dimX);
            this.process3Lines(this.resultLine, 0, this.buffer3Lines, 0, dimX, this.dimXMul2, 0);
            result.setData(lineOffset, this.resultLine);
            if (lineOffset < matrixSizeMinusDimX) {
                System.arraycopy(this.buffer3Lines, dimX, this.buffer3Lines, 0, this.dimXMul2);
            }
            ++y;
            lineOffset += (long)dimX;
        }
    }

    private void doFilterForDirectAccessible(Object resultArray, int resultOffset, Object sourceArray, int sourceOffset) {
        int dimX = this.dimX();
        long dimY = this.dimY();
        assert (this.matrixSize() == (long)((int)this.matrixSize()));
        assert (dimY == (long)((int)dimY));
        if (this.isMultithreading()) {
            IntStream.range(0, this.numberOfRanges).parallel().forEach(rangeIndex -> {
                int from = this.splitters[rangeIndex];
                int to = this.splitters[rangeIndex + 1];
                int y = from;
                int lineOffset = y * dimX;
                while (y < to) {
                    this.processLine(resultArray, resultOffset, sourceArray, sourceOffset, lineOffset, rangeIndex);
                    ++y;
                    lineOffset += dimX;
                }
            });
        } else {
            int y = 0;
            int lineOffset = 0;
            while ((long)y < dimY) {
                this.processLine(resultArray, resultOffset, sourceArray, sourceOffset, lineOffset, 0);
                ++y;
                lineOffset += dimX;
            }
        }
    }

    private void processLine(Object resultArray, int resultOffset, Object sourceArray, int sourceOffset, int lineOffset, int multithreadingRangeIndex) {
        int previousLineOffset = (int)this.previousLineOffset(lineOffset);
        int nextLineOffset = (int)this.nextLineOffset(lineOffset);
        this.process3Lines(resultArray, resultOffset + lineOffset, sourceArray, sourceOffset + previousLineOffset, sourceOffset + lineOffset, sourceOffset + nextLineOffset, multithreadingRangeIndex);
    }
}

