/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.filters3x3;

import net.algart.matrices.filters3x3.AbstractQuickFilter3x3;

public abstract class DilationByCross3x3
extends AbstractQuickFilter3x3 {
    DilationByCross3x3(Class<?> elementType, long[] dimensions) {
        super(elementType, dimensions);
    }

    public static DilationByCross3x3 newInstance(Class<?> elementType, long dimX, long dimY) {
        return DilationByCross3x3.newInstance(elementType, new long[]{dimX, dimY});
    }

    public static DilationByCross3x3 newInstance(Class<?> elementType, long[] dimensions) {
        if (elementType == Character.TYPE) {
            return new ForChar(dimensions);
        }
        if (elementType == Boolean.TYPE) {
            return new ForBit(dimensions);
        }
        if (elementType == Byte.TYPE) {
            return new ForByte(dimensions);
        }
        if (elementType == Short.TYPE) {
            return new ForShort(dimensions);
        }
        if (elementType == Integer.TYPE) {
            return new ForInt(dimensions);
        }
        if (elementType == Long.TYPE) {
            return new ForLong(dimensions);
        }
        if (elementType == Float.TYPE) {
            return new ForFloat(dimensions);
        }
        if (elementType == Double.TYPE) {
            return new ForDouble(dimensions);
        }
        throw new UnsupportedOperationException("Non-primitive element type " + String.valueOf(elementType) + " is not supported");
    }

    private static class ForChar
    extends DilationByCross3x3 {
        private ForChar(long[] dimensions) {
            super(Character.TYPE, dimensions);
        }

        @Override
        protected void process3Lines(Object resultJavaArray, int resultLineOffset, Object sourceJavaArray, int firstLineOffset, int middleLineOffset, int lastLineOffset, int multithreadingRangeIndex) {
            char[] result = (char[])resultJavaArray;
            char[] source = (char[])sourceJavaArray;
            char vL = source[middleLineOffset + this.dimXm1];
            char vR = source[middleLineOffset + this.rem1ForDimX];
            char vU = source[firstLineOffset];
            char vD = source[lastLineOffset];
            char vC = source[middleLineOffset];
            result[resultLineOffset] = (char)ForChar.max(vL, vR, vU, vD, vC);
            int resultLineOffsetTo = resultLineOffset + this.dimX - 2;
            ++firstLineOffset;
            ++middleLineOffset;
            ++lastLineOffset;
            while (resultLineOffset < resultLineOffsetTo) {
                vL = vC;
                vC = vR;
                vR = source[++middleLineOffset];
                vU = source[firstLineOffset++];
                vD = source[lastLineOffset++];
                int max1 = Math.max(vL, vR);
                int max2 = Math.max(vU, vD);
                max1 = Math.max(max1, vC);
                result[++resultLineOffset] = (char)Math.max(max1, max2);
            }
            if (this.dimX >= 2) {
                vL = vC;
                vC = vR;
                vR = source[middleLineOffset - this.dimXm1];
                vU = source[firstLineOffset];
                vD = source[lastLineOffset];
                result[++resultLineOffset] = (char)ForChar.max(vL, vR, vU, vD, vC);
            }
        }

        private static int max(int w0, int w1, int w2, int w3, int w4) {
            int max1 = Math.max(w0, w1);
            int max2 = Math.max(w2, w3);
            max1 = Math.max(max1, w4);
            return Math.max(max1, max2);
        }
    }

    private static class ForBit
    extends DilationByCross3x3 {
        private ForBit(long[] dimensions) {
            super(Boolean.TYPE, dimensions);
        }

        @Override
        protected void process3Lines(Object resultJavaArray, int resultLineOffset, Object sourceJavaArray, int firstLineOffset, int middleLineOffset, int lastLineOffset, int multithreadingRangeIndex) {
            boolean[] result = (boolean[])resultJavaArray;
            boolean[] source = (boolean[])sourceJavaArray;
            boolean vL = source[middleLineOffset + this.dimXm1];
            boolean vR = source[middleLineOffset + this.rem1ForDimX];
            boolean vU = source[firstLineOffset];
            boolean vD = source[lastLineOffset];
            boolean vC = source[middleLineOffset];
            result[resultLineOffset] = vL || vR || vU || vD || vC;
            int resultLineOffsetTo = resultLineOffset + this.dimX - 2;
            ++firstLineOffset;
            ++middleLineOffset;
            ++lastLineOffset;
            while (resultLineOffset < resultLineOffsetTo) {
                vL = vC;
                vC = vR;
                vR = source[++middleLineOffset];
                vU = source[firstLineOffset++];
                vD = source[lastLineOffset++];
                result[++resultLineOffset] = vL || vR || vU || vD || vC;
            }
            if (this.dimX >= 2) {
                vL = vC;
                vC = vR;
                vR = source[middleLineOffset - this.dimXm1];
                vU = source[firstLineOffset];
                vD = source[lastLineOffset];
                result[++resultLineOffset] = vL || vR || vU || vD || vC;
            }
        }
    }

    private static class ForByte
    extends DilationByCross3x3 {
        private ForByte(long[] dimensions) {
            super(Byte.TYPE, dimensions);
        }

        @Override
        protected void process3Lines(Object resultJavaArray, int resultLineOffset, Object sourceJavaArray, int firstLineOffset, int middleLineOffset, int lastLineOffset, int multithreadingRangeIndex) {
            byte[] result = (byte[])resultJavaArray;
            byte[] source = (byte[])sourceJavaArray;
            int vL = source[middleLineOffset + this.dimXm1] & 0xFF;
            int vR = source[middleLineOffset + this.rem1ForDimX] & 0xFF;
            int vU = source[firstLineOffset] & 0xFF;
            int vD = source[lastLineOffset] & 0xFF;
            int vC = source[middleLineOffset] & 0xFF;
            result[resultLineOffset] = (byte)ForByte.max(vL, vR, vU, vD, vC);
            int resultLineOffsetTo = resultLineOffset + this.dimX - 2;
            ++firstLineOffset;
            ++middleLineOffset;
            ++lastLineOffset;
            while (resultLineOffset < resultLineOffsetTo) {
                vL = vC;
                vC = vR;
                vR = source[++middleLineOffset] & 0xFF;
                vU = source[firstLineOffset++] & 0xFF;
                vD = source[lastLineOffset++] & 0xFF;
                int max1 = Math.max(vL, vR);
                int max2 = Math.max(vU, vD);
                max1 = Math.max(max1, vC);
                result[++resultLineOffset] = (byte)Math.max(max1, max2);
            }
            if (this.dimX >= 2) {
                vL = vC;
                vC = vR;
                vR = source[middleLineOffset - this.dimXm1] & 0xFF;
                vU = source[firstLineOffset] & 0xFF;
                vD = source[lastLineOffset] & 0xFF;
                result[++resultLineOffset] = (byte)ForByte.max(vL, vR, vU, vD, vC);
            }
        }

        private static int max(int w0, int w1, int w2, int w3, int w4) {
            int max1 = Math.max(w0, w1);
            int max2 = Math.max(w2, w3);
            max1 = Math.max(max1, w4);
            return Math.max(max1, max2);
        }
    }

    private static class ForShort
    extends DilationByCross3x3 {
        private ForShort(long[] dimensions) {
            super(Short.TYPE, dimensions);
        }

        @Override
        protected void process3Lines(Object resultJavaArray, int resultLineOffset, Object sourceJavaArray, int firstLineOffset, int middleLineOffset, int lastLineOffset, int multithreadingRangeIndex) {
            short[] result = (short[])resultJavaArray;
            short[] source = (short[])sourceJavaArray;
            int vL = source[middleLineOffset + this.dimXm1] & 0xFFFF;
            int vR = source[middleLineOffset + this.rem1ForDimX] & 0xFFFF;
            int vU = source[firstLineOffset] & 0xFFFF;
            int vD = source[lastLineOffset] & 0xFFFF;
            int vC = source[middleLineOffset] & 0xFFFF;
            result[resultLineOffset] = (short)ForShort.max(vL, vR, vU, vD, vC);
            int resultLineOffsetTo = resultLineOffset + this.dimX - 2;
            ++firstLineOffset;
            ++middleLineOffset;
            ++lastLineOffset;
            while (resultLineOffset < resultLineOffsetTo) {
                vL = vC;
                vC = vR;
                vR = source[++middleLineOffset] & 0xFFFF;
                vU = source[firstLineOffset++] & 0xFFFF;
                vD = source[lastLineOffset++] & 0xFFFF;
                int max1 = Math.max(vL, vR);
                int max2 = Math.max(vU, vD);
                max1 = Math.max(max1, vC);
                result[++resultLineOffset] = (short)Math.max(max1, max2);
            }
            if (this.dimX >= 2) {
                vL = vC;
                vC = vR;
                vR = source[middleLineOffset - this.dimXm1] & 0xFFFF;
                vU = source[firstLineOffset] & 0xFFFF;
                vD = source[lastLineOffset] & 0xFFFF;
                result[++resultLineOffset] = (short)ForShort.max(vL, vR, vU, vD, vC);
            }
        }

        private static int max(int w0, int w1, int w2, int w3, int w4) {
            int max1 = Math.max(w0, w1);
            int max2 = Math.max(w2, w3);
            max1 = Math.max(max1, w4);
            return Math.max(max1, max2);
        }
    }

    private static class ForInt
    extends DilationByCross3x3 {
        private ForInt(long[] dimensions) {
            super(Integer.TYPE, dimensions);
        }

        @Override
        protected void process3Lines(Object resultJavaArray, int resultLineOffset, Object sourceJavaArray, int firstLineOffset, int middleLineOffset, int lastLineOffset, int multithreadingRangeIndex) {
            int[] result = (int[])resultJavaArray;
            int[] source = (int[])sourceJavaArray;
            int vL = source[middleLineOffset + this.dimXm1];
            int vR = source[middleLineOffset + this.rem1ForDimX];
            int vU = source[firstLineOffset];
            int vD = source[lastLineOffset];
            int vC = source[middleLineOffset];
            result[resultLineOffset] = ForInt.max(vL, vR, vU, vD, vC);
            int resultLineOffsetTo = resultLineOffset + this.dimX - 2;
            ++firstLineOffset;
            ++middleLineOffset;
            ++lastLineOffset;
            while (resultLineOffset < resultLineOffsetTo) {
                vL = vC;
                vC = vR;
                vR = source[++middleLineOffset];
                vU = source[firstLineOffset++];
                vD = source[lastLineOffset++];
                int max1 = Math.max(vL, vR);
                int max2 = Math.max(vU, vD);
                max1 = Math.max(max1, vC);
                result[++resultLineOffset] = Math.max(max1, max2);
            }
            if (this.dimX >= 2) {
                vL = vC;
                vC = vR;
                vR = source[middleLineOffset - this.dimXm1];
                vU = source[firstLineOffset];
                vD = source[lastLineOffset];
                result[++resultLineOffset] = ForInt.max(vL, vR, vU, vD, vC);
            }
        }

        private static int max(int w0, int w1, int w2, int w3, int w4) {
            int max1 = Math.max(w0, w1);
            int max2 = Math.max(w2, w3);
            max1 = Math.max(max1, w4);
            return Math.max(max1, max2);
        }
    }

    private static class ForLong
    extends DilationByCross3x3 {
        private ForLong(long[] dimensions) {
            super(Long.TYPE, dimensions);
        }

        @Override
        protected void process3Lines(Object resultJavaArray, int resultLineOffset, Object sourceJavaArray, int firstLineOffset, int middleLineOffset, int lastLineOffset, int multithreadingRangeIndex) {
            long[] result = (long[])resultJavaArray;
            long[] source = (long[])sourceJavaArray;
            long vL = source[middleLineOffset + this.dimXm1];
            long vR = source[middleLineOffset + this.rem1ForDimX];
            long vU = source[firstLineOffset];
            long vD = source[lastLineOffset];
            long vC = source[middleLineOffset];
            result[resultLineOffset] = ForLong.max(vL, vR, vU, vD, vC);
            int resultLineOffsetTo = resultLineOffset + this.dimX - 2;
            ++firstLineOffset;
            ++middleLineOffset;
            ++lastLineOffset;
            while (resultLineOffset < resultLineOffsetTo) {
                vL = vC;
                vC = vR;
                vR = source[++middleLineOffset];
                vU = source[firstLineOffset++];
                vD = source[lastLineOffset++];
                long max1 = Math.max(vL, vR);
                long max2 = Math.max(vU, vD);
                max1 = Math.max(max1, vC);
                result[++resultLineOffset] = Math.max(max1, max2);
            }
            if (this.dimX >= 2) {
                vL = vC;
                vC = vR;
                vR = source[middleLineOffset - this.dimXm1];
                vU = source[firstLineOffset];
                vD = source[lastLineOffset];
                result[++resultLineOffset] = ForLong.max(vL, vR, vU, vD, vC);
            }
        }

        private static long max(long w0, long w1, long w2, long w3, long w4) {
            long max1 = Math.max(w0, w1);
            long max2 = Math.max(w2, w3);
            max1 = Math.max(max1, w4);
            return Math.max(max1, max2);
        }
    }

    private static class ForFloat
    extends DilationByCross3x3 {
        private ForFloat(long[] dimensions) {
            super(Float.TYPE, dimensions);
        }

        @Override
        protected void process3Lines(Object resultJavaArray, int resultLineOffset, Object sourceJavaArray, int firstLineOffset, int middleLineOffset, int lastLineOffset, int multithreadingRangeIndex) {
            float[] result = (float[])resultJavaArray;
            float[] source = (float[])sourceJavaArray;
            float vL = source[middleLineOffset + this.dimXm1];
            float vR = source[middleLineOffset + this.rem1ForDimX];
            float vU = source[firstLineOffset];
            float vD = source[lastLineOffset];
            float vC = source[middleLineOffset];
            result[resultLineOffset] = ForFloat.max(vL, vR, vU, vD, vC);
            int resultLineOffsetTo = resultLineOffset + this.dimX - 2;
            ++firstLineOffset;
            ++middleLineOffset;
            ++lastLineOffset;
            while (resultLineOffset < resultLineOffsetTo) {
                vL = vC;
                vC = vR;
                vR = source[++middleLineOffset];
                vU = source[firstLineOffset++];
                vD = source[lastLineOffset++];
                float max1 = Math.max(vL, vR);
                float max2 = Math.max(vU, vD);
                max1 = Math.max(max1, vC);
                result[++resultLineOffset] = Math.max(max1, max2);
            }
            if (this.dimX >= 2) {
                vL = vC;
                vC = vR;
                vR = source[middleLineOffset - this.dimXm1];
                vU = source[firstLineOffset];
                vD = source[lastLineOffset];
                result[++resultLineOffset] = ForFloat.max(vL, vR, vU, vD, vC);
            }
        }

        private static float max(float w0, float w1, float w2, float w3, float w4) {
            float max1 = Math.max(w0, w1);
            float max2 = Math.max(w2, w3);
            max1 = Math.max(max1, w4);
            return Math.max(max1, max2);
        }
    }

    private static class ForDouble
    extends DilationByCross3x3 {
        private ForDouble(long[] dimensions) {
            super(Double.TYPE, dimensions);
        }

        @Override
        protected void process3Lines(Object resultJavaArray, int resultLineOffset, Object sourceJavaArray, int firstLineOffset, int middleLineOffset, int lastLineOffset, int multithreadingRangeIndex) {
            double[] result = (double[])resultJavaArray;
            double[] source = (double[])sourceJavaArray;
            double vL = source[middleLineOffset + this.dimXm1];
            double vR = source[middleLineOffset + this.rem1ForDimX];
            double vU = source[firstLineOffset];
            double vD = source[lastLineOffset];
            double vC = source[middleLineOffset];
            result[resultLineOffset] = ForDouble.max(vL, vR, vU, vD, vC);
            int resultLineOffsetTo = resultLineOffset + this.dimX - 2;
            ++firstLineOffset;
            ++middleLineOffset;
            ++lastLineOffset;
            while (resultLineOffset < resultLineOffsetTo) {
                vL = vC;
                vC = vR;
                vR = source[++middleLineOffset];
                vU = source[firstLineOffset++];
                vD = source[lastLineOffset++];
                double max1 = Math.max(vL, vR);
                double max2 = Math.max(vU, vD);
                max1 = Math.max(max1, vC);
                result[++resultLineOffset] = Math.max(max1, max2);
            }
            if (this.dimX >= 2) {
                vL = vC;
                vC = vR;
                vR = source[middleLineOffset - this.dimXm1];
                vU = source[firstLineOffset];
                vD = source[lastLineOffset];
                result[++resultLineOffset] = ForDouble.max(vL, vR, vU, vD, vC);
            }
        }

        private static double max(double w0, double w1, double w2, double w3, double w4) {
            double max1 = Math.max(w0, w1);
            double max2 = Math.max(w2, w3);
            max1 = Math.max(max1, w4);
            return Math.max(max1, max2);
        }
    }
}

