/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.morphology;

import java.util.Objects;
import net.algart.arrays.AbstractBitArray;
import net.algart.arrays.AbstractByteArray;
import net.algart.arrays.AbstractCharArray;
import net.algart.arrays.AbstractDoubleArray;
import net.algart.arrays.AbstractFloatArray;
import net.algart.arrays.AbstractIntArray;
import net.algart.arrays.AbstractLongArray;
import net.algart.arrays.AbstractShortArray;
import net.algart.arrays.Array;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.ArrayPool;
import net.algart.arrays.Arrays;
import net.algart.arrays.BitArray;
import net.algart.arrays.ByteArray;
import net.algart.arrays.CharArray;
import net.algart.arrays.DirectAccessible;
import net.algart.arrays.DoubleArray;
import net.algart.arrays.FloatArray;
import net.algart.arrays.Histogram;
import net.algart.arrays.IntArray;
import net.algart.arrays.JArrayPool;
import net.algart.arrays.LongArray;
import net.algart.arrays.PArray;
import net.algart.arrays.PFloatingArray;
import net.algart.arrays.PIntegerArray;
import net.algart.arrays.ShortArray;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.arrays.UpdatablePArray;
import net.algart.arrays.UpdatablePIntegerArray;
import net.algart.math.functions.Func;
import net.algart.matrices.morphology.HistogramCache;
import net.algart.matrices.morphology.RankOperationProcessor;

class Percentiler
extends RankOperationProcessor {
    private final boolean optimizeGetData = OPTIMIZE_GET_DATA;
    private final boolean optimizeDirectArrays = OPTIMIZE_DIRECT_ARRAYS;
    private final boolean inlineOneLevel = INLINE_ONE_LEVEL;
    final boolean interpolated;

    Percentiler(ArrayContext context, boolean interpolated, int[] bitLevels) {
        super(context, bitLevels);
        this.interpolated = interpolated;
    }

    @Override
    PArray asProcessed(Class<? extends PArray> desiredType, PArray src, PArray[] additional, long[] dimensions, final long[] shifts, final long[] left, final long[] right) {
        ArrayPool ap;
        if (additional.length == 0) {
            throw new IllegalArgumentException("One additional matrix is required (percentile indexes)");
        }
        assert (shifts.length > 0);
        assert (left.length == right.length);
        boolean direct = this.optimizeDirectArrays && src instanceof DirectAccessible && ((DirectAccessible)((Object)src)).hasJavaArray();
        final PArray fPerc = additional[0] instanceof PIntegerArray || src instanceof PFloatingArray || this.interpolated ? additional[0] : Arrays.asFuncArray(true, Func.IDENTITY, LongArray.class, additional[0]);
        final PIntegerArray iPerc = fPerc instanceof PIntegerArray ? (PIntegerArray)fPerc : null;
        ArrayPool arrayPool = ap = this.optimizeDirectArrays && (Arrays.isNCopies(fPerc) || SimpleMemoryModel.isSimpleArray(fPerc)) ? null : ArrayPool.getInstance(Arrays.SMM, fPerc.elementType(), 65536L);
        if (src instanceof BitArray) {
            final BitArray a = (BitArray)src;
            final HistogramCache histogramCache = new HistogramCache();
            return new AbstractBitArray(src.length(), true, new Array[]{src}){

                @Override
                public boolean getBit(long index) {
                    double weightedMeanStripe;
                    long r;
                    double rank;
                    if (iPerc != null) {
                        rank = -1.0;
                        r = iPerc.getLong(index);
                    } else {
                        rank = fPerc.getDouble(index);
                        Percentiler.checkNaN(rank);
                        r = (long)rank;
                    }
                    if (r >= (long)shifts.length) {
                        return true;
                    }
                    int leftBar = 0;
                    for (long shift : shifts) {
                        long i = index - shift;
                        if (i < 0L) {
                            i += this.length;
                        }
                        if (a.getBit(i)) continue;
                        ++leftBar;
                    }
                    if (r < 0L) {
                        return leftBar == 0;
                    }
                    if (iPerc != null) {
                        return r >= (long)leftBar;
                    }
                    if (r >= (long)leftBar || r == (long)(shifts.length - 1)) {
                        return leftBar < shifts.length;
                    }
                    if (r < (long)(leftBar - 1)) {
                        assert (leftBar > 0);
                        return false;
                    }
                    assert (r >= 0L && r == (long)(leftBar - 1));
                    int rightBar = shifts.length - leftBar;
                    double leftStripe = leftBar == 1 ? 1.0 : 1.0 / (double)leftBar;
                    double fraction = rank - (double)r;
                    double newPreciseValue = ((double)(leftBar - 1) + fraction) * leftStripe;
                    double d = weightedMeanStripe = leftBar == rightBar ? leftStripe : leftStripe + (rank - (double)r) * (1.0 / (double)rightBar - leftStripe);
                    assert (weightedMeanStripe >= -0.001);
                    double rangeCenter = newPreciseValue + 0.5 * Math.max(weightedMeanStripe, 1.0E-10);
                    return rangeCenter >= 1.0;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    if (!Percentiler.this.optimizeGetData) {
                        super.getData(arrayPos, destArray, destArrayOffset, count);
                        return;
                    }
                    Objects.requireNonNull(destArray, "Null destArray argument");
                    Percentiler.checkRanges(this.length, arrayPos, count);
                    if (count == 0) {
                        return;
                    }
                    boolean[] dest = (boolean[])destArray;
                    UpdatablePArray buf = ap == null ? null : (UpdatablePArray)ap.requestArray();
                    int bufLen = ap == null ? count : 65536;
                    int[] hist = (int[])histogramCache.get(arrayPos);
                    if (hist == null) {
                        hist = new int[1];
                        for (long shift : shifts) {
                            long i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            if (a.getBit(i)) continue;
                            hist[0] = hist[0] + 1;
                        }
                    }
                    while (count > 0) {
                        int len = Math.min(bufLen, count);
                        if (ap != null) {
                            buf.copy(fPerc.subArr(arrayPos, len));
                        }
                        int k = 0;
                        while (k < len) {
                            boolean v;
                            if (iPerc != null) {
                                long r;
                                long l = r = ap != null ? ((PIntegerArray)((Object)buf)).getLong(k) : iPerc.getLong(arrayPos);
                                v = r < 0L ? hist[0] == 0 : r >= (long)hist[0];
                            } else {
                                double rank = ap != null ? buf.getDouble(k) : fPerc.getDouble(arrayPos);
                                Percentiler.checkNaN(rank);
                                long r = (long)rank;
                                int leftBar = hist[0];
                                if (r >= (long)shifts.length) {
                                    v = true;
                                } else if (r >= (long)leftBar || r == (long)(shifts.length - 1)) {
                                    v = leftBar < shifts.length;
                                } else if (r < 0L || r < (long)(leftBar - 1)) {
                                    v = leftBar == 0;
                                } else {
                                    double weightedMeanStripe;
                                    assert (r >= 0L && r == (long)(leftBar - 1));
                                    int rightBar = shifts.length - leftBar;
                                    double leftStripe = leftBar == 1 ? 1.0 : 1.0 / (double)leftBar;
                                    double fraction = rank - (double)r;
                                    double newPreciseValue = ((double)(leftBar - 1) + fraction) * leftStripe;
                                    double d = weightedMeanStripe = leftBar == rightBar ? leftStripe : leftStripe + (rank - (double)r) * (1.0 / (double)rightBar - leftStripe);
                                    assert (weightedMeanStripe >= -0.001);
                                    double rangeCenter = newPreciseValue + 0.5 * Math.max(weightedMeanStripe, 1.0E-10);
                                    v = rangeCenter >= 1.0;
                                }
                            }
                            dest[destArrayOffset] = v;
                            for (long shift : right) {
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if (a.getBit(i)) continue;
                                hist[0] = hist[0] - 1;
                                assert (hist[0] >= 0) : "Unbalanced 0 and 1 bits";
                            }
                            if (++arrayPos == this.length) {
                                arrayPos = 0L;
                            }
                            for (long shift : left) {
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if (a.getBit(i)) continue;
                                hist[0] = hist[0] + 1;
                            }
                            ++k;
                            ++destArrayOffset;
                        }
                        count -= bufLen;
                    }
                    histogramCache.put(arrayPos, hist);
                    if (ap != null) {
                        ap.releaseArray(buf);
                    }
                }
            };
        }
        if (src instanceof CharArray) {
            final CharArray a = (CharArray)src;
            final int nab = Math.min(this.numberOfAnalyzedBits, 16);
            final int bs = 16 - nab;
            if (direct) {
                boolean implementHere;
                final char[] ja = (char[])((DirectAccessible)((Object)a)).javaArray();
                final int jaOfs = ((DirectAccessible)((Object)a)).javaArrayOffset();
                boolean bl = implementHere = this.inlineOneLevel && this.bitLevels.length == 0;
                if (implementHere && iPerc != null) {
                    final HistogramCache histogramCache = new HistogramCache();
                    return new AbstractCharArray(src.length(), true, new Array[]{src}){

                        @Override
                        public char getChar(long index) {
                            long percentileIndex = iPerc.getLong(index);
                            int[] hist = new int[1 << nab];
                            for (long shift : shifts) {
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int n = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                hist[n] = hist[n] + 1;
                            }
                            int p = Math.min(Histogram.iValue(hist, percentileIndex), hist.length - 1);
                            return (char)(p << bs);
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            if (!Percentiler.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            Percentiler.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            char[] dest = (char[])destArray;
                            UpdatablePIntegerArray buf = ap == null ? null : (UpdatablePIntegerArray)ap.requestArray();
                            int bufLen = ap == null ? count : 65536;
                            int[] hist = (int[])histogramCache.get(arrayPos);
                            if (hist == null) {
                                hist = new int[1 << nab];
                                for (long shift : shifts) {
                                    long i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    int n = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                    hist[n] = hist[n] + 1;
                                }
                            }
                            int currentIValue = 0;
                            int currentIRank = 0;
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (ap != null) {
                                    buf.copy(fPerc.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    int value;
                                    long i;
                                    long percentileIndex;
                                    long l = percentileIndex = ap != null ? buf.getLong(k) : iPerc.getLong(arrayPos);
                                    if (percentileIndex < 0L) {
                                        percentileIndex = 0L;
                                    } else if (percentileIndex > (long)shifts.length) {
                                        percentileIndex = shifts.length;
                                    }
                                    if (percentileIndex < (long)currentIRank) {
                                        while (percentileIndex < (long)(currentIRank -= hist[--currentIValue])) {
                                        }
                                        assert (currentIRank >= 0);
                                    } else if (percentileIndex < (long)shifts.length) {
                                        int b = hist[currentIValue];
                                        while (percentileIndex >= (long)(currentIRank + b)) {
                                            currentIRank += b;
                                            b = hist[++currentIValue];
                                        }
                                        assert (currentIRank < shifts.length);
                                    } else if (currentIRank == shifts.length) {
                                        assert (currentIValue == hist.length || hist[currentIValue] == 0);
                                        assert (currentIValue > 0);
                                        while (hist[currentIValue - 1] == 0) {
                                            assert (--currentIValue > 0);
                                        }
                                    } else {
                                        assert (currentIRank < shifts.length);
                                        while ((currentIRank += hist[++currentIValue]) < shifts.length) {
                                        }
                                        assert (currentIRank == shifts.length);
                                    }
                                    dest[destArrayOffset] = (char)(Math.min(currentIValue, hist.length - 1) << bs);
                                    for (long shift : right) {
                                        i = arrayPos - shift;
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        int n = value = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                        hist[n] = hist[n] - 1;
                                        if (hist[n] < 0) {
                                            throw new AssertionError((Object)("Disbalance in the histogram: negative number " + hist[value] + " of occurrences of " + value + " value"));
                                        }
                                        if (value >= currentIValue) continue;
                                        --currentIRank;
                                    }
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (long shift : left) {
                                        i = arrayPos - shift;
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        int n = value = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                        hist[n] = hist[n] + 1;
                                        if (value >= currentIValue) continue;
                                        ++currentIRank;
                                    }
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            histogramCache.put(arrayPos, hist);
                            if (ap != null) {
                                ap.releaseArray(buf);
                            }
                        }
                    };
                }
                if (implementHere) {
                    assert (iPerc == null);
                    final HistogramCache histogramCache = new HistogramCache();
                    return new AbstractCharArray(src.length(), true, new Array[]{src}){

                        @Override
                        public char getChar(long index) {
                            double percentileIndex = fPerc.getDouble(index);
                            Percentiler.checkNaN(percentileIndex);
                            int[] hist = new int[1 << nab];
                            for (long shift : shifts) {
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int n = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                hist[n] = hist[n] + 1;
                            }
                            int p = Math.min(Histogram.iPreciseValue(hist, percentileIndex), hist.length - 1);
                            return (char)(p << bs);
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            if (!Percentiler.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            Percentiler.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            char[] dest = (char[])destArray;
                            UpdatablePArray buf = ap == null ? null : (UpdatablePArray)ap.requestArray();
                            int bufLen = ap == null ? count : 65536;
                            int[] hist = (int[])histogramCache.get(arrayPos);
                            if (hist == null) {
                                hist = new int[1 << nab];
                                for (long shift : shifts) {
                                    long i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    int n = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                    hist[n] = hist[n] + 1;
                                }
                            }
                            int currentIValue = 0;
                            int currentIRank = 0;
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (ap != null) {
                                    buf.copy(fPerc.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    long i;
                                    int r;
                                    double percentileIndex = ap != null ? buf.getDouble(k) : fPerc.getDouble(arrayPos);
                                    Percentiler.checkNaN(percentileIndex);
                                    if (percentileIndex < 0.0) {
                                        r = 0;
                                        percentileIndex = 0;
                                    } else if (percentileIndex > (double)shifts.length) {
                                        r = shifts.length;
                                        percentileIndex = r;
                                    } else {
                                        r = (int)percentileIndex;
                                    }
                                    if (r < currentIRank) {
                                        while (r < (currentIRank -= hist[--currentIValue])) {
                                        }
                                        assert (currentIRank >= 0);
                                    } else if (r < shifts.length) {
                                        int b = hist[currentIValue];
                                        while (r >= currentIRank + b) {
                                            currentIRank += b;
                                            b = hist[++currentIValue];
                                        }
                                        assert (currentIRank < shifts.length);
                                    } else if (currentIRank == shifts.length) {
                                        assert (currentIValue == hist.length || hist[currentIValue] == 0);
                                        assert (currentIValue > 0);
                                        while (hist[currentIValue - 1] == 0) {
                                            assert (--currentIValue > 0);
                                        }
                                    } else {
                                        assert (currentIRank < shifts.length);
                                        while ((currentIRank += hist[++currentIValue]) < shifts.length) {
                                        }
                                        assert (currentIRank == shifts.length);
                                    }
                                    if (r < shifts.length - 1) {
                                        int leftValue = currentIValue;
                                        int indexInBar = r - currentIRank;
                                        int leftBar = hist[currentIValue];
                                        assert (indexInBar < leftBar);
                                        if ((double)r != percentileIndex && indexInBar == leftBar - 1) {
                                            double weightedMeanStripe;
                                            int leftRank = currentIRank;
                                            double leftPreciseValue = leftBar == 1 ? (double)leftValue : (double)leftValue + (double)indexInBar / (double)leftBar;
                                            assert (r + 1 == (currentIRank += leftBar));
                                            int rightBar = hist[++currentIValue];
                                            while (rightBar == 0) {
                                                rightBar = hist[++currentIValue];
                                            }
                                            assert (currentIRank < shifts.length);
                                            double newPreciseValue = leftPreciseValue + (percentileIndex - (double)r) * ((double)currentIValue - leftPreciseValue);
                                            double leftStripe = leftBar == 1 ? 1.0 : 1.0 / (double)leftBar;
                                            double d = weightedMeanStripe = leftBar == rightBar ? leftStripe : leftStripe + (percentileIndex - (double)r) * (1.0 / (double)rightBar - leftStripe);
                                            assert (weightedMeanStripe >= -0.001);
                                            double rangeCenter = newPreciseValue + 0.5 * Math.max(weightedMeanStripe, 1.0E-10);
                                            currentIValue = (int)rangeCenter;
                                            if (currentIValue == leftValue) {
                                                currentIRank = leftRank;
                                            }
                                        }
                                    }
                                    dest[destArrayOffset] = (char)(Math.min(currentIValue, hist.length - 1) << bs);
                                    for (long shift : right) {
                                        int value;
                                        i = arrayPos - shift;
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        int n = value = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                        hist[n] = hist[n] - 1;
                                        if (hist[n] < 0) {
                                            throw new AssertionError((Object)("Disbalance in the histogram: negative number " + hist[value] + " of occurrences of " + value + " value"));
                                        }
                                        if (value >= currentIValue) continue;
                                        --currentIRank;
                                    }
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (long shift : left) {
                                        int value;
                                        i = arrayPos - shift;
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        int n = value = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                        hist[n] = hist[n] + 1;
                                        if (value >= currentIValue) continue;
                                        ++currentIRank;
                                    }
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            histogramCache.put(arrayPos, hist);
                            if (ap != null) {
                                ap.releaseArray(buf);
                            }
                        }
                    };
                }
                if (iPerc != null) {
                    assert (!implementHere);
                    final HistogramCache histogramCache = new HistogramCache();
                    final JArrayPool indexesPool = JArrayPool.getInstance(Integer.TYPE, left.length);
                    return new AbstractCharArray(src.length(), true, new Array[]{src}){

                        @Override
                        public char getChar(long index) {
                            long percentileIndex = iPerc.getLong(index);
                            int[] hist = new int[1 << nab];
                            for (long shift : shifts) {
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int n = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                hist[n] = hist[n] + 1;
                            }
                            int p = Math.min(Histogram.iValue(hist, percentileIndex), hist.length - 1);
                            return (char)(p << bs);
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            if (!Percentiler.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            Percentiler.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            char[] dest = (char[])destArray;
                            UpdatablePIntegerArray buf = ap == null ? null : (UpdatablePIntegerArray)ap.requestArray();
                            int bufLen = ap == null ? count : 65536;
                            Histogram hist = (Histogram)histogramCache.get(arrayPos);
                            if (hist == null) {
                                hist = Histogram.newIntHistogram(1 << nab, Percentiler.this.bitLevels);
                                for (long shift : shifts) {
                                    long i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    hist.include((ja[jaOfs + (int)i] & 0xFFFF) >> bs);
                                }
                            }
                            int[] barIndexes = (int[])indexesPool.requestArray();
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (ap != null) {
                                    buf.copy(fPerc.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    long i;
                                    int j;
                                    long percentileIndex = ap != null ? buf.getLong(k) : iPerc.getLong(arrayPos);
                                    hist.moveToIRank(percentileIndex);
                                    dest[destArrayOffset] = (char)(Math.min(hist.currentIValue(), hist.length() - 1) << bs);
                                    for (j = 0; j < right.length; ++j) {
                                        i = arrayPos - right[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        barIndexes[j] = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                    }
                                    hist.exclude(barIndexes);
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (j = 0; j < left.length; ++j) {
                                        i = arrayPos - left[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        barIndexes[j] = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                    }
                                    hist.include(barIndexes);
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            indexesPool.releaseArray(barIndexes);
                            histogramCache.put(arrayPos, hist);
                            if (ap != null) {
                                ap.releaseArray(buf);
                            }
                        }
                    };
                }
                assert (iPerc == null);
                final HistogramCache histogramCache = new HistogramCache();
                final JArrayPool indexesPool = JArrayPool.getInstance(Integer.TYPE, left.length);
                return new AbstractCharArray(src.length(), true, new Array[]{src}){

                    @Override
                    public char getChar(long index) {
                        double percentileIndex = fPerc.getDouble(index);
                        Percentiler.checkNaN(percentileIndex);
                        int[] hist = new int[1 << nab];
                        for (long shift : shifts) {
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            int n = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                            hist[n] = hist[n] + 1;
                        }
                        int p = Math.min(Histogram.iPreciseValue(hist, percentileIndex), hist.length - 1);
                        return (char)(p << bs);
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!Percentiler.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        Percentiler.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        char[] dest = (char[])destArray;
                        UpdatablePArray buf = ap == null ? null : (UpdatablePArray)ap.requestArray();
                        int bufLen = ap == null ? count : 65536;
                        Histogram hist = (Histogram)histogramCache.get(arrayPos);
                        if (hist == null) {
                            hist = Histogram.newIntHistogram(1 << nab, Percentiler.this.bitLevels);
                            for (long shift : shifts) {
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist.include((ja[jaOfs + (int)i] & 0xFFFF) >> bs);
                            }
                        }
                        int[] barIndexes = (int[])indexesPool.requestArray();
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (ap != null) {
                                buf.copy(fPerc.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                long i;
                                int j;
                                double percentileIndex = ap != null ? buf.getDouble(k) : fPerc.getDouble(arrayPos);
                                hist.moveToPreciseRank(percentileIndex);
                                dest[destArrayOffset] = (char)(Math.min(hist.currentIValue(), hist.length() - 1) << bs);
                                for (j = 0; j < right.length; ++j) {
                                    i = arrayPos - right[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    barIndexes[j] = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                }
                                hist.exclude(barIndexes);
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (j = 0; j < left.length; ++j) {
                                    i = arrayPos - left[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    barIndexes[j] = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                }
                                hist.include(barIndexes);
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        indexesPool.releaseArray(barIndexes);
                        histogramCache.put(arrayPos, hist);
                        if (ap != null) {
                            ap.releaseArray(buf);
                        }
                    }
                };
            }
            if (iPerc != null) {
                final HistogramCache histogramCache = new HistogramCache();
                return new AbstractCharArray(src.length(), true, new Array[]{src}){

                    @Override
                    public char getChar(long index) {
                        long percentileIndex = iPerc.getLong(index);
                        int[] hist = new int[1 << nab];
                        for (long shift : shifts) {
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            int n = a.getInt(i) >> bs;
                            hist[n] = hist[n] + 1;
                        }
                        int p = Math.min(Histogram.iValue(hist, percentileIndex), hist.length - 1);
                        return (char)(p << bs);
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!Percentiler.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        Percentiler.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        char[] dest = (char[])destArray;
                        UpdatablePIntegerArray buf = ap == null ? null : (UpdatablePIntegerArray)ap.requestArray();
                        int bufLen = ap == null ? count : 65536;
                        Histogram hist = (Histogram)histogramCache.get(arrayPos);
                        if (hist == null) {
                            hist = Histogram.newIntHistogram(1 << nab, Percentiler.this.bitLevels);
                            for (long shift : shifts) {
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist.include(a.getInt(i) >> bs);
                            }
                        }
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (ap != null) {
                                buf.copy(fPerc.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                long i;
                                long percentileIndex = ap != null ? buf.getLong(k) : iPerc.getLong(arrayPos);
                                hist.moveToIRank(percentileIndex);
                                dest[destArrayOffset] = (char)(Math.min(hist.currentIValue(), hist.length() - 1) << bs);
                                for (long shift : right) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    hist.exclude(a.getInt(i) >> bs);
                                }
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (long shift : left) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    hist.include(a.getInt(i) >> bs);
                                }
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        histogramCache.put(arrayPos, hist);
                        if (ap != null) {
                            ap.releaseArray(buf);
                        }
                    }
                };
            }
            assert (iPerc == null);
            final HistogramCache histogramCache = new HistogramCache();
            return new AbstractCharArray(src.length(), true, new Array[]{src}){

                @Override
                public char getChar(long index) {
                    double percentileIndex = fPerc.getDouble(index);
                    Percentiler.checkNaN(percentileIndex);
                    int[] hist = new int[1 << nab];
                    for (long shift : shifts) {
                        long i = index - shift;
                        if (i < 0L) {
                            i += this.length;
                        }
                        int n = a.getInt(i) >> bs;
                        hist[n] = hist[n] + 1;
                    }
                    int p = Math.min(Histogram.iPreciseValue(hist, percentileIndex), hist.length - 1);
                    return (char)(p << bs);
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    if (!Percentiler.this.optimizeGetData) {
                        super.getData(arrayPos, destArray, destArrayOffset, count);
                        return;
                    }
                    Objects.requireNonNull(destArray, "Null destArray argument");
                    Percentiler.checkRanges(this.length, arrayPos, count);
                    if (count == 0) {
                        return;
                    }
                    char[] dest = (char[])destArray;
                    UpdatablePArray buf = ap == null ? null : (UpdatablePArray)ap.requestArray();
                    int bufLen = ap == null ? count : 65536;
                    Histogram hist = (Histogram)histogramCache.get(arrayPos);
                    if (hist == null) {
                        hist = Histogram.newIntHistogram(1 << nab, Percentiler.this.bitLevels);
                        for (long shift : shifts) {
                            long i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            hist.include(a.getInt(i) >> bs);
                        }
                    }
                    while (count > 0) {
                        int len = Math.min(bufLen, count);
                        if (ap != null) {
                            buf.copy(fPerc.subArr(arrayPos, len));
                        }
                        int k = 0;
                        while (k < len) {
                            long i;
                            double percentileIndex = ap != null ? buf.getDouble(k) : fPerc.getDouble(arrayPos);
                            hist.moveToPreciseRank(percentileIndex);
                            dest[destArrayOffset] = (char)(Math.min(hist.currentIValue(), hist.length() - 1) << bs);
                            for (long shift : right) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist.exclude(a.getInt(i) >> bs);
                            }
                            if (++arrayPos == this.length) {
                                arrayPos = 0L;
                            }
                            for (long shift : left) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist.include(a.getInt(i) >> bs);
                            }
                            ++k;
                            ++destArrayOffset;
                        }
                        count -= bufLen;
                    }
                    histogramCache.put(arrayPos, hist);
                    if (ap != null) {
                        ap.releaseArray(buf);
                    }
                }
            };
        }
        if (src instanceof ByteArray) {
            final ByteArray a = (ByteArray)src;
            final int nab = Math.min(this.numberOfAnalyzedBits, 8);
            final int bs = 8 - nab;
            if (direct) {
                boolean implementHere;
                final byte[] ja = (byte[])((DirectAccessible)((Object)a)).javaArray();
                final int jaOfs = ((DirectAccessible)((Object)a)).javaArrayOffset();
                boolean bl = implementHere = this.inlineOneLevel && this.bitLevels.length == 0;
                if (implementHere && iPerc != null) {
                    final HistogramCache histogramCache = new HistogramCache();
                    return new AbstractByteArray(src.length(), true, new Array[]{src}){

                        @Override
                        public int getByte(long index) {
                            long percentileIndex = iPerc.getLong(index);
                            int[] hist = new int[1 << nab];
                            for (long shift : shifts) {
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int n = (ja[jaOfs + (int)i] & 0xFF) >> bs;
                                hist[n] = hist[n] + 1;
                            }
                            int p = Math.min(Histogram.iValue(hist, percentileIndex), hist.length - 1);
                            return p << bs;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            if (!Percentiler.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            Percentiler.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            byte[] dest = (byte[])destArray;
                            UpdatablePIntegerArray buf = ap == null ? null : (UpdatablePIntegerArray)ap.requestArray();
                            int bufLen = ap == null ? count : 65536;
                            int[] hist = (int[])histogramCache.get(arrayPos);
                            if (hist == null) {
                                hist = new int[1 << nab];
                                for (long shift : shifts) {
                                    long i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    int n = (ja[jaOfs + (int)i] & 0xFF) >> bs;
                                    hist[n] = hist[n] + 1;
                                }
                            }
                            int currentIValue = 0;
                            int currentIRank = 0;
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (ap != null) {
                                    buf.copy(fPerc.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    int value;
                                    long i;
                                    long percentileIndex;
                                    long l = percentileIndex = ap != null ? buf.getLong(k) : iPerc.getLong(arrayPos);
                                    if (percentileIndex < 0L) {
                                        percentileIndex = 0L;
                                    } else if (percentileIndex > (long)shifts.length) {
                                        percentileIndex = shifts.length;
                                    }
                                    if (percentileIndex < (long)currentIRank) {
                                        while (percentileIndex < (long)(currentIRank -= hist[--currentIValue])) {
                                        }
                                        assert (currentIRank >= 0);
                                    } else if (percentileIndex < (long)shifts.length) {
                                        int b = hist[currentIValue];
                                        while (percentileIndex >= (long)(currentIRank + b)) {
                                            currentIRank += b;
                                            b = hist[++currentIValue];
                                        }
                                        assert (currentIRank < shifts.length);
                                    } else if (currentIRank == shifts.length) {
                                        assert (currentIValue == hist.length || hist[currentIValue] == 0);
                                        assert (currentIValue > 0);
                                        while (hist[currentIValue - 1] == 0) {
                                            assert (--currentIValue > 0);
                                        }
                                    } else {
                                        assert (currentIRank < shifts.length);
                                        while ((currentIRank += hist[++currentIValue]) < shifts.length) {
                                        }
                                        assert (currentIRank == shifts.length);
                                    }
                                    dest[destArrayOffset] = (byte)(Math.min(currentIValue, hist.length - 1) << bs);
                                    for (long shift : right) {
                                        i = arrayPos - shift;
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        int n = value = (ja[jaOfs + (int)i] & 0xFF) >> bs;
                                        hist[n] = hist[n] - 1;
                                        if (hist[n] < 0) {
                                            throw new AssertionError((Object)("Disbalance in the histogram: negative number " + hist[value] + " of occurrences of " + value + " value"));
                                        }
                                        if (value >= currentIValue) continue;
                                        --currentIRank;
                                    }
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (long shift : left) {
                                        i = arrayPos - shift;
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        int n = value = (ja[jaOfs + (int)i] & 0xFF) >> bs;
                                        hist[n] = hist[n] + 1;
                                        if (value >= currentIValue) continue;
                                        ++currentIRank;
                                    }
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            histogramCache.put(arrayPos, hist);
                            if (ap != null) {
                                ap.releaseArray(buf);
                            }
                        }
                    };
                }
                if (implementHere) {
                    assert (iPerc == null);
                    final HistogramCache histogramCache = new HistogramCache();
                    return new AbstractByteArray(src.length(), true, new Array[]{src}){

                        @Override
                        public int getByte(long index) {
                            double percentileIndex = fPerc.getDouble(index);
                            Percentiler.checkNaN(percentileIndex);
                            int[] hist = new int[1 << nab];
                            for (long shift : shifts) {
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int n = (ja[jaOfs + (int)i] & 0xFF) >> bs;
                                hist[n] = hist[n] + 1;
                            }
                            int p = Math.min(Histogram.iPreciseValue(hist, percentileIndex), hist.length - 1);
                            return p << bs;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            if (!Percentiler.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            Percentiler.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            byte[] dest = (byte[])destArray;
                            UpdatablePArray buf = ap == null ? null : (UpdatablePArray)ap.requestArray();
                            int bufLen = ap == null ? count : 65536;
                            int[] hist = (int[])histogramCache.get(arrayPos);
                            if (hist == null) {
                                hist = new int[1 << nab];
                                for (long shift : shifts) {
                                    long i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    int n = (ja[jaOfs + (int)i] & 0xFF) >> bs;
                                    hist[n] = hist[n] + 1;
                                }
                            }
                            int currentIValue = 0;
                            int currentIRank = 0;
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (ap != null) {
                                    buf.copy(fPerc.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    long i;
                                    int r;
                                    double percentileIndex = ap != null ? buf.getDouble(k) : fPerc.getDouble(arrayPos);
                                    Percentiler.checkNaN(percentileIndex);
                                    if (percentileIndex < 0.0) {
                                        r = 0;
                                        percentileIndex = 0;
                                    } else if (percentileIndex > (double)shifts.length) {
                                        r = shifts.length;
                                        percentileIndex = r;
                                    } else {
                                        r = (int)percentileIndex;
                                    }
                                    if (r < currentIRank) {
                                        while (r < (currentIRank -= hist[--currentIValue])) {
                                        }
                                        assert (currentIRank >= 0);
                                    } else if (r < shifts.length) {
                                        int b = hist[currentIValue];
                                        while (r >= currentIRank + b) {
                                            currentIRank += b;
                                            b = hist[++currentIValue];
                                        }
                                        assert (currentIRank < shifts.length);
                                    } else if (currentIRank == shifts.length) {
                                        assert (currentIValue == hist.length || hist[currentIValue] == 0);
                                        assert (currentIValue > 0);
                                        while (hist[currentIValue - 1] == 0) {
                                            assert (--currentIValue > 0);
                                        }
                                    } else {
                                        assert (currentIRank < shifts.length);
                                        while ((currentIRank += hist[++currentIValue]) < shifts.length) {
                                        }
                                        assert (currentIRank == shifts.length);
                                    }
                                    if (r < shifts.length - 1) {
                                        int leftValue = currentIValue;
                                        int indexInBar = r - currentIRank;
                                        int leftBar = hist[currentIValue];
                                        assert (indexInBar < leftBar);
                                        if ((double)r != percentileIndex && indexInBar == leftBar - 1) {
                                            double weightedMeanStripe;
                                            int leftRank = currentIRank;
                                            double leftPreciseValue = leftBar == 1 ? (double)leftValue : (double)leftValue + (double)indexInBar / (double)leftBar;
                                            assert (r + 1 == (currentIRank += leftBar));
                                            int rightBar = hist[++currentIValue];
                                            while (rightBar == 0) {
                                                rightBar = hist[++currentIValue];
                                            }
                                            assert (currentIRank < shifts.length);
                                            double newPreciseValue = leftPreciseValue + (percentileIndex - (double)r) * ((double)currentIValue - leftPreciseValue);
                                            double leftStripe = leftBar == 1 ? 1.0 : 1.0 / (double)leftBar;
                                            double d = weightedMeanStripe = leftBar == rightBar ? leftStripe : leftStripe + (percentileIndex - (double)r) * (1.0 / (double)rightBar - leftStripe);
                                            assert (weightedMeanStripe >= -0.001);
                                            double rangeCenter = newPreciseValue + 0.5 * Math.max(weightedMeanStripe, 1.0E-10);
                                            currentIValue = (int)rangeCenter;
                                            if (currentIValue == leftValue) {
                                                currentIRank = leftRank;
                                            }
                                        }
                                    }
                                    dest[destArrayOffset] = (byte)(Math.min(currentIValue, hist.length - 1) << bs);
                                    for (long shift : right) {
                                        int value;
                                        i = arrayPos - shift;
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        int n = value = (ja[jaOfs + (int)i] & 0xFF) >> bs;
                                        hist[n] = hist[n] - 1;
                                        if (hist[n] < 0) {
                                            throw new AssertionError((Object)("Disbalance in the histogram: negative number " + hist[value] + " of occurrences of " + value + " value"));
                                        }
                                        if (value >= currentIValue) continue;
                                        --currentIRank;
                                    }
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (long shift : left) {
                                        int value;
                                        i = arrayPos - shift;
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        int n = value = (ja[jaOfs + (int)i] & 0xFF) >> bs;
                                        hist[n] = hist[n] + 1;
                                        if (value >= currentIValue) continue;
                                        ++currentIRank;
                                    }
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            histogramCache.put(arrayPos, hist);
                            if (ap != null) {
                                ap.releaseArray(buf);
                            }
                        }
                    };
                }
                if (iPerc != null) {
                    assert (!implementHere);
                    final HistogramCache histogramCache = new HistogramCache();
                    final JArrayPool indexesPool = JArrayPool.getInstance(Integer.TYPE, left.length);
                    return new AbstractByteArray(src.length(), true, new Array[]{src}){

                        @Override
                        public int getByte(long index) {
                            long percentileIndex = iPerc.getLong(index);
                            int[] hist = new int[1 << nab];
                            for (long shift : shifts) {
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int n = (ja[jaOfs + (int)i] & 0xFF) >> bs;
                                hist[n] = hist[n] + 1;
                            }
                            int p = Math.min(Histogram.iValue(hist, percentileIndex), hist.length - 1);
                            return p << bs;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            if (!Percentiler.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            Percentiler.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            byte[] dest = (byte[])destArray;
                            UpdatablePIntegerArray buf = ap == null ? null : (UpdatablePIntegerArray)ap.requestArray();
                            int bufLen = ap == null ? count : 65536;
                            Histogram hist = (Histogram)histogramCache.get(arrayPos);
                            if (hist == null) {
                                hist = Histogram.newIntHistogram(1 << nab, Percentiler.this.bitLevels);
                                for (long shift : shifts) {
                                    long i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    hist.include((ja[jaOfs + (int)i] & 0xFF) >> bs);
                                }
                            }
                            int[] barIndexes = (int[])indexesPool.requestArray();
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (ap != null) {
                                    buf.copy(fPerc.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    long i;
                                    int j;
                                    long percentileIndex = ap != null ? buf.getLong(k) : iPerc.getLong(arrayPos);
                                    hist.moveToIRank(percentileIndex);
                                    dest[destArrayOffset] = (byte)(Math.min(hist.currentIValue(), hist.length() - 1) << bs);
                                    for (j = 0; j < right.length; ++j) {
                                        i = arrayPos - right[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        barIndexes[j] = (ja[jaOfs + (int)i] & 0xFF) >> bs;
                                    }
                                    hist.exclude(barIndexes);
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (j = 0; j < left.length; ++j) {
                                        i = arrayPos - left[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        barIndexes[j] = (ja[jaOfs + (int)i] & 0xFF) >> bs;
                                    }
                                    hist.include(barIndexes);
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            indexesPool.releaseArray(barIndexes);
                            histogramCache.put(arrayPos, hist);
                            if (ap != null) {
                                ap.releaseArray(buf);
                            }
                        }
                    };
                }
                assert (iPerc == null);
                final HistogramCache histogramCache = new HistogramCache();
                final JArrayPool indexesPool = JArrayPool.getInstance(Integer.TYPE, left.length);
                return new AbstractByteArray(src.length(), true, new Array[]{src}){

                    @Override
                    public int getByte(long index) {
                        double percentileIndex = fPerc.getDouble(index);
                        Percentiler.checkNaN(percentileIndex);
                        int[] hist = new int[1 << nab];
                        for (long shift : shifts) {
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            int n = (ja[jaOfs + (int)i] & 0xFF) >> bs;
                            hist[n] = hist[n] + 1;
                        }
                        int p = Math.min(Histogram.iPreciseValue(hist, percentileIndex), hist.length - 1);
                        return p << bs;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!Percentiler.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        Percentiler.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        byte[] dest = (byte[])destArray;
                        UpdatablePArray buf = ap == null ? null : (UpdatablePArray)ap.requestArray();
                        int bufLen = ap == null ? count : 65536;
                        Histogram hist = (Histogram)histogramCache.get(arrayPos);
                        if (hist == null) {
                            hist = Histogram.newIntHistogram(1 << nab, Percentiler.this.bitLevels);
                            for (long shift : shifts) {
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist.include((ja[jaOfs + (int)i] & 0xFF) >> bs);
                            }
                        }
                        int[] barIndexes = (int[])indexesPool.requestArray();
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (ap != null) {
                                buf.copy(fPerc.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                long i;
                                int j;
                                double percentileIndex = ap != null ? buf.getDouble(k) : fPerc.getDouble(arrayPos);
                                hist.moveToPreciseRank(percentileIndex);
                                dest[destArrayOffset] = (byte)(Math.min(hist.currentIValue(), hist.length() - 1) << bs);
                                for (j = 0; j < right.length; ++j) {
                                    i = arrayPos - right[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    barIndexes[j] = (ja[jaOfs + (int)i] & 0xFF) >> bs;
                                }
                                hist.exclude(barIndexes);
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (j = 0; j < left.length; ++j) {
                                    i = arrayPos - left[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    barIndexes[j] = (ja[jaOfs + (int)i] & 0xFF) >> bs;
                                }
                                hist.include(barIndexes);
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        indexesPool.releaseArray(barIndexes);
                        histogramCache.put(arrayPos, hist);
                        if (ap != null) {
                            ap.releaseArray(buf);
                        }
                    }
                };
            }
            if (iPerc != null) {
                final HistogramCache histogramCache = new HistogramCache();
                return new AbstractByteArray(src.length(), true, new Array[]{src}){

                    @Override
                    public int getByte(long index) {
                        long percentileIndex = iPerc.getLong(index);
                        int[] hist = new int[1 << nab];
                        for (long shift : shifts) {
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            int n = a.getInt(i) >> bs;
                            hist[n] = hist[n] + 1;
                        }
                        int p = Math.min(Histogram.iValue(hist, percentileIndex), hist.length - 1);
                        return p << bs;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!Percentiler.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        Percentiler.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        byte[] dest = (byte[])destArray;
                        UpdatablePIntegerArray buf = ap == null ? null : (UpdatablePIntegerArray)ap.requestArray();
                        int bufLen = ap == null ? count : 65536;
                        Histogram hist = (Histogram)histogramCache.get(arrayPos);
                        if (hist == null) {
                            hist = Histogram.newIntHistogram(1 << nab, Percentiler.this.bitLevels);
                            for (long shift : shifts) {
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist.include(a.getInt(i) >> bs);
                            }
                        }
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (ap != null) {
                                buf.copy(fPerc.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                long i;
                                long percentileIndex = ap != null ? buf.getLong(k) : iPerc.getLong(arrayPos);
                                hist.moveToIRank(percentileIndex);
                                dest[destArrayOffset] = (byte)(Math.min(hist.currentIValue(), hist.length() - 1) << bs);
                                for (long shift : right) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    hist.exclude(a.getInt(i) >> bs);
                                }
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (long shift : left) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    hist.include(a.getInt(i) >> bs);
                                }
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        histogramCache.put(arrayPos, hist);
                        if (ap != null) {
                            ap.releaseArray(buf);
                        }
                    }
                };
            }
            assert (iPerc == null);
            final HistogramCache histogramCache = new HistogramCache();
            return new AbstractByteArray(src.length(), true, new Array[]{src}){

                @Override
                public int getByte(long index) {
                    double percentileIndex = fPerc.getDouble(index);
                    Percentiler.checkNaN(percentileIndex);
                    int[] hist = new int[1 << nab];
                    for (long shift : shifts) {
                        long i = index - shift;
                        if (i < 0L) {
                            i += this.length;
                        }
                        int n = a.getInt(i) >> bs;
                        hist[n] = hist[n] + 1;
                    }
                    int p = Math.min(Histogram.iPreciseValue(hist, percentileIndex), hist.length - 1);
                    return p << bs;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    if (!Percentiler.this.optimizeGetData) {
                        super.getData(arrayPos, destArray, destArrayOffset, count);
                        return;
                    }
                    Objects.requireNonNull(destArray, "Null destArray argument");
                    Percentiler.checkRanges(this.length, arrayPos, count);
                    if (count == 0) {
                        return;
                    }
                    byte[] dest = (byte[])destArray;
                    UpdatablePArray buf = ap == null ? null : (UpdatablePArray)ap.requestArray();
                    int bufLen = ap == null ? count : 65536;
                    Histogram hist = (Histogram)histogramCache.get(arrayPos);
                    if (hist == null) {
                        hist = Histogram.newIntHistogram(1 << nab, Percentiler.this.bitLevels);
                        for (long shift : shifts) {
                            long i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            hist.include(a.getInt(i) >> bs);
                        }
                    }
                    while (count > 0) {
                        int len = Math.min(bufLen, count);
                        if (ap != null) {
                            buf.copy(fPerc.subArr(arrayPos, len));
                        }
                        int k = 0;
                        while (k < len) {
                            long i;
                            double percentileIndex = ap != null ? buf.getDouble(k) : fPerc.getDouble(arrayPos);
                            hist.moveToPreciseRank(percentileIndex);
                            dest[destArrayOffset] = (byte)(Math.min(hist.currentIValue(), hist.length() - 1) << bs);
                            for (long shift : right) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist.exclude(a.getInt(i) >> bs);
                            }
                            if (++arrayPos == this.length) {
                                arrayPos = 0L;
                            }
                            for (long shift : left) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist.include(a.getInt(i) >> bs);
                            }
                            ++k;
                            ++destArrayOffset;
                        }
                        count -= bufLen;
                    }
                    histogramCache.put(arrayPos, hist);
                    if (ap != null) {
                        ap.releaseArray(buf);
                    }
                }
            };
        }
        if (src instanceof ShortArray) {
            final ShortArray a = (ShortArray)src;
            final int nab = Math.min(this.numberOfAnalyzedBits, 16);
            final int bs = 16 - nab;
            if (direct) {
                boolean implementHere;
                final short[] ja = (short[])((DirectAccessible)((Object)a)).javaArray();
                final int jaOfs = ((DirectAccessible)((Object)a)).javaArrayOffset();
                boolean bl = implementHere = this.inlineOneLevel && this.bitLevels.length == 0;
                if (implementHere && iPerc != null) {
                    final HistogramCache histogramCache = new HistogramCache();
                    return new AbstractShortArray(src.length(), true, new Array[]{src}){

                        @Override
                        public int getShort(long index) {
                            long percentileIndex = iPerc.getLong(index);
                            int[] hist = new int[1 << nab];
                            for (long shift : shifts) {
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int n = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                hist[n] = hist[n] + 1;
                            }
                            int p = Math.min(Histogram.iValue(hist, percentileIndex), hist.length - 1);
                            return p << bs;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            if (!Percentiler.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            Percentiler.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            short[] dest = (short[])destArray;
                            UpdatablePIntegerArray buf = ap == null ? null : (UpdatablePIntegerArray)ap.requestArray();
                            int bufLen = ap == null ? count : 65536;
                            int[] hist = (int[])histogramCache.get(arrayPos);
                            if (hist == null) {
                                hist = new int[1 << nab];
                                for (long shift : shifts) {
                                    long i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    int n = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                    hist[n] = hist[n] + 1;
                                }
                            }
                            int currentIValue = 0;
                            int currentIRank = 0;
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (ap != null) {
                                    buf.copy(fPerc.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    int value;
                                    long i;
                                    long percentileIndex;
                                    long l = percentileIndex = ap != null ? buf.getLong(k) : iPerc.getLong(arrayPos);
                                    if (percentileIndex < 0L) {
                                        percentileIndex = 0L;
                                    } else if (percentileIndex > (long)shifts.length) {
                                        percentileIndex = shifts.length;
                                    }
                                    if (percentileIndex < (long)currentIRank) {
                                        while (percentileIndex < (long)(currentIRank -= hist[--currentIValue])) {
                                        }
                                        assert (currentIRank >= 0);
                                    } else if (percentileIndex < (long)shifts.length) {
                                        int b = hist[currentIValue];
                                        while (percentileIndex >= (long)(currentIRank + b)) {
                                            currentIRank += b;
                                            b = hist[++currentIValue];
                                        }
                                        assert (currentIRank < shifts.length);
                                    } else if (currentIRank == shifts.length) {
                                        assert (currentIValue == hist.length || hist[currentIValue] == 0);
                                        assert (currentIValue > 0);
                                        while (hist[currentIValue - 1] == 0) {
                                            assert (--currentIValue > 0);
                                        }
                                    } else {
                                        assert (currentIRank < shifts.length);
                                        while ((currentIRank += hist[++currentIValue]) < shifts.length) {
                                        }
                                        assert (currentIRank == shifts.length);
                                    }
                                    dest[destArrayOffset] = (short)(Math.min(currentIValue, hist.length - 1) << bs);
                                    for (long shift : right) {
                                        i = arrayPos - shift;
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        int n = value = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                        hist[n] = hist[n] - 1;
                                        if (hist[n] < 0) {
                                            throw new AssertionError((Object)("Disbalance in the histogram: negative number " + hist[value] + " of occurrences of " + value + " value"));
                                        }
                                        if (value >= currentIValue) continue;
                                        --currentIRank;
                                    }
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (long shift : left) {
                                        i = arrayPos - shift;
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        int n = value = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                        hist[n] = hist[n] + 1;
                                        if (value >= currentIValue) continue;
                                        ++currentIRank;
                                    }
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            histogramCache.put(arrayPos, hist);
                            if (ap != null) {
                                ap.releaseArray(buf);
                            }
                        }
                    };
                }
                if (implementHere) {
                    assert (iPerc == null);
                    final HistogramCache histogramCache = new HistogramCache();
                    return new AbstractShortArray(src.length(), true, new Array[]{src}){

                        @Override
                        public int getShort(long index) {
                            double percentileIndex = fPerc.getDouble(index);
                            Percentiler.checkNaN(percentileIndex);
                            int[] hist = new int[1 << nab];
                            for (long shift : shifts) {
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int n = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                hist[n] = hist[n] + 1;
                            }
                            int p = Math.min(Histogram.iPreciseValue(hist, percentileIndex), hist.length - 1);
                            return p << bs;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            if (!Percentiler.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            Percentiler.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            short[] dest = (short[])destArray;
                            UpdatablePArray buf = ap == null ? null : (UpdatablePArray)ap.requestArray();
                            int bufLen = ap == null ? count : 65536;
                            int[] hist = (int[])histogramCache.get(arrayPos);
                            if (hist == null) {
                                hist = new int[1 << nab];
                                for (long shift : shifts) {
                                    long i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    int n = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                    hist[n] = hist[n] + 1;
                                }
                            }
                            int currentIValue = 0;
                            int currentIRank = 0;
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (ap != null) {
                                    buf.copy(fPerc.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    long i;
                                    int r;
                                    double percentileIndex = ap != null ? buf.getDouble(k) : fPerc.getDouble(arrayPos);
                                    Percentiler.checkNaN(percentileIndex);
                                    if (percentileIndex < 0.0) {
                                        r = 0;
                                        percentileIndex = 0;
                                    } else if (percentileIndex > (double)shifts.length) {
                                        r = shifts.length;
                                        percentileIndex = r;
                                    } else {
                                        r = (int)percentileIndex;
                                    }
                                    if (r < currentIRank) {
                                        while (r < (currentIRank -= hist[--currentIValue])) {
                                        }
                                        assert (currentIRank >= 0);
                                    } else if (r < shifts.length) {
                                        int b = hist[currentIValue];
                                        while (r >= currentIRank + b) {
                                            currentIRank += b;
                                            b = hist[++currentIValue];
                                        }
                                        assert (currentIRank < shifts.length);
                                    } else if (currentIRank == shifts.length) {
                                        assert (currentIValue == hist.length || hist[currentIValue] == 0);
                                        assert (currentIValue > 0);
                                        while (hist[currentIValue - 1] == 0) {
                                            assert (--currentIValue > 0);
                                        }
                                    } else {
                                        assert (currentIRank < shifts.length);
                                        while ((currentIRank += hist[++currentIValue]) < shifts.length) {
                                        }
                                        assert (currentIRank == shifts.length);
                                    }
                                    if (r < shifts.length - 1) {
                                        int leftValue = currentIValue;
                                        int indexInBar = r - currentIRank;
                                        int leftBar = hist[currentIValue];
                                        assert (indexInBar < leftBar);
                                        if ((double)r != percentileIndex && indexInBar == leftBar - 1) {
                                            double weightedMeanStripe;
                                            int leftRank = currentIRank;
                                            double leftPreciseValue = leftBar == 1 ? (double)leftValue : (double)leftValue + (double)indexInBar / (double)leftBar;
                                            assert (r + 1 == (currentIRank += leftBar));
                                            int rightBar = hist[++currentIValue];
                                            while (rightBar == 0) {
                                                rightBar = hist[++currentIValue];
                                            }
                                            assert (currentIRank < shifts.length);
                                            double newPreciseValue = leftPreciseValue + (percentileIndex - (double)r) * ((double)currentIValue - leftPreciseValue);
                                            double leftStripe = leftBar == 1 ? 1.0 : 1.0 / (double)leftBar;
                                            double d = weightedMeanStripe = leftBar == rightBar ? leftStripe : leftStripe + (percentileIndex - (double)r) * (1.0 / (double)rightBar - leftStripe);
                                            assert (weightedMeanStripe >= -0.001);
                                            double rangeCenter = newPreciseValue + 0.5 * Math.max(weightedMeanStripe, 1.0E-10);
                                            currentIValue = (int)rangeCenter;
                                            if (currentIValue == leftValue) {
                                                currentIRank = leftRank;
                                            }
                                        }
                                    }
                                    dest[destArrayOffset] = (short)(Math.min(currentIValue, hist.length - 1) << bs);
                                    for (long shift : right) {
                                        int value;
                                        i = arrayPos - shift;
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        int n = value = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                        hist[n] = hist[n] - 1;
                                        if (hist[n] < 0) {
                                            throw new AssertionError((Object)("Disbalance in the histogram: negative number " + hist[value] + " of occurrences of " + value + " value"));
                                        }
                                        if (value >= currentIValue) continue;
                                        --currentIRank;
                                    }
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (long shift : left) {
                                        int value;
                                        i = arrayPos - shift;
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        int n = value = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                        hist[n] = hist[n] + 1;
                                        if (value >= currentIValue) continue;
                                        ++currentIRank;
                                    }
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            histogramCache.put(arrayPos, hist);
                            if (ap != null) {
                                ap.releaseArray(buf);
                            }
                        }
                    };
                }
                if (iPerc != null) {
                    assert (!implementHere);
                    final HistogramCache histogramCache = new HistogramCache();
                    final JArrayPool indexesPool = JArrayPool.getInstance(Integer.TYPE, left.length);
                    return new AbstractShortArray(src.length(), true, new Array[]{src}){

                        @Override
                        public int getShort(long index) {
                            long percentileIndex = iPerc.getLong(index);
                            int[] hist = new int[1 << nab];
                            for (long shift : shifts) {
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int n = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                hist[n] = hist[n] + 1;
                            }
                            int p = Math.min(Histogram.iValue(hist, percentileIndex), hist.length - 1);
                            return p << bs;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            if (!Percentiler.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            Percentiler.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            short[] dest = (short[])destArray;
                            UpdatablePIntegerArray buf = ap == null ? null : (UpdatablePIntegerArray)ap.requestArray();
                            int bufLen = ap == null ? count : 65536;
                            Histogram hist = (Histogram)histogramCache.get(arrayPos);
                            if (hist == null) {
                                hist = Histogram.newIntHistogram(1 << nab, Percentiler.this.bitLevels);
                                for (long shift : shifts) {
                                    long i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    hist.include((ja[jaOfs + (int)i] & 0xFFFF) >> bs);
                                }
                            }
                            int[] barIndexes = (int[])indexesPool.requestArray();
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (ap != null) {
                                    buf.copy(fPerc.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    long i;
                                    int j;
                                    long percentileIndex = ap != null ? buf.getLong(k) : iPerc.getLong(arrayPos);
                                    hist.moveToIRank(percentileIndex);
                                    dest[destArrayOffset] = (short)(Math.min(hist.currentIValue(), hist.length() - 1) << bs);
                                    for (j = 0; j < right.length; ++j) {
                                        i = arrayPos - right[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        barIndexes[j] = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                    }
                                    hist.exclude(barIndexes);
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (j = 0; j < left.length; ++j) {
                                        i = arrayPos - left[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        barIndexes[j] = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                    }
                                    hist.include(barIndexes);
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            indexesPool.releaseArray(barIndexes);
                            histogramCache.put(arrayPos, hist);
                            if (ap != null) {
                                ap.releaseArray(buf);
                            }
                        }
                    };
                }
                assert (iPerc == null);
                final HistogramCache histogramCache = new HistogramCache();
                final JArrayPool indexesPool = JArrayPool.getInstance(Integer.TYPE, left.length);
                return new AbstractShortArray(src.length(), true, new Array[]{src}){

                    @Override
                    public int getShort(long index) {
                        double percentileIndex = fPerc.getDouble(index);
                        Percentiler.checkNaN(percentileIndex);
                        int[] hist = new int[1 << nab];
                        for (long shift : shifts) {
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            int n = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                            hist[n] = hist[n] + 1;
                        }
                        int p = Math.min(Histogram.iPreciseValue(hist, percentileIndex), hist.length - 1);
                        return p << bs;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!Percentiler.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        Percentiler.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        short[] dest = (short[])destArray;
                        UpdatablePArray buf = ap == null ? null : (UpdatablePArray)ap.requestArray();
                        int bufLen = ap == null ? count : 65536;
                        Histogram hist = (Histogram)histogramCache.get(arrayPos);
                        if (hist == null) {
                            hist = Histogram.newIntHistogram(1 << nab, Percentiler.this.bitLevels);
                            for (long shift : shifts) {
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist.include((ja[jaOfs + (int)i] & 0xFFFF) >> bs);
                            }
                        }
                        int[] barIndexes = (int[])indexesPool.requestArray();
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (ap != null) {
                                buf.copy(fPerc.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                long i;
                                int j;
                                double percentileIndex = ap != null ? buf.getDouble(k) : fPerc.getDouble(arrayPos);
                                hist.moveToPreciseRank(percentileIndex);
                                dest[destArrayOffset] = (short)(Math.min(hist.currentIValue(), hist.length() - 1) << bs);
                                for (j = 0; j < right.length; ++j) {
                                    i = arrayPos - right[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    barIndexes[j] = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                }
                                hist.exclude(barIndexes);
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (j = 0; j < left.length; ++j) {
                                    i = arrayPos - left[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    barIndexes[j] = (ja[jaOfs + (int)i] & 0xFFFF) >> bs;
                                }
                                hist.include(barIndexes);
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        indexesPool.releaseArray(barIndexes);
                        histogramCache.put(arrayPos, hist);
                        if (ap != null) {
                            ap.releaseArray(buf);
                        }
                    }
                };
            }
            if (iPerc != null) {
                final HistogramCache histogramCache = new HistogramCache();
                return new AbstractShortArray(src.length(), true, new Array[]{src}){

                    @Override
                    public int getShort(long index) {
                        long percentileIndex = iPerc.getLong(index);
                        int[] hist = new int[1 << nab];
                        for (long shift : shifts) {
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            int n = a.getInt(i) >> bs;
                            hist[n] = hist[n] + 1;
                        }
                        int p = Math.min(Histogram.iValue(hist, percentileIndex), hist.length - 1);
                        return p << bs;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!Percentiler.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        Percentiler.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        short[] dest = (short[])destArray;
                        UpdatablePIntegerArray buf = ap == null ? null : (UpdatablePIntegerArray)ap.requestArray();
                        int bufLen = ap == null ? count : 65536;
                        Histogram hist = (Histogram)histogramCache.get(arrayPos);
                        if (hist == null) {
                            hist = Histogram.newIntHistogram(1 << nab, Percentiler.this.bitLevels);
                            for (long shift : shifts) {
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist.include(a.getInt(i) >> bs);
                            }
                        }
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (ap != null) {
                                buf.copy(fPerc.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                long i;
                                long percentileIndex = ap != null ? buf.getLong(k) : iPerc.getLong(arrayPos);
                                hist.moveToIRank(percentileIndex);
                                dest[destArrayOffset] = (short)(Math.min(hist.currentIValue(), hist.length() - 1) << bs);
                                for (long shift : right) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    hist.exclude(a.getInt(i) >> bs);
                                }
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (long shift : left) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    hist.include(a.getInt(i) >> bs);
                                }
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        histogramCache.put(arrayPos, hist);
                        if (ap != null) {
                            ap.releaseArray(buf);
                        }
                    }
                };
            }
            assert (iPerc == null);
            final HistogramCache histogramCache = new HistogramCache();
            return new AbstractShortArray(src.length(), true, new Array[]{src}){

                @Override
                public int getShort(long index) {
                    double percentileIndex = fPerc.getDouble(index);
                    Percentiler.checkNaN(percentileIndex);
                    int[] hist = new int[1 << nab];
                    for (long shift : shifts) {
                        long i = index - shift;
                        if (i < 0L) {
                            i += this.length;
                        }
                        int n = a.getInt(i) >> bs;
                        hist[n] = hist[n] + 1;
                    }
                    int p = Math.min(Histogram.iPreciseValue(hist, percentileIndex), hist.length - 1);
                    return p << bs;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    if (!Percentiler.this.optimizeGetData) {
                        super.getData(arrayPos, destArray, destArrayOffset, count);
                        return;
                    }
                    Objects.requireNonNull(destArray, "Null destArray argument");
                    Percentiler.checkRanges(this.length, arrayPos, count);
                    if (count == 0) {
                        return;
                    }
                    short[] dest = (short[])destArray;
                    UpdatablePArray buf = ap == null ? null : (UpdatablePArray)ap.requestArray();
                    int bufLen = ap == null ? count : 65536;
                    Histogram hist = (Histogram)histogramCache.get(arrayPos);
                    if (hist == null) {
                        hist = Histogram.newIntHistogram(1 << nab, Percentiler.this.bitLevels);
                        for (long shift : shifts) {
                            long i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            hist.include(a.getInt(i) >> bs);
                        }
                    }
                    while (count > 0) {
                        int len = Math.min(bufLen, count);
                        if (ap != null) {
                            buf.copy(fPerc.subArr(arrayPos, len));
                        }
                        int k = 0;
                        while (k < len) {
                            long i;
                            double percentileIndex = ap != null ? buf.getDouble(k) : fPerc.getDouble(arrayPos);
                            hist.moveToPreciseRank(percentileIndex);
                            dest[destArrayOffset] = (short)(Math.min(hist.currentIValue(), hist.length() - 1) << bs);
                            for (long shift : right) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist.exclude(a.getInt(i) >> bs);
                            }
                            if (++arrayPos == this.length) {
                                arrayPos = 0L;
                            }
                            for (long shift : left) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                hist.include(a.getInt(i) >> bs);
                            }
                            ++k;
                            ++destArrayOffset;
                        }
                        count -= bufLen;
                    }
                    histogramCache.put(arrayPos, hist);
                    if (ap != null) {
                        ap.releaseArray(buf);
                    }
                }
            };
        }
        if (src instanceof IntArray) {
            final IntArray a = (IntArray)src;
            final int nab = Math.min(this.numberOfAnalyzedBits, 30);
            final int bs = 31 - nab;
            final HistogramCache histogramCache = new HistogramCache();
            if (direct) {
                final int[] ja = (int[])((DirectAccessible)((Object)a)).javaArray();
                final int jaOfs = ((DirectAccessible)((Object)a)).javaArrayOffset();
                final JArrayPool indexesPool = JArrayPool.getInstance(Integer.TYPE, left.length);
                if (iPerc != null) {
                    return new AbstractIntArray(src.length(), true, new Array[]{src}){

                        @Override
                        public int getInt(long index) {
                            long percentileIndex = iPerc.getLong(index);
                            int[] hist = new int[1 << nab];
                            for (long shift : shifts) {
                                int v;
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if ((v = ja[jaOfs + (int)i]) < 0) {
                                    v = 0;
                                }
                                int n = v >> bs;
                                hist[n] = hist[n] + 1;
                            }
                            int p = Math.min(Histogram.iValue(hist, percentileIndex), hist.length - 1);
                            return p << bs;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            if (!Percentiler.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            Percentiler.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            int[] dest = (int[])destArray;
                            UpdatablePIntegerArray buf = ap == null ? null : (UpdatablePIntegerArray)ap.requestArray();
                            int bufLen = ap == null ? count : 65536;
                            Histogram hist = (Histogram)histogramCache.get(arrayPos);
                            if (hist == null) {
                                hist = Histogram.newIntHistogram(1 << nab, Percentiler.this.bitLevels);
                                for (long shift : shifts) {
                                    int v;
                                    long i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    if ((v = ja[jaOfs + (int)i]) < 0) {
                                        v = 0;
                                    }
                                    hist.include(v >> bs);
                                }
                            }
                            int[] barIndexes = (int[])indexesPool.requestArray();
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (ap != null) {
                                    buf.copy(fPerc.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    int v;
                                    long i;
                                    int j;
                                    long percentileIndex = ap != null ? buf.getLong(k) : iPerc.getLong(arrayPos);
                                    hist.moveToIRank(percentileIndex);
                                    int p = Math.min(hist.currentIValue(), hist.length() - 1);
                                    dest[destArrayOffset] = p << bs;
                                    for (j = 0; j < right.length; ++j) {
                                        i = arrayPos - right[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        if ((v = ja[jaOfs + (int)i]) < 0) {
                                            v = 0;
                                        }
                                        barIndexes[j] = v >> bs;
                                    }
                                    hist.exclude(barIndexes);
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (j = 0; j < left.length; ++j) {
                                        i = arrayPos - left[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        if ((v = ja[jaOfs + (int)i]) < 0) {
                                            v = 0;
                                        }
                                        barIndexes[j] = v >> bs;
                                    }
                                    hist.include(barIndexes);
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            indexesPool.releaseArray(barIndexes);
                            histogramCache.put(arrayPos, hist);
                            if (ap != null) {
                                ap.releaseArray(buf);
                            }
                        }
                    };
                }
                assert (iPerc == null);
                return new AbstractIntArray(src.length(), true, new Array[]{src}){

                    @Override
                    public int getInt(long index) {
                        double percentileIndex = fPerc.getDouble(index);
                        Percentiler.checkNaN(percentileIndex);
                        int[] hist = new int[1 << nab];
                        for (long shift : shifts) {
                            int v;
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            if ((v = ja[jaOfs + (int)i]) < 0) {
                                v = 0;
                            }
                            int n = v >> bs;
                            hist[n] = hist[n] + 1;
                        }
                        int p = Math.min(Histogram.iPreciseValue(hist, percentileIndex), hist.length - 1);
                        return p << bs;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!Percentiler.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        Percentiler.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        int[] dest = (int[])destArray;
                        UpdatablePArray buf = ap == null ? null : (UpdatablePArray)ap.requestArray();
                        int bufLen = ap == null ? count : 65536;
                        Histogram hist = (Histogram)histogramCache.get(arrayPos);
                        if (hist == null) {
                            hist = Histogram.newIntHistogram(1 << nab, Percentiler.this.bitLevels);
                            for (long shift : shifts) {
                                int v;
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if ((v = ja[jaOfs + (int)i]) < 0) {
                                    v = 0;
                                }
                                hist.include(v >> bs);
                            }
                        }
                        int[] barIndexes = (int[])indexesPool.requestArray();
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (ap != null) {
                                buf.copy(fPerc.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                int v;
                                long i;
                                int j;
                                double percentileIndex = ap != null ? buf.getDouble(k) : fPerc.getDouble(arrayPos);
                                hist.moveToPreciseRank(percentileIndex);
                                int p = Math.min(hist.currentIValue(), hist.length() - 1);
                                dest[destArrayOffset] = p << bs;
                                for (j = 0; j < right.length; ++j) {
                                    i = arrayPos - right[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    if ((v = ja[jaOfs + (int)i]) < 0) {
                                        v = 0;
                                    }
                                    barIndexes[j] = v >> bs;
                                }
                                hist.exclude(barIndexes);
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (j = 0; j < left.length; ++j) {
                                    i = arrayPos - left[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    if ((v = ja[jaOfs + (int)i]) < 0) {
                                        v = 0;
                                    }
                                    barIndexes[j] = v >> bs;
                                }
                                hist.include(barIndexes);
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        indexesPool.releaseArray(barIndexes);
                        histogramCache.put(arrayPos, hist);
                        if (ap != null) {
                            ap.releaseArray(buf);
                        }
                    }
                };
            }
            if (iPerc != null) {
                return new AbstractIntArray(src.length(), true, new Array[]{src}){

                    @Override
                    public int getInt(long index) {
                        long percentileIndex = iPerc.getLong(index);
                        int[] hist = new int[1 << nab];
                        for (long shift : shifts) {
                            int v;
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            if ((v = a.getInt(i)) < 0) {
                                v = 0;
                            }
                            int n = v >> bs;
                            hist[n] = hist[n] + 1;
                        }
                        int p = Math.min(Histogram.iValue(hist, percentileIndex), hist.length - 1);
                        return p << bs;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!Percentiler.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        Percentiler.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        int[] dest = (int[])destArray;
                        UpdatablePIntegerArray buf = ap == null ? null : (UpdatablePIntegerArray)ap.requestArray();
                        int bufLen = ap == null ? count : 65536;
                        Histogram hist = (Histogram)histogramCache.get(arrayPos);
                        if (hist == null) {
                            hist = Histogram.newIntHistogram(1 << nab, Percentiler.this.bitLevels);
                            for (long shift : shifts) {
                                int v;
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if ((v = a.getInt(i)) < 0) {
                                    v = 0;
                                }
                                hist.include(v >> bs);
                            }
                        }
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (ap != null) {
                                buf.copy(fPerc.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                int v;
                                long i;
                                long percentileIndex = ap != null ? buf.getLong(k) : iPerc.getLong(arrayPos);
                                hist.moveToIRank(percentileIndex);
                                int p = Math.min(hist.currentIValue(), hist.length() - 1);
                                dest[destArrayOffset] = p << bs;
                                for (long shift : right) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    if ((v = a.getInt(i)) < 0) {
                                        v = 0;
                                    }
                                    hist.exclude(v >> bs);
                                }
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (long shift : left) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    if ((v = a.getInt(i)) < 0) {
                                        v = 0;
                                    }
                                    hist.include(v >> bs);
                                }
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        histogramCache.put(arrayPos, hist);
                        if (ap != null) {
                            ap.releaseArray(buf);
                        }
                    }
                };
            }
            assert (iPerc == null);
            return new AbstractIntArray(src.length(), true, new Array[]{src}){

                @Override
                public int getInt(long index) {
                    double percentileIndex = fPerc.getDouble(index);
                    Percentiler.checkNaN(percentileIndex);
                    int[] hist = new int[1 << nab];
                    for (long shift : shifts) {
                        int v;
                        long i = index - shift;
                        if (i < 0L) {
                            i += this.length;
                        }
                        if ((v = a.getInt(i)) < 0) {
                            v = 0;
                        }
                        int n = v >> bs;
                        hist[n] = hist[n] + 1;
                    }
                    int p = Math.min(Histogram.iPreciseValue(hist, percentileIndex), hist.length - 1);
                    return p << bs;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    if (!Percentiler.this.optimizeGetData) {
                        super.getData(arrayPos, destArray, destArrayOffset, count);
                        return;
                    }
                    Objects.requireNonNull(destArray, "Null destArray argument");
                    Percentiler.checkRanges(this.length, arrayPos, count);
                    if (count == 0) {
                        return;
                    }
                    int[] dest = (int[])destArray;
                    UpdatablePArray buf = ap == null ? null : (UpdatablePArray)ap.requestArray();
                    int bufLen = ap == null ? count : 65536;
                    Histogram hist = (Histogram)histogramCache.get(arrayPos);
                    if (hist == null) {
                        hist = Histogram.newIntHistogram(1 << nab, Percentiler.this.bitLevels);
                        for (long shift : shifts) {
                            int v;
                            long i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            if ((v = a.getInt(i)) < 0) {
                                v = 0;
                            }
                            hist.include(v >> bs);
                        }
                    }
                    while (count > 0) {
                        int len = Math.min(bufLen, count);
                        if (ap != null) {
                            buf.copy(fPerc.subArr(arrayPos, len));
                        }
                        int k = 0;
                        while (k < len) {
                            int v;
                            long i;
                            double percentileIndex = ap != null ? buf.getDouble(k) : fPerc.getDouble(arrayPos);
                            hist.moveToPreciseRank(percentileIndex);
                            int p = Math.min(hist.currentIValue(), hist.length() - 1);
                            dest[destArrayOffset] = p << bs;
                            for (long shift : right) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if ((v = a.getInt(i)) < 0) {
                                    v = 0;
                                }
                                hist.exclude(v >> bs);
                            }
                            if (++arrayPos == this.length) {
                                arrayPos = 0L;
                            }
                            for (long shift : left) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if ((v = a.getInt(i)) < 0) {
                                    v = 0;
                                }
                                hist.include(v >> bs);
                            }
                            ++k;
                            ++destArrayOffset;
                        }
                        count -= bufLen;
                    }
                    histogramCache.put(arrayPos, hist);
                    if (ap != null) {
                        ap.releaseArray(buf);
                    }
                }
            };
        }
        if (src instanceof LongArray) {
            final LongArray a = (LongArray)src;
            final int nab = Math.min(this.numberOfAnalyzedBits, 30);
            final int bs = 63 - nab;
            final HistogramCache histogramCache = new HistogramCache();
            if (direct) {
                final long[] ja = (long[])((DirectAccessible)((Object)a)).javaArray();
                final int jaOfs = ((DirectAccessible)((Object)a)).javaArrayOffset();
                final JArrayPool indexesPool = JArrayPool.getInstance(Integer.TYPE, left.length);
                if (iPerc != null) {
                    return new AbstractLongArray(src.length(), true, new Array[]{src}){

                        @Override
                        public long getLong(long index) {
                            long percentileIndex = iPerc.getLong(index);
                            int[] hist = new int[1 << nab];
                            for (long shift : shifts) {
                                long v;
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if ((v = ja[jaOfs + (int)i]) < 0L) {
                                    v = 0L;
                                }
                                int n = (int)(v >> bs);
                                hist[n] = hist[n] + 1;
                            }
                            long p = Math.min(Histogram.iValue(hist, percentileIndex), hist.length - 1);
                            return p << bs;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            if (!Percentiler.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            Percentiler.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            long[] dest = (long[])destArray;
                            UpdatablePIntegerArray buf = ap == null ? null : (UpdatablePIntegerArray)ap.requestArray();
                            int bufLen = ap == null ? count : 65536;
                            Histogram hist = (Histogram)histogramCache.get(arrayPos);
                            if (hist == null) {
                                hist = Histogram.newIntHistogram(1 << nab, Percentiler.this.bitLevels);
                                for (long shift : shifts) {
                                    long v;
                                    long i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    if ((v = ja[jaOfs + (int)i]) < 0L) {
                                        v = 0L;
                                    }
                                    hist.include((int)(v >> bs));
                                }
                            }
                            int[] barIndexes = (int[])indexesPool.requestArray();
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (ap != null) {
                                    buf.copy(fPerc.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    long v;
                                    long i;
                                    int j;
                                    long percentileIndex = ap != null ? buf.getLong(k) : iPerc.getLong(arrayPos);
                                    hist.moveToIRank(percentileIndex);
                                    long p = Math.min(hist.currentIValue(), hist.length() - 1);
                                    dest[destArrayOffset] = p << bs;
                                    for (j = 0; j < right.length; ++j) {
                                        i = arrayPos - right[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        if ((v = ja[jaOfs + (int)i]) < 0L) {
                                            v = 0L;
                                        }
                                        barIndexes[j] = (int)(v >> bs);
                                    }
                                    hist.exclude(barIndexes);
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (j = 0; j < left.length; ++j) {
                                        i = arrayPos - left[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        if ((v = ja[jaOfs + (int)i]) < 0L) {
                                            v = 0L;
                                        }
                                        barIndexes[j] = (int)(v >> bs);
                                    }
                                    hist.include(barIndexes);
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            indexesPool.releaseArray(barIndexes);
                            histogramCache.put(arrayPos, hist);
                            if (ap != null) {
                                ap.releaseArray(buf);
                            }
                        }
                    };
                }
                assert (iPerc == null);
                return new AbstractLongArray(src.length(), true, new Array[]{src}){

                    @Override
                    public long getLong(long index) {
                        double percentileIndex = fPerc.getDouble(index);
                        Percentiler.checkNaN(percentileIndex);
                        int[] hist = new int[1 << nab];
                        for (long shift : shifts) {
                            long v;
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            if ((v = ja[jaOfs + (int)i]) < 0L) {
                                v = 0L;
                            }
                            int n = (int)(v >> bs);
                            hist[n] = hist[n] + 1;
                        }
                        long p = Math.min(Histogram.iPreciseValue(hist, percentileIndex), hist.length - 1);
                        return p << bs;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!Percentiler.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        Percentiler.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        long[] dest = (long[])destArray;
                        UpdatablePArray buf = ap == null ? null : (UpdatablePArray)ap.requestArray();
                        int bufLen = ap == null ? count : 65536;
                        Histogram hist = (Histogram)histogramCache.get(arrayPos);
                        if (hist == null) {
                            hist = Histogram.newIntHistogram(1 << nab, Percentiler.this.bitLevels);
                            for (long shift : shifts) {
                                long v;
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if ((v = ja[jaOfs + (int)i]) < 0L) {
                                    v = 0L;
                                }
                                hist.include((int)(v >> bs));
                            }
                        }
                        int[] barIndexes = (int[])indexesPool.requestArray();
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (ap != null) {
                                buf.copy(fPerc.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                long v;
                                long i;
                                int j;
                                double percentileIndex = ap != null ? buf.getDouble(k) : fPerc.getDouble(arrayPos);
                                hist.moveToPreciseRank(percentileIndex);
                                long p = Math.min(hist.currentIValue(), hist.length() - 1);
                                dest[destArrayOffset] = p << bs;
                                for (j = 0; j < right.length; ++j) {
                                    i = arrayPos - right[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    if ((v = ja[jaOfs + (int)i]) < 0L) {
                                        v = 0L;
                                    }
                                    barIndexes[j] = (int)(v >> bs);
                                }
                                hist.exclude(barIndexes);
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (j = 0; j < left.length; ++j) {
                                    i = arrayPos - left[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    if ((v = ja[jaOfs + (int)i]) < 0L) {
                                        v = 0L;
                                    }
                                    barIndexes[j] = (int)(v >> bs);
                                }
                                hist.include(barIndexes);
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        indexesPool.releaseArray(barIndexes);
                        histogramCache.put(arrayPos, hist);
                        if (ap != null) {
                            ap.releaseArray(buf);
                        }
                    }
                };
            }
            if (iPerc != null) {
                return new AbstractLongArray(src.length(), true, new Array[]{src}){

                    @Override
                    public long getLong(long index) {
                        long percentileIndex = iPerc.getLong(index);
                        int[] hist = new int[1 << nab];
                        for (long shift : shifts) {
                            long v;
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            if ((v = a.getLong(i)) < 0L) {
                                v = 0L;
                            }
                            int n = (int)(v >> bs);
                            hist[n] = hist[n] + 1;
                        }
                        long p = Math.min(Histogram.iValue(hist, percentileIndex), hist.length - 1);
                        return p << bs;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!Percentiler.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        Percentiler.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        long[] dest = (long[])destArray;
                        UpdatablePIntegerArray buf = ap == null ? null : (UpdatablePIntegerArray)ap.requestArray();
                        int bufLen = ap == null ? count : 65536;
                        Histogram hist = (Histogram)histogramCache.get(arrayPos);
                        if (hist == null) {
                            hist = Histogram.newIntHistogram(1 << nab, Percentiler.this.bitLevels);
                            for (long shift : shifts) {
                                long v;
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if ((v = a.getLong(i)) < 0L) {
                                    v = 0L;
                                }
                                hist.include((int)(v >> bs));
                            }
                        }
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (ap != null) {
                                buf.copy(fPerc.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                long v;
                                long i;
                                long percentileIndex = ap != null ? buf.getLong(k) : iPerc.getLong(arrayPos);
                                hist.moveToIRank(percentileIndex);
                                long p = Math.min(hist.currentIValue(), hist.length() - 1);
                                dest[destArrayOffset] = p << bs;
                                for (long shift : right) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    if ((v = a.getLong(i)) < 0L) {
                                        v = 0L;
                                    }
                                    hist.exclude((int)(v >> bs));
                                }
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (long shift : left) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    if ((v = a.getLong(i)) < 0L) {
                                        v = 0L;
                                    }
                                    hist.include((int)(v >> bs));
                                }
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        histogramCache.put(arrayPos, hist);
                        if (ap != null) {
                            ap.releaseArray(buf);
                        }
                    }
                };
            }
            assert (iPerc == null);
            return new AbstractLongArray(src.length(), true, new Array[]{src}){

                @Override
                public long getLong(long index) {
                    double percentileIndex = fPerc.getDouble(index);
                    Percentiler.checkNaN(percentileIndex);
                    int[] hist = new int[1 << nab];
                    for (long shift : shifts) {
                        long v;
                        long i = index - shift;
                        if (i < 0L) {
                            i += this.length;
                        }
                        if ((v = a.getLong(i)) < 0L) {
                            v = 0L;
                        }
                        int n = (int)(v >> bs);
                        hist[n] = hist[n] + 1;
                    }
                    long p = Math.min(Histogram.iPreciseValue(hist, percentileIndex), hist.length - 1);
                    return p << bs;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    if (!Percentiler.this.optimizeGetData) {
                        super.getData(arrayPos, destArray, destArrayOffset, count);
                        return;
                    }
                    Objects.requireNonNull(destArray, "Null destArray argument");
                    Percentiler.checkRanges(this.length, arrayPos, count);
                    if (count == 0) {
                        return;
                    }
                    long[] dest = (long[])destArray;
                    UpdatablePArray buf = ap == null ? null : (UpdatablePArray)ap.requestArray();
                    int bufLen = ap == null ? count : 65536;
                    Histogram hist = (Histogram)histogramCache.get(arrayPos);
                    if (hist == null) {
                        hist = Histogram.newIntHistogram(1 << nab, Percentiler.this.bitLevels);
                        for (long shift : shifts) {
                            long v;
                            long i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            if ((v = a.getLong(i)) < 0L) {
                                v = 0L;
                            }
                            hist.include((int)(v >> bs));
                        }
                    }
                    while (count > 0) {
                        int len = Math.min(bufLen, count);
                        if (ap != null) {
                            buf.copy(fPerc.subArr(arrayPos, len));
                        }
                        int k = 0;
                        while (k < len) {
                            long v;
                            long i;
                            double percentileIndex = ap != null ? buf.getDouble(k) : fPerc.getDouble(arrayPos);
                            hist.moveToPreciseRank(percentileIndex);
                            long p = Math.min(hist.currentIValue(), hist.length() - 1);
                            dest[destArrayOffset] = p << bs;
                            for (long shift : right) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if ((v = a.getLong(i)) < 0L) {
                                    v = 0L;
                                }
                                hist.exclude((int)(v >> bs));
                            }
                            if (++arrayPos == this.length) {
                                arrayPos = 0L;
                            }
                            for (long shift : left) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                if ((v = a.getLong(i)) < 0L) {
                                    v = 0L;
                                }
                                hist.include((int)(v >> bs));
                            }
                            ++k;
                            ++destArrayOffset;
                        }
                        count -= bufLen;
                    }
                    histogramCache.put(arrayPos, hist);
                    if (ap != null) {
                        ap.releaseArray(buf);
                    }
                }
            };
        }
        if (src instanceof FloatArray) {
            final FloatArray a = (FloatArray)src;
            final int histLength = 1 << this.numberOfAnalyzedBits;
            final double multiplier = histLength - 1;
            final double multiplierInv = 1.0 / multiplier;
            final HistogramCache histogramCache = new HistogramCache();
            if (direct) {
                final float[] ja = (float[])((DirectAccessible)((Object)a)).javaArray();
                final int jaOfs = ((DirectAccessible)((Object)a)).javaArrayOffset();
                final JArrayPool indexesPool = JArrayPool.getInstance(Integer.TYPE, left.length);
                if (!this.interpolated) {
                    return new AbstractFloatArray(src.length(), true, new Array[]{src}){

                        @Override
                        public float getFloat(long index) {
                            double percentileIndex = fPerc.getDouble(index);
                            Percentiler.checkNaN(percentileIndex);
                            int[] hist = new int[histLength];
                            for (long shift : shifts) {
                                double v;
                                int histIndex;
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int n = histIndex = (v = (double)ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                hist[n] = hist[n] + 1;
                            }
                            double p = Histogram.value(hist, percentileIndex);
                            return (float)(p * multiplierInv);
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            if (!Percentiler.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            Percentiler.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            float[] dest = (float[])destArray;
                            UpdatablePArray buf = ap == null ? null : (UpdatablePArray)ap.requestArray();
                            int bufLen = ap == null ? count : 65536;
                            Histogram hist = (Histogram)histogramCache.get(arrayPos);
                            if (hist == null) {
                                hist = Histogram.newIntHistogram(histLength, Percentiler.this.bitLevels);
                                for (long shift : shifts) {
                                    double v;
                                    long i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    int histIndex = (v = (double)ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                    hist.include(histIndex);
                                }
                            }
                            int[] barIndexes = (int[])indexesPool.requestArray();
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (ap != null) {
                                    buf.copy(fPerc.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    double v;
                                    long i;
                                    int j;
                                    double percentileIndex = ap != null ? buf.getDouble(k) : fPerc.getDouble(arrayPos);
                                    hist.moveToRank(percentileIndex);
                                    dest[destArrayOffset] = (float)(hist.currentValue() * multiplierInv);
                                    for (j = 0; j < right.length; ++j) {
                                        i = arrayPos - right[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        barIndexes[j] = (v = (double)ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                    }
                                    hist.exclude(barIndexes);
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (j = 0; j < left.length; ++j) {
                                        i = arrayPos - left[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        barIndexes[j] = (v = (double)ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                    }
                                    hist.include(barIndexes);
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            indexesPool.releaseArray(barIndexes);
                            histogramCache.put(arrayPos, hist);
                            if (ap != null) {
                                ap.releaseArray(buf);
                            }
                        }
                    };
                }
                return new AbstractFloatArray(src.length(), true, new Array[]{src}){

                    @Override
                    public float getFloat(long index) {
                        double percentileIndex = fPerc.getDouble(index);
                        Percentiler.checkNaN(percentileIndex);
                        int[] hist = new int[histLength];
                        for (long shift : shifts) {
                            double v;
                            int histIndex;
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            int n = histIndex = (v = (double)ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                            hist[n] = hist[n] + 1;
                        }
                        double p = Histogram.preciseValue(hist, percentileIndex);
                        return (float)(p * multiplierInv);
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!Percentiler.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        Percentiler.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        float[] dest = (float[])destArray;
                        UpdatablePArray buf = ap == null ? null : (UpdatablePArray)ap.requestArray();
                        int bufLen = ap == null ? count : 65536;
                        Histogram hist = (Histogram)histogramCache.get(arrayPos);
                        if (hist == null) {
                            hist = Histogram.newIntHistogram(histLength, Percentiler.this.bitLevels);
                            for (long shift : shifts) {
                                double v;
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int histIndex = (v = (double)ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                hist.include(histIndex);
                            }
                        }
                        int[] barIndexes = (int[])indexesPool.requestArray();
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (ap != null) {
                                buf.copy(fPerc.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                double v;
                                long i;
                                int j;
                                double percentileIndex = ap != null ? buf.getDouble(k) : fPerc.getDouble(arrayPos);
                                hist.moveToPreciseRank(percentileIndex);
                                dest[destArrayOffset] = (float)(hist.currentValue() * multiplierInv);
                                for (j = 0; j < right.length; ++j) {
                                    i = arrayPos - right[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    barIndexes[j] = (v = (double)ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                }
                                hist.exclude(barIndexes);
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (j = 0; j < left.length; ++j) {
                                    i = arrayPos - left[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    barIndexes[j] = (v = (double)ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                }
                                hist.include(barIndexes);
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        indexesPool.releaseArray(barIndexes);
                        histogramCache.put(arrayPos, hist);
                        if (ap != null) {
                            ap.releaseArray(buf);
                        }
                    }
                };
            }
            if (!this.interpolated) {
                return new AbstractFloatArray(src.length(), true, new Array[]{src}){

                    @Override
                    public float getFloat(long index) {
                        double percentileIndex = fPerc.getDouble(index);
                        Percentiler.checkNaN(percentileIndex);
                        int[] hist = new int[histLength];
                        for (long shift : shifts) {
                            double v;
                            int histIndex;
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            int n = histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                            hist[n] = hist[n] + 1;
                        }
                        double p = Histogram.value(hist, percentileIndex);
                        return (float)(p * multiplierInv);
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!Percentiler.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        Percentiler.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        float[] dest = (float[])destArray;
                        UpdatablePArray buf = ap == null ? null : (UpdatablePArray)ap.requestArray();
                        int bufLen = ap == null ? count : 65536;
                        Histogram hist = (Histogram)histogramCache.get(arrayPos);
                        if (hist == null) {
                            hist = Histogram.newIntHistogram(histLength, Percentiler.this.bitLevels);
                            for (long shift : shifts) {
                                double v;
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                hist.include(histIndex);
                            }
                        }
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (ap != null) {
                                buf.copy(fPerc.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                int histIndex;
                                double v;
                                long i;
                                double percentileIndex = ap != null ? buf.getDouble(k) : fPerc.getDouble(arrayPos);
                                hist.moveToRank(percentileIndex);
                                dest[destArrayOffset] = (float)(hist.currentValue() * multiplierInv);
                                for (long shift : right) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                    hist.exclude(histIndex);
                                }
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (long shift : left) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                    hist.include(histIndex);
                                }
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        histogramCache.put(arrayPos, hist);
                        if (ap != null) {
                            ap.releaseArray(buf);
                        }
                    }
                };
            }
            return new AbstractFloatArray(src.length(), true, new Array[]{src}){

                @Override
                public float getFloat(long index) {
                    double percentileIndex = fPerc.getDouble(index);
                    Percentiler.checkNaN(percentileIndex);
                    int[] hist = new int[histLength];
                    for (long shift : shifts) {
                        double v;
                        int histIndex;
                        long i = index - shift;
                        if (i < 0L) {
                            i += this.length;
                        }
                        int n = histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                        hist[n] = hist[n] + 1;
                    }
                    double p = Histogram.preciseValue(hist, percentileIndex);
                    return (float)(p * multiplierInv);
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    if (!Percentiler.this.optimizeGetData) {
                        super.getData(arrayPos, destArray, destArrayOffset, count);
                        return;
                    }
                    Objects.requireNonNull(destArray, "Null destArray argument");
                    Percentiler.checkRanges(this.length, arrayPos, count);
                    if (count == 0) {
                        return;
                    }
                    float[] dest = (float[])destArray;
                    UpdatablePArray buf = ap == null ? null : (UpdatablePArray)ap.requestArray();
                    int bufLen = ap == null ? count : 65536;
                    Histogram hist = (Histogram)histogramCache.get(arrayPos);
                    if (hist == null) {
                        hist = Histogram.newIntHistogram(histLength, Percentiler.this.bitLevels);
                        for (long shift : shifts) {
                            double v;
                            long i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            int histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                            hist.include(histIndex);
                        }
                    }
                    while (count > 0) {
                        int len = Math.min(bufLen, count);
                        if (ap != null) {
                            buf.copy(fPerc.subArr(arrayPos, len));
                        }
                        int k = 0;
                        while (k < len) {
                            int histIndex;
                            double v;
                            long i;
                            double percentileIndex = ap != null ? buf.getDouble(k) : fPerc.getDouble(arrayPos);
                            hist.moveToPreciseRank(percentileIndex);
                            dest[destArrayOffset] = (float)(hist.currentValue() * multiplierInv);
                            for (long shift : right) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                hist.exclude(histIndex);
                            }
                            if (++arrayPos == this.length) {
                                arrayPos = 0L;
                            }
                            for (long shift : left) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                hist.include(histIndex);
                            }
                            ++k;
                            ++destArrayOffset;
                        }
                        count -= bufLen;
                    }
                    histogramCache.put(arrayPos, hist);
                    if (ap != null) {
                        ap.releaseArray(buf);
                    }
                }
            };
        }
        if (src instanceof DoubleArray) {
            final DoubleArray a = (DoubleArray)src;
            final int histLength = 1 << this.numberOfAnalyzedBits;
            final double multiplier = histLength - 1;
            final double multiplierInv = 1.0 / multiplier;
            final HistogramCache histogramCache = new HistogramCache();
            if (direct) {
                final double[] ja = (double[])((DirectAccessible)((Object)a)).javaArray();
                final int jaOfs = ((DirectAccessible)((Object)a)).javaArrayOffset();
                final JArrayPool indexesPool = JArrayPool.getInstance(Integer.TYPE, left.length);
                if (!this.interpolated) {
                    return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                        @Override
                        public double getDouble(long index) {
                            double percentileIndex = fPerc.getDouble(index);
                            Percentiler.checkNaN(percentileIndex);
                            int[] hist = new int[histLength];
                            for (long shift : shifts) {
                                double v;
                                int histIndex;
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int n = histIndex = (v = ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                hist[n] = hist[n] + 1;
                            }
                            double p = Histogram.value(hist, percentileIndex);
                            return p * multiplierInv;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            if (!Percentiler.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            Percentiler.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            double[] dest = (double[])destArray;
                            UpdatablePArray buf = ap == null ? null : (UpdatablePArray)ap.requestArray();
                            int bufLen = ap == null ? count : 65536;
                            Histogram hist = (Histogram)histogramCache.get(arrayPos);
                            if (hist == null) {
                                hist = Histogram.newIntHistogram(histLength, Percentiler.this.bitLevels);
                                for (long shift : shifts) {
                                    double v;
                                    long i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    int histIndex = (v = ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                    hist.include(histIndex);
                                }
                            }
                            int[] barIndexes = (int[])indexesPool.requestArray();
                            while (count > 0) {
                                int len = Math.min(bufLen, count);
                                if (ap != null) {
                                    buf.copy(fPerc.subArr(arrayPos, len));
                                }
                                int k = 0;
                                while (k < len) {
                                    double v;
                                    long i;
                                    int j;
                                    double percentileIndex = ap != null ? buf.getDouble(k) : fPerc.getDouble(arrayPos);
                                    hist.moveToRank(percentileIndex);
                                    dest[destArrayOffset] = hist.currentValue() * multiplierInv;
                                    for (j = 0; j < right.length; ++j) {
                                        i = arrayPos - right[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        barIndexes[j] = (v = ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                    }
                                    hist.exclude(barIndexes);
                                    if (++arrayPos == this.length) {
                                        arrayPos = 0L;
                                    }
                                    for (j = 0; j < left.length; ++j) {
                                        i = arrayPos - left[j];
                                        if (i < 0L) {
                                            i += this.length;
                                        }
                                        barIndexes[j] = (v = ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                    }
                                    hist.include(barIndexes);
                                    ++k;
                                    ++destArrayOffset;
                                }
                                count -= bufLen;
                            }
                            indexesPool.releaseArray(barIndexes);
                            histogramCache.put(arrayPos, hist);
                            if (ap != null) {
                                ap.releaseArray(buf);
                            }
                        }
                    };
                }
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                    @Override
                    public double getDouble(long index) {
                        double percentileIndex = fPerc.getDouble(index);
                        Percentiler.checkNaN(percentileIndex);
                        int[] hist = new int[histLength];
                        for (long shift : shifts) {
                            double v;
                            int histIndex;
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            int n = histIndex = (v = ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                            hist[n] = hist[n] + 1;
                        }
                        double p = Histogram.preciseValue(hist, percentileIndex);
                        return p * multiplierInv;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!Percentiler.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        Percentiler.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        UpdatablePArray buf = ap == null ? null : (UpdatablePArray)ap.requestArray();
                        int bufLen = ap == null ? count : 65536;
                        Histogram hist = (Histogram)histogramCache.get(arrayPos);
                        if (hist == null) {
                            hist = Histogram.newIntHistogram(histLength, Percentiler.this.bitLevels);
                            for (long shift : shifts) {
                                double v;
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int histIndex = (v = ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                hist.include(histIndex);
                            }
                        }
                        int[] barIndexes = (int[])indexesPool.requestArray();
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (ap != null) {
                                buf.copy(fPerc.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                double v;
                                long i;
                                int j;
                                double percentileIndex = ap != null ? buf.getDouble(k) : fPerc.getDouble(arrayPos);
                                hist.moveToPreciseRank(percentileIndex);
                                dest[destArrayOffset] = hist.currentValue() * multiplierInv;
                                for (j = 0; j < right.length; ++j) {
                                    i = arrayPos - right[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    barIndexes[j] = (v = ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                }
                                hist.exclude(barIndexes);
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (j = 0; j < left.length; ++j) {
                                    i = arrayPos - left[j];
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    barIndexes[j] = (v = ja[jaOfs + (int)i]) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                }
                                hist.include(barIndexes);
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        indexesPool.releaseArray(barIndexes);
                        histogramCache.put(arrayPos, hist);
                        if (ap != null) {
                            ap.releaseArray(buf);
                        }
                    }
                };
            }
            if (!this.interpolated) {
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                    @Override
                    public double getDouble(long index) {
                        double percentileIndex = fPerc.getDouble(index);
                        Percentiler.checkNaN(percentileIndex);
                        int[] hist = new int[histLength];
                        for (long shift : shifts) {
                            double v;
                            int histIndex;
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            int n = histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                            hist[n] = hist[n] + 1;
                        }
                        double p = Histogram.value(hist, percentileIndex);
                        return p * multiplierInv;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        if (!Percentiler.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        Percentiler.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        UpdatablePArray buf = ap == null ? null : (UpdatablePArray)ap.requestArray();
                        int bufLen = ap == null ? count : 65536;
                        Histogram hist = (Histogram)histogramCache.get(arrayPos);
                        if (hist == null) {
                            hist = Histogram.newIntHistogram(histLength, Percentiler.this.bitLevels);
                            for (long shift : shifts) {
                                double v;
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                int histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                hist.include(histIndex);
                            }
                        }
                        while (count > 0) {
                            int len = Math.min(bufLen, count);
                            if (ap != null) {
                                buf.copy(fPerc.subArr(arrayPos, len));
                            }
                            int k = 0;
                            while (k < len) {
                                int histIndex;
                                double v;
                                long i;
                                double percentileIndex = ap != null ? buf.getDouble(k) : fPerc.getDouble(arrayPos);
                                hist.moveToRank(percentileIndex);
                                dest[destArrayOffset] = hist.currentValue() * multiplierInv;
                                for (long shift : right) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                    hist.exclude(histIndex);
                                }
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (long shift : left) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                    hist.include(histIndex);
                                }
                                ++k;
                                ++destArrayOffset;
                            }
                            count -= bufLen;
                        }
                        histogramCache.put(arrayPos, hist);
                        if (ap != null) {
                            ap.releaseArray(buf);
                        }
                    }
                };
            }
            return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                @Override
                public double getDouble(long index) {
                    double percentileIndex = fPerc.getDouble(index);
                    Percentiler.checkNaN(percentileIndex);
                    int[] hist = new int[histLength];
                    for (long shift : shifts) {
                        double v;
                        int histIndex;
                        long i = index - shift;
                        if (i < 0L) {
                            i += this.length;
                        }
                        int n = histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                        hist[n] = hist[n] + 1;
                    }
                    double p = Histogram.preciseValue(hist, percentileIndex);
                    return p * multiplierInv;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    if (!Percentiler.this.optimizeGetData) {
                        super.getData(arrayPos, destArray, destArrayOffset, count);
                        return;
                    }
                    Objects.requireNonNull(destArray, "Null destArray argument");
                    Percentiler.checkRanges(this.length, arrayPos, count);
                    if (count == 0) {
                        return;
                    }
                    double[] dest = (double[])destArray;
                    UpdatablePArray buf = ap == null ? null : (UpdatablePArray)ap.requestArray();
                    int bufLen = ap == null ? count : 65536;
                    Histogram hist = (Histogram)histogramCache.get(arrayPos);
                    if (hist == null) {
                        hist = Histogram.newIntHistogram(histLength, Percentiler.this.bitLevels);
                        for (long shift : shifts) {
                            double v;
                            long i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            int histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                            hist.include(histIndex);
                        }
                    }
                    while (count > 0) {
                        int len = Math.min(bufLen, count);
                        if (ap != null) {
                            buf.copy(fPerc.subArr(arrayPos, len));
                        }
                        int k = 0;
                        while (k < len) {
                            int histIndex;
                            double v;
                            long i;
                            double percentileIndex = ap != null ? buf.getDouble(k) : fPerc.getDouble(arrayPos);
                            hist.moveToPreciseRank(percentileIndex);
                            dest[destArrayOffset] = hist.currentValue() * multiplierInv;
                            for (long shift : right) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                hist.exclude(histIndex);
                            }
                            if (++arrayPos == this.length) {
                                arrayPos = 0L;
                            }
                            for (long shift : left) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                histIndex = (v = a.getDouble(i)) < 0.0 ? 0 : (v >= 1.0 ? histLength - 1 : (int)(v * multiplier));
                                hist.include(histIndex);
                            }
                            ++k;
                            ++destArrayOffset;
                        }
                        count -= bufLen;
                    }
                    histogramCache.put(arrayPos, hist);
                    if (ap != null) {
                        ap.releaseArray(buf);
                    }
                }
            };
        }
        throw new AssertionError((Object)("Illegal array type (" + String.valueOf(src.getClass()) + "): it must implement one of primitive XxxArray interfaces"));
    }

    private static void checkRanges(long length, long arrayPos, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
        }
        if (arrayPos < 0L) {
            throw new IndexOutOfBoundsException("arrayPos = " + arrayPos + " < 0");
        }
        if (arrayPos > length - (long)count) {
            throw new IndexOutOfBoundsException("arrayPos+count = " + arrayPos + "+" + count + " > length=" + length);
        }
    }

    private static void checkNaN(double rank) {
        if (Double.isNaN(rank)) {
            throw new IllegalArgumentException("Illegal rank (NaN) in some percentile indexes");
        }
    }
}

