/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.scanning;

import java.util.Objects;
import net.algart.arrays.JArrays;
import net.algart.matrices.scanning.Boundary2DScanner;
import net.algart.matrices.scanning.Boundary2DWrapper;
import net.algart.matrices.scanning.ContourLineType;

public abstract class Boundary2DProjectionMeasurer
extends Boundary2DWrapper {
    final ContourLineType contourLineType;
    final double startAngleInRadians;
    final int m;

    Boundary2DProjectionMeasurer(Boundary2DScanner parent, ContourLineType contourLineType, double startAngleInRadians, int numberOfDirections) {
        super(parent);
        Objects.requireNonNull(contourLineType, "Null contourLineType");
        if (numberOfDirections <= 0) {
            throw new IllegalArgumentException("Negative or zero number of directions");
        }
        this.contourLineType = contourLineType;
        this.startAngleInRadians = startAngleInRadians;
        this.m = numberOfDirections;
    }

    public static Boundary2DProjectionMeasurer getInstance(Boundary2DScanner parent, ContourLineType contourLineType, double startAngleInRadians, int numberOfDirections) {
        Objects.requireNonNull(parent, "Null parent argument");
        return new DoubleVersion(parent, contourLineType, startAngleInRadians, numberOfDirections);
    }

    public ContourLineType contourLineType() {
        return this.contourLineType;
    }

    public double startAngleInRadians() {
        return this.startAngleInRadians;
    }

    public int numberOfDirections() {
        return this.m;
    }

    public double directionAngleInRadians(int directionIndex) {
        return this.startAngleInRadians + Math.PI * (double)directionIndex / (double)this.m;
    }

    public double area() {
        return this.area(this.contourLineType);
    }

    public double perimeter() {
        return this.perimeter(this.contourLineType);
    }

    public abstract double projectionMin(int var1);

    public abstract double projectionMax(int var1);

    public abstract double projectionLength(int var1);

    public double meanProjectionLength() {
        double sum = 0.0;
        for (int k = 0; k < this.m; ++k) {
            sum += this.projectionLength(k);
        }
        return sum / (double)this.m;
    }

    public int indexOfMinProjectionLength() {
        double result = Double.POSITIVE_INFINITY;
        int index = -1;
        for (int k = 0; k < this.m; ++k) {
            double length = this.projectionLength(k);
            if (!(length < result)) continue;
            index = k;
            result = length;
        }
        return index;
    }

    public int indexOfMaxProjectionLength() {
        double result = Double.NEGATIVE_INFINITY;
        int index = -1;
        for (int k = 0; k < this.m; ++k) {
            double length = this.projectionLength(k);
            if (!(length > result)) continue;
            index = k;
            result = length;
        }
        return index;
    }

    public int indexOfMinCircumscribedRhombus(int stepBetweenDirections) {
        if (stepBetweenDirections < 0) {
            throw new IllegalArgumentException("Negative stepBetweenDirections");
        }
        double result = Double.POSITIVE_INFINITY;
        int index = -1;
        int k = 0;
        int i = stepBetweenDirections %= this.m;
        while (k < this.m) {
            double otherLength;
            double length;
            if (i == this.m) {
                i = 0;
            }
            if ((length = this.projectionLength(k)) < (otherLength = this.projectionLength(i))) {
                length = otherLength;
            }
            if (length < result) {
                index = k;
                result = length;
            }
            ++k;
            ++i;
        }
        return index;
    }

    public double minProjectionLength() {
        double result = Double.POSITIVE_INFINITY;
        for (int k = 0; k < this.m; ++k) {
            double length = this.projectionLength(k);
            if (!(length < result)) continue;
            result = length;
        }
        return result;
    }

    public double maxProjectionLength() {
        double result = Double.NEGATIVE_INFINITY;
        for (int k = 0; k < this.m; ++k) {
            double length = this.projectionLength(k);
            if (!(length > result)) continue;
            result = length;
        }
        return result;
    }

    public double minCircumscribedRhombus(int stepBetweenDirections) {
        if (stepBetweenDirections < 0) {
            throw new IllegalArgumentException("Negative stepBetweenDirections");
        }
        double result = Double.POSITIVE_INFINITY;
        int k = 0;
        int i = stepBetweenDirections %= this.m;
        while (k < this.m) {
            double otherLength;
            double length;
            if (i == this.m) {
                i = 0;
            }
            if ((length = this.projectionLength(k)) < (otherLength = this.projectionLength(i))) {
                length = otherLength;
            }
            if (length < result) {
                result = length;
            }
            ++k;
            ++i;
        }
        return result;
    }

    @Override
    public String toString() {
        return this.m + "-projection measurer of " + String.valueOf(this.parent);
    }

    static class DoubleVersion
    extends Boundary2DProjectionMeasurer {
        private final double[] projectionMin;
        private final double[] projectionMax;
        private final double[] dirX;
        private final double[] dirY;

        DoubleVersion(Boundary2DScanner parent, ContourLineType contourLineType, double startAngleInRadians, int numberOfDirections) {
            super(parent, contourLineType, startAngleInRadians, numberOfDirections);
            this.projectionMin = new double[this.m];
            this.projectionMax = new double[this.m];
            this.dirX = new double[this.m];
            this.dirY = new double[this.m];
            for (int k = 0; k < this.m; ++k) {
                this.dirX[k] = StrictMath.cos(startAngleInRadians + Math.PI * (double)k / (double)this.m);
                this.dirY[k] = StrictMath.sin(startAngleInRadians + Math.PI * (double)k / (double)this.m);
            }
        }

        @Override
        public double projectionMin(int directionIndex) {
            return this.projectionMin[directionIndex];
        }

        @Override
        public double projectionMax(int directionIndex) {
            return this.projectionMax[directionIndex];
        }

        @Override
        public double projectionLength(int directionIndex) {
            return this.projectionMax[directionIndex] - this.projectionMin[directionIndex];
        }

        @Override
        public void next() {
            this.parent.next();
            double x = this.contourLineType.x(this.parent);
            double y = this.contourLineType.y(this.parent);
            for (int k = 0; k < this.m; ++k) {
                double projection = x * this.dirX[k] + y * this.dirY[k];
                if (projection < this.projectionMin[k]) {
                    this.projectionMin[k] = projection;
                }
                if (!(projection > this.projectionMax[k])) continue;
                this.projectionMax[k] = projection;
            }
        }

        @Override
        public void resetCounters() {
            super.resetCounters();
            JArrays.fill(this.projectionMin, Double.POSITIVE_INFINITY);
            JArrays.fill(this.projectionMax, Double.NEGATIVE_INFINITY);
        }
    }
}

