/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.scanning;

import java.util.Objects;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.BitArray;
import net.algart.arrays.DataBitBuffer;
import net.algart.arrays.DataBuffer;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.PFixedArray;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.arrays.SizeMismatchException;
import net.algart.arrays.UpdatableBitArray;
import net.algart.arrays.UpdatablePFixedArray;
import net.algart.matrices.scanning.ConnectivityType;
import net.algart.matrices.scanning.ContourLineType;

public abstract class Boundary2DScanner {
    private static final boolean DEBUG_NESTING_LEVEL = false;
    static final int X_MINUS_CODE = 0;
    static final int Y_MINUS_CODE = 1;
    static final int X_PLUS_CODE = 2;
    static final int Y_PLUS_CODE = 3;
    static final Side[] ALL_SIDES = Side.values();
    final Matrix<? extends BitArray> matrix;
    final BitArray array;
    final long arrayLength;
    final long dimX;
    final long dimY;

    Boundary2DScanner(Matrix<? extends BitArray> matrix) {
        Objects.requireNonNull(matrix, "Null matrix argument");
        if (matrix.dimCount() != 2) {
            throw new IllegalArgumentException(String.valueOf(Boundary2DScanner.class) + " can be used for 2-dimensional matrices only");
        }
        this.matrix = matrix;
        this.array = matrix.array();
        this.arrayLength = this.array.length();
        this.dimX = matrix.dimX();
        this.dimY = matrix.dimY();
    }

    public static Boundary2DScanner getSingleBoundaryScanner(Matrix<? extends BitArray> matrix, ConnectivityType connectivityType) {
        Objects.requireNonNull(matrix, "Null matrix argument");
        Objects.requireNonNull(connectivityType, "Null connectivityType argument");
        switch (connectivityType) {
            case STRAIGHT_ONLY: {
                if (!Boundary2DScanner.isDirectBitArray(matrix.array())) {
                    return new SingleBoundary2D4Scanner(matrix);
                }
                return new DirectSingleBoundary2D4Scanner(matrix);
            }
            case STRAIGHT_AND_DIAGONAL: {
                if (!Boundary2DScanner.isDirectBitArray(matrix.array())) {
                    return new SingleBoundary2D8Scanner(matrix);
                }
                return new DirectSingleBoundary2D8Scanner(matrix);
            }
        }
        throw new AssertionError((Object)("Unsupported connectivity type: " + String.valueOf((Object)connectivityType)));
    }

    public static Boundary2DScanner getAllBoundariesScanner(Matrix<? extends BitArray> matrix, Matrix<? extends UpdatablePFixedArray> buffer1, Matrix<? extends UpdatablePFixedArray> buffer2, ConnectivityType connectivityType) {
        Objects.requireNonNull(connectivityType, "Null connectivityType argument");
        switch (connectivityType) {
            case STRAIGHT_ONLY: {
                if (!Boundary2DScanner.isDirectBitArray(matrix.array())) {
                    return new AllBoundaries2D4Scanner(matrix, buffer1, buffer2);
                }
                return new DirectAllBoundaries2D4Scanner(matrix, buffer1, buffer2);
            }
            case STRAIGHT_AND_DIAGONAL: {
                if (!Boundary2DScanner.isDirectBitArray(matrix.array())) {
                    return new AllBoundaries2D8Scanner(matrix, buffer1, buffer2);
                }
                return new DirectAllBoundaries2D8Scanner(matrix, buffer1, buffer2);
            }
        }
        throw new AssertionError((Object)("Unsupported connectivity type: " + String.valueOf((Object)connectivityType)));
    }

    public static Boundary2DScanner getMainBoundariesScanner(Matrix<? extends BitArray> matrix, Matrix<? extends UpdatablePFixedArray> buffer, ConnectivityType connectivityType) {
        Objects.requireNonNull(connectivityType, "Null connectivityType argument");
        switch (connectivityType) {
            case STRAIGHT_ONLY: {
                if (!Boundary2DScanner.isDirectBitArray(matrix.array())) {
                    return new MainBoundaries2D4Scanner(matrix, buffer);
                }
                return new DirectMainBoundaries2D4Scanner(matrix, buffer);
            }
            case STRAIGHT_AND_DIAGONAL: {
                if (!Boundary2DScanner.isDirectBitArray(matrix.array())) {
                    return new MainBoundaries2D8Scanner(matrix, buffer);
                }
                return new DirectMainBoundaries2D8Scanner(matrix, buffer);
            }
        }
        throw new AssertionError((Object)("Unsupported connectivity type: " + String.valueOf((Object)connectivityType)));
    }

    public static Matrix<UpdatableBitArray> fillHoles(MemoryModel memoryModel, Matrix<? extends BitArray> source, ConnectivityType connectivityType) {
        Objects.requireNonNull(memoryModel, "Null memoryModel");
        Objects.requireNonNull(source, "Null source bit matrix");
        Objects.requireNonNull(connectivityType, "Null connectivityType argument");
        Matrix<UpdatableBitArray> result = memoryModel.newBitMatrix(source.dimensions());
        Boundary2DScanner scanner = Boundary2DScanner.getMainBoundariesScanner(source, result, connectivityType);
        while (scanner.nextBoundary()) {
            scanner.scanBoundary();
        }
        return result;
    }

    public static void fillHoles(Matrix<? extends UpdatableBitArray> result, Matrix<? extends BitArray> source, ConnectivityType connectivityType) {
        Objects.requireNonNull(result, "Null result bit matrix");
        Objects.requireNonNull(source, "Null source bit matrix");
        Objects.requireNonNull(connectivityType, "Null connectivityType argument");
        Boundary2DScanner scanner = Boundary2DScanner.getMainBoundariesScanner(source, result, connectivityType);
        Matrices.clear(result);
        while (scanner.nextBoundary()) {
            scanner.scanBoundary();
        }
    }

    public abstract boolean isSingleBoundaryScanner();

    public abstract boolean isAllBoundariesScanner();

    public abstract boolean isMainBoundariesScanner();

    public final Matrix<? extends BitArray> matrix() {
        return this.matrix;
    }

    public final long dimX() {
        return this.dimX;
    }

    public final long dimY() {
        return this.dimY;
    }

    public abstract ConnectivityType connectivityType();

    public abstract boolean isInitialized();

    public abstract boolean isMovedAlongBoundary();

    public abstract long x();

    public abstract long y();

    public abstract Side side();

    public abstract boolean atMatrixBoundary();

    public abstract long nestingLevel();

    public abstract long currentIndexInArray();

    public abstract void goTo(long var1, long var3, Side var5);

    public final void goToSamePosition(Boundary2DScanner scanner) {
        this.goTo(scanner.x(), scanner.y(), scanner.side());
    }

    public abstract void resetCounters();

    public abstract boolean get();

    public abstract boolean nextBoundary();

    public abstract void next();

    public abstract Step lastStep();

    public abstract boolean coordinatesChanged();

    public abstract boolean boundaryFinished();

    public abstract long stepCount();

    public final long straightStepCount() {
        return this.stepCount() - (this.diagonalStepCount() + this.rotationStepCount());
    }

    public abstract long diagonalStepCount();

    public abstract long rotationStepCount();

    public abstract long orientedArea();

    public double area(ContourLineType contourLineType) {
        long orientedArea = this.orientedArea();
        switch (contourLineType) {
            case STRICT_BOUNDARY: {
                return orientedArea;
            }
            case PIXEL_CENTERS_POLYLINE: {
                long straightStepCount = this.straightStepCount();
                return (double)orientedArea - 0.5 * (double)straightStepCount - 0.25 * (double)(this.stepCount() - straightStepCount);
            }
            case SEGMENT_CENTERS_POLYLINE: {
                return orientedArea > 0L ? (double)orientedArea - 0.5 : (double)orientedArea + 0.5;
            }
        }
        throw new AssertionError((Object)("Unsupported contourLineType=" + String.valueOf((Object)contourLineType)));
    }

    public double perimeter(ContourLineType contourLineType) {
        long stepCount = this.stepCount();
        switch (contourLineType) {
            case STRICT_BOUNDARY: {
                return stepCount;
            }
            case PIXEL_CENTERS_POLYLINE: {
                long diagonalStepCount = this.diagonalStepCount();
                return (double)(stepCount - diagonalStepCount - this.rotationStepCount()) + Step.DIAGONAL_LENGTH * (double)diagonalStepCount;
            }
            case SEGMENT_CENTERS_POLYLINE: {
                long nonStraightStepCount = this.diagonalStepCount() + this.rotationStepCount();
                return (double)(stepCount - nonStraightStepCount) + Step.HALF_DIAGONAL_LENGTH * (double)nonStraightStepCount;
            }
        }
        throw new AssertionError((Object)("Unsupported contourLineType=" + String.valueOf((Object)contourLineType)));
    }

    public final boolean isInternalBoundary() {
        return this.side() == Side.X_PLUS;
    }

    public final long scanBoundary() {
        return this.scanBoundary(null);
    }

    public final long scanBoundary(ArrayContext context) {
        do {
            this.next();
            if (context == null || (this.stepCount() & 0xFFFFL) != 0L) continue;
            context.checkInterruption();
        } while (!this.boundaryFinished());
        return this.stepCount();
    }

    public final void updateProgress(ArrayContext context) {
        if (context != null) {
            context.updateProgress(new ArrayContext.Event(Boolean.TYPE, this.currentIndexInArray(), this.matrix.size()));
        }
    }

    public final void checkInterruption(ArrayContext context) {
        if (context != null) {
            context.checkInterruption();
        }
    }

    public String toString() {
        return "2D scanner (" + (String)(!this.isInitialized() ? "not initialized yet" : "x = " + this.x() + ", y = " + this.y() + ", side = " + String.valueOf((Object)this.side()) + (String)(!this.isMovedAlongBoundary() ? "" : ", last step: " + String.valueOf(this.lastStep())) + (String)(this.nestingLevel() == 0L ? "" : ", nesting level = " + this.nestingLevel())) + (this.connectivityType() == ConnectivityType.STRAIGHT_ONLY ? "; 4" : "; 8") + "-connectivity)";
    }

    static boolean nextSingleBoundary(AbstractBoundary2DScanner scanner) {
        if (scanner.arrayLength == 0L) {
            return false;
        }
        long index = scanner.currentIndexInArray();
        if (!scanner.get()) {
            return Boundary2DScanner.goToNextUnitBit(scanner, index + 1L);
        }
        if (scanner.mover == null) {
            assert (scanner.x == 0L && scanner.y == 0L);
            scanner.goTo(0L, 0L, Side.X_MINUS);
            return true;
        }
        long x = scanner.x();
        long i = scanner.array.indexOf(index + 1L, index + scanner.dimX - x, false);
        i = i == -1L ? scanner.dimX - x - 1L : (i -= index + 1L);
        if (i == 0L) {
            if (scanner.side() != Side.X_PLUS) {
                scanner.goTo(x, scanner.y(), Side.X_PLUS);
                return true;
            }
            return Boundary2DScanner.goToNextUnitBit(scanner, index + 1L);
        }
        scanner.goTo(x + i, scanner.y(), Side.X_PLUS);
        return true;
    }

    static AbstractBoundary2DScanner.AbstractAccessor nextAnyBoundary(AbstractBoundary2DScanner scanner, AbstractBoundary2DScanner.AbstractAccessor bufferAccessor1, AbstractBoundary2DScanner.AbstractAccessor bufferAccessor2) {
        block8: while (Boundary2DScanner.nextSingleBoundary(scanner)) {
            boolean bracket1 = scanner.mover.getHorizontalBracket(bufferAccessor1);
            boolean bracket2 = scanner.mover.getHorizontalBracket(bufferAccessor2);
            if (scanner.x == scanner.dimX - 1L && scanner.mover.currentSide == Side.X_PLUS) {
                assert (!bracket1 && !bracket2);
                scanner.nestingLevel = 0L;
                continue;
            }
            if (bracket1 || bracket2) {
                switch (scanner.mover.currentSide.ordinal()) {
                    case 0: {
                        if (bracket1) {
                            ++scanner.nestingLevel;
                            continue block8;
                        }
                        --scanner.nestingLevel;
                        continue block8;
                    }
                    case 2: {
                        if (bracket1) {
                            --scanner.nestingLevel;
                            continue block8;
                        }
                        ++scanner.nestingLevel;
                        continue block8;
                    }
                }
                throw new AssertionError((Object)("getHorizontalBracket must be false in " + String.valueOf((Object)scanner.mover.currentSide)));
            }
            ++scanner.nestingLevel;
            switch (scanner.mover.currentSide.ordinal()) {
                case 0: {
                    return bufferAccessor1;
                }
                case 2: {
                    return bufferAccessor2;
                }
            }
        }
        return null;
    }

    static boolean nextMainBoundary(AbstractBoundary2DScanner scanner, UpdatablePFixedArray bufferArray) {
        boolean atLeftBoundary;
        if (scanner.arrayLength == 0L) {
            return false;
        }
        long index = scanner.currentIndexInArray();
        boolean bl = atLeftBoundary = bufferArray.getInt(index) != 0;
        if (!atLeftBoundary) {
            return Boundary2DScanner.nextSingleBoundary(scanner);
        }
        long x = scanner.x;
        do {
            long i;
            if ((i = bufferArray.indexOf(index + 1L, index + scanner.dimX - x, 1L)) == -1L) {
                i = scanner.dimX - x - 1L;
            } else {
                bufferArray.setInt(i, 0);
                i -= index + 1L;
            }
            bufferArray.fill(index + 1L, i, 1L);
            if ((index += i) >= scanner.arrayLength) {
                return false;
            }
            if ((index = scanner.array.indexOf(index + 1L, scanner.arrayLength, true)) == -1L) {
                return false;
            }
            x = index % scanner.dimX;
        } while (atLeftBoundary = bufferArray.getInt(index) != 0);
        scanner.goTo(x, index / scanner.dimX, Side.X_MINUS);
        return true;
    }

    private static boolean goToNextUnitBit(Boundary2DScanner scanner, long index) {
        long i = scanner.array.indexOf(index, scanner.arrayLength, true);
        if (i == -1L) {
            return false;
        }
        scanner.goTo(i % scanner.dimX, i / scanner.dimX, Side.X_MINUS);
        return true;
    }

    private static boolean isDirectBitArray(BitArray array) {
        if (SimpleMemoryModel.isSimpleArray(array)) {
            DataBitBuffer buf = array.buffer(DataBuffer.AccessMode.READ, 16L);
            return buf.isDirect();
        }
        return false;
    }

    static {
        Side.X_MINUS.diagonal = new Step(4, -1, -1, Side.X_MINUS, Side.Y_PLUS);
        Side.X_MINUS.straight = new Step(0, 0, -1, Side.X_MINUS, Side.X_MINUS);
        Side.X_MINUS.rotation = new Step(8, 0, 0, Side.X_MINUS, Side.Y_MINUS);
        Side.Y_MINUS.diagonal = new Step(5, 1, -1, Side.Y_MINUS, Side.X_MINUS);
        Side.Y_MINUS.straight = new Step(1, 1, 0, Side.Y_MINUS, Side.Y_MINUS);
        Side.Y_MINUS.rotation = new Step(9, 0, 0, Side.Y_MINUS, Side.X_PLUS);
        Side.X_PLUS.diagonal = new Step(6, 1, 1, Side.X_PLUS, Side.Y_MINUS);
        Side.X_PLUS.straight = new Step(2, 0, 1, Side.X_PLUS, Side.X_PLUS);
        Side.X_PLUS.rotation = new Step(10, 0, 0, Side.X_PLUS, Side.Y_PLUS);
        Side.Y_PLUS.diagonal = new Step(7, -1, 1, Side.Y_PLUS, Side.X_PLUS);
        Side.Y_PLUS.straight = new Step(3, -1, 0, Side.Y_PLUS, Side.Y_PLUS);
        Side.Y_PLUS.rotation = new Step(11, 0, 0, Side.Y_PLUS, Side.X_MINUS);
        if (ALL_SIDES.length != 4) {
            throw new AssertionError((Object)"The number of sides must be 4");
        }
        for (Side side : Side.values()) {
            if (side.diagonal.oldSide != side || side.straight.oldSide != side || side.rotation.oldSide != side) {
                throw new AssertionError((Object)"Incorrect class initialization");
            }
            if (side.straight.newSide != side) {
                throw new AssertionError((Object)"Incorrect class initialization");
            }
            if (!side.rotation.samePixel) {
                throw new AssertionError((Object)"Incorrect class initialization");
            }
        }
        int xSum = 0;
        int ySum = 0;
        for (Side side : Side.values()) {
            xSum += side.straight.pixelCenterDX;
            ySum += side.straight.pixelCenterDY;
        }
        if (xSum != 0 || ySum != 0) {
            throw new AssertionError((Object)"Incorrect class initialization");
        }
        xSum = 0;
        ySum = 0;
        for (Side side : Side.values()) {
            xSum += side.diagonal.pixelCenterDX;
            ySum += side.diagonal.pixelCenterDY;
        }
        if (xSum != 0 || ySum != 0) {
            throw new AssertionError((Object)"Incorrect class initialization");
        }
    }

    static class SingleBoundary2D4Scanner
    extends SingleBoundary2DScanner {
        SingleBoundary2D4Scanner(Matrix<? extends BitArray> matrix) {
            super(matrix);
        }

        @Override
        public ConnectivityType connectivityType() {
            return ConnectivityType.STRAIGHT_ONLY;
        }

        @Override
        public void next() {
            if (this.mover == null) {
                throw new IllegalStateException("The boundary scanner is not positioned yet");
            }
            this.mover.next4();
            this.mover.currentSide.correctState(this);
        }
    }

    static class DirectSingleBoundary2D4Scanner
    extends DirectSingleBoundary2DScanner {
        DirectSingleBoundary2D4Scanner(Matrix<? extends BitArray> matrix) {
            super(matrix);
        }

        @Override
        public ConnectivityType connectivityType() {
            return ConnectivityType.STRAIGHT_ONLY;
        }

        @Override
        public void next() {
            if (this.mover == null) {
                throw new IllegalStateException("The boundary scanner is not positioned yet");
            }
            this.mover.next4();
            this.mover.currentSide.correctState(this);
        }
    }

    static class SingleBoundary2D8Scanner
    extends SingleBoundary2DScanner {
        SingleBoundary2D8Scanner(Matrix<? extends BitArray> matrix) {
            super(matrix);
        }

        @Override
        public ConnectivityType connectivityType() {
            return ConnectivityType.STRAIGHT_AND_DIAGONAL;
        }

        @Override
        public void next() {
            if (this.mover == null) {
                throw new IllegalStateException("The boundary scanner is not positioned yet");
            }
            this.mover.next8();
            this.mover.currentSide.correctState(this);
        }
    }

    static class DirectSingleBoundary2D8Scanner
    extends DirectSingleBoundary2DScanner {
        DirectSingleBoundary2D8Scanner(Matrix<? extends BitArray> matrix) {
            super(matrix);
        }

        @Override
        public ConnectivityType connectivityType() {
            return ConnectivityType.STRAIGHT_AND_DIAGONAL;
        }

        @Override
        public void next() {
            if (this.mover == null) {
                throw new IllegalStateException("The boundary scanner is not positioned yet");
            }
            this.mover.next8();
            this.mover.currentSide.correctState(this);
        }
    }

    static class AllBoundaries2D4Scanner
    extends SingleBoundary2D4Scanner {
        private final AbstractBoundary2DScanner.AbstractAccessor bufferAccessor1;
        private final AbstractBoundary2DScanner.AbstractAccessor bufferAccessor2;
        private AbstractBoundary2DScanner.AbstractAccessor bufferAccessor = null;

        private AllBoundaries2D4Scanner(Matrix<? extends BitArray> matrix, Matrix<? extends UpdatablePFixedArray> buffer1, Matrix<? extends UpdatablePFixedArray> buffer2) {
            super(matrix);
            Objects.requireNonNull(buffer1, "Null buffer1 argument");
            Objects.requireNonNull(buffer2, "Null buffer2 argument");
            if (!buffer1.dimEquals(matrix)) {
                throw new SizeMismatchException("matrix and buffer1 dimensions mismatch: matrix is " + String.valueOf(matrix) + ", buffer is " + String.valueOf(buffer1));
            }
            if (!buffer2.dimEquals(matrix)) {
                throw new SizeMismatchException("matrix and buffer2 dimensions mismatch: matrix is " + String.valueOf(matrix) + ", buffer is " + String.valueOf(buffer2));
            }
            this.bufferAccessor1 = this.getAccessor(buffer1);
            this.bufferAccessor2 = this.getAccessor(buffer2);
            this.bufferAccessor = this.bufferAccessor1;
        }

        @Override
        public boolean isSingleBoundaryScanner() {
            return false;
        }

        @Override
        public boolean isAllBoundariesScanner() {
            return true;
        }

        @Override
        public boolean isMainBoundariesScanner() {
            return false;
        }

        @Override
        public boolean nextBoundary() {
            AbstractBoundary2DScanner.AbstractAccessor result = AllBoundaries2D4Scanner.nextAnyBoundary(this, this.bufferAccessor1, this.bufferAccessor2);
            if (result == null) {
                return false;
            }
            this.bufferAccessor = result;
            return true;
        }

        @Override
        public void next() {
            if (this.mover == null) {
                throw new IllegalStateException("The boundary scanner is not positioned yet");
            }
            this.mover.next4();
            this.mover.setHorizontalBracket(this.bufferAccessor);
            this.mover.currentSide.correctState(this);
        }

        @Override
        public String toString() {
            return "all boundaries " + super.toString();
        }
    }

    static class DirectAllBoundaries2D4Scanner
    extends DirectSingleBoundary2D4Scanner {
        private final AbstractBoundary2DScanner.AbstractAccessor bufferAccessor1;
        private final AbstractBoundary2DScanner.AbstractAccessor bufferAccessor2;
        private AbstractBoundary2DScanner.AbstractAccessor bufferAccessor = null;

        private DirectAllBoundaries2D4Scanner(Matrix<? extends BitArray> matrix, Matrix<? extends UpdatablePFixedArray> buffer1, Matrix<? extends UpdatablePFixedArray> buffer2) {
            super(matrix);
            Objects.requireNonNull(buffer1, "Null buffer1 argument");
            Objects.requireNonNull(buffer2, "Null buffer2 argument");
            if (!buffer1.dimEquals(matrix)) {
                throw new SizeMismatchException("matrix and buffer1 dimensions mismatch: matrix is " + String.valueOf(matrix) + ", buffer is " + String.valueOf(buffer1));
            }
            if (!buffer2.dimEquals(matrix)) {
                throw new SizeMismatchException("matrix and buffer2 dimensions mismatch: matrix is " + String.valueOf(matrix) + ", buffer is " + String.valueOf(buffer2));
            }
            this.bufferAccessor1 = this.getAccessor(buffer1);
            this.bufferAccessor2 = this.getAccessor(buffer2);
            this.bufferAccessor = this.bufferAccessor1;
        }

        @Override
        public boolean isSingleBoundaryScanner() {
            return false;
        }

        @Override
        public boolean isAllBoundariesScanner() {
            return true;
        }

        @Override
        public boolean isMainBoundariesScanner() {
            return false;
        }

        @Override
        public boolean nextBoundary() {
            AbstractBoundary2DScanner.AbstractAccessor result = DirectAllBoundaries2D4Scanner.nextAnyBoundary(this, this.bufferAccessor1, this.bufferAccessor2);
            if (result == null) {
                return false;
            }
            this.bufferAccessor = result;
            return true;
        }

        @Override
        public void next() {
            if (this.mover == null) {
                throw new IllegalStateException("The boundary scanner is not positioned yet");
            }
            this.mover.next4();
            this.mover.setHorizontalBracket(this.bufferAccessor);
            this.mover.currentSide.correctState(this);
        }

        @Override
        public String toString() {
            return "all boundaries " + super.toString();
        }
    }

    static class AllBoundaries2D8Scanner
    extends SingleBoundary2D8Scanner {
        private final AbstractBoundary2DScanner.AbstractAccessor bufferAccessor1;
        private final AbstractBoundary2DScanner.AbstractAccessor bufferAccessor2;
        private AbstractBoundary2DScanner.AbstractAccessor bufferAccessor = null;

        private AllBoundaries2D8Scanner(Matrix<? extends BitArray> matrix, Matrix<? extends UpdatablePFixedArray> buffer1, Matrix<? extends UpdatablePFixedArray> buffer2) {
            super(matrix);
            Objects.requireNonNull(buffer1, "Null buffer1 argument");
            Objects.requireNonNull(buffer2, "Null buffer2 argument");
            if (!buffer1.dimEquals(matrix)) {
                throw new SizeMismatchException("matrix and buffer1 dimensions mismatch: matrix is " + String.valueOf(matrix) + ", buffer is " + String.valueOf(buffer1));
            }
            if (!buffer2.dimEquals(matrix)) {
                throw new SizeMismatchException("matrix and buffer2 dimensions mismatch: matrix is " + String.valueOf(matrix) + ", buffer is " + String.valueOf(buffer2));
            }
            this.bufferAccessor1 = this.getAccessor(buffer1);
            this.bufferAccessor2 = this.getAccessor(buffer2);
            this.bufferAccessor = this.bufferAccessor1;
        }

        @Override
        public boolean isSingleBoundaryScanner() {
            return false;
        }

        @Override
        public boolean isAllBoundariesScanner() {
            return true;
        }

        @Override
        public boolean isMainBoundariesScanner() {
            return false;
        }

        @Override
        public boolean nextBoundary() {
            AbstractBoundary2DScanner.AbstractAccessor result = AllBoundaries2D8Scanner.nextAnyBoundary(this, this.bufferAccessor1, this.bufferAccessor2);
            if (result == null) {
                return false;
            }
            this.bufferAccessor = result;
            return true;
        }

        @Override
        public void next() {
            if (this.mover == null) {
                throw new IllegalStateException("The boundary scanner is not positioned yet");
            }
            this.mover.next8();
            this.mover.setHorizontalBracket(this.bufferAccessor);
            this.mover.currentSide.correctState(this);
        }

        @Override
        public String toString() {
            return "all boundaries " + super.toString();
        }
    }

    static class DirectAllBoundaries2D8Scanner
    extends DirectSingleBoundary2D8Scanner {
        private final AbstractBoundary2DScanner.AbstractAccessor bufferAccessor1;
        private final AbstractBoundary2DScanner.AbstractAccessor bufferAccessor2;
        private AbstractBoundary2DScanner.AbstractAccessor bufferAccessor = null;

        private DirectAllBoundaries2D8Scanner(Matrix<? extends BitArray> matrix, Matrix<? extends UpdatablePFixedArray> buffer1, Matrix<? extends UpdatablePFixedArray> buffer2) {
            super(matrix);
            Objects.requireNonNull(buffer1, "Null buffer1 argument");
            Objects.requireNonNull(buffer2, "Null buffer2 argument");
            if (!buffer1.dimEquals(matrix)) {
                throw new SizeMismatchException("matrix and buffer1 dimensions mismatch: matrix is " + String.valueOf(matrix) + ", buffer is " + String.valueOf(buffer1));
            }
            if (!buffer2.dimEquals(matrix)) {
                throw new SizeMismatchException("matrix and buffer2 dimensions mismatch: matrix is " + String.valueOf(matrix) + ", buffer is " + String.valueOf(buffer2));
            }
            this.bufferAccessor1 = this.getAccessor(buffer1);
            this.bufferAccessor2 = this.getAccessor(buffer2);
            this.bufferAccessor = this.bufferAccessor1;
        }

        @Override
        public boolean isSingleBoundaryScanner() {
            return false;
        }

        @Override
        public boolean isAllBoundariesScanner() {
            return true;
        }

        @Override
        public boolean isMainBoundariesScanner() {
            return false;
        }

        @Override
        public boolean nextBoundary() {
            AbstractBoundary2DScanner.AbstractAccessor result = DirectAllBoundaries2D8Scanner.nextAnyBoundary(this, this.bufferAccessor1, this.bufferAccessor2);
            if (result == null) {
                return false;
            }
            this.bufferAccessor = result;
            return true;
        }

        @Override
        public void next() {
            if (this.mover == null) {
                throw new IllegalStateException("The boundary scanner is not positioned yet");
            }
            this.mover.next8();
            this.mover.setHorizontalBracket(this.bufferAccessor);
            this.mover.currentSide.correctState(this);
        }

        @Override
        public String toString() {
            return "all boundaries " + super.toString();
        }
    }

    static class MainBoundaries2D4Scanner
    extends SingleBoundary2D4Scanner {
        private final AbstractBoundary2DScanner.AbstractAccessor bufferAccessor;
        private final UpdatablePFixedArray bufferArray;

        private MainBoundaries2D4Scanner(Matrix<? extends BitArray> matrix, Matrix<? extends UpdatablePFixedArray> buffer) {
            super(matrix);
            Objects.requireNonNull(buffer, "Null buffer argument");
            if (!buffer.dimEquals(matrix)) {
                throw new SizeMismatchException("matrix and buffer dimensions mismatch: matrix is " + String.valueOf(matrix) + ", buffer is " + String.valueOf(buffer));
            }
            this.bufferAccessor = this.getAccessor(buffer);
            this.bufferArray = buffer.array();
        }

        @Override
        public boolean isSingleBoundaryScanner() {
            return false;
        }

        @Override
        public boolean isAllBoundariesScanner() {
            return false;
        }

        @Override
        public boolean isMainBoundariesScanner() {
            return true;
        }

        @Override
        public boolean nextBoundary() {
            return MainBoundaries2D4Scanner.nextMainBoundary(this, this.bufferArray);
        }

        @Override
        public void next() {
            if (this.mover == null) {
                throw new IllegalStateException("The boundary scanner is not positioned yet");
            }
            this.mover.next4();
            this.mover.setHorizontalBracket(this.bufferAccessor);
            this.mover.currentSide.correctState(this);
        }

        @Override
        public String toString() {
            return "main boundaries " + super.toString();
        }
    }

    static class DirectMainBoundaries2D4Scanner
    extends DirectSingleBoundary2D4Scanner {
        private final AbstractBoundary2DScanner.AbstractAccessor bufferAccessor;
        private final UpdatablePFixedArray bufferArray;

        private DirectMainBoundaries2D4Scanner(Matrix<? extends BitArray> matrix, Matrix<? extends UpdatablePFixedArray> buffer) {
            super(matrix);
            Objects.requireNonNull(buffer, "Null buffer argument");
            if (!buffer.dimEquals(matrix)) {
                throw new SizeMismatchException("matrix and buffer dimensions mismatch: matrix is " + String.valueOf(matrix) + ", buffer is " + String.valueOf(buffer));
            }
            this.bufferAccessor = this.getAccessor(buffer);
            this.bufferArray = buffer.array();
        }

        @Override
        public boolean isSingleBoundaryScanner() {
            return false;
        }

        @Override
        public boolean isAllBoundariesScanner() {
            return false;
        }

        @Override
        public boolean isMainBoundariesScanner() {
            return true;
        }

        @Override
        public boolean nextBoundary() {
            return DirectMainBoundaries2D4Scanner.nextMainBoundary(this, this.bufferArray);
        }

        @Override
        public void next() {
            if (this.mover == null) {
                throw new IllegalStateException("The boundary scanner is not positioned yet");
            }
            this.mover.next4();
            this.mover.setHorizontalBracket(this.bufferAccessor);
            this.mover.currentSide.correctState(this);
        }

        @Override
        public String toString() {
            return "main boundaries " + super.toString();
        }
    }

    static class MainBoundaries2D8Scanner
    extends SingleBoundary2D8Scanner {
        private final AbstractBoundary2DScanner.AbstractAccessor bufferAccessor;
        private final UpdatablePFixedArray bufferArray;

        private MainBoundaries2D8Scanner(Matrix<? extends BitArray> matrix, Matrix<? extends UpdatablePFixedArray> buffer) {
            super(matrix);
            Objects.requireNonNull(buffer, "Null buffer argument");
            if (!buffer.dimEquals(matrix)) {
                throw new SizeMismatchException("matrix and buffer dimensions mismatch: matrix is " + String.valueOf(matrix) + ", buffer is " + String.valueOf(buffer));
            }
            this.bufferAccessor = this.getAccessor(buffer);
            this.bufferArray = buffer.array();
        }

        @Override
        public boolean isSingleBoundaryScanner() {
            return false;
        }

        @Override
        public boolean isAllBoundariesScanner() {
            return false;
        }

        @Override
        public boolean isMainBoundariesScanner() {
            return true;
        }

        @Override
        public boolean nextBoundary() {
            return MainBoundaries2D8Scanner.nextMainBoundary(this, this.bufferArray);
        }

        @Override
        public void next() {
            if (this.mover == null) {
                throw new IllegalStateException("The boundary scanner is not positioned yet");
            }
            this.mover.next8();
            this.mover.setHorizontalBracket(this.bufferAccessor);
            this.mover.currentSide.correctState(this);
        }

        @Override
        public String toString() {
            return "main boundaries " + super.toString();
        }
    }

    static class DirectMainBoundaries2D8Scanner
    extends DirectSingleBoundary2D8Scanner {
        private final AbstractBoundary2DScanner.AbstractAccessor bufferAccessor;
        private final UpdatablePFixedArray bufferArray;

        private DirectMainBoundaries2D8Scanner(Matrix<? extends BitArray> matrix, Matrix<? extends UpdatablePFixedArray> buffer) {
            super(matrix);
            Objects.requireNonNull(buffer, "Null buffer argument");
            if (!buffer.dimEquals(matrix)) {
                throw new SizeMismatchException("matrix and buffer dimensions mismatch: matrix is " + String.valueOf(matrix) + ", buffer is " + String.valueOf(buffer));
            }
            this.bufferAccessor = this.getAccessor(buffer);
            this.bufferArray = buffer.array();
        }

        @Override
        public boolean isSingleBoundaryScanner() {
            return false;
        }

        @Override
        public boolean isAllBoundariesScanner() {
            return false;
        }

        @Override
        public boolean isMainBoundariesScanner() {
            return true;
        }

        @Override
        public boolean nextBoundary() {
            return DirectMainBoundaries2D8Scanner.nextMainBoundary(this, this.bufferArray);
        }

        @Override
        public void next() {
            if (this.mover == null) {
                throw new IllegalStateException("The boundary scanner is not positioned yet");
            }
            this.mover.next8();
            this.mover.setHorizontalBracket(this.bufferAccessor);
            this.mover.currentSide.correctState(this);
        }

        @Override
        public String toString() {
            return "main boundaries " + super.toString();
        }
    }

    public static enum Side {
        X_MINUS(0, true, 0, -1, -0.5, 0.0){

            @Override
            AbstractBoundary2DScanner.AbstractMover getMover(AbstractBoundary2DScanner scanner) {
                return scanner.getMoverXM();
            }

            @Override
            void correctState(AbstractBoundary2DScanner scanner) {
                ++scanner.stepCount;
                long x = scanner.x;
                scanner.orientedArea -= x - 1L;
                scanner.atMatrixBoundary = x == 0L;
            }
        }
        ,
        Y_MINUS(1, false, 1, 0, 0.0, -0.5){

            @Override
            AbstractBoundary2DScanner.AbstractMover getMover(AbstractBoundary2DScanner scanner) {
                return scanner.getMoverYM();
            }

            @Override
            void correctState(AbstractBoundary2DScanner scanner) {
                ++scanner.stepCount;
                scanner.atMatrixBoundary = scanner.y == 0L;
            }
        }
        ,
        X_PLUS(2, true, 0, 1, 0.5, 0.0){

            @Override
            AbstractBoundary2DScanner.AbstractMover getMover(AbstractBoundary2DScanner scanner) {
                return scanner.getMoverXP();
            }

            @Override
            void correctState(AbstractBoundary2DScanner scanner) {
                ++scanner.stepCount;
                long x = scanner.x;
                scanner.orientedArea += x;
                scanner.atMatrixBoundary = x == scanner.dimX - 1L;
            }
        }
        ,
        Y_PLUS(3, false, -1, 0, 0.0, 0.5){

            @Override
            AbstractBoundary2DScanner.AbstractMover getMover(AbstractBoundary2DScanner scanner) {
                return scanner.getMoverYP();
            }

            @Override
            void correctState(AbstractBoundary2DScanner scanner) {
                ++scanner.stepCount;
                scanner.atMatrixBoundary = scanner.y == scanner.dimY - 1L;
            }
        };

        final int code;
        final boolean vertical;
        final int dxAlong;
        final int dyAlong;
        final double centerX;
        final double centerY;
        Step diagonal;
        Step straight;
        Step rotation;

        private Side(int code, boolean vertical, int dxAlong, int dyAlong, double centerX, double centerY) {
            this.code = code;
            this.vertical = vertical;
            this.dxAlong = dxAlong;
            this.dyAlong = dyAlong;
            this.centerX = centerX;
            this.centerY = centerY;
        }

        public boolean isHorizontal() {
            return !this.vertical;
        }

        public boolean isVertical() {
            return this.vertical;
        }

        public int dxAlong() {
            return this.dxAlong;
        }

        public int dyAlong() {
            return this.dyAlong;
        }

        public double centerX() {
            return this.centerX;
        }

        public double centerY() {
            return this.centerY;
        }

        abstract AbstractBoundary2DScanner.AbstractMover getMover(AbstractBoundary2DScanner var1);

        abstract void correctState(AbstractBoundary2DScanner var1);
    }

    public static class Step {
        public static final int Y_MINUS_CODE = 0;
        public static final int X_PLUS_CODE = 1;
        public static final int Y_PLUS_CODE = 2;
        public static final int X_MINUS_CODE = 3;
        public static final int X_MINUS_Y_MINUS_CODE = 4;
        public static final int X_PLUS_Y_MINUS_CODE = 5;
        public static final int X_PLUS_Y_PLUS_CODE = 6;
        public static final int X_MINUS_Y_PLUS_CODE = 7;
        public static final int ROTATION_X_MINUS_TO_Y_MINUS_CODE = 8;
        public static final int ROTATION_Y_MINUS_TO_X_PLUS_CODE = 9;
        public static final int ROTATION_X_PLUS_TO_Y_PLUS_CODE = 10;
        public static final int ROTATION_Y_PLUS_TO_X_MINUS_CODE = 11;
        final int code;
        final int pixelCenterDX;
        final int pixelCenterDY;
        final boolean samePixel;
        final boolean horizontal;
        final boolean vertical;
        final boolean straight;
        final boolean diagonal;
        final double d;
        final double segmentCenterDX;
        final double segmentCenterDY;
        final double pixelVertexX;
        final double pixelVertexY;
        final int increasedPixelVertexX;
        final int increasedPixelVertexY;
        final Side oldSide;
        final Side newSide;
        public static final double DIAGONAL_LENGTH = StrictMath.sqrt(2.0);
        public static final double HALF_DIAGONAL_LENGTH = 0.5 * StrictMath.sqrt(2.0);

        private Step(int code, int pixelCenterDX, int pixelCenterDY, Side oldSide, Side newSide) {
            assert (code <= 12 && Math.abs(pixelCenterDX) <= 1 && Math.abs(pixelCenterDY) <= 1);
            this.code = code;
            this.pixelCenterDX = pixelCenterDX;
            this.pixelCenterDY = pixelCenterDY;
            this.samePixel = pixelCenterDX == 0 && pixelCenterDY == 0;
            this.horizontal = pixelCenterDX == 0 && pixelCenterDY != 0;
            this.vertical = pixelCenterDX != 0 && pixelCenterDY == 0;
            this.straight = this.horizontal || this.vertical;
            boolean bl = this.diagonal = pixelCenterDX != 0 && pixelCenterDY != 0;
            this.d = this.samePixel ? 0.0 : (this.straight ? 1.0 : DIAGONAL_LENGTH);
            this.oldSide = oldSide;
            this.newSide = newSide;
            if (this.straight) {
                this.segmentCenterDX = pixelCenterDX;
                this.segmentCenterDY = pixelCenterDY;
                double d = pixelCenterDX == 0 ? newSide.centerX : (this.pixelVertexX = pixelCenterDX == 1 ? -0.5 : 0.5);
                this.pixelVertexY = pixelCenterDY == 0 ? newSide.centerY : (pixelCenterDY == 1 ? -0.5 : 0.5);
            } else if (this.samePixel) {
                this.segmentCenterDX = newSide.centerX - oldSide.centerX;
                this.segmentCenterDY = newSide.centerY - oldSide.centerY;
                this.pixelVertexX = newSide == Side.X_MINUS || newSide == Side.X_PLUS ? newSide.centerX : oldSide.centerX;
                double d = this.pixelVertexY = newSide == Side.Y_MINUS || newSide == Side.Y_PLUS ? newSide.centerY : oldSide.centerY;
                if (StrictMath.abs(0.5 * (double)(oldSide.dxAlong() + newSide.dxAlong()) - this.segmentCenterDX) > 0.001 || StrictMath.abs(0.5 * (double)(oldSide.dyAlong() + newSide.dyAlong()) - this.segmentCenterDY) > 0.001) {
                    throw new AssertionError((Object)("Incorrect class initialization: dx/dyAlong do not match to centerX/Y in " + String.valueOf((Object)oldSide) + " and " + String.valueOf((Object)newSide)));
                }
            } else {
                this.segmentCenterDX = 0.5 * (double)pixelCenterDX;
                this.segmentCenterDY = 0.5 * (double)pixelCenterDY;
                this.pixelVertexX = newSide == Side.X_MINUS || newSide == Side.X_PLUS ? newSide.centerX : -oldSide.centerX;
                double d = this.pixelVertexY = newSide == Side.Y_MINUS || newSide == Side.Y_PLUS ? newSide.centerY : -oldSide.centerY;
            }
            if (StrictMath.abs(StrictMath.abs(this.pixelVertexX) + StrictMath.abs(this.pixelVertexY) - 1.0) > 0.001) {
                throw new AssertionError((Object)("Incorrect class initialization (|pixelVertexX| + |this.pixelVertexY| != 1): " + String.valueOf(this)));
            }
            this.increasedPixelVertexX = (int)Math.round(this.pixelVertexX + 0.5);
            this.increasedPixelVertexY = (int)Math.round(this.pixelVertexY + 0.5);
            if (this.increasedPixelVertexX != 0 && this.increasedPixelVertexX != 1) {
                throw new AssertionError((Object)("Incorrect class initialization (increasedPixelVertexX != 0 and != 1): " + String.valueOf(this)));
            }
            if (this.increasedPixelVertexY != 0 && this.increasedPixelVertexY != 1) {
                throw new AssertionError((Object)("Incorrect class initialization (increasedPixelVertexY != 0 and != 1): " + String.valueOf(this)));
            }
        }

        public int code() {
            return this.code;
        }

        public int pixelCenterDX() {
            return this.pixelCenterDX;
        }

        public int pixelCenterDY() {
            return this.pixelCenterDY;
        }

        public double segmentCenterDX() {
            return this.segmentCenterDX;
        }

        public double segmentCenterDY() {
            return this.segmentCenterDY;
        }

        public double pixelVertexX() {
            return this.pixelVertexX;
        }

        public double pixelVertexY() {
            return this.pixelVertexY;
        }

        public int increasedPixelVertexX() {
            return this.increasedPixelVertexX;
        }

        public int increasedPixelVertexY() {
            return this.increasedPixelVertexY;
        }

        public boolean isRotation() {
            return this.samePixel;
        }

        public boolean isHorizontal() {
            return this.horizontal;
        }

        public boolean isVertical() {
            return this.vertical;
        }

        public boolean isStraight() {
            return this.straight;
        }

        public boolean isDiagonal() {
            return this.diagonal;
        }

        public double distanceBetweenPixelCenters() {
            return this.d;
        }

        public double distanceBetweenSegmentCenters() {
            return this.straight ? 1.0 : HALF_DIAGONAL_LENGTH;
        }

        public Side oldSide() {
            return this.oldSide;
        }

        public Side newSide() {
            return this.newSide;
        }

        public String toString() {
            return "boundary scanning step from " + String.valueOf((Object)this.oldSide) + " to " + String.valueOf((Object)this.newSide) + " by " + this.pixelCenterDX + "," + this.pixelCenterDY + " (pixel vertex " + this.pixelVertexX + "," + this.pixelVertexY + ")";
        }
    }

    static abstract class AbstractBoundary2DScanner
    extends Boundary2DScanner {
        long x = 0L;
        long y = 0L;
        private long startX = 0L;
        private long startY = 0L;
        long nestingLevel = 0L;
        final AbstractAccessor accessor;
        final AbstractMover[] movers;
        AbstractMover mover = null;
        AbstractMover startMover = null;
        ShiftInfo lastShiftInfo = null;
        boolean atMatrixBoundary = false;
        long stepCount = 0L;
        long diagonalStepCount = 0L;
        long rotationStepCount = 0L;
        long orientedArea = 0L;

        private AbstractBoundary2DScanner(Matrix<? extends BitArray> matrix) {
            super(matrix);
            int k;
            this.accessor = this.getAccessor(matrix);
            this.movers = new AbstractMover[ALL_SIDES.length];
            for (k = 0; k < ALL_SIDES.length; ++k) {
                this.movers[k] = ALL_SIDES[k].getMover(this);
            }
            for (k = 0; k < ALL_SIDES.length; ++k) {
                Side side;
                this.movers[k].currentSide = side = ALL_SIDES[k];
                this.movers[k].diagonal = new ShiftInfo(side.diagonal, this.movers[side.diagonal.newSide.ordinal()]);
                this.movers[k].straight = new ShiftInfo(side.straight, this.movers[side.straight.newSide.ordinal()]);
                this.movers[k].rotation = new ShiftInfo(side.rotation, this.movers[side.rotation.newSide.ordinal()]);
            }
        }

        @Override
        public final boolean isInitialized() {
            return this.mover != null;
        }

        @Override
        public boolean isMovedAlongBoundary() {
            return this.lastShiftInfo != null;
        }

        @Override
        public final long x() {
            if (this.mover == null) {
                throw new IllegalStateException("The boundary scanner is not positioned yet");
            }
            return this.x;
        }

        @Override
        public final long y() {
            if (this.mover == null) {
                throw new IllegalStateException("The boundary scanner is not positioned yet");
            }
            return this.y;
        }

        @Override
        public final Side side() {
            if (this.mover == null) {
                throw new IllegalStateException("The boundary scanner is not positioned yet");
            }
            return this.mover.currentSide;
        }

        @Override
        public boolean atMatrixBoundary() {
            return this.atMatrixBoundary;
        }

        @Override
        public long nestingLevel() {
            return this.isAllBoundariesScanner() ? this.nestingLevel : 0L;
        }

        @Override
        public boolean nextBoundary() {
            return AbstractBoundary2DScanner.nextSingleBoundary(this);
        }

        @Override
        public void goTo(long x, long y, Side side) {
            if (x < 0L || x >= this.dimX) {
                throw new IndexOutOfBoundsException("Index x (" + x + (String)(x < 0L ? ") < 0" : ") >= dim(0) (" + this.dimX + ")"));
            }
            if (y < 0L || y >= this.dimY) {
                throw new IndexOutOfBoundsException("Index y (" + y + (String)(y < 0L ? ") < 0" : ") >= dim(1) (" + this.dimY + ")"));
            }
            Objects.requireNonNull(side, "Null side argument");
            this.x = this.startX = x;
            this.y = this.startY = y;
            this.mover = this.startMover = this.movers[side.ordinal()];
            this.resetCounters();
        }

        @Override
        public void resetCounters() {
            this.stepCount = 0L;
            this.diagonalStepCount = 0L;
            this.rotationStepCount = 0L;
            this.orientedArea = 0L;
        }

        @Override
        public final Step lastStep() {
            if (this.lastShiftInfo == null) {
                throw new IllegalStateException("The boundary scanner did not performed any steps yet");
            }
            return this.lastShiftInfo.shift;
        }

        @Override
        public final boolean coordinatesChanged() {
            if (this.lastShiftInfo == null) {
                throw new IllegalStateException("The boundary scanner did not performed any steps yet");
            }
            return this.lastShiftInfo.coordinatesChanged;
        }

        @Override
        public boolean boundaryFinished() {
            return this.x == this.startX && this.y == this.startY && this.mover == this.startMover;
        }

        @Override
        public long stepCount() {
            return this.stepCount;
        }

        @Override
        public long diagonalStepCount() {
            return this.diagonalStepCount;
        }

        @Override
        public long rotationStepCount() {
            return this.rotationStepCount;
        }

        @Override
        public long orientedArea() {
            return this.orientedArea;
        }

        abstract AbstractAccessor getAccessor(Matrix<? extends PFixedArray> var1);

        abstract AbstractMover getMoverXM();

        abstract AbstractMover getMoverYM();

        abstract AbstractMover getMoverXP();

        abstract AbstractMover getMoverYP();

        abstract class AbstractMover {
            final Matrix<? extends BitArray> matrix;
            final BitArray array;
            final long maxX;
            final long maxY;
            ShiftInfo diagonal;
            ShiftInfo straight;
            ShiftInfo rotation;
            Side currentSide;

            AbstractMover() {
                this.matrix = AbstractBoundary2DScanner.this.matrix;
                this.array = this.matrix.array();
                this.maxX = this.matrix.dimX() - 1L;
                this.maxY = this.matrix.dimY() - 1L;
            }

            abstract boolean atMatrixBound();

            abstract boolean straight();

            abstract boolean rightAfterStraight();

            abstract void straightBackLeft();

            abstract boolean diag();

            abstract boolean leftAfterDiag();

            abstract void straightBack();

            abstract boolean getHorizontalBracket(AbstractAccessor var1);

            abstract void setHorizontalBracket(AbstractAccessor var1);

            final void next4() {
                if (!this.atMatrixBound()) {
                    if (!this.straight()) {
                        this.straightBack();
                    } else {
                        if (this.rightAfterStraight()) {
                            AbstractBoundary2DScanner.this.lastShiftInfo = AbstractBoundary2DScanner.this.mover.diagonal;
                            AbstractBoundary2DScanner.this.mover = AbstractBoundary2DScanner.this.lastShiftInfo.newMover;
                            ++AbstractBoundary2DScanner.this.diagonalStepCount;
                            return;
                        }
                        this.straightBackLeft();
                        AbstractBoundary2DScanner.this.lastShiftInfo = AbstractBoundary2DScanner.this.mover.straight;
                        return;
                    }
                }
                AbstractBoundary2DScanner.this.lastShiftInfo = AbstractBoundary2DScanner.this.mover.rotation;
                AbstractBoundary2DScanner.this.mover = AbstractBoundary2DScanner.this.lastShiftInfo.newMover;
                ++AbstractBoundary2DScanner.this.rotationStepCount;
            }

            void next8() {
                if (!this.atMatrixBound()) {
                    if (this.diag()) {
                        AbstractBoundary2DScanner.this.lastShiftInfo = AbstractBoundary2DScanner.this.mover.diagonal;
                        AbstractBoundary2DScanner.this.mover = AbstractBoundary2DScanner.this.lastShiftInfo.newMover;
                        ++AbstractBoundary2DScanner.this.diagonalStepCount;
                        return;
                    }
                    if (this.leftAfterDiag()) {
                        AbstractBoundary2DScanner.this.lastShiftInfo = AbstractBoundary2DScanner.this.mover.straight;
                        return;
                    }
                    this.straightBack();
                }
                AbstractBoundary2DScanner.this.lastShiftInfo = AbstractBoundary2DScanner.this.mover.rotation;
                AbstractBoundary2DScanner.this.mover = AbstractBoundary2DScanner.this.lastShiftInfo.newMover;
                ++AbstractBoundary2DScanner.this.rotationStepCount;
            }
        }

        static final class ShiftInfo {
            final Step shift;
            final boolean coordinatesChanged;
            final AbstractMover newMover;

            ShiftInfo(Step shift, AbstractMover newMover) {
                this.shift = shift;
                this.coordinatesChanged = !shift.samePixel;
                this.newMover = newMover;
            }
        }

        static abstract class AbstractAccessor {
            final PFixedArray array;
            final UpdatablePFixedArray updatableArray;

            AbstractAccessor(PFixedArray array) {
                this.array = array;
                this.updatableArray = array instanceof UpdatablePFixedArray ? (UpdatablePFixedArray)array : null;
            }

            abstract boolean get();

            abstract void set();

            abstract boolean getNext();

            abstract void setNext();
        }

        abstract class AbstractMoverYP
        extends AbstractMover {
            AbstractMoverYP() {
            }

            @Override
            final boolean atMatrixBound() {
                return AbstractBoundary2DScanner.this.x == 0L;
            }

            @Override
            final boolean getHorizontalBracket(AbstractAccessor accessor) {
                return false;
            }

            @Override
            final void setHorizontalBracket(AbstractAccessor accessor) {
            }
        }

        abstract class AbstractMoverXP
        extends AbstractMover {
            AbstractMoverXP() {
            }

            @Override
            final boolean atMatrixBound() {
                return AbstractBoundary2DScanner.this.y == this.maxY;
            }

            @Override
            final boolean getHorizontalBracket(AbstractAccessor accessor) {
                return AbstractBoundary2DScanner.this.x < this.maxX && accessor.getNext();
            }

            @Override
            final void setHorizontalBracket(AbstractAccessor accessor) {
                if (AbstractBoundary2DScanner.this.x < this.maxX) {
                    accessor.setNext();
                }
            }
        }

        abstract class AbstractMoverYM
        extends AbstractMover {
            AbstractMoverYM() {
            }

            @Override
            final boolean atMatrixBound() {
                return AbstractBoundary2DScanner.this.x == this.maxX;
            }

            @Override
            final boolean getHorizontalBracket(AbstractAccessor accessor) {
                return false;
            }

            @Override
            final void setHorizontalBracket(AbstractAccessor accessor) {
            }
        }

        abstract class AbstractMoverXM
        extends AbstractMover {
            AbstractMoverXM() {
            }

            @Override
            final boolean atMatrixBound() {
                return AbstractBoundary2DScanner.this.y == 0L;
            }

            @Override
            final boolean getHorizontalBracket(AbstractAccessor accessor) {
                return accessor.get();
            }

            @Override
            final void setHorizontalBracket(AbstractAccessor accessor) {
                accessor.set();
            }
        }
    }

    static abstract class DirectSingleBoundary2DScanner
    extends AbstractBoundary2DScanner {
        private final long[] ja;
        private final long jaOfs;
        private long jaMask;
        private int jaDisp;
        private long index;

        DirectSingleBoundary2DScanner(Matrix<? extends BitArray> matrix) {
            super(matrix);
            if (!SimpleMemoryModel.isSimpleArray(this.array)) {
                throw new AssertionError((Object)("Illegal usage of " + String.valueOf(this.getClass()) + ": not simple array"));
            }
            DataBitBuffer buf = this.array.buffer(DataBuffer.AccessMode.READ, 16L);
            if (!buf.isDirect()) {
                throw new AssertionError((Object)("Illegal usage of " + String.valueOf(this.getClass()) + ": not direct buffer"));
            }
            buf.map(0L);
            this.ja = buf.data();
            this.jaOfs = buf.from();
            this.jaDisp = (int)(this.jaOfs >>> 6);
            this.jaMask = 1L << (int)(this.jaOfs & 0x3FL);
        }

        @Override
        public boolean isSingleBoundaryScanner() {
            return true;
        }

        @Override
        public boolean isAllBoundariesScanner() {
            return false;
        }

        @Override
        public boolean isMainBoundariesScanner() {
            return false;
        }

        @Override
        public long currentIndexInArray() {
            return this.y * this.dimX + this.x;
        }

        @Override
        public void goTo(long x, long y, Side side) {
            super.goTo(x, y, side);
            this.index = y * this.dimX + x;
            this.jaDisp = (int)(this.jaOfs + this.index >>> 6);
            this.jaMask = 1L << (int)(this.jaOfs + this.index & 0x3FL);
        }

        @Override
        public boolean get() {
            return (this.ja[this.jaDisp] & this.jaMask) != 0L;
        }

        @Override
        public String toString() {
            return "direct " + super.toString();
        }

        @Override
        final AbstractBoundary2DScanner.AbstractAccessor getAccessor(Matrix<? extends PFixedArray> matrix) {
            DataBitBuffer buf;
            PFixedArray array;
            if (this.ja != null && (array = matrix.array()) instanceof BitArray && SimpleMemoryModel.isSimpleArray(array) && (buf = ((BitArray)array).buffer(DataBuffer.AccessMode.READ, 16L)).isDirect()) {
                buf.map(0L);
                long[] mja = buf.data();
                long mjaOfs = buf.from();
                if (mja != null && mjaOfs == this.jaOfs) {
                    return new DirectAccessor((BitArray)array);
                }
            }
            return new Accessor(matrix);
        }

        @Override
        final AbstractBoundary2DScanner.AbstractMover getMoverXM() {
            return (this.dimX & 0x3FL) == 0L ? new Direct64MoverXM() : new DirectMoverXM();
        }

        @Override
        final AbstractBoundary2DScanner.AbstractMover getMoverYM() {
            return (this.dimX & 0x3FL) == 0L ? new Direct64MoverYM() : new DirectMoverYM();
        }

        @Override
        final AbstractBoundary2DScanner.AbstractMover getMoverXP() {
            return (this.dimX & 0x3FL) == 0L ? new Direct64MoverXP() : new DirectMoverXP();
        }

        @Override
        final AbstractBoundary2DScanner.AbstractMover getMoverYP() {
            return (this.dimX & 0x3FL) == 0L ? new Direct64MoverYP() : new DirectMoverYP();
        }

        class DirectAccessor
        extends AbstractBoundary2DScanner.AbstractAccessor {
            final long[] ja;

            DirectAccessor(BitArray array) {
                super(array);
                if (!SimpleMemoryModel.isSimpleArray(array)) {
                    throw new AssertionError((Object)("Illegal usage of " + String.valueOf(this.getClass()) + ": not simple array"));
                }
                DataBitBuffer buf = array.buffer(DataBuffer.AccessMode.READ, 16L);
                if (!buf.isDirect()) {
                    throw new AssertionError((Object)("Illegal usage of " + String.valueOf(this.getClass()) + ": not direct buffer"));
                }
                buf.map(0L);
                this.ja = buf.data();
                if ((long)buf.from() != DirectSingleBoundary2DScanner.this.jaOfs) {
                    throw new AssertionError((Object)("Illegal usage of " + String.valueOf(this.getClass()) + ": different offsets"));
                }
            }

            @Override
            boolean get() {
                return (this.ja[DirectSingleBoundary2DScanner.this.jaDisp] & DirectSingleBoundary2DScanner.this.jaMask) != 0L;
            }

            @Override
            void set() {
                int n = DirectSingleBoundary2DScanner.this.jaDisp;
                this.ja[n] = this.ja[n] | DirectSingleBoundary2DScanner.this.jaMask;
            }

            @Override
            boolean getNext() {
                int disp = DirectSingleBoundary2DScanner.this.jaDisp;
                long mask = DirectSingleBoundary2DScanner.this.jaMask << 1;
                if (mask == 0L) {
                    mask = 1L;
                    ++disp;
                }
                return (this.ja[disp] & mask) != 0L;
            }

            @Override
            void setNext() {
                int disp = DirectSingleBoundary2DScanner.this.jaDisp;
                long mask = DirectSingleBoundary2DScanner.this.jaMask << 1;
                if (mask == 0L) {
                    mask = 1L;
                }
                int n = ++disp;
                this.ja[n] = this.ja[n] | mask;
            }
        }

        class Accessor
        extends AbstractBoundary2DScanner.AbstractAccessor {
            Accessor(Matrix<? extends PFixedArray> matrix) {
                super(matrix.array());
            }

            @Override
            boolean get() {
                return this.array.getInt(DirectSingleBoundary2DScanner.this.y * DirectSingleBoundary2DScanner.this.dimX + DirectSingleBoundary2DScanner.this.x) != 0;
            }

            @Override
            void set() {
                this.updatableArray.setLong(DirectSingleBoundary2DScanner.this.y * DirectSingleBoundary2DScanner.this.dimX + DirectSingleBoundary2DScanner.this.x, 1L);
            }

            @Override
            boolean getNext() {
                return this.array.getLong(DirectSingleBoundary2DScanner.this.y * DirectSingleBoundary2DScanner.this.dimX + DirectSingleBoundary2DScanner.this.x + 1L) != 0L;
            }

            @Override
            void setNext() {
                this.updatableArray.setLong(DirectSingleBoundary2DScanner.this.y * DirectSingleBoundary2DScanner.this.dimX + DirectSingleBoundary2DScanner.this.x + 1L, 1L);
            }
        }

        class Direct64MoverXM
        extends AbstractBoundary2DScanner.AbstractMoverXM {
            final int jaStep;

            Direct64MoverXM() {
                this.jaStep = (int)(DirectSingleBoundary2DScanner.this.dimX >>> 6);
            }

            @Override
            boolean straight() {
                --DirectSingleBoundary2DScanner.this.y;
                DirectSingleBoundary2DScanner.this.jaDisp -= this.jaStep;
                return (DirectSingleBoundary2DScanner.this.ja[DirectSingleBoundary2DScanner.this.jaDisp] & DirectSingleBoundary2DScanner.this.jaMask) != 0L;
            }

            @Override
            boolean rightAfterStraight() {
                --DirectSingleBoundary2DScanner.this.x;
                --DirectSingleBoundary2DScanner.this.index;
                if ((DirectSingleBoundary2DScanner.this.jaMask >>>= 1) == 0L) {
                    DirectSingleBoundary2DScanner.this.jaMask = Long.MIN_VALUE;
                    --DirectSingleBoundary2DScanner.this.jaDisp;
                }
                return DirectSingleBoundary2DScanner.this.x >= 0L && (DirectSingleBoundary2DScanner.this.ja[DirectSingleBoundary2DScanner.this.jaDisp] & DirectSingleBoundary2DScanner.this.jaMask) != 0L;
            }

            @Override
            void straightBackLeft() {
                ++DirectSingleBoundary2DScanner.this.x;
                ++DirectSingleBoundary2DScanner.this.index;
                if ((DirectSingleBoundary2DScanner.this.jaMask <<= 1) == 0L) {
                    DirectSingleBoundary2DScanner.this.jaMask = 1L;
                    ++DirectSingleBoundary2DScanner.this.jaDisp;
                }
            }

            @Override
            boolean diag() {
                --DirectSingleBoundary2DScanner.this.y;
                --DirectSingleBoundary2DScanner.this.x;
                DirectSingleBoundary2DScanner.this.jaDisp -= this.jaStep;
                if ((DirectSingleBoundary2DScanner.this.jaMask >>>= 1) == 0L) {
                    DirectSingleBoundary2DScanner.this.jaMask = Long.MIN_VALUE;
                    --DirectSingleBoundary2DScanner.this.jaDisp;
                }
                return DirectSingleBoundary2DScanner.this.x >= 0L && (DirectSingleBoundary2DScanner.this.ja[DirectSingleBoundary2DScanner.this.jaDisp] & DirectSingleBoundary2DScanner.this.jaMask) != 0L;
            }

            @Override
            boolean leftAfterDiag() {
                ++DirectSingleBoundary2DScanner.this.x;
                if ((DirectSingleBoundary2DScanner.this.jaMask <<= 1) == 0L) {
                    DirectSingleBoundary2DScanner.this.jaMask = 1L;
                    ++DirectSingleBoundary2DScanner.this.jaDisp;
                }
                return (DirectSingleBoundary2DScanner.this.ja[DirectSingleBoundary2DScanner.this.jaDisp] & DirectSingleBoundary2DScanner.this.jaMask) != 0L;
            }

            @Override
            void straightBack() {
                ++DirectSingleBoundary2DScanner.this.y;
                DirectSingleBoundary2DScanner.this.jaDisp += this.jaStep;
            }

            @Override
            void next8() {
                if (DirectSingleBoundary2DScanner.this.y != 0L) {
                    --DirectSingleBoundary2DScanner.this.y;
                    --DirectSingleBoundary2DScanner.this.x;
                    DirectSingleBoundary2DScanner.this.jaDisp -= this.jaStep;
                    if ((DirectSingleBoundary2DScanner.this.jaMask >>>= 1) == 0L) {
                        DirectSingleBoundary2DScanner.this.jaMask = Long.MIN_VALUE;
                        --DirectSingleBoundary2DScanner.this.jaDisp;
                    }
                    if (DirectSingleBoundary2DScanner.this.x >= 0L && (DirectSingleBoundary2DScanner.this.ja[DirectSingleBoundary2DScanner.this.jaDisp] & DirectSingleBoundary2DScanner.this.jaMask) != 0L) {
                        DirectSingleBoundary2DScanner.this.lastShiftInfo = DirectSingleBoundary2DScanner.this.mover.diagonal;
                        DirectSingleBoundary2DScanner.this.mover = DirectSingleBoundary2DScanner.this.lastShiftInfo.newMover;
                        ++DirectSingleBoundary2DScanner.this.diagonalStepCount;
                        return;
                    }
                    ++DirectSingleBoundary2DScanner.this.x;
                    if ((DirectSingleBoundary2DScanner.this.jaMask <<= 1) == 0L) {
                        DirectSingleBoundary2DScanner.this.jaMask = 1L;
                        ++DirectSingleBoundary2DScanner.this.jaDisp;
                    }
                    if ((DirectSingleBoundary2DScanner.this.ja[DirectSingleBoundary2DScanner.this.jaDisp] & DirectSingleBoundary2DScanner.this.jaMask) != 0L) {
                        DirectSingleBoundary2DScanner.this.lastShiftInfo = DirectSingleBoundary2DScanner.this.mover.straight;
                        return;
                    }
                    ++DirectSingleBoundary2DScanner.this.y;
                    DirectSingleBoundary2DScanner.this.jaDisp += this.jaStep;
                }
                DirectSingleBoundary2DScanner.this.lastShiftInfo = DirectSingleBoundary2DScanner.this.mover.rotation;
                DirectSingleBoundary2DScanner.this.mover = DirectSingleBoundary2DScanner.this.lastShiftInfo.newMover;
                ++DirectSingleBoundary2DScanner.this.rotationStepCount;
            }
        }

        class DirectMoverXM
        extends AbstractBoundary2DScanner.AbstractMoverXM {
            DirectMoverXM() {
            }

            @Override
            boolean straight() {
                --DirectSingleBoundary2DScanner.this.y;
                DirectSingleBoundary2DScanner.this.index -= DirectSingleBoundary2DScanner.this.dimX;
                DirectSingleBoundary2DScanner.this.jaDisp = (int)(DirectSingleBoundary2DScanner.this.jaOfs + DirectSingleBoundary2DScanner.this.index >>> 6);
                DirectSingleBoundary2DScanner.this.jaMask = 1L << (int)(DirectSingleBoundary2DScanner.this.jaOfs + DirectSingleBoundary2DScanner.this.index & 0x3FL);
                return (DirectSingleBoundary2DScanner.this.ja[DirectSingleBoundary2DScanner.this.jaDisp] & DirectSingleBoundary2DScanner.this.jaMask) != 0L;
            }

            @Override
            boolean rightAfterStraight() {
                --DirectSingleBoundary2DScanner.this.x;
                --DirectSingleBoundary2DScanner.this.index;
                if ((DirectSingleBoundary2DScanner.this.jaMask >>>= 1) == 0L) {
                    DirectSingleBoundary2DScanner.this.jaMask = Long.MIN_VALUE;
                    --DirectSingleBoundary2DScanner.this.jaDisp;
                }
                return DirectSingleBoundary2DScanner.this.x >= 0L && (DirectSingleBoundary2DScanner.this.ja[DirectSingleBoundary2DScanner.this.jaDisp] & DirectSingleBoundary2DScanner.this.jaMask) != 0L;
            }

            @Override
            void straightBackLeft() {
                ++DirectSingleBoundary2DScanner.this.x;
                ++DirectSingleBoundary2DScanner.this.index;
                if ((DirectSingleBoundary2DScanner.this.jaMask <<= 1) == 0L) {
                    DirectSingleBoundary2DScanner.this.jaMask = 1L;
                    ++DirectSingleBoundary2DScanner.this.jaDisp;
                }
            }

            @Override
            boolean diag() {
                --DirectSingleBoundary2DScanner.this.y;
                --DirectSingleBoundary2DScanner.this.x;
                DirectSingleBoundary2DScanner.this.index -= DirectSingleBoundary2DScanner.this.dimX + 1L;
                DirectSingleBoundary2DScanner.this.jaDisp = (int)(DirectSingleBoundary2DScanner.this.jaOfs + DirectSingleBoundary2DScanner.this.index >>> 6);
                DirectSingleBoundary2DScanner.this.jaMask = 1L << (int)(DirectSingleBoundary2DScanner.this.jaOfs + DirectSingleBoundary2DScanner.this.index & 0x3FL);
                return DirectSingleBoundary2DScanner.this.x >= 0L && (DirectSingleBoundary2DScanner.this.ja[DirectSingleBoundary2DScanner.this.jaDisp] & DirectSingleBoundary2DScanner.this.jaMask) != 0L;
            }

            @Override
            boolean leftAfterDiag() {
                ++DirectSingleBoundary2DScanner.this.x;
                ++DirectSingleBoundary2DScanner.this.index;
                if ((DirectSingleBoundary2DScanner.this.jaMask <<= 1) == 0L) {
                    DirectSingleBoundary2DScanner.this.jaMask = 1L;
                    ++DirectSingleBoundary2DScanner.this.jaDisp;
                }
                return (DirectSingleBoundary2DScanner.this.ja[DirectSingleBoundary2DScanner.this.jaDisp] & DirectSingleBoundary2DScanner.this.jaMask) != 0L;
            }

            @Override
            void straightBack() {
                ++DirectSingleBoundary2DScanner.this.y;
                DirectSingleBoundary2DScanner.this.index += DirectSingleBoundary2DScanner.this.dimX;
                DirectSingleBoundary2DScanner.this.jaDisp = (int)(DirectSingleBoundary2DScanner.this.jaOfs + DirectSingleBoundary2DScanner.this.index >>> 6);
                DirectSingleBoundary2DScanner.this.jaMask = 1L << (int)(DirectSingleBoundary2DScanner.this.jaOfs + DirectSingleBoundary2DScanner.this.index & 0x3FL);
            }
        }

        class Direct64MoverYM
        extends AbstractBoundary2DScanner.AbstractMoverYM {
            final int jaStep;

            Direct64MoverYM() {
                this.jaStep = (int)(DirectSingleBoundary2DScanner.this.dimX >>> 6);
            }

            @Override
            boolean straight() {
                ++DirectSingleBoundary2DScanner.this.x;
                ++DirectSingleBoundary2DScanner.this.index;
                if ((DirectSingleBoundary2DScanner.this.jaMask <<= 1) == 0L) {
                    DirectSingleBoundary2DScanner.this.jaMask = 1L;
                    ++DirectSingleBoundary2DScanner.this.jaDisp;
                }
                return (DirectSingleBoundary2DScanner.this.ja[DirectSingleBoundary2DScanner.this.jaDisp] & DirectSingleBoundary2DScanner.this.jaMask) != 0L;
            }

            @Override
            boolean rightAfterStraight() {
                --DirectSingleBoundary2DScanner.this.y;
                DirectSingleBoundary2DScanner.this.jaDisp -= this.jaStep;
                return DirectSingleBoundary2DScanner.this.y >= 0L && (DirectSingleBoundary2DScanner.this.ja[DirectSingleBoundary2DScanner.this.jaDisp] & DirectSingleBoundary2DScanner.this.jaMask) != 0L;
            }

            @Override
            void straightBackLeft() {
                ++DirectSingleBoundary2DScanner.this.y;
                DirectSingleBoundary2DScanner.this.jaDisp += this.jaStep;
            }

            @Override
            boolean diag() {
                --DirectSingleBoundary2DScanner.this.y;
                ++DirectSingleBoundary2DScanner.this.x;
                DirectSingleBoundary2DScanner.this.jaDisp -= this.jaStep;
                if ((DirectSingleBoundary2DScanner.this.jaMask <<= 1) == 0L) {
                    DirectSingleBoundary2DScanner.this.jaMask = 1L;
                    ++DirectSingleBoundary2DScanner.this.jaDisp;
                }
                return DirectSingleBoundary2DScanner.this.y >= 0L && (DirectSingleBoundary2DScanner.this.ja[DirectSingleBoundary2DScanner.this.jaDisp] & DirectSingleBoundary2DScanner.this.jaMask) != 0L;
            }

            @Override
            boolean leftAfterDiag() {
                ++DirectSingleBoundary2DScanner.this.y;
                DirectSingleBoundary2DScanner.this.jaDisp += this.jaStep;
                return (DirectSingleBoundary2DScanner.this.ja[DirectSingleBoundary2DScanner.this.jaDisp] & DirectSingleBoundary2DScanner.this.jaMask) != 0L;
            }

            @Override
            void straightBack() {
                --DirectSingleBoundary2DScanner.this.x;
                if ((DirectSingleBoundary2DScanner.this.jaMask >>>= 1) == 0L) {
                    DirectSingleBoundary2DScanner.this.jaMask = Long.MIN_VALUE;
                    --DirectSingleBoundary2DScanner.this.jaDisp;
                }
            }

            @Override
            void next8() {
                if (DirectSingleBoundary2DScanner.this.x != this.maxX) {
                    --DirectSingleBoundary2DScanner.this.y;
                    ++DirectSingleBoundary2DScanner.this.x;
                    DirectSingleBoundary2DScanner.this.jaDisp -= this.jaStep;
                    if ((DirectSingleBoundary2DScanner.this.jaMask <<= 1) == 0L) {
                        DirectSingleBoundary2DScanner.this.jaMask = 1L;
                        ++DirectSingleBoundary2DScanner.this.jaDisp;
                    }
                    if (DirectSingleBoundary2DScanner.this.y >= 0L && (DirectSingleBoundary2DScanner.this.ja[DirectSingleBoundary2DScanner.this.jaDisp] & DirectSingleBoundary2DScanner.this.jaMask) != 0L) {
                        DirectSingleBoundary2DScanner.this.lastShiftInfo = DirectSingleBoundary2DScanner.this.mover.diagonal;
                        DirectSingleBoundary2DScanner.this.mover = DirectSingleBoundary2DScanner.this.lastShiftInfo.newMover;
                        ++DirectSingleBoundary2DScanner.this.diagonalStepCount;
                        return;
                    }
                    ++DirectSingleBoundary2DScanner.this.y;
                    DirectSingleBoundary2DScanner.this.jaDisp += this.jaStep;
                    if ((DirectSingleBoundary2DScanner.this.ja[DirectSingleBoundary2DScanner.this.jaDisp] & DirectSingleBoundary2DScanner.this.jaMask) != 0L) {
                        DirectSingleBoundary2DScanner.this.lastShiftInfo = DirectSingleBoundary2DScanner.this.mover.straight;
                        return;
                    }
                    --DirectSingleBoundary2DScanner.this.x;
                    if ((DirectSingleBoundary2DScanner.this.jaMask >>>= 1) == 0L) {
                        DirectSingleBoundary2DScanner.this.jaMask = Long.MIN_VALUE;
                        --DirectSingleBoundary2DScanner.this.jaDisp;
                    }
                }
                DirectSingleBoundary2DScanner.this.lastShiftInfo = DirectSingleBoundary2DScanner.this.mover.rotation;
                DirectSingleBoundary2DScanner.this.mover = DirectSingleBoundary2DScanner.this.lastShiftInfo.newMover;
                ++DirectSingleBoundary2DScanner.this.rotationStepCount;
            }
        }

        class DirectMoverYM
        extends AbstractBoundary2DScanner.AbstractMoverYM {
            DirectMoverYM() {
            }

            @Override
            boolean straight() {
                ++DirectSingleBoundary2DScanner.this.x;
                ++DirectSingleBoundary2DScanner.this.index;
                if ((DirectSingleBoundary2DScanner.this.jaMask <<= 1) == 0L) {
                    DirectSingleBoundary2DScanner.this.jaMask = 1L;
                    ++DirectSingleBoundary2DScanner.this.jaDisp;
                }
                return (DirectSingleBoundary2DScanner.this.ja[DirectSingleBoundary2DScanner.this.jaDisp] & DirectSingleBoundary2DScanner.this.jaMask) != 0L;
            }

            @Override
            boolean rightAfterStraight() {
                --DirectSingleBoundary2DScanner.this.y;
                DirectSingleBoundary2DScanner.this.index -= DirectSingleBoundary2DScanner.this.dimX;
                DirectSingleBoundary2DScanner.this.jaDisp = (int)(DirectSingleBoundary2DScanner.this.jaOfs + DirectSingleBoundary2DScanner.this.index >>> 6);
                DirectSingleBoundary2DScanner.this.jaMask = 1L << (int)(DirectSingleBoundary2DScanner.this.jaOfs + DirectSingleBoundary2DScanner.this.index & 0x3FL);
                return DirectSingleBoundary2DScanner.this.y >= 0L && (DirectSingleBoundary2DScanner.this.ja[DirectSingleBoundary2DScanner.this.jaDisp] & DirectSingleBoundary2DScanner.this.jaMask) != 0L;
            }

            @Override
            void straightBackLeft() {
                ++DirectSingleBoundary2DScanner.this.y;
                DirectSingleBoundary2DScanner.this.index += DirectSingleBoundary2DScanner.this.dimX;
                DirectSingleBoundary2DScanner.this.jaDisp = (int)(DirectSingleBoundary2DScanner.this.jaOfs + DirectSingleBoundary2DScanner.this.index >>> 6);
                DirectSingleBoundary2DScanner.this.jaMask = 1L << (int)(DirectSingleBoundary2DScanner.this.jaOfs + DirectSingleBoundary2DScanner.this.index & 0x3FL);
            }

            @Override
            boolean diag() {
                --DirectSingleBoundary2DScanner.this.y;
                ++DirectSingleBoundary2DScanner.this.x;
                DirectSingleBoundary2DScanner.this.index -= this.maxX;
                DirectSingleBoundary2DScanner.this.jaDisp = (int)(DirectSingleBoundary2DScanner.this.jaOfs + DirectSingleBoundary2DScanner.this.index >>> 6);
                DirectSingleBoundary2DScanner.this.jaMask = 1L << (int)(DirectSingleBoundary2DScanner.this.jaOfs + DirectSingleBoundary2DScanner.this.index & 0x3FL);
                return DirectSingleBoundary2DScanner.this.y >= 0L && (DirectSingleBoundary2DScanner.this.ja[DirectSingleBoundary2DScanner.this.jaDisp] & DirectSingleBoundary2DScanner.this.jaMask) != 0L;
            }

            @Override
            boolean leftAfterDiag() {
                ++DirectSingleBoundary2DScanner.this.y;
                DirectSingleBoundary2DScanner.this.index += DirectSingleBoundary2DScanner.this.dimX;
                DirectSingleBoundary2DScanner.this.jaDisp = (int)(DirectSingleBoundary2DScanner.this.jaOfs + DirectSingleBoundary2DScanner.this.index >>> 6);
                DirectSingleBoundary2DScanner.this.jaMask = 1L << (int)(DirectSingleBoundary2DScanner.this.jaOfs + DirectSingleBoundary2DScanner.this.index & 0x3FL);
                return (DirectSingleBoundary2DScanner.this.ja[DirectSingleBoundary2DScanner.this.jaDisp] & DirectSingleBoundary2DScanner.this.jaMask) != 0L;
            }

            @Override
            void straightBack() {
                --DirectSingleBoundary2DScanner.this.x;
                --DirectSingleBoundary2DScanner.this.index;
                if ((DirectSingleBoundary2DScanner.this.jaMask >>>= 1) == 0L) {
                    DirectSingleBoundary2DScanner.this.jaMask = Long.MIN_VALUE;
                    --DirectSingleBoundary2DScanner.this.jaDisp;
                }
            }
        }

        class Direct64MoverXP
        extends AbstractBoundary2DScanner.AbstractMoverXP {
            final int jaStep;

            Direct64MoverXP() {
                this.jaStep = (int)(DirectSingleBoundary2DScanner.this.dimX >>> 6);
            }

            @Override
            boolean straight() {
                ++DirectSingleBoundary2DScanner.this.y;
                DirectSingleBoundary2DScanner.this.jaDisp += this.jaStep;
                return (DirectSingleBoundary2DScanner.this.ja[DirectSingleBoundary2DScanner.this.jaDisp] & DirectSingleBoundary2DScanner.this.jaMask) != 0L;
            }

            @Override
            boolean rightAfterStraight() {
                ++DirectSingleBoundary2DScanner.this.x;
                if ((DirectSingleBoundary2DScanner.this.jaMask <<= 1) == 0L) {
                    DirectSingleBoundary2DScanner.this.jaMask = 1L;
                    ++DirectSingleBoundary2DScanner.this.jaDisp;
                }
                return DirectSingleBoundary2DScanner.this.x < DirectSingleBoundary2DScanner.this.dimX && (DirectSingleBoundary2DScanner.this.ja[DirectSingleBoundary2DScanner.this.jaDisp] & DirectSingleBoundary2DScanner.this.jaMask) != 0L;
            }

            @Override
            void straightBackLeft() {
                --DirectSingleBoundary2DScanner.this.x;
                --DirectSingleBoundary2DScanner.this.index;
                if ((DirectSingleBoundary2DScanner.this.jaMask >>>= 1) == 0L) {
                    DirectSingleBoundary2DScanner.this.jaMask = Long.MIN_VALUE;
                    --DirectSingleBoundary2DScanner.this.jaDisp;
                }
            }

            @Override
            boolean diag() {
                ++DirectSingleBoundary2DScanner.this.y;
                ++DirectSingleBoundary2DScanner.this.x;
                DirectSingleBoundary2DScanner.this.jaDisp += this.jaStep;
                if ((DirectSingleBoundary2DScanner.this.jaMask <<= 1) == 0L) {
                    DirectSingleBoundary2DScanner.this.jaMask = 1L;
                    ++DirectSingleBoundary2DScanner.this.jaDisp;
                }
                return DirectSingleBoundary2DScanner.this.x < DirectSingleBoundary2DScanner.this.dimX && (DirectSingleBoundary2DScanner.this.ja[DirectSingleBoundary2DScanner.this.jaDisp] & DirectSingleBoundary2DScanner.this.jaMask) != 0L;
            }

            @Override
            boolean leftAfterDiag() {
                --DirectSingleBoundary2DScanner.this.x;
                if ((DirectSingleBoundary2DScanner.this.jaMask >>>= 1) == 0L) {
                    DirectSingleBoundary2DScanner.this.jaMask = Long.MIN_VALUE;
                    --DirectSingleBoundary2DScanner.this.jaDisp;
                }
                return (DirectSingleBoundary2DScanner.this.ja[DirectSingleBoundary2DScanner.this.jaDisp] & DirectSingleBoundary2DScanner.this.jaMask) != 0L;
            }

            @Override
            void straightBack() {
                --DirectSingleBoundary2DScanner.this.y;
                DirectSingleBoundary2DScanner.this.jaDisp -= this.jaStep;
            }

            @Override
            void next8() {
                if (DirectSingleBoundary2DScanner.this.y != this.maxY) {
                    ++DirectSingleBoundary2DScanner.this.y;
                    ++DirectSingleBoundary2DScanner.this.x;
                    DirectSingleBoundary2DScanner.this.jaDisp += this.jaStep;
                    if ((DirectSingleBoundary2DScanner.this.jaMask <<= 1) == 0L) {
                        DirectSingleBoundary2DScanner.this.jaMask = 1L;
                        ++DirectSingleBoundary2DScanner.this.jaDisp;
                    }
                    if (DirectSingleBoundary2DScanner.this.x < DirectSingleBoundary2DScanner.this.dimX && (DirectSingleBoundary2DScanner.this.ja[DirectSingleBoundary2DScanner.this.jaDisp] & DirectSingleBoundary2DScanner.this.jaMask) != 0L) {
                        DirectSingleBoundary2DScanner.this.lastShiftInfo = DirectSingleBoundary2DScanner.this.mover.diagonal;
                        DirectSingleBoundary2DScanner.this.mover = DirectSingleBoundary2DScanner.this.lastShiftInfo.newMover;
                        ++DirectSingleBoundary2DScanner.this.diagonalStepCount;
                        return;
                    }
                    --DirectSingleBoundary2DScanner.this.x;
                    if ((DirectSingleBoundary2DScanner.this.jaMask >>>= 1) == 0L) {
                        DirectSingleBoundary2DScanner.this.jaMask = Long.MIN_VALUE;
                        --DirectSingleBoundary2DScanner.this.jaDisp;
                    }
                    if ((DirectSingleBoundary2DScanner.this.ja[DirectSingleBoundary2DScanner.this.jaDisp] & DirectSingleBoundary2DScanner.this.jaMask) != 0L) {
                        DirectSingleBoundary2DScanner.this.lastShiftInfo = DirectSingleBoundary2DScanner.this.mover.straight;
                        return;
                    }
                    --DirectSingleBoundary2DScanner.this.y;
                    DirectSingleBoundary2DScanner.this.jaDisp -= this.jaStep;
                }
                DirectSingleBoundary2DScanner.this.lastShiftInfo = DirectSingleBoundary2DScanner.this.mover.rotation;
                DirectSingleBoundary2DScanner.this.mover = DirectSingleBoundary2DScanner.this.lastShiftInfo.newMover;
                ++DirectSingleBoundary2DScanner.this.rotationStepCount;
            }
        }

        class DirectMoverXP
        extends AbstractBoundary2DScanner.AbstractMoverXP {
            DirectMoverXP() {
            }

            @Override
            boolean straight() {
                ++DirectSingleBoundary2DScanner.this.y;
                DirectSingleBoundary2DScanner.this.index += DirectSingleBoundary2DScanner.this.dimX;
                DirectSingleBoundary2DScanner.this.jaDisp = (int)(DirectSingleBoundary2DScanner.this.jaOfs + DirectSingleBoundary2DScanner.this.index >>> 6);
                DirectSingleBoundary2DScanner.this.jaMask = 1L << (int)(DirectSingleBoundary2DScanner.this.jaOfs + DirectSingleBoundary2DScanner.this.index & 0x3FL);
                return (DirectSingleBoundary2DScanner.this.ja[DirectSingleBoundary2DScanner.this.jaDisp] & DirectSingleBoundary2DScanner.this.jaMask) != 0L;
            }

            @Override
            boolean rightAfterStraight() {
                ++DirectSingleBoundary2DScanner.this.x;
                ++DirectSingleBoundary2DScanner.this.index;
                if ((DirectSingleBoundary2DScanner.this.jaMask <<= 1) == 0L) {
                    DirectSingleBoundary2DScanner.this.jaMask = 1L;
                    ++DirectSingleBoundary2DScanner.this.jaDisp;
                }
                return DirectSingleBoundary2DScanner.this.x < DirectSingleBoundary2DScanner.this.dimX && (DirectSingleBoundary2DScanner.this.ja[DirectSingleBoundary2DScanner.this.jaDisp] & DirectSingleBoundary2DScanner.this.jaMask) != 0L;
            }

            @Override
            void straightBackLeft() {
                --DirectSingleBoundary2DScanner.this.x;
                --DirectSingleBoundary2DScanner.this.index;
                if ((DirectSingleBoundary2DScanner.this.jaMask >>>= 1) == 0L) {
                    DirectSingleBoundary2DScanner.this.jaMask = Long.MIN_VALUE;
                    --DirectSingleBoundary2DScanner.this.jaDisp;
                }
            }

            @Override
            boolean diag() {
                ++DirectSingleBoundary2DScanner.this.y;
                ++DirectSingleBoundary2DScanner.this.x;
                DirectSingleBoundary2DScanner.this.index += DirectSingleBoundary2DScanner.this.dimX + 1L;
                DirectSingleBoundary2DScanner.this.jaDisp = (int)(DirectSingleBoundary2DScanner.this.jaOfs + DirectSingleBoundary2DScanner.this.index >>> 6);
                DirectSingleBoundary2DScanner.this.jaMask = 1L << (int)(DirectSingleBoundary2DScanner.this.jaOfs + DirectSingleBoundary2DScanner.this.index & 0x3FL);
                return DirectSingleBoundary2DScanner.this.x < DirectSingleBoundary2DScanner.this.dimX && (DirectSingleBoundary2DScanner.this.ja[DirectSingleBoundary2DScanner.this.jaDisp] & DirectSingleBoundary2DScanner.this.jaMask) != 0L;
            }

            @Override
            boolean leftAfterDiag() {
                --DirectSingleBoundary2DScanner.this.x;
                --DirectSingleBoundary2DScanner.this.index;
                if ((DirectSingleBoundary2DScanner.this.jaMask >>>= 1) == 0L) {
                    DirectSingleBoundary2DScanner.this.jaMask = Long.MIN_VALUE;
                    --DirectSingleBoundary2DScanner.this.jaDisp;
                }
                return (DirectSingleBoundary2DScanner.this.ja[DirectSingleBoundary2DScanner.this.jaDisp] & DirectSingleBoundary2DScanner.this.jaMask) != 0L;
            }

            @Override
            void straightBack() {
                --DirectSingleBoundary2DScanner.this.y;
                DirectSingleBoundary2DScanner.this.index -= DirectSingleBoundary2DScanner.this.dimX;
                DirectSingleBoundary2DScanner.this.jaDisp = (int)(DirectSingleBoundary2DScanner.this.jaOfs + DirectSingleBoundary2DScanner.this.index >>> 6);
                DirectSingleBoundary2DScanner.this.jaMask = 1L << (int)(DirectSingleBoundary2DScanner.this.jaOfs + DirectSingleBoundary2DScanner.this.index & 0x3FL);
            }
        }

        class Direct64MoverYP
        extends AbstractBoundary2DScanner.AbstractMoverYP {
            final int jaStep;

            Direct64MoverYP() {
                this.jaStep = (int)(DirectSingleBoundary2DScanner.this.dimX >>> 6);
            }

            @Override
            boolean straight() {
                --DirectSingleBoundary2DScanner.this.x;
                --DirectSingleBoundary2DScanner.this.index;
                if ((DirectSingleBoundary2DScanner.this.jaMask >>>= 1) == 0L) {
                    DirectSingleBoundary2DScanner.this.jaMask = Long.MIN_VALUE;
                    --DirectSingleBoundary2DScanner.this.jaDisp;
                }
                return (DirectSingleBoundary2DScanner.this.ja[DirectSingleBoundary2DScanner.this.jaDisp] & DirectSingleBoundary2DScanner.this.jaMask) != 0L;
            }

            @Override
            boolean rightAfterStraight() {
                ++DirectSingleBoundary2DScanner.this.y;
                DirectSingleBoundary2DScanner.this.jaDisp += this.jaStep;
                return DirectSingleBoundary2DScanner.this.y < DirectSingleBoundary2DScanner.this.dimY && (DirectSingleBoundary2DScanner.this.ja[DirectSingleBoundary2DScanner.this.jaDisp] & DirectSingleBoundary2DScanner.this.jaMask) != 0L;
            }

            @Override
            void straightBackLeft() {
                --DirectSingleBoundary2DScanner.this.y;
                DirectSingleBoundary2DScanner.this.jaDisp -= this.jaStep;
            }

            @Override
            boolean diag() {
                ++DirectSingleBoundary2DScanner.this.y;
                --DirectSingleBoundary2DScanner.this.x;
                DirectSingleBoundary2DScanner.this.jaDisp += this.jaStep;
                if ((DirectSingleBoundary2DScanner.this.jaMask >>>= 1) == 0L) {
                    DirectSingleBoundary2DScanner.this.jaMask = Long.MIN_VALUE;
                    --DirectSingleBoundary2DScanner.this.jaDisp;
                }
                return DirectSingleBoundary2DScanner.this.y < DirectSingleBoundary2DScanner.this.dimY && (DirectSingleBoundary2DScanner.this.ja[DirectSingleBoundary2DScanner.this.jaDisp] & DirectSingleBoundary2DScanner.this.jaMask) != 0L;
            }

            @Override
            boolean leftAfterDiag() {
                --DirectSingleBoundary2DScanner.this.y;
                DirectSingleBoundary2DScanner.this.jaDisp -= this.jaStep;
                return (DirectSingleBoundary2DScanner.this.ja[DirectSingleBoundary2DScanner.this.jaDisp] & DirectSingleBoundary2DScanner.this.jaMask) != 0L;
            }

            @Override
            void straightBack() {
                ++DirectSingleBoundary2DScanner.this.x;
                if ((DirectSingleBoundary2DScanner.this.jaMask <<= 1) == 0L) {
                    DirectSingleBoundary2DScanner.this.jaMask = 1L;
                    ++DirectSingleBoundary2DScanner.this.jaDisp;
                }
            }

            @Override
            void next8() {
                if (DirectSingleBoundary2DScanner.this.x != 0L) {
                    ++DirectSingleBoundary2DScanner.this.y;
                    --DirectSingleBoundary2DScanner.this.x;
                    DirectSingleBoundary2DScanner.this.jaDisp += this.jaStep;
                    if ((DirectSingleBoundary2DScanner.this.jaMask >>>= 1) == 0L) {
                        DirectSingleBoundary2DScanner.this.jaMask = Long.MIN_VALUE;
                        --DirectSingleBoundary2DScanner.this.jaDisp;
                    }
                    if (DirectSingleBoundary2DScanner.this.y < DirectSingleBoundary2DScanner.this.dimY && (DirectSingleBoundary2DScanner.this.ja[DirectSingleBoundary2DScanner.this.jaDisp] & DirectSingleBoundary2DScanner.this.jaMask) != 0L) {
                        DirectSingleBoundary2DScanner.this.lastShiftInfo = DirectSingleBoundary2DScanner.this.mover.diagonal;
                        DirectSingleBoundary2DScanner.this.mover = DirectSingleBoundary2DScanner.this.lastShiftInfo.newMover;
                        ++DirectSingleBoundary2DScanner.this.diagonalStepCount;
                        return;
                    }
                    --DirectSingleBoundary2DScanner.this.y;
                    DirectSingleBoundary2DScanner.this.jaDisp -= this.jaStep;
                    if ((DirectSingleBoundary2DScanner.this.ja[DirectSingleBoundary2DScanner.this.jaDisp] & DirectSingleBoundary2DScanner.this.jaMask) != 0L) {
                        DirectSingleBoundary2DScanner.this.lastShiftInfo = DirectSingleBoundary2DScanner.this.mover.straight;
                        return;
                    }
                    ++DirectSingleBoundary2DScanner.this.x;
                    if ((DirectSingleBoundary2DScanner.this.jaMask <<= 1) == 0L) {
                        DirectSingleBoundary2DScanner.this.jaMask = 1L;
                        ++DirectSingleBoundary2DScanner.this.jaDisp;
                    }
                }
                DirectSingleBoundary2DScanner.this.lastShiftInfo = DirectSingleBoundary2DScanner.this.mover.rotation;
                DirectSingleBoundary2DScanner.this.mover = DirectSingleBoundary2DScanner.this.lastShiftInfo.newMover;
                ++DirectSingleBoundary2DScanner.this.rotationStepCount;
            }
        }

        class DirectMoverYP
        extends AbstractBoundary2DScanner.AbstractMoverYP {
            DirectMoverYP() {
            }

            @Override
            boolean straight() {
                --DirectSingleBoundary2DScanner.this.x;
                --DirectSingleBoundary2DScanner.this.index;
                if ((DirectSingleBoundary2DScanner.this.jaMask >>>= 1) == 0L) {
                    DirectSingleBoundary2DScanner.this.jaMask = Long.MIN_VALUE;
                    --DirectSingleBoundary2DScanner.this.jaDisp;
                }
                return (DirectSingleBoundary2DScanner.this.ja[DirectSingleBoundary2DScanner.this.jaDisp] & DirectSingleBoundary2DScanner.this.jaMask) != 0L;
            }

            @Override
            boolean rightAfterStraight() {
                ++DirectSingleBoundary2DScanner.this.y;
                DirectSingleBoundary2DScanner.this.index += DirectSingleBoundary2DScanner.this.dimX;
                DirectSingleBoundary2DScanner.this.jaDisp = (int)(DirectSingleBoundary2DScanner.this.jaOfs + DirectSingleBoundary2DScanner.this.index >>> 6);
                DirectSingleBoundary2DScanner.this.jaMask = 1L << (int)(DirectSingleBoundary2DScanner.this.jaOfs + DirectSingleBoundary2DScanner.this.index & 0x3FL);
                return DirectSingleBoundary2DScanner.this.y < DirectSingleBoundary2DScanner.this.dimY && (DirectSingleBoundary2DScanner.this.ja[DirectSingleBoundary2DScanner.this.jaDisp] & DirectSingleBoundary2DScanner.this.jaMask) != 0L;
            }

            @Override
            void straightBackLeft() {
                --DirectSingleBoundary2DScanner.this.y;
                DirectSingleBoundary2DScanner.this.index -= DirectSingleBoundary2DScanner.this.dimX;
                DirectSingleBoundary2DScanner.this.jaDisp = (int)(DirectSingleBoundary2DScanner.this.jaOfs + DirectSingleBoundary2DScanner.this.index >>> 6);
                DirectSingleBoundary2DScanner.this.jaMask = 1L << (int)(DirectSingleBoundary2DScanner.this.jaOfs + DirectSingleBoundary2DScanner.this.index & 0x3FL);
            }

            @Override
            boolean diag() {
                ++DirectSingleBoundary2DScanner.this.y;
                --DirectSingleBoundary2DScanner.this.x;
                DirectSingleBoundary2DScanner.this.index += this.maxX;
                DirectSingleBoundary2DScanner.this.jaDisp = (int)(DirectSingleBoundary2DScanner.this.jaOfs + DirectSingleBoundary2DScanner.this.index >>> 6);
                DirectSingleBoundary2DScanner.this.jaMask = 1L << (int)(DirectSingleBoundary2DScanner.this.jaOfs + DirectSingleBoundary2DScanner.this.index & 0x3FL);
                return DirectSingleBoundary2DScanner.this.y < DirectSingleBoundary2DScanner.this.dimY && (DirectSingleBoundary2DScanner.this.ja[DirectSingleBoundary2DScanner.this.jaDisp] & DirectSingleBoundary2DScanner.this.jaMask) != 0L;
            }

            @Override
            boolean leftAfterDiag() {
                --DirectSingleBoundary2DScanner.this.y;
                DirectSingleBoundary2DScanner.this.index -= DirectSingleBoundary2DScanner.this.dimX;
                DirectSingleBoundary2DScanner.this.jaDisp = (int)(DirectSingleBoundary2DScanner.this.jaOfs + DirectSingleBoundary2DScanner.this.index >>> 6);
                DirectSingleBoundary2DScanner.this.jaMask = 1L << (int)(DirectSingleBoundary2DScanner.this.jaOfs + DirectSingleBoundary2DScanner.this.index & 0x3FL);
                return (DirectSingleBoundary2DScanner.this.ja[DirectSingleBoundary2DScanner.this.jaDisp] & DirectSingleBoundary2DScanner.this.jaMask) != 0L;
            }

            @Override
            void straightBack() {
                ++DirectSingleBoundary2DScanner.this.x;
                ++DirectSingleBoundary2DScanner.this.index;
                if ((DirectSingleBoundary2DScanner.this.jaMask <<= 1) == 0L) {
                    DirectSingleBoundary2DScanner.this.jaMask = 1L;
                    ++DirectSingleBoundary2DScanner.this.jaDisp;
                }
            }
        }
    }

    static abstract class SingleBoundary2DScanner
    extends AbstractBoundary2DScanner {
        private long index = 0L;
        private long startIndex = 0L;

        SingleBoundary2DScanner(Matrix<? extends BitArray> matrix) {
            super(matrix);
        }

        @Override
        public boolean isSingleBoundaryScanner() {
            return true;
        }

        @Override
        public boolean isAllBoundariesScanner() {
            return false;
        }

        @Override
        public boolean isMainBoundariesScanner() {
            return false;
        }

        @Override
        public long currentIndexInArray() {
            return this.index;
        }

        @Override
        public void goTo(long x, long y, Side side) {
            super.goTo(x, y, side);
            this.index = this.startIndex = y * this.dimX + x;
        }

        @Override
        public boolean get() {
            return this.array.getInt(this.index) != 0;
        }

        @Override
        public boolean boundaryFinished() {
            return this.index == this.startIndex && this.mover == this.startMover;
        }

        @Override
        final AbstractBoundary2DScanner.AbstractAccessor getAccessor(Matrix<? extends PFixedArray> matrix) {
            return new Accessor(matrix);
        }

        @Override
        final AbstractBoundary2DScanner.AbstractMover getMoverXM() {
            return new MoverXM();
        }

        @Override
        final AbstractBoundary2DScanner.AbstractMover getMoverYM() {
            return new MoverYM();
        }

        @Override
        final AbstractBoundary2DScanner.AbstractMover getMoverXP() {
            return new MoverXP();
        }

        @Override
        final AbstractBoundary2DScanner.AbstractMover getMoverYP() {
            return new MoverYP();
        }

        class Accessor
        extends AbstractBoundary2DScanner.AbstractAccessor {
            Accessor(Matrix<? extends PFixedArray> matrix) {
                super(matrix.array());
            }

            @Override
            boolean get() {
                return this.array.getLong(SingleBoundary2DScanner.this.index) != 0L;
            }

            @Override
            void set() {
                this.updatableArray.setLong(SingleBoundary2DScanner.this.index, 1L);
            }

            @Override
            boolean getNext() {
                return this.array.getLong(SingleBoundary2DScanner.this.index + 1L) != 0L;
            }

            @Override
            void setNext() {
                this.updatableArray.setLong(SingleBoundary2DScanner.this.index + 1L, 1L);
            }
        }

        class MoverXM
        extends AbstractBoundary2DScanner.AbstractMoverXM {
            MoverXM() {
            }

            @Override
            boolean straight() {
                --SingleBoundary2DScanner.this.y;
                SingleBoundary2DScanner.this.index -= SingleBoundary2DScanner.this.dimX;
                return this.array.getBit(SingleBoundary2DScanner.this.index);
            }

            @Override
            boolean rightAfterStraight() {
                --SingleBoundary2DScanner.this.x;
                --SingleBoundary2DScanner.this.index;
                return SingleBoundary2DScanner.this.x >= 0L && this.array.getBit(SingleBoundary2DScanner.this.index);
            }

            @Override
            void straightBackLeft() {
                ++SingleBoundary2DScanner.this.x;
                ++SingleBoundary2DScanner.this.index;
            }

            @Override
            boolean diag() {
                --SingleBoundary2DScanner.this.y;
                --SingleBoundary2DScanner.this.x;
                SingleBoundary2DScanner.this.index -= SingleBoundary2DScanner.this.dimX + 1L;
                return SingleBoundary2DScanner.this.x >= 0L && this.array.getBit(SingleBoundary2DScanner.this.index);
            }

            @Override
            boolean leftAfterDiag() {
                ++SingleBoundary2DScanner.this.x;
                ++SingleBoundary2DScanner.this.index;
                return this.array.getBit(SingleBoundary2DScanner.this.index);
            }

            @Override
            void straightBack() {
                ++SingleBoundary2DScanner.this.y;
                SingleBoundary2DScanner.this.index += SingleBoundary2DScanner.this.dimX;
            }
        }

        class MoverYM
        extends AbstractBoundary2DScanner.AbstractMoverYM {
            MoverYM() {
            }

            @Override
            boolean straight() {
                ++SingleBoundary2DScanner.this.x;
                ++SingleBoundary2DScanner.this.index;
                return this.array.getBit(SingleBoundary2DScanner.this.index);
            }

            @Override
            boolean rightAfterStraight() {
                --SingleBoundary2DScanner.this.y;
                SingleBoundary2DScanner.this.index -= SingleBoundary2DScanner.this.dimX;
                return SingleBoundary2DScanner.this.y >= 0L && this.array.getBit(SingleBoundary2DScanner.this.index);
            }

            @Override
            void straightBackLeft() {
                ++SingleBoundary2DScanner.this.y;
                SingleBoundary2DScanner.this.index += SingleBoundary2DScanner.this.dimX;
            }

            @Override
            boolean diag() {
                --SingleBoundary2DScanner.this.y;
                ++SingleBoundary2DScanner.this.x;
                SingleBoundary2DScanner.this.index -= this.maxX;
                return SingleBoundary2DScanner.this.y >= 0L && this.array.getBit(SingleBoundary2DScanner.this.index);
            }

            @Override
            boolean leftAfterDiag() {
                ++SingleBoundary2DScanner.this.y;
                SingleBoundary2DScanner.this.index += SingleBoundary2DScanner.this.dimX;
                return this.array.getBit(SingleBoundary2DScanner.this.index);
            }

            @Override
            void straightBack() {
                --SingleBoundary2DScanner.this.x;
                --SingleBoundary2DScanner.this.index;
            }
        }

        class MoverXP
        extends AbstractBoundary2DScanner.AbstractMoverXP {
            MoverXP() {
            }

            @Override
            boolean straight() {
                ++SingleBoundary2DScanner.this.y;
                SingleBoundary2DScanner.this.index += SingleBoundary2DScanner.this.dimX;
                return this.array.getBit(SingleBoundary2DScanner.this.index);
            }

            @Override
            boolean rightAfterStraight() {
                ++SingleBoundary2DScanner.this.x;
                ++SingleBoundary2DScanner.this.index;
                return SingleBoundary2DScanner.this.x < SingleBoundary2DScanner.this.dimX && this.array.getBit(SingleBoundary2DScanner.this.index);
            }

            @Override
            void straightBackLeft() {
                --SingleBoundary2DScanner.this.x;
                --SingleBoundary2DScanner.this.index;
            }

            @Override
            boolean diag() {
                ++SingleBoundary2DScanner.this.y;
                ++SingleBoundary2DScanner.this.x;
                SingleBoundary2DScanner.this.index += SingleBoundary2DScanner.this.dimX + 1L;
                return SingleBoundary2DScanner.this.x < SingleBoundary2DScanner.this.dimX && this.array.getBit(SingleBoundary2DScanner.this.index);
            }

            @Override
            boolean leftAfterDiag() {
                --SingleBoundary2DScanner.this.x;
                --SingleBoundary2DScanner.this.index;
                return this.array.getBit(SingleBoundary2DScanner.this.index);
            }

            @Override
            void straightBack() {
                --SingleBoundary2DScanner.this.y;
                SingleBoundary2DScanner.this.index -= SingleBoundary2DScanner.this.dimX;
            }
        }

        class MoverYP
        extends AbstractBoundary2DScanner.AbstractMoverYP {
            MoverYP() {
            }

            @Override
            boolean straight() {
                --SingleBoundary2DScanner.this.x;
                --SingleBoundary2DScanner.this.index;
                return this.array.getBit(SingleBoundary2DScanner.this.index);
            }

            @Override
            boolean rightAfterStraight() {
                ++SingleBoundary2DScanner.this.y;
                SingleBoundary2DScanner.this.index += SingleBoundary2DScanner.this.dimX;
                return SingleBoundary2DScanner.this.y < SingleBoundary2DScanner.this.dimY && this.array.getBit(SingleBoundary2DScanner.this.index);
            }

            @Override
            void straightBackLeft() {
                --SingleBoundary2DScanner.this.y;
                SingleBoundary2DScanner.this.index -= SingleBoundary2DScanner.this.dimX;
            }

            @Override
            boolean diag() {
                ++SingleBoundary2DScanner.this.y;
                --SingleBoundary2DScanner.this.x;
                SingleBoundary2DScanner.this.index += this.maxX;
                return SingleBoundary2DScanner.this.y < SingleBoundary2DScanner.this.dimY && this.array.getBit(SingleBoundary2DScanner.this.index);
            }

            @Override
            boolean leftAfterDiag() {
                --SingleBoundary2DScanner.this.y;
                SingleBoundary2DScanner.this.index -= SingleBoundary2DScanner.this.dimX;
                return this.array.getBit(SingleBoundary2DScanner.this.index);
            }

            @Override
            void straightBack() {
                ++SingleBoundary2DScanner.this.x;
                ++SingleBoundary2DScanner.this.index;
            }
        }
    }
}

