/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.scanning;

import net.algart.arrays.JArrays;

public enum ConnectivityType {
    STRAIGHT_ONLY{

        @Override
        byte[][] apertureShifts(int dimCount) {
            assert (dimCount < STRAIGHT_SHIFTS.length);
            return STRAIGHT_SHIFTS[dimCount];
        }
    }
    ,
    STRAIGHT_AND_DIAGONAL{

        @Override
        byte[][] apertureShifts(int dimCount) {
            assert (dimCount < STRAIGHT_AND_DIAGONAL_SHIFTS.length);
            return STRAIGHT_AND_DIAGONAL_SHIFTS[dimCount];
        }
    };

    private static final byte[][][] STRAIGHT_SHIFTS;
    private static final byte[][][] STRAIGHT_AND_DIAGONAL_SHIFTS;

    public int numberOfNeighbours(int dimCount) {
        if (dimCount <= 0 || dimCount > 9) {
            throw new IllegalArgumentException("dimCount = " + dimCount + " is not in range 1..9");
        }
        return this.apertureShifts(dimCount).length;
    }

    abstract byte[][] apertureShifts(int var1);

    private static byte[][] generateStraightShifts(int dimCount) {
        byte[][] shifts = new byte[2 * dimCount][dimCount];
        int i = 0;
        for (int k = 0; k < dimCount; ++k) {
            shifts[i++][k] = 1;
            shifts[i++][k] = -1;
        }
        return shifts;
    }

    private static byte[][] generateStraightAndDiagonalShifts(int dimCount) {
        int totalCount = 1;
        for (int k = 0; k < dimCount; ++k) {
            totalCount *= 3;
        }
        byte[][] shifts = new byte[totalCount - 1][dimCount];
        byte[] coordinates = new byte[dimCount];
        JArrays.fill(coordinates, (byte)-1);
        int index = 0;
        int shiftsIndex = 0;
        while (true) {
            int j;
            boolean origin = true;
            for (j = 0; j < dimCount; ++j) {
                if (coordinates[j] == 0) continue;
                origin = false;
                break;
            }
            if (!origin) {
                System.arraycopy(coordinates, 0, shifts[shiftsIndex], 0, dimCount);
                ++shiftsIndex;
            }
            if (++index >= totalCount) break;
            j = dimCount - 1;
            while (coordinates[j] == 1) {
                coordinates[j] = -1;
                --j;
            }
            int n = j;
            coordinates[n] = (byte)(coordinates[n] + 1);
        }
        return shifts;
    }

    static {
        STRAIGHT_SHIFTS = new byte[10][][];
        STRAIGHT_AND_DIAGONAL_SHIFTS = new byte[10][][];
        for (int dimCount = 1; dimCount <= 9; ++dimCount) {
            ConnectivityType.STRAIGHT_SHIFTS[dimCount] = ConnectivityType.generateStraightShifts(dimCount);
            ConnectivityType.STRAIGHT_AND_DIAGONAL_SHIFTS[dimCount] = ConnectivityType.generateStraightAndDiagonalShifts(dimCount);
        }
    }
}

