/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.scanning;

import net.algart.matrices.scanning.Boundary2DScanner;

public enum ContourLineType {
    STRICT_BOUNDARY(0){

        @Override
        public double x(Boundary2DScanner scanner) {
            return (double)scanner.x() + scanner.lastStep().pixelVertexX;
        }

        @Override
        public double y(Boundary2DScanner scanner) {
            return (double)scanner.y() + scanner.lastStep().pixelVertexY;
        }
    }
    ,
    PIXEL_CENTERS_POLYLINE(1){

        @Override
        public double x(Boundary2DScanner scanner) {
            return scanner.x();
        }

        @Override
        public double y(Boundary2DScanner scanner) {
            return scanner.y();
        }
    }
    ,
    SEGMENT_CENTERS_POLYLINE(2){

        @Override
        public double x(Boundary2DScanner scanner) {
            return (double)scanner.x() + scanner.side().centerX;
        }

        @Override
        public double y(Boundary2DScanner scanner) {
            return (double)scanner.y() + scanner.side().centerY;
        }
    };

    static final int STRICT_BOUNDARY_CODE = 0;
    static final int PIXEL_CENTERS_POLYLINE_CODE = 1;
    static final int SEGMENT_CENTERS_POLYLINE_CODE = 2;
    final int code;

    private ContourLineType(int code) {
        this.code = code;
    }

    public abstract double x(Boundary2DScanner var1);

    public abstract double y(Boundary2DScanner var1);
}

