/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.skeletons;

import net.algart.arrays.ArrayContext;
import net.algart.arrays.BitArray;
import net.algart.arrays.Matrix;
import net.algart.arrays.UpdatableBitArray;
import net.algart.matrices.skeletons.AbstractThinningSkeleton2D;
import net.algart.matrices.skeletons.ThinningSkeleton;
import net.algart.matrices.skeletons.ThinningTools;

public class StrongQuadruple3x5ThinningSkeleton2D
extends AbstractThinningSkeleton2D
implements ThinningSkeleton {
    static final boolean TOP_3X5_WEAKENING = false;
    static final boolean BOTTOM_3X5_WEAKENING = true;
    private static final int[][] SKELETON_XP = new int[][]{{1, 0}, {-1, 0}, {1, 1}, {0, 1}, {-1, 1, 0, 2}, {1, -1}, {0, -1}, {-1, -1, 0, -2}, {0, 1, 0, -1, -1, 1, -1, -1}, {1, 2, 1, 0, 1, -2, 0, 1, 0, -1, -1, 1, -1, 0, -1, -1}, {0, 2}, {0, -2}, {-1, 2}, {-1, -2}, {0, 2, 1, 1, -1, 1, 1, 0, -1, 0, 1, -1, -1, -1, 0, -2}};
    private static final int[][] SKELETON_YP = ThinningTools.rotate90(SKELETON_XP);
    private static final int[][] SKELETON_XM = ThinningTools.rotate180(SKELETON_XP);
    private static final int[][] SKELETON_YM = ThinningTools.rotate270(SKELETON_XP);
    private static final int[][][] SKELETON_3x5 = new int[][][]{SKELETON_XP, SKELETON_YP, SKELETON_XM, SKELETON_YM};

    private StrongQuadruple3x5ThinningSkeleton2D(ArrayContext context, Matrix<? extends UpdatableBitArray> matrix) {
        super(context, matrix, true, false);
    }

    public static StrongQuadruple3x5ThinningSkeleton2D getInstance(ArrayContext context, Matrix<? extends UpdatableBitArray> matrix) {
        return new StrongQuadruple3x5ThinningSkeleton2D(context, matrix);
    }

    @Override
    public long estimatedNumberOfIterations() {
        return ThinningTools.estimatedNumberOfIterations(this.result, false);
    }

    @Override
    public Matrix<BitArray> asThinning(int directionIndex) {
        if (directionIndex < 0 || directionIndex > 7) {
            throw new IllegalArgumentException("Illegal directionIndex = " + directionIndex + " (must be 0..7)");
        }
        if (directionIndex % 2 == 0) {
            return StrongQuadruple3x5ThinningSkeleton2D.asStrongQuadrupleThinning(this.result, directionIndex / 2);
        }
        return this.result.cast(BitArray.class);
    }

    public String toString() {
        return "strong quadruple thinning 2D skeletonizer with 3x5 aperture";
    }

    private static Matrix<BitArray> asStrongQuadrupleThinning(Matrix<? extends BitArray> matrix, int directionIndex) {
        int[][] points = SKELETON_3x5[directionIndex];
        Matrix<BitArray> internal = ThinningTools.shift(matrix, points[0]);
        Matrix<BitArray> internalOrThin = ThinningTools.or(internal, ThinningTools.not(ThinningTools.shift(matrix, points[1])));
        Matrix<BitArray> topArticulation = ThinningTools.andNot(ThinningTools.shift(matrix, points[2]), ThinningTools.shift(matrix, points[3]));
        Matrix<BitArray> bottomArticulation = ThinningTools.andNot(ThinningTools.shift(matrix, points[5]), ThinningTools.or(ThinningTools.shift(matrix, points[6]), ThinningTools.and(ThinningTools.shifts(matrix, points[7]))));
        Matrix<BitArray> dilation4Points = ThinningTools.or(ThinningTools.shifts(matrix, points[8]));
        Matrix<BitArray> notRemoved = ThinningTools.or(internalOrThin, topArticulation, bottomArticulation, ThinningTools.not(dilation4Points));
        Matrix<BitArray> erosion8Points1 = ThinningTools.and(ThinningTools.shifts(matrix, points[9]));
        Matrix<BitArray> notRemovedStrongly1 = ThinningTools.or(ThinningTools.shift(matrix, points[2]), ThinningTools.shift(matrix, points[5]), ThinningTools.shift(matrix, points[10]), ThinningTools.shift(matrix, points[11]), ThinningTools.not(erosion8Points1));
        return ThinningTools.and(matrix, notRemoved, notRemovedStrongly1);
    }
}

