/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.spectra;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import net.algart.arrays.Array;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.Arrays;
import net.algart.arrays.DirectAccessible;
import net.algart.arrays.JArrays;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.SizeMismatchException;
import net.algart.arrays.UpdatablePNumberArray;
import net.algart.matrices.spectra.ComplexScalarSampleArray;
import net.algart.matrices.spectra.ComplexVectorSampleArray;
import net.algart.matrices.spectra.RealScalarSampleArray;
import net.algart.matrices.spectra.RealVectorSampleArray;
import net.algart.matrices.spectra.SampleArray;
import net.algart.matrices.spectra.SpectralTransform;

public abstract class AbstractSpectralTransform
implements SpectralTransform {
    private static final boolean BUFFERING_LARGE_MATRICES = true;
    public static final long MIN_SPECTRAL_JAVA_MEMORY = 0x400000L;
    private final long maxTempJavaMemory;

    protected AbstractSpectralTransform() {
        this(Arrays.SystemSettings.maxTempJavaMemory());
    }

    protected AbstractSpectralTransform(long maxTempJavaMemory) {
        this.maxTempJavaMemory = maxTempJavaMemory;
    }

    @Override
    public abstract boolean isLengthAllowed(long var1);

    @Override
    public abstract boolean areComplexSamplesRequired();

    @Override
    public final void directTransform(ArrayContext context, SampleArray samples) {
        this.checkSamples(samples);
        this.transform(context, samples, false);
    }

    @Override
    public final void inverseTransform(ArrayContext context, SampleArray samples) {
        this.checkSamples(samples);
        this.transform(context, samples, true);
    }

    @Override
    public final void directTransformMatrix(ArrayContext context, Matrix<? extends UpdatablePNumberArray> matrixRe, Matrix<? extends UpdatablePNumberArray> matrixIm) {
        this.checkMatrices(matrixRe, matrixIm);
        this.transformMatrix(context, matrixRe, matrixIm, false);
    }

    @Override
    public final void inverseTransformMatrix(ArrayContext context, Matrix<? extends UpdatablePNumberArray> matrixRe, Matrix<? extends UpdatablePNumberArray> matrixIm) {
        this.checkMatrices(matrixRe, matrixIm);
        this.transformMatrix(context, matrixRe, matrixIm, true);
    }

    protected abstract String unallowedLengthMessage();

    protected abstract void transform(ArrayContext var1, SampleArray var2, boolean var3);

    protected void transformMatrix(ArrayContext context, Matrix<? extends UpdatablePNumberArray> matrixRe, Matrix<? extends UpdatablePNumberArray> matrixIm, boolean inverse) {
        int numberOfTasks = Math.max(1, Arrays.getThreadPoolFactory(context).recommendedNumberOfTasks());
        this.transformMatrixRecursively(context, matrixRe, matrixIm, inverse, numberOfTasks);
    }

    protected long maxTempJavaMemory() {
        return Math.max(this.maxTempJavaMemory, 0x400000L);
    }

    private void checkSamples(SampleArray samples) {
        if (this.areComplexSamplesRequired() && !samples.isComplex()) {
            throw new UnsupportedOperationException("Fast Fourier transformation requires complex samples");
        }
        if (!this.isLengthAllowed(samples.length())) {
            throw new IllegalArgumentException("The length of sample array " + samples.length() + " is not allowed: " + this.unallowedLengthMessage());
        }
    }

    private void checkMatrices(Matrix<? extends UpdatablePNumberArray> matrixRe, Matrix<? extends UpdatablePNumberArray> matrixIm) {
        Objects.requireNonNull(matrixRe, "Null matrixRe argument");
        if (this.areComplexSamplesRequired() && matrixIm == null) {
            throw new UnsupportedOperationException("Null matrixRe argument, but Fast Fourier transformation requires complex samples");
        }
        if (matrixIm != null && !matrixRe.dimEquals(matrixIm)) {
            throw new SizeMismatchException("matrixRe and matrixIm dimensions mismatch: matrixRe is " + String.valueOf(matrixRe) + ", matrixIm " + String.valueOf(matrixIm));
        }
        long[] dimensions = matrixRe.dimensions();
        for (int k = 0; k < dimensions.length; ++k) {
            if (this.isLengthAllowed(dimensions[k])) continue;
            throw new IllegalArgumentException("The matrix dimension #" + k + " = " + dimensions[k] + " is not allowed: " + this.unallowedLengthMessage());
        }
    }

    private void transformMatrixRecursively(ArrayContext context, Matrix<? extends UpdatablePNumberArray> matrixRe, Matrix<? extends UpdatablePNumberArray> matrixIm, boolean inverse, int numberOfTasks) {
        boolean doClone;
        UpdatablePNumberArray arrayIm;
        long[] dim = matrixRe.dimensions();
        UpdatablePNumberArray arrayRe = matrixRe.array();
        UpdatablePNumberArray updatablePNumberArray = arrayIm = matrixIm == null ? null : matrixIm.array();
        boolean bl = !AbstractSpectralTransform.areDirect(arrayRe, arrayIm) && Arrays.sizeOf(arrayRe) <= this.maxTempJavaMemory() - (matrixIm == null ? 0L : Arrays.sizeOf(arrayIm)) ? true : (doClone = false);
        if (doClone) {
            UpdatablePNumberArray a = (UpdatablePNumberArray)Arrays.SMM.newUnresizableArray(arrayRe);
            Arrays.copy(context == null ? null : context.part(0.0, matrixIm == null ? 0.1 : 0.05), a, arrayRe);
            arrayRe = a;
            if (matrixIm != null) {
                a = (UpdatablePNumberArray)Arrays.SMM.newUnresizableArray(arrayIm);
                Arrays.copy(context == null ? null : context.part(0.05, 0.1), a, arrayIm);
                arrayIm = a;
            }
        }
        this.transformMatrixBaseAlgorithm(context == null || !doClone ? context : context.part(0.1, 0.9), arrayRe, arrayIm, dim, inverse, numberOfTasks);
        if (doClone) {
            Arrays.copy(context == null ? null : context.part(0.9, arrayIm == null ? 1.0 : 0.95), matrixRe.array(), arrayRe);
            if (matrixIm != null) {
                Arrays.copy(context == null ? null : context.part(0.95, 1.0), matrixIm.array(), arrayIm);
            }
        }
    }

    private void transformMatrixBaseAlgorithm(ArrayContext context, UpdatablePNumberArray arrayRe, UpdatablePNumberArray arrayIm, long[] dim, boolean inverse, int numberOfTasks) {
        if (dim.length == 1) {
            SampleArray samples = arrayIm == null ? RealScalarSampleArray.asSampleArray(arrayRe) : ComplexScalarSampleArray.asSampleArray(arrayRe, arrayIm);
            this.transform(context, samples, inverse);
        } else {
            this.transformHorizontalRecursively(context == null ? null : context.part(0, dim.length - 1, dim.length), arrayRe, arrayIm, dim, inverse, numberOfTasks);
            this.transformVertical(context == null ? null : context.part(dim.length - 1, dim.length, dim.length), arrayRe, arrayIm, dim, inverse, numberOfTasks);
        }
    }

    private void transformHorizontalRecursively(ArrayContext context, UpdatablePNumberArray arrayRe, UpdatablePNumberArray arrayIm, long[] dimensions, boolean inverse, int numberOfTasks) {
        assert (dimensions.length >= 2);
        long[] layerDims = JArrays.copyOfRange(dimensions, 0, dimensions.length - 1);
        long layerLen = Arrays.longMul(layerDims);
        long lastDim = dimensions[dimensions.length - 1];
        double elementSize = (double)(arrayRe.bitsPerElement() + (arrayIm == null ? 0L : arrayIm.bitsPerElement())) / 8.0;
        long bufLen = (long)((double)Math.max(this.maxTempJavaMemory(), 0L) / elementSize);
        boolean direct = AbstractSpectralTransform.areDirect(arrayRe, arrayIm);
        if (layerLen <= bufLen / 2L && !direct) {
            this.transformHorizontalRecursivelyWithSplitting(context, arrayRe, arrayIm, dimensions, layerLen, bufLen, inverse, numberOfTasks);
        } else {
            this.transformHorizontalRecursivelyBaseAlgorithm(context, arrayRe, arrayIm, layerDims, lastDim, layerLen, inverse, direct ? numberOfTasks : 1);
        }
    }

    private void transformHorizontalRecursivelyBaseAlgorithm(ArrayContext context, UpdatablePNumberArray arrayRe, UpdatablePNumberArray arrayIm, long[] layerDims, long lastDim, long layerLen, boolean inverse, int numberOfTasks) {
        if ((numberOfTasks = (int)Math.min((long)numberOfTasks, lastDim)) <= 1) {
            long k = 0L;
            long disp = 0L;
            while (k < lastDim) {
                this.transformMatrixRecursively(null, Matrices.matrix((UpdatablePNumberArray)arrayRe.subArr(disp, layerLen), layerDims), arrayIm == null ? null : Matrices.matrix((UpdatablePNumberArray)arrayIm.subArr(disp, layerLen), layerDims), inverse, 1);
                if (context != null) {
                    context.checkInterruptionAndUpdateProgress(null, k + 1L, lastDim);
                }
                ++k;
                disp += layerLen;
            }
        } else {
            Runnable[] tasks = new Runnable[numberOfTasks];
            AtomicLong readyLayers = new AtomicLong(0L);
            int threadIndex = 0;
            while (threadIndex < tasks.length) {
                int ti = threadIndex++;
                tasks[ti] = () -> {
                    long layerStep = (long)tasks.length * layerLen;
                    long k = ti;
                    long disp = (long)ti * layerLen;
                    while (k < lastDim) {
                        this.transformMatrixRecursively(null, Matrices.matrix((UpdatablePNumberArray)arrayRe.subArr(disp, layerLen), layerDims), arrayIm == null ? null : Matrices.matrix((UpdatablePNumberArray)arrayIm.subArr(disp, layerLen), layerDims), inverse, 1);
                        if (context != null) {
                            context.checkInterruptionAndUpdateProgress(null, readyLayers.incrementAndGet(), lastDim);
                        }
                        k += (long)tasks.length;
                        disp += layerStep;
                    }
                };
            }
            Arrays.getThreadPoolFactory(context).performTasks(tasks);
        }
    }

    private void transformHorizontalRecursivelyWithSplitting(ArrayContext context, UpdatablePNumberArray arrayRe, UpdatablePNumberArray arrayIm, long[] dimensions, long layerLen, long bufLen, boolean inverse, int numberOfTasks) {
        assert (layerLen <= bufLen / 2L);
        long lastDim = dimensions[dimensions.length - 1];
        long layersPerBuf = bufLen / layerLen;
        assert (layersPerBuf > 1L);
        long batchLength = layersPerBuf * layerLen;
        UpdatablePNumberArray bufRe = (UpdatablePNumberArray)Arrays.SMM.newUnresizableArray(arrayRe.elementType(), batchLength);
        UpdatablePNumberArray bufIm = arrayIm == null ? null : (UpdatablePNumberArray)Arrays.SMM.newUnresizableArray(arrayIm.elementType(), batchLength);
        long[] subDim = (long[])dimensions.clone();
        long k = 0L;
        long disp = 0L;
        while (k < lastDim) {
            long lpb;
            subDim[subDim.length - 1] = lpb = Math.min(layersPerBuf, lastDim - k);
            long bl = lpb * layerLen;
            UpdatablePNumberArray subArrayRe = (UpdatablePNumberArray)arrayRe.subArr(disp, bl);
            UpdatablePNumberArray subArrayIm = arrayIm == null ? null : (UpdatablePNumberArray)arrayIm.subArr(disp, bl);
            bufRe.copy(subArrayRe);
            if (arrayIm != null) {
                bufIm.copy(subArrayIm);
            }
            this.transformHorizontalRecursively(context == null ? null : context.part(k, k + lpb, lastDim), bufRe, bufIm, subDim, inverse, numberOfTasks);
            subArrayRe.copy(bufRe);
            if (arrayIm != null) {
                subArrayIm.copy(bufIm);
            }
            k += layersPerBuf;
            disp += batchLength;
        }
    }

    private void transformVertical(ArrayContext context, UpdatablePNumberArray arrayRe, UpdatablePNumberArray arrayIm, long[] dimensions, boolean inverse, int numberOfTasks) {
        assert (dimensions.length >= 2);
        long[] layerDims = JArrays.copyOfRange(dimensions, 0, dimensions.length - 1);
        long layerLen = Arrays.longMul(layerDims);
        long lastDim = dimensions[dimensions.length - 1];
        double elementSize = (double)(arrayRe.bitsPerElement() + (arrayIm == null ? 0L : arrayIm.bitsPerElement())) / 8.0;
        long bufLen = (long)((double)Math.max(this.maxTempJavaMemory(), 0L) / elementSize);
        long columnLength = lastDim;
        for (int k = 0; k < dimensions.length - 2; ++k) {
            columnLength *= dimensions[k];
        }
        boolean direct = AbstractSpectralTransform.areDirect(arrayRe, arrayIm);
        if (columnLength <= bufLen / 2L && !direct) {
            this.transformVerticalWithSplitting(context, arrayRe, arrayIm, dimensions, columnLength, bufLen, inverse, numberOfTasks);
        } else {
            this.transformVerticalBaseAlgorithm(context, arrayRe, arrayIm, lastDim, layerLen, inverse, direct ? numberOfTasks : 1);
        }
    }

    private void transformVerticalBaseAlgorithm(ArrayContext context, UpdatablePNumberArray arrayRe, UpdatablePNumberArray arrayIm, long lastDim, long layerLen, boolean inverse, int numberOfTasks) {
        MemoryModel mm;
        numberOfTasks = (int)Math.min((long)numberOfTasks, layerLen);
        MemoryModel memoryModel = mm = context == null ? null : context.getMemoryModel();
        if (numberOfTasks <= 1) {
            SampleArray samples = arrayIm == null ? RealVectorSampleArray.asSampleArray(mm, arrayRe, layerLen, layerLen, lastDim) : ComplexVectorSampleArray.asSampleArray(mm, arrayRe, arrayIm, layerLen, layerLen, lastDim);
            this.transform(context, samples, inverse);
        } else {
            assert (AbstractSpectralTransform.areDirect(arrayRe, arrayIm));
            Runnable[] tasks = new Runnable[numberOfTasks];
            double layerStep = (double)layerLen / (double)numberOfTasks;
            long layerDelimiter = 0L;
            for (int threadIndex = 0; threadIndex < tasks.length; ++threadIndex) {
                long layerFrom = layerDelimiter;
                long layerTo = layerDelimiter = threadIndex == tasks.length - 1 ? layerLen : (long)((double)(threadIndex + 1) * layerStep);
                ArrayContext contextNoProgress = context == null ? null : context.noProgressVersion();
                RealVectorSampleArray samples = arrayIm == null ? RealVectorSampleArray.asSampleArray(mm, (UpdatablePNumberArray)arrayRe.subArray(layerFrom, arrayRe.length()), layerTo - layerFrom, layerLen, lastDim) : ComplexVectorSampleArray.asSampleArray(mm, (UpdatablePNumberArray)arrayRe.subArray(layerFrom, arrayRe.length()), (UpdatablePNumberArray)arrayIm.subArray(layerFrom, arrayIm.length()), layerTo - layerFrom, layerLen, lastDim);
                tasks[threadIndex] = () -> this.transform(contextNoProgress, samples, inverse);
            }
            Arrays.getThreadPoolFactory(context).performTasks(tasks);
            if (context != null) {
                context.checkInterruptionAndUpdateProgress(null, lastDim, lastDim);
            }
        }
    }

    private void transformVerticalWithSplitting(ArrayContext context, UpdatablePNumberArray arrayRe, UpdatablePNumberArray arrayIm, long[] dimensions, long columnLength, long bufLen, boolean inverse, int numberOfTasks) {
        assert (columnLength <= bufLen / 2L);
        long previousDim = dimensions[dimensions.length - 2];
        long columnsPerBuf = bufLen / columnLength;
        assert (columnsPerBuf > 1L);
        long batchLength = columnsPerBuf * columnLength;
        UpdatablePNumberArray bufRe = (UpdatablePNumberArray)Arrays.SMM.newUnresizableArray(arrayRe.elementType(), batchLength);
        UpdatablePNumberArray bufIm = arrayIm == null ? null : (UpdatablePNumberArray)Arrays.SMM.newUnresizableArray(arrayIm.elementType(), batchLength);
        Matrix<UpdatablePNumberArray> matrixRe = Matrices.matrix(arrayRe, dimensions);
        Matrix<UpdatablePNumberArray> matrixIm = arrayIm == null ? null : Matrices.matrix(arrayIm, dimensions);
        long[] subPos = new long[dimensions.length];
        long[] subDim = (long[])dimensions.clone();
        for (long k = 0L; k < previousDim; k += columnsPerBuf) {
            long cpb = Math.min(columnsPerBuf, previousDim - k);
            subPos[dimensions.length - 2] = k;
            subDim[dimensions.length - 2] = cpb;
            long bl = cpb * columnLength;
            Matrix<UpdatablePNumberArray> matrixBufRe = Matrices.matrix(bl == batchLength ? bufRe : (UpdatablePNumberArray)bufRe.subArr(0L, bl), subDim);
            Matrix<UpdatablePNumberArray> matrixBufIm = arrayIm == null ? null : Matrices.matrix(bl == batchLength ? bufIm : (UpdatablePNumberArray)bufIm.subArr(0L, bl), subDim);
            Matrix<UpdatablePNumberArray> subMatrixRe = matrixRe.subMatr(subPos, subDim);
            Matrix<UpdatablePNumberArray> subMatrixIm = arrayIm == null ? null : matrixIm.subMatr(subPos, subDim);
            matrixBufRe.array().copy(subMatrixRe.array());
            if (arrayIm != null) {
                matrixBufIm.array().copy(subMatrixIm.array());
            }
            this.transformVertical(context == null ? null : context.part(k, k + cpb, previousDim), bufRe, bufIm, subDim, inverse, numberOfTasks);
            subMatrixRe.array().copy(matrixBufRe.array());
            if (arrayIm == null) continue;
            subMatrixIm.array().copy(matrixBufIm.array());
        }
    }

    static boolean areDirect(Array arrayRe, Array arrayIm) {
        return arrayRe instanceof DirectAccessible && ((DirectAccessible)((Object)arrayRe)).hasJavaArray() && (arrayIm == null || arrayIm instanceof DirectAccessible && ((DirectAccessible)((Object)arrayIm)).hasJavaArray());
    }
}

