/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.spectra;

import java.util.Objects;
import net.algart.arrays.Arrays;
import net.algart.arrays.DirectAccessible;
import net.algart.arrays.DoubleArray;
import net.algart.arrays.FloatArray;
import net.algart.arrays.JArrayPool;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.TooLargeArrayException;
import net.algart.arrays.UpdatablePArray;
import net.algart.arrays.UpdatablePNumberArray;
import net.algart.math.functions.Func;
import net.algart.math.functions.LinearFunc;
import net.algart.matrices.spectra.SampleArray;

public abstract class ComplexVectorSampleArray
implements SampleArray {
    private static final int BUFFER_LENGTH = 32768;
    private static final int NUMBER_OF_BUFFERS = 4;
    private static final JArrayPool FLOAT_BUFFERS = JArrayPool.getInstance(Float.TYPE, 131072);
    private static final JArrayPool DOUBLE_BUFFERS = JArrayPool.getInstance(Double.TYPE, 131072);
    final long vectorLength;
    final long vectorStep;
    final long length;
    final UpdatablePNumberArray samplesRe;
    final UpdatablePNumberArray samplesIm;

    ComplexVectorSampleArray(UpdatablePNumberArray samplesRe, UpdatablePNumberArray samplesIm, long vectorLength, long vectorStep, long length) {
        Objects.requireNonNull(samplesRe, "Null samplesRe");
        Objects.requireNonNull(samplesIm, "Null samplesIm");
        if (vectorLength < 0L) {
            throw new IllegalArgumentException("Negative vectorLength = " + vectorLength);
        }
        if (vectorStep < vectorLength) {
            throw new IllegalArgumentException("vectorStep = " + vectorStep + " < vectorLength = " + vectorLength);
        }
        if (length < 0L) {
            throw new IllegalArgumentException("Negative length = " + length);
        }
        long m = samplesRe.length() - vectorLength;
        if (length > 0L && m < 0L || vectorStep > 0L && length - 1L > m / vectorStep) {
            throw new IllegalArgumentException("samplesRe is too short: its length " + samplesRe.length() + " < (length - 1) * vectorStep + vectorLength = " + (length - 1L) + " * " + vectorStep + " + " + vectorLength);
        }
        m = samplesIm.length() - vectorLength;
        if (length > 0L && m < 0L || vectorStep > 0L && length - 1L > m / vectorStep) {
            throw new IllegalArgumentException("samplesIm is too short: its length " + samplesIm.length() + " < (length - 1) * vectorStep + vectorLength = " + (length - 1L) + " * " + vectorStep + " + " + vectorLength);
        }
        this.samplesRe = samplesRe;
        this.samplesIm = samplesIm;
        this.vectorLength = vectorLength;
        this.vectorStep = vectorStep;
        this.length = length;
    }

    public static ComplexVectorSampleArray asSampleArray(MemoryModel memoryModel, UpdatablePNumberArray samplesRe, UpdatablePNumberArray samplesIm, long vectorLength, long vectorStep, long length) {
        Objects.requireNonNull(samplesRe, "Null samplesRe");
        Objects.requireNonNull(samplesIm, "Null samplesIm");
        samplesRe = (UpdatablePNumberArray)samplesRe.asUnresizable();
        samplesIm = (UpdatablePNumberArray)samplesIm.asUnresizable();
        if (samplesRe instanceof DirectAccessible && ((DirectAccessible)((Object)samplesRe)).hasJavaArray() && samplesIm instanceof DirectAccessible && ((DirectAccessible)((Object)samplesIm)).hasJavaArray() && vectorLength <= Arrays.SMM.maxSupportedLength(samplesRe.elementType()) / 64L) {
            if (samplesRe instanceof FloatArray && samplesIm instanceof FloatArray) {
                return new DirectComplexFloatVectorSampleArray(samplesRe, samplesIm, vectorLength, vectorStep, length);
            }
            if (samplesRe instanceof DoubleArray && samplesIm instanceof DoubleArray) {
                return new DirectComplexDoubleVectorSampleArray(samplesRe, samplesIm, vectorLength, vectorStep, length);
            }
        }
        if (vectorLength < 32768L) {
            if (samplesRe instanceof FloatArray && samplesIm instanceof FloatArray) {
                return new ComplexFloatVectorSampleArray(samplesRe, samplesIm, vectorLength, vectorStep, length);
            }
            if (samplesRe instanceof DoubleArray && samplesIm instanceof DoubleArray) {
                return new ComplexDoubleVectorSampleArray(samplesRe, samplesIm, vectorLength, vectorStep, length);
            }
        }
        if (memoryModel == null) {
            memoryModel = Arrays.SMM;
        }
        if (vectorLength > Math.min(memoryModel.maxSupportedLength(samplesRe.elementType()), memoryModel.maxSupportedLength(samplesIm.elementType())) / 64L) {
            throw new TooLargeArrayException("Too large samples for the given memory model " + String.valueOf(memoryModel) + ": it cannot allocate 64 samples (each sample is a vector of " + vectorLength + " numbers");
        }
        return new CommonComplexVectorSampleArray(memoryModel, samplesRe, samplesIm, vectorLength, vectorStep, length);
    }

    @Override
    public final boolean isComplex() {
        return true;
    }

    @Override
    public final long length() {
        return this.length;
    }

    @Override
    public abstract ComplexVectorSampleArray newCompatibleSamplesArray(long var1);

    @Override
    public void copy(long destIndex, SampleArray src, long srcIndex) {
        ComplexVectorSampleArray a = (ComplexVectorSampleArray)src;
        this.re(destIndex).copy(a.re(srcIndex));
        this.im(destIndex).copy(a.im(srcIndex));
    }

    @Override
    public void swap(long firstIndex, long secondIndex) {
        this.samplesRe.swap(firstIndex * this.vectorStep, secondIndex * this.vectorStep, this.vectorLength);
        this.samplesIm.swap(firstIndex * this.vectorStep, secondIndex * this.vectorStep, this.vectorLength);
    }

    @Override
    public abstract void add(long var1, SampleArray var3, long var4, long var6);

    @Override
    public abstract void sub(long var1, SampleArray var3, long var4, long var6);

    @Override
    public abstract void add(long var1, long var3, SampleArray var5, long var6);

    @Override
    public abstract void sub(long var1, long var3, SampleArray var5, long var6);

    @Override
    public abstract void add(long var1, long var3, long var5);

    @Override
    public abstract void sub(long var1, long var3, long var5);

    @Override
    public abstract void multiplyByScalar(long var1, SampleArray var3, long var4, double var6, double var8);

    @Override
    public abstract void combineWithRealMultipliers(long var1, long var3, double var5, long var7, double var9);

    @Override
    public abstract void multiplyByRealScalar(long var1, double var3);

    @Override
    public String toString(String format, String separator, int maxStringLength) {
        Objects.requireNonNull(format, "Null format argument");
        Objects.requireNonNull(separator, "Null separator argument");
        if (maxStringLength <= 0) {
            throw new IllegalArgumentException("maxStringLength argument must be positive");
        }
        if (this.length == 0L) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        format = "(" + (String)format + " " + (String)format + ")";
        long i = 0L;
        long disp = 0L;
        while (i < this.length) {
            if (sb.length() >= maxStringLength) {
                sb.append(separator).append("...");
                break;
            }
            if (i > 0L) {
                sb.append(" ").append(separator);
            }
            for (long j = 0L; j < this.vectorLength && sb.length() < maxStringLength; ++j) {
                sb.append(j == 0L ? "(" : separator);
                sb.append(String.format((String)format, this.samplesRe.getDouble(disp + j), this.samplesIm.getDouble(disp + j)));
                if (j != this.vectorLength - 1L) continue;
                sb.append(")");
            }
            ++i;
            disp += this.vectorStep;
        }
        return sb.toString();
    }

    UpdatablePArray re(long index) {
        return this.samplesRe.subArr(index * this.vectorStep, this.vectorLength);
    }

    UpdatablePArray im(long index) {
        return this.samplesIm.subArr(index * this.vectorStep, this.vectorLength);
    }

    static class DirectComplexFloatVectorSampleArray
    extends ComplexVectorSampleArray {
        final float[] samplesRe;
        final int ofsRe;
        final float[] samplesIm;
        final int ofsIm;
        final int vectorLen;

        DirectComplexFloatVectorSampleArray(UpdatablePNumberArray samplesRe, UpdatablePNumberArray samplesIm, long vectorLength, long vectorStep, long length) {
            super(samplesRe, samplesIm, vectorLength, vectorStep, length);
            DirectAccessible daRe = (DirectAccessible)((Object)((ComplexVectorSampleArray)this).samplesRe);
            this.samplesRe = (float[])daRe.javaArray();
            this.ofsRe = daRe.javaArrayOffset();
            DirectAccessible daIm = (DirectAccessible)((Object)((ComplexVectorSampleArray)this).samplesIm);
            this.samplesIm = (float[])daIm.javaArray();
            this.ofsIm = daIm.javaArrayOffset();
            assert (length <= Integer.MAX_VALUE);
            this.vectorLen = (int)vectorLength;
        }

        @Override
        public ComplexVectorSampleArray newCompatibleSamplesArray(long length) {
            if (length > Long.MAX_VALUE / this.vectorLength) {
                throw new TooLargeArrayException("Too large sample array: " + length + " vectors of " + this.vectorLength + " numbers");
            }
            return new DirectComplexFloatVectorSampleArray(Arrays.SMM.newUnresizableFloatArray(length * this.vectorLength), Arrays.SMM.newUnresizableFloatArray(length * this.vectorLength), this.vectorLength, this.vectorLength, length);
        }

        @Override
        public void add(long destIndex, SampleArray src, long srcIndex1, long srcIndex2) {
            DirectComplexFloatVectorSampleArray a = (DirectComplexFloatVectorSampleArray)src;
            int k = this.ofsRe + (int)(destIndex * this.vectorStep);
            int kMax = k + this.vectorLen;
            int i = a.ofsRe + (int)(srcIndex1 * a.vectorStep);
            int j = a.ofsRe + (int)(srcIndex2 * a.vectorStep);
            while (k < kMax) {
                this.samplesRe[k] = a.samplesRe[i] + a.samplesRe[j];
                ++k;
                ++i;
                ++j;
            }
            k = this.ofsIm + (int)(destIndex * this.vectorStep);
            kMax = k + this.vectorLen;
            i = a.ofsIm + (int)(srcIndex1 * a.vectorStep);
            j = a.ofsIm + (int)(srcIndex2 * a.vectorStep);
            while (k < kMax) {
                this.samplesIm[k] = a.samplesIm[i] + a.samplesIm[j];
                ++k;
                ++i;
                ++j;
            }
        }

        @Override
        public void sub(long destIndex, SampleArray src, long srcIndex1, long srcIndex2) {
            DirectComplexFloatVectorSampleArray a = (DirectComplexFloatVectorSampleArray)src;
            int k = this.ofsRe + (int)(destIndex * this.vectorStep);
            int kMax = k + this.vectorLen;
            int i = a.ofsRe + (int)(srcIndex1 * a.vectorStep);
            int j = a.ofsRe + (int)(srcIndex2 * a.vectorStep);
            while (k < kMax) {
                this.samplesRe[k] = a.samplesRe[i] - a.samplesRe[j];
                ++k;
                ++i;
                ++j;
            }
            k = this.ofsIm + (int)(destIndex * this.vectorStep);
            kMax = k + this.vectorLen;
            i = a.ofsIm + (int)(srcIndex1 * a.vectorStep);
            j = a.ofsIm + (int)(srcIndex2 * a.vectorStep);
            while (k < kMax) {
                this.samplesIm[k] = a.samplesIm[i] - a.samplesIm[j];
                ++k;
                ++i;
                ++j;
            }
        }

        @Override
        public void add(long destIndex, long srcIndex1, SampleArray src2, long srcIndex2) {
            DirectComplexFloatVectorSampleArray a2 = (DirectComplexFloatVectorSampleArray)src2;
            int k = this.ofsRe + (int)(destIndex * this.vectorStep);
            int kMax = k + this.vectorLen;
            int i = this.ofsRe + (int)(srcIndex1 * this.vectorStep);
            int j = a2.ofsRe + (int)(srcIndex2 * a2.vectorStep);
            while (k < kMax) {
                this.samplesRe[k] = this.samplesRe[i] + a2.samplesRe[j];
                ++k;
                ++i;
                ++j;
            }
            k = this.ofsIm + (int)(destIndex * this.vectorStep);
            kMax = k + this.vectorLen;
            i = this.ofsIm + (int)(srcIndex1 * this.vectorStep);
            j = a2.ofsIm + (int)(srcIndex2 * a2.vectorStep);
            while (k < kMax) {
                this.samplesIm[k] = this.samplesIm[i] + a2.samplesIm[j];
                ++k;
                ++i;
                ++j;
            }
        }

        @Override
        public void sub(long destIndex, long srcIndex1, SampleArray src2, long srcIndex2) {
            DirectComplexFloatVectorSampleArray a2 = (DirectComplexFloatVectorSampleArray)src2;
            int k = this.ofsRe + (int)(destIndex * this.vectorStep);
            int kMax = k + this.vectorLen;
            int i = this.ofsRe + (int)(srcIndex1 * this.vectorStep);
            int j = a2.ofsRe + (int)(srcIndex2 * a2.vectorStep);
            while (k < kMax) {
                this.samplesRe[k] = this.samplesRe[i] - a2.samplesRe[j];
                ++k;
                ++i;
                ++j;
            }
            k = this.ofsIm + (int)(destIndex * this.vectorStep);
            kMax = k + this.vectorLen;
            i = this.ofsIm + (int)(srcIndex1 * this.vectorStep);
            j = a2.ofsIm + (int)(srcIndex2 * a2.vectorStep);
            while (k < kMax) {
                this.samplesIm[k] = this.samplesIm[i] - a2.samplesIm[j];
                ++k;
                ++i;
                ++j;
            }
        }

        @Override
        public void add(long destIndex, long srcIndex1, long srcIndex2) {
            int k = this.ofsRe + (int)(destIndex * this.vectorStep);
            int kMax = k + this.vectorLen;
            int i = this.ofsRe + (int)(srcIndex1 * this.vectorStep);
            int j = this.ofsRe + (int)(srcIndex2 * this.vectorStep);
            while (k < kMax) {
                this.samplesRe[k] = this.samplesRe[i] + this.samplesRe[j];
                ++k;
                ++i;
                ++j;
            }
            k = this.ofsIm + (int)(destIndex * this.vectorStep);
            kMax = k + this.vectorLen;
            i = this.ofsIm + (int)(srcIndex1 * this.vectorStep);
            j = this.ofsIm + (int)(srcIndex2 * this.vectorStep);
            while (k < kMax) {
                this.samplesIm[k] = this.samplesIm[i] + this.samplesIm[j];
                ++k;
                ++i;
                ++j;
            }
        }

        @Override
        public void sub(long destIndex, long srcIndex1, long srcIndex2) {
            int k = this.ofsRe + (int)(destIndex * this.vectorStep);
            int kMax = k + this.vectorLen;
            int i = this.ofsRe + (int)(srcIndex1 * this.vectorStep);
            int j = this.ofsRe + (int)(srcIndex2 * this.vectorStep);
            while (k < kMax) {
                this.samplesRe[k] = this.samplesRe[i] - this.samplesRe[j];
                ++k;
                ++i;
                ++j;
            }
            k = this.ofsIm + (int)(destIndex * this.vectorStep);
            kMax = k + this.vectorLen;
            i = this.ofsIm + (int)(srcIndex1 * this.vectorStep);
            j = this.ofsIm + (int)(srcIndex2 * this.vectorStep);
            while (k < kMax) {
                this.samplesIm[k] = this.samplesIm[i] - this.samplesIm[j];
                ++k;
                ++i;
                ++j;
            }
        }

        @Override
        public void multiplyByScalar(long destIndex, SampleArray src, long srcIndex, double aRe, double aIm) {
            DirectComplexFloatVectorSampleArray a = (DirectComplexFloatVectorSampleArray)src;
            int kRe = this.ofsRe + (int)(destIndex * this.vectorStep);
            int kReMax = kRe + this.vectorLen;
            int kIm = this.ofsIm + (int)(destIndex * this.vectorStep);
            int iRe = a.ofsRe + (int)(srcIndex * a.vectorStep);
            int iIm = a.ofsIm + (int)(srcIndex * a.vectorStep);
            while (kRe < kReMax) {
                float re = a.samplesRe[iRe];
                float im = a.samplesIm[iIm];
                this.samplesRe[kRe] = (float)((double)re * aRe - (double)im * aIm);
                this.samplesIm[kIm] = (float)((double)re * aIm + (double)im * aRe);
                ++kRe;
                ++kIm;
                ++iRe;
                ++iIm;
            }
        }

        @Override
        public void combineWithRealMultipliers(long destIndex, long srcIndex1, double a1, long srcIndex2, double a2) {
            int k = this.ofsRe + (int)(destIndex * this.vectorStep);
            int kMax = k + this.vectorLen;
            int i = this.ofsRe + (int)(srcIndex1 * this.vectorStep);
            int j = this.ofsRe + (int)(srcIndex2 * this.vectorStep);
            while (k < kMax) {
                this.samplesRe[k] = (float)(a1 * (double)this.samplesRe[i] + a2 * (double)this.samplesRe[j]);
                ++k;
                ++i;
                ++j;
            }
            k = this.ofsIm + (int)(destIndex * this.vectorStep);
            kMax = k + this.vectorLen;
            i = this.ofsIm + (int)(srcIndex1 * this.vectorStep);
            j = this.ofsIm + (int)(srcIndex2 * this.vectorStep);
            while (k < kMax) {
                this.samplesIm[k] = (float)(a1 * (double)this.samplesIm[i] + a2 * (double)this.samplesIm[j]);
                ++k;
                ++i;
                ++j;
            }
        }

        @Override
        public void multiplyByRealScalar(long index, double a) {
            int k;
            int kMax = k + this.vectorLen;
            for (k = this.ofsRe + (int)(index * this.vectorStep); k < kMax; ++k) {
                this.samplesRe[k] = (float)((double)this.samplesRe[k] * a);
            }
            kMax = k + this.vectorLen;
            for (k = this.ofsIm + (int)(index * this.vectorStep); k < kMax; ++k) {
                this.samplesIm[k] = (float)((double)this.samplesIm[k] * a);
            }
        }

        @Override
        public void multiplyRangeByRealScalar(long fromIndex, long toIndex, double a) {
            int dispRe = this.ofsRe + (int)(fromIndex * this.vectorStep);
            int dispIm = this.ofsIm + (int)(fromIndex * this.vectorStep);
            int dispReMax = dispRe + (int)((toIndex - fromIndex) * this.vectorStep);
            while (dispRe < dispReMax) {
                int k;
                int kMax = k + this.vectorLen;
                for (k = dispRe; k < kMax; ++k) {
                    this.samplesRe[k] = (float)((double)this.samplesRe[k] * a);
                }
                kMax = k + this.vectorLen;
                for (k = dispIm; k < kMax; ++k) {
                    this.samplesIm[k] = (float)((double)this.samplesIm[k] * a);
                }
                dispRe += (int)this.vectorStep;
                dispIm += (int)this.vectorStep;
            }
        }
    }

    static class DirectComplexDoubleVectorSampleArray
    extends ComplexVectorSampleArray {
        final double[] samplesRe;
        final int ofsRe;
        final double[] samplesIm;
        final int ofsIm;
        final int vectorLen;

        DirectComplexDoubleVectorSampleArray(UpdatablePNumberArray samplesRe, UpdatablePNumberArray samplesIm, long vectorLength, long vectorStep, long length) {
            super(samplesRe, samplesIm, vectorLength, vectorStep, length);
            DirectAccessible daRe = (DirectAccessible)((Object)((ComplexVectorSampleArray)this).samplesRe);
            this.samplesRe = (double[])daRe.javaArray();
            this.ofsRe = daRe.javaArrayOffset();
            DirectAccessible daIm = (DirectAccessible)((Object)((ComplexVectorSampleArray)this).samplesIm);
            this.samplesIm = (double[])daIm.javaArray();
            this.ofsIm = daIm.javaArrayOffset();
            assert (length <= Integer.MAX_VALUE);
            this.vectorLen = (int)vectorLength;
        }

        @Override
        public ComplexVectorSampleArray newCompatibleSamplesArray(long length) {
            if (length > Long.MAX_VALUE / this.vectorLength) {
                throw new TooLargeArrayException("Too large sample array: " + length + " vectors of " + this.vectorLength + " numbers");
            }
            return new DirectComplexDoubleVectorSampleArray(Arrays.SMM.newUnresizableDoubleArray(length * this.vectorLength), Arrays.SMM.newUnresizableDoubleArray(length * this.vectorLength), this.vectorLength, this.vectorLength, length);
        }

        @Override
        public void add(long destIndex, SampleArray src, long srcIndex1, long srcIndex2) {
            DirectComplexDoubleVectorSampleArray a = (DirectComplexDoubleVectorSampleArray)src;
            int k = this.ofsRe + (int)(destIndex * this.vectorStep);
            int kMax = k + this.vectorLen;
            int i = a.ofsRe + (int)(srcIndex1 * a.vectorStep);
            int j = a.ofsRe + (int)(srcIndex2 * a.vectorStep);
            while (k < kMax) {
                this.samplesRe[k] = a.samplesRe[i] + a.samplesRe[j];
                ++k;
                ++i;
                ++j;
            }
            k = this.ofsIm + (int)(destIndex * this.vectorStep);
            kMax = k + this.vectorLen;
            i = a.ofsIm + (int)(srcIndex1 * a.vectorStep);
            j = a.ofsIm + (int)(srcIndex2 * a.vectorStep);
            while (k < kMax) {
                this.samplesIm[k] = a.samplesIm[i] + a.samplesIm[j];
                ++k;
                ++i;
                ++j;
            }
        }

        @Override
        public void sub(long destIndex, SampleArray src, long srcIndex1, long srcIndex2) {
            DirectComplexDoubleVectorSampleArray a = (DirectComplexDoubleVectorSampleArray)src;
            int k = this.ofsRe + (int)(destIndex * this.vectorStep);
            int kMax = k + this.vectorLen;
            int i = a.ofsRe + (int)(srcIndex1 * a.vectorStep);
            int j = a.ofsRe + (int)(srcIndex2 * a.vectorStep);
            while (k < kMax) {
                this.samplesRe[k] = a.samplesRe[i] - a.samplesRe[j];
                ++k;
                ++i;
                ++j;
            }
            k = this.ofsIm + (int)(destIndex * this.vectorStep);
            kMax = k + this.vectorLen;
            i = a.ofsIm + (int)(srcIndex1 * a.vectorStep);
            j = a.ofsIm + (int)(srcIndex2 * a.vectorStep);
            while (k < kMax) {
                this.samplesIm[k] = a.samplesIm[i] - a.samplesIm[j];
                ++k;
                ++i;
                ++j;
            }
        }

        @Override
        public void add(long destIndex, long srcIndex1, SampleArray src2, long srcIndex2) {
            DirectComplexDoubleVectorSampleArray a2 = (DirectComplexDoubleVectorSampleArray)src2;
            int k = this.ofsRe + (int)(destIndex * this.vectorStep);
            int kMax = k + this.vectorLen;
            int i = this.ofsRe + (int)(srcIndex1 * this.vectorStep);
            int j = a2.ofsRe + (int)(srcIndex2 * a2.vectorStep);
            while (k < kMax) {
                this.samplesRe[k] = this.samplesRe[i] + a2.samplesRe[j];
                ++k;
                ++i;
                ++j;
            }
            k = this.ofsIm + (int)(destIndex * this.vectorStep);
            kMax = k + this.vectorLen;
            i = this.ofsIm + (int)(srcIndex1 * this.vectorStep);
            j = a2.ofsIm + (int)(srcIndex2 * a2.vectorStep);
            while (k < kMax) {
                this.samplesIm[k] = this.samplesIm[i] + a2.samplesIm[j];
                ++k;
                ++i;
                ++j;
            }
        }

        @Override
        public void sub(long destIndex, long srcIndex1, SampleArray src2, long srcIndex2) {
            DirectComplexDoubleVectorSampleArray a2 = (DirectComplexDoubleVectorSampleArray)src2;
            int k = this.ofsRe + (int)(destIndex * this.vectorStep);
            int kMax = k + this.vectorLen;
            int i = this.ofsRe + (int)(srcIndex1 * this.vectorStep);
            int j = a2.ofsRe + (int)(srcIndex2 * a2.vectorStep);
            while (k < kMax) {
                this.samplesRe[k] = this.samplesRe[i] - a2.samplesRe[j];
                ++k;
                ++i;
                ++j;
            }
            k = this.ofsIm + (int)(destIndex * this.vectorStep);
            kMax = k + this.vectorLen;
            i = this.ofsIm + (int)(srcIndex1 * this.vectorStep);
            j = a2.ofsIm + (int)(srcIndex2 * a2.vectorStep);
            while (k < kMax) {
                this.samplesIm[k] = this.samplesIm[i] - a2.samplesIm[j];
                ++k;
                ++i;
                ++j;
            }
        }

        @Override
        public void add(long destIndex, long srcIndex1, long srcIndex2) {
            int k = this.ofsRe + (int)(destIndex * this.vectorStep);
            int kMax = k + this.vectorLen;
            int i = this.ofsRe + (int)(srcIndex1 * this.vectorStep);
            int j = this.ofsRe + (int)(srcIndex2 * this.vectorStep);
            while (k < kMax) {
                this.samplesRe[k] = this.samplesRe[i] + this.samplesRe[j];
                ++k;
                ++i;
                ++j;
            }
            k = this.ofsIm + (int)(destIndex * this.vectorStep);
            kMax = k + this.vectorLen;
            i = this.ofsIm + (int)(srcIndex1 * this.vectorStep);
            j = this.ofsIm + (int)(srcIndex2 * this.vectorStep);
            while (k < kMax) {
                this.samplesIm[k] = this.samplesIm[i] + this.samplesIm[j];
                ++k;
                ++i;
                ++j;
            }
        }

        @Override
        public void sub(long destIndex, long srcIndex1, long srcIndex2) {
            int k = this.ofsRe + (int)(destIndex * this.vectorStep);
            int kMax = k + this.vectorLen;
            int i = this.ofsRe + (int)(srcIndex1 * this.vectorStep);
            int j = this.ofsRe + (int)(srcIndex2 * this.vectorStep);
            while (k < kMax) {
                this.samplesRe[k] = this.samplesRe[i] - this.samplesRe[j];
                ++k;
                ++i;
                ++j;
            }
            k = this.ofsIm + (int)(destIndex * this.vectorStep);
            kMax = k + this.vectorLen;
            i = this.ofsIm + (int)(srcIndex1 * this.vectorStep);
            j = this.ofsIm + (int)(srcIndex2 * this.vectorStep);
            while (k < kMax) {
                this.samplesIm[k] = this.samplesIm[i] - this.samplesIm[j];
                ++k;
                ++i;
                ++j;
            }
        }

        @Override
        public void multiplyByScalar(long destIndex, SampleArray src, long srcIndex, double aRe, double aIm) {
            DirectComplexDoubleVectorSampleArray a = (DirectComplexDoubleVectorSampleArray)src;
            int kRe = this.ofsRe + (int)(destIndex * this.vectorStep);
            int kReMax = kRe + this.vectorLen;
            int kIm = this.ofsIm + (int)(destIndex * this.vectorStep);
            int iRe = a.ofsRe + (int)(srcIndex * a.vectorStep);
            int iIm = a.ofsIm + (int)(srcIndex * a.vectorStep);
            while (kRe < kReMax) {
                double re = a.samplesRe[iRe];
                double im = a.samplesIm[iIm];
                this.samplesRe[kRe] = re * aRe - im * aIm;
                this.samplesIm[kIm] = re * aIm + im * aRe;
                ++kRe;
                ++kIm;
                ++iRe;
                ++iIm;
            }
        }

        @Override
        public void combineWithRealMultipliers(long destIndex, long srcIndex1, double a1, long srcIndex2, double a2) {
            int k = this.ofsRe + (int)(destIndex * this.vectorStep);
            int kMax = k + this.vectorLen;
            int i = this.ofsRe + (int)(srcIndex1 * this.vectorStep);
            int j = this.ofsRe + (int)(srcIndex2 * this.vectorStep);
            while (k < kMax) {
                this.samplesRe[k] = a1 * this.samplesRe[i] + a2 * this.samplesRe[j];
                ++k;
                ++i;
                ++j;
            }
            k = this.ofsIm + (int)(destIndex * this.vectorStep);
            kMax = k + this.vectorLen;
            i = this.ofsIm + (int)(srcIndex1 * this.vectorStep);
            j = this.ofsIm + (int)(srcIndex2 * this.vectorStep);
            while (k < kMax) {
                this.samplesIm[k] = a1 * this.samplesIm[i] + a2 * this.samplesIm[j];
                ++k;
                ++i;
                ++j;
            }
        }

        @Override
        public void multiplyByRealScalar(long index, double a) {
            int k;
            int kMax = k + this.vectorLen;
            for (k = this.ofsRe + (int)(index * this.vectorStep); k < kMax; ++k) {
                this.samplesRe[k] = this.samplesRe[k] * a;
            }
            kMax = k + this.vectorLen;
            for (k = this.ofsIm + (int)(index * this.vectorStep); k < kMax; ++k) {
                this.samplesIm[k] = this.samplesIm[k] * a;
            }
        }

        @Override
        public void multiplyRangeByRealScalar(long fromIndex, long toIndex, double a) {
            int dispRe = this.ofsRe + (int)(fromIndex * this.vectorStep);
            int dispIm = this.ofsIm + (int)(fromIndex * this.vectorStep);
            int dispReMax = dispRe + (int)((toIndex - fromIndex) * this.vectorStep);
            while (dispRe < dispReMax) {
                int k;
                int kMax = k + this.vectorLen;
                for (k = dispRe; k < kMax; ++k) {
                    this.samplesRe[k] = this.samplesRe[k] * a;
                }
                kMax = k + this.vectorLen;
                for (k = dispIm; k < kMax; ++k) {
                    this.samplesIm[k] = this.samplesIm[k] * a;
                }
                dispRe += (int)this.vectorStep;
                dispIm += (int)this.vectorStep;
            }
        }
    }

    static class ComplexFloatVectorSampleArray
    extends ComplexVectorSampleArray {
        final int vectorLen;
        final int vectorLen2;

        ComplexFloatVectorSampleArray(UpdatablePNumberArray samplesRe, UpdatablePNumberArray samplesIm, long vectorLength, long vectorStep, long length) {
            super(samplesRe, samplesIm, vectorLength, vectorStep, length);
            assert (length <= 32768L);
            this.vectorLen = (int)vectorLength;
            this.vectorLen2 = 2 * this.vectorLen;
        }

        @Override
        public ComplexVectorSampleArray newCompatibleSamplesArray(long length) {
            if (length > Long.MAX_VALUE / this.vectorLength) {
                throw new TooLargeArrayException("Too large sample array: " + length + " vectors of " + this.vectorLength + " numbers");
            }
            return new ComplexFloatVectorSampleArray((UpdatablePNumberArray)Arrays.SMM.newUnresizableArray(this.samplesRe.elementType(), length * this.vectorLength), (UpdatablePNumberArray)Arrays.SMM.newUnresizableArray(this.samplesIm.elementType(), length * this.vectorLength), this.vectorLength, this.vectorLength, length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(long destIndex, SampleArray src, long srcIndex1, long srcIndex2) {
            ComplexFloatVectorSampleArray a = (ComplexFloatVectorSampleArray)src;
            float[] buf = null;
            try {
                buf = (float[])FLOAT_BUFFERS.requestArray();
                a.samplesRe.getData(srcIndex1 * this.vectorStep, buf, 0, this.vectorLen);
                a.samplesIm.getData(srcIndex1 * this.vectorStep, buf, this.vectorLen, this.vectorLen);
                a.samplesRe.getData(srcIndex2 * this.vectorStep, buf, 2 * this.vectorLen, this.vectorLen);
                a.samplesIm.getData(srcIndex2 * this.vectorStep, buf, 3 * this.vectorLen, this.vectorLen);
                int i = 0;
                int j = this.vectorLen2;
                while (i < this.vectorLen2) {
                    int n = i++;
                    buf[n] = buf[n] + buf[j];
                    ++j;
                }
                this.samplesRe.setData(destIndex * this.vectorStep, buf, 0, this.vectorLen);
                this.samplesIm.setData(destIndex * this.vectorStep, buf, this.vectorLen, this.vectorLen);
            }
            finally {
                FLOAT_BUFFERS.releaseArray(buf);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sub(long destIndex, SampleArray src, long srcIndex1, long srcIndex2) {
            ComplexFloatVectorSampleArray a = (ComplexFloatVectorSampleArray)src;
            float[] buf = null;
            try {
                buf = (float[])FLOAT_BUFFERS.requestArray();
                a.samplesRe.getData(srcIndex1 * this.vectorStep, buf, 0, this.vectorLen);
                a.samplesIm.getData(srcIndex1 * this.vectorStep, buf, this.vectorLen, this.vectorLen);
                a.samplesRe.getData(srcIndex2 * this.vectorStep, buf, 2 * this.vectorLen, this.vectorLen);
                a.samplesIm.getData(srcIndex2 * this.vectorStep, buf, 3 * this.vectorLen, this.vectorLen);
                int i = 0;
                int j = this.vectorLen2;
                while (i < this.vectorLen2) {
                    int n = i++;
                    buf[n] = buf[n] - buf[j];
                    ++j;
                }
                this.samplesRe.setData(destIndex * this.vectorStep, buf, 0, this.vectorLen);
                this.samplesIm.setData(destIndex * this.vectorStep, buf, this.vectorLen, this.vectorLen);
            }
            finally {
                FLOAT_BUFFERS.releaseArray(buf);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(long destIndex, long srcIndex1, SampleArray src2, long srcIndex2) {
            ComplexFloatVectorSampleArray a2 = (ComplexFloatVectorSampleArray)src2;
            float[] buf = null;
            try {
                buf = (float[])FLOAT_BUFFERS.requestArray();
                this.samplesRe.getData(srcIndex1 * this.vectorStep, buf, 0, this.vectorLen);
                this.samplesIm.getData(srcIndex1 * this.vectorStep, buf, this.vectorLen, this.vectorLen);
                a2.samplesRe.getData(srcIndex2 * this.vectorStep, buf, 2 * this.vectorLen, this.vectorLen);
                a2.samplesIm.getData(srcIndex2 * this.vectorStep, buf, 3 * this.vectorLen, this.vectorLen);
                int i = 0;
                int j = this.vectorLen2;
                while (i < this.vectorLen2) {
                    int n = i++;
                    buf[n] = buf[n] + buf[j];
                    ++j;
                }
                this.samplesRe.setData(destIndex * this.vectorStep, buf, 0, this.vectorLen);
                this.samplesIm.setData(destIndex * this.vectorStep, buf, this.vectorLen, this.vectorLen);
            }
            finally {
                FLOAT_BUFFERS.releaseArray(buf);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sub(long destIndex, long srcIndex1, SampleArray src2, long srcIndex2) {
            ComplexFloatVectorSampleArray a2 = (ComplexFloatVectorSampleArray)src2;
            float[] buf = null;
            try {
                buf = (float[])FLOAT_BUFFERS.requestArray();
                this.samplesRe.getData(srcIndex1 * this.vectorStep, buf, 0, this.vectorLen);
                this.samplesIm.getData(srcIndex1 * this.vectorStep, buf, this.vectorLen, this.vectorLen);
                a2.samplesRe.getData(srcIndex2 * this.vectorStep, buf, 2 * this.vectorLen, this.vectorLen);
                a2.samplesIm.getData(srcIndex2 * this.vectorStep, buf, 3 * this.vectorLen, this.vectorLen);
                int i = 0;
                int j = this.vectorLen2;
                while (i < this.vectorLen2) {
                    int n = i++;
                    buf[n] = buf[n] - buf[j];
                    ++j;
                }
                this.samplesRe.setData(destIndex * this.vectorStep, buf, 0, this.vectorLen);
                this.samplesIm.setData(destIndex * this.vectorStep, buf, this.vectorLen, this.vectorLen);
            }
            finally {
                FLOAT_BUFFERS.releaseArray(buf);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(long destIndex, long srcIndex1, long srcIndex2) {
            float[] buf = null;
            try {
                buf = (float[])FLOAT_BUFFERS.requestArray();
                this.samplesRe.getData(srcIndex1 * this.vectorStep, buf, 0, this.vectorLen);
                this.samplesIm.getData(srcIndex1 * this.vectorStep, buf, this.vectorLen, this.vectorLen);
                this.samplesRe.getData(srcIndex2 * this.vectorStep, buf, 2 * this.vectorLen, this.vectorLen);
                this.samplesIm.getData(srcIndex2 * this.vectorStep, buf, 3 * this.vectorLen, this.vectorLen);
                int i = 0;
                int j = this.vectorLen2;
                while (i < this.vectorLen2) {
                    int n = i++;
                    buf[n] = buf[n] + buf[j];
                    ++j;
                }
                this.samplesRe.setData(destIndex * this.vectorStep, buf, 0, this.vectorLen);
                this.samplesIm.setData(destIndex * this.vectorStep, buf, this.vectorLen, this.vectorLen);
            }
            finally {
                FLOAT_BUFFERS.releaseArray(buf);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sub(long destIndex, long srcIndex1, long srcIndex2) {
            float[] buf = null;
            try {
                buf = (float[])FLOAT_BUFFERS.requestArray();
                this.samplesRe.getData(srcIndex1 * this.vectorStep, buf, 0, this.vectorLen);
                this.samplesIm.getData(srcIndex1 * this.vectorStep, buf, this.vectorLen, this.vectorLen);
                this.samplesRe.getData(srcIndex2 * this.vectorStep, buf, 2 * this.vectorLen, this.vectorLen);
                this.samplesIm.getData(srcIndex2 * this.vectorStep, buf, 3 * this.vectorLen, this.vectorLen);
                int i = 0;
                int j = this.vectorLen2;
                while (i < this.vectorLen2) {
                    int n = i++;
                    buf[n] = buf[n] - buf[j];
                    ++j;
                }
                this.samplesRe.setData(destIndex * this.vectorStep, buf, 0, this.vectorLen);
                this.samplesIm.setData(destIndex * this.vectorStep, buf, this.vectorLen, this.vectorLen);
            }
            finally {
                FLOAT_BUFFERS.releaseArray(buf);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void multiplyByScalar(long destIndex, SampleArray src, long srcIndex, double aRe, double aIm) {
            ComplexFloatVectorSampleArray a = (ComplexFloatVectorSampleArray)src;
            float[] buf = null;
            try {
                buf = (float[])FLOAT_BUFFERS.requestArray();
                a.samplesRe.getData(srcIndex * this.vectorStep, buf, 0, this.vectorLen);
                a.samplesIm.getData(srcIndex * this.vectorStep, buf, this.vectorLen, this.vectorLen);
                int i = 0;
                int j = this.vectorLen;
                while (i < this.vectorLen) {
                    float re = (float)((double)buf[i] * aRe - (double)buf[j] * aIm);
                    float im = (float)((double)buf[i] * aIm + (double)buf[j] * aRe);
                    buf[i] = re;
                    buf[j] = im;
                    ++i;
                    ++j;
                }
                this.samplesRe.setData(destIndex * this.vectorStep, buf, 0, this.vectorLen);
                this.samplesIm.setData(destIndex * this.vectorStep, buf, this.vectorLen, this.vectorLen);
            }
            finally {
                FLOAT_BUFFERS.releaseArray(buf);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void multiplyByRealScalar(long index, double a) {
            float[] buf = null;
            try {
                buf = (float[])FLOAT_BUFFERS.requestArray();
                this.samplesRe.getData(index * this.vectorStep, buf, 0, this.vectorLen);
                this.samplesIm.getData(index * this.vectorStep, buf, this.vectorLen, this.vectorLen);
                for (int i = 0; i < this.vectorLen2; ++i) {
                    buf[i] = (float)((double)buf[i] * a);
                }
                this.samplesRe.setData(index * this.vectorStep, buf, 0, this.vectorLen);
                this.samplesIm.setData(index * this.vectorStep, buf, this.vectorLen, this.vectorLen);
            }
            finally {
                FLOAT_BUFFERS.releaseArray(buf);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void combineWithRealMultipliers(long destIndex, long srcIndex1, double a1, long srcIndex2, double a2) {
            float[] buf = null;
            try {
                buf = (float[])FLOAT_BUFFERS.requestArray();
                this.samplesRe.getData(srcIndex1 * this.vectorStep, buf, 0, this.vectorLen);
                this.samplesIm.getData(srcIndex1 * this.vectorStep, buf, this.vectorLen, this.vectorLen);
                this.samplesRe.getData(srcIndex2 * this.vectorStep, buf, 2 * this.vectorLen, this.vectorLen);
                this.samplesIm.getData(srcIndex2 * this.vectorStep, buf, 3 * this.vectorLen, this.vectorLen);
                int i = 0;
                int j = this.vectorLen2;
                while (i < this.vectorLen2) {
                    buf[i] = (float)((double)buf[i] * a1 + (double)buf[j] * a2);
                    ++i;
                    ++j;
                }
                this.samplesRe.setData(destIndex * this.vectorStep, buf, 0, this.vectorLen);
                this.samplesIm.setData(destIndex * this.vectorStep, buf, this.vectorLen, this.vectorLen);
            }
            finally {
                FLOAT_BUFFERS.releaseArray(buf);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void multiplyRangeByRealScalar(long fromIndex, long toIndex, double a) {
            float[] buf = null;
            try {
                buf = (float[])FLOAT_BUFFERS.requestArray();
                for (long index = fromIndex; index < toIndex; ++index) {
                    this.samplesRe.getData(index * this.vectorStep, buf, 0, this.vectorLen);
                    this.samplesIm.getData(index * this.vectorStep, buf, this.vectorLen, this.vectorLen);
                    for (int i = 0; i < this.vectorLen2; ++i) {
                        buf[i] = (float)((double)buf[i] * a);
                    }
                    this.samplesRe.setData(index * this.vectorStep, buf, 0, this.vectorLen);
                    this.samplesIm.setData(index * this.vectorStep, buf, this.vectorLen, this.vectorLen);
                }
            }
            finally {
                FLOAT_BUFFERS.releaseArray(buf);
            }
        }
    }

    static class ComplexDoubleVectorSampleArray
    extends ComplexVectorSampleArray {
        final int vectorLen;
        final int vectorLen2;

        ComplexDoubleVectorSampleArray(UpdatablePNumberArray samplesRe, UpdatablePNumberArray samplesIm, long vectorLength, long vectorStep, long length) {
            super(samplesRe, samplesIm, vectorLength, vectorStep, length);
            assert (length <= 32768L);
            this.vectorLen = (int)vectorLength;
            this.vectorLen2 = 2 * this.vectorLen;
        }

        @Override
        public ComplexVectorSampleArray newCompatibleSamplesArray(long length) {
            if (length > Long.MAX_VALUE / this.vectorLength) {
                throw new TooLargeArrayException("Too large sample array: " + length + " vectors of " + this.vectorLength + " numbers");
            }
            return new ComplexDoubleVectorSampleArray((UpdatablePNumberArray)Arrays.SMM.newUnresizableArray(this.samplesRe.elementType(), length * this.vectorLength), (UpdatablePNumberArray)Arrays.SMM.newUnresizableArray(this.samplesIm.elementType(), length * this.vectorLength), this.vectorLength, this.vectorLength, length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(long destIndex, SampleArray src, long srcIndex1, long srcIndex2) {
            ComplexDoubleVectorSampleArray a = (ComplexDoubleVectorSampleArray)src;
            double[] buf = null;
            try {
                buf = (double[])DOUBLE_BUFFERS.requestArray();
                a.samplesRe.getData(srcIndex1 * this.vectorStep, buf, 0, this.vectorLen);
                a.samplesIm.getData(srcIndex1 * this.vectorStep, buf, this.vectorLen, this.vectorLen);
                a.samplesRe.getData(srcIndex2 * this.vectorStep, buf, 2 * this.vectorLen, this.vectorLen);
                a.samplesIm.getData(srcIndex2 * this.vectorStep, buf, 3 * this.vectorLen, this.vectorLen);
                int i = 0;
                int j = this.vectorLen2;
                while (i < this.vectorLen2) {
                    int n = i++;
                    buf[n] = buf[n] + buf[j];
                    ++j;
                }
                this.samplesRe.setData(destIndex * this.vectorStep, buf, 0, this.vectorLen);
                this.samplesIm.setData(destIndex * this.vectorStep, buf, this.vectorLen, this.vectorLen);
            }
            finally {
                DOUBLE_BUFFERS.releaseArray(buf);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sub(long destIndex, SampleArray src, long srcIndex1, long srcIndex2) {
            ComplexDoubleVectorSampleArray a = (ComplexDoubleVectorSampleArray)src;
            double[] buf = null;
            try {
                buf = (double[])DOUBLE_BUFFERS.requestArray();
                a.samplesRe.getData(srcIndex1 * this.vectorStep, buf, 0, this.vectorLen);
                a.samplesIm.getData(srcIndex1 * this.vectorStep, buf, this.vectorLen, this.vectorLen);
                a.samplesRe.getData(srcIndex2 * this.vectorStep, buf, 2 * this.vectorLen, this.vectorLen);
                a.samplesIm.getData(srcIndex2 * this.vectorStep, buf, 3 * this.vectorLen, this.vectorLen);
                int i = 0;
                int j = this.vectorLen2;
                while (i < this.vectorLen2) {
                    int n = i++;
                    buf[n] = buf[n] - buf[j];
                    ++j;
                }
                this.samplesRe.setData(destIndex * this.vectorStep, buf, 0, this.vectorLen);
                this.samplesIm.setData(destIndex * this.vectorStep, buf, this.vectorLen, this.vectorLen);
            }
            finally {
                DOUBLE_BUFFERS.releaseArray(buf);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(long destIndex, long srcIndex1, SampleArray src2, long srcIndex2) {
            ComplexDoubleVectorSampleArray a2 = (ComplexDoubleVectorSampleArray)src2;
            double[] buf = null;
            try {
                buf = (double[])DOUBLE_BUFFERS.requestArray();
                this.samplesRe.getData(srcIndex1 * this.vectorStep, buf, 0, this.vectorLen);
                this.samplesIm.getData(srcIndex1 * this.vectorStep, buf, this.vectorLen, this.vectorLen);
                a2.samplesRe.getData(srcIndex2 * this.vectorStep, buf, 2 * this.vectorLen, this.vectorLen);
                a2.samplesIm.getData(srcIndex2 * this.vectorStep, buf, 3 * this.vectorLen, this.vectorLen);
                int i = 0;
                int j = this.vectorLen2;
                while (i < this.vectorLen2) {
                    int n = i++;
                    buf[n] = buf[n] + buf[j];
                    ++j;
                }
                this.samplesRe.setData(destIndex * this.vectorStep, buf, 0, this.vectorLen);
                this.samplesIm.setData(destIndex * this.vectorStep, buf, this.vectorLen, this.vectorLen);
            }
            finally {
                DOUBLE_BUFFERS.releaseArray(buf);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sub(long destIndex, long srcIndex1, SampleArray src2, long srcIndex2) {
            ComplexDoubleVectorSampleArray a2 = (ComplexDoubleVectorSampleArray)src2;
            double[] buf = null;
            try {
                buf = (double[])DOUBLE_BUFFERS.requestArray();
                this.samplesRe.getData(srcIndex1 * this.vectorStep, buf, 0, this.vectorLen);
                this.samplesIm.getData(srcIndex1 * this.vectorStep, buf, this.vectorLen, this.vectorLen);
                a2.samplesRe.getData(srcIndex2 * this.vectorStep, buf, 2 * this.vectorLen, this.vectorLen);
                a2.samplesIm.getData(srcIndex2 * this.vectorStep, buf, 3 * this.vectorLen, this.vectorLen);
                int i = 0;
                int j = this.vectorLen2;
                while (i < this.vectorLen2) {
                    int n = i++;
                    buf[n] = buf[n] - buf[j];
                    ++j;
                }
                this.samplesRe.setData(destIndex * this.vectorStep, buf, 0, this.vectorLen);
                this.samplesIm.setData(destIndex * this.vectorStep, buf, this.vectorLen, this.vectorLen);
            }
            finally {
                DOUBLE_BUFFERS.releaseArray(buf);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(long destIndex, long srcIndex1, long srcIndex2) {
            double[] buf = null;
            try {
                buf = (double[])DOUBLE_BUFFERS.requestArray();
                this.samplesRe.getData(srcIndex1 * this.vectorStep, buf, 0, this.vectorLen);
                this.samplesIm.getData(srcIndex1 * this.vectorStep, buf, this.vectorLen, this.vectorLen);
                this.samplesRe.getData(srcIndex2 * this.vectorStep, buf, 2 * this.vectorLen, this.vectorLen);
                this.samplesIm.getData(srcIndex2 * this.vectorStep, buf, 3 * this.vectorLen, this.vectorLen);
                int i = 0;
                int j = this.vectorLen2;
                while (i < this.vectorLen2) {
                    int n = i++;
                    buf[n] = buf[n] + buf[j];
                    ++j;
                }
                this.samplesRe.setData(destIndex * this.vectorStep, buf, 0, this.vectorLen);
                this.samplesIm.setData(destIndex * this.vectorStep, buf, this.vectorLen, this.vectorLen);
            }
            finally {
                DOUBLE_BUFFERS.releaseArray(buf);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sub(long destIndex, long srcIndex1, long srcIndex2) {
            double[] buf = null;
            try {
                buf = (double[])DOUBLE_BUFFERS.requestArray();
                this.samplesRe.getData(srcIndex1 * this.vectorStep, buf, 0, this.vectorLen);
                this.samplesIm.getData(srcIndex1 * this.vectorStep, buf, this.vectorLen, this.vectorLen);
                this.samplesRe.getData(srcIndex2 * this.vectorStep, buf, 2 * this.vectorLen, this.vectorLen);
                this.samplesIm.getData(srcIndex2 * this.vectorStep, buf, 3 * this.vectorLen, this.vectorLen);
                int i = 0;
                int j = this.vectorLen2;
                while (i < this.vectorLen2) {
                    int n = i++;
                    buf[n] = buf[n] - buf[j];
                    ++j;
                }
                this.samplesRe.setData(destIndex * this.vectorStep, buf, 0, this.vectorLen);
                this.samplesIm.setData(destIndex * this.vectorStep, buf, this.vectorLen, this.vectorLen);
            }
            finally {
                DOUBLE_BUFFERS.releaseArray(buf);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void multiplyByScalar(long destIndex, SampleArray src, long srcIndex, double aRe, double aIm) {
            ComplexDoubleVectorSampleArray a = (ComplexDoubleVectorSampleArray)src;
            double[] buf = null;
            try {
                buf = (double[])DOUBLE_BUFFERS.requestArray();
                a.samplesRe.getData(srcIndex * this.vectorStep, buf, 0, this.vectorLen);
                a.samplesIm.getData(srcIndex * this.vectorStep, buf, this.vectorLen, this.vectorLen);
                int i = 0;
                int j = this.vectorLen;
                while (i < this.vectorLen) {
                    double re = buf[i] * aRe - buf[j] * aIm;
                    double im = buf[i] * aIm + buf[j] * aRe;
                    buf[i] = re;
                    buf[j] = im;
                    ++i;
                    ++j;
                }
                this.samplesRe.setData(destIndex * this.vectorStep, buf, 0, this.vectorLen);
                this.samplesIm.setData(destIndex * this.vectorStep, buf, this.vectorLen, this.vectorLen);
            }
            finally {
                DOUBLE_BUFFERS.releaseArray(buf);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void multiplyByRealScalar(long index, double a) {
            double[] buf = null;
            try {
                buf = (double[])DOUBLE_BUFFERS.requestArray();
                this.samplesRe.getData(index * this.vectorStep, buf, 0, this.vectorLen);
                this.samplesIm.getData(index * this.vectorStep, buf, this.vectorLen, this.vectorLen);
                for (int i = 0; i < this.vectorLen2; ++i) {
                    buf[i] = buf[i] * a;
                }
                this.samplesRe.setData(index * this.vectorStep, buf, 0, this.vectorLen);
                this.samplesIm.setData(index * this.vectorStep, buf, this.vectorLen, this.vectorLen);
            }
            finally {
                DOUBLE_BUFFERS.releaseArray(buf);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void combineWithRealMultipliers(long destIndex, long srcIndex1, double a1, long srcIndex2, double a2) {
            double[] buf = null;
            try {
                buf = (double[])DOUBLE_BUFFERS.requestArray();
                this.samplesRe.getData(srcIndex1 * this.vectorStep, buf, 0, this.vectorLen);
                this.samplesIm.getData(srcIndex1 * this.vectorStep, buf, this.vectorLen, this.vectorLen);
                this.samplesRe.getData(srcIndex2 * this.vectorStep, buf, 2 * this.vectorLen, this.vectorLen);
                this.samplesIm.getData(srcIndex2 * this.vectorStep, buf, 3 * this.vectorLen, this.vectorLen);
                int i = 0;
                int j = this.vectorLen2;
                while (i < this.vectorLen2) {
                    buf[i] = buf[i] * a1 + buf[j] * a2;
                    ++i;
                    ++j;
                }
                this.samplesRe.setData(destIndex * this.vectorStep, buf, 0, this.vectorLen);
                this.samplesIm.setData(destIndex * this.vectorStep, buf, this.vectorLen, this.vectorLen);
            }
            finally {
                DOUBLE_BUFFERS.releaseArray(buf);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void multiplyRangeByRealScalar(long fromIndex, long toIndex, double a) {
            double[] buf = null;
            try {
                buf = (double[])DOUBLE_BUFFERS.requestArray();
                for (long index = fromIndex; index < toIndex; ++index) {
                    this.samplesRe.getData(index * this.vectorStep, buf, 0, this.vectorLen);
                    this.samplesIm.getData(index * this.vectorStep, buf, this.vectorLen, this.vectorLen);
                    for (int i = 0; i < this.vectorLen2; ++i) {
                        buf[i] = buf[i] * a;
                    }
                    this.samplesRe.setData(index * this.vectorStep, buf, 0, this.vectorLen);
                    this.samplesIm.setData(index * this.vectorStep, buf, this.vectorLen, this.vectorLen);
                }
            }
            finally {
                DOUBLE_BUFFERS.releaseArray(buf);
            }
        }
    }

    static class CommonComplexVectorSampleArray
    extends ComplexVectorSampleArray {
        final MemoryModel mm;

        CommonComplexVectorSampleArray(MemoryModel memoryModel, UpdatablePNumberArray samplesRe, UpdatablePNumberArray samplesIm, long vectorLength, long vectorStep, long length) {
            super(samplesRe, samplesIm, vectorLength, vectorStep, length);
            assert (memoryModel != null);
            this.mm = memoryModel;
        }

        @Override
        public ComplexVectorSampleArray newCompatibleSamplesArray(long length) {
            if (length > Long.MAX_VALUE / this.vectorLength) {
                throw new TooLargeArrayException("Too large sample array: " + length + " vectors of " + this.vectorLength + " numbers");
            }
            return new CommonComplexVectorSampleArray(this.mm, (UpdatablePNumberArray)this.mm.newUnresizableArray(this.samplesRe.elementType(), length * this.vectorLength), (UpdatablePNumberArray)this.mm.newUnresizableArray(this.samplesIm.elementType(), length * this.vectorLength), this.vectorLength, this.vectorLength, length);
        }

        @Override
        public void add(long destIndex, SampleArray src, long srcIndex1, long srcIndex2) {
            CommonComplexVectorSampleArray a = (CommonComplexVectorSampleArray)src;
            Arrays.applyFunc(null, false, 1, true, Func.X_PLUS_Y, this.re(destIndex), a.re(srcIndex1), a.re(srcIndex2));
            Arrays.applyFunc(null, false, 1, true, Func.X_PLUS_Y, this.im(destIndex), a.im(srcIndex1), a.im(srcIndex2));
        }

        @Override
        public void sub(long destIndex, SampleArray src, long srcIndex1, long srcIndex2) {
            CommonComplexVectorSampleArray a = (CommonComplexVectorSampleArray)src;
            Arrays.applyFunc(null, false, 1, true, Func.X_MINUS_Y, this.re(destIndex), a.re(srcIndex1), a.re(srcIndex2));
            Arrays.applyFunc(null, false, 1, true, Func.X_MINUS_Y, this.im(destIndex), a.im(srcIndex1), a.im(srcIndex2));
        }

        @Override
        public void add(long destIndex, long srcIndex1, SampleArray src2, long srcIndex2) {
            CommonComplexVectorSampleArray a2 = (CommonComplexVectorSampleArray)src2;
            Arrays.applyFunc(null, false, 1, true, Func.X_PLUS_Y, this.re(destIndex), this.re(srcIndex1), a2.re(srcIndex2));
            Arrays.applyFunc(null, false, 1, true, Func.X_PLUS_Y, this.im(destIndex), this.im(srcIndex1), a2.im(srcIndex2));
        }

        @Override
        public void sub(long destIndex, long srcIndex1, SampleArray src2, long srcIndex2) {
            CommonComplexVectorSampleArray a2 = (CommonComplexVectorSampleArray)src2;
            Arrays.applyFunc(null, false, 1, true, Func.X_MINUS_Y, this.re(destIndex), this.re(srcIndex1), a2.re(srcIndex2));
            Arrays.applyFunc(null, false, 1, true, Func.X_MINUS_Y, this.im(destIndex), this.im(srcIndex1), a2.im(srcIndex2));
        }

        @Override
        public void add(long destIndex, long srcIndex1, long srcIndex2) {
            Arrays.applyFunc(null, false, 1, true, Func.X_PLUS_Y, this.re(destIndex), this.re(srcIndex1), this.re(srcIndex2));
            Arrays.applyFunc(null, false, 1, true, Func.X_PLUS_Y, this.im(destIndex), this.im(srcIndex1), this.im(srcIndex2));
        }

        @Override
        public void sub(long destIndex, long srcIndex1, long srcIndex2) {
            Arrays.applyFunc(null, false, 1, true, Func.X_MINUS_Y, this.re(destIndex), this.re(srcIndex1), this.re(srcIndex2));
            Arrays.applyFunc(null, false, 1, true, Func.X_MINUS_Y, this.im(destIndex), this.im(srcIndex1), this.im(srcIndex2));
        }

        @Override
        public void multiplyByScalar(long destIndex, SampleArray src, long srcIndex, double aRe, double aIm) {
            CommonComplexVectorSampleArray a = (CommonComplexVectorSampleArray)src;
            UpdatablePArray re = a.re(srcIndex);
            UpdatablePArray im = a.im(srcIndex);
            Arrays.applyFunc(null, false, 1, true, LinearFunc.getInstance(0.0, aRe, -aIm), this.re(destIndex), re, im);
            Arrays.applyFunc(null, false, 1, true, LinearFunc.getInstance(0.0, aIm, aRe), this.im(destIndex), re, im);
        }

        @Override
        public void combineWithRealMultipliers(long destIndex, long srcIndex1, double a1, long srcIndex2, double a2) {
            Arrays.applyFunc(null, false, 1, true, LinearFunc.getInstance(0.0, a1, a2), this.re(destIndex), this.re(srcIndex1), this.re(srcIndex2));
            Arrays.applyFunc(null, false, 1, true, LinearFunc.getInstance(0.0, a1, a2), this.im(destIndex), this.im(srcIndex1), this.im(srcIndex2));
        }

        @Override
        public void multiplyByRealScalar(long index, double a) {
            UpdatablePArray re = this.re(index);
            UpdatablePArray im = this.im(index);
            Arrays.applyFunc(null, false, 1, true, LinearFunc.getInstance(0.0, a), re, re);
            Arrays.applyFunc(null, false, 1, true, LinearFunc.getInstance(0.0, a), im, im);
        }

        @Override
        public void multiplyRangeByRealScalar(long fromIndex, long toIndex, double a) {
            for (long index = fromIndex; index < toIndex; ++index) {
                this.multiplyByRealScalar(index, a);
            }
        }
    }
}

