/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.spectra;

import java.util.Objects;
import net.algart.arrays.Arrays;
import net.algart.arrays.DirectAccessible;
import net.algart.arrays.UpdatablePNumberArray;
import net.algart.matrices.spectra.SampleArray;

public abstract class RealScalarSampleArray
implements SampleArray {
    public static RealScalarSampleArray asSampleArray(UpdatablePNumberArray samples) {
        Objects.requireNonNull(samples, "Null samples");
        samples = (UpdatablePNumberArray)samples.asUnresizable();
        if (samples instanceof DirectAccessible && ((DirectAccessible)((Object)samples)).hasJavaArray()) {
            Object arr = ((DirectAccessible)((Object)samples)).javaArray();
            int ofs = ((DirectAccessible)((Object)samples)).javaArrayOffset();
            if (arr instanceof float[]) {
                if (ofs == 0) {
                    return new DirectZeroOffsetsRealFloatSampleArray((float[])arr, (int)samples.length());
                }
                return new DirectRealFloatSampleArray((float[])arr, ofs, (int)samples.length());
            }
            if (arr instanceof double[]) {
                if (ofs == 0) {
                    return new DirectZeroOffsetsRealDoubleSampleArray((double[])arr, (int)samples.length());
                }
                return new DirectRealDoubleSampleArray((double[])arr, ofs, (int)samples.length());
            }
        }
        return new CommonRealScalarSampleArray(samples);
    }

    @Override
    public final boolean isComplex() {
        return false;
    }

    @Override
    public abstract long length();

    @Override
    public abstract RealScalarSampleArray newCompatibleSamplesArray(long var1);

    @Override
    public abstract void copy(long var1, SampleArray var3, long var4);

    @Override
    public abstract void swap(long var1, long var3);

    @Override
    public abstract void add(long var1, SampleArray var3, long var4, long var6);

    @Override
    public abstract void sub(long var1, SampleArray var3, long var4, long var6);

    @Override
    public abstract void add(long var1, long var3, SampleArray var5, long var6);

    @Override
    public abstract void sub(long var1, long var3, SampleArray var5, long var6);

    @Override
    public abstract void add(long var1, long var3, long var5);

    @Override
    public abstract void sub(long var1, long var3, long var5);

    @Override
    public abstract void multiplyByScalar(long var1, SampleArray var3, long var4, double var6, double var8);

    @Override
    public abstract void multiplyByRealScalar(long var1, double var3);

    @Override
    public abstract void combineWithRealMultipliers(long var1, long var3, double var5, long var7, double var9);

    @Override
    public abstract void multiplyRangeByRealScalar(long var1, long var3, double var5);

    @Override
    public abstract String toString(String var1, String var2, int var3);

    static final class DirectZeroOffsetsRealFloatSampleArray
    extends RealScalarSampleArray {
        final float[] samples;
        final int length;

        DirectZeroOffsetsRealFloatSampleArray(float[] samples, int length) {
            assert (length >= 0);
            assert (length <= samples.length);
            this.samples = samples;
            this.length = length;
        }

        @Override
        public long length() {
            return this.length;
        }

        @Override
        public RealScalarSampleArray newCompatibleSamplesArray(long length) {
            if (length < 0L) {
                throw new IllegalArgumentException("Negative length");
            }
            if (length > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("length must be less than 2^31");
            }
            int len = (int)length;
            return new DirectZeroOffsetsRealFloatSampleArray(new float[len], len);
        }

        @Override
        public void copy(long destIndex, SampleArray src, long srcIndex) {
            DirectZeroOffsetsRealFloatSampleArray a = (DirectZeroOffsetsRealFloatSampleArray)src;
            this.samples[(int)destIndex] = a.samples[(int)srcIndex];
        }

        @Override
        public void swap(long firstIndex, long secondIndex) {
            float temp = this.samples[(int)firstIndex];
            this.samples[(int)firstIndex] = this.samples[(int)secondIndex];
            this.samples[(int)secondIndex] = temp;
        }

        @Override
        public void add(long destIndex, SampleArray src, long srcIndex1, long srcIndex2) {
            DirectZeroOffsetsRealFloatSampleArray a = (DirectZeroOffsetsRealFloatSampleArray)src;
            this.samples[(int)destIndex] = a.samples[(int)srcIndex1] + a.samples[(int)srcIndex2];
        }

        @Override
        public void sub(long destIndex, SampleArray src, long srcIndex1, long srcIndex2) {
            DirectZeroOffsetsRealFloatSampleArray a = (DirectZeroOffsetsRealFloatSampleArray)src;
            this.samples[(int)destIndex] = a.samples[(int)srcIndex1] - a.samples[(int)srcIndex2];
        }

        @Override
        public void add(long destIndex, long srcIndex1, SampleArray src2, long srcIndex2) {
            DirectZeroOffsetsRealFloatSampleArray a2 = (DirectZeroOffsetsRealFloatSampleArray)src2;
            this.samples[(int)destIndex] = this.samples[(int)srcIndex1] + a2.samples[(int)srcIndex2];
        }

        @Override
        public void sub(long destIndex, long srcIndex1, SampleArray src2, long srcIndex2) {
            DirectZeroOffsetsRealFloatSampleArray a2 = (DirectZeroOffsetsRealFloatSampleArray)src2;
            this.samples[(int)destIndex] = this.samples[(int)srcIndex1] - a2.samples[(int)srcIndex2];
        }

        @Override
        public void add(long destIndex, long srcIndex1, long srcIndex2) {
            this.samples[(int)destIndex] = this.samples[(int)srcIndex1] + this.samples[(int)srcIndex2];
        }

        @Override
        public void sub(long destIndex, long srcIndex1, long srcIndex2) {
            this.samples[(int)destIndex] = this.samples[(int)srcIndex1] - this.samples[(int)srcIndex2];
        }

        @Override
        public void multiplyByScalar(long destIndex, SampleArray src, long srcIndex, double aRe, double aIm) {
            DirectZeroOffsetsRealFloatSampleArray a = (DirectZeroOffsetsRealFloatSampleArray)src;
            double re = a.samples[(int)srcIndex];
            this.samples[(int)destIndex] = (float)(re * aRe);
        }

        @Override
        public void multiplyByRealScalar(long index, double a) {
            float v = this.samples[(int)index];
            this.samples[(int)index] = (float)((double)v * a);
        }

        @Override
        public void combineWithRealMultipliers(long destIndex, long srcIndex1, double a1, long srcIndex2, double a2) {
            int destI = (int)destIndex;
            int srcI1 = (int)srcIndex1;
            int srcI2 = (int)srcIndex2;
            this.samples[destI] = (float)((double)this.samples[srcI1] * a1 + (double)this.samples[srcI2] * a2);
        }

        @Override
        public void multiplyRangeByRealScalar(long fromIndex, long toIndex, double a) {
            int from = (int)fromIndex;
            int to = (int)toIndex;
            for (int index = from; index < to; ++index) {
                float v = this.samples[index];
                this.samples[index] = (float)((double)v * a);
            }
        }

        @Override
        public String toString(String format, String separator, int maxStringLength) {
            Objects.requireNonNull(format, "Null format argument");
            Objects.requireNonNull(separator, "Null separator argument");
            if (maxStringLength <= 0) {
                throw new IllegalArgumentException("maxStringLength argument must be positive");
            }
            if (this.length == 0) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            sb.append(String.format(format, Float.valueOf(this.samples[0])));
            for (int k = 1; k < this.samples.length; ++k) {
                if (sb.length() >= maxStringLength) {
                    sb.append(separator).append("...");
                    break;
                }
                sb.append(separator).append(String.format(format, Float.valueOf(this.samples[k])));
            }
            return sb.toString();
        }
    }

    static final class DirectRealFloatSampleArray
    extends RealScalarSampleArray {
        final float[] samples;
        final int ofs;
        final int length;

        DirectRealFloatSampleArray(float[] samples, int ofs, int length) {
            assert (ofs >= 0);
            assert (length >= 0);
            assert (ofs <= samples.length - length);
            this.samples = samples;
            this.ofs = ofs;
            this.length = length;
        }

        @Override
        public long length() {
            return this.length;
        }

        @Override
        public RealScalarSampleArray newCompatibleSamplesArray(long length) {
            if (length < 0L) {
                throw new IllegalArgumentException("Negative length");
            }
            if (length > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("length must be less than 2^31");
            }
            int len = (int)length;
            return new DirectRealFloatSampleArray(new float[len], 0, len);
        }

        @Override
        public void copy(long destIndex, SampleArray src, long srcIndex) {
            DirectRealFloatSampleArray a = (DirectRealFloatSampleArray)src;
            this.samples[this.ofs + (int)destIndex] = a.samples[a.ofs + (int)srcIndex];
        }

        @Override
        public void swap(long firstIndex, long secondIndex) {
            float temp = this.samples[this.ofs + (int)firstIndex];
            this.samples[this.ofs + (int)firstIndex] = this.samples[this.ofs + (int)secondIndex];
            this.samples[this.ofs + (int)secondIndex] = temp;
        }

        @Override
        public void add(long destIndex, SampleArray src, long srcIndex1, long srcIndex2) {
            DirectRealFloatSampleArray a = (DirectRealFloatSampleArray)src;
            this.samples[this.ofs + (int)destIndex] = a.samples[a.ofs + (int)srcIndex1] + a.samples[a.ofs + (int)srcIndex2];
        }

        @Override
        public void sub(long destIndex, SampleArray src, long srcIndex1, long srcIndex2) {
            DirectRealFloatSampleArray a = (DirectRealFloatSampleArray)src;
            this.samples[this.ofs + (int)destIndex] = a.samples[a.ofs + (int)srcIndex1] - a.samples[a.ofs + (int)srcIndex2];
        }

        @Override
        public void add(long destIndex, long srcIndex1, SampleArray src2, long srcIndex2) {
            DirectRealFloatSampleArray a2 = (DirectRealFloatSampleArray)src2;
            this.samples[this.ofs + (int)destIndex] = this.samples[this.ofs + (int)srcIndex1] + a2.samples[a2.ofs + (int)srcIndex2];
        }

        @Override
        public void sub(long destIndex, long srcIndex1, SampleArray src2, long srcIndex2) {
            DirectRealFloatSampleArray a2 = (DirectRealFloatSampleArray)src2;
            this.samples[this.ofs + (int)destIndex] = this.samples[this.ofs + (int)srcIndex1] - a2.samples[a2.ofs + (int)srcIndex2];
        }

        @Override
        public void add(long destIndex, long srcIndex1, long srcIndex2) {
            this.samples[this.ofs + (int)destIndex] = this.samples[this.ofs + (int)srcIndex1] + this.samples[this.ofs + (int)srcIndex2];
        }

        @Override
        public void sub(long destIndex, long srcIndex1, long srcIndex2) {
            this.samples[this.ofs + (int)destIndex] = this.samples[this.ofs + (int)srcIndex1] - this.samples[this.ofs + (int)srcIndex2];
        }

        @Override
        public void multiplyByScalar(long destIndex, SampleArray src, long srcIndex, double aRe, double aIm) {
            DirectRealFloatSampleArray a = (DirectRealFloatSampleArray)src;
            double re = a.samples[a.ofs + (int)srcIndex];
            this.samples[this.ofs + (int)destIndex] = (float)(re * aRe);
        }

        @Override
        public void multiplyByRealScalar(long index, double a) {
            double re = this.samples[this.ofs + (int)index];
            this.samples[this.ofs + (int)index] = (float)(re * a);
        }

        @Override
        public void combineWithRealMultipliers(long destIndex, long srcIndex1, double a1, long srcIndex2, double a2) {
            int destI = (int)destIndex;
            int srcI1 = (int)srcIndex1;
            int srcI2 = (int)srcIndex2;
            this.samples[this.ofs + destI] = (float)((double)this.samples[this.ofs + srcI1] * a1 + (double)this.samples[this.ofs + srcI2] * a2);
        }

        @Override
        public void multiplyRangeByRealScalar(long fromIndex, long toIndex, double a) {
            int index;
            int indexMax = index + (int)(toIndex - fromIndex);
            for (index = this.ofs + (int)fromIndex; index < indexMax; ++index) {
                this.samples[index] = (float)((double)this.samples[index] * a);
            }
        }

        @Override
        public String toString(String format, String separator, int maxStringLength) {
            Objects.requireNonNull(format, "Null format argument");
            Objects.requireNonNull(separator, "Null separator argument");
            if (maxStringLength <= 0) {
                throw new IllegalArgumentException("maxStringLength argument must be positive");
            }
            if (this.length == 0) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            sb.append(String.format(format, Float.valueOf(this.samples[this.ofs])));
            for (int k = 1; k < this.length; ++k) {
                if (sb.length() >= maxStringLength) {
                    sb.append(separator).append("...");
                    break;
                }
                sb.append(separator).append(String.format(format, Float.valueOf(this.samples[this.ofs + k])));
            }
            return sb.toString();
        }
    }

    static final class DirectZeroOffsetsRealDoubleSampleArray
    extends RealScalarSampleArray {
        final double[] samples;
        final int length;

        DirectZeroOffsetsRealDoubleSampleArray(double[] samples, int length) {
            assert (length >= 0);
            assert (length <= samples.length);
            this.samples = samples;
            this.length = length;
        }

        @Override
        public long length() {
            return this.length;
        }

        @Override
        public RealScalarSampleArray newCompatibleSamplesArray(long length) {
            if (length < 0L) {
                throw new IllegalArgumentException("Negative length");
            }
            if (length > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("length must be less than 2^31");
            }
            int len = (int)length;
            return new DirectZeroOffsetsRealDoubleSampleArray(new double[len], len);
        }

        @Override
        public void copy(long destIndex, SampleArray src, long srcIndex) {
            DirectZeroOffsetsRealDoubleSampleArray a = (DirectZeroOffsetsRealDoubleSampleArray)src;
            this.samples[(int)destIndex] = a.samples[(int)srcIndex];
        }

        @Override
        public void swap(long firstIndex, long secondIndex) {
            double temp = this.samples[(int)firstIndex];
            this.samples[(int)firstIndex] = this.samples[(int)secondIndex];
            this.samples[(int)secondIndex] = temp;
        }

        @Override
        public void add(long destIndex, SampleArray src, long srcIndex1, long srcIndex2) {
            DirectZeroOffsetsRealDoubleSampleArray a = (DirectZeroOffsetsRealDoubleSampleArray)src;
            this.samples[(int)destIndex] = a.samples[(int)srcIndex1] + a.samples[(int)srcIndex2];
        }

        @Override
        public void sub(long destIndex, SampleArray src, long srcIndex1, long srcIndex2) {
            DirectZeroOffsetsRealDoubleSampleArray a = (DirectZeroOffsetsRealDoubleSampleArray)src;
            this.samples[(int)destIndex] = a.samples[(int)srcIndex1] - a.samples[(int)srcIndex2];
        }

        @Override
        public void add(long destIndex, long srcIndex1, SampleArray src2, long srcIndex2) {
            DirectZeroOffsetsRealDoubleSampleArray a2 = (DirectZeroOffsetsRealDoubleSampleArray)src2;
            this.samples[(int)destIndex] = this.samples[(int)srcIndex1] + a2.samples[(int)srcIndex2];
        }

        @Override
        public void sub(long destIndex, long srcIndex1, SampleArray src2, long srcIndex2) {
            DirectZeroOffsetsRealDoubleSampleArray a2 = (DirectZeroOffsetsRealDoubleSampleArray)src2;
            this.samples[(int)destIndex] = this.samples[(int)srcIndex1] - a2.samples[(int)srcIndex2];
        }

        @Override
        public void add(long destIndex, long srcIndex1, long srcIndex2) {
            this.samples[(int)destIndex] = this.samples[(int)srcIndex1] + this.samples[(int)srcIndex2];
        }

        @Override
        public void sub(long destIndex, long srcIndex1, long srcIndex2) {
            this.samples[(int)destIndex] = this.samples[(int)srcIndex1] - this.samples[(int)srcIndex2];
        }

        @Override
        public void multiplyByScalar(long destIndex, SampleArray src, long srcIndex, double aRe, double aIm) {
            DirectZeroOffsetsRealDoubleSampleArray a = (DirectZeroOffsetsRealDoubleSampleArray)src;
            double re = a.samples[(int)srcIndex];
            this.samples[(int)destIndex] = re * aRe;
        }

        @Override
        public void multiplyByRealScalar(long index, double a) {
            double v = this.samples[(int)index];
            this.samples[(int)index] = v * a;
        }

        @Override
        public void combineWithRealMultipliers(long destIndex, long srcIndex1, double a1, long srcIndex2, double a2) {
            int destI = (int)destIndex;
            int srcI1 = (int)srcIndex1;
            int srcI2 = (int)srcIndex2;
            this.samples[destI] = this.samples[srcI1] * a1 + this.samples[srcI2] * a2;
        }

        @Override
        public void multiplyRangeByRealScalar(long fromIndex, long toIndex, double a) {
            int from = (int)fromIndex;
            int to = (int)toIndex;
            for (int index = from; index < to; ++index) {
                double v = this.samples[index];
                this.samples[index] = v * a;
            }
        }

        @Override
        public String toString(String format, String separator, int maxStringLength) {
            Objects.requireNonNull(format, "Null format argument");
            Objects.requireNonNull(separator, "Null separator argument");
            if (maxStringLength <= 0) {
                throw new IllegalArgumentException("maxStringLength argument must be positive");
            }
            if (this.length == 0) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            sb.append(String.format(format, this.samples[0]));
            for (int k = 1; k < this.samples.length; ++k) {
                if (sb.length() >= maxStringLength) {
                    sb.append(separator).append("...");
                    break;
                }
                sb.append(separator).append(String.format(format, this.samples[k]));
            }
            return sb.toString();
        }
    }

    static final class DirectRealDoubleSampleArray
    extends RealScalarSampleArray {
        final double[] samples;
        final int ofs;
        final int length;

        DirectRealDoubleSampleArray(double[] samples, int ofs, int length) {
            assert (ofs >= 0);
            assert (length >= 0);
            assert (ofs <= samples.length - length);
            this.samples = samples;
            this.ofs = ofs;
            this.length = length;
        }

        @Override
        public long length() {
            return this.length;
        }

        @Override
        public RealScalarSampleArray newCompatibleSamplesArray(long length) {
            if (length < 0L) {
                throw new IllegalArgumentException("Negative length");
            }
            if (length > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("length must be less than 2^31");
            }
            int len = (int)length;
            return new DirectRealDoubleSampleArray(new double[len], 0, len);
        }

        @Override
        public void copy(long destIndex, SampleArray src, long srcIndex) {
            DirectRealDoubleSampleArray a = (DirectRealDoubleSampleArray)src;
            this.samples[this.ofs + (int)destIndex] = a.samples[a.ofs + (int)srcIndex];
        }

        @Override
        public void swap(long firstIndex, long secondIndex) {
            double temp = this.samples[this.ofs + (int)firstIndex];
            this.samples[this.ofs + (int)firstIndex] = this.samples[this.ofs + (int)secondIndex];
            this.samples[this.ofs + (int)secondIndex] = temp;
        }

        @Override
        public void add(long destIndex, SampleArray src, long srcIndex1, long srcIndex2) {
            DirectRealDoubleSampleArray a = (DirectRealDoubleSampleArray)src;
            this.samples[this.ofs + (int)destIndex] = a.samples[a.ofs + (int)srcIndex1] + a.samples[a.ofs + (int)srcIndex2];
        }

        @Override
        public void sub(long destIndex, SampleArray src, long srcIndex1, long srcIndex2) {
            DirectRealDoubleSampleArray a = (DirectRealDoubleSampleArray)src;
            this.samples[this.ofs + (int)destIndex] = a.samples[a.ofs + (int)srcIndex1] - a.samples[a.ofs + (int)srcIndex2];
        }

        @Override
        public void add(long destIndex, long srcIndex1, SampleArray src2, long srcIndex2) {
            DirectRealDoubleSampleArray a2 = (DirectRealDoubleSampleArray)src2;
            this.samples[this.ofs + (int)destIndex] = this.samples[this.ofs + (int)srcIndex1] + a2.samples[a2.ofs + (int)srcIndex2];
        }

        @Override
        public void sub(long destIndex, long srcIndex1, SampleArray src2, long srcIndex2) {
            DirectRealDoubleSampleArray a2 = (DirectRealDoubleSampleArray)src2;
            this.samples[this.ofs + (int)destIndex] = this.samples[this.ofs + (int)srcIndex1] - a2.samples[a2.ofs + (int)srcIndex2];
        }

        @Override
        public void add(long destIndex, long srcIndex1, long srcIndex2) {
            this.samples[this.ofs + (int)destIndex] = this.samples[this.ofs + (int)srcIndex1] + this.samples[this.ofs + (int)srcIndex2];
        }

        @Override
        public void sub(long destIndex, long srcIndex1, long srcIndex2) {
            this.samples[this.ofs + (int)destIndex] = this.samples[this.ofs + (int)srcIndex1] - this.samples[this.ofs + (int)srcIndex2];
        }

        @Override
        public void multiplyByScalar(long destIndex, SampleArray src, long srcIndex, double aRe, double aIm) {
            DirectRealDoubleSampleArray a = (DirectRealDoubleSampleArray)src;
            double re = a.samples[a.ofs + (int)srcIndex];
            this.samples[this.ofs + (int)destIndex] = re * aRe;
        }

        @Override
        public void multiplyByRealScalar(long index, double a) {
            double re = this.samples[this.ofs + (int)index];
            this.samples[this.ofs + (int)index] = re * a;
        }

        @Override
        public void combineWithRealMultipliers(long destIndex, long srcIndex1, double a1, long srcIndex2, double a2) {
            int destI = (int)destIndex;
            int srcI1 = (int)srcIndex1;
            int srcI2 = (int)srcIndex2;
            this.samples[this.ofs + destI] = this.samples[this.ofs + srcI1] * a1 + this.samples[this.ofs + srcI2] * a2;
        }

        @Override
        public void multiplyRangeByRealScalar(long fromIndex, long toIndex, double a) {
            int index;
            int indexMax = index + (int)(toIndex - fromIndex);
            for (index = this.ofs + (int)fromIndex; index < indexMax; ++index) {
                this.samples[index] = this.samples[index] * a;
            }
        }

        @Override
        public String toString(String format, String separator, int maxStringLength) {
            Objects.requireNonNull(format, "Null format argument");
            Objects.requireNonNull(separator, "Null separator argument");
            if (maxStringLength <= 0) {
                throw new IllegalArgumentException("maxStringLength argument must be positive");
            }
            if (this.length == 0) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            sb.append(String.format(format, this.samples[this.ofs]));
            for (int k = 1; k < this.length; ++k) {
                if (sb.length() >= maxStringLength) {
                    sb.append(separator).append("...");
                    break;
                }
                sb.append(separator).append(String.format(format, this.samples[this.ofs + k]));
            }
            return sb.toString();
        }
    }

    static final class CommonRealScalarSampleArray
    extends RealScalarSampleArray {
        private final UpdatablePNumberArray samples;

        CommonRealScalarSampleArray(UpdatablePNumberArray samples) {
            Objects.requireNonNull(samples, "Null samples");
            this.samples = samples;
        }

        @Override
        public long length() {
            return this.samples.length();
        }

        @Override
        public RealScalarSampleArray newCompatibleSamplesArray(long length) {
            return new CommonRealScalarSampleArray((UpdatablePNumberArray)Arrays.SMM.newUnresizableArray(this.samples));
        }

        @Override
        public void copy(long destIndex, SampleArray src, long srcIndex) {
            CommonRealScalarSampleArray a = (CommonRealScalarSampleArray)src;
            this.samples.setDouble(destIndex, a.samples.getDouble(srcIndex));
        }

        @Override
        public void swap(long firstIndex, long secondIndex) {
            this.samples.swap(firstIndex, secondIndex);
        }

        @Override
        public void add(long destIndex, SampleArray src, long srcIndex1, long srcIndex2) {
            CommonRealScalarSampleArray a = (CommonRealScalarSampleArray)src;
            this.samples.setDouble(destIndex, a.samples.getDouble(srcIndex1) + a.samples.getDouble(srcIndex2));
        }

        @Override
        public void sub(long destIndex, SampleArray src, long srcIndex1, long srcIndex2) {
            CommonRealScalarSampleArray a = (CommonRealScalarSampleArray)src;
            this.samples.setDouble(destIndex, a.samples.getDouble(srcIndex1) - a.samples.getDouble(srcIndex2));
        }

        @Override
        public void add(long destIndex, long srcIndex1, SampleArray src2, long srcIndex2) {
            CommonRealScalarSampleArray a2 = (CommonRealScalarSampleArray)src2;
            this.samples.setDouble(destIndex, this.samples.getDouble(srcIndex1) + a2.samples.getDouble(srcIndex2));
        }

        @Override
        public void sub(long destIndex, long srcIndex1, SampleArray src2, long srcIndex2) {
            CommonRealScalarSampleArray a2 = (CommonRealScalarSampleArray)src2;
            this.samples.setDouble(destIndex, this.samples.getDouble(srcIndex1) - a2.samples.getDouble(srcIndex2));
        }

        @Override
        public void add(long destIndex, long srcIndex1, long srcIndex2) {
            this.samples.setDouble(destIndex, this.samples.getDouble(srcIndex1) + this.samples.getDouble(srcIndex2));
        }

        @Override
        public void sub(long destIndex, long srcIndex1, long srcIndex2) {
            this.samples.setDouble(destIndex, this.samples.getDouble(srcIndex1) - this.samples.getDouble(srcIndex2));
        }

        @Override
        public void multiplyByScalar(long destIndex, SampleArray src, long srcIndex, double aRe, double aIm) {
            CommonRealScalarSampleArray a = (CommonRealScalarSampleArray)src;
            double re = a.samples.getDouble(srcIndex);
            this.samples.setDouble(destIndex, re * aRe);
        }

        @Override
        public void multiplyByRealScalar(long index, double a) {
            this.samples.setDouble(index, this.samples.getDouble(index) * a);
        }

        @Override
        public void multiplyRangeByRealScalar(long fromIndex, long toIndex, double a) {
            for (long index = fromIndex; index < toIndex; ++index) {
                this.samples.setDouble(index, this.samples.getDouble(index) * a);
            }
        }

        @Override
        public void combineWithRealMultipliers(long destIndex, long srcIndex1, double a1, long srcIndex2, double a2) {
            this.samples.setDouble(destIndex, this.samples.getDouble(srcIndex1) * a1 + this.samples.getDouble(srcIndex2) * a2);
        }

        @Override
        public String toString(String format, String separator, int maxStringLength) {
            Objects.requireNonNull(format, "Null format argument");
            Objects.requireNonNull(separator, "Null separator argument");
            if (maxStringLength <= 0) {
                throw new IllegalArgumentException("maxStringLength argument must be positive");
            }
            long n = this.samples.length();
            if (n == 0L) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            sb.append(String.format(format, this.samples.getDouble(0L)));
            for (long k = 1L; k < n; ++k) {
                if (sb.length() >= maxStringLength) {
                    sb.append(separator).append("...");
                    break;
                }
                sb.append(separator).append(String.format(format, this.samples.getDouble(k)));
            }
            return sb.toString();
        }
    }
}

