/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.spectra;

import net.algart.arrays.ArrayContext;
import net.algart.matrices.spectra.SampleArray;

class ReverseBits {
    static final int[] REVERSE_16 = new int[65536];

    ReverseBits() {
    }

    public static long reverseBits64(long v) {
        return (long)REVERSE_16[(int)(v >>> 48)] | (long)REVERSE_16[(int)(v >>> 32) & 0xFFFF] << 16 | (long)REVERSE_16[(int)(v >>> 16) & 0xFFFF] << 32 | (long)REVERSE_16[(int)v & 0xFFFF] << 48;
    }

    public static int reverseBits32(int v) {
        return REVERSE_16[v >>> 16] | REVERSE_16[v & 0xFFFF] << 16;
    }

    public static void reorderForButterfly(ArrayContext context, SampleArray samples) {
        long n = samples.length();
        if ((n & n - 1L) != 0L) {
            throw new IllegalArgumentException("The length of sample " + n + " is not 2^k");
        }
        int numberOfLeadingZeros = Long.numberOfLeadingZeros(n);
        if (n <= Integer.MAX_VALUE) {
            int shift = numberOfLeadingZeros - 31;
            int i = 1;
            int m = (int)n - 1;
            while (i < m) {
                int iMax;
                int n2 = iMax = i > m - 1024 ? m : i + 1024;
                while (i < iMax) {
                    int j = (REVERSE_16[i >>> 16] | REVERSE_16[i & 0xFFFF] << 16) >>> shift;
                    if (i < j) {
                        samples.swap(i, j);
                    }
                    ++i;
                }
                if (context == null) continue;
                context.checkInterruptionAndUpdateProgress(null, iMax, m);
            }
        } else {
            int shift = numberOfLeadingZeros + 1;
            long i = 1L;
            long m = n - 1L;
            while (i < m) {
                long iMax;
                long l = iMax = i > m - 65536L ? m : i + 65536L;
                while (i < iMax) {
                    long j = Long.reverse(i) >>> shift;
                    if (i < j) {
                        samples.swap(i, j);
                    }
                    ++i;
                }
                if (context == null) continue;
                context.checkInterruptionAndUpdateProgress(null, iMax, m);
            }
        }
    }

    static {
        ReverseBits.REVERSE_16[0] = 0;
        for (int k = 0; k < 65536; ++k) {
            ReverseBits.REVERSE_16[k] = Integer.reverse(k) >>> 16;
        }
    }
}

