/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.stitching;

import net.algart.math.functions.Func;

public class LastExceptingNaN
implements Func {
    private final double defaultValue;

    private LastExceptingNaN(double defaultValue) {
        this.defaultValue = defaultValue;
    }

    public static LastExceptingNaN getInstance(double defaultValue) {
        return new LastExceptingNaN(defaultValue);
    }

    @Override
    public double get(double ... x) {
        for (int k = x.length - 1; k >= 0; --k) {
            if (x[k] != x[k]) continue;
            return x[k];
        }
        return this.defaultValue;
    }

    @Override
    public double get() {
        return this.defaultValue;
    }

    @Override
    public double get(double x0) {
        return x0 == x0 ? x0 : this.defaultValue;
    }

    @Override
    public double get(double x0, double x1) {
        if (x1 == x1) {
            return x1;
        }
        if (x0 == x0) {
            return x0;
        }
        return this.defaultValue;
    }

    @Override
    public double get(double x0, double x1, double x2) {
        if (x2 == x2) {
            return x2;
        }
        if (x1 == x1) {
            return x1;
        }
        if (x0 == x0) {
            return x0;
        }
        return this.defaultValue;
    }

    @Override
    public double get(double x0, double x1, double x2, double x3) {
        if (x3 == x3) {
            return x3;
        }
        if (x2 == x2) {
            return x2;
        }
        if (x1 == x1) {
            return x1;
        }
        if (x0 == x0) {
            return x0;
        }
        return this.defaultValue;
    }

    public String toString() {
        return "last not-NaN argument";
    }
}

