/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.stitching;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.Arrays;
import net.algart.arrays.DoubleArray;
import net.algart.arrays.IntArray;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.math.IPoint;
import net.algart.math.Point;
import net.algart.math.RectangularArea;
import net.algart.math.functions.ConstantFunc;
import net.algart.math.functions.Func;
import net.algart.math.functions.LinearOperator;
import net.algart.matrices.stitching.CoordinateFreeStitchingMethod;
import net.algart.matrices.stitching.DefaultFrame;
import net.algart.matrices.stitching.Frame;
import net.algart.matrices.stitching.FramePosition;
import net.algart.matrices.stitching.ShiftFramePosition;
import net.algart.matrices.stitching.StitchingFunc;
import net.algart.matrices.stitching.StitchingMethod;
import net.algart.matrices.stitching.UniversalFramePosition;

public class Stitcher<P extends FramePosition> {
    private static final double[] EMPTY_DOUBLES = new double[0];
    private static final double MIN_USED_PART_FOR_PRELOADING = 0.3;
    private final int dimCount;
    private final StitchingMethod<P> stitchingMethod;
    private final List<Frame<P>> frames;

    private Stitcher(int dimCount, StitchingMethod<P> stitchingMethod, List<? extends Frame<P>> frames) {
        Objects.requireNonNull(stitchingMethod, "Null stitchingMethod argument");
        if (dimCount <= 0) {
            throw new IllegalArgumentException("Zero or negative dimCount argument = " + dimCount);
        }
        this.dimCount = dimCount;
        this.stitchingMethod = stitchingMethod;
        this.frames = new ArrayList<Frame<P>>(frames);
        Stitcher.checkFrameDimensions(dimCount, this.frames);
    }

    public static <P extends FramePosition> Stitcher<P> getInstance(int dimCount, StitchingMethod<P> stitchingMethod, List<? extends Frame<P>> frames) {
        return new Stitcher<P>(dimCount, stitchingMethod, frames);
    }

    public final int dimCount() {
        return this.dimCount;
    }

    public final StitchingMethod<P> stitchingMethod() {
        return this.stitchingMethod;
    }

    public List<Frame<P>> frames() {
        return Collections.unmodifiableList(this.frames);
    }

    public Stitcher<P> frames(List<? extends Frame<P>> newFrames) {
        return new Stitcher<P>(this.dimCount, this.stitchingMethod, newFrames);
    }

    public List<Frame<P>> actualFrames(RectangularArea area) {
        Objects.requireNonNull(area, "Null area argument");
        if (area.coordCount() != this.dimCount) {
            throw new IllegalArgumentException("Illegal number of dimensions in area argument: " + area.coordCount() + " instead of " + this.dimCount);
        }
        ArrayList<Frame<P>> result = new ArrayList<Frame<P>>();
        for (Frame<P> frame : this.frames) {
            if (!frame.position().area().overlaps(area)) continue;
            result.add(frame);
        }
        return result;
    }

    public <T extends PArray> Matrix<T> asStitched(Class<? extends T> requiredType, RectangularArea area) {
        Object localOffset;
        Point o;
        boolean integerShiftPositions;
        Objects.requireNonNull(requiredType, "Null requiredType argument");
        List<Frame<P>> actualFrames = this.actualFrames(area);
        boolean shiftPositions = Stitcher.shiftPositions(actualFrames);
        boolean bl = integerShiftPositions = shiftPositions && Stitcher.integerOffsets(actualFrames, area.min());
        if (shiftPositions) {
            ArrayList<Frame<P>> shiftedFrames = new ArrayList<Frame<P>>();
            for (Frame<P> frame : actualFrames) {
                Matrix<PArray> m = frame.matrix();
                RectangularArea shiftedArea = frame.position().area().shift(area.min().symmetric());
                P position = this.castPosition(ShiftFramePosition.valueOf(shiftedArea));
                shiftedFrames.add(DefaultFrame.valueOf(m, position));
            }
            actualFrames = shiftedFrames;
            area = RectangularArea.valueOf(Point.origin(this.dimCount), area.size());
        }
        long[] dimensions = area.size().toIntegerPoint().coordinates();
        if (actualFrames.isEmpty() && this.stitchingMethod.simpleBehaviorForEmptySpace()) {
            return Matrices.asCoordFuncMatrix(ConstantFunc.getInstance(this.outsideValue(actualFrames)), requiredType, dimensions);
        }
        if (actualFrames.size() == 1 && this.stitchingMethod.simpleBehaviorForSingleFrame()) {
            Frame<P> singleFrame = actualFrames.get(0);
            Matrix<PArray> m = singleFrame.matrix();
            P p = singleFrame.position();
            if (integerShiftPositions) {
                o = p.area().min();
                localOffset = o.toRoundedPoint();
                assert (o.equals(((IPoint)localOffset).toPoint()));
                Matrix<T> casted = Matrices.asFuncMatrix(Func.IDENTITY, requiredType, m);
                return casted.subMatr(((IPoint)localOffset).symmetric().coordinates(), dimensions, Matrix.ContinuationMode.getConstantMode(this.outsideValue(actualFrames)));
            }
            if (p instanceof UniversalFramePosition && (localOffset = ((UniversalFramePosition)p).inverseTransform()) instanceof LinearOperator) {
                LinearOperator inverseTransform = (LinearOperator)localOffset;
                LinearOperator shift = LinearOperator.getShiftInstance(area.min().coordinates());
                LinearOperator lo = shift.superposition(inverseTransform);
                Func f = Matrices.asInterpolationFunc(m, Matrices.InterpolationMethod.POLYLINEAR_FUNCTION, this.outsideValue(actualFrames));
                f = lo.apply(f);
                return Matrices.asCoordFuncMatrix(f, requiredType, dimensions);
            }
        }
        if (integerShiftPositions && this.stitchingMethod instanceof CoordinateFreeStitchingMethod) {
            ArrayList<Matrix<PArray>> expandedMatrices = new ArrayList<Matrix<PArray>>(actualFrames.size());
            for (Frame<P> localFrame : actualFrames) {
                o = localFrame.position().area().min();
                localOffset = o.toRoundedPoint();
                assert (o.equals(((IPoint)localOffset).toPoint()));
                Matrix<PArray> m = localFrame.matrix();
                m = Matrices.asFuncMatrix(Func.IDENTITY, DoubleArray.class, m);
                m = m.subMatr(((IPoint)localOffset).symmetric().coordinates(), dimensions, Matrix.ContinuationMode.NAN_CONSTANT);
                expandedMatrices.add(m);
            }
            return Matrices.asFuncMatrix(((CoordinateFreeStitchingMethod)this.stitchingMethod).combiningFunc(), requiredType, expandedMatrices);
        }
        return Matrices.asCoordFuncMatrix(this.getCombiner(actualFrames, area.min()), requiredType, dimensions);
    }

    public void stitch(ArrayContext context, Matrix<? extends UpdatablePArray> result, Point offset, long ... tileDimensions) {
        Objects.requireNonNull(result, "Null result argument");
        Objects.requireNonNull(offset, "Null offset argument");
        Objects.requireNonNull(tileDimensions, "Null tileDimensions argument");
        int n = offset.coordCount();
        long[] dim = result.dimensions();
        if (dim.length != n) {
            throw new IllegalArgumentException("Different offset.coordCount() = " + n + " and result.dimCount() = " + dim.length);
        }
        if (tileDimensions.length != n) {
            throw new IllegalArgumentException("Different offset.coordCount() = " + n + " and tileDimensions.length = " + tileDimensions.length);
        }
        long[] tileDim = new long[n];
        for (int k = 0; k < n; ++k) {
            tileDim[k] = tileDimensions[k] <= 0L ? dim[k] : tileDimensions[k];
        }
        long[] tileCounts = new long[n];
        for (int k = 0; k < n; ++k) {
            tileCounts[k] = dim[k] == 0L ? 0L : (dim[k] - 1L) / tileDim[k] + 1L;
        }
        long[] tileIndexes = new long[n];
        long[] subPos = new long[n];
        long[] subDim = new long[n];
        double[] subMin = new double[n];
        double[] subMax = new double[n];
        Matrix<IntArray> enumerator = Matrices.matrix(Arrays.nIntCopies(Arrays.longMul(tileCounts), 157), tileCounts);
        long tileCount = enumerator.size();
        for (long tileIndex = 0L; tileIndex < tileCount; ++tileIndex) {
            ArrayContext ac = context == null ? null : context.part(tileIndex, tileIndex + 1L, tileCount);
            enumerator.coordinates(tileIndex, tileIndexes);
            for (int k = 0; k < n; ++k) {
                subPos[k] = tileIndexes[k] * tileDim[k];
                assert (subPos[k] < dim[k]);
                subDim[k] = Math.min(tileDim[k], dim[k] - subPos[k]);
                subMin[k] = offset.coord(k) + (double)subPos[k];
                subMax[k] = subMin[k] + (double)subDim[k];
            }
            RectangularArea subArea = RectangularArea.valueOf(Point.valueOf(subMin), Point.valueOf(subMax));
            Matrix<? extends UpdatablePArray> subResult = result.subMatr(subPos, subDim);
            List<Frame<P>> localFrames = this.actualFrames(subArea);
            Stitcher<P> localStitcher = this.frames(localFrames);
            double requiredMemory = Stitcher.sizeOfFrames(localFrames);
            if (!localStitcher.quickStitching(subArea) && requiredMemory <= (double)Arrays.SystemSettings.maxTempJavaMemory() && (double)Matrices.sizeOf(subResult) >= 0.3 * requiredMemory) {
                localStitcher = localStitcher.cloneIntoJavaMemory(ac == null ? null : ac.part(0.0, 0.3));
                ac = ac == null ? null : ac.part(0.3, 1.0);
            }
            Matrix<PArray> lazy = localStitcher.asStitched(result.type(PArray.class), subArea);
            Matrices.copy(ac, subResult, lazy, 0, false);
            localStitcher.freeResources();
        }
    }

    public Stitcher<P> cloneIntoJavaMemory(ArrayContext context) {
        return this.frames(Stitcher.cloneIntoJavaMemory(context, this.frames(), true));
    }

    public void freeResources() {
        for (Frame<P> frame : this.frames) {
            frame.freeResources();
        }
    }

    public boolean quickStitching(RectangularArea area) {
        List<Frame<P>> actualFrames = this.actualFrames(area);
        return (this.stitchingMethod instanceof CoordinateFreeStitchingMethod || actualFrames.size() == 1 && this.stitchingMethod.simpleBehaviorForSingleFrame()) && Stitcher.shiftPositions(actualFrames) && Stitcher.integerOffsets(actualFrames, area.min());
    }

    public String toString() {
        return "Stitcher by " + String.valueOf(this.stitchingMethod) + " of " + this.frames.size() + " frames";
    }

    public static <P extends FramePosition> boolean integerOffsets(List<Frame<P>> frames, Point offset) {
        for (Frame<P> frame : frames) {
            Point o = frame.position().area().min().subtract(offset);
            if (o.equals(o.toRoundedPoint().toPoint())) continue;
            return false;
        }
        return true;
    }

    public static <P extends FramePosition> boolean shiftPositions(List<Frame<P>> frames) {
        for (Frame<P> frame : frames) {
            P fp = frame.position();
            if (fp instanceof ShiftFramePosition) continue;
            return false;
        }
        return true;
    }

    public static <P extends FramePosition> double sizeOfFrames(List<Frame<P>> frames) {
        double result = 0.0;
        for (Frame<P> frame : frames) {
            result += (double)Matrices.sizeOf(frame.matrix());
        }
        return result;
    }

    public static <P extends FramePosition> List<Frame<P>> cloneIntoJavaMemory(ArrayContext arrayContext, List<Frame<P>> frames, boolean freeSourceResources) {
        ArrayList<Frame<P>> result = new ArrayList<Frame<P>>(frames.size());
        int n = frames.size();
        for (int k = 0; k < n; ++k) {
            ArrayContext ac = arrayContext == null ? null : arrayContext.part(k, k + 1, n);
            Frame<P> frame = frames.get(k);
            result.add(Stitcher.cloneIntoJavaMemory(ac, frame));
            if (!freeSourceResources) continue;
            frame.freeResources();
        }
        return result;
    }

    public static <P extends FramePosition> Frame<P> cloneIntoJavaMemory(ArrayContext arrayContext, Frame<P> frame) {
        Matrix<UpdatablePArray> preloaded = Arrays.SMM.newMatrix(UpdatablePArray.class, frame.matrix());
        Matrices.copy(arrayContext, preloaded, frame.matrix());
        return DefaultFrame.valueOf(preloaded, frame.position());
    }

    private static void checkFrameDimensions(int dimCount, List<? extends Frame<?>> frames) {
        Objects.requireNonNull(frames, "Null frames argument");
        if (dimCount <= 0) {
            throw new IllegalArgumentException("Zero or negative dimCount argument = " + dimCount);
        }
        int n = 0;
        for (Frame<?> frame : frames) {
            Objects.requireNonNull(frame, "Null frame in the frames list");
            if (frame.matrix().dimCount() != dimCount) {
                throw new IllegalArgumentException("frames.get(" + n + ") and frames.get(0) have different number of dimensions: frame #" + n + " is " + String.valueOf(frame) + ", frame #0 is " + dimCount + "-dimensional");
            }
            ++n;
        }
        assert (n == frames.size());
    }

    private double outsideValue(List<Frame<P>> stitchedFrames) {
        double[] probeCoordinates = Arrays.nDoubleCopies(this.dimCount(), 0.0).toJavaArray();
        double[] probeValues = Arrays.nDoubleCopies(stitchedFrames.size(), Double.NaN).toJavaArray();
        return this.stitchingMethod.getStitchingFunc(stitchedFrames).get(probeCoordinates, probeValues);
    }

    private P castPosition(FramePosition position) {
        return (P)position;
    }

    private Func getCombiner(List<Frame<P>> frames, Point offset) {
        if (offset.isOrigin()) {
            return switch (frames.size()) {
                case 1 -> new CombinerFor1Frame(this, frames);
                case 2 -> new CombinerFor2Frames(this, frames);
                case 3 -> new CombinerFor3Frames(this, frames);
                case 4 -> new CombinerFor4Frames(this, frames);
                case 5 -> new CombinerFor5Frames(this, frames);
                case 6 -> new CombinerFor6Frames(this, frames);
                case 7 -> new CombinerFor7Frames(this, frames);
                case 8 -> new CombinerFor8Frames(this, frames);
                default -> new Combiner(this, frames);
            };
        }
        return switch (frames.size()) {
            case 1 -> new ShiftingCombinerFor1Frame(this, frames, offset);
            case 2 -> new ShiftingCombinerFor2Frames(this, frames, offset);
            case 3 -> new ShiftingCombinerFor3Frames(this, frames, offset);
            case 4 -> new ShiftingCombinerFor4Frames(this, frames, offset);
            case 5 -> new ShiftingCombinerFor5Frames(this, frames, offset);
            case 6 -> new ShiftingCombinerFor6Frames(this, frames, offset);
            case 7 -> new ShiftingCombinerFor7Frames(this, frames, offset);
            case 8 -> new ShiftingCombinerFor8Frames(this, frames, offset);
            default -> new ShiftingCombiner(this, frames, offset);
        };
    }

    private class CombinerFor1Frame
    extends Combiner {
        private CombinerFor1Frame(Stitcher stitcher, List<Frame<P>> frames) {
            super(stitcher, frames);
        }

        @Override
        public double get(double ... x) {
            double v0 = this.interpolation0.get(x);
            return this.stitchingFunc.get(x, v0);
        }

        @Override
        public double get(double x0) {
            double v0 = this.interpolation0.get(x0);
            return this.stitchingFunc.get1D(x0, v0);
        }

        @Override
        public double get(double x0, double x1) {
            double v0 = this.interpolation0.get(x0, x1);
            return this.stitchingFunc.get2D(x0, x1, v0);
        }

        @Override
        public double get(double x0, double x1, double x2) {
            double v0 = this.interpolation0.get(x0, x1, x2);
            return this.stitchingFunc.get3D(x0, x1, x2, v0);
        }

        @Override
        public String toString() {
            return "1-frame stitching combiner with " + String.valueOf(this.stitchingFunc);
        }
    }

    private class CombinerFor2Frames
    extends Combiner {
        private CombinerFor2Frames(Stitcher stitcher, List<Frame<P>> frames) {
            super(stitcher, frames);
        }

        @Override
        public double get(double ... x) {
            double v0 = this.interpolation0.get(x);
            double v1 = this.interpolation1.get(x);
            return this.stitchingFunc.get(x, v0, v1);
        }

        @Override
        public double get(double x0) {
            double v0 = this.interpolation0.get(x0);
            double v1 = this.interpolation1.get(x0);
            return this.stitchingFunc.get1D(x0, v0, v1);
        }

        @Override
        public double get(double x0, double x1) {
            double v0 = this.interpolation0.get(x0, x1);
            double v1 = this.interpolation1.get(x0, x1);
            return this.stitchingFunc.get2D(x0, x1, v0, v1);
        }

        @Override
        public double get(double x0, double x1, double x2) {
            double v0 = this.interpolation0.get(x0, x1, x2);
            double v1 = this.interpolation1.get(x0, x1, x2);
            return this.stitchingFunc.get3D(x0, x1, x2, v0, v1);
        }

        @Override
        public String toString() {
            return "2-frames stitching combiner with " + String.valueOf(this.stitchingFunc);
        }
    }

    private class CombinerFor3Frames
    extends Combiner {
        private CombinerFor3Frames(Stitcher stitcher, List<Frame<P>> frames) {
            super(stitcher, frames);
        }

        @Override
        public double get(double ... x) {
            double v0 = this.interpolation0.get(x);
            double v1 = this.interpolation1.get(x);
            double v2 = this.interpolation2.get(x);
            return this.stitchingFunc.get(x, v0, v1, v2);
        }

        @Override
        public double get(double x0) {
            double v0 = this.interpolation0.get(x0);
            double v1 = this.interpolation1.get(x0);
            double v2 = this.interpolation2.get(x0);
            return this.stitchingFunc.get1D(x0, v0, v1, v2);
        }

        @Override
        public double get(double x0, double x1) {
            double v0 = this.interpolation0.get(x0, x1);
            double v1 = this.interpolation1.get(x0, x1);
            double v2 = this.interpolation2.get(x0, x1);
            return this.stitchingFunc.get2D(x0, x1, v0, v1, v2);
        }

        @Override
        public double get(double x0, double x1, double x2) {
            double v0 = this.interpolation0.get(x0, x1, x2);
            double v1 = this.interpolation1.get(x0, x1, x2);
            double v2 = this.interpolation2.get(x0, x1, x2);
            return this.stitchingFunc.get3D(x0, x1, x2, v0, v1, v2);
        }

        @Override
        public String toString() {
            return "3-frames stitching combiner with " + String.valueOf(this.stitchingFunc);
        }
    }

    private class CombinerFor4Frames
    extends Combiner {
        private CombinerFor4Frames(Stitcher stitcher, List<Frame<P>> frames) {
            super(stitcher, frames);
        }

        @Override
        public double get(double ... x) {
            double v0 = this.interpolation0.get(x);
            double v1 = this.interpolation1.get(x);
            double v2 = this.interpolation2.get(x);
            double v3 = this.interpolation3.get(x);
            return this.stitchingFunc.get(x, v0, v1, v2, v3);
        }

        @Override
        public double get(double x0) {
            double v0 = this.interpolation0.get(x0);
            double v1 = this.interpolation1.get(x0);
            double v2 = this.interpolation2.get(x0);
            double v3 = this.interpolation3.get(x0);
            return this.stitchingFunc.get1D(x0, v0, v1, v2, v3);
        }

        @Override
        public double get(double x0, double x1) {
            double v0 = this.interpolation0.get(x0, x1);
            double v1 = this.interpolation1.get(x0, x1);
            double v2 = this.interpolation2.get(x0, x1);
            double v3 = this.interpolation3.get(x0, x1);
            return this.stitchingFunc.get2D(x0, x1, v0, v1, v2, v3);
        }

        @Override
        public double get(double x0, double x1, double x2) {
            double v0 = this.interpolation0.get(x0, x1, x2);
            double v1 = this.interpolation1.get(x0, x1, x2);
            double v2 = this.interpolation2.get(x0, x1, x2);
            double v3 = this.interpolation3.get(x0, x1, x2);
            return this.stitchingFunc.get3D(x0, x1, x2, v0, v1, v2, v3);
        }

        @Override
        public String toString() {
            return "4-frames stitching combiner with " + String.valueOf(this.stitchingFunc);
        }
    }

    private class CombinerFor5Frames
    extends Combiner {
        private CombinerFor5Frames(Stitcher stitcher, List<Frame<P>> frames) {
            super(stitcher, frames);
        }

        @Override
        public double get(double ... x) {
            double v0 = this.interpolation0.get(x);
            double v1 = this.interpolation1.get(x);
            double v2 = this.interpolation2.get(x);
            double v3 = this.interpolation3.get(x);
            double v4 = this.interpolation4.get(x);
            return this.stitchingFunc.get(x, v0, v1, v2, v3, v4);
        }

        @Override
        public double get(double x0) {
            double v0 = this.interpolation0.get(x0);
            double v1 = this.interpolation1.get(x0);
            double v2 = this.interpolation2.get(x0);
            double v3 = this.interpolation3.get(x0);
            double v4 = this.interpolation4.get(x0);
            return this.stitchingFunc.get1D(x0, v0, v1, v2, v3, v4);
        }

        @Override
        public double get(double x0, double x1) {
            double v0 = this.interpolation0.get(x0, x1);
            double v1 = this.interpolation1.get(x0, x1);
            double v2 = this.interpolation2.get(x0, x1);
            double v3 = this.interpolation3.get(x0, x1);
            double v4 = this.interpolation4.get(x0, x1);
            return this.stitchingFunc.get2D(x0, x1, v0, v1, v2, v3, v4);
        }

        @Override
        public double get(double x0, double x1, double x2) {
            double v0 = this.interpolation0.get(x0, x1, x2);
            double v1 = this.interpolation1.get(x0, x1, x2);
            double v2 = this.interpolation2.get(x0, x1, x2);
            double v3 = this.interpolation3.get(x0, x1, x2);
            double v4 = this.interpolation4.get(x0, x1, x2);
            return this.stitchingFunc.get3D(x0, x1, x2, v0, v1, v2, v3, v4);
        }

        @Override
        public String toString() {
            return "5-frames stitching combiner with " + String.valueOf(this.stitchingFunc);
        }
    }

    private class CombinerFor6Frames
    extends Combiner {
        private CombinerFor6Frames(Stitcher stitcher, List<Frame<P>> frames) {
            super(stitcher, frames);
        }

        @Override
        public double get(double ... x) {
            double v0 = this.interpolation0.get(x);
            double v1 = this.interpolation1.get(x);
            double v2 = this.interpolation2.get(x);
            double v3 = this.interpolation3.get(x);
            double v4 = this.interpolation4.get(x);
            double v5 = this.interpolation5.get(x);
            return this.stitchingFunc.get(x, v0, v1, v2, v3, v4, v5);
        }

        @Override
        public double get(double x0) {
            double v0 = this.interpolation0.get(x0);
            double v1 = this.interpolation1.get(x0);
            double v2 = this.interpolation2.get(x0);
            double v3 = this.interpolation3.get(x0);
            double v4 = this.interpolation4.get(x0);
            double v5 = this.interpolation5.get(x0);
            return this.stitchingFunc.get1D(x0, v0, v1, v2, v3, v4, v5);
        }

        @Override
        public double get(double x0, double x1) {
            double v0 = this.interpolation0.get(x0, x1);
            double v1 = this.interpolation1.get(x0, x1);
            double v2 = this.interpolation2.get(x0, x1);
            double v3 = this.interpolation3.get(x0, x1);
            double v4 = this.interpolation4.get(x0, x1);
            double v5 = this.interpolation5.get(x0, x1);
            return this.stitchingFunc.get2D(x0, x1, v0, v1, v2, v3, v4, v5);
        }

        @Override
        public double get(double x0, double x1, double x2) {
            double v0 = this.interpolation0.get(x0, x1, x2);
            double v1 = this.interpolation1.get(x0, x1, x2);
            double v2 = this.interpolation2.get(x0, x1, x2);
            double v3 = this.interpolation3.get(x0, x1, x2);
            double v4 = this.interpolation4.get(x0, x1, x2);
            double v5 = this.interpolation5.get(x0, x1, x2);
            return this.stitchingFunc.get3D(x0, x1, x2, v0, v1, v2, v3, v4, v5);
        }

        @Override
        public String toString() {
            return "6-frames stitching combiner with " + String.valueOf(this.stitchingFunc);
        }
    }

    private class CombinerFor7Frames
    extends Combiner {
        private CombinerFor7Frames(Stitcher stitcher, List<Frame<P>> frames) {
            super(stitcher, frames);
        }

        @Override
        public double get(double ... x) {
            double v0 = this.interpolation0.get(x);
            double v1 = this.interpolation1.get(x);
            double v2 = this.interpolation2.get(x);
            double v3 = this.interpolation3.get(x);
            double v4 = this.interpolation4.get(x);
            double v5 = this.interpolation5.get(x);
            double v6 = this.interpolation6.get(x);
            return this.stitchingFunc.get(x, v0, v1, v2, v3, v4, v5, v6);
        }

        @Override
        public double get(double x0) {
            double v0 = this.interpolation0.get(x0);
            double v1 = this.interpolation1.get(x0);
            double v2 = this.interpolation2.get(x0);
            double v3 = this.interpolation3.get(x0);
            double v4 = this.interpolation4.get(x0);
            double v5 = this.interpolation5.get(x0);
            double v6 = this.interpolation6.get(x0);
            return this.stitchingFunc.get1D(x0, v0, v1, v2, v3, v4, v5, v6);
        }

        @Override
        public double get(double x0, double x1) {
            double v0 = this.interpolation0.get(x0, x1);
            double v1 = this.interpolation1.get(x0, x1);
            double v2 = this.interpolation2.get(x0, x1);
            double v3 = this.interpolation3.get(x0, x1);
            double v4 = this.interpolation4.get(x0, x1);
            double v5 = this.interpolation5.get(x0, x1);
            double v6 = this.interpolation6.get(x0, x1);
            return this.stitchingFunc.get2D(x0, x1, v0, v1, v2, v3, v4, v5, v6);
        }

        @Override
        public double get(double x0, double x1, double x2) {
            double v0 = this.interpolation0.get(x0, x1, x2);
            double v1 = this.interpolation1.get(x0, x1, x2);
            double v2 = this.interpolation2.get(x0, x1, x2);
            double v3 = this.interpolation3.get(x0, x1, x2);
            double v4 = this.interpolation4.get(x0, x1, x2);
            double v5 = this.interpolation5.get(x0, x1, x2);
            double v6 = this.interpolation6.get(x0, x1, x2);
            return this.stitchingFunc.get3D(x0, x1, x2, v0, v1, v2, v3, v4, v5, v6);
        }

        @Override
        public String toString() {
            return "7-frames stitching combiner with " + String.valueOf(this.stitchingFunc);
        }
    }

    private class CombinerFor8Frames
    extends Combiner {
        private CombinerFor8Frames(Stitcher stitcher, List<Frame<P>> frames) {
            super(stitcher, frames);
        }

        @Override
        public double get(double ... x) {
            double v0 = this.interpolation0.get(x);
            double v1 = this.interpolation1.get(x);
            double v2 = this.interpolation2.get(x);
            double v3 = this.interpolation3.get(x);
            double v4 = this.interpolation4.get(x);
            double v5 = this.interpolation5.get(x);
            double v6 = this.interpolation6.get(x);
            double v7 = this.interpolation7.get(x);
            return this.stitchingFunc.get(x, v0, v1, v2, v3, v4, v5, v6, v7);
        }

        @Override
        public double get(double x0) {
            double v0 = this.interpolation0.get(x0);
            double v1 = this.interpolation1.get(x0);
            double v2 = this.interpolation2.get(x0);
            double v3 = this.interpolation3.get(x0);
            double v4 = this.interpolation4.get(x0);
            double v5 = this.interpolation5.get(x0);
            double v6 = this.interpolation6.get(x0);
            double v7 = this.interpolation7.get(x0);
            return this.stitchingFunc.get1D(x0, v0, v1, v2, v3, v4, v5, v6, v7);
        }

        @Override
        public double get(double x0, double x1) {
            double v0 = this.interpolation0.get(x0, x1);
            double v1 = this.interpolation1.get(x0, x1);
            double v2 = this.interpolation2.get(x0, x1);
            double v3 = this.interpolation3.get(x0, x1);
            double v4 = this.interpolation4.get(x0, x1);
            double v5 = this.interpolation5.get(x0, x1);
            double v6 = this.interpolation6.get(x0, x1);
            double v7 = this.interpolation7.get(x0, x1);
            return this.stitchingFunc.get2D(x0, x1, v0, v1, v2, v3, v4, v5, v6, v7);
        }

        @Override
        public double get(double x0, double x1, double x2) {
            double v0 = this.interpolation0.get(x0, x1, x2);
            double v1 = this.interpolation1.get(x0, x1, x2);
            double v2 = this.interpolation2.get(x0, x1, x2);
            double v3 = this.interpolation3.get(x0, x1, x2);
            double v4 = this.interpolation4.get(x0, x1, x2);
            double v5 = this.interpolation5.get(x0, x1, x2);
            double v6 = this.interpolation6.get(x0, x1, x2);
            double v7 = this.interpolation7.get(x0, x1, x2);
            return this.stitchingFunc.get3D(x0, x1, x2, v0, v1, v2, v3, v4, v5, v6, v7);
        }

        @Override
        public String toString() {
            return "8-frames stitching combiner with " + String.valueOf(this.stitchingFunc);
        }
    }

    private class Combiner
    implements Func {
        final StitchingFunc stitchingFunc;
        final Func[] interpolations;
        final Func interpolation0;
        final Func interpolation1;
        final Func interpolation2;
        final Func interpolation3;
        final Func interpolation4;
        final Func interpolation5;
        final Func interpolation6;
        final Func interpolation7;
        final int n;

        private Combiner(Stitcher stitcher, List<? extends Frame<P>> frames) {
            this.n = frames.size();
            this.stitchingFunc = stitcher.stitchingMethod().getStitchingFunc(frames);
            Func[] interpolations = new Func[this.n];
            int k = 0;
            for (Frame frame : frames) {
                interpolations[k] = frame.position().asInterpolationFunc(frame.matrix());
                ++k;
            }
            this.interpolations = interpolations;
            this.interpolation0 = this.n >= 1 ? interpolations[0] : null;
            this.interpolation1 = this.n >= 2 ? interpolations[1] : null;
            this.interpolation2 = this.n >= 3 ? interpolations[2] : null;
            this.interpolation3 = this.n >= 4 ? interpolations[3] : null;
            this.interpolation4 = this.n >= 5 ? interpolations[4] : null;
            this.interpolation5 = this.n >= 6 ? interpolations[5] : null;
            this.interpolation6 = this.n >= 7 ? interpolations[6] : null;
            this.interpolation7 = this.n >= 8 ? interpolations[7] : null;
        }

        @Override
        public double get(double ... x) {
            double[] values = new double[this.n];
            for (int k = 0; k < this.n; ++k) {
                values[k] = this.interpolations[k].get(x);
            }
            return this.stitchingFunc.get(x, values);
        }

        @Override
        public double get() {
            double[] values = new double[this.n];
            for (int k = 0; k < this.n; ++k) {
                values[k] = this.interpolations[k].get(EMPTY_DOUBLES);
            }
            return this.stitchingFunc.get(EMPTY_DOUBLES, values);
        }

        @Override
        public double get(double x0) {
            double[] values = new double[this.n];
            for (int k = 0; k < this.n; ++k) {
                values[k] = this.interpolations[k].get(x0);
            }
            return this.stitchingFunc.get1D(x0, values);
        }

        @Override
        public double get(double x0, double x1) {
            double[] values = new double[this.n];
            for (int k = 0; k < this.n; ++k) {
                values[k] = this.interpolations[k].get(x0, x1);
            }
            return this.stitchingFunc.get2D(x0, x1, values);
        }

        @Override
        public double get(double x0, double x1, double x2) {
            double[] values = new double[this.n];
            for (int k = 0; k < this.n; ++k) {
                values[k] = this.interpolations[k].get(x0, x1, x2);
            }
            return this.stitchingFunc.get3D(x0, x1, x2, values);
        }

        @Override
        public double get(double x0, double x1, double x2, double x3) {
            double[] values = new double[this.n];
            for (int k = 0; k < this.n; ++k) {
                values[k] = this.interpolations[k].get(x0, x1, x2, x3);
            }
            return this.stitchingFunc.get(new double[]{x0, x1, x2, x3}, values);
        }

        public String toString() {
            return "stitching combiner with " + String.valueOf(this.stitchingFunc);
        }
    }

    private class ShiftingCombinerFor1Frame
    extends ShiftingCombiner {
        private ShiftingCombinerFor1Frame(Stitcher stitcher, List<Frame<P>> frames, Point offset) {
            super(stitcher, frames, offset);
        }

        @Override
        public double get(double ... x) {
            double[] shifted = new double[x.length];
            for (int k = 0; k < x.length; ++k) {
                shifted[k] = x[k] + this.offset[k];
            }
            double v0 = this.interpolation0.get(shifted);
            return this.stitchingFunc.get(x, v0);
        }

        @Override
        public double get(double x0) {
            double v0 = this.interpolation0.get(x0 += this.offset0);
            return this.stitchingFunc.get1D(x0, v0);
        }

        @Override
        public double get(double x0, double x1) {
            double v0 = this.interpolation0.get(x0 += this.offset0, x1 += this.offset1);
            return this.stitchingFunc.get2D(x0, x1, v0);
        }

        @Override
        public double get(double x0, double x1, double x2) {
            double v0 = this.interpolation0.get(x0 += this.offset0, x1 += this.offset1, x2 += this.offset2);
            return this.stitchingFunc.get3D(x0, x1, x2, v0);
        }

        @Override
        public String toString() {
            return "1-frame shifting stitching combiner with " + String.valueOf(this.stitchingFunc);
        }
    }

    private class ShiftingCombinerFor2Frames
    extends ShiftingCombiner {
        private ShiftingCombinerFor2Frames(Stitcher stitcher, List<Frame<P>> frames, Point offset) {
            super(stitcher, frames, offset);
        }

        @Override
        public double get(double ... x) {
            double[] shifted = new double[x.length];
            for (int k = 0; k < x.length; ++k) {
                shifted[k] = x[k] + this.offset[k];
            }
            double v0 = this.interpolation0.get(shifted);
            double v1 = this.interpolation1.get(shifted);
            return this.stitchingFunc.get(x, v0, v1);
        }

        @Override
        public double get(double x0) {
            double v0 = this.interpolation0.get(x0 += this.offset0);
            double v1 = this.interpolation1.get(x0);
            return this.stitchingFunc.get1D(x0, v0, v1);
        }

        @Override
        public double get(double x0, double x1) {
            double v0 = this.interpolation0.get(x0 += this.offset0, x1 += this.offset1);
            double v1 = this.interpolation1.get(x0, x1);
            return this.stitchingFunc.get2D(x0, x1, v0, v1);
        }

        @Override
        public double get(double x0, double x1, double x2) {
            double v0 = this.interpolation0.get(x0 += this.offset0, x1 += this.offset1, x2 += this.offset2);
            double v1 = this.interpolation1.get(x0, x1, x2);
            return this.stitchingFunc.get3D(x0, x1, x2, v0, v1);
        }

        @Override
        public String toString() {
            return "2-frames shifting stitching combiner with " + String.valueOf(this.stitchingFunc);
        }
    }

    private class ShiftingCombinerFor3Frames
    extends ShiftingCombiner {
        private ShiftingCombinerFor3Frames(Stitcher stitcher, List<Frame<P>> frames, Point offset) {
            super(stitcher, frames, offset);
        }

        @Override
        public double get(double ... x) {
            double[] shifted = new double[x.length];
            for (int k = 0; k < x.length; ++k) {
                shifted[k] = x[k] + this.offset[k];
            }
            double v0 = this.interpolation0.get(shifted);
            double v1 = this.interpolation1.get(shifted);
            double v2 = this.interpolation2.get(shifted);
            return this.stitchingFunc.get(x, v0, v1, v2);
        }

        @Override
        public double get(double x0) {
            double v0 = this.interpolation0.get(x0 += this.offset0);
            double v1 = this.interpolation1.get(x0);
            double v2 = this.interpolation2.get(x0);
            return this.stitchingFunc.get1D(x0, v0, v1, v2);
        }

        @Override
        public double get(double x0, double x1) {
            double v0 = this.interpolation0.get(x0 += this.offset0, x1 += this.offset1);
            double v1 = this.interpolation1.get(x0, x1);
            double v2 = this.interpolation2.get(x0, x1);
            return this.stitchingFunc.get2D(x0, x1, v0, v1, v2);
        }

        @Override
        public double get(double x0, double x1, double x2) {
            double v0 = this.interpolation0.get(x0 += this.offset0, x1 += this.offset1, x2 += this.offset2);
            double v1 = this.interpolation1.get(x0, x1, x2);
            double v2 = this.interpolation2.get(x0, x1, x2);
            return this.stitchingFunc.get3D(x0, x1, x2, v0, v1, v2);
        }

        @Override
        public String toString() {
            return "3-frames shifting stitching combiner with " + String.valueOf(this.stitchingFunc);
        }
    }

    private class ShiftingCombinerFor4Frames
    extends ShiftingCombiner {
        private ShiftingCombinerFor4Frames(Stitcher stitcher, List<Frame<P>> frames, Point offset) {
            super(stitcher, frames, offset);
        }

        @Override
        public double get(double ... x) {
            double[] shifted = new double[x.length];
            for (int k = 0; k < x.length; ++k) {
                shifted[k] = x[k] + this.offset[k];
            }
            double v0 = this.interpolation0.get(shifted);
            double v1 = this.interpolation1.get(shifted);
            double v2 = this.interpolation2.get(shifted);
            double v3 = this.interpolation3.get(shifted);
            return this.stitchingFunc.get(x, v0, v1, v2, v3);
        }

        @Override
        public double get(double x0) {
            double v0 = this.interpolation0.get(x0 += this.offset0);
            double v1 = this.interpolation1.get(x0);
            double v2 = this.interpolation2.get(x0);
            double v3 = this.interpolation3.get(x0);
            return this.stitchingFunc.get1D(x0, v0, v1, v2, v3);
        }

        @Override
        public double get(double x0, double x1) {
            double v0 = this.interpolation0.get(x0 += this.offset0, x1 += this.offset1);
            double v1 = this.interpolation1.get(x0, x1);
            double v2 = this.interpolation2.get(x0, x1);
            double v3 = this.interpolation3.get(x0, x1);
            return this.stitchingFunc.get2D(x0, x1, v0, v1, v2, v3);
        }

        @Override
        public double get(double x0, double x1, double x2) {
            double v0 = this.interpolation0.get(x0 += this.offset0, x1 += this.offset1, x2 += this.offset2);
            double v1 = this.interpolation1.get(x0, x1, x2);
            double v2 = this.interpolation2.get(x0, x1, x2);
            double v3 = this.interpolation3.get(x0, x1, x2);
            return this.stitchingFunc.get3D(x0, x1, x2, v0, v1, v2, v3);
        }

        @Override
        public String toString() {
            return "4-frames shifting stitching combiner with " + String.valueOf(this.stitchingFunc);
        }
    }

    private class ShiftingCombinerFor5Frames
    extends ShiftingCombiner {
        private ShiftingCombinerFor5Frames(Stitcher stitcher, List<Frame<P>> frames, Point offset) {
            super(stitcher, frames, offset);
        }

        @Override
        public double get(double ... x) {
            double[] shifted = new double[x.length];
            for (int k = 0; k < x.length; ++k) {
                shifted[k] = x[k] + this.offset[k];
            }
            double v0 = this.interpolation0.get(shifted);
            double v1 = this.interpolation1.get(shifted);
            double v2 = this.interpolation2.get(shifted);
            double v3 = this.interpolation3.get(shifted);
            double v4 = this.interpolation4.get(shifted);
            return this.stitchingFunc.get(x, v0, v1, v2, v3, v4);
        }

        @Override
        public double get(double x0) {
            double v0 = this.interpolation0.get(x0 += this.offset0);
            double v1 = this.interpolation1.get(x0);
            double v2 = this.interpolation2.get(x0);
            double v3 = this.interpolation3.get(x0);
            double v4 = this.interpolation4.get(x0);
            return this.stitchingFunc.get1D(x0, v0, v1, v2, v3, v4);
        }

        @Override
        public double get(double x0, double x1) {
            double v0 = this.interpolation0.get(x0 += this.offset0, x1 += this.offset1);
            double v1 = this.interpolation1.get(x0, x1);
            double v2 = this.interpolation2.get(x0, x1);
            double v3 = this.interpolation3.get(x0, x1);
            double v4 = this.interpolation4.get(x0, x1);
            return this.stitchingFunc.get2D(x0, x1, v0, v1, v2, v3, v4);
        }

        @Override
        public double get(double x0, double x1, double x2) {
            double v0 = this.interpolation0.get(x0 += this.offset0, x1 += this.offset1, x2 += this.offset2);
            double v1 = this.interpolation1.get(x0, x1, x2);
            double v2 = this.interpolation2.get(x0, x1, x2);
            double v3 = this.interpolation3.get(x0, x1, x2);
            double v4 = this.interpolation4.get(x0, x1, x2);
            return this.stitchingFunc.get3D(x0, x1, x2, v0, v1, v2, v3, v4);
        }

        @Override
        public String toString() {
            return "5-frames shifting stitching combiner with " + String.valueOf(this.stitchingFunc);
        }
    }

    private class ShiftingCombinerFor6Frames
    extends ShiftingCombiner {
        private ShiftingCombinerFor6Frames(Stitcher stitcher, List<Frame<P>> frames, Point offset) {
            super(stitcher, frames, offset);
        }

        @Override
        public double get(double ... x) {
            double[] shifted = new double[x.length];
            for (int k = 0; k < x.length; ++k) {
                shifted[k] = x[k] + this.offset[k];
            }
            double v0 = this.interpolation0.get(shifted);
            double v1 = this.interpolation1.get(shifted);
            double v2 = this.interpolation2.get(shifted);
            double v3 = this.interpolation3.get(shifted);
            double v4 = this.interpolation4.get(shifted);
            double v5 = this.interpolation5.get(shifted);
            return this.stitchingFunc.get(x, v0, v1, v2, v3, v4, v5);
        }

        @Override
        public double get(double x0) {
            double v0 = this.interpolation0.get(x0 += this.offset0);
            double v1 = this.interpolation1.get(x0);
            double v2 = this.interpolation2.get(x0);
            double v3 = this.interpolation3.get(x0);
            double v4 = this.interpolation4.get(x0);
            double v5 = this.interpolation5.get(x0);
            return this.stitchingFunc.get1D(x0, v0, v1, v2, v3, v4, v5);
        }

        @Override
        public double get(double x0, double x1) {
            double v0 = this.interpolation0.get(x0 += this.offset0, x1 += this.offset1);
            double v1 = this.interpolation1.get(x0, x1);
            double v2 = this.interpolation2.get(x0, x1);
            double v3 = this.interpolation3.get(x0, x1);
            double v4 = this.interpolation4.get(x0, x1);
            double v5 = this.interpolation5.get(x0, x1);
            return this.stitchingFunc.get2D(x0, x1, v0, v1, v2, v3, v4, v5);
        }

        @Override
        public double get(double x0, double x1, double x2) {
            double v0 = this.interpolation0.get(x0 += this.offset0, x1 += this.offset1, x2 += this.offset2);
            double v1 = this.interpolation1.get(x0, x1, x2);
            double v2 = this.interpolation2.get(x0, x1, x2);
            double v3 = this.interpolation3.get(x0, x1, x2);
            double v4 = this.interpolation4.get(x0, x1, x2);
            double v5 = this.interpolation5.get(x0, x1, x2);
            return this.stitchingFunc.get3D(x0, x1, x2, v0, v1, v2, v3, v4, v5);
        }

        @Override
        public String toString() {
            return "6-frames shifting stitching combiner with " + String.valueOf(this.stitchingFunc);
        }
    }

    private class ShiftingCombinerFor7Frames
    extends ShiftingCombiner {
        private ShiftingCombinerFor7Frames(Stitcher stitcher, List<Frame<P>> frames, Point offset) {
            super(stitcher, frames, offset);
        }

        @Override
        public double get(double ... x) {
            double[] shifted = new double[x.length];
            for (int k = 0; k < x.length; ++k) {
                shifted[k] = x[k] + this.offset[k];
            }
            double v0 = this.interpolation0.get(shifted);
            double v1 = this.interpolation1.get(shifted);
            double v2 = this.interpolation2.get(shifted);
            double v3 = this.interpolation3.get(shifted);
            double v4 = this.interpolation4.get(shifted);
            double v5 = this.interpolation5.get(shifted);
            double v6 = this.interpolation6.get(shifted);
            return this.stitchingFunc.get(x, v0, v1, v2, v3, v4, v5, v6);
        }

        @Override
        public double get(double x0) {
            double v0 = this.interpolation0.get(x0 += this.offset0);
            double v1 = this.interpolation1.get(x0);
            double v2 = this.interpolation2.get(x0);
            double v3 = this.interpolation3.get(x0);
            double v4 = this.interpolation4.get(x0);
            double v5 = this.interpolation5.get(x0);
            double v6 = this.interpolation6.get(x0);
            return this.stitchingFunc.get1D(x0, v0, v1, v2, v3, v4, v5, v6);
        }

        @Override
        public double get(double x0, double x1) {
            double v0 = this.interpolation0.get(x0 += this.offset0, x1 += this.offset1);
            double v1 = this.interpolation1.get(x0, x1);
            double v2 = this.interpolation2.get(x0, x1);
            double v3 = this.interpolation3.get(x0, x1);
            double v4 = this.interpolation4.get(x0, x1);
            double v5 = this.interpolation5.get(x0, x1);
            double v6 = this.interpolation6.get(x0, x1);
            return this.stitchingFunc.get2D(x0, x1, v0, v1, v2, v3, v4, v5, v6);
        }

        @Override
        public double get(double x0, double x1, double x2) {
            double v0 = this.interpolation0.get(x0 += this.offset0, x1 += this.offset1, x2 += this.offset2);
            double v1 = this.interpolation1.get(x0, x1, x2);
            double v2 = this.interpolation2.get(x0, x1, x2);
            double v3 = this.interpolation3.get(x0, x1, x2);
            double v4 = this.interpolation4.get(x0, x1, x2);
            double v5 = this.interpolation5.get(x0, x1, x2);
            double v6 = this.interpolation6.get(x0, x1, x2);
            return this.stitchingFunc.get3D(x0, x1, x2, v0, v1, v2, v3, v4, v5, v6);
        }

        @Override
        public String toString() {
            return "7-frames shifting stitching combiner with " + String.valueOf(this.stitchingFunc);
        }
    }

    private class ShiftingCombinerFor8Frames
    extends ShiftingCombiner {
        private ShiftingCombinerFor8Frames(Stitcher stitcher, List<Frame<P>> frames, Point offset) {
            super(stitcher, frames, offset);
        }

        @Override
        public double get(double ... x) {
            double[] shifted = new double[x.length];
            for (int k = 0; k < x.length; ++k) {
                shifted[k] = x[k] + this.offset[k];
            }
            double v0 = this.interpolation0.get(shifted);
            double v1 = this.interpolation1.get(shifted);
            double v2 = this.interpolation2.get(shifted);
            double v3 = this.interpolation3.get(shifted);
            double v4 = this.interpolation4.get(shifted);
            double v5 = this.interpolation5.get(shifted);
            double v6 = this.interpolation6.get(shifted);
            double v7 = this.interpolation7.get(shifted);
            return this.stitchingFunc.get(x, v0, v1, v2, v3, v4, v5, v6, v7);
        }

        @Override
        public double get(double x0) {
            double v0 = this.interpolation0.get(x0 += this.offset0);
            double v1 = this.interpolation1.get(x0);
            double v2 = this.interpolation2.get(x0);
            double v3 = this.interpolation3.get(x0);
            double v4 = this.interpolation4.get(x0);
            double v5 = this.interpolation5.get(x0);
            double v6 = this.interpolation6.get(x0);
            double v7 = this.interpolation7.get(x0);
            return this.stitchingFunc.get1D(x0, v0, v1, v2, v3, v4, v5, v6, v7);
        }

        @Override
        public double get(double x0, double x1) {
            double v0 = this.interpolation0.get(x0 += this.offset0, x1 += this.offset1);
            double v1 = this.interpolation1.get(x0, x1);
            double v2 = this.interpolation2.get(x0, x1);
            double v3 = this.interpolation3.get(x0, x1);
            double v4 = this.interpolation4.get(x0, x1);
            double v5 = this.interpolation5.get(x0, x1);
            double v6 = this.interpolation6.get(x0, x1);
            double v7 = this.interpolation7.get(x0, x1);
            return this.stitchingFunc.get2D(x0, x1, v0, v1, v2, v3, v4, v5, v6, v7);
        }

        @Override
        public double get(double x0, double x1, double x2) {
            double v0 = this.interpolation0.get(x0 += this.offset0, x1 += this.offset1, x2 += this.offset2);
            double v1 = this.interpolation1.get(x0, x1, x2);
            double v2 = this.interpolation2.get(x0, x1, x2);
            double v3 = this.interpolation3.get(x0, x1, x2);
            double v4 = this.interpolation4.get(x0, x1, x2);
            double v5 = this.interpolation5.get(x0, x1, x2);
            double v6 = this.interpolation6.get(x0, x1, x2);
            double v7 = this.interpolation7.get(x0, x1, x2);
            return this.stitchingFunc.get3D(x0, x1, x2, v0, v1, v2, v3, v4, v5, v6, v7);
        }

        @Override
        public String toString() {
            return "8-frames shifting stitching combiner with " + String.valueOf(this.stitchingFunc);
        }
    }

    private class ShiftingCombiner
    implements Func {
        final StitchingFunc stitchingFunc;
        final Func[] interpolations;
        final Func interpolation0;
        final Func interpolation1;
        final Func interpolation2;
        final Func interpolation3;
        final Func interpolation4;
        final Func interpolation5;
        final Func interpolation6;
        final Func interpolation7;
        final double[] offset;
        final double offset0;
        final double offset1;
        final double offset2;
        final double offset3;
        final int n;

        private ShiftingCombiner(Stitcher stitcher, List<Frame<P>> frames, Point offset) {
            this.n = frames.size();
            this.stitchingFunc = stitcher.stitchingMethod().getStitchingFunc(frames);
            Func[] interpolations = new Func[this.n];
            int k = 0;
            for (Frame frame : frames) {
                interpolations[k] = frame.position().asInterpolationFunc(frame.matrix());
                ++k;
            }
            this.interpolations = interpolations;
            this.interpolation0 = this.n >= 1 ? interpolations[0] : null;
            this.interpolation1 = this.n >= 2 ? interpolations[1] : null;
            this.interpolation2 = this.n >= 3 ? interpolations[2] : null;
            this.interpolation3 = this.n >= 4 ? interpolations[3] : null;
            this.interpolation4 = this.n >= 5 ? interpolations[4] : null;
            this.interpolation5 = this.n >= 6 ? interpolations[5] : null;
            this.interpolation6 = this.n >= 7 ? interpolations[6] : null;
            this.interpolation7 = this.n >= 8 ? interpolations[7] : null;
            this.offset = offset.coordinates();
            this.offset0 = this.offset.length >= 1 ? this.offset[0] : Double.NaN;
            this.offset1 = this.offset.length >= 2 ? this.offset[1] : Double.NaN;
            this.offset2 = this.offset.length >= 3 ? this.offset[2] : Double.NaN;
            this.offset3 = this.offset.length >= 4 ? this.offset[3] : Double.NaN;
        }

        @Override
        public double get(double ... x) {
            double[] shifted = new double[x.length];
            for (int k = 0; k < x.length; ++k) {
                shifted[k] = x[k] + this.offset[k];
            }
            double[] values = new double[this.n];
            for (int k = 0; k < this.n; ++k) {
                values[k] = this.interpolations[k].get(shifted);
            }
            return this.stitchingFunc.get(shifted, values);
        }

        @Override
        public double get() {
            double[] values = new double[this.n];
            for (int k = 0; k < this.n; ++k) {
                values[k] = this.interpolations[k].get(EMPTY_DOUBLES);
            }
            return this.stitchingFunc.get(EMPTY_DOUBLES, values);
        }

        @Override
        public double get(double x0) {
            double[] values = new double[this.n];
            for (int k = 0; k < this.n; ++k) {
                values[k] = this.interpolations[k].get(x0 + this.offset0);
            }
            return this.stitchingFunc.get1D(x0 + this.offset0, values);
        }

        @Override
        public double get(double x0, double x1) {
            double[] values = new double[this.n];
            for (int k = 0; k < this.n; ++k) {
                values[k] = this.interpolations[k].get(x0 + this.offset0, x1 + this.offset1);
            }
            return this.stitchingFunc.get2D(x0 + this.offset0, x1 + this.offset1, values);
        }

        @Override
        public double get(double x0, double x1, double x2) {
            double[] values = new double[this.n];
            for (int k = 0; k < this.n; ++k) {
                values[k] = this.interpolations[k].get(x0 + this.offset0, x1 + this.offset1, x2 + this.offset2);
            }
            return this.stitchingFunc.get3D(x0 + this.offset0, x1 + this.offset1, x2 + this.offset2, values);
        }

        @Override
        public double get(double x0, double x1, double x2, double x3) {
            double[] values = new double[this.n];
            for (int k = 0; k < this.n; ++k) {
                values[k] = this.interpolations[k].get(x0 + this.offset0, x1 + this.offset1, x2 + this.offset2, x3 + this.offset3);
            }
            return this.stitchingFunc.get(new double[]{x0 + this.offset0, x1 + this.offset1, x2 + this.offset2, x3 + this.offset3}, values);
        }

        public String toString() {
            return "shifting stitching combiner with " + String.valueOf(this.stitchingFunc);
        }
    }
}

