/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api;

import jakarta.json.Json;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.algart.arrays.Arrays;
import net.algart.executors.api.LogLevel;
import net.algart.json.Jsons;

public class ExecutionStatus {
    private static final int MAX_POSSIBLE_NUMBER_OF_PARENTS = 10000;
    private static final int MAX_SHOWN_NUMBER_OF_PARENTS = 256;
    private static final String LOGGING_STATUS_LEVEL = Arrays.SystemSettings.getStringProperty((String)"net.algart.executors.api.loggingStatusLevel", null);
    private static final DataKind LOGGING_STATUS_KIND = DataKind.ofOrNull(Arrays.SystemSettings.getStringProperty((String)"net.algart.executors.api.loggingStatusKind", null));
    private static final long MIN_TIME_BETWEEN_LOGGING_IN_NANOSECONDS = 500000000L;
    private final Supplier<String> ownerName;
    private ExecutionStatus parent = null;
    private ExecutionStatus root = null;
    private ExecutionStatus child = null;
    private volatile boolean opened = false;
    private Supplier<String> message = null;
    private Supplier<String> comment = null;
    private String executorFullClassName = null;
    private String executorSimpleClassName = null;
    private String executorClassId = null;
    private String executorInstanceId = null;
    private JsonObject custom = null;
    private Long startProcessingTimeStamp = null;
    private boolean classInformationIncluded = false;

    private ExecutionStatus(Supplier<String> ownerName) {
        this.ownerName = ownerName;
    }

    public static ExecutionStatus newInstance() {
        return ExecutionStatus.newNamedInstance((Supplier<String>)null);
    }

    public static ExecutionStatus newNamedInstance(String ownerName) {
        return ExecutionStatus.newNamedInstance(ownerName == null ? null : () -> ownerName);
    }

    public static ExecutionStatus newNamedInstance(Supplier<String> ownerName) {
        return LOGGING_STATUS_LEVEL == null ? new ExecutionStatus(ownerName) : new LoggingExecutionStatus(ownerName);
    }

    public String ownerName() {
        return this.ownerName == null ? null : this.ownerName.get();
    }

    public boolean isOpened() {
        return this.opened;
    }

    public ExecutionStatus parent() {
        return this.parent;
    }

    public ExecutionStatus root() {
        assert (!this.opened || this.root != null);
        return this.root;
    }

    public void open(ExecutionStatus parentStatus) {
        if (parentStatus == this) {
            throw new IllegalArgumentException("Parent status cannot be identical to this one");
        }
        this.parent = parentStatus;
        if (this.parent != null) {
            this.parent.child = this;
        }
        this.root = this.findRoot();
        assert (this.root != null);
        this.clearInformation();
        this.opened = true;
        this.onOpen();
    }

    public void close() {
        this.onClose();
        this.opened = false;
        if (this.parent != null) {
            this.parent.child = null;
        }
        this.parent = null;
        this.root = null;
        this.child = null;
    }

    public boolean isEmpty() {
        return !this.isNonEmpty();
    }

    public boolean isNonEmpty() {
        return this.hasMessage() || this.hasComment() || this.classInformationIncluded && this.executorSimpleClassName != null;
    }

    public void clear() {
        this.clearInformation();
        this.onUpdate(true, true);
    }

    public boolean hasMessage() {
        return this.message != null;
    }

    public String message() {
        return this.message == null ? null : this.message.get();
    }

    public Supplier<String> getMessage() {
        return this.message;
    }

    public ExecutionStatus setMessageString(String message) {
        return this.setMessage(() -> message);
    }

    public ExecutionStatus setMessage(Supplier<String> message) {
        if (!this.opened) {
            return this;
        }
        this.message = message;
        this.onUpdate(message != null, false);
        return this;
    }

    public boolean hasComment() {
        return this.comment != null;
    }

    public String comment() {
        return this.comment == null ? null : this.comment.get();
    }

    public Supplier<String> getComment() {
        return this.comment;
    }

    public ExecutionStatus setComment(Supplier<String> comment) {
        if (!this.opened) {
            return this;
        }
        this.comment = comment;
        this.onUpdate(false, comment != null);
        return this;
    }

    public String getExecutorFullClassName() {
        return this.executorFullClassName;
    }

    public ExecutionStatus setExecutorFullClassName(String executorFullClassName) {
        this.executorFullClassName = executorFullClassName;
        return this;
    }

    public String getExecutorSimpleClassName() {
        return this.executorSimpleClassName;
    }

    public ExecutionStatus setExecutorSimpleClassName(String executorSimpleClassName) {
        this.executorSimpleClassName = executorSimpleClassName;
        return this;
    }

    public ExecutionStatus setExecutorClass(Class<?> executorClass) {
        this.setExecutorSimpleClassName(executorClass.getSimpleName());
        this.setExecutorFullClassName(executorClass.getName());
        return this;
    }

    public String getExecutorClassId() {
        return this.executorClassId;
    }

    public ExecutionStatus setExecutorClassId(String executorClassId) {
        this.executorClassId = executorClassId;
        return this;
    }

    public String getExecutorInstanceId() {
        return this.executorInstanceId;
    }

    public ExecutionStatus setExecutorInstanceId(String executorInstanceId) {
        this.executorInstanceId = executorInstanceId;
        return this;
    }

    public JsonObject getCustom() {
        return this.custom;
    }

    public String getCustomJsonString() {
        return this.custom == null ? null : Jsons.toPrettyString(this.custom);
    }

    public ExecutionStatus setCustom(JsonObject custom) {
        this.custom = custom;
        return this;
    }

    public Long getStartProcessingTimeStamp() {
        return this.startProcessingTimeStamp;
    }

    public ExecutionStatus setStartProcessingTimeStamp(Long startProcessingTimeStamp) {
        this.startProcessingTimeStamp = startProcessingTimeStamp;
        return this;
    }

    public ExecutionStatus setStartProcessingTimeStamp() {
        this.startProcessingTimeStamp = System.nanoTime();
        return this;
    }

    public boolean isClassInformationIncluded() {
        return this.classInformationIncluded;
    }

    public ExecutionStatus setClassInformationIncluded(boolean classInformationIncluded) {
        this.classInformationIncluded = classInformationIncluded;
        return this;
    }

    public List<ExecutionStatus> stack() {
        return this.stack(Integer.MAX_VALUE);
    }

    public List<ExecutionStatus> stack(int maxLength) {
        ArrayList<ExecutionStatus> stack = new ArrayList<ExecutionStatus>();
        int counter = 0;
        ExecutionStatus status = this;
        while (status != null) {
            if (++counter > 10000) {
                throw new IllegalStateException("Too large child nesting level of status hierarchy, probably infinite loop (starting from the parent \"" + this.toSingleLevelString(false) + "\")");
            }
            if (counter <= maxLength) {
                stack.add(status);
            }
            status = status.child;
        }
        return stack;
    }

    public String toSingleLevelString(boolean onlyMainInformation) {
        String message = ExecutionStatus.emptyToNull(this.message());
        String comment = ExecutionStatus.emptyToNull(this.comment());
        StringBuilder sb = new StringBuilder();
        if (this.classInformationIncluded && this.executorSimpleClassName != null) {
            sb.append(this.executorSimpleClassName);
            if (!this.executorSimpleClassName.isEmpty()) {
                sb.append(' ');
            }
            if (this.startProcessingTimeStamp != null) {
                long elapsedTime = System.nanoTime() - this.startProcessingTimeStamp;
                sb.append(elapsedTime < 100000000L ? String.format(Locale.US, "(%.2f ms)", (double)elapsedTime * 1.0E-6) : String.format(Locale.US, "(%.2f sec)", (double)elapsedTime * 1.0E-9));
            }
        }
        if (message != null) {
            if (sb.length() > 0) {
                sb.append(": ");
            }
            sb.append(message);
        }
        if (!onlyMainInformation && comment != null) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append("[").append(comment).append("]");
        }
        return sb.toString();
    }

    public String joinMessages() {
        return this.joinStack(this.stackPlusOne(), ExecutionStatus::hasMessage, status -> ExecutionStatus.nullToEmpty(status.message()));
    }

    public String joinComments() {
        return this.joinStack(this.stackPlusOne(), ExecutionStatus::hasComment, status -> ExecutionStatus.nullToEmpty(status.comment()));
    }

    public String joinAll(boolean onlyMainInformation) {
        return this.joinStack(this.stackPlusOne(), ExecutionStatus::isNonEmpty, status -> status.toSingleLevelString(onlyMainInformation));
    }

    public JsonObject toSingleLevelJson() {
        String comment;
        String message;
        JsonObjectBuilder builder = Json.createObjectBuilder();
        String owner = this.ownerName();
        if (owner != null) {
            builder.add("owner", owner);
        }
        if ((message = this.message()) != null) {
            builder.add("message", message);
        }
        if ((comment = this.comment()) != null) {
            builder.add("comment", comment);
        }
        if (this.executorFullClassName != null) {
            builder.add("executorFullClassName", this.executorFullClassName);
        }
        if (this.executorSimpleClassName != null) {
            builder.add("executorSimpleClassName", this.executorSimpleClassName);
        }
        if (this.executorClassId != null) {
            builder.add("executorClassId", this.executorClassId);
        }
        if (this.executorInstanceId != null) {
            builder.add("executorInstanceId", this.executorInstanceId);
        }
        if (this.startProcessingTimeStamp != null) {
            builder.add("startProcessingTimeStamp", this.startProcessingTimeStamp.longValue());
            builder.add("processingTimeInSeconds", (double)(System.nanoTime() - this.startProcessingTimeStamp) * 1.0E-9);
        }
        if (this.custom != null) {
            builder.add("custom", (JsonValue)this.custom);
        }
        return builder.build();
    }

    public JsonObject toJson() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
        for (ExecutionStatus status : this.stack()) {
            arrayBuilder.add((JsonValue)status.toSingleLevelJson());
        }
        builder.add("stack", (JsonValue)arrayBuilder.build());
        return builder.build();
    }

    public String toJsonString() {
        return Jsons.toPrettyString(this.toJson());
    }

    public String toString() {
        if (!this.opened) {
            return "<closed status>";
        }
        return this.joinAll(false);
    }

    void onOpen() {
    }

    void onClose() {
    }

    void onUpdate(boolean message, boolean comment) {
    }

    private void clearInformation() {
        this.message = null;
        this.comment = null;
    }

    private List<ExecutionStatus> stackPlusOne() {
        return this.stack(257);
    }

    private ExecutionStatus findRoot() {
        int counter = 0;
        ExecutionStatus status = this;
        while (status.parent != null) {
            if (++counter > 10000) {
                throw new IllegalStateException("Too large parent nesting level of status hierarchy, probably infinite loop (starting from the child \"" + this.toSingleLevelString(false) + "\")");
            }
            status = status.parent;
        }
        return status;
    }

    private String joinStack(List<ExecutionStatus> stack, Predicate<ExecutionStatus> included, Function<ExecutionStatus, String> statusToString) {
        if (!this.opened) {
            return "";
        }
        String result = stack.stream().limit(256L).filter(included).map(statusToString).collect(Collectors.joining(" / "));
        return stack.size() > 256 ? result + "..." : result;
    }

    private static String nullToEmpty(String s) {
        return s == null ? "" : s;
    }

    private static String emptyToNull(String s) {
        return s != null && s.isEmpty() ? null : s;
    }

    private static class LoggingExecutionStatus
    extends ExecutionStatus {
        private volatile boolean needToFinishStage = false;

        private LoggingExecutionStatus(Supplier<String> ownerName) {
            super(ownerName);
        }

        @Override
        void onOpen() {
            this.needToFinishStage = false;
        }

        @Override
        void onClose() {
            if (this.needToFinishStage) {
                DelayingLogger.INSTANCE.log(this::makeStatus, true);
                this.needToFinishStage = false;
            }
        }

        @Override
        void onUpdate(boolean message, boolean comment) {
            DelayingLogger.INSTANCE.log(this::makeStatus, false);
            if (message) {
                this.needToFinishStage = true;
            }
        }

        private String makeStatus() {
            ExecutionStatus root = this.root();
            assert (root != null);
            return LOGGING_STATUS_KIND == null ? root.toString() : LOGGING_STATUS_KIND.data(root);
        }
    }

    public static enum DataKind {
        FULL(1, status -> status.joinAll(false)),
        INFORMATION(2, status -> status.joinAll(true)),
        MESSAGES(3, ExecutionStatus::joinMessages),
        COMMENTS(4, ExecutionStatus::joinComments),
        JSON(-1, ExecutionStatus::toJsonString),
        CUSTOM_JSON(-2, ExecutionStatus::getCustomJsonString);

        private static final Map<Integer, DataKind> CODE_TO_KIND;
        private static final Map<String, DataKind> NAME_TO_KIND;
        private final int code;
        private final Function<ExecutionStatus, String> getter;

        private DataKind(int code, Function<ExecutionStatus, String> getter) {
            this.code = code;
            this.getter = getter;
        }

        public String data(ExecutionStatus status) {
            Objects.requireNonNull(status, "Null status");
            return this.getter.apply(status);
        }

        public int code() {
            return this.code;
        }

        public static DataKind ofOrNull(String name) {
            return NAME_TO_KIND.get(name);
        }

        public static DataKind ofOrNull(int code) {
            return CODE_TO_KIND.get(code);
        }

        public static DataKind of(int code) {
            DataKind result = DataKind.ofOrNull(code);
            if (result == null) {
                throw new IllegalArgumentException("Unknown status data code: " + code);
            }
            return result;
        }

        static {
            CODE_TO_KIND = Arrays.stream(DataKind.values()).collect(Collectors.toMap(DataKind::code, kind -> kind));
            NAME_TO_KIND = Arrays.stream(DataKind.values()).collect(Collectors.toMap(Enum::name, kind -> kind));
        }
    }

    private static class DelayingLogger {
        static final DelayingLogger INSTANCE = new DelayingLogger(LogLevel.of(LOGGING_STATUS_LEVEL));
        private final LogLevel level;
        private long lastTime = Long.MAX_VALUE;
        private String lastString = null;

        private DelayingLogger(LogLevel level) {
            this.level = Objects.requireNonNull(level);
        }

        public synchronized boolean log(Supplier<String> supplier, boolean forceFinishStage) {
            long last = this.lastTime;
            long t = System.nanoTime();
            boolean result = false;
            if (forceFinishStage || last == Long.MAX_VALUE || t - last > 500000000L) {
                String s = supplier.get();
                if (s != null && !s.isEmpty()) {
                    this.level.removeMessage(this.lastString);
                    this.level.log(s);
                    result = true;
                }
                this.lastString = s;
                this.lastTime = t;
                if (forceFinishStage) {
                    this.level.finishStage();
                }
            }
            return result;
        }
    }
}

